/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.spring.test.junit;

import com.tangosol.net.Coherence;
import com.tangosol.net.CoherenceConfiguration;
import com.tangosol.net.SessionConfiguration;
import io.github.classgraph.ClassGraph;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

public class CoherenceServerJunitExtension
implements ParameterResolver,
BeforeAllCallback,
AfterAllCallback {
    protected static final Log logger = LogFactory.getLog(CoherenceServerJunitExtension.class);
    private final String configUri;
    private Coherence coherence;

    public CoherenceServerJunitExtension() {
        this.configUri = "coherence-cache-config.xml";
    }

    public CoherenceServerJunitExtension(String configUri) {
        this.configUri = configUri;
    }

    public void afterAll(ExtensionContext context) {
        this.coherence.getCluster().shutdown();
        this.coherence.close();
        System.clearProperty("coherence.log");
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Shutting down Coherence complete.");
        }
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        System.setProperty("coherence.log", "slf4j");
        if (logger.isInfoEnabled()) {
            logger.info((Object)"JunitExtension - Starting up Coherence...");
        }
        SessionConfiguration.Builder sessionConfigurationBuilder = (SessionConfiguration.Builder)this.getFromTestClassloader(SessionConfiguration.class).getMethod("builder", new Class[0]).invoke(null, new Object[0]);
        SessionConfiguration sessionConfiguration = sessionConfigurationBuilder.withConfigUri(this.configUri).build();
        CoherenceConfiguration.Builder coherenceBuilder = (CoherenceConfiguration.Builder)this.getFromTestClassloader(CoherenceConfiguration.class).getMethod("builder", new Class[0]).invoke(null, new Object[0]);
        CoherenceConfiguration cfg = coherenceBuilder.withSessions(new SessionConfiguration[]{sessionConfiguration}).build();
        this.coherence = (Coherence)this.getFromTestClassloader(Coherence.class).getMethod("clusterMember", CoherenceConfiguration.class).invoke(null, cfg);
        this.coherence.start().join();
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.getParameter().getType().equals(Coherence.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return this.coherence;
    }

    private Class<?> getFromTestClassloader(Class<?> clazz) throws ClassNotFoundException {
        TestClassLoader testClassLoader = new TestClassLoader();
        return Class.forName(clazz.getName(), true, testClassLoader);
    }

    static class TestClassLoader
    extends URLClassLoader {
        TestClassLoader() {
            super(new ClassGraph().getClasspathURLs().toArray(new URL[0]));
        }
    }
}

