/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.spring.event;

import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.partitionedService.PartitionedCache;
import com.tangosol.coherence.component.util.safeService.SafeCacheService;
import com.tangosol.net.CacheService;
import com.tangosol.net.NamedMap;
import java.util.Map;

public final class EventsHelper {
    private EventsHelper() {
    }

    public static int getTotalListenerCount(NamedMap<?, ?> map) {
        PartitionedCache.Storage storage = EventsHelper.getStorage(map);
        return EventsHelper.getKeyListenerCount(storage) + EventsHelper.getListenerCount(storage);
    }

    public static int getListenerCount(NamedMap<?, ?> map) {
        PartitionedCache.Storage storage = EventsHelper.getStorage(map);
        return EventsHelper.getListenerCount(storage);
    }

    public static int getKeyListenerCount(NamedMap<?, ?> map) {
        PartitionedCache.Storage storage = EventsHelper.getStorage(map);
        return EventsHelper.getKeyListenerCount(storage);
    }

    private static int getListenerCount(PartitionedCache.Storage storage) {
        if (storage == null) {
            return 0;
        }
        Map map = storage.getListenerMap();
        return map != null ? map.size() : 0;
    }

    private static int getKeyListenerCount(PartitionedCache.Storage storage) {
        if (storage == null) {
            return 0;
        }
        Map map = storage.getKeyListenerMap();
        return map != null ? map.size() : 0;
    }

    private static PartitionedCache.Storage getStorage(NamedMap<?, ?> map) {
        CacheService service = map.getService();
        if (service instanceof SafeCacheService) {
            service = ((SafeCacheService)service).getRunningCacheService();
        }
        return service instanceof PartitionedCache ? ((PartitionedCache)service).getStorage(map.getName()) : null;
    }
}

