/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Calendar;
import oracle.pg.rdbms.pgql.PgqlConnection;
import oracle.pg.rdbms.pgql.PgqlPreparedStatement;
import oracle.pg.rdbms.pgql.PgqlResultSet;
import oracle.pg.rdbms.pgql.PgqlToSqlException;
import oracle.pg.rdbms.pgql.jdbc.PgqlJdbcHintClause;
import oracle.pg.rdbms.pgql.jdbc.PgqlJdbcRdbmsConnection;
import oracle.pg.rdbms.pgql.jdbc.PgqlJdbcRdbmsResultSet;
import oracle.pgql.lang.PgqlException;

public class PgqlJdbcRdbmsPreparedStatement
implements PreparedStatement {
    private static final int MAX_RESULTS = -1;
    private PgqlJdbcRdbmsConnection conn;
    private PgqlConnection pgqlConn;
    private PgqlPreparedStatement preparedStatement;
    private PgqlJdbcRdbmsResultSet currentResultSet;
    private int queryTimeout = 60;
    private final int parallelDop;
    private final int dynamicSamplingLevel;
    private final String options;
    private final String matchOptions;
    private static final int DEFAULT_TIMEOUT = 0;
    private static final int DEFAULT_MAX_RESULTS = -1;

    public PgqlJdbcRdbmsPreparedStatement(PgqlJdbcRdbmsConnection conn, String pgql, PgqlJdbcHintClause hintClause) throws SQLException {
        this.conn = conn;
        this.pgqlConn = conn.getPgqlConnection();
        this.parallelDop = hintClause.getParallelDop();
        this.dynamicSamplingLevel = hintClause.getDynamicSamplingLevel();
        this.matchOptions = hintClause.getMatchOptions();
        this.options = this.conn.getAutoCommit() ? "AUTO_COMMIT=T," + hintClause.getOptions() : "AUTO_COMMIT=F," + hintClause.getOptions();
        this.preparedStatement = this.pgqlConn.prepareStatement(pgql, 0, this.parallelDop, this.dynamicSamplingLevel, -1, this.matchOptions, this.options);
    }

    private void checkClosed() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("PreparedStatement is already closed");
        }
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.checkClosed();
        this.preparedStatement.setBoolean(parameterIndex, x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.checkClosed();
        this.preparedStatement.setInt(parameterIndex, x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.checkClosed();
        this.preparedStatement.setLong(parameterIndex, x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.checkClosed();
        this.preparedStatement.setFloat(parameterIndex, x);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.checkClosed();
        this.preparedStatement.setDouble(parameterIndex, x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.checkClosed();
        this.preparedStatement.setString(parameterIndex, x);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.checkClosed();
        try {
            this.preparedStatement.setDate(parameterIndex, x.toLocalDate());
        }
        catch (PgqlException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.checkClosed();
        try {
            this.preparedStatement.setTime(parameterIndex, x.toLocalTime());
        }
        catch (PgqlException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.checkClosed();
        this.preparedStatement.setTimestamp(parameterIndex, x);
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.execute();
        return this.currentResultSet;
    }

    @Override
    public boolean execute() throws SQLException {
        this.checkClosed();
        boolean returnBoolean = false;
        try {
            returnBoolean = this.preparedStatement.execute();
            if (this.currentResultSet != null) {
                this.currentResultSet.close();
                this.currentResultSet = null;
            }
            PgqlResultSet rs = this.preparedStatement.getResultSet();
            this.currentResultSet = new PgqlJdbcRdbmsResultSet(rs);
        }
        catch (PgqlToSqlException | PgqlException e) {
            throw new SQLException(e);
        }
        return returnBoolean;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        return this.currentResultSet.getMetaData();
    }

    @Override
    public void close() throws SQLException {
        try {
            if (this.preparedStatement != null) {
                this.preparedStatement.close();
                this.preparedStatement = null;
            }
            if (this.currentResultSet != null) {
                this.currentResultSet.close();
                this.currentResultSet = null;
            }
        }
        catch (PgqlException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkClosed();
        PgqlJdbcRdbmsResultSet rs = this.currentResultSet;
        this.currentResultSet = null;
        return rs;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.checkClosed();
        return (int)this.preparedStatement.getModifyCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.checkClosed();
        return this.currentResultSet != null;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1002;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkClosed();
        return this.preparedStatement.getFetchSize();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return 1004;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.conn;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return this.currentResultSet != null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.preparedStatement == null;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        switch (x.getClass().getName()) {
            case "java.time.LocalDateTime": {
                this.setTimestamp(parameterIndex, Timestamp.valueOf((LocalDateTime)x));
                break;
            }
            default: {
                throw new UnsupportedOperationException("void setObject(int parameterIndex, Object x) not yet supported");
            }
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkClosed();
        this.preparedStatement.setFetchSize(rows);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.queryTimeout = seconds;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        throw new UnsupportedOperationException("ResultSet executeQuery(String sql) not yet supported");
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        throw new UnsupportedOperationException("boolean executeQuery(String sql) not yet supported");
    }

    @Override
    public int executeUpdate() throws SQLException {
        throw new UnsupportedOperationException("int executeUpdate() not yet supported");
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        throw new UnsupportedOperationException("void setNull(int parameterIndex, int sqlType) not yet supported");
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        throw new UnsupportedOperationException("void setByte(int parameterIndex, byte x) not yet supported");
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        throw new UnsupportedOperationException("void setShort(int parameterIndex, short x) not yet supported");
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        throw new UnsupportedOperationException("void setBigDecimal(int parameterIndex, BigDecimal x) not yet supported");
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        throw new UnsupportedOperationException("void setBytes(int parameterIndex, byte[] x) not yet supported");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException("void setAsciiStream(int parameterIndex, InputStream x, int length) not yet supported");
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException("void setUnicodeStream(int parameterIndex, InputStream x, int length) not yet supported");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException("void setBinaryStream(int parameterIndex, InputStream x, int length) not yet supported");
    }

    @Override
    public void clearParameters() throws SQLException {
        throw new UnsupportedOperationException("void clearParameters() not yet supported");
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        throw new UnsupportedOperationException("void setObject(int parameterIndex, Object x, int targetSqlType) not yet supported");
    }

    @Override
    public void addBatch() throws SQLException {
        throw new UnsupportedOperationException("void addBatch() not yet supported");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        throw new UnsupportedOperationException("void setCharacterStream(int parameterIndex, Reader reader, int length) not yet supported");
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        throw new UnsupportedOperationException("void setRef(int parameterIndex, Ref x) not yet supported");
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        throw new UnsupportedOperationException("void setBlob(int parameterIndex, Blob x) not yet supported");
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        throw new UnsupportedOperationException("void setClob(int parameterIndex, Clob x) not yet supported");
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        throw new UnsupportedOperationException("void setArray(int parameterIndex, Array x) not yet supported");
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException("void setDate(int parameterIndex, Date x, Calendar cal)  not yet supported");
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException("void setTime(int parameterIndex, Time x, Calendar cal) not yet supported");
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException("void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) not yet supported");
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        throw new UnsupportedOperationException("void setNull(int parameterIndex, int sqlType, String typeName) not yet supported");
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw new UnsupportedOperationException("void setURL(int parameterIndex, URL x)  not yet supported");
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        throw new UnsupportedOperationException("ParameterMetaData getParameterMetaData() not yet supported");
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new UnsupportedOperationException("void setRowId(int parameterIndex, RowId x) not yet supported");
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        throw new UnsupportedOperationException("void setNString(int parameterIndex, String value) not yet supported");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw new UnsupportedOperationException("void setNCharacterStream(int parameterIndex, Reader value, long length) not yet supported");
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw new UnsupportedOperationException("void setNClob(int parameterIndex, NClob value) not yet supported");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("void setClob(int parameterIndex, Reader reader, long length) not yet supported");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw new UnsupportedOperationException("void setBlob(int parameterIndex, InputStream inputStream, long length) not yet supported");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("void setNClob(int parameterIndex, Reader reader, long length)  not yet supported");
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw new UnsupportedOperationException("void setSQLXML(int parameterIndex, SQLXML xmlObject) not yet supported");
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        throw new UnsupportedOperationException("void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) not yet supported");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException("void setAsciiStream(int parameterIndex, InputStream x, long length) not yet supported");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException("void setBinaryStream(int parameterIndex, InputStream x, long length) not yet supported");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("void setCharacterStream(int parameterIndex, Reader reader, long length) not yet supported");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        throw new UnsupportedOperationException("void setAsciiStream(int parameterIndex, InputStream x)  not yet supported");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        throw new UnsupportedOperationException("void setBinaryStream(int parameterIndex, InputStream x) not yet supported");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("void setCharacterStream(int parameterIndex, Reader reader) not yet supported");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw new UnsupportedOperationException("void setNCharacterStream(int parameterIndex, Reader value) not yet supported");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("void setClob(int parameterIndex, Reader reader)  not yet supported");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException("void setBlob(int parameterIndex, InputStream inputStream) not yet supported");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("void setNClob(int parameterIndex, Reader reader) not yet supported");
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        throw new UnsupportedOperationException("int executeUpdate(String sql) not yet supported");
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        throw new UnsupportedOperationException("int getMaxFieldSize() not yet supported");
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        throw new UnsupportedOperationException("void setMaxFieldSize(int max) not yet supported");
    }

    @Override
    public int getMaxRows() throws SQLException {
        throw new UnsupportedOperationException("int getMaxRows() not yet supported");
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        throw new UnsupportedOperationException("void setMaxRows(int max) not yet supported");
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        throw new UnsupportedOperationException("void setEscapeProcessing(boolean enable) not yet supported");
    }

    @Override
    public void cancel() throws SQLException {
        throw new UnsupportedOperationException("void cancel() not yet supported");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        throw new UnsupportedOperationException("SQLWarning getWarnings() not yet supported");
    }

    @Override
    public void clearWarnings() throws SQLException {
        throw new UnsupportedOperationException("void clearWarnings() not yet supported");
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw new UnsupportedOperationException("void setCursorName(String name) not yet supported");
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        throw new UnsupportedOperationException("void setFetchDirection(int direction) not yet supported");
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        throw new UnsupportedOperationException("int getResultSetConcurrency() not yet supported");
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw new UnsupportedOperationException("void addBatch(String sql) not yet supported");
    }

    @Override
    public void clearBatch() throws SQLException {
        throw new UnsupportedOperationException("void clearBatch() not yet supported");
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw new UnsupportedOperationException("int[] executeBatch() not yet supported");
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new UnsupportedOperationException("ResultSet getGeneratedKeys() not yet supported");
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedOperationException("int executeUpdate(String sql, int autoGeneratedKeys) not yet supported");
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException("int executeUpdate(String sql, int[] columnIndexes) not yet supported");
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException("int executeUpdate(String sql, String[] columnNames) not yet supported");
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedOperationException("boolean execute(String sql, int autoGeneratedKeys) not yet supported");
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException("boolean execute(String sql, int[] columnIndexes) not yet supported");
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException("boolean execute(String sql, String[] columnNames) not yet supported");
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new UnsupportedOperationException("int getResultSetHoldability() not yet supported");
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        throw new UnsupportedOperationException("void setPoolable(boolean poolable) not yet supported");
    }

    @Override
    public boolean isPoolable() throws SQLException {
        throw new UnsupportedOperationException("boolean isPoolable() not yet supported");
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new UnsupportedOperationException("void closeOnCompletion() not yet supported");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("<T> T unwrap(Class<T> iface) not yet supported");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException("boolean isWrapperFor(Class<?> iface) not yet supported");
    }
}

