/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import oracle.pg.rdbms.pgql.PgqlResultSet;
import oracle.pg.rdbms.pgql.PgqlResultSetMetaDataImpl;
import oracle.pgql.lang.PgqlException;

public class PgqlJdbcRdbmsResultSetMetaData
implements ResultSetMetaData {
    private PgqlResultSetMetaDataImpl meta;
    private int columnCount = 0;
    private int[] columnTypeList;
    private static final Map<Integer, Integer> PGTYPE_TO_SQL_TYPES = new HashMap<Integer, Integer>();
    private static final Map<Integer, Class<?>> PGTYPE_TO_CLASS = new HashMap();
    private static final Map<Integer, String> PGTYPE_TO_NAME = new HashMap<Integer, String>();

    public PgqlJdbcRdbmsResultSetMetaData(PgqlResultSet rs) throws PgqlException {
        this.meta = (PgqlResultSetMetaDataImpl)rs.getMetaData();
        this.columnCount = this.meta.getColumnCount();
        this.columnTypeList = new int[this.columnCount];
        if (rs.next()) {
            for (int i = 0; i < this.columnCount; ++i) {
                this.columnTypeList[i] = rs.getValueType(i + 1);
            }
        }
        rs.beforeFirst();
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.columnCount;
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return 0;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return false;
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return 0;
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.meta.getColumnName(column);
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.getColumnLabel(column);
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        this.checkOutBoundIndex(column);
        int t = this.columnTypeList[column - 1];
        if (PGTYPE_TO_SQL_TYPES.containsKey(t)) {
            return PGTYPE_TO_SQL_TYPES.get(t);
        }
        return 2000;
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        this.checkOutBoundIndex(column);
        int t = this.columnTypeList[column - 1];
        if (PGTYPE_TO_CLASS.containsKey(t)) {
            return PGTYPE_TO_CLASS.get(t).getName();
        }
        return Object.class.getName();
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        this.checkOutBoundIndex(column);
        int t = this.columnTypeList[column - 1];
        if (PGTYPE_TO_NAME.containsKey(t)) {
            return PGTYPE_TO_NAME.get(t);
        }
        return "object";
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    private void checkOutBoundIndex(int column) throws SQLException {
        if (column > this.columnCount) {
            throw new SQLException(String.format("column: %d index out of bounds", column));
        }
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        throw new UnsupportedOperationException("String getSchemaName(int column) not yet implemented");
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        throw new UnsupportedOperationException("int getPrecision(int column) not yet implemented");
    }

    @Override
    public int getScale(int column) throws SQLException {
        throw new UnsupportedOperationException("int getScale(int column) not yet implemented");
    }

    @Override
    public String getTableName(int column) throws SQLException {
        throw new UnsupportedOperationException("String getTableName(int column) not yet implemented");
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        throw new UnsupportedOperationException("String getCatalogName(int column) not yet implemented");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("<T> T unwrap(Class<T> iface) not yet implemented");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException("boolean isWrapperFor(Class<?> iface) not yet implemented");
    }

    static {
        PGTYPE_TO_SQL_TYPES.put(7, -5);
        PGTYPE_TO_SQL_TYPES.put(1, 12);
        PGTYPE_TO_SQL_TYPES.put(4, 8);
        PGTYPE_TO_SQL_TYPES.put(3, 6);
        PGTYPE_TO_SQL_TYPES.put(2, 4);
        PGTYPE_TO_SQL_TYPES.put(6, 16);
        PGTYPE_TO_SQL_TYPES.put(10, 1);
        PGTYPE_TO_SQL_TYPES.put(8, -6);
        PGTYPE_TO_SQL_TYPES.put(5, 93);
        PGTYPE_TO_CLASS.put(7, Long.class);
        PGTYPE_TO_CLASS.put(1, String.class);
        PGTYPE_TO_CLASS.put(4, Double.class);
        PGTYPE_TO_CLASS.put(3, Float.class);
        PGTYPE_TO_CLASS.put(2, Integer.class);
        PGTYPE_TO_CLASS.put(6, Boolean.class);
        PGTYPE_TO_CLASS.put(10, Character.class);
        PGTYPE_TO_CLASS.put(8, Short.class);
        PGTYPE_TO_CLASS.put(5, Timestamp.class);
        PGTYPE_TO_NAME.put(7, "long");
        PGTYPE_TO_NAME.put(1, "string");
        PGTYPE_TO_NAME.put(4, "double");
        PGTYPE_TO_NAME.put(3, "float");
        PGTYPE_TO_NAME.put(2, "integer");
        PGTYPE_TO_NAME.put(6, "boolean");
        PGTYPE_TO_NAME.put(10, "char");
        PGTYPE_TO_NAME.put(8, "short");
        PGTYPE_TO_NAME.put(5, "date");
    }
}

