/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql;

import oracle.pg.rdbms.pgql.PgqlColumnDescriptor;

public class PgqlColumnDescriptorImpl
implements PgqlColumnDescriptor {
    private final String colName;
    private final PgqlColumnDescriptor.Type colType;
    private final int offset;

    public PgqlColumnDescriptorImpl(String colName, PgqlColumnDescriptor.Type colType, int offset) {
        this.colName = colName;
        this.colType = colType;
        this.offset = offset;
    }

    @Override
    public String getColName() {
        return this.colName;
    }

    @Override
    public PgqlColumnDescriptor.Type getColType() {
        return this.colType;
    }

    @Override
    public int getSqlOffset() {
        return this.offset;
    }

    public String toString() {
        String readableType = "";
        switch (this.colType) {
            case VERTEX: {
                readableType = "VERTEX";
                break;
            }
            case EDGE: {
                readableType = "EDGE";
                break;
            }
            case VALUE: {
                readableType = "VALUE";
            }
        }
        return "colName=[" + this.colName + "] colType=[" + readableType + "] offset=[" + this.offset + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PgqlColumnDescriptorImpl c = (PgqlColumnDescriptorImpl)o;
        if (c.getColName() != null && this.getColName() == null) {
            return false;
        }
        if (c.getColName() == null && this.getColName() != null) {
            return false;
        }
        if (c.getColName() != null && this.getColName() != null && !c.getColName().equals(this.getColName())) {
            return false;
        }
        return c.getColType() == this.getColType() && c.getSqlOffset() == this.getSqlOffset();
    }

    public int hashCode() {
        PgqlColumnDescriptor.Type t = this.getColType();
        int tInt = 0;
        switch (t) {
            case VERTEX: {
                tInt = 1;
                break;
            }
            case EDGE: {
                tInt = 2;
                break;
            }
            default: {
                tInt = 3;
            }
        }
        int hc = 31 * tInt;
        hc += 31 * this.getSqlOffset();
        if (this.getColName() != null) {
            hc ^= this.getColName().hashCode();
        }
        return hc;
    }
}

