/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql.pgview.metadata;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import oracle.pg.rdbms.pgql.PgqlToSqlException;
import oracle.pg.rdbms.pgql.pgview.metadata.MetadataRefreshTimes;
import oracle.pg.rdbms.pgql.pgview.util.Pair;

public abstract class Cache<V> {
    private static final int MAX_CAPACITY = 1000;
    private static final long REFRESH_INTERVAL = 1000L;
    private static final String LAST_DDL_TIME_QUERY = "SELECT TO_CHAR(LAST_DDL_TIME, 'DD-MM-YYYY HH24:MI:SS') as last_ddl\nFROM SYS.ALL_OBJECTS WHERE owner = ? AND object_name = ? AND object_type = 'TABLE'";
    private final LinkedHashMap<CacheKey, Pair<V, MetadataRefreshTimes>> cache = new LinkedHashMap<CacheKey, Pair<V, MetadataRefreshTimes>>(1000){

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > Cache.this.maxCapacity;
        }
    };
    private boolean isEnabled = true;
    private int maxCapacity = 1000;
    private long refreshInterval = 1000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<V, MetadataRefreshTimes> get(Connection conn, boolean syncCache, String ... keyComponents) {
        CacheKey key = new CacheKey(keyComponents);
        LinkedHashMap<CacheKey, Pair<V, MetadataRefreshTimes>> linkedHashMap = this.cache;
        synchronized (linkedHashMap) {
            if (this.isEnabled && this.cache.containsKey(key) && (!syncCache || this.isCacheRefreshed(conn, keyComponents))) {
                return this.cache.get(key);
            }
            Pair<V, MetadataRefreshTimes> value = this.buildValue(conn, keyComponents);
            if (this.isEnabled && value != null) {
                this.cache.put(key, value);
            }
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheValue(String[] keyComponents, V value, MetadataRefreshTimes metadataRefreshTimes) {
        CacheKey key = new CacheKey(keyComponents);
        LinkedHashMap<CacheKey, Pair<V, MetadataRefreshTimes>> linkedHashMap = this.cache;
        synchronized (linkedHashMap) {
            if (this.isEnabled) {
                this.cache.put(key, new Pair<V, MetadataRefreshTimes>(value, metadataRefreshTimes));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEntry(String ... keyComponents) {
        CacheKey key = new CacheKey(keyComponents);
        LinkedHashMap<CacheKey, Pair<V, MetadataRefreshTimes>> linkedHashMap = this.cache;
        synchronized (linkedHashMap) {
            this.cache.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(String ... keyComponents) {
        CacheKey key = new CacheKey(keyComponents);
        LinkedHashMap<CacheKey, Pair<V, MetadataRefreshTimes>> linkedHashMap = this.cache;
        synchronized (linkedHashMap) {
            if (this.isEnabled) {
                return this.cache.containsKey(key);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxCapacity(int maxCapacity) {
        if (maxCapacity < 1) {
            throw new PgqlToSqlException("Max capacity should be a positive number");
        }
        LinkedHashMap<CacheKey, Pair<V, MetadataRefreshTimes>> linkedHashMap = this.cache;
        synchronized (linkedHashMap) {
            this.maxCapacity = maxCapacity;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRefreshInterval(long interval) {
        if (interval < 1L) {
            throw new PgqlToSqlException("Delay should be a positive number");
        }
        LinkedHashMap<CacheKey, Pair<V, MetadataRefreshTimes>> linkedHashMap = this.cache;
        synchronized (linkedHashMap) {
            this.refreshInterval = interval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        LinkedHashMap<CacheKey, Pair<V, MetadataRefreshTimes>> linkedHashMap = this.cache;
        synchronized (linkedHashMap) {
            this.cache.clear();
        }
    }

    public void enable() {
        this.isEnabled = true;
    }

    public void disable() {
        this.isEnabled = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetadataRefreshTimes getTimestampLastRefreshed(String ... keyComponents) {
        Pair<V, MetadataRefreshTimes> pair;
        CacheKey key = new CacheKey(keyComponents);
        LinkedHashMap<CacheKey, Pair<V, MetadataRefreshTimes>> linkedHashMap = this.cache;
        synchronized (linkedHashMap) {
            pair = this.cache.get(key);
        }
        return pair == null ? null : (MetadataRefreshTimes)pair.second;
    }

    Pair<V, MetadataRefreshTimes> buildValue(Connection conn, String ... valueParameters) {
        return null;
    }

    public boolean isCacheRefreshed(Connection conn, String ... keyComponents) {
        MetadataRefreshTimes metadataRefreshTimes = this.getTimestampLastRefreshed(keyComponents);
        if (metadataRefreshTimes == null) {
            return true;
        }
        return this.isRefreshed(conn, keyComponents[0], keyComponents[1], metadataRefreshTimes);
    }

    public boolean isRefreshed(Connection conn, String schema, String graphname, MetadataRefreshTimes metadataRefreshTimes) {
        Instant dbInstantDateTime;
        Instant localInstantDateTime = metadataRefreshTimes.getTimeOfCheckOfLastMetadataChange();
        if (Instant.now().minusMillis(this.refreshInterval).isBefore(localInstantDateTime)) {
            return true;
        }
        Instant lastDdlDateTimeInstant = this.getLastDdlDateTime(conn, schema, graphname);
        return !lastDdlDateTimeInstant.isAfter(dbInstantDateTime = metadataRefreshTimes.getTimeOfLastMetadataChange());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Instant getLastDdlDateTime(Connection conn, String schema, String graphname) {
        try (PreparedStatement stmt = conn.prepareStatement(LAST_DDL_TIME_QUERY);){
            stmt.setString(1, schema);
            stmt.setString(2, graphname + "_ELEM_TABLE$");
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                String lastDdlTime = rs.getString(1);
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd-MM-yyyy HH:mm:ss");
                Instant instant = LocalDateTime.parse(lastDdlTime, formatter).toInstant(ZoneOffset.UTC);
                return instant;
            }
            Instant instant = Instant.MIN;
            return instant;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    static class CacheKey {
        String[] keyComponents;

        public CacheKey(String ... keyComponents) {
            this.keyComponents = keyComponents;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey that = (CacheKey)o;
            if (this.keyComponents == null) {
                return that.keyComponents == null;
            }
            if (that.keyComponents == null) {
                return false;
            }
            if (this.keyComponents.length != that.keyComponents.length) {
                return false;
            }
            for (int i = 0; i < this.keyComponents.length; ++i) {
                if (Objects.equals(this.keyComponents[i], that.keyComponents[i])) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return Objects.hash(this.keyComponents);
        }
    }
}

