/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import oracle.pgx.api.AllPaths;
import oracle.pgx.api.BipartiteGraph;
import oracle.pgx.api.EdgeLabel;
import oracle.pgx.api.EdgeProperty;
import oracle.pgx.api.EdgeSequence;
import oracle.pgx.api.EdgeSet;
import oracle.pgx.api.GraphChangeSet;
import oracle.pgx.api.GraphChangeSetImpl;
import oracle.pgx.api.GraphMetaData;
import oracle.pgx.api.MergingStrategyBuilder;
import oracle.pgx.api.Namespace;
import oracle.pgx.api.Operation;
import oracle.pgx.api.Partition;
import oracle.pgx.api.PartitionizingStrategyBuilder;
import oracle.pgx.api.PgqlResultSet;
import oracle.pgx.api.PgxCollection;
import oracle.pgx.api.PgxEdge;
import oracle.pgx.api.PgxEntity;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxManagedObject;
import oracle.pgx.api.PgxMap;
import oracle.pgx.api.PgxPath;
import oracle.pgx.api.PgxPreparedStatement;
import oracle.pgx.api.PgxSession;
import oracle.pgx.api.PgxVect;
import oracle.pgx.api.PgxVertex;
import oracle.pgx.api.PickingStrategyBuilder;
import oracle.pgx.api.Scalar;
import oracle.pgx.api.ServerInstance;
import oracle.pgx.api.SessionContext;
import oracle.pgx.api.Synchronizer;
import oracle.pgx.api.VertexLabels;
import oracle.pgx.api.VertexProperty;
import oracle.pgx.api.VertexSequence;
import oracle.pgx.api.VertexSet;
import oracle.pgx.api.beta.annotation.BetaApi;
import oracle.pgx.api.expansion.GenericGraphExpander;
import oracle.pgx.api.expansion.internal.GraphExpansionConfig;
import oracle.pgx.api.filter.EdgeFilter;
import oracle.pgx.api.filter.GraphFilter;
import oracle.pgx.api.filter.VertexFilter;
import oracle.pgx.api.graphalteration.GraphAlterationBuilder;
import oracle.pgx.api.graphalteration.internal.GraphAlterationBuilderImpl;
import oracle.pgx.api.internal.AllPathsProxy;
import oracle.pgx.api.internal.ComponentsProxy;
import oracle.pgx.api.internal.Core;
import oracle.pgx.api.internal.CoreGraphPersistenceApi;
import oracle.pgx.api.internal.Edge;
import oracle.pgx.api.internal.EntityTable;
import oracle.pgx.api.internal.Graph;
import oracle.pgx.api.internal.GraphConfigGenerationHelper;
import oracle.pgx.api.internal.PartitionedGraphConfigGenerationContext;
import oracle.pgx.api.internal.PathProxy;
import oracle.pgx.api.internal.PgqlResultSetImpl;
import oracle.pgx.api.internal.PgqlResultSetProxy;
import oracle.pgx.api.internal.PgxPreparedStatementImpl;
import oracle.pgx.api.internal.PreparedStatementProxy;
import oracle.pgx.api.internal.Property;
import oracle.pgx.api.internal.Vertex;
import oracle.pgx.api.subgraph.internal.KeystoreLookup;
import oracle.pgx.common.Pair;
import oracle.pgx.common.PgxId;
import oracle.pgx.common.auth.PgxResourcePermission;
import oracle.pgx.common.auth.PgxRole;
import oracle.pgx.common.auth.PgxUser;
import oracle.pgx.common.mutations.EdgeStrategy;
import oracle.pgx.common.mutations.MutationStrategy;
import oracle.pgx.common.mutations.PartitionizingStrategy;
import oracle.pgx.common.pojo.CollectionInfo;
import oracle.pgx.common.types.AuthorizationType;
import oracle.pgx.common.types.CollectionType;
import oracle.pgx.common.types.EntityType;
import oracle.pgx.common.types.IdStrategy;
import oracle.pgx.common.types.IdType;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.util.ConversionHelper;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.AbstractFileGraphConfig;
import oracle.pgx.config.EntityProviderConfig;
import oracle.pgx.config.FileEntityProviderConfig;
import oracle.pgx.config.FileGraphConfig;
import oracle.pgx.config.FileGraphConfigBuilder;
import oracle.pgx.config.FileGraphStoringConfig;
import oracle.pgx.config.FileGraphStoringConfigBuilder;
import oracle.pgx.config.Format;
import oracle.pgx.config.GraphBuilderConfig;
import oracle.pgx.config.GraphConfig;
import oracle.pgx.config.GraphConfigBuilder;
import oracle.pgx.config.IdGenerationStrategy;
import oracle.pgx.config.OnInvalidChange;
import oracle.pgx.config.PartitionedGraphConfig;
import oracle.pgx.config.PgxRedactionRuleConfig;
import oracle.pgx.config.ProviderFormat;
import oracle.pgx.config.TwoTablesTextGraphConfig;
import oracle.pgx.config.TwoTablesTextGraphConfigBuilder;
import oracle.pgx.config.internal.ConfigUtils;
import oracle.pgx.config.internal.PgqlOption;
import org.apache.commons.io.FilenameUtils;

public class PgxGraph
extends PgxManagedObject
implements Cloneable {
    private static final String GENERATE_NAME = null;
    private final ServerInstance instance;
    private final PgxSession session;
    private final Core core;
    private final AtomicReference<String> graphName;
    private final AtomicReference<PgxId> graphId;
    private final AtomicBoolean transientFlag;
    private final AtomicReference<GraphMetaData> metaData;

    PgxGraph(PgxSession session, Graph gr) {
        this.instance = session.getServerInstance();
        this.session = session;
        this.core = session.getCore();
        this.graphName = new AtomicReference<String>(gr.getGraphName());
        this.graphId = new AtomicReference<PgxId>(gr.getGraphId());
        this.transientFlag = new AtomicBoolean(gr.isTransient());
        this.metaData = new AtomicReference<GraphMetaData>(gr.getMetaData());
    }

    public final PgxId getId() {
        return this.graphId.get();
    }

    final void setId(PgxId id) {
        this.graphId.set(id);
    }

    boolean isHomogeneous() {
        return this.metaData.get().isNonPartitioned();
    }

    public GraphMetaData getMetaData() {
        return new GraphMetaData(this.metaData.get());
    }

    void setMetaData(GraphMetaData metaData) {
        this.metaData.set(metaData);
    }

    public ServerInstance getPgxInstance() {
        return this.instance;
    }

    public PgxSession getSession() {
        return this.session;
    }

    @Override
    public String getName() {
        return this.graphName.get();
    }

    public boolean isTransient() {
        return this.transientFlag.get();
    }

    void setTransient(boolean isTransient) {
        this.transientFlag.set(isTransient);
    }

    public long getNumVertices() {
        return this.metaData.get().getNumVertices();
    }

    public long getNumEdges() {
        return this.metaData.get().getNumEdges();
    }

    public long getMemoryMb() {
        return this.metaData.get().getMemoryMb();
    }

    public String getDataSourceVersion() {
        return this.metaData.get().getDataSourceVersion();
    }

    public GraphConfig getConfig() {
        return ConfigUtils.createGraphConfigWithoutCredentials((GraphConfig)this.metaData.get().getConfig());
    }

    public long getCreationRequestTimestamp() {
        return this.metaData.get().getCreationRequestTimestamp();
    }

    public long getCreationTimestamp() {
        return this.metaData.get().getCreationTimestamp();
    }

    public IdStrategy getVertexIdStrategy() {
        return this.metaData.get().getVertexIdStrategy();
    }

    public IdType getVertexIdType() {
        IdStrategy vertexIdStrategy = this.getVertexIdStrategy();
        if (vertexIdStrategy == null || vertexIdStrategy == IdStrategy.NO_IDS) {
            return null;
        }
        return this.metaData.get().getVertexIdType();
    }

    public IdStrategy getEdgeIdStrategy() {
        return this.metaData.get().getEdgeIdStrategy();
    }

    IdType getEdgeIdType() {
        IdStrategy edgeIdStrategy = this.getEdgeIdStrategy();
        if (edgeIdStrategy == null || edgeIdStrategy == IdStrategy.NO_IDS) {
            return null;
        }
        return this.metaData.get().getEdgeIdType();
    }

    public void addRedactionRule(PgxRedactionRuleConfig ruleConfig, AuthorizationType type, String ... names) {
        this.addRedactionRuleAsync(ruleConfig, type, names).join();
    }

    public PgxFuture<Void> addRedactionRuleAsync(PgxRedactionRuleConfig ruleConfig, AuthorizationType type, String ... names) {
        return this.core.addRedactionRule(this.getSessionContext(), this.getId(), ruleConfig, type, names);
    }

    public void removeRedactionRule(PgxRedactionRuleConfig ruleConfig, AuthorizationType type, String ... names) {
        this.removeRedactionRuleAsync(ruleConfig, type, names).join();
    }

    public PgxFuture<Void> removeRedactionRuleAsync(PgxRedactionRuleConfig ruleConfig, AuthorizationType type, String ... names) {
        return this.core.removeRedactionRule(this.getSessionContext(), this.getId(), ruleConfig, type, names);
    }

    public List<PgxRedactionRuleConfig> getRedactionRules(AuthorizationType type, String name) {
        return this.getRedactionRulesAsync(type, name).join();
    }

    public PgxFuture<List<PgxRedactionRuleConfig>> getRedactionRulesAsync(AuthorizationType type, String name) {
        return this.core.getRedactionRules(this.getSessionContext(), this.getId(), type, name);
    }

    public <ID extends Comparable<ID>> GraphChangeSet<ID> createChangeSet() {
        return this.createChangeSet(IdGenerationStrategy.USER_IDS, IdGenerationStrategy.AUTO_GENERATED);
    }

    public <ID extends Comparable<ID>> GraphChangeSet<ID> createChangeSet(IdGenerationStrategy vertexIdGenerationStrategy, IdGenerationStrategy edgeIdGenerationStrategy) {
        this.throwIfNoIds();
        GraphChangeSetImpl graphChangeSet = new GraphChangeSetImpl(this);
        graphChangeSet.setConfigParameter(GraphBuilderConfig.Field.VERTEX_ID_GENERATION_STRATEGY, vertexIdGenerationStrategy);
        graphChangeSet.setConfigParameter(GraphBuilderConfig.Field.EDGE_ID_GENERATION_STRATEGY, edgeIdGenerationStrategy);
        return graphChangeSet;
    }

    public GraphAlterationBuilder alterGraph() {
        return new GraphAlterationBuilderImpl(this.core, this.session, this.session.getKeystorePath(), this.session.getKeystorePassword(), this, PgxGraph::new);
    }

    @BetaApi
    public GenericGraphExpander expandGraph() {
        GraphMetaData graphMetaData = this.metaData.get();
        if (graphMetaData.isNonPartitioned()) {
            throw new UnsupportedOperationException(ErrorMessages.getMessage((String)"UNSUPPORTED_OP_ON_NON_PARTITIONED_GRAPH", (Object[])new Object[0]));
        }
        GraphConfig config = graphMetaData.getConfig();
        if (config != null && !(config instanceof PartitionedGraphConfig)) {
            throw new UnsupportedOperationException(ErrorMessages.getMessage((String)"EXPECTED_PARTITIONED_GRAPH_CONFIG", (Object[])new Object[0]));
        }
        return new GenericGraphExpander((PartitionedGraphConfig)config, this.session, expConfig -> this.core.expandGraph(this.getSessionContext(), this.getId(), (GraphExpansionConfig)expConfig).thenApply(g -> new PgxGraph(this.session, (Graph)((Object)((Object)g)))), KeystoreLookup.forKeystoreProvider(this.session::getKeystorePath, this.session::getKeystorePassword));
    }

    public <ID> PgxFuture<PgxVertex<ID>> getVertexAsync(ID id) {
        if (id == null) {
            return PgxFuture.exceptionallyCompletedFuture(new IllegalArgumentException(ErrorMessages.getMessage((String)"NODE_KEY_NULL", (Object[])new Object[0])));
        }
        if (this.getVertexIdType() != null && id.getClass() != this.getVertexIdType().getTypeClass()) {
            return PgxFuture.exceptionallyCompletedFuture(new IllegalArgumentException(ErrorMessages.getMessage((String)"NODE_ID_UNEXPECTED_TYPE", (Object[])new Object[]{this.getVertexIdType().getTypeClass(), id.getClass()})));
        }
        return this.core.getEntity(this.getSessionContext(), this.getId(), EntityType.VERTEX, this.getVertexIdType(), id).thenApply(vertex -> new PgxVertex<Vertex>(this, (Vertex)vertex));
    }

    public <ID> PgxFuture<Boolean> hasVertexAsync(ID id) {
        return this.core.exists(this.getSessionContext(), this.getId(), EntityType.VERTEX, this.getVertexIdType(), id);
    }

    public PgxFuture<PgxEdge> getEdgeAsync(long id) {
        return this.core.getEntity(this.getSessionContext(), this.getId(), EntityType.EDGE, IdType.LONG, id).thenApply(edge -> new PgxEdge(this, (Edge)edge));
    }

    public PgxFuture<PgxEdge> getEdgeAsync(String id) {
        return this.core.getEntity(this.getSessionContext(), this.getId(), EntityType.EDGE, IdType.STRING, id).thenApply(edge -> new PgxEdge(this, (Edge)edge));
    }

    public PgxFuture<Boolean> hasEdgeAsync(long id) {
        return this.core.exists(this.getSessionContext(), this.getId(), EntityType.EDGE, IdType.LONG, id);
    }

    public PgxFuture<Boolean> hasEdgeAsync(String id) {
        return this.core.exists(this.getSessionContext(), this.getId(), EntityType.EDGE, IdType.STRING, id);
    }

    public <ID> PgxFuture<PgxVertex<ID>> getRandomVertexAsync() {
        return this.core.getRandomEntity(this.getSessionContext(), this.getId(), EntityType.VERTEX).thenApply(vertex -> new PgxVertex<Vertex>(this, (Vertex)vertex));
    }

    public PgxFuture<PgxEdge> getRandomEdgeAsync() {
        return this.core.getRandomEntity(this.getSessionContext(), this.getId(), EntityType.EDGE).thenApply(edge -> new PgxEdge(this, (Edge)edge));
    }

    public PgxFuture<Boolean> hasVertexLabelsAsync() {
        GraphConfig config = this.getConfig();
        if (config != null) {
            if (config instanceof PartitionedGraphConfig) {
                PartitionedGraphConfig relationalConfig = (PartitionedGraphConfig)config;
                return PgxFuture.completedFuture(!relationalConfig.getVertexProviders().isEmpty());
            }
            return PgxFuture.completedFuture(config.isVertexLabelsLoadingEnabled());
        }
        return this.core.getGraphResult(this.getSessionContext(), this.getId()).thenApply(gr -> gr.hasVertexLabels());
    }

    public <ID> PgxFuture<VertexLabels<ID>> getVertexLabelsAsync() {
        return this.core.getGraphResult(this.getSessionContext(), this.getId()).thenApply(gr -> {
            Property pr = gr.getVertexLabels();
            if (pr == null) {
                throw new IllegalStateException(ErrorMessages.getMessage((String)"VERTEX_LABELS_NOT_EXIST", (Object[])new Object[0]));
            }
            return new VertexLabels(this, pr);
        });
    }

    public PgxFuture<Boolean> hasEdgeLabelAsync() {
        GraphConfig config = this.getConfig();
        if (config != null) {
            if (config instanceof PartitionedGraphConfig) {
                PartitionedGraphConfig relationalConfig = (PartitionedGraphConfig)config;
                return PgxFuture.completedFuture(!relationalConfig.getEdgeProviders().isEmpty());
            }
            return PgxFuture.completedFuture(config.isEdgeLabelLoadingEnabled());
        }
        return this.core.getGraphResult(this.getSessionContext(), this.getId()).thenApply(gr -> gr.hasEdgeLabel());
    }

    public PgxFuture<EdgeLabel> getEdgeLabelAsync() {
        return this.core.getGraphResult(this.getSessionContext(), this.getId()).thenApply(gr -> {
            Property pr = gr.getEdgeLabel();
            if (pr == null) {
                throw new IllegalStateException(ErrorMessages.getMessage((String)"EDGE_LABEL_NOT_EXISTS", (Object[])new Object[0]));
            }
            return new EdgeLabel(this, pr);
        });
    }

    public PgxFuture<Set<VertexProperty<?, ?>>> getVertexPropertiesAsync() {
        return this.core.getGraphResult(this.getSessionContext(), this.getId()).thenApply(gr -> {
            HashSet set = new HashSet();
            for (Property pr : gr.getAllVertexProperties()) {
                set.add(new VertexProperty(this, pr));
            }
            return set;
        });
    }

    public PgxFuture<Set<EdgeProperty<?>>> getEdgePropertiesAsync() {
        return this.core.getGraphResult(this.getSessionContext(), this.getId()).thenApply(gr -> {
            HashSet set = new HashSet();
            for (Property pr : gr.getAllEdgeProperties()) {
                set.add(new EdgeProperty(this, pr));
            }
            return set;
        });
    }

    public <ID, V> PgxFuture<VertexProperty<ID, V>> getVertexPropertyAsync(String name) {
        return this.getVertexPropertyAsync(null, name);
    }

    public <V> PgxFuture<EdgeProperty<V>> getEdgePropertyAsync(String name) {
        return this.getEdgePropertyAsync(null, name);
    }

    public <ID, V> PgxFuture<VertexProperty<ID, V>> getVertexPropertyAsync(Namespace namespace, String name) {
        return this.core.getGraphResult(this.getSessionContext(), this.getId()).thenApply(graph -> this.getAndCreateProperty(graph::getVertexProperty, VertexProperty::new, namespace, name));
    }

    public <V> PgxFuture<EdgeProperty<V>> getEdgePropertyAsync(Namespace namespace, String name) {
        return this.core.getGraphResult(this.getSessionContext(), this.getId()).thenApply(graph -> this.getAndCreateProperty(graph::getEdgeProperty, EdgeProperty::new, namespace, name));
    }

    private <ID, K extends PgxEntity<ID>, V, P extends oracle.pgx.api.Property<ID, K, V>> P getAndCreateProperty(BiFunction<Namespace, String, Property> propertyGetter, BiFunction<PgxGraph, Property, P> propertyConstructor, @Nullable Namespace namespace, String name) {
        Property property = propertyGetter.apply(namespace, name);
        if (property == null) {
            return null;
        }
        return (P)((oracle.pgx.api.Property)propertyConstructor.apply(this, property));
    }

    public PgxFuture<FileGraphConfig> storeAsync(Format targetFormat, String targetPath) {
        return this.storeAsync(targetFormat, targetPath, false);
    }

    public PgxFuture<PartitionedGraphConfig> storeAsync(ProviderFormat targetFormat, String targetBasePath) {
        return this.storeAsync(targetFormat, targetBasePath, false);
    }

    public PgxFuture<PartitionedGraphConfig> storeAsync(ProviderFormat targetFormat, String targetBasePath, Set<String> vertexProvidersToStore, Set<String> edgeProvidersToStore) {
        return this.storeAsync(targetFormat, targetBasePath, vertexProvidersToStore, edgeProvidersToStore, false);
    }

    public PgxFuture<FileGraphConfig> storeAsync(Format targetFormat, String targetPath, boolean overwrite) {
        return this.storeAsync(targetFormat, targetPath, VertexProperty.ALL, EdgeProperty.ALL, overwrite);
    }

    public PgxFuture<PartitionedGraphConfig> storeAsync(ProviderFormat targetFormat, String targetBasePath, boolean overwrite) {
        return this.storeAsync(targetFormat, targetBasePath, (Collection<VertexProperty<?, ?>>)VertexProperty.ALL, (Collection<EdgeProperty<?>>)EdgeProperty.ALL, overwrite);
    }

    public PgxFuture<PartitionedGraphConfig> storeAsync(ProviderFormat targetFormat, String targetBasePath, Set<String> vertexProvidersToStore, Set<String> edgeProvidersToStore, boolean overwrite) {
        return this.storeAsync(targetFormat, targetBasePath, vertexProvidersToStore, edgeProvidersToStore, VertexProperty.ALL, EdgeProperty.ALL, overwrite);
    }

    public PgxFuture<FileGraphConfig> storeAsync(Format targetFormat, String targetPath, Collection<VertexProperty<?, ?>> vertexProps, Collection<EdgeProperty<?>> edgeProps, boolean overwrite) {
        return this.storeAsync(targetFormat, targetPath, null, vertexProps, edgeProps, overwrite);
    }

    public PgxFuture<PartitionedGraphConfig> storeAsync(ProviderFormat targetFormat, String targetBasePath, Collection<VertexProperty<?, ?>> vertexProps, Collection<EdgeProperty<?>> edgeProps, boolean overwrite) {
        return this.storeAsync(targetFormat, targetBasePath, 0, null, null, vertexProps, edgeProps, overwrite);
    }

    public PgxFuture<PartitionedGraphConfig> storeAsync(ProviderFormat targetFormat, String targetBasePath, Set<String> vertexProvidersToStore, Set<String> edgeProvidersToStore, Collection<VertexProperty<?, ?>> vertexProps, Collection<EdgeProperty<?>> edgeProps, boolean overwrite) {
        return this.storeAsync(targetFormat, targetBasePath, 0, vertexProvidersToStore, edgeProvidersToStore, null, null, vertexProps, edgeProps, overwrite);
    }

    public PgxFuture<FileGraphConfig> storeAsync(Format targetFormat, String targetBasePath, int numPartitions) {
        return this.storeAsync(targetFormat, targetBasePath, numPartitions, false);
    }

    public PgxFuture<PartitionedGraphConfig> storeAsync(ProviderFormat targetFormat, String targetBasePath, int numPartitions) {
        return this.storeAsync(targetFormat, targetBasePath, numPartitions, false);
    }

    public PgxFuture<PartitionedGraphConfig> storeAsync(ProviderFormat targetFormat, String targetBasePath, int numPartitions, Set<String> vertexProvidersToStore, Set<String> edgeProvidersToStore) {
        return this.storeAsync(targetFormat, targetBasePath, numPartitions, vertexProvidersToStore, edgeProvidersToStore, false);
    }

    public PgxFuture<FileGraphConfig> storeAsync(Format targetFormat, String targetBasePath, int numPartitions, boolean overwrite) {
        return this.storeAsync(targetFormat, targetBasePath, numPartitions, VertexProperty.ALL, EdgeProperty.ALL, overwrite);
    }

    public PgxFuture<PartitionedGraphConfig> storeAsync(ProviderFormat targetFormat, String targetBasePath, int numPartitions, boolean overwrite) {
        return this.storeAsync(targetFormat, targetBasePath, numPartitions, (Collection<VertexProperty<?, ?>>)VertexProperty.ALL, (Collection<EdgeProperty<?>>)EdgeProperty.ALL, overwrite);
    }

    public PgxFuture<PartitionedGraphConfig> storeAsync(ProviderFormat targetFormat, String targetBasePath, int numPartitions, Set<String> vertexProvidersToStore, Set<String> edgeProvidersToStore, boolean overwrite) {
        return this.storeAsync(targetFormat, targetBasePath, numPartitions, vertexProvidersToStore, edgeProvidersToStore, VertexProperty.ALL, EdgeProperty.ALL, overwrite);
    }

    public PgxFuture<FileGraphConfig> storeAsync(Format targetFormat, String targetBasePath, int numPartitions, Collection<VertexProperty<?, ?>> vertexProps, Collection<EdgeProperty<?>> edgeProps, boolean overwrite) {
        FileGraphStoringConfig storingConfig = new FileGraphStoringConfigBuilder(targetBasePath).setNumPartitions(numPartitions).build();
        return this.storeAsync(targetFormat, targetBasePath, storingConfig, vertexProps, edgeProps, overwrite);
    }

    public PgxFuture<PartitionedGraphConfig> storeAsync(ProviderFormat targetFormat, String targetBasePath, int numPartitions, Collection<VertexProperty<?, ?>> vertexProps, Collection<EdgeProperty<?>> edgeProps, boolean overwrite) {
        return this.storeAsync(targetFormat, targetBasePath, numPartitions, null, null, null, null, vertexProps, edgeProps, overwrite);
    }

    public PgxFuture<PartitionedGraphConfig> storeAsync(ProviderFormat targetFormat, String targetBasePath, int numPartitions, Set<String> vertexProvidersToStore, Set<String> edgeProvidersToStore, Collection<VertexProperty<?, ?>> vertexProps, Collection<EdgeProperty<?>> edgeProps, boolean overwrite) {
        return this.storeAsync(targetFormat, targetBasePath, numPartitions, vertexProvidersToStore, edgeProvidersToStore, null, null, vertexProps, edgeProps, overwrite);
    }

    public PgxFuture<FileGraphConfig> storeAsync(Format targetFormat, FileGraphStoringConfig storingConfig) {
        return this.storeAsync(targetFormat, storingConfig, false);
    }

    public PgxFuture<PartitionedGraphConfig> storeAsync(ProviderFormat targetFormat, Map<String, FileGraphStoringConfig> vertexStoringConfigs, Map<String, FileGraphStoringConfig> edgeStoringConfigs) {
        return this.storeAsync(targetFormat, vertexStoringConfigs, edgeStoringConfigs, false);
    }

    public PgxFuture<FileGraphConfig> storeAsync(Format targetFormat, FileGraphStoringConfig storingConfig, boolean overwrite) {
        return this.storeAsync(targetFormat, storingConfig, VertexProperty.ALL, EdgeProperty.ALL, overwrite);
    }

    public PgxFuture<PartitionedGraphConfig> storeAsync(ProviderFormat targetFormat, Map<String, FileGraphStoringConfig> vertexStoringConfigs, Map<String, FileGraphStoringConfig> edgeStoringConfigs, boolean overwrite) {
        return this.storeAsync(targetFormat, vertexStoringConfigs, edgeStoringConfigs, VertexProperty.ALL, EdgeProperty.ALL, overwrite);
    }

    public PgxFuture<PartitionedGraphConfig> storeAsync(ProviderFormat targetFormat, Set<String> vertexProvidersToStore, Set<String> edgeProvidersToStore, Map<String, FileGraphStoringConfig> vertexStoringConfigs, Map<String, FileGraphStoringConfig> edgeStoringConfigs, boolean overwrite) {
        return this.storeAsync(targetFormat, vertexProvidersToStore, edgeProvidersToStore, vertexStoringConfigs, edgeStoringConfigs, VertexProperty.ALL, EdgeProperty.ALL, overwrite);
    }

    public PgxFuture<FileGraphConfig> storeAsync(Format targetFormat, FileGraphStoringConfig storingConfig, Collection<VertexProperty<?, ?>> vertexProps, Collection<EdgeProperty<?>> edgeProps, boolean overwrite) {
        return this.storeAsync(targetFormat, storingConfig.getBasePath(), storingConfig, vertexProps, edgeProps, overwrite);
    }

    public PgxFuture<PartitionedGraphConfig> storeAsync(ProviderFormat targetFormat, Map<String, FileGraphStoringConfig> vertexStoringConfigs, Map<String, FileGraphStoringConfig> edgeStoringConfigs, Collection<VertexProperty<?, ?>> vertexProps, Collection<EdgeProperty<?>> edgeProps, boolean overwrite) {
        return this.storeAsync(targetFormat, null, 0, null, null, vertexStoringConfigs, edgeStoringConfigs, vertexProps, edgeProps, overwrite);
    }

    public PgxFuture<PartitionedGraphConfig> storeAsync(ProviderFormat targetFormat, Set<String> vertexProvidersToStore, Set<String> edgeProvidersToStore, Map<String, FileGraphStoringConfig> vertexStoringConfigs, Map<String, FileGraphStoringConfig> edgeStoringConfigs, Collection<VertexProperty<?, ?>> vertexProps, Collection<EdgeProperty<?>> edgeProps, boolean overwrite) {
        return this.storeAsync(targetFormat, null, 0, vertexProvidersToStore, edgeProvidersToStore, vertexStoringConfigs, edgeStoringConfigs, vertexProps, edgeProps, overwrite);
    }

    public PgxFuture<GraphConfig> storeAsync(GraphConfig targetConfig, boolean overwrite) {
        return this.storeAsync(targetConfig, null, null, overwrite);
    }

    public PgxFuture<GraphConfig> storeAsync(GraphConfig targetConfig, Set<String> vertexProvidersToStore, Set<String> edgeProvidersToStore, boolean overwrite) {
        GraphConfig graphConfig = null;
        try {
            String keystorePath = this.session.getKeystorePath();
            char[] keystorePassword = this.session.getKeystorePassword();
            graphConfig = ConfigUtils.createGraphConfigWithCredentials((GraphConfig)targetConfig, (String)keystorePath, (char[])keystorePassword);
        }
        catch (Exception e) {
            return PgxFuture.exceptionallyCompletedFuture(e);
        }
        PgxFuture<Void> storingFuture = this.core.storeGraphWithProperties(this.getSessionContext(), this.getId(), graphConfig, vertexProvidersToStore, edgeProvidersToStore, overwrite);
        return storingFuture.thenApply(arg -> {
            if (targetConfig instanceof AbstractFileGraphConfig && ((AbstractFileGraphConfig)targetConfig).getStoring().isEmpty()) {
                return targetConfig;
            }
            if (targetConfig instanceof FileGraphConfig) {
                if (((Format)targetConfig.getFormat()).hasVerticesAndEdgesSeparatedFileFormat()) {
                    FileGraphConfig fileGraphConfig = (FileGraphConfig)targetConfig;
                    return ((FileGraphConfigBuilder)((FileGraphConfigBuilder)((FileGraphConfigBuilder)new FileGraphConfigBuilder().copyFrom(fileGraphConfig).setVertexUris(this.constructPartitionedVertexUris((AbstractFileGraphConfig)fileGraphConfig))).setEdgeUris(this.constructPartitionedEdgeUris((AbstractFileGraphConfig)fileGraphConfig))).setSeparator(this.getStoringSeparator((AbstractFileGraphConfig)fileGraphConfig))).build();
                }
                FileGraphConfig fileGraphConfig = (FileGraphConfig)targetConfig;
                return ((FileGraphConfigBuilder)((FileGraphConfigBuilder)new FileGraphConfigBuilder().copyFrom(fileGraphConfig).setUris(this.constructPartitionedVertexUris((AbstractFileGraphConfig)fileGraphConfig))).setSeparator(this.getStoringSeparator((AbstractFileGraphConfig)fileGraphConfig))).build();
            }
            if (targetConfig instanceof TwoTablesTextGraphConfig) {
                TwoTablesTextGraphConfig tttGraphConfig = (TwoTablesTextGraphConfig)targetConfig;
                return ((TwoTablesTextGraphConfigBuilder)((TwoTablesTextGraphConfigBuilder)((TwoTablesTextGraphConfigBuilder)new TwoTablesTextGraphConfigBuilder().copyFrom(tttGraphConfig).setVertexUris(this.constructPartitionedVertexUris((AbstractFileGraphConfig)tttGraphConfig))).setEdgeUris(this.constructPartitionedEdgeUris((AbstractFileGraphConfig)tttGraphConfig))).setSeparator(this.getStoringSeparator((AbstractFileGraphConfig)tttGraphConfig))).build();
            }
            if (targetConfig instanceof PartitionedGraphConfig) {
                FileEntityProviderConfig fileEntityProviderConfig;
                PartitionedGraphConfig partitionedGraphConfig = (PartitionedGraphConfig)targetConfig;
                ArrayList<EntityProviderConfig> vertexProviders = new ArrayList<EntityProviderConfig>();
                ArrayList<EntityProviderConfig> edgeProviders = new ArrayList<EntityProviderConfig>();
                for (EntityProviderConfig vertexProvider : partitionedGraphConfig.getVertexProviders()) {
                    fileEntityProviderConfig = (FileEntityProviderConfig)vertexProvider;
                    vertexProviders.add(fileEntityProviderConfig.toEntityProviderConfigBuilder().setUris(this.constructPartitionedVertexUris(fileEntityProviderConfig)).build());
                }
                for (EntityProviderConfig edgeProvider : partitionedGraphConfig.getEdgeProviders()) {
                    fileEntityProviderConfig = (FileEntityProviderConfig)edgeProvider;
                    edgeProviders.add(fileEntityProviderConfig.toEntityProviderConfigBuilder().setUris(this.constructPartitionedEdgeUris(fileEntityProviderConfig)).build());
                }
                new GraphConfigBuilder();
                return GraphConfigBuilder.forPartitioned().copyFrom(partitionedGraphConfig).setVertexProviders(vertexProviders).setEdgeProviders(edgeProviders).build();
            }
            return targetConfig;
        });
    }

    private String getStoringSeparator(AbstractFileGraphConfig graphConfig) {
        Character separator = graphConfig.getStoring().getSeparator();
        return separator == null ? graphConfig.getSeparator() : separator.toString();
    }

    private List<String> constructPartitionedVertexUris(AbstractFileGraphConfig graphConfig) {
        String fileExtension = "." + graphConfig.getStoring().getVertexExtension();
        return this.constructPartitionedUris(fileExtension, graphConfig);
    }

    private List<String> constructPartitionedEdgeUris(AbstractFileGraphConfig graphConfig) {
        String fileExtension = "." + graphConfig.getStoring().getEdgeExtension();
        return this.constructPartitionedUris(fileExtension, graphConfig);
    }

    private List<String> constructPartitionedUris(String fileExtension, AbstractFileGraphConfig graphConfig) {
        FileGraphStoringConfig storingConfig = graphConfig.getStoring();
        int numPartitions = storingConfig.getNumPartitions();
        int initialPartitionIndex = storingConfig.getInitialPartitionIndex();
        String basePath = storingConfig.getBasePath();
        String string = basePath = basePath == null ? FilenameUtils.removeExtension((String)((String)graphConfig.getUris().get(0))) : basePath;
        if (numPartitions == 1) {
            return Collections.singletonList(basePath + fileExtension);
        }
        ArrayList<String> uris = new ArrayList<String>(numPartitions);
        for (int partitionIndex = 0; partitionIndex < numPartitions; ++partitionIndex) {
            uris.add(basePath + "_" + (partitionIndex + initialPartitionIndex) + fileExtension);
        }
        return uris;
    }

    private List<String> constructPartitionedVertexUris(FileEntityProviderConfig graphConfig) {
        String fileExtension = "." + graphConfig.getStoring().getVertexExtension();
        return this.constructPartitionedUris(fileExtension, graphConfig);
    }

    private List<String> constructPartitionedEdgeUris(FileEntityProviderConfig graphConfig) {
        String fileExtension = "." + graphConfig.getStoring().getEdgeExtension();
        return this.constructPartitionedUris(fileExtension, graphConfig);
    }

    private List<String> constructPartitionedUris(String fileExtension, FileEntityProviderConfig graphConfig) {
        FileGraphStoringConfig storingConfig = graphConfig.getStoring();
        int numPartitions = storingConfig.getNumPartitions();
        if (numPartitions != 1 && graphConfig.getFormat() == ProviderFormat.PGB) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"PGB_NOT_SUPPORTING_NUM_PARTITIONS_GREATER_ONE", (Object[])new Object[]{numPartitions}));
        }
        int initialPartitionIndex = storingConfig.getInitialPartitionIndex();
        String basePath = storingConfig.getBasePath();
        String string = basePath = basePath == null ? FilenameUtils.removeExtension((String)((String)graphConfig.getUris().get(0))) : basePath;
        if (numPartitions == 1) {
            return Collections.singletonList(basePath + fileExtension);
        }
        ArrayList<String> uris = new ArrayList<String>(numPartitions);
        for (int partitionIndex = 0; partitionIndex < numPartitions; ++partitionIndex) {
            uris.add(basePath + "_" + (partitionIndex + initialPartitionIndex) + fileExtension);
        }
        return uris;
    }

    private PgxFuture<FileGraphConfig> storeAsync(Format targetFormat, String targetPath, FileGraphStoringConfig storingConfig, Collection<VertexProperty<?, ?>> vertexProps, Collection<EdgeProperty<?>> edgeProps, boolean overwrite) {
        if (!this.isHomogeneous()) {
            return PgxFuture.exceptionallyCompletedFuture(new UnsupportedOperationException(ErrorMessages.getMessage((String)"UNSUPPORTED_OP_ON_PARTITIONED_GRAPH", (Object[])new Object[0])));
        }
        if (!this.isDirected()) {
            return PgxFuture.exceptionallyCompletedFuture(new IllegalStateException(ErrorMessages.getMessage((String)"STORING_OF_UNDIRECTED_NOT_SUPPORTED", (Object[])new Object[0])));
        }
        if (!targetFormat.isFileFormat()) {
            return PgxFuture.exceptionallyCompletedFuture(new IllegalArgumentException(ErrorMessages.getMessage((String)"EXPECTED_FILE_FORMAT", (Object[])new Object[]{targetFormat})));
        }
        if (targetFormat.hasVerticesAndEdgesSeparatedFormat() && storingConfig == null) {
            return PgxFuture.exceptionallyCompletedFuture(new IllegalArgumentException(ErrorMessages.getMessage((String)"EXPECTED_COMBINED_VERTICES_AND_EDGES_FORMAT_SHORT", (Object[])new Object[]{targetFormat})));
        }
        PgxFuture<Graph> graphResultPromise = this.core.getGraphResult(this.getSessionContext(), this.getId());
        PgxFuture<Collection<VertexProperty<?, ?>>> vertexPropsPromise = vertexProps == VertexProperty.ALL ? this.getVertexPropertiesAsync() : PgxFuture.completedFuture(vertexProps);
        PgxFuture<Collection<EdgeProperty<?>>> edgePropsPromise = edgeProps == EdgeProperty.ALL ? this.getEdgePropertiesAsync() : PgxFuture.completedFuture(edgeProps);
        return ((PgxFuture)vertexPropsPromise.thenCombine(edgePropsPromise, (vertexProperties, edgeProperties) -> new Pair(vertexProperties, edgeProperties)).thenCombine(graphResultPromise, (p, graph) -> {
            Collection vertexProperties = (Collection)p.getFirst();
            Collection edgeProperties = (Collection)p.getSecond();
            return GraphConfigGenerationHelper.generateFileGraphConfig(targetFormat, targetPath, storingConfig, graph, this.getVertexIdType(), vertexProperties, edgeProperties);
        }).thenCompose(config -> this.storeAsync((GraphConfig)config, overwrite))).thenApply(graphConfig -> {
            assert (graphConfig.isFileFormat());
            return (FileGraphConfig)graphConfig;
        });
    }

    private void throwIfNoIds() {
        if (this.getVertexIdStrategy() == IdStrategy.NO_IDS) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"GRAPH_MISSING_VERTEX_IDS", (Object[])new Object[0]));
        }
        if (this.getEdgeIdStrategy() == IdStrategy.NO_IDS) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"GRAPH_MISSING_EDGE_IDS", (Object[])new Object[0]));
        }
    }

    private PgxFuture<PartitionedGraphConfig> storeAsync(ProviderFormat targetFormat, String targetBasePath, int numPartitions, Set<String> vertexProvidersToStore, Set<String> edgeProvidersToStore, Map<String, FileGraphStoringConfig> vertexStoringConfigs, Map<String, FileGraphStoringConfig> edgeStoringConfigs, Collection<VertexProperty<?, ?>> vertexProps, Collection<EdgeProperty<?>> edgeProps, boolean overwrite) {
        if (this.getVertexIdStrategy() == IdStrategy.NO_IDS) {
            return PgxFuture.exceptionallyCompletedFuture(new IllegalStateException(ErrorMessages.getMessage((String)"GRAPH_MISSING_VERTEX_IDS", (Object[])new Object[0])));
        }
        if (!this.isDirected()) {
            return PgxFuture.exceptionallyCompletedFuture(new IllegalStateException(ErrorMessages.getMessage((String)"STORING_OF_UNDIRECTED_NOT_SUPPORTED", (Object[])new Object[0])));
        }
        if (!targetFormat.isFileFormat()) {
            return PgxFuture.exceptionallyCompletedFuture(new IllegalArgumentException(ErrorMessages.getMessage((String)"EXPECTED_FILE_FORMAT", (Object[])new Object[]{targetFormat})));
        }
        PgxFuture<Graph> graphResultPromise = this.core.getGraphResult(this.getSessionContext(), this.getId());
        PgxFuture<Collection<VertexProperty<?, ?>>> vertexPropsPromise = vertexProps == VertexProperty.ALL ? this.getVertexPropertiesAsync() : PgxFuture.completedFuture(vertexProps);
        PgxFuture<Collection<EdgeProperty<?>>> edgePropsPromise = edgeProps == EdgeProperty.ALL ? this.getEdgePropertiesAsync() : PgxFuture.completedFuture(edgeProps);
        return ((PgxFuture)vertexPropsPromise.thenCombine(edgePropsPromise, (vertexProperties, edgeProperties) -> new Pair(vertexProperties, edgeProperties)).thenCombine(graphResultPromise, (p, graph) -> {
            Collection vertexProperties = (Collection)p.getFirst();
            Collection edgeProperties = (Collection)p.getSecond();
            PartitionedGraphConfigGenerationContext partitionedGraphConfigGenerationContext = new PartitionedGraphConfigGenerationContext();
            partitionedGraphConfigGenerationContext.setTargetFormat(targetFormat);
            partitionedGraphConfigGenerationContext.setTargetBasePath(targetBasePath);
            partitionedGraphConfigGenerationContext.setNumPartitions(numPartitions);
            partitionedGraphConfigGenerationContext.setVertexStoringConfigs(vertexStoringConfigs);
            partitionedGraphConfigGenerationContext.setEdgeStoringConfigs(edgeStoringConfigs);
            partitionedGraphConfigGenerationContext.setGraph((Graph)((Object)graph));
            partitionedGraphConfigGenerationContext.setVertexIdType(this.getVertexIdType());
            partitionedGraphConfigGenerationContext.setEdgeIdType(this.getEdgeIdType());
            partitionedGraphConfigGenerationContext.setVertexIdStrategy(this.getVertexIdStrategy());
            partitionedGraphConfigGenerationContext.setEdgeIdStrategy(this.getEdgeIdStrategy());
            partitionedGraphConfigGenerationContext.setVertexProperties(vertexProperties);
            partitionedGraphConfigGenerationContext.setEdgeProperties(edgeProperties);
            partitionedGraphConfigGenerationContext.setVertexProvidersToStore(vertexProvidersToStore);
            partitionedGraphConfigGenerationContext.setEdgeProvidersToStore(edgeProvidersToStore);
            return partitionedGraphConfigGenerationContext.generatePartitionedGraphConfig();
        }).thenCompose(config -> this.storeAsync((GraphConfig)config, vertexProvidersToStore, edgeProvidersToStore, overwrite))).thenApply(graphConfig -> (PartitionedGraphConfig)graphConfig);
    }

    @Override
    public PgxFuture<Void> destroyAsync() {
        return this.core.destroyGraphWithProperties(this.getSessionContext(), this.getId());
    }

    public PgxFuture<Void> destroyVertexPropertyIfExistsAsync(String name) {
        return this.destroyPropertyIfExists(() -> this.getVertexPropertyAsync(name));
    }

    public PgxFuture<Void> destroyEdgePropertyIfExistsAsync(String name) {
        return this.destroyPropertyIfExists(() -> this.getEdgePropertyAsync(name));
    }

    private PgxFuture<Void> destroyPropertyIfExists(Supplier<PgxFuture<? extends oracle.pgx.api.Property<?, ?, ?>>> getter) {
        return getter.get().thenCompose(property -> {
            if (property != null) {
                return property.destroyAsync();
            }
            return PgxFuture.completedFuture(null);
        });
    }

    public PgxFuture<Boolean> isFreshAsync() {
        return this.core.isFresh(this.getSessionContext(), this.getId());
    }

    public <T> PgxFuture<Scalar<T>> createScalarAsync(PropertyType type, String newScalarName) {
        return this.core.createScalar(this.getSessionContext(), this.getId(), type, newScalarName).thenApply(self -> new Scalar(this, self.getId(), type));
    }

    public <T> PgxFuture<Scalar<T>> createScalarAsync(PropertyType type) {
        return this.createScalarAsync(type, null);
    }

    public <T> PgxFuture<Scalar<PgxVect<T>>> createVectorScalarAsync(PropertyType type, int dimension, String newScalarName) {
        if (dimension < 0) {
            return PgxFuture.exceptionallyCompletedFuture(new IllegalArgumentException(ErrorMessages.getMessage((String)"INVALID_SCALAR_DIMENSION", (Object[])new Object[0])));
        }
        return this.core.createScalar(this.getSessionContext(), this.getId(), type, dimension, newScalarName).thenApply(self -> new Scalar(this, self.getId(), type, dimension));
    }

    public <T> PgxFuture<Scalar<PgxVect<T>>> createVectorScalarAsync(PropertyType type, int dimension) {
        return this.createVectorScalarAsync(type, dimension, null);
    }

    public <ID, V> PgxFuture<VertexProperty<ID, V>> createVertexPropertyAsync(PropertyType type) {
        return this.createVertexPropertyAsync(type, null);
    }

    public <ID, V> PgxFuture<VertexProperty<ID, V>> createVertexPropertyAsync(PropertyType type, String name) {
        return this.createVertexPropertyAsync(type, 0, name, false);
    }

    public <ID, V> PgxFuture<VertexProperty<ID, PgxVect<V>>> createVertexVectorPropertyAsync(PropertyType type, int dimension) {
        return this.createVertexVectorPropertyAsync(type, dimension, null);
    }

    public <ID, V> PgxFuture<VertexProperty<ID, PgxVect<V>>> createVertexVectorPropertyAsync(PropertyType type, int dimension, String name) {
        return this.createVertexPropertyAsync(type, dimension, name, false);
    }

    <ID, V> PgxFuture<VertexProperty<ID, V>> createVertexPropertyAsync(PropertyType type, int dimension, String propertyName, boolean hardName) {
        if (dimension < 0) {
            return PgxFuture.exceptionallyCompletedFuture(new IllegalArgumentException(ErrorMessages.getMessage((String)"INVALID_PROPERTY_DIMENSION", (Object[])new Object[0])));
        }
        return this.core.createProperty(this.getSessionContext(), this.getId(), EntityType.VERTEX, type, dimension, propertyName, hardName).thenApply(pr -> new VertexProperty(this, (Property)((Object)pr)));
    }

    public <ID, V> PgxFuture<VertexProperty<ID, V>> getOrCreateVertexPropertyAsync(PropertyType type, String name) {
        return this.getOrCreatePropertyAsync(() -> this.getVertexPropertyAsync(name), () -> this.createVertexPropertyAsync(type, name), type, 0);
    }

    private <ID, K extends PgxEntity<ID>, V, P extends oracle.pgx.api.Property<ID, K, V>> PgxFuture<P> getOrCreatePropertyAsync(Supplier<PgxFuture<P>> propertyGetter, Supplier<PgxFuture<P>> propertyCreator, PropertyType type, int dimension) {
        return propertyGetter.get().thenCompose(property -> {
            if (property != null) {
                return PgxGraph.toFuture(property, type, dimension);
            }
            return (CompletionStage)propertyCreator.get();
        });
    }

    private static <ID, K extends PgxEntity<ID>, V, P extends oracle.pgx.api.Property<ID, K, V>> PgxFuture<P> toFuture(P property, PropertyType type, int dimension) {
        if (property.getType() == type) {
            if (!property.isVectorProperty() || property.getDimension() == dimension) {
                return PgxFuture.completedFuture(property);
            }
            String message = ErrorMessages.getMessage((String)"PROPERTY_EXISTS_DIFFERENT_DIMENSION", (Object[])new Object[]{property.getEntityType(), property.getName(), property.getDimension(), dimension});
            return PgxGraph.createIllegalArgumentFuture(message);
        }
        String message = ErrorMessages.getMessage((String)"PROPERTY_EXISTS_DIFFERENT_TYPE", (Object[])new Object[]{property.getEntityType(), property.getName(), property.getType(), type});
        return PgxGraph.createIllegalArgumentFuture(message);
    }

    private static <T> PgxFuture<T> createIllegalArgumentFuture(String message) {
        return PgxFuture.exceptionallyCompletedFuture(new IllegalArgumentException(message));
    }

    public <ID, V> PgxFuture<VertexProperty<ID, PgxVect<V>>> getOrCreateVertexVectorPropertyAsync(PropertyType type, int dimension, String name) {
        return this.getOrCreatePropertyAsync(() -> this.getVertexPropertyAsync(name), () -> this.createVertexVectorPropertyAsync(type, dimension, name), type, dimension);
    }

    public <V> PgxFuture<EdgeProperty<V>> createEdgePropertyAsync(PropertyType type) {
        return this.createEdgePropertyAsync(type, null);
    }

    public <V> PgxFuture<EdgeProperty<V>> createEdgePropertyAsync(PropertyType type, String name) {
        return this.createEdgePropertyAsync(type, 0, name, false);
    }

    public <V> PgxFuture<EdgeProperty<PgxVect<V>>> createEdgeVectorPropertyAsync(PropertyType type, int dimension) {
        return this.createEdgeVectorPropertyAsync(type, dimension, null);
    }

    public <V> PgxFuture<EdgeProperty<PgxVect<V>>> createEdgeVectorPropertyAsync(PropertyType type, int dimension, String name) {
        return this.createEdgePropertyAsync(type, dimension, name, false);
    }

    <V> PgxFuture<EdgeProperty<V>> createEdgePropertyAsync(PropertyType type, int dimension, String propertyName, boolean hardName) {
        if (dimension < 0) {
            return PgxFuture.exceptionallyCompletedFuture(new IllegalArgumentException(ErrorMessages.getMessage((String)"INVALID_PROPERTY_DIMENSION", (Object[])new Object[0])));
        }
        return this.core.createProperty(this.getSessionContext(), this.getId(), EntityType.EDGE, type, dimension, propertyName, hardName).thenApply(pr -> new EdgeProperty(this, (Property)((Object)pr)));
    }

    public <V> PgxFuture<EdgeProperty<PgxVect<V>>> getOrCreateEdgeVectorPropertyAsync(PropertyType type, int dimension, String name) {
        return this.getOrCreatePropertyAsync(() -> this.getEdgePropertyAsync(name), () -> this.createEdgeVectorPropertyAsync(type, dimension, name), type, dimension);
    }

    public <V> PgxFuture<EdgeProperty<V>> getOrCreateEdgePropertyAsync(PropertyType type, String name) {
        return this.getOrCreatePropertyAsync(() -> this.getEdgePropertyAsync(name), () -> this.createEdgePropertyAsync(type, name), type, 0);
    }

    public <V> PgxFuture<EdgeProperty<PgxVect<V>>> getOrCreateEdgeVertexPropertyAsync(PropertyType type, int dimension, String name) {
        return this.getEdgePropertyAsync(name).thenCompose(ep -> {
            if (ep != null) {
                return PgxFuture.completedFuture(ep);
            }
            return this.createEdgeVectorPropertyAsync(type, dimension, name);
        });
    }

    public <E> PgxFuture<VertexSequence<E>> createVertexSequenceAsync() {
        return this.createVertexSequenceAsync(null);
    }

    public <E> PgxFuture<VertexSequence<E>> createVertexSequenceAsync(String name) {
        return this.createCollection(CollectionType.SEQUENCE, EntityType.VERTEX, name).thenApply(collectionInfo -> new VertexSequence(this, collectionInfo.getCollectionId(), collectionInfo.getName()));
    }

    public <E> PgxFuture<VertexSet<E>> getVerticesAsync(VertexFilter filter) {
        return this.getVerticesAsync(filter, null);
    }

    public <E> PgxFuture<VertexSet<E>> getVerticesAsync(VertexFilter filter, String name) {
        return this.createCollectionFromFilter(CollectionType.SET, (GraphFilter)filter, name).thenApply(collectionInfo -> new VertexSet(this, collectionInfo.getCollectionId(), collectionInfo.getName()));
    }

    public <E> PgxFuture<VertexSet<E>> getVerticesAsync() {
        return this.getVerticesAsync(VertexFilter.ALL);
    }

    public <E> PgxFuture<VertexSet<E>> createVertexSetAsync() {
        return this.createVertexSetAsync(null);
    }

    public <E> PgxFuture<VertexSet<E>> createVertexSetAsync(String name) {
        return this.createCollection(CollectionType.SET, EntityType.VERTEX, name).thenApply(collectionInfo -> new VertexSet(this, collectionInfo.getCollectionId(), collectionInfo.getName()));
    }

    public PgxFuture<EdgeSequence> createEdgeSequenceAsync() {
        return this.createEdgeSequenceAsync(null);
    }

    public PgxFuture<EdgeSequence> createEdgeSequenceAsync(String name) {
        return this.createCollection(CollectionType.SEQUENCE, EntityType.EDGE, name).thenApply(collectionInfo -> new EdgeSequence(this, collectionInfo.getCollectionId(), collectionInfo.getName()));
    }

    public PgxFuture<EdgeSet> createEdgeSetAsync() {
        return this.createEdgeSetAsync(null);
    }

    public PgxFuture<EdgeSet> createEdgeSetAsync(String name) {
        return this.createCollection(CollectionType.SET, EntityType.EDGE, name).thenApply(collectionInfo -> new EdgeSet(this, collectionInfo.getCollectionId(), collectionInfo.getName()));
    }

    public <E> PgxFuture<EdgeSet> getEdgesAsync(EdgeFilter filter) {
        return this.getEdgesAsync(filter, null);
    }

    public PgxFuture<EdgeSet> getEdgesAsync(EdgeFilter filter, String name) {
        return this.createCollectionFromFilter(CollectionType.SET, (GraphFilter)filter, name).thenApply(collectionInfo -> new EdgeSet(this, collectionInfo.getCollectionId(), collectionInfo.getName()));
    }

    public PgxFuture<EdgeSet> getEdgesAsync() {
        return this.getEdgesAsync(EdgeFilter.fromExpression((String)"true"));
    }

    private PgxFuture<CollectionInfo> createCollection(CollectionType type, EntityType elementType, String newCollectionName) {
        return this.core.createCollection(this.getSessionContext(), this.getId(), type, elementType, newCollectionName);
    }

    private PgxFuture<CollectionInfo> createCollectionFromFilter(CollectionType type, GraphFilter graphFilter, String newCollectionName) {
        return this.core.createCollectionFromFilter(this.getSessionContext(), this.getId(), type, graphFilter, newCollectionName);
    }

    public <K, V> PgxFuture<PgxMap<K, V>> createMapAsync(PropertyType keyType, PropertyType valType) {
        return this.createMapAsync(keyType, valType, null);
    }

    public <K, V> PgxFuture<PgxMap<K, V>> createMapAsync(PropertyType keyType, PropertyType valType, String mapName) {
        return this.core.createMap(this.getSessionContext(), this.getId(), keyType, valType, mapName).thenApply(self -> new PgxMap(this, keyType, valType, self.getId()));
    }

    public PgxFuture<PgxGraph> sortByDegreeAsync() {
        return this.sortByDegreeAsync(GENERATE_NAME);
    }

    public PgxFuture<PgxGraph> sortByDegreeAsync(String newGraphName) {
        return this.sortByDegreeAsync(SortOrder.DESCENDING, Degree.IN, Mode.CREATE_COPY, newGraphName);
    }

    public PgxFuture<PgxGraph> sortByDegreeAsync(SortOrder sortOrder, Degree degree, Mode mode, String newGraphName) {
        return this.sortByDegreeAsync(VertexProperty.ALL, EdgeProperty.ALL, sortOrder, degree, mode, newGraphName);
    }

    public PgxFuture<PgxGraph> sortByDegreeAsync(Collection<VertexProperty<?, ?>> vertexProps, Collection<EdgeProperty<?>> edgeProps, SortOrder sortOrder, Degree degree, Mode mode, String newGraphName) {
        Collection<PgxId> vertexPropIds = oracle.pgx.api.Property.getIds(vertexProps);
        Collection<PgxId> edgePropIds = oracle.pgx.api.Property.getIds(edgeProps);
        boolean ascending = sortOrder == SortOrder.ASCENDING;
        boolean useOutDegree = degree == Degree.OUT;
        boolean inPlace = mode == Mode.MUTATE_IN_PLACE;
        PgxFuture<Graph> result = this.core.sortByDegree(this.getSessionContext(), this.getId(), vertexPropIds, edgePropIds, ascending, useOutDegree, inPlace, newGraphName);
        return this.toPgxGraph(result, inPlace);
    }

    public PgxFuture<PgxGraph> transposeAsync() {
        return this.transposeAsync(GENERATE_NAME);
    }

    public PgxFuture<PgxGraph> transposeAsync(Mode mode) {
        return this.transposeAsync(mode, GENERATE_NAME);
    }

    public PgxFuture<PgxGraph> transposeAsync(String newGraphName) {
        return this.transposeAsync(Mode.CREATE_COPY, newGraphName);
    }

    public PgxFuture<PgxGraph> transposeAsync(Mode mode, String newGraphName) {
        return this.transposeAsync(VertexProperty.ALL, EdgeProperty.ALL, null, mode, newGraphName);
    }

    public PgxFuture<PgxGraph> transposeAsync(Collection<VertexProperty<?, ?>> vertexProps, Collection<EdgeProperty<?>> edgeProps, Map<String, String> edgeLabelMapping, Mode mode, String newGraphName) {
        Collection<PgxId> vertexPropIds = oracle.pgx.api.Property.getIds(vertexProps);
        Collection<PgxId> edgePropIds = oracle.pgx.api.Property.getIds(edgeProps);
        boolean inPlace = mode == Mode.MUTATE_IN_PLACE;
        MutationStrategy mutationStrategy = new MutationStrategy(vertexPropIds, edgePropIds, inPlace, newGraphName, false, EdgeStrategy.getDefaultMultiEdgeHandler((boolean)false, (boolean)false), edgeLabelMapping);
        return this.transposeAsync(mutationStrategy);
    }

    PgxFuture<PgxGraph> transposeAsync(MutationStrategy mutationStrategy) {
        PgxFuture<Graph> result = this.core.createTransposedGraph(this.getSessionContext(), this.getId(), mutationStrategy);
        return this.toPgxGraph(result, mutationStrategy.isInPlace());
    }

    public PgxGraph undirect(MutationStrategy mutationStrategy) throws ExecutionException, InterruptedException {
        return this.undirectAsync(mutationStrategy).get();
    }

    public PgxFuture<PgxGraph> undirectAsync() {
        return this.undirectAsync(GENERATE_NAME);
    }

    public PgxFuture<PgxGraph> undirectAsync(String newGraphName) {
        return this.undirectAsync(MultiEdges.KEEP_MULTI_EDGES, SelfEdges.KEEP_SELF_EDGES, Mode.CREATE_COPY, newGraphName);
    }

    public PgxFuture<PgxGraph> undirectAsync(MultiEdges multiEdges, SelfEdges selfEdges, Mode mode, String newGraphName) {
        return this.undirectAsync(VertexProperty.ALL, EdgeProperty.ALL, multiEdges, selfEdges, mode, newGraphName);
    }

    public PgxFuture<PgxGraph> undirectAsync(Collection<VertexProperty<?, ?>> vertexProps, Collection<EdgeProperty<?>> edgeProps, MultiEdges multiEdges, SelfEdges selfEdges, Mode mode, String newGraphName) {
        Collection<PgxId> vertexPropIds = oracle.pgx.api.Property.getIds(vertexProps);
        Collection<PgxId> edgePropIds = oracle.pgx.api.Property.getIds(edgeProps);
        boolean noMultiEdges = multiEdges == MultiEdges.REMOVE_MULTI_EDGES;
        boolean noSelfEdges = selfEdges == SelfEdges.REMOVE_SELF_EDGES;
        boolean inPlace = mode == Mode.MUTATE_IN_PLACE;
        MutationStrategy mutationStrategy = new MutationStrategy(vertexPropIds, edgePropIds, inPlace, newGraphName, false, EdgeStrategy.getDefaultMultiEdgeHandler((boolean)noMultiEdges, (boolean)noSelfEdges));
        return this.undirectAsync(mutationStrategy);
    }

    public PgxFuture<PgxGraph> undirectAsync(MutationStrategy mutationStrategy) {
        PgxFuture<Graph> result = this.core.createUndirectedGraph(this.getSessionContext(), this.getId(), mutationStrategy);
        return this.toPgxGraph(result, mutationStrategy.isInPlace());
    }

    private PgxFuture<PgxGraph> partitionByLabelsAsync() {
        return this.partitionByLabelsAsync(GENERATE_NAME);
    }

    private PgxFuture<PgxGraph> partitionByLabelsAsync(PartitionizingStrategy partitionizingStrategy) {
        PgxFuture<Graph> result = this.core.createPartitionedGraph(this.getSessionContext(), this.getId(), partitionizingStrategy);
        return this.toPgxGraph(result, partitionizingStrategy.isInPlace());
    }

    private PgxFuture<PgxGraph> partitionByLabelsAsync(String newGraphName) {
        return this.partitionByLabelsAsync(PartitionizingStrategy.createDefaultStrategy((String)newGraphName));
    }

    public PgxFuture<PgxGraph> simplifyAsync() {
        return this.simplifyAsync(GENERATE_NAME);
    }

    public PgxFuture<PgxGraph> simplifyAsync(String newGraphName) {
        return this.simplifyAsync(MultiEdges.REMOVE_MULTI_EDGES, SelfEdges.REMOVE_SELF_EDGES, TrivialVertices.REMOVE_TRIVIAL_VERTICES, Mode.CREATE_COPY, newGraphName);
    }

    public PgxFuture<PgxGraph> simplifyAsync(MultiEdges multiEdges, SelfEdges selfEdges, TrivialVertices trivialVertices, Mode mode, String newGraphName) {
        return this.simplifyAsync(VertexProperty.ALL, EdgeProperty.ALL, multiEdges, selfEdges, trivialVertices, mode, newGraphName);
    }

    public PgxFuture<PgxGraph> simplifyAsync(Collection<VertexProperty<?, ?>> vertexProps, Collection<EdgeProperty<?>> edgeProps, MultiEdges multiEdges, SelfEdges selfEdges, TrivialVertices trivialVertices, Mode mode, String newGraphName) {
        Collection<PgxId> vertexPropIds = oracle.pgx.api.Property.getIds(vertexProps);
        Collection<PgxId> edgePropIds = oracle.pgx.api.Property.getIds(edgeProps);
        boolean noMultiEdges = multiEdges == MultiEdges.REMOVE_MULTI_EDGES;
        boolean noSelfEdges = selfEdges == SelfEdges.REMOVE_SELF_EDGES;
        boolean noTrivialVertices = trivialVertices == TrivialVertices.REMOVE_TRIVIAL_VERTICES;
        boolean inPlace = mode == Mode.MUTATE_IN_PLACE;
        return this.simplifyAsync(new MutationStrategy(vertexPropIds, edgePropIds, inPlace, newGraphName, noTrivialVertices, EdgeStrategy.getDefaultMultiEdgeHandler((boolean)noMultiEdges, (boolean)noSelfEdges)));
    }

    public PgxFuture<PgxGraph> simplifyAsync(MutationStrategy mutationStrategy) {
        PgxFuture<Graph> result = this.core.simplifyGraph(this.getSessionContext(), this.getId(), mutationStrategy);
        return this.toPgxGraph(result, mutationStrategy.isInPlace());
    }

    public PgxFuture<BipartiteGraph> bipartiteSubGraphFromLeftSetAsync(VertexSet<?> vertexSet) {
        return this.bipartiteSubGraphFromLeftSetAsync(vertexSet, null);
    }

    public PgxFuture<BipartiteGraph> bipartiteSubGraphFromLeftSetAsync(VertexSet<?> vertexSet, String newGraphName) {
        return this.bipartiteSubGraphFromLeftSetAsync(VertexProperty.ALL, EdgeProperty.ALL, vertexSet, newGraphName);
    }

    public PgxFuture<BipartiteGraph> bipartiteSubGraphFromLeftSetAsync(Collection<VertexProperty<?, ?>> vertexProps, Collection<EdgeProperty<?>> edgeProps, VertexSet<?> vertexSet, String newGraphName) {
        return this.bipartiteSubGraphFromLeftSetAsync(vertexProps, edgeProps, vertexSet, newGraphName, null);
    }

    public PgxFuture<BipartiteGraph> bipartiteSubGraphFromLeftSetAsync(Collection<VertexProperty<?, ?>> vertexProps, Collection<EdgeProperty<?>> edgeProps, VertexSet<?> vertexSet, String newGraphName, String isLeftPropName) {
        Collection<PgxId> vertexPropIds = oracle.pgx.api.Property.getIds(vertexProps);
        Collection<PgxId> edgePropIds = oracle.pgx.api.Property.getIds(edgeProps);
        PgxFuture<Graph> result = this.core.createBipartiteSubgraphFromLeftSet(this.getSessionContext(), this.getId(), vertexPropIds, edgePropIds, vertexSet.getId(), newGraphName, isLeftPropName);
        return this.toBipartiteGraph(result);
    }

    public PgxFuture<BipartiteGraph> bipartiteSubGraphFromInDegreeAsync() {
        return this.bipartiteSubGraphFromInDegreeAsync(null);
    }

    public PgxFuture<BipartiteGraph> bipartiteSubGraphFromInDegreeAsync(String newGraphName) {
        return this.bipartiteSubGraphFromInDegreeAsync(VertexProperty.ALL, EdgeProperty.ALL, newGraphName);
    }

    public PgxFuture<BipartiteGraph> bipartiteSubGraphFromInDegreeAsync(Collection<VertexProperty<?, ?>> vertexProps, Collection<EdgeProperty<?>> edgeProps, String newGraphName) {
        return this.bipartiteSubGraphFromInDegreeAsync(vertexProps, edgeProps, newGraphName, null, false);
    }

    public PgxFuture<BipartiteGraph> bipartiteSubGraphFromInDegreeAsync(Collection<VertexProperty<?, ?>> vertexProps, Collection<EdgeProperty<?>> edgeProps, String newGraphName, String isLeftPropName, boolean inPlace) {
        Collection<PgxId> vertexPropIds = oracle.pgx.api.Property.getIds(vertexProps);
        Collection<PgxId> edgePropIds = oracle.pgx.api.Property.getIds(edgeProps);
        PgxFuture<Graph> result = this.core.createBipartiteSubgraphFromInDegree(this.getSessionContext(), this.getId(), vertexPropIds, edgePropIds, newGraphName, isLeftPropName, inPlace);
        return this.toBipartiteGraph(result);
    }

    private PgxFuture<BipartiteGraph> toBipartiteGraph(PgxFuture<Graph> result) {
        return result.thenApply(g -> {
            Property isLeftProperty = (Property)((Object)((Object)g.getVertexTables().values().stream().limit(1L).map(EntityTable::getProperties).flatMap(p -> p.values().stream()).findFirst().orElseThrow(() -> new IllegalArgumentException(ErrorMessages.getMessage((String)"GRAPH_EMPTY", (Object[])new Object[0])))));
            return new BipartiteGraph(this.session, (Graph)((Object)g), isLeftProperty.getPropertyId(), isLeftProperty.getName());
        });
    }

    public <ID> PgxFuture<Boolean> isBipartiteGraphAsync(VertexProperty<ID, Boolean> isLeft) {
        return this.session.createAnalyst().getBuiltinAlgorithms().pgxBuiltinS10BipartiteCheck(this.getSessionContext(), this.getId(), isLeft.getPropertyId());
    }

    public PgxFuture<PgxGraph> sparsifyAsync(double e) {
        return this.sparsifyAsync(e, null);
    }

    public PgxFuture<PgxGraph> sparsifyAsync(double e, String newGraphName) {
        return this.sparsifyAsync(VertexProperty.ALL, EdgeProperty.ALL, e, newGraphName);
    }

    public PgxFuture<PgxGraph> sparsifyAsync(Collection<VertexProperty<?, ?>> vertexProps, Collection<EdgeProperty<?>> edgeProps, double e, String newGraphName) {
        Collection<PgxId> vertexPropIds = oracle.pgx.api.Property.getIds(vertexProps);
        Collection<PgxId> edgePropIds = oracle.pgx.api.Property.getIds(edgeProps);
        PgxFuture<Graph> result = this.core.createSparsifiedSubgraph(this.getSessionContext(), this.getId(), vertexPropIds, edgePropIds, e, newGraphName);
        return this.toPgxGraph(result);
    }

    public PgxFuture<PgxGraph> filterAsync(GraphFilter graphFilter) {
        return this.filterAsync(graphFilter, null);
    }

    public PgxFuture<PgxGraph> filterAsync(GraphFilter graphFilter, String newGraphName) {
        return this.filterAsync(VertexProperty.ALL, EdgeProperty.ALL, graphFilter, newGraphName);
    }

    public PgxFuture<PgxGraph> filterAsync(Collection<VertexProperty<?, ?>> vertexProps, Collection<EdgeProperty<?>> edgeProps, GraphFilter graphFilter, String newGraphName) {
        Collection<PgxId> vertexPropIds = oracle.pgx.api.Property.getIds(vertexProps);
        Collection<PgxId> edgePropIds = oracle.pgx.api.Property.getIds(edgeProps);
        PgxFuture<Graph> result = this.core.createSubgraphFromFilter(this.getSessionContext(), this.getId(), vertexPropIds, edgePropIds, graphFilter, newGraphName);
        return this.toPgxGraph(result);
    }

    public PgxFuture<PgxGraph> cloneAsync() {
        return this.cloneAsync(null);
    }

    public PgxFuture<PgxGraph> cloneAsync(String newGraphName) {
        return this.cloneAsync(VertexProperty.ALL, EdgeProperty.ALL, newGraphName);
    }

    public PgxFuture<PgxGraph> cloneAsync(Collection<VertexProperty<?, ?>> vertexProps, Collection<EdgeProperty<?>> edgeProps, String newGraphName) {
        Collection<PgxId> vertexPropIds = oracle.pgx.api.Property.getIds(vertexProps);
        Collection<PgxId> edgePropIds = oracle.pgx.api.Property.getIds(edgeProps);
        PgxFuture<Graph> result = this.core.cloneGraph(this.getSessionContext(), this.getId(), vertexPropIds, edgePropIds, newGraphName);
        return this.toPgxGraph(result);
    }

    private PgxFuture<PgxGraph> toPgxGraph(PgxFuture<Graph> result, boolean inPlace) {
        return result.thenApply(graph -> {
            if (inPlace) {
                this.setMetaData(graph.getMetaData());
                return this;
            }
            return new PgxGraph(this.session, (Graph)((Object)graph));
        });
    }

    private PgxFuture<PgxGraph> toPgxGraph(PgxFuture<Graph> result) {
        return this.toPgxGraph(result, false);
    }

    public <ID> PgxFuture<PgxPath<ID>> createPathAsync(PgxVertex<ID> src, PgxVertex<ID> dst, EdgeProperty<Double> cost, VertexProperty<ID, PgxVertex<ID>> parent, VertexProperty<ID, PgxEdge> parentEdge) {
        PgxId costName = cost == null ? null : cost.getPropertyId();
        return this.core.getPathProxy(this.getSessionContext(), this.getId(), src.serialize(), dst.serialize(), costName, parent.getPropertyId(), parentEdge.getPropertyId()).thenApply(proxy -> new PgxPath(this, (PathProxy)proxy));
    }

    public <ID> PgxFuture<PgxPath<ID>> createPathAsync(VertexSequence<ID> nodeSequence, EdgeSequence edgeSequence) {
        return this.core.getPathProxy(this.getSessionContext(), this.getId(), nodeSequence.getId(), edgeSequence.getId()).thenApply(proxy -> new PgxPath(this, (PathProxy)proxy));
    }

    public <ID> PgxFuture<AllPaths<ID>> createAllPathsAsync(PgxVertex<ID> src, EdgeProperty<Double> cost, VertexProperty<ID, Double> dist, VertexProperty<ID, PgxVertex<ID>> parent, VertexProperty<ID, PgxEdge> parentEdge) {
        PgxId costName = cost == null ? null : cost.getPropertyId();
        return this.core.getAllPathsProxy(this.getSessionContext(), this.getId(), src.serialize(), costName, dist.getPropertyId(), parent.getPropertyId(), parentEdge.getPropertyId()).thenApply(proxy -> new AllPaths(this, src, (AllPathsProxy)proxy));
    }

    public <ID> PgxFuture<Partition<ID>> createComponentsAsync(VertexProperty<ID, Long> components, long numComponents) {
        return this.core.getComponentsProxy(this.getSessionContext(), this.getId(), components.getPropertyId(), numComponents).thenApply(proxy -> new Partition(this, components, (ComponentsProxy)proxy));
    }

    private PgxFuture<PgqlResultSet> queryPgqlAsync(String pgqlString, List<PgqlOption> pgqlOptions) {
        pgqlOptions = PgqlOption.getClientPgqlOptionsWithDefaults(pgqlOptions);
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)this.core.queryPgql(this.getSessionContext(), this.getId(), pgqlString, pgqlOptions).cancelOn(promise).thenApply(resultSet -> resultSet == null ? null : new PgqlResultSetImpl(this.core, this, this.session::getKeystorePath, this.session::getKeystorePassword, (PgqlResultSetProxy)resultSet))).thenComplete(promise);
    }

    public PgxFuture<PgqlResultSet> queryPgqlAsync(String pgqlString) {
        return this.queryPgqlAsync(pgqlString, Collections.emptyList());
    }

    public PgxFuture<PgqlResultSet> executePgqlAsync(String pgqlString) {
        List pgqlOptions = PgqlOption.getClientPgqlOptionsWithDefaults(Collections.emptyList());
        PgxFuture promise = new PgxFuture();
        return ((PgxFuture)((PgxFuture)this.core.executePgql(this.getSessionContext(), this.getId(), pgqlString, pgqlOptions).cancelOn(promise).thenApply(resultSet -> resultSet == null ? null : new PgqlResultSetImpl(this.core, this, this.session::getKeystorePath, this.session::getKeystorePassword, (PgqlResultSetProxy)resultSet))).thenCompose(rs -> this.toPgxGraph(this.core.getGraphResult(this.getSessionContext(), this.getId()), true).thenReturn(rs))).thenComplete(promise);
    }

    public PgxFuture<PgxGraph> cloneAndExecutePgqlAsync(String pgqlString) {
        return this.cloneAndExecutePgqlAsync(pgqlString, null);
    }

    public PgxFuture<PgxGraph> cloneAndExecutePgqlAsync(String pgqlString, String newGraphName) {
        List pgqlOptions = PgqlOption.getClientPgqlOptionsWithDefaults(Collections.emptyList());
        return this.toPgxGraph(this.core.cloneAndExecutePgql(this.getSessionContext(), this.getId(), pgqlString, newGraphName, pgqlOptions));
    }

    public PgxFuture<PgxPreparedStatement> preparePgqlAsync(String pgqlString) {
        return this.core.preparePgql(this.getSessionContext(), this.getId(), pgqlString).thenApply(preparedStatement -> new PgxPreparedStatementImpl(this.core, this, (PreparedStatementProxy)preparedStatement, this.session, this.session::getKeystorePath, this.session::getKeystorePassword));
    }

    public PgxFuture<Operation> explainPgqlAsync(String pgqlString) {
        PgxFuture promise = new PgxFuture();
        return this.core.explainPgql(this.getSessionContext(), this.getId(), pgqlString).cancelOn(promise).thenComplete(promise);
    }

    public <ID, V> PgxFuture<VertexProperty<ID, PgxVect<V>>> combineVertexPropertiesIntoVectorPropertyAsync(List<VertexProperty<ID, V>> vertexPropertyList) {
        return this.combineVertexPropertiesIntoVectorPropertyAsync(vertexPropertyList, null);
    }

    public <ID, V> PgxFuture<VertexProperty<ID, PgxVect<V>>> combineVertexPropertiesIntoVectorPropertyAsync(List<VertexProperty<ID, V>> vertexPropertyList, String name) {
        return this.core.combine(this.getSessionContext(), this.getId(), EntityType.VERTEX, this.getPropertyIds(vertexPropertyList), name).thenApply(pr -> new VertexProperty(this, (Property)((Object)pr)));
    }

    public <E> PgxFuture<EdgeProperty<PgxVect<E>>> combineEdgePropertiesIntoVectorPropertyAsync(List<EdgeProperty<E>> edgePropertyList) {
        return this.combineEdgePropertiesIntoVectorPropertyAsync(edgePropertyList, null);
    }

    public <E> PgxFuture<EdgeProperty<PgxVect<E>>> combineEdgePropertiesIntoVectorPropertyAsync(List<EdgeProperty<E>> edgePropertyList, String name) {
        return this.core.combine(this.getSessionContext(), this.getId(), EntityType.EDGE, this.getPropertyIds(edgePropertyList), name).thenApply(pr -> new EdgeProperty(this, (Property)((Object)pr)));
    }

    private <E extends oracle.pgx.api.Property> List<PgxId> getPropertyIds(List<E> propertyList) {
        ArrayList<PgxId> names = new ArrayList<PgxId>();
        for (oracle.pgx.api.Property property : propertyList) {
            names.add(property.getPropertyId());
        }
        return names;
    }

    public PgxFuture<Map<String, PgxCollection<? extends PgxEntity<?>, ?>>> getCollectionsAsync() {
        return this.core.getCollections(this.getSessionContext(), this.getId()).thenApply(infos -> infos.stream().map(info -> PgxCollection.createFromNameAndTypes(this, info.getCollectionId(), info.name, info.entityType, info.collectionType)).collect(Collectors.toMap(PgxCollection::getName, Function.identity())));
    }

    public PgxFuture<Void> renameAsync(String newGraphName) {
        return this.core.renameGraph(this.getSessionContext(), this.getId(), newGraphName).thenAccept(arg -> this.graphName.set(newGraphName));
    }

    public PgxFuture<Void> publishAsync() {
        return this.publishAsync(VertexProperty.NONE, EdgeProperty.NONE);
    }

    public PgxFuture<Void> publishAsync(Collection<VertexProperty<?, ?>> vertexProps, Collection<EdgeProperty<?>> edgeProps) {
        Collection<PgxId> vertexPropIds = oracle.pgx.api.Property.getIds(vertexProps);
        Collection<PgxId> edgePropIds = oracle.pgx.api.Property.getIds(edgeProps);
        return this.core.publish(this.getSessionContext(), this.getId(), vertexPropIds, edgePropIds);
    }

    public PgxFuture<Void> publishWithSnapshotsAsync() {
        return this.publishWithSnapshotsAsync(VertexProperty.NONE, EdgeProperty.NONE);
    }

    public PgxFuture<Void> publishWithSnapshotsAsync(Collection<VertexProperty<?, ?>> vertexProps, Collection<EdgeProperty<?>> edgeProps) {
        Collection<PgxId> vertexPropIds = oracle.pgx.api.Property.getIds(vertexProps);
        Collection<PgxId> edgePropIds = oracle.pgx.api.Property.getIds(edgeProps);
        return this.core.publishWithSnapshots(this.getSessionContext(), this.getId(), vertexPropIds, edgePropIds);
    }

    public PgxFuture<Boolean> isPublishedAsync() {
        return this.core.isPublished(this.getSessionContext(), this.getId());
    }

    public PgxFuture<Boolean> isPublishedWithSnapshotsAsync() {
        return this.core.isPublishedWithSnapshots(this.getSessionContext(), this.getId());
    }

    public PgxFuture<PgxResourcePermission> getPermissionAsync() {
        return this.core.getPermission(this.getSessionContext(), this.getId());
    }

    public PgxFuture<Void> grantPermissionAsync(PgxUser user, PgxResourcePermission permission) {
        this.validateResourcePermission(permission);
        return this.core.grantPermission(this.getSessionContext(), this.getId(), user, permission);
    }

    public PgxFuture<Void> grantPermissionAsync(PgxRole role, PgxResourcePermission permission) {
        this.validateResourcePermission(permission);
        return this.core.grantPermission(this.getSessionContext(), this.getId(), role, permission);
    }

    private void validateResourcePermission(PgxResourcePermission permission) {
        switch (permission) {
            case READ: 
            case EXPORT: 
            case MANAGE: {
                return;
            }
        }
        throw new IllegalArgumentException(ErrorMessages.getMessage((String)"AUTH_INVALID_GRAPH_PERMISSION", (Object[])new Object[]{permission, PgxResourcePermission.READ, PgxResourcePermission.EXPORT, PgxResourcePermission.MANAGE}));
    }

    public PgxFuture<Void> revokePermissionAsync(PgxUser user) {
        return this.core.revokePermission(this.getSessionContext(), this.getId(), user);
    }

    public PgxFuture<Void> revokePermissionAsync(PgxRole role) {
        return this.core.revokePermission(this.getSessionContext(), this.getId(), role);
    }

    public PgxFuture<Void> pinAsync() {
        return this.core.setPinned(this.getSessionContext(), this.getId(), CoreGraphPersistenceApi.PinTarget.GRAPH, true);
    }

    public PgxFuture<Void> unpinAsync() {
        return this.core.setPinned(this.getSessionContext(), this.getId(), CoreGraphPersistenceApi.PinTarget.GRAPH, false);
    }

    public PgxFuture<Boolean> isPinnedAsync() {
        return this.core.isPinned(this.getSessionContext(), this.getId(), CoreGraphPersistenceApi.PinTarget.GRAPH);
    }

    public String toString() {
        return this.toString(PgxGraph.entry("name", this.getName()), PgxGraph.entry("N", this.getNumVertices()), PgxGraph.entry("E", this.getNumEdges()), PgxGraph.entry("created", this.getCreationTimestamp()));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        PgxGraph other = (PgxGraph)obj;
        return this.getId().equals((Object)other.getId());
    }

    @Override
    public int hashCode() {
        return this.getId().hashCode();
    }

    public <ID> PgxVertex<ID> getRandomVertex() {
        return this.getRandomVertexAsync().join();
    }

    public PgxEdge getRandomEdge() {
        return this.getRandomEdgeAsync().join();
    }

    public boolean hasVertexLabels() {
        return this.hasVertexLabelsAsync().join();
    }

    public <ID> VertexLabels<ID> getVertexLabels() {
        return this.getVertexLabelsAsync().join();
    }

    public EdgeLabel getEdgeLabel() {
        return this.getEdgeLabelAsync().join();
    }

    public boolean hasEdgeLabel() {
        return this.hasEdgeLabelAsync().join();
    }

    public Set<VertexProperty<?, ?>> getVertexProperties() {
        return this.getVertexPropertiesAsync().join();
    }

    public Set<EdgeProperty<?>> getEdgeProperties() {
        return this.getEdgePropertiesAsync().join();
    }

    public <ID, V> VertexProperty<ID, V> getVertexProperty(String name) {
        return this.getVertexPropertyAsync(name).join();
    }

    public <V> EdgeProperty<V> getEdgeProperty(String name) {
        return this.getEdgePropertyAsync(name).join();
    }

    public <ID, V> VertexProperty<ID, V> getVertexProperty(Namespace namespace, String name) {
        return this.getVertexPropertyAsync(namespace, name).join();
    }

    public <V> EdgeProperty<V> getEdgeProperty(Namespace namespace, String name) {
        return this.getEdgePropertyAsync(namespace, name).join();
    }

    public FileGraphConfig store(Format targetFormat, String targetPath) throws ExecutionException, InterruptedException {
        return this.storeAsync(targetFormat, targetPath).get();
    }

    public PartitionedGraphConfig store(ProviderFormat targetFormat, String targetBasePath) throws ExecutionException, InterruptedException {
        return this.storeAsync(targetFormat, targetBasePath).get();
    }

    public PartitionedGraphConfig store(ProviderFormat targetFormat, String targetBasePath, Set<String> vertexProvidersToStore, Set<String> edgeProvidersToStore) throws ExecutionException, InterruptedException {
        return this.storeAsync(targetFormat, targetBasePath, vertexProvidersToStore, edgeProvidersToStore).get();
    }

    public FileGraphConfig store(Format targetFormat, String targetPath, boolean overwrite) throws ExecutionException, InterruptedException {
        return this.storeAsync(targetFormat, targetPath, overwrite).get();
    }

    public PartitionedGraphConfig store(ProviderFormat targetFormat, String targetBasePath, boolean overwrite) throws ExecutionException, InterruptedException {
        return this.storeAsync(targetFormat, targetBasePath, overwrite).get();
    }

    public PartitionedGraphConfig store(ProviderFormat targetFormat, String targetBasePath, Set<String> vertexProvidersToStore, Set<String> edgeProvidersToStore, boolean overwrite) throws ExecutionException, InterruptedException {
        return this.storeAsync(targetFormat, targetBasePath, vertexProvidersToStore, edgeProvidersToStore, overwrite).get();
    }

    public FileGraphConfig store(Format targetFormat, String targetPath, Collection<VertexProperty<?, ?>> vertexProps, Collection<EdgeProperty<?>> edgeProps, boolean overwrite) throws ExecutionException, InterruptedException {
        return this.storeAsync(targetFormat, targetPath, vertexProps, edgeProps, overwrite).get();
    }

    public PartitionedGraphConfig store(ProviderFormat targetFormat, String targetBasePath, Collection<VertexProperty<?, ?>> vertexProps, Collection<EdgeProperty<?>> edgeProps, boolean overwrite) throws ExecutionException, InterruptedException {
        return this.storeAsync(targetFormat, targetBasePath, vertexProps, edgeProps, overwrite).get();
    }

    public PartitionedGraphConfig store(ProviderFormat targetFormat, String targetBasePath, Set<String> vertexProvidersToStore, Set<String> edgeProvidersToStore, Collection<VertexProperty<?, ?>> vertexProps, Collection<EdgeProperty<?>> edgeProps, boolean overwrite) throws ExecutionException, InterruptedException {
        return this.storeAsync(targetFormat, targetBasePath, vertexProvidersToStore, edgeProvidersToStore, vertexProps, edgeProps, overwrite).get();
    }

    public FileGraphConfig store(Format targetFormat, String targetBasePath, int numPartitions) throws ExecutionException, InterruptedException {
        return this.storeAsync(targetFormat, targetBasePath, numPartitions).get();
    }

    public PartitionedGraphConfig store(ProviderFormat targetFormat, String targetBasePath, int numPartitions) throws ExecutionException, InterruptedException {
        return this.storeAsync(targetFormat, targetBasePath, numPartitions).get();
    }

    public PartitionedGraphConfig store(ProviderFormat targetFormat, String targetBasePath, int numPartitions, Set<String> vertexProvidersToStore, Set<String> edgeProvidersToStore) throws ExecutionException, InterruptedException {
        return this.storeAsync(targetFormat, targetBasePath, numPartitions, vertexProvidersToStore, edgeProvidersToStore).get();
    }

    public FileGraphConfig store(Format targetFormat, String targetBasePath, int numPartitions, boolean overwrite) throws ExecutionException, InterruptedException {
        return this.storeAsync(targetFormat, targetBasePath, numPartitions, overwrite).get();
    }

    public PartitionedGraphConfig store(ProviderFormat targetFormat, String targetBasePath, int numPartitions, boolean overwrite) throws ExecutionException, InterruptedException {
        return this.storeAsync(targetFormat, targetBasePath, numPartitions, overwrite).get();
    }

    public PartitionedGraphConfig store(ProviderFormat targetFormat, String targetBasePath, int numPartitions, Set<String> vertexProvidersToStore, Set<String> edgeProvidersToStore, boolean overwrite) throws ExecutionException, InterruptedException {
        return this.storeAsync(targetFormat, targetBasePath, numPartitions, vertexProvidersToStore, edgeProvidersToStore, overwrite).get();
    }

    public FileGraphConfig store(Format targetFormat, String targetBasePath, int numPartitions, Collection<VertexProperty<?, ?>> vertexProps, Collection<EdgeProperty<?>> edgeProps, boolean overwrite) throws ExecutionException, InterruptedException {
        return this.storeAsync(targetFormat, targetBasePath, numPartitions, vertexProps, edgeProps, overwrite).get();
    }

    public PartitionedGraphConfig store(ProviderFormat targetFormat, String targetBasePath, int numPartitions, Collection<VertexProperty<?, ?>> vertexProps, Collection<EdgeProperty<?>> edgeProps, boolean overwrite) throws ExecutionException, InterruptedException {
        return this.storeAsync(targetFormat, targetBasePath, numPartitions, vertexProps, edgeProps, overwrite).get();
    }

    public PartitionedGraphConfig store(ProviderFormat targetFormat, String targetBasePath, int numPartitions, Set<String> vertexProvidersToStore, Set<String> edgeProvidersToStore, Collection<VertexProperty<?, ?>> vertexProps, Collection<EdgeProperty<?>> edgeProps, boolean overwrite) throws ExecutionException, InterruptedException {
        return this.storeAsync(targetFormat, targetBasePath, numPartitions, vertexProvidersToStore, edgeProvidersToStore, vertexProps, edgeProps, overwrite).get();
    }

    public FileGraphConfig store(Format targetFormat, FileGraphStoringConfig storingConfig) throws ExecutionException, InterruptedException {
        return this.storeAsync(targetFormat, storingConfig).get();
    }

    public PartitionedGraphConfig store(ProviderFormat targetFormat, Map<String, FileGraphStoringConfig> vertexStoringConfigs, Map<String, FileGraphStoringConfig> edgeStoringConfigs) throws ExecutionException, InterruptedException {
        return this.storeAsync(targetFormat, vertexStoringConfigs, edgeStoringConfigs).get();
    }

    public FileGraphConfig store(Format targetFormat, FileGraphStoringConfig storingConfig, boolean overwrite) throws ExecutionException, InterruptedException {
        return this.storeAsync(targetFormat, storingConfig, overwrite).get();
    }

    public PartitionedGraphConfig store(ProviderFormat targetFormat, Map<String, FileGraphStoringConfig> vertexStoringConfigs, Map<String, FileGraphStoringConfig> edgeStoringConfigs, boolean overwrite) throws ExecutionException, InterruptedException {
        return this.storeAsync(targetFormat, vertexStoringConfigs, edgeStoringConfigs, overwrite).get();
    }

    public PartitionedGraphConfig store(ProviderFormat targetFormat, Set<String> vertexProvidersToStore, Set<String> edgeProvidersToStore, Map<String, FileGraphStoringConfig> vertexStoringConfigs, Map<String, FileGraphStoringConfig> edgeStoringConfigs, boolean overwrite) throws ExecutionException, InterruptedException {
        return this.storeAsync(targetFormat, vertexProvidersToStore, edgeProvidersToStore, vertexStoringConfigs, edgeStoringConfigs, overwrite).get();
    }

    public FileGraphConfig store(Format targetFormat, FileGraphStoringConfig storingConfig, Collection<VertexProperty<?, ?>> vertexProps, Collection<EdgeProperty<?>> edgeProps, boolean overwrite) throws ExecutionException, InterruptedException {
        return this.storeAsync(targetFormat, storingConfig, vertexProps, edgeProps, overwrite).get();
    }

    public PartitionedGraphConfig store(ProviderFormat targetFormat, Map<String, FileGraphStoringConfig> vertexStoringConfigs, Map<String, FileGraphStoringConfig> edgeStoringConfigs, Collection<VertexProperty<?, ?>> vertexProps, Collection<EdgeProperty<?>> edgeProps, boolean overwrite) throws ExecutionException, InterruptedException {
        return this.storeAsync(targetFormat, vertexStoringConfigs, edgeStoringConfigs, vertexProps, edgeProps, overwrite).get();
    }

    public PartitionedGraphConfig store(ProviderFormat targetFormat, Set<String> vertexProvidersToStore, Set<String> edgeProvidersToStore, Map<String, FileGraphStoringConfig> vertexStoringConfigs, Map<String, FileGraphStoringConfig> edgeStoringConfigs, Collection<VertexProperty<?, ?>> vertexProps, Collection<EdgeProperty<?>> edgeProps, boolean overwrite) throws ExecutionException, InterruptedException {
        return this.storeAsync(targetFormat, vertexProvidersToStore, edgeProvidersToStore, vertexStoringConfigs, edgeStoringConfigs, vertexProps, edgeProps, overwrite).get();
    }

    public GraphConfig store(GraphConfig targetConfig, boolean overwrite) throws ExecutionException, InterruptedException {
        return this.storeAsync(targetConfig, overwrite).get();
    }

    public GraphConfig store(GraphConfig targetConfig, Set<String> vertexProvidersToStore, Set<String> edgeProvidersToStore, boolean overwrite) throws ExecutionException, InterruptedException {
        return this.storeAsync(targetConfig, vertexProvidersToStore, edgeProvidersToStore, overwrite).get();
    }

    public boolean isFresh() throws ExecutionException, InterruptedException {
        return this.isFreshAsync().get();
    }

    public <T> Scalar<T> createScalar(PropertyType type, String newScalarName) {
        return this.createScalarAsync(type, newScalarName).join();
    }

    public <T> Scalar<T> createScalar(PropertyType type) {
        return this.createScalarAsync(type).join();
    }

    public <T> Scalar<PgxVect<T>> createVectorScalar(PropertyType type, int dimension, String newScalarName) {
        return this.createVectorScalarAsync(type, dimension, newScalarName).join();
    }

    public <T> Scalar<PgxVect<T>> createVectorScalar(PropertyType type, int dimension) {
        return this.createVectorScalarAsync(type, dimension).join();
    }

    public <ID, V> VertexProperty<ID, V> createVertexProperty(PropertyType type) {
        return this.createVertexPropertyAsync(type).join();
    }

    public <ID, V> VertexProperty<ID, V> createVertexProperty(PropertyType type, String name) {
        return this.createVertexPropertyAsync(type, name).join();
    }

    public <ID, V> VertexProperty<ID, V> getOrCreateVertexProperty(PropertyType type, String name) {
        return this.getOrCreateVertexPropertyAsync(type, name).join();
    }

    public <ID, V> VertexProperty<ID, V> createVertexProperty(PropertyType type, int dimension, String name, boolean hardName) {
        return this.createVertexPropertyAsync(type, dimension, name, hardName).join();
    }

    public <ID, V> VertexProperty<ID, PgxVect<V>> createVertexVectorProperty(PropertyType type, int dimension, String name) {
        return this.createVertexVectorPropertyAsync(type, dimension, name).join();
    }

    public <ID, V> VertexProperty<ID, PgxVect<V>> getOrCreateVertexVectorProperty(PropertyType type, int dimension, String name) {
        return this.getOrCreateVertexVectorPropertyAsync(type, dimension, name).join();
    }

    public <ID, V> VertexProperty<ID, PgxVect<V>> createVertexVectorProperty(PropertyType type, int dimension) {
        return this.createVertexVectorPropertyAsync(type, dimension).join();
    }

    public <V> EdgeProperty<V> createEdgeProperty(PropertyType type) {
        return this.createEdgePropertyAsync(type).join();
    }

    public <V> EdgeProperty<V> createEdgeProperty(PropertyType type, String name) {
        return this.createEdgePropertyAsync(type, name).join();
    }

    public <V> EdgeProperty<V> getOrCreateEdgeProperty(PropertyType type, String name) {
        return this.getOrCreateEdgePropertyAsync(type, name).join();
    }

    public <V> EdgeProperty<V> createEdgeProperty(PropertyType type, int dimension, String name, boolean hardName) {
        return this.createEdgePropertyAsync(type, dimension, name, hardName).join();
    }

    public <V> EdgeProperty<PgxVect<V>> createEdgeVectorProperty(PropertyType type, int dimension, String name) {
        return this.createEdgeVectorPropertyAsync(type, dimension, name).join();
    }

    public <V> EdgeProperty<PgxVect<V>> getOrCreateEdgeVectorProperty(PropertyType type, int dimension, String name) {
        return this.getOrCreateEdgeVectorPropertyAsync(type, dimension, name).join();
    }

    public <V> EdgeProperty<PgxVect<V>> createEdgeVectorProperty(PropertyType type, int dimension) {
        return this.createEdgeVectorPropertyAsync(type, dimension).join();
    }

    public <E> VertexSequence<E> createVertexSequence() {
        return this.createVertexSequenceAsync().join();
    }

    public <E> VertexSequence<E> createVertexSequence(String name) {
        return this.createVertexSequenceAsync(name).join();
    }

    public <E> VertexSet<E> createVertexSet() {
        return this.createVertexSetAsync().join();
    }

    public <E> VertexSet<E> createVertexSet(String name) {
        return this.createVertexSetAsync(name).join();
    }

    public EdgeSequence createEdgeSequence() {
        return this.createEdgeSequenceAsync().join();
    }

    public EdgeSequence createEdgeSequence(String name) {
        return this.createEdgeSequenceAsync(name).join();
    }

    public EdgeSet createEdgeSet() {
        return this.createEdgeSetAsync().join();
    }

    public EdgeSet createEdgeSet(String name) {
        return this.createEdgeSetAsync(name).join();
    }

    public <K, V> PgxMap<K, V> createMap(PropertyType keyType, PropertyType valType) {
        return this.createMapAsync(keyType, valType).join();
    }

    public <K, V> PgxMap<K, V> createMap(PropertyType keyType, PropertyType valType, String mapName) {
        return this.createMapAsync(keyType, valType, mapName).join();
    }

    public PgxGraph sortByDegree() throws ExecutionException, InterruptedException {
        return this.sortByDegreeAsync().get();
    }

    public PgxGraph sortByDegree(String newGraphName) throws ExecutionException, InterruptedException {
        return this.sortByDegreeAsync(newGraphName).get();
    }

    public PgxGraph sortByDegree(SortOrder sortOrder, Degree degree, Mode mode, String newGraphName) throws ExecutionException, InterruptedException {
        return this.sortByDegreeAsync(sortOrder, degree, mode, newGraphName).get();
    }

    public PgxGraph sortByDegree(Collection<VertexProperty<?, ?>> vertexProps, Collection<EdgeProperty<?>> edgeProps, SortOrder sortOrder, Degree degree, Mode mode, String newGraphName) throws ExecutionException, InterruptedException {
        return this.sortByDegreeAsync(vertexProps, edgeProps, sortOrder, degree, mode, newGraphName).get();
    }

    public PgxGraph transpose(Collection<VertexProperty<?, ?>> vertexProps, Collection<EdgeProperty<?>> edgeProps, Map<String, String> edgeLabelMapping, Mode mode, String newGraphName) throws ExecutionException, InterruptedException {
        return this.transposeAsync(vertexProps, edgeProps, edgeLabelMapping, mode, newGraphName).get();
    }

    public PgxGraph transpose(Mode mode, String newGraphName) throws ExecutionException, InterruptedException {
        return this.transposeAsync(mode, newGraphName).get();
    }

    public PgxGraph transpose(String newGraphName) throws ExecutionException, InterruptedException {
        return this.transposeAsync(newGraphName).get();
    }

    public PgxGraph transpose(Mode mode) throws ExecutionException, InterruptedException {
        return this.transposeAsync(mode).get();
    }

    public PgxGraph transpose() throws ExecutionException, InterruptedException {
        return this.transposeAsync().get();
    }

    PgxGraph transpose(MutationStrategy mutationStrategy) throws ExecutionException, InterruptedException {
        return this.transposeAsync(mutationStrategy).get();
    }

    public PgxGraph undirect() throws ExecutionException, InterruptedException {
        return this.undirectAsync().get();
    }

    public boolean isDirected() {
        return this.metaData.get().isDirected();
    }

    public PgxGraph undirect(String newGraphName) throws ExecutionException, InterruptedException {
        return this.undirectAsync(newGraphName).get();
    }

    public PgxGraph undirect(MultiEdges multiEdges, SelfEdges selfEdges, Mode mode, String newGraphName) throws ExecutionException, InterruptedException {
        return this.undirectAsync(multiEdges, selfEdges, mode, newGraphName).get();
    }

    public PgxGraph undirect(Collection<VertexProperty<?, ?>> vertexProps, Collection<EdgeProperty<?>> edgeProps, MultiEdges multiEdges, SelfEdges selfEdges, TrivialVertices trivialVertices, Mode mode, String newGraphName) throws ExecutionException, InterruptedException {
        return this.undirectAsync(vertexProps, edgeProps, multiEdges, selfEdges, mode, newGraphName).get();
    }

    private PgxGraph partitionByLabels() throws ExecutionException, InterruptedException {
        return this.partitionByLabels(GENERATE_NAME);
    }

    private PgxGraph partitionByLabels(String newGraphName) throws ExecutionException, InterruptedException {
        return this.partitionByLabelsAsync(newGraphName).get();
    }

    private PgxGraph partitionByLabels(PartitionizingStrategy partitionizingStrategy) throws ExecutionException, InterruptedException {
        return this.partitionByLabelsAsync(partitionizingStrategy).get();
    }

    public MergingStrategyBuilder createMergingStrategyBuilder() throws ExecutionException, InterruptedException {
        return new MergingStrategyBuilder(this);
    }

    public PickingStrategyBuilder createPickingStrategyBuilder() throws ExecutionException, InterruptedException {
        return new PickingStrategyBuilder(this);
    }

    private PartitionizingStrategyBuilder createPartitionWhileLoadingStrategyBuilder() throws ExecutionException, InterruptedException {
        return new PartitionizingStrategyBuilder(this);
    }

    public PgxGraph simplify() throws ExecutionException, InterruptedException {
        return this.simplifyAsync().get();
    }

    public PgxGraph simplify(MutationStrategy mutationStrategy) throws ExecutionException, InterruptedException {
        return this.simplifyAsync(mutationStrategy).get();
    }

    public PgxGraph simplify(String newGraphName) throws ExecutionException, InterruptedException {
        return this.simplifyAsync(newGraphName).get();
    }

    public PgxGraph simplify(MultiEdges multiEdges, SelfEdges selfEdges, TrivialVertices trivialVertices, Mode mode, String newGraphName) throws ExecutionException, InterruptedException {
        return this.simplifyAsync(multiEdges, selfEdges, trivialVertices, mode, newGraphName).get();
    }

    public PgxGraph simplify(Collection<VertexProperty<?, ?>> vertexProps, Collection<EdgeProperty<?>> edgeProps, MultiEdges multiEdges, SelfEdges selfEdges, TrivialVertices trivialVertices, Mode mode, String newGraphName) throws ExecutionException, InterruptedException {
        return this.simplifyAsync(vertexProps, edgeProps, multiEdges, selfEdges, trivialVertices, mode, newGraphName).get();
    }

    public BipartiteGraph bipartiteSubGraphFromLeftSet(VertexSet<?> vertexSet) throws ExecutionException, InterruptedException {
        return this.bipartiteSubGraphFromLeftSetAsync(vertexSet).get();
    }

    public BipartiteGraph bipartiteSubGraphFromLeftSet(VertexSet<?> vertexSet, String newGraphName) throws ExecutionException, InterruptedException {
        return this.bipartiteSubGraphFromLeftSetAsync(vertexSet, newGraphName).get();
    }

    public BipartiteGraph bipartiteSubGraphFromLeftSet(Collection<VertexProperty<?, ?>> vertexProps, Collection<EdgeProperty<?>> edgeProps, VertexSet<?> vertexSet, String newGraphName) throws ExecutionException, InterruptedException {
        return this.bipartiteSubGraphFromLeftSetAsync(vertexProps, edgeProps, vertexSet, newGraphName).get();
    }

    public BipartiteGraph bipartiteSubGraphFromLeftSet(Collection<VertexProperty<?, ?>> vertexProps, Collection<EdgeProperty<?>> edgeProps, VertexSet<?> vertexSet, String newGraphName, String isLeftPropName) throws ExecutionException, InterruptedException {
        return this.bipartiteSubGraphFromLeftSetAsync(vertexProps, edgeProps, vertexSet, newGraphName, isLeftPropName).get();
    }

    public BipartiteGraph bipartiteSubGraphFromInDegree() throws ExecutionException, InterruptedException {
        return this.bipartiteSubGraphFromInDegreeAsync().get();
    }

    public BipartiteGraph bipartiteSubGraphFromInDegree(String newGraphName) throws ExecutionException, InterruptedException {
        return this.bipartiteSubGraphFromInDegreeAsync(newGraphName).get();
    }

    public BipartiteGraph bipartiteSubGraphFromInDegree(Collection<VertexProperty<?, ?>> vertexProps, Collection<EdgeProperty<?>> edgeProps, String newGraphName) throws ExecutionException, InterruptedException {
        return this.bipartiteSubGraphFromInDegreeAsync(vertexProps, edgeProps, newGraphName).get();
    }

    public BipartiteGraph bipartiteSubGraphFromInDegree(Collection<VertexProperty<?, ?>> vertexProps, Collection<EdgeProperty<?>> edgeProps, String newGraphName, String isLeftPropName, boolean inPlace) throws ExecutionException, InterruptedException {
        return this.bipartiteSubGraphFromInDegreeAsync(vertexProps, edgeProps, newGraphName, isLeftPropName, inPlace).get();
    }

    public Boolean isBipartiteGraph(VertexProperty<?, Boolean> isLeft) throws ExecutionException, InterruptedException {
        return this.isBipartiteGraphAsync(isLeft).get();
    }

    public PgxGraph sparsify(double e) throws ExecutionException, InterruptedException {
        return this.sparsifyAsync(e).get();
    }

    public PgxGraph sparsify(double e, String newGraphName) throws ExecutionException, InterruptedException {
        return this.sparsifyAsync(e, newGraphName).get();
    }

    public PgxGraph sparsify(Collection<VertexProperty<?, ?>> vertexProps, Collection<EdgeProperty<?>> edgeProps, double e, String newGraphName) throws ExecutionException, InterruptedException {
        return this.sparsifyAsync(vertexProps, edgeProps, e, newGraphName).get();
    }

    public PgxGraph filter(GraphFilter graphFilter) throws ExecutionException, InterruptedException {
        return this.filterAsync(graphFilter).get();
    }

    public PgxGraph filter(GraphFilter graphFilter, String newGraphName) throws ExecutionException, InterruptedException {
        return this.filterAsync(graphFilter, newGraphName).get();
    }

    public PgxGraph filter(Collection<VertexProperty<?, ?>> vertexProps, Collection<EdgeProperty<?>> edgeProps, GraphFilter graphFilter, String newGraphName) throws ExecutionException, InterruptedException {
        return this.filterAsync(vertexProps, edgeProps, graphFilter, newGraphName).get();
    }

    public PgxGraph clone() {
        return this.cloneAsync().join();
    }

    public PgxGraph clone(String newGraphName) {
        return this.cloneAsync(newGraphName).join();
    }

    public PgxGraph clone(Collection<VertexProperty<?, ?>> vertexProps, Collection<EdgeProperty<?>> edgeProps, String newGraphName) {
        return this.cloneAsync(vertexProps, edgeProps, newGraphName).join();
    }

    public <ID> PgxPath<ID> createPath(PgxVertex<ID> src, PgxVertex<ID> dst, EdgeProperty<Double> cost, VertexProperty<ID, PgxVertex<ID>> parent, VertexProperty<ID, PgxEdge> parentEdge) {
        return this.createPathAsync(src, dst, cost, parent, parentEdge).join();
    }

    public <ID> AllPaths<ID> createAllPaths(PgxVertex<ID> src, EdgeProperty<Double> cost, VertexProperty<ID, Double> dist, VertexProperty<ID, PgxVertex<ID>> parent, VertexProperty<ID, PgxEdge> parentEdge) {
        return this.createAllPathsAsync(src, cost, dist, parent, parentEdge).join();
    }

    public <ID> Partition<ID> createComponents(VertexProperty<ID, Long> components, long numComponents) {
        return this.createComponentsAsync(components, numComponents).join();
    }

    public <E> VertexSet<E> getVertices(VertexFilter filter) throws InterruptedException, ExecutionException {
        return this.getVerticesAsync(filter).get();
    }

    public <E> VertexSet<E> getVertices(VertexFilter filter, String name) throws InterruptedException, ExecutionException {
        return this.getVerticesAsync(filter, name).get();
    }

    public <E> VertexSet<E> getVertices() {
        return this.getVerticesAsync().join();
    }

    public EdgeSet getEdges(EdgeFilter filter) throws InterruptedException, ExecutionException {
        return this.getEdgesAsync(filter).get();
    }

    public EdgeSet getEdges(EdgeFilter filter, String name) throws InterruptedException, ExecutionException {
        return this.getEdgesAsync(filter, name).get();
    }

    public EdgeSet getEdges() {
        return this.getEdgesAsync().join();
    }

    public PgqlResultSet queryPgql(String pgqlString) throws ExecutionException, InterruptedException {
        return this.queryPgqlAsync(pgqlString).get();
    }

    private PgqlResultSet queryPgql(String pgqlString, List<PgqlOption> pgqlOptions) throws ExecutionException, InterruptedException {
        return this.queryPgqlAsync(pgqlString, pgqlOptions).get();
    }

    public PgqlResultSet executePgql(String pgqlString) throws ExecutionException, InterruptedException {
        return this.executePgqlAsync(pgqlString).get();
    }

    public PgxGraph cloneAndExecutePgql(String pgqlString) throws ExecutionException, InterruptedException {
        return this.cloneAndExecutePgqlAsync(pgqlString).get();
    }

    public PgxGraph cloneAndExecutePgql(String pgqlString, String graphName) throws ExecutionException, InterruptedException {
        return this.cloneAndExecutePgqlAsync(pgqlString, graphName).get();
    }

    public PgxPreparedStatement preparePgql(String pgqlString) {
        return this.preparePgqlAsync(pgqlString).join();
    }

    public Operation explainPgql(String pgqlString) throws ExecutionException, InterruptedException {
        return this.explainPgqlAsync(pgqlString).get();
    }

    public <ID> PgxVertex<ID> getVertex(ID id) {
        id = ConversionHelper.tryCastIntegerToLong(id, (IdType)this.getVertexIdType());
        return this.getVertexAsync(id).join();
    }

    public PgxEdge getEdge(long id) {
        return this.getEdgeAsync(id).join();
    }

    public PgxEdge getEdge(String id) {
        return this.getEdgeAsync(id).join();
    }

    public <ID> boolean hasVertex(ID id) {
        id = ConversionHelper.tryCastIntegerToLong(id, (IdType)this.getVertexIdType());
        return this.hasVertexAsync(id).join();
    }

    public boolean hasEdge(long id) {
        return this.hasEdgeAsync(id).join();
    }

    public boolean hasEdge(String id) {
        return this.hasEdgeAsync(id).join();
    }

    public <ID, V> VertexProperty<ID, PgxVect<V>> combineVertexPropertiesIntoVectorProperty(List<VertexProperty<ID, V>> vertexPropertyList) throws ExecutionException, InterruptedException {
        return this.combineVertexPropertiesIntoVectorPropertyAsync(vertexPropertyList).get();
    }

    public <ID, V> VertexProperty<ID, PgxVect<V>> combineVertexPropertiesIntoVectorProperty(List<VertexProperty<ID, V>> vertexPropertyList, String name) throws ExecutionException, InterruptedException {
        return this.combineVertexPropertiesIntoVectorPropertyAsync(vertexPropertyList, name).get();
    }

    public <E> EdgeProperty<PgxVect<E>> combineEdgePropertiesIntoVectorProperty(List<EdgeProperty<E>> edgePropertyList) throws ExecutionException, InterruptedException {
        return this.combineEdgePropertiesIntoVectorPropertyAsync(edgePropertyList).get();
    }

    public <E> EdgeProperty<PgxVect<E>> combineEdgePropertiesIntoVectorProperty(List<EdgeProperty<E>> edgePropertyList, String name) throws ExecutionException, InterruptedException {
        return this.combineEdgePropertiesIntoVectorPropertyAsync(edgePropertyList, name).get();
    }

    public Map<String, PgxCollection<? extends PgxEntity<?>, ?>> getCollections() {
        return this.getCollectionsAsync().join();
    }

    public void publish(Collection<VertexProperty<?, ?>> vertexProps, Collection<EdgeProperty<?>> edgeProps) {
        this.publishAsync(vertexProps, edgeProps).join();
    }

    public void rename(String newGraphName) {
        this.renameAsync(newGraphName).join();
    }

    public void publish() {
        this.publishAsync().join();
    }

    public void publishWithSnapshots() {
        this.publishWithSnapshotsAsync().join();
    }

    public void publishWithSnapshots(Collection<VertexProperty<?, ?>> vertexProps, Collection<EdgeProperty<?>> edgeProps) {
        this.publishWithSnapshotsAsync(vertexProps, edgeProps).join();
    }

    public boolean isPublished() {
        return this.isPublishedAsync().join();
    }

    public boolean isPublishedWithSnapshots() {
        return this.isPublishedWithSnapshotsAsync().join();
    }

    @Override
    public void destroy() {
        this.destroyAsync().join();
    }

    @Deprecated
    public void destroy(Retention retention) {
        this.core.destroyGraphWithProperties(this.getSessionContext(), this.getId(), false, retention).join();
    }

    public void destroyVertexPropertyIfExists(String name) {
        this.destroyVertexPropertyIfExistsAsync(name).join();
    }

    public void destroyEdgePropertyIfExists(String name) {
        this.destroyEdgePropertyIfExistsAsync(name).join();
    }

    public PgxResourcePermission getPermission() {
        return this.getPermissionAsync().join();
    }

    public void grantPermission(PgxUser user, PgxResourcePermission permission) {
        this.grantPermissionAsync(user, permission).join();
    }

    public void grantPermission(PgxRole role, PgxResourcePermission permission) {
        this.grantPermissionAsync(role, permission).join();
    }

    public void revokePermission(PgxUser user) {
        this.revokePermissionAsync(user).join();
    }

    public void revokePermission(PgxRole role) {
        this.revokePermissionAsync(role).join();
    }

    private SessionContext getSessionContext() {
        return this.session.getSessionContext();
    }

    public <T extends Synchronizer> Synchronizer createSynchronizer(Class<T> type) throws SQLException {
        return new Synchronizer.Builder<T>().setType(type).setGraph(this).build();
    }

    public <T extends Synchronizer> Synchronizer createSynchronizer(Class<T> type, Connection conn) throws SQLException {
        return new Synchronizer.Builder<T>().setType(type).setGraph(this).setConnection(conn).build();
    }

    public <T extends Synchronizer> Synchronizer createSynchronizer(Class<T> type, Connection conn, OnInvalidChange invalidChangePolicy) throws SQLException {
        return new Synchronizer.Builder<T>().setType(type).setInvalidChangePolicy(invalidChangePolicy).setGraph(this).setConnection(conn).build();
    }

    public void pin() {
        this.pinAsync().join();
    }

    public void unpin() {
        this.unpinAsync().join();
    }

    public boolean isPinned() {
        return this.isPinnedAsync().join();
    }

    @Deprecated
    public static enum Retention {
        KEEP_GRAPH,
        DESTROY_IF_NOT_USED;

    }

    public static enum TrivialVertices {
        KEEP_TRIVIAL_VERTICES,
        REMOVE_TRIVIAL_VERTICES;

    }

    public static enum MultiEdges {
        KEEP_MULTI_EDGES,
        REMOVE_MULTI_EDGES;

    }

    public static enum SelfEdges {
        KEEP_SELF_EDGES,
        REMOVE_SELF_EDGES;

    }

    public static enum Mode {
        CREATE_COPY,
        MUTATE_IN_PLACE;

    }

    public static enum Degree {
        IN,
        OUT;

    }

    public static enum SortOrder {
        ASCENDING,
        DESCENDING;

    }
}

