/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.expansion.internal;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import oracle.pgx.api.expansion.PropertyMergeStrategy;
import oracle.pgx.api.expansion.internal.GraphExpansionConfig;
import oracle.pgx.common.pojo.ObfuscatedGraphConfigDeserializer;
import oracle.pgx.common.pojo.ObfuscatedGraphConfigSerializer;
import oracle.pgx.config.PartitionedGraphConfig;
import oracle.pgx.config.PartitionedGraphConfigBuilder;
import oracle.pgx.config.PreparedQueryConfig;
import oracle.pgx.config.SnapshotsSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude
public class PgqlGraphExpansionConfig
extends GraphExpansionConfig {
    private static final Logger LOG = LoggerFactory.getLogger(PgqlGraphExpansionConfig.class);
    private final PartitionedGraphConfig graphConfig;
    private final PartitionedGraphConfig expansionConfig;
    private final List<String> queries;
    private final List<PreparedQueryConfig> preparedQueries;

    @JsonCreator
    public PgqlGraphExpansionConfig(@JsonProperty(value="graphName") String newGraphName, @Nullable @JsonDeserialize(using=ObfuscatedGraphConfigDeserializer.class) @JsonProperty(value="graphConfig") PartitionedGraphConfig graphConfig, @JsonDeserialize(using=ObfuscatedGraphConfigDeserializer.class) @JsonProperty(value="expansionConfig") PartitionedGraphConfig expansionConfig, @JsonProperty(value="queries") List<String> queries, @JsonProperty(value="preparedQueries") Collection<Map<String, Object>> preparedQueries, @Deprecated @Nullable @JsonProperty(value="pgViewName") String pgViewName, @JsonProperty(value="asSnapshot") boolean asSnapshot, @JsonProperty(value="vertexPropertyMergeStrategy") PropertyMergeStrategy vertexPropertyMergeStrategy, @JsonProperty(value="edgePropertyMergeStrategy") PropertyMergeStrategy edgePropertyMergeStrategy) {
        super(newGraphName, GraphExpansionConfig.GraphExpansionType.PGQL_EXPANSION, asSnapshot, vertexPropertyMergeStrategy, edgePropertyMergeStrategy);
        this.graphConfig = graphConfig;
        if (expansionConfig == null) {
            LOG.debug("Expansion config not specified, using base config for expansion");
        }
        this.expansionConfig = expansionConfig == null ? graphConfig : expansionConfig;
        this.queries = queries;
        this.preparedQueries = new ArrayList<PreparedQueryConfig>();
        if (preparedQueries != null) {
            for (Map<String, Object> preparedQueryData : preparedQueries) {
                this.preparedQueries.add(PreparedQueryConfig.parse(preparedQueryData, (boolean)true, null));
            }
        }
    }

    public PgqlGraphExpansionConfig(String newGraphName, PartitionedGraphConfig graphConfig, PartitionedGraphConfig expansionConfig, List<String> queries, List<PreparedQueryConfig> preparedQueries, boolean asSnapshot, PropertyMergeStrategy vertexPropertyMergeStrategy, PropertyMergeStrategy edgePropertyMergeStrategy) {
        super(newGraphName, GraphExpansionConfig.GraphExpansionType.PGQL_EXPANSION, asSnapshot, vertexPropertyMergeStrategy, edgePropertyMergeStrategy);
        this.graphConfig = graphConfig;
        this.expansionConfig = expansionConfig;
        this.queries = queries;
        this.preparedQueries = preparedQueries;
    }

    @JsonProperty(value="queries")
    public List<String> getQueries() {
        return this.queries;
    }

    @JsonProperty(value="preparedQueries")
    public List<PreparedQueryConfig> getPreparedQueries() {
        return this.preparedQueries;
    }

    @JsonSerialize(using=ObfuscatedGraphConfigSerializer.class)
    @JsonProperty(value="graphConfig")
    public PartitionedGraphConfig getGraphConfig() {
        return this.graphConfig;
    }

    @JsonSerialize(using=ObfuscatedGraphConfigSerializer.class)
    @JsonProperty(value="expansionConfig")
    public PartitionedGraphConfig getExpansionGraphConfig() {
        return this.expansionConfig;
    }

    @JsonIgnore
    public PartitionedGraphConfig createConfigForExpansion() {
        PartitionedGraphConfig graphConfig = this.getExpansionGraphConfig();
        PartitionedGraphConfigBuilder builder = new PartitionedGraphConfigBuilder().copyFrom(this.getExpansionGraphConfig());
        if (this.asSnapshot) {
            builder.setSnapshotsSource(SnapshotsSource.CHANGE_SET);
        }
        HashSet<String> queries = new HashSet<String>(graphConfig.getQueries() == null ? Collections.emptyList() : graphConfig.getQueries());
        queries.addAll(this.getQueries());
        builder.setQueries(new ArrayList(queries));
        HashSet<PreparedQueryConfig> preparedQueries = new HashSet<PreparedQueryConfig>(graphConfig.getPreparedQueries() == null ? Collections.emptyList() : graphConfig.getPreparedQueries());
        preparedQueries.addAll(this.getPreparedQueries());
        builder.setPreparedQueries(new ArrayList(preparedQueries));
        return (PartitionedGraphConfig)builder.build();
    }
}

