/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.marshalers;

import com.fasterxml.jackson.databind.JavaType;
import java.io.IOException;
import java.lang.reflect.Type;
import oracle.pgx.api.internal.Edge;
import oracle.pgx.api.internal.Vertex;
import oracle.pgx.common.marshalers.Marshaler;
import oracle.pgx.common.pojo.PropertyTypedObject;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.types.internal.PropertyTypeUtils;
import oracle.pgx.common.util.JsonUtil;

public class PropertyTypedObjectMarshaler<V>
implements Marshaler<V> {
    @Override
    public V unmarshal(String jsonString) throws IOException {
        if (jsonString == null || jsonString.isEmpty()) {
            return null;
        }
        PropertyTypedObject typedObject = (PropertyTypedObject)JsonUtil.readTopLevelJson((String)jsonString, PropertyTypedObject.class);
        Object object = this.getUntypedItem(typedObject.value, (PropertyType)typedObject.type);
        return (V)object;
    }

    private Object getUntypedItem(String jsonObject, PropertyType propertyType) throws IOException {
        if (propertyType != null) {
            JavaType itemClass = propertyType == PropertyType.VERTEX ? JsonUtil.getTypeFactory().constructType(Vertex.class) : (propertyType == PropertyType.EDGE ? JsonUtil.getTypeFactory().constructType(Edge.class) : JsonUtil.getTypeFactory().constructType((Type)propertyType.getTypeClass()));
            return JsonUtil.readTopLevelJson((String)jsonObject, (JavaType)itemClass);
        }
        return null;
    }

    @Override
    public String marshal(V object) throws IOException {
        if (object == null) {
            return null;
        }
        PropertyType objectType = PropertyTypeUtils.getElementPropertyType(object);
        PropertyTypedObject typedObject = new PropertyTypedObject(objectType, JsonUtil.toJson(object));
        return JsonUtil.toJson((Object)typedObject);
    }
}

