/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import com.fasterxml.jackson.annotation.JsonValue;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import oracle.pgx.common.types.IdStrategy;
import oracle.pgx.common.types.IdType;
import oracle.pgx.common.util.ConfigJsonUtil;
import oracle.pgx.config.AbstractConfig;
import oracle.pgx.config.AbstractPgRdbmsGraphConfig;
import oracle.pgx.config.ConfigField;
import oracle.pgx.config.ConfigParser;
import oracle.pgx.config.DbEngine;
import oracle.pgx.config.ExternalStoreConfig;
import oracle.pgx.config.Format;
import oracle.pgx.config.GraphErrorHandlingConfig;
import oracle.pgx.config.GraphLoadingConfig;
import oracle.pgx.config.GraphOptimizedFor;
import oracle.pgx.config.GraphPropertyConfig;
import oracle.pgx.config.ParseResult;
import oracle.pgx.config.PartitionWhileLoading;
import oracle.pgx.config.PropertiesConfigParser;

public class PgRdbmsGraphConfig
extends AbstractPgRdbmsGraphConfig {
    private final Map<Field, Object> values;
    private final Set<Field> defaults;
    private final Map<String, Object> leftoverValues;

    public static PgRdbmsGraphConfig parse(InputStream is, boolean strict, String parentPath) throws IOException {
        return PgRdbmsGraphConfig.parse(ConfigParser.parseRaw(is), strict, parentPath);
    }

    static PgRdbmsGraphConfig parse(InputStream is, boolean strict, String parentPath, boolean parseHiddenValues) throws IOException {
        return PgRdbmsGraphConfig.parse(ConfigParser.parseRaw(is), strict, parentPath, parseHiddenValues);
    }

    public static PgRdbmsGraphConfig parse(Map<String, Object> raw, boolean strict, String parentPath) {
        ParseResult pr = ConfigParser.parse(raw, (ConfigField[])Field.values(), (boolean)strict, (String)parentPath);
        return new PgRdbmsGraphConfig(pr.getValues(), raw, pr.getDefaults());
    }

    static PgRdbmsGraphConfig parse(Map<String, Object> raw, boolean strict, String parentPath, boolean parseHiddenValues) {
        ParseResult pr = ConfigParser.parse(raw, (ConfigField[])Field.values(), (boolean)strict, (String)parentPath, (boolean)parseHiddenValues);
        return new PgRdbmsGraphConfig(pr.getValues(), raw, pr.getDefaults());
    }

    public static PgRdbmsGraphConfig parse(Properties props, boolean strict) {
        ParseResult pr = PropertiesConfigParser.parse((Properties)props, (ConfigField[])Field.values(), (boolean)strict);
        return new PgRdbmsGraphConfig(pr.getValues(), null, pr.getDefaults());
    }

    public static Field[] getConfigFields() {
        return Field.values();
    }

    protected PgRdbmsGraphConfig(Map<Field, Object> values, Map<String, Object> leftoverValues, Set<Field> defaults) {
        this.values = values;
        this.leftoverValues = leftoverValues == null ? Collections.emptyMap() : leftoverValues;
        this.defaults = defaults;
        this.initialize();
    }

    public Map<Field, Object> getValues() {
        return this.values;
    }

    public boolean isEmpty() {
        return this.getValuesWithoutDefaults().isEmpty();
    }

    public boolean hasDefaultValue(Field field) {
        return this.defaults.contains(field);
    }

    @JsonValue
    public Map<Field, Object> getValuesWithoutDefaults() {
        HashMap<Field, Object> valuesWithoutDefaults = new HashMap<Field, Object>(this.values);
        for (Field field : this.defaults) {
            valuesWithoutDefaults.remove(field);
        }
        return valuesWithoutDefaults;
    }

    public Map<String, Object> getLeftoverValues() {
        return this.leftoverValues;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean hideSensitiveData) {
        if (!this.canSerialize()) {
            throw new UnsupportedOperationException("some objects part of this config cannot be serialized");
        }
        try {
            Object configValues = hideSensitiveData ? this.hiddenSensitiveData() : this;
            return ConfigJsonUtil.toJson(configValues);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private final Map<Field, Object> hiddenSensitiveData() {
        HashMap<Field, Object> hiddenValues = new HashMap<Field, Object>(this.getValuesWithoutDefaults());
        for (Field f : this.values.keySet()) {
            if (!f.isSensitive()) continue;
            hiddenValues.put(f, "*******");
        }
        return hiddenValues;
    }

    @Override
    public String getOwner() {
        return (String)this.values.get(Field.OWNER);
    }

    @Override
    public String getSecurityPolicy() {
        return (String)this.values.get(Field.SECURITY_POLICY);
    }

    @Override
    public String getLabel() {
        return (String)this.values.get(Field.LABEL);
    }

    @Override
    public String getRowLabel() {
        return (String)this.values.get(Field.ROW_LABEL);
    }

    public String getOptions() {
        return (String)this.values.get(Field.OPTIONS);
    }

    @Override
    public String getVerticesViewName() {
        return (String)this.values.get(Field.VERTICES_VIEW_NAME);
    }

    @Override
    public String getEdgesViewName() {
        return (String)this.values.get(Field.EDGES_VIEW_NAME);
    }

    public Integer getViewParallelHintDegree() {
        return (Integer)this.values.get(Field.VIEW_PARALLEL_HINT_DEGREE);
    }

    @Override
    public String getJdbcUrl() {
        return (String)this.values.get(Field.JDBC_URL);
    }

    @Override
    public String getUsername() {
        return (String)this.values.get(Field.USERNAME);
    }

    @Override
    public String getDataSourceId() {
        return (String)this.values.get(Field.DATA_SOURCE_ID);
    }

    @Override
    public Integer getMaxPrefetchedRows() {
        return (Integer)this.values.get(Field.MAX_PREFETCHED_ROWS);
    }

    @Override
    public DbEngine getDbEngine() {
        return (DbEngine)((Object)this.values.get(Field.DB_ENGINE));
    }

    @Override
    public String getName() {
        return (String)this.values.get(Field.NAME);
    }

    @Override
    public Integer getMaxNumConnections() {
        return (Integer)this.values.get(Field.MAX_NUM_CONNECTIONS);
    }

    @Override
    public GraphOptimizedFor getOptimizedFor() {
        return (GraphOptimizedFor)((Object)this.values.get(Field.OPTIMIZED_FOR));
    }

    @Override
    public PartitionWhileLoading getPartitionWhileLoading() {
        return (PartitionWhileLoading)((Object)this.values.get(Field.PARTITION_WHILE_LOADING));
    }

    @Override
    public IdStrategy getVertexIdStrategy() {
        return (IdStrategy)this.values.get(Field.VERTEX_ID_STRATEGY);
    }

    @Override
    public IdStrategy getEdgeIdStrategy() {
        return (IdStrategy)this.values.get(Field.EDGE_ID_STRATEGY);
    }

    @Override
    public IdType getVertexIdType() {
        return (IdType)this.values.get(Field.VERTEX_ID_TYPE);
    }

    @Override
    public IdType getEdgeIdType() {
        return (IdType)this.values.get(Field.EDGE_ID_TYPE);
    }

    @Override
    public Format getFormat() {
        return (Format)((Object)this.values.get(Field.FORMAT));
    }

    @Override
    public Double getArrayCompactionThreshold() {
        return (Double)this.values.get(Field.ARRAY_COMPACTION_THRESHOLD);
    }

    @Override
    public List<GraphPropertyConfig> getVertexProps() {
        return (List)this.values.get(Field.VERTEX_PROPS);
    }

    @Override
    public List<GraphPropertyConfig> getEdgeProps() {
        return (List)this.values.get(Field.EDGE_PROPS);
    }

    @Override
    public GraphLoadingConfig getLoading() {
        return (GraphLoadingConfig)this.values.get(Field.LOADING);
    }

    @Override
    public List<ExternalStoreConfig> getExternalStores() {
        return (List)this.values.get(Field.EXTERNAL_STORES);
    }

    @Override
    public GraphErrorHandlingConfig getErrorHandling() {
        return (GraphErrorHandlingConfig)this.values.get(Field.ERROR_HANDLING);
    }

    @Override
    public List<String> getLocalDateFormat() {
        return (List)this.values.get(Field.LOCAL_DATE_FORMAT);
    }

    @Override
    public List<String> getTimeFormat() {
        return (List)this.values.get(Field.TIME_FORMAT);
    }

    @Override
    public List<String> getTimestampFormat() {
        return (List)this.values.get(Field.TIMESTAMP_FORMAT);
    }

    @Override
    public List<String> getTimeWithTimezoneFormat() {
        return (List)this.values.get(Field.TIME_WITH_TIMEZONE_FORMAT);
    }

    @Override
    public List<String> getTimestampWithTimezoneFormat() {
        return (List)this.values.get(Field.TIMESTAMP_WITH_TIMEZONE_FORMAT);
    }

    @Override
    public Character getVectorComponentDelimiter() {
        return (Character)this.values.get(Field.VECTOR_COMPONENT_DELIMITER);
    }

    public String getPoint2d() {
        return (String)this.values.get(Field.POINT2D);
    }

    @Override
    public Map getAttributes() {
        return (Map)this.values.get(Field.ATTRIBUTES);
    }

    @Override
    public String getKeystoreAlias() {
        return (String)this.values.get(Field.KEYSTORE_ALIAS);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PgRdbmsGraphConfig other = (PgRdbmsGraphConfig)obj;
        if (!Objects.equals(this.getOwner(), other.getOwner())) {
            return false;
        }
        if (!Objects.equals(this.getSecurityPolicy(), other.getSecurityPolicy())) {
            return false;
        }
        if (!Objects.equals(this.getLabel(), other.getLabel())) {
            return false;
        }
        if (!Objects.equals(this.getRowLabel(), other.getRowLabel())) {
            return false;
        }
        if (!Objects.equals(this.getOptions(), other.getOptions())) {
            return false;
        }
        if (!Objects.equals(this.getVerticesViewName(), other.getVerticesViewName())) {
            return false;
        }
        if (!Objects.equals(this.getEdgesViewName(), other.getEdgesViewName())) {
            return false;
        }
        if (!Objects.equals(this.getViewParallelHintDegree(), other.getViewParallelHintDegree())) {
            return false;
        }
        if (!Objects.equals(this.getJdbcUrl(), other.getJdbcUrl())) {
            return false;
        }
        if (!Objects.equals(this.getUsername(), other.getUsername())) {
            return false;
        }
        if (!Objects.equals(this.getDataSourceId(), other.getDataSourceId())) {
            return false;
        }
        if (!Objects.equals(this.getMaxPrefetchedRows(), other.getMaxPrefetchedRows())) {
            return false;
        }
        if (!Objects.equals((Object)this.getDbEngine(), (Object)other.getDbEngine())) {
            return false;
        }
        if (!Objects.equals(this.getName(), other.getName())) {
            return false;
        }
        if (!Objects.equals(this.getMaxNumConnections(), other.getMaxNumConnections())) {
            return false;
        }
        if (!Objects.equals((Object)this.getOptimizedFor(), (Object)other.getOptimizedFor())) {
            return false;
        }
        if (!Objects.equals((Object)this.getPartitionWhileLoading(), (Object)other.getPartitionWhileLoading())) {
            return false;
        }
        if (!Objects.equals(this.getValidatedVertexIdStrategy(), other.getValidatedVertexIdStrategy())) {
            return false;
        }
        if (!Objects.equals(this.getValidatedEdgeIdStrategy(), other.getValidatedEdgeIdStrategy())) {
            return false;
        }
        if (!Objects.equals(this.getValidatedVertexIdType(), other.getValidatedVertexIdType())) {
            return false;
        }
        if (!Objects.equals(this.getValidatedEdgeIdType(), other.getValidatedEdgeIdType())) {
            return false;
        }
        if (!Objects.equals((Object)this.getFormat(), (Object)other.getFormat())) {
            return false;
        }
        if (!Objects.equals(this.getArrayCompactionThreshold(), other.getArrayCompactionThreshold())) {
            return false;
        }
        if (!Objects.equals(this.getVertexProps(), other.getVertexProps())) {
            return false;
        }
        if (!Objects.equals(this.getEdgeProps(), other.getEdgeProps())) {
            return false;
        }
        if (!Objects.equals(this.getLoading(), other.getLoading())) {
            return false;
        }
        if (!Objects.equals(this.getExternalStores(), other.getExternalStores())) {
            return false;
        }
        if (!Objects.equals(this.getErrorHandling(), other.getErrorHandling())) {
            return false;
        }
        if (!Objects.equals(this.getLocalDateFormat(), other.getLocalDateFormat())) {
            return false;
        }
        if (!Objects.equals(this.getTimeFormat(), other.getTimeFormat())) {
            return false;
        }
        if (!Objects.equals(this.getTimestampFormat(), other.getTimestampFormat())) {
            return false;
        }
        if (!Objects.equals(this.getTimeWithTimezoneFormat(), other.getTimeWithTimezoneFormat())) {
            return false;
        }
        if (!Objects.equals(this.getTimestampWithTimezoneFormat(), other.getTimestampWithTimezoneFormat())) {
            return false;
        }
        if (!Objects.equals(this.getVectorComponentDelimiter(), other.getVectorComponentDelimiter())) {
            return false;
        }
        if (!Objects.equals(this.getPoint2d(), other.getPoint2d())) {
            return false;
        }
        if (!Objects.equals(this.getAttributes(), other.getAttributes())) {
            return false;
        }
        if (!Objects.equals(this.values.get(Field.PASSWORD), other.values.get(Field.PASSWORD))) {
            return false;
        }
        return Objects.equals(this.getKeystoreAlias(), other.getKeystoreAlias());
    }

    public static enum Field implements ConfigField
    {
        OWNER(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, false, false),
        SECURITY_POLICY(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, false, false),
        LABEL(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, false, false),
        ROW_LABEL(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, false, false),
        OPTIONS(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, false, false),
        VERTICES_VIEW_NAME(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, false, false),
        EDGES_VIEW_NAME(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, false, false),
        VIEW_PARALLEL_HINT_DEGREE(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 1, false, false, false, false),
        JDBC_URL(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, false, false),
        USERNAME(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, false, false),
        DATA_SOURCE_ID(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, false, false),
        MAX_PREFETCHED_ROWS(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 10000, false, false, false, false),
        DB_ENGINE(Collections.emptyList(), Collections.emptyList(), DbEngine.class, false, (Object)((Object)DbEngine.RDBMS), false, false, false, false),
        NAME(Collections.emptyList(), Collections.emptyList(), String.class, true, null, false, false, false, false),
        MAX_NUM_CONNECTIONS(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 8, false, false, false, false),
        OPTIMIZED_FOR(Collections.emptyList(), Collections.emptyList(), GraphOptimizedFor.class, false, (Object)((Object)GraphOptimizedFor.READ), false, false, false, false),
        PARTITION_WHILE_LOADING(Collections.emptyList(), Collections.emptyList(), PartitionWhileLoading.class, false, null, false, false, false, false),
        VERTEX_ID_STRATEGY(Collections.emptyList(), Collections.emptyList(), IdStrategy.class, false, null, false, false, false, false),
        EDGE_ID_STRATEGY(Collections.emptyList(), Collections.emptyList(), IdStrategy.class, false, null, false, false, false, false),
        VERTEX_ID_TYPE(Arrays.asList("node_id_type"), Collections.emptyList(), IdType.class, false, null, false, false, false, false),
        EDGE_ID_TYPE(Collections.emptyList(), Collections.emptyList(), IdType.class, false, null, false, false, false, false),
        FORMAT(Collections.emptyList(), Collections.emptyList(), Format.class, false, null, false, false, false, false),
        ARRAY_COMPACTION_THRESHOLD(Collections.emptyList(), Collections.emptyList(), Double.class, false, 0.2, false, false, false, false),
        VERTEX_PROPS(Arrays.asList("node_props"), Collections.emptyList(), GraphPropertyConfig.class, false, Collections.emptyList(), true, false, false, false),
        EDGE_PROPS(Collections.emptyList(), Collections.emptyList(), GraphPropertyConfig.class, false, Collections.emptyList(), true, false, false, false),
        LOADING(Arrays.asList("loading_options"), Collections.emptyList(), GraphLoadingConfig.class, false, Collections.emptyMap(), false, false, false, false),
        EXTERNAL_STORES(Collections.emptyList(), Collections.emptyList(), ExternalStoreConfig.class, false, Collections.emptyList(), true, false, false, false),
        ERROR_HANDLING(Collections.emptyList(), Collections.emptyList(), GraphErrorHandlingConfig.class, false, Collections.emptyMap(), false, false, false, false),
        LOCAL_DATE_FORMAT(Collections.emptyList(), Collections.emptyList(), String.class, false, Arrays.asList("yyyy-M[M]-d[d]", "M[M]/d[d]/yyyy", "d[d]-MMM-yyyy", "d[d]-M[M]-yyyy", "yyyy-MM-dd'T'H[H]:m[m][:s[s][.SSS[SSS]]][XXX]", "yyyy-MM-dd'T'H[H]:m[m][:s[s][.SSSSSS]][XXX]"), true, false, false, false),
        TIME_FORMAT(Collections.emptyList(), Collections.emptyList(), String.class, false, Arrays.asList("h[h]:m[m][:s[s][.SSS]] a[ XXX]", "[yyyy-MM-dd'T']H[H]:m[m][:s[s][.SSS[SSS]]][XXX]", "yyyy-MM-dd'T'H[H]:m[m][:s[s][.SSSSSS]][XXX]"), true, false, false, false),
        TIMESTAMP_FORMAT(Collections.emptyList(), Collections.emptyList(), String.class, false, Arrays.asList("yyyy-MM-dd'T'H[H]:m[m][:s[s][.SSS[SSS]]][XXX]", "yyyy-MM-dd H[H]:m[m][:s[s][.SSS[SSS]]][XXX]", "yyyy-MM-dd'T'H[H]:m[m][:s[s][.SSSSSS]][XXX]"), true, false, false, false),
        TIME_WITH_TIMEZONE_FORMAT(Collections.emptyList(), Collections.emptyList(), String.class, false, Arrays.asList("h[h]:m[m][:s[s]] a[ XXX]", "[yyyy-MM-dd'T']H[H]:m[m][:s[s][.SSS[SSS]]][XXX]", "yyyy-MM-dd'T'H[H]:m[m][:s[s][.SSSSSS]][XXX]"), true, false, false, false),
        TIMESTAMP_WITH_TIMEZONE_FORMAT(Collections.emptyList(), Collections.emptyList(), String.class, false, Arrays.asList("yyyy-MM-dd'T'H[H]:m[m][:s[s][.SSS[SSS]]][XXX]", "yyyy-MM-dd H[H]:m[m][:s[s][.SSS[SSS]]][XXX]", "yyyy-MM-dd'T'H[H]:m[m][:s[s][.SSSSSS]][XXX]"), true, false, false, false),
        VECTOR_COMPONENT_DELIMITER(Collections.emptyList(), Collections.emptyList(), Character.class, false, Character.valueOf(';'), false, false, false, false),
        POINT2D(Collections.emptyList(), Collections.emptyList(), String.class, false, "0.0 0.0", false, false, false, false),
        ATTRIBUTES(Collections.emptyList(), Collections.emptyList(), Map.class, false, Collections.emptyMap(), false, false, false, false),
        PASSWORD(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, true, true),
        KEYSTORE_ALIAS(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, false, false);

        private final List<String> aliases;
        private final List<String> singletonListAliases;
        private final Class<?> type;
        private final boolean required;
        private final Object defaultVal;
        private final boolean array;
        private final boolean path;
        private final boolean sensitive;
        private final boolean hidden;

        private Field(List<String> aliases, List<String> singletonListAliases, Class<?> type, boolean required, Object factoryDefaultVal, boolean array, boolean path, boolean sensitive, boolean hidden) {
            this.aliases = aliases;
            this.singletonListAliases = singletonListAliases;
            this.type = type;
            this.required = required;
            this.defaultVal = AbstractConfig.getDefault("pg.rdbms.graph.json", this, factoryDefaultVal);
            this.array = array;
            this.path = path;
            this.sensitive = sensitive;
            this.hidden = hidden;
        }

        @Override
        public List<String> getKeyAliases() {
            return this.aliases;
        }

        @Override
        public List<String> getSingletonListKeyAliases() {
            return this.singletonListAliases;
        }

        @Override
        public Class<?> getType() {
            return this.type;
        }

        @Override
        public boolean isRequired() {
            return this.required;
        }

        @Override
        public boolean isArray() {
            return this.array;
        }

        @Override
        public boolean isPath() {
            return this.path;
        }

        @Override
        public Object getDefaultVal() {
            return this.defaultVal;
        }

        @Override
        @JsonValue
        public String toKey() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.toKey();
        }

        @Override
        public boolean isSensitive() {
            return this.sensitive;
        }

        @Override
        public boolean isHidden() {
            return this.hidden;
        }
    }
}

