/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import oracle.pgx.common.util.ConfigJsonUtil;
import oracle.pgx.config.PreparedQueryConfig;

public final class PreparedQueryConfigBuilder {
    private final Map<PreparedQueryConfig.Field, Object> values = new HashMap<PreparedQueryConfig.Field, Object>();

    public static PreparedQueryConfig buildPreparedQueryConfig(Consumer<PreparedQueryConfigBuilder> builderSetup) {
        PreparedQueryConfigBuilder builder = new PreparedQueryConfigBuilder();
        builderSetup.accept(builder);
        return builder.build();
    }

    public PreparedQueryConfigBuilder() {
    }

    public PreparedQueryConfigBuilder(Map<PreparedQueryConfig.Field, Object> values) {
        this.putAll(values);
    }

    public PreparedQueryConfigBuilder(PreparedQueryConfig config) {
        this.putAll(config);
    }

    public PreparedQueryConfigBuilder(PreparedQueryConfigBuilder builder) {
        this.putAll(builder.values);
    }

    public PreparedQueryConfigBuilder putAll(Map<PreparedQueryConfig.Field, Object> values) {
        this.values.putAll(values);
        return this;
    }

    public PreparedQueryConfigBuilder putAll(PreparedQueryConfig config) {
        this.putAll(config.getValuesWithoutDefaults());
        return this;
    }

    public PreparedQueryConfigBuilder clear() {
        this.values.clear();
        return this;
    }

    public PreparedQueryConfig build(String parentPath) {
        try {
            return PreparedQueryConfig.parse(this.toInputStream(), true, parentPath);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public PreparedQueryConfig build() {
        return this.build(null);
    }

    public InputStream toInputStream() {
        try {
            return ConfigJsonUtil.toJsonInputStream(this.values);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public Map<PreparedQueryConfig.Field, Object> getValues() {
        return Collections.unmodifiableMap(this.values);
    }

    public String toString() {
        return "PreparedQueryConfigBuilder" + this.values;
    }

    public PreparedQueryConfigBuilder setQuery(String query) {
        this.values.put(PreparedQueryConfig.Field.QUERY, query);
        return this;
    }

    public PreparedQueryConfigBuilder setArguments(Object ... arguments) {
        this.values.put(PreparedQueryConfig.Field.ARGUMENTS, arguments);
        return this;
    }

    public PreparedQueryConfigBuilder setArguments(List<?> arguments) {
        this.values.put(PreparedQueryConfig.Field.ARGUMENTS, arguments);
        return this;
    }
}

