/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.io.IOException;
import oracle.ons.Notification;
import oracle.ons.OutputBuffer;
import oracle.ons.SubscriptionException;

public class SubscriptionNotification {
    protected int subsid;
    protected String subscription;
    protected Object lock;
    protected boolean waiter;
    protected SubscriptionException ex;
    protected boolean success;
    private boolean replyrecvd;
    private static byte[] subsmessageline = new byte[26];
    private static byte[] subsidheader;
    private static byte[] subsheader;
    private static byte[] contentlengthline;

    protected SubscriptionNotification(int sid, String subs, boolean w) {
        this.subsid = sid;
        this.subscription = subs;
        this.waiter = w;
        this.ex = null;
        this.success = false;
        this.replyrecvd = false;
        this.lock = this.waiter ? new Object() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForReply(long timeout) throws SubscriptionException {
        try {
            Object object = this.lock;
            synchronized (object) {
                if (!this.replyrecvd) {
                    if (timeout <= 0L) {
                        this.lock.wait();
                    } else {
                        this.lock.wait(timeout);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (timeout >= 0L && !this.replyrecvd) {
            throw new SubscriptionException("Subscription request timed out after " + timeout + " millseconds.  Possible causes: OPMN may not be running, you may have an OPMN running in an alternate ORACLE_HOME using duplicate port values, or OPMN may be misconfigured.");
        }
        if (!this.success) {
            if (this.ex != null) {
                throw this.ex;
            }
            throw new SubscriptionException("Subscription failed for unknown reason");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void wakeup(boolean s, SubscriptionException sexcept) {
        this.success = s;
        this.ex = sexcept;
        if (this.waiter) {
            Object object = this.lock;
            synchronized (object) {
                this.replyrecvd = true;
                this.lock.notifyAll();
            }
        }
    }

    protected void send(OutputBuffer obuf) throws IOException {
        obuf.putBytes(subsmessageline, subsmessageline.length);
        obuf.putBytes(contentlengthline, contentlengthline.length);
        obuf.putBytes(subsidheader, subsidheader.length);
        String tmpstr = Integer.toString(this.subsid);
        obuf.putBytes(tmpstr.getBytes(), tmpstr.length());
        obuf.putBytes(Notification.crlf, 2);
        obuf.putBytes(subsheader, subsheader.length);
        if (this.subscription != null && this.subscription.length() > 0) {
            obuf.putBytes(this.subscription.getBytes(), this.subscription.length());
        }
        obuf.putBytes(Notification.crlf, 2);
        obuf.putBytes(Notification.crlf, 2);
        obuf.flush();
    }

    static {
        System.arraycopy(new String("POST /subscribe HTTP/1.1").getBytes(), 0, subsmessageline, 0, 24);
        System.arraycopy(Notification.crlf, 0, subsmessageline, 24, 2);
        subsidheader = new String("SubscriberID: ").getBytes();
        subsheader = new String("Subscription: ").getBytes();
        contentlengthline = new byte[19];
        System.arraycopy(new String("Content-Length: 0").getBytes(), 0, contentlengthline, 0, 17);
        System.arraycopy(Notification.crlf, 0, contentlengthline, 17, 2);
    }
}

