/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import oracle.ons.BodyBlock;
import oracle.ons.ComponentCallBack;
import oracle.ons.HeaderBlock;
import oracle.ons.Notification;
import oracle.ons.ONS;
import oracle.ons.Publisher;

public class OpmnNotifier
implements Runnable {
    private final String ONS_READY_EVENT = "IAS/PM/PROC_READY";
    private final String ONS_FIRST_EVENT = "OPMFirst";
    private final String OPMN_ID = "OPMN_UID";
    private final String UMP_UID = "-1";
    private String onsComponentName;
    private String opmnId;
    private int pingInterval = 10000;
    private boolean localOnly = false;
    private ComponentCallBack compCb = null;
    private Object notifCbData = null;
    private boolean threadShutdown = false;
    private Thread notifThread = null;
    private boolean firstTime = false;
    private ONS ons = ONS.getONS();

    public OpmnNotifier(String compName, String UID) {
        this(compName, UID, 10, false, null, null);
    }

    public OpmnNotifier(String compName, String UID, int pingInterval, boolean localOnly, ComponentCallBack callBack, Object cbData) {
        this.onsComponentName = compName;
        this.opmnId = UID;
        this.compCb = callBack;
        this.notifCbData = cbData;
        this.localOnly = localOnly;
        if (pingInterval > 0) {
            this.pingInterval = pingInterval * 1000;
        }
    }

    public String getComponentName() {
        return this.onsComponentName;
    }

    public void startup() throws IllegalThreadStateException {
        if (this.notifThread != null) {
            return;
        }
        this.notifThread = new Thread((Runnable)this, "OpmnNotifier");
        this.notifThread.setDaemon(true);
        this.notifThread.start();
    }

    @Override
    public void run() {
        this.firstTime = true;
        if (this.onsComponentName == null || this.opmnId == null) {
            ONS.error("ComponentName or OPMNID is NULL");
            return;
        }
        Publisher pub = new Publisher(this.ons, this.onsComponentName);
        while (!this.threadShutdown) {
            BodyBlock bodyBlock = new BodyBlock();
            HeaderBlock headerBlock = new HeaderBlock();
            if (this.compCb != null) {
                this.compCb.OpmnCallback(bodyBlock, headerBlock, this.notifCbData);
            }
            byte[] body = bodyBlock.generateBody();
            Notification out_n = new Notification("IAS/PM/PROC_READY", "", "", body);
            headerBlock.setHeader(out_n);
            String instanceId = this.ons.config.getInstanceId();
            if (instanceId != null) {
                out_n.put("instanceId", instanceId);
            }
            if (!this.opmnId.equals("-1")) {
                out_n.put("OPMN_UID", this.opmnId);
            }
            if (this.firstTime) {
                this.firstTime = false;
                out_n.put("OPMFirst", "true");
            } else {
                out_n.put("OPMFirst", "false");
            }
            if (this.localOnly) {
                out_n.setLocalOnly();
            }
            pub.publish(out_n);
            if (this.threadShutdown) continue;
            try {
                Thread.sleep(this.pingInterval);
            }
            catch (Exception exception) {}
        }
        pub.close();
        this.notifThread = null;
    }

    public void shutdown() {
        try {
            this.threadShutdown = true;
            this.notifThread.interrupt();
        }
        catch (Exception e) {
            ONS.error("Exception while shutting down receiver thread");
            e.printStackTrace(this.ons.errstream);
        }
    }

    public void setFirstNotificationFlag() {
        this.firstTime = true;
    }
}

