/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ons.CreatePermission;
import oracle.ons.Message;
import oracle.ons.NoServersAvailable;
import oracle.ons.Node;
import oracle.ons.NodeAddress;
import oracle.ons.Notification;
import oracle.ons.NotificationException;
import oracle.ons.NotificationManager;
import oracle.ons.ONS;
import oracle.ons.ONSConfiguration;
import oracle.ons.ONSException;
import oracle.ons.PublishPermission;
import oracle.ons.Publisher;
import oracle.ons.Subscriber;
import oracle.ons.SubscriptionProxy;

public class NotificationNetwork {
    protected ONSConfiguration config;
    protected NotificationManager master;
    protected volatile int messageReceived = 0;
    protected volatile int messagePublished = 0;
    protected volatile int messageDropped = 0;
    private static final int STATE_NETWORK_DOWN = 0;
    private static final int STATE_STARTING_UP = 1;
    private static final int STATE_NETWORK_UP = 2;
    private static final long CONNECTION_SCAN = 15000L;
    private static final long FAILOVER_COOLDOWN = 3000L;
    private AtomicInteger state = new AtomicInteger(0);
    private int usageCount = 0;
    protected Logger logger;
    private final Semaphore networkStatusLock = new Semaphore(0, false);
    protected final List<ONSConfiguration.NodeList> nodeLists = new ArrayList<ONSConfiguration.NodeList>();
    private final Set<Node> nodes = new HashSet<Node>();
    private RefreshConnectionsTask localRefreshTask = new RefreshConnectionsTask();
    private final Map<String, SubscriptionProxy> networkSubscriptions = new HashMap<String, SubscriptionProxy>();

    Iterable<? extends Node> getNodes() {
        return this.nodes;
    }

    NotificationNetwork(ONSConfiguration oNSConfiguration) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new CreatePermission("ONSUser"));
        }
        this.master = NotificationManager.getNotificationManager();
        this.config = oNSConfiguration;
        this.logger = this.master.logger;
        this.nodeLists.addAll(oNSConfiguration.getTopologies());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilOnline(long l, boolean bl) throws ONSException, InterruptedException {
        if (this.networkStatusLock.availablePermits() > 0) {
            NotificationNetwork notificationNetwork = this;
            synchronized (notificationNetwork) {
                return !this.nodes.isEmpty();
            }
        }
        if (this.networkStatusLock.tryAcquire(l, TimeUnit.MILLISECONDS)) {
            this.networkStatusLock.release();
        } else {
            this.state.compareAndSet(1, 0);
            if (bl) {
                throw new NoServersAvailable("Server time out");
            }
        }
        NotificationNetwork notificationNetwork = this;
        synchronized (notificationNetwork) {
            return !this.nodes.isEmpty();
        }
    }

    public boolean waitUntilOnline() throws ONSException, InterruptedException {
        return this.waitUntilOnline(this.config.getSocketTimeout(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ping() {
        NotificationNetwork notificationNetwork = this;
        synchronized (notificationNetwork) {
            for (Node node : this.nodes) {
                node.ping(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ping(long l) throws InterruptedException {
        LinkedBlockingQueue<Node> linkedBlockingQueue = new LinkedBlockingQueue<Node>();
        this.lazyDemand();
        if (!this.waitUntilOnline(l, false)) {
            return false;
        }
        HashSet<Node> hashSet = new HashSet<Node>();
        Object object = this;
        synchronized (object) {
            for (Node node : this.nodes) {
                if (!hashSet.add(node)) continue;
                node.ping(linkedBlockingQueue);
            }
        }
        while (!hashSet.isEmpty()) {
            object = (Node)linkedBlockingQueue.poll(l, TimeUnit.MILLISECONDS);
            if (object == null) {
                return false;
            }
            hashSet.remove(object);
        }
        return true;
    }

    protected void checkPublisherPerimission() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new PublishPermission("ONSUser"));
        }
    }

    public Publisher getPublisher(String string) {
        return new Publisher(this, string);
    }

    public synchronized boolean publish(Message message) {
        this.checkPublisherPerimission();
        if (this.nodes.isEmpty()) {
            throw new NotificationException("Network is down");
        }
        Iterator<Node> iterator = this.nodes.iterator();
        if (iterator.hasNext()) {
            Node node = iterator.next();
            node.publish(message);
            return true;
        }
        return false;
    }

    public synchronized boolean publishNotification(Notification notification, Publisher publisher) {
        boolean bl = false;
        this.checkPublisherPerimission();
        if (notification.deliveryTime != -1L) {
            throw new NotificationException("Received notifications cannot be published");
        }
        if (this.nodes.isEmpty()) {
            throw new NotificationException("Network is down");
        }
        Message message = null;
        Message message2 = null;
        Message message3 = null;
        for (ONSConfiguration.NodeList nodeList : this.nodeLists) {
            Iterator<Node> iterator = nodeList.connected.iterator();
            if (!iterator.hasNext()) continue;
            Node node = iterator.next();
            try {
                if (node.getProtocolVersion() >= 6) {
                    node.publish(message3 != null ? message3 : notification.toMessage(publisher, 6));
                } else if (node.getProtocolVersion() == 5) {
                    node.publish(message2 != null ? message2 : notification.toMessage(publisher, 5));
                } else {
                    node.publish(message != null ? message : notification.toMessageVersion4(publisher));
                }
                bl = true;
            }
            catch (IOException iOException) {
                throw new ONSException("Notification publish failed for client internal error");
            }
        }
        return bl;
    }

    void scanExpandNodeList(Collection<NodeAddress> collection, Collection<NodeAddress> collection2) {
        if (this.config.ignoreScan) {
            collection.stream().map(nodeAddress -> new NodeAddress((NodeAddress)nodeAddress)).forEachOrdered(collection2::add);
        } else {
            for (NodeAddress nodeAddress2 : collection) {
                try {
                    for (InetAddress inetAddress : InetAddress.getAllByName(nodeAddress2.hostname)) {
                        NodeAddress nodeAddress3 = new NodeAddress(inetAddress.getHostAddress(), nodeAddress2.port, this.config.getKeyFile(), this.config.getWebSocket());
                        this.logger.finest(String.format("%s resolves to %s", nodeAddress2.toString(), nodeAddress3.toString()));
                        collection2.add(nodeAddress3);
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    NotificationManager.getNotificationManager().logger.warning(String.format("ONS failed to resolve host : %s", nodeAddress2.toString()));
                }
            }
        }
    }

    synchronized void onNodeUp(Node node) {
        if (node.isConnected()) {
            this.logger.log(Level.FINE, "ONS network: " + this + " node up: " + node);
            for (SubscriptionProxy object : this.networkSubscriptions.values()) {
                this.logger.log(Level.FINE, "ONS network: " + this + " sub task sched: " + object);
                this.master.getWorkloadManager().schedule(new RegisterSubscriptionTask(node, object));
            }
            this.nodes.add(node);
            for (ONSConfiguration.NodeList nodeList : this.nodeLists) {
                if (!nodeList.pending.contains(node)) continue;
                this.logger.log(Level.FINE, "ONS network: " + this + " pending node on up");
                nodeList.pending.remove(node);
                nodeList.connected.add(node);
                nodeList.connectFails = 0;
            }
            this.state.set(2);
            this.networkStatusLock.release();
        } else {
            this.logger.log(Level.FINE, "ONS network: " + this + " unconnected node up: " + node);
        }
    }

    synchronized void onNodeDown(Node node) {
        if (this.nodes.contains(node)) {
            this.logger.log(Level.FINE, "ONS network: " + this + " node down: " + node);
            this.nodes.remove(node);
            for (ONSConfiguration.NodeList nodeList : this.nodeLists) {
                nodeList.pending.remove(node);
                nodeList.connected.remove(node);
            }
            if (this.nodes.isEmpty()) {
                this.state.compareAndSet(2, 1);
            }
            if (!this.networkStatusLock.tryAcquire()) {
                this.logger.severe("ONS network " + this + " Node consistency broken");
            }
        } else {
            this.logger.log(Level.FINE, "ONS network: " + this + " not in nodes node down: " + node);
            for (ONSConfiguration.NodeList nodeList : this.nodeLists) {
                if (!nodeList.pending.contains(node)) continue;
                this.logger.log(Level.FINE, "ONS network: " + this + " removing node " + node + " from nodelist " + nodeList + " pending");
                nodeList.pending.remove(node);
                ++nodeList.connectFails;
            }
        }
        if (this.state.get() != 0) {
            this.logger.log(Level.FINE, "ONS network: " + this + " : sched RefreshConnectionsTask");
            this.master.getWorkloadManager().schedule(this.localRefreshTask);
        }
    }

    private void shutdown() {
        this.logger.log(Level.FINE, "ONS network: " + this + " shutdown");
        for (Node node : this.nodes) {
            node.unregister(this);
            this.networkStatusLock.tryAcquire();
        }
        this.nodes.clear();
        this.state.set(0);
    }

    synchronized void release() {
        --this.usageCount;
        if (this.usageCount == 0) {
            this.logger.log(Level.FINE, "ONS network: " + this + " release action");
            this.shutdown();
            this.master.onNetworkDown(this);
        } else {
            this.logger.log(Level.FINE, "ONS network: " + this + " release skip: " + this.usageCount);
        }
    }

    synchronized NotificationNetwork demand() {
        ++this.usageCount;
        if (this.usageCount == 1) {
            this.logger.log(Level.FINE, "ONS network: " + this + " demand action");
            this.startup();
        } else {
            this.logger.log(Level.FINE, "ONS network: " + this + " demand skip: " + this.usageCount);
        }
        return this;
    }

    @Deprecated
    public NotificationNetwork lazyDemand() {
        return this;
    }

    public synchronized void releaseIfUnused() {
        if (this.usageCount == 0) {
            this.logger.log(Level.FINE, "ONS network: " + this + " unused release action");
            this.shutdown();
            this.master.onNetworkDown(this);
        }
    }

    private void startup() {
        if (this.state.compareAndSet(0, 1)) {
            this.logger.log(Level.FINE, "ONS network: " + this + " startup action");
            this.master.onNetworkUp(this);
            this.master.getWorkloadManager().schedule(this.localRefreshTask);
        } else {
            this.logger.log(Level.FINE, "ONS network: " + this + " startup skipped: " + this.state.get());
        }
    }

    synchronized void registerSubscriber(Subscriber subscriber) {
        String string = subscriber.getSubscriptionKey();
        SubscriptionProxy subscriptionProxy = this.networkSubscriptions.get(string);
        if (subscriptionProxy == null) {
            this.logger.log(Level.FINE, "ONS network: " + this + " register subscriber (new proxy): " + subscriber + "(" + subscriber.id + ")");
            subscriptionProxy = new SubscriptionProxy(this, subscriber);
            this.logger.log(Level.FINE, "ONS network: " + this + " subscriber: " + subscriber + "(" + subscriber.id + ") new proxy: " + subscriptionProxy);
            this.networkSubscriptions.put(string, subscriptionProxy);
            for (Node node : this.getNodes()) {
                this.logger.log(Level.FINE, "ONS network: " + this + " sched reg sub: " + subscriber + "(" + subscriber.id + ") for node: " + node);
                this.master.getWorkloadManager().schedule(new RegisterSubscriptionTask(node, subscriptionProxy));
            }
        } else {
            this.logger.log(Level.FINE, "ONS network: " + this + " register subscriber (proxy: " + subscriptionProxy + "): " + subscriber + "(" + subscriber.id + ")");
            subscriptionProxy.add(subscriber);
        }
    }

    synchronized void unregisterSubscriber(Subscriber subscriber) {
        String string = subscriber.getSubscriptionKey();
        SubscriptionProxy subscriptionProxy = this.networkSubscriptions.get(string);
        this.logger.log(Level.FINE, "ONS network: " + this + " unregister subscriber (proxy: " + subscriptionProxy + "): " + subscriber + "(" + subscriber.id + ")");
        subscriptionProxy.remove(subscriber);
        if (subscriptionProxy.isEmpty()) {
            this.networkSubscriptions.remove(string);
            for (Node node : this.getNodes()) {
                this.logger.log(Level.FINE, "ONS network: " + this + " sched rem sub: " + subscriber + "(" + subscriber.id + ") for node: " + node);
                this.master.getWorkloadManager().schedule(new RemoveSubscriptionTask(node, subscriptionProxy));
            }
        }
    }

    private class RemoveSubscriptionTask
    implements Runnable {
        Node node;
        SubscriptionProxy proxy;

        private RemoveSubscriptionTask(Node node, SubscriptionProxy subscriptionProxy) {
            this.node = node;
            this.proxy = subscriptionProxy;
        }

        @Override
        public void run() {
            try {
                this.node.removeSubscriber(this.proxy);
            }
            catch (Exception exception) {
                NotificationNetwork.this.master.logger.finest(ONS.exceptionMsg(exception));
            }
        }
    }

    private class RegisterSubscriptionTask
    implements Runnable {
        Node node;
        SubscriptionProxy proxy;

        private RegisterSubscriptionTask(Node node, SubscriptionProxy subscriptionProxy) {
            this.node = node;
            this.proxy = subscriptionProxy;
        }

        @Override
        public void run() {
            try {
                this.node.addSubscriber(this.proxy);
            }
            catch (Exception exception) {
                NotificationNetwork.this.master.logger.warning(ONS.exceptionMsg(exception));
                exception.printStackTrace();
            }
        }
    }

    private class RefreshConnectionsTask
    implements Runnable {
        private volatile long lastRun = 0L;
        private volatile boolean scheduled = false;
        private volatile boolean rapidRun = false;

        private RefreshConnectionsTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            NotificationNetwork.this.logger.log(Level.FINE, "ONS network: " + NotificationNetwork.this + " RefreshConnectionsTask");
            NotificationNetwork notificationNetwork = NotificationNetwork.this;
            synchronized (notificationNetwork) {
                long l = System.currentTimeMillis();
                long l2 = l - this.lastRun;
                if (3000L > l2) {
                    if (this.rapidRun) {
                        if (!this.scheduled) {
                            NotificationNetwork.this.logger.log(Level.FINE, "ONS network: " + NotificationNetwork.this + " cooldown resched RefreshConnectionsTask");
                            NotificationNetwork.this.master.getWorkloadManager().scheduleDelayed(this, 3000L - l2);
                            this.scheduled = true;
                        }
                        return;
                    }
                    this.rapidRun = true;
                } else {
                    this.rapidRun = false;
                }
                this.scheduled = false;
                long l3 = 15000L;
                boolean bl = false;
                for (ONSConfiguration.NodeList nodeList : NotificationNetwork.this.nodeLists) {
                    Object object;
                    HashSet<NodeAddress> hashSet = new HashSet<NodeAddress>();
                    NotificationNetwork.this.scanExpandNodeList(nodeList.addresses, hashSet);
                    int n = Math.min(nodeList.maxConnections, hashSet.size());
                    int n2 = nodeList.pending.size() + nodeList.connected.size();
                    NotificationNetwork.this.logger.log(Level.FINE, "ONS network: " + NotificationNetwork.this + " scan node-list " + nodeList + " active: " + nodeList.active + " count: " + n2 + " max: " + n);
                    if (!nodeList.active) {
                        if (nodeList.failedFrom == null) continue;
                        if (n2 < n) {
                            NotificationNetwork.this.master.connect(nodeList, hashSet, n, NotificationNetwork.this);
                        }
                        bl = true;
                        continue;
                    }
                    if (nodeList.connected.size() >= n && nodeList.failedTo == null) continue;
                    NotificationNetwork.this.logger.log(Level.FINE, "ONS network: " + NotificationNetwork.this + " connect node-list " + nodeList);
                    NotificationNetwork.this.master.connect(nodeList, hashSet, n, NotificationNetwork.this);
                    n2 = nodeList.pending.size() + nodeList.connected.size();
                    if (nodeList.failedTo != null && nodeList.connected.size() != 0) {
                        Object object2;
                        ONSConfiguration.NodeList nodeList2 = nodeList.failedTo;
                        nodeList.failedTo = null;
                        nodeList2.failedFrom = null;
                        HashSet<Object> hashSet2 = new HashSet<Object>();
                        object = nodeList2.pending.iterator();
                        while (object.hasNext()) {
                            object2 = object.next();
                            hashSet2.add(object2);
                            object.remove();
                        }
                        object = nodeList2.connected.iterator();
                        while (object.hasNext()) {
                            object2 = object.next();
                            hashSet2.add(object2);
                            object.remove();
                        }
                        for (Node node : hashSet2) {
                            if (!NotificationNetwork.this.nodes.contains(node)) continue;
                            NotificationNetwork.this.nodes.remove(node);
                            node.unregister(NotificationNetwork.this);
                        }
                        if (n2 < n) {
                            NotificationNetwork.this.master.connect(nodeList, hashSet, n, NotificationNetwork.this);
                            n2 = nodeList.pending.size() + nodeList.connected.size();
                        }
                        l3 = 3000L;
                        bl = true;
                    } else if (nodeList.connected.size() == 0 && nodeList.connectFails > n && nodeList.failedTo == null) {
                        for (ONSConfiguration.NodeList nodeList2 : NotificationNetwork.this.nodeLists) {
                            if (nodeList2.active || nodeList2.failedFrom != null) continue;
                            object = new HashSet();
                            NotificationNetwork.this.scanExpandNodeList(nodeList2.addresses, (Collection<NodeAddress>)object);
                            int n3 = Math.min(nodeList2.maxConnections, object.size());
                            NotificationNetwork.this.master.connect(nodeList2, (Set<NodeAddress>)object, n3, NotificationNetwork.this);
                            int n4 = nodeList2.pending.size() + nodeList2.connected.size();
                            if (n4 == 0) continue;
                            nodeList.failedTo = nodeList2;
                            nodeList2.failedFrom = nodeList;
                            n2 = n4;
                            n = n3;
                            break;
                        }
                    } else if (nodeList.connected.size() == 0 && nodeList.failedTo == null) {
                        l3 = 3000L;
                    }
                    if (n2 >= n) continue;
                    bl = true;
                }
                this.lastRun = System.currentTimeMillis();
                if (bl && !this.scheduled) {
                    NotificationNetwork.this.logger.log(Level.FINE, "ONS network: " + NotificationNetwork.this + " resched RefreshConnectionsTask");
                    NotificationNetwork.this.master.getWorkloadManager().scheduleDelayed(this, l3);
                    this.scheduled = true;
                }
            }
        }
    }
}

