/*
 * Decompiled with CFR 0.152.
 */
package oracle.jakarta.AQ.xml;

import jakarta.jms.JMSException;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import oracle.jakarta.AQ.AQOracleDebug;
import oracle.jakarta.AQ.xml.AQxmlAdtMessage;
import oracle.jakarta.AQ.xml.AQxmlAgent;
import oracle.jakarta.AQ.xml.AQxmlClientRequest;
import oracle.jakarta.AQ.xml.AQxmlCommitRequest;
import oracle.jakarta.AQ.xml.AQxmlConsumerOption;
import oracle.jakarta.AQ.xml.AQxmlDebug;
import oracle.jakarta.AQ.xml.AQxmlDocument;
import oracle.jakarta.AQ.xml.AQxmlEnqueueRequest;
import oracle.jakarta.AQ.xml.AQxmlError;
import oracle.jakarta.AQ.xml.AQxmlException;
import oracle.jakarta.AQ.xml.AQxmlJmsBytesMessage;
import oracle.jakarta.AQ.xml.AQxmlJmsMapMessage;
import oracle.jakarta.AQ.xml.AQxmlJmsMessage;
import oracle.jakarta.AQ.xml.AQxmlJmsObjectMessage;
import oracle.jakarta.AQ.xml.AQxmlJmsTextMessage;
import oracle.jakarta.AQ.xml.AQxmlMessage;
import oracle.jakarta.AQ.xml.AQxmlMessageHeader;
import oracle.jakarta.AQ.xml.AQxmlMessagePropertyList;
import oracle.jakarta.AQ.xml.AQxmlProducerOption;
import oracle.jakarta.AQ.xml.AQxmlPublishRequest;
import oracle.jakarta.AQ.xml.AQxmlPushRequest;
import oracle.jakarta.AQ.xml.AQxmlRawMessage;
import oracle.jakarta.AQ.xml.AQxmlReceiveRequest;
import oracle.jakarta.AQ.xml.AQxmlRegisterOption;
import oracle.jakarta.AQ.xml.AQxmlRegisterRequest;
import oracle.jakarta.AQ.xml.AQxmlRollbackRequest;
import oracle.jakarta.AQ.xml.AQxmlSendRequest;
import oracle.jakarta.AQ.xml.AQxmlSequenceNumRequest;
import oracle.jakarta.AQ.xml.AQxmlSignature;
import oracle.jakarta.AQ.xml.AQxmlTypeInfoRequest;
import oracle.jakarta.AQ.xml.StreamsAddTablePropagationRulesRequest;
import oracle.jakarta.AQ.xml.StreamsAddTableRulesRequest;
import oracle.jakarta.AQ.xml.StreamsSetupQueueRequest;
import oracle.jakarta.AQ.xml.StreamsStartApplyRequest;
import oracle.jakarta.AQ.xml.StreamsStartCaptureRequest;
import oracle.jakarta.jms.AQjmsAgent;
import oracle.jakarta.jms.AQjmsBytesMessage;
import oracle.jakarta.jms.AQjmsMapMessage;
import oracle.jakarta.jms.AQjmsMessage;
import oracle.jakarta.jms.AQjmsObjectMessage;
import oracle.jakarta.jms.AQjmsSignature;
import oracle.jakarta.jms.AQjmsTextMessage;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class AQxmlConverter {
    Document doc;
    int msg_type = -1;
    static Hashtable elementHashtable;
    int message_count = 0;

    AQxmlConverter() {
    }

    int getMessageType(NodeList nl) throws AQxmlException {
        Node n = null;
        NodeList cnl = null;
        NodeList msg_type_cnl = null;
        Node msg_node = null;
        String msg_node_name = null;
        String msg_node_local_name = null;
        n = nl.item(0);
        cnl = ((XMLElement)n).getElementsByTagName("message_payload", "http://ns.oracle.com/AQ/schemas/access");
        if (cnl.item(0) == null) {
            AQxmlError.throwAQEx(401, "Invalid message type");
        }
        msg_type_cnl = cnl.item(0).getChildNodes();
        msg_node = msg_type_cnl.item(0);
        msg_node_name = msg_node.getNodeName();
        msg_node_local_name = ((XMLElement)msg_node).getLocalName();
        AQxmlDebug.trace(4, "AQxmlConverter.getMessageType", "Node Name: " + msg_node_name + " Local Name: " + msg_node_local_name);
        int ret_msg_type = msg_node_local_name.equalsIgnoreCase("JMS_TEXT_MESSAGE") ? 0 : (msg_node_local_name.equalsIgnoreCase("JMS_MAP_MESSAGE") ? 2 : (msg_node_local_name.equalsIgnoreCase("JMS_BYTES_MESSAGE") ? 1 : (msg_node_local_name.equalsIgnoreCase("JMS_OBJECT_MESSAGE") ? 3 : (msg_node_local_name.equalsIgnoreCase("RAW") ? 5 : 4))));
        AQxmlDebug.trace(4, "AQxmlConverter.getMessageType", "Message Type: " + ret_msg_type);
        return ret_msg_type;
    }

    AQxmlDocument[] generateAQxmlDocument(NodeList nl) throws AQxmlException {
        Node n = null;
        Integer xmlElement = null;
        AQxmlDocument[] retDocs = null;
        Object local_name = null;
        Object namespace = null;
        NodeList cnl = null;
        int j = 0;
        this.printUtil("generateAQxmlDocument");
        AQxmlDebug.trace(4, "AQxmlConverter.generateAQxmlDocument", "entry");
        try {
            AQxmlDebug.trace(5, "AQxmlConverter.generateAQxmlDocument", "NL: " + nl.getLength());
            retDocs = new AQxmlDocument[nl.getLength()];
            block20: for (int i = 0; i < nl.getLength(); ++i) {
                n = nl.item(i);
                xmlElement = this.getNextAQElement(n);
                this.printNodeNSInfo(n);
                if (xmlElement == null) {
                    AQxmlDebug.trace(4, "AQxmlConverter.generateAQxmlDocument", "Null Element");
                    continue;
                }
                switch (xmlElement) {
                    case 620: {
                        this.msg_type = this.getMessageType(nl);
                        cnl = n.getChildNodes();
                        retDocs[j++] = this.processSend(cnl, 1);
                        continue block20;
                    }
                    case 640: {
                        this.msg_type = this.getMessageType(nl);
                        cnl = n.getChildNodes();
                        retDocs[j++] = this.processSend(cnl, 2);
                        continue block20;
                    }
                    case 630: {
                        cnl = n.getChildNodes();
                        retDocs[j++] = this.processReceive(cnl);
                        continue block20;
                    }
                    case 650: {
                        cnl = n.getChildNodes();
                        retDocs[j++] = this.processRegister(cnl);
                        continue block20;
                    }
                    case 680: {
                        retDocs[j++] = this.processCommitOrRollback(680);
                        continue block20;
                    }
                    case 690: {
                        retDocs[j++] = this.processCommitOrRollback(690);
                        continue block20;
                    }
                    case 290: {
                        this.msg_type = this.getMessageType(nl);
                        cnl = n.getChildNodes();
                        retDocs[j++] = this.processPush(cnl);
                        continue block20;
                    }
                    case 300: {
                        continue block20;
                    }
                    case 310: {
                        cnl = n.getChildNodes();
                        retDocs[j++] = this.processSequenceNumReq(cnl);
                        continue block20;
                    }
                    case 311: {
                        cnl = n.getChildNodes();
                        retDocs[j++] = this.processQueueTypeReq(cnl);
                        continue block20;
                    }
                    case 2080: {
                        cnl = n.getChildNodes();
                        retDocs[j++] = this.processStreamsSetupQueue(cnl);
                        continue block20;
                    }
                    case 2140: {
                        cnl = n.getChildNodes();
                        retDocs[j++] = this.processStreamsAddTableRules(cnl);
                        continue block20;
                    }
                    case 2310: {
                        cnl = n.getChildNodes();
                        retDocs[j++] = this.processStreamsAddTablePropagationRules(cnl);
                        continue block20;
                    }
                    case 2270: {
                        cnl = n.getChildNodes();
                        retDocs[j++] = this.processStreamsStartCapture(cnl);
                        continue block20;
                    }
                    case 2290: {
                        cnl = n.getChildNodes();
                        retDocs[j++] = this.processStreamsStartApply(cnl);
                        continue block20;
                    }
                    default: {
                        AQxmlError.throwAQEx(401, "Invalid Idap Tag: " + n.getNodeName());
                    }
                }
            }
        }
        catch (AQxmlException aqxml_ex) {
            throw aqxml_ex;
        }
        catch (Exception ex) {
            AQxmlDebug.traceEx(3, "AQxmlConverter.generateAQxmlDocument-ex", ex);
            AQxmlError.throwAQEx(404, ex);
        }
        return retDocs;
    }

    void printNodeNSInfo(Node n) {
        AQxmlDebug.trace(5, "AQxmlConverter.printNodeNSInfo", "Expanded Name: " + ((XMLElement)n).getExpandedName());
        AQxmlDebug.trace(5, "AQxmlConverter.printNodeNSInfo", "Local Name: " + ((XMLElement)n).getLocalName());
        AQxmlDebug.trace(5, "AQxmlConverter.printNodeNSInfo", "Namespace: " + ((XMLElement)n).getNamespace());
        AQxmlDebug.trace(5, "AQxmlConverter.printNodeNSInfo", "Prefix: " + ((XMLElement)n).getPrefix());
        AQxmlDebug.trace(5, "AQxmlConverter.printNodeNSInfo", "Qualified NS: " + ((XMLElement)n).getQualifiedName());
    }

    boolean isAQNamespace(String ns) {
        AQxmlDebug.trace(5, "AQxmlConverter.isAQNamespace", "NS: " + ns);
        return ns.equalsIgnoreCase("http://ns.oracle.com/AQ/schemas/access");
    }

    boolean isIdapNamespace(String ns) {
        AQxmlDebug.trace(5, "AQxmlConverter.isIdapNamespace", "NS: " + ns);
        return ns.equalsIgnoreCase("http://ns.oracle.com/AQ/schemas/envelope");
    }

    Integer getNextAQElement(Node n) throws AQxmlException {
        Integer xmlElement = null;
        String nodename = null;
        String local_name = null;
        String namespace = null;
        nodename = n.getNodeName();
        local_name = ((XMLElement)n).getLocalName();
        namespace = ((XMLElement)n).getNamespace();
        AQxmlDebug.trace(5, "AQxmlConverter.genNextAQElement", "Full Node name: " + namespace + " " + local_name);
        AQxmlDebug.trace(5, "AQxmlConverter.genNextAQElement", " finding :" + local_name.toUpperCase());
        xmlElement = (Integer)elementHashtable.get(local_name.toUpperCase());
        AQxmlDebug.trace(5, "AQxmlConverter.genNextAQElement", "XML ELEMENT: " + xmlElement);
        return xmlElement;
    }

    AQxmlDocument processStreamsSetupQueue(NodeList nl) throws AQxmlException {
        String qt = null;
        String sc = null;
        String qn = null;
        String qu = null;
        String cm = null;
        String db = null;
        AQxmlDebug.trace(4, "AQxmlConverter.processStreamsSetupQueue", "entry");
        block8: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            Integer xmlElement = this.getNextAQElement(n);
            if (xmlElement == null) {
                AQxmlDebug.trace(4, "AQxmlConverter.generateAQxmlDocument", "Null Element");
                continue;
            }
            switch (xmlElement) {
                case 2340: {
                    db = n.getChildNodes().item(0).getNodeValue();
                    continue block8;
                }
                case 2090: {
                    qt = n.getChildNodes().item(0).getNodeValue();
                    continue block8;
                }
                case 2100: {
                    sc = n.getChildNodes().item(0).getNodeValue();
                    continue block8;
                }
                case 2110: {
                    qn = n.getChildNodes().item(0).getNodeValue();
                    continue block8;
                }
                case 2120: {
                    qu = n.getChildNodes().item(0).getNodeValue();
                    continue block8;
                }
                case 2130: {
                    cm = n.getChildNodes().item(0).getNodeValue();
                    continue block8;
                }
                default: {
                    AQxmlError.throwAQEx(401, "Invalid Idap Tag: " + n.getNodeName());
                }
            }
        }
        StreamsSetupQueueRequest doc = new StreamsSetupQueueRequest(qt, sc, qn, qu, cm);
        if (db != null) {
            doc.setDBName(db);
        }
        return doc;
    }

    AQxmlDocument processStreamsAddTableRules(NodeList nl) throws AQxmlException {
        String tn = null;
        String st = null;
        String sn = null;
        String qn = null;
        String dbn = null;
        Boolean idml = null;
        Boolean iddl = null;
        Boolean ilcr = null;
        Boolean incl = null;
        String db = null;
        AQxmlDebug.trace(4, "AQxmlConverter.processStreamsAddTableRules", "entry");
        block12: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            Integer xmlElement = this.getNextAQElement(n);
            if (xmlElement == null) {
                AQxmlDebug.trace(4, "AQxmlConverter.generateAQxmlDocument", "Null Element");
                continue;
            }
            switch (xmlElement) {
                case 2340: {
                    db = n.getChildNodes().item(0).getNodeValue();
                    continue block12;
                }
                case 2150: {
                    tn = n.getChildNodes().item(0).getNodeValue();
                    continue block12;
                }
                case 2160: {
                    st = n.getChildNodes().item(0).getNodeValue();
                    continue block12;
                }
                case 2170: {
                    sn = n.getChildNodes().item(0).getNodeValue();
                    continue block12;
                }
                case 2110: {
                    qn = n.getChildNodes().item(0).getNodeValue();
                    continue block12;
                }
                case 2180: {
                    String value = n.getChildNodes().item(0).getNodeValue();
                    idml = value != null ? Boolean.valueOf(value) : null;
                    continue block12;
                }
                case 2190: {
                    String value = n.getChildNodes().item(0).getNodeValue();
                    iddl = value != null ? Boolean.valueOf(value) : null;
                    continue block12;
                }
                case 2200: {
                    String value = n.getChildNodes().item(0).getNodeValue();
                    ilcr = value != null ? Boolean.valueOf(value) : null;
                    continue block12;
                }
                case 2210: {
                    dbn = n.getChildNodes().item(0).getNodeValue();
                    continue block12;
                }
                case 2220: {
                    String value = n.getChildNodes().item(0).getNodeValue();
                    incl = value != null ? Boolean.valueOf(value) : null;
                    continue block12;
                }
                default: {
                    AQxmlError.throwAQEx(401, "Invalid Idap Tag: " + n.getNodeName());
                }
            }
        }
        StreamsAddTableRulesRequest doc = new StreamsAddTableRulesRequest(tn, st, sn, qn, idml, iddl, ilcr, dbn, incl);
        if (db != null) {
            doc.setDBName(db);
        }
        return doc;
    }

    AQxmlDocument processStreamsAddTablePropagationRules(NodeList nl) throws AQxmlException {
        String tn = null;
        String sn = null;
        String src = null;
        String dest = null;
        String dbn = null;
        Boolean idml = null;
        Boolean iddl = null;
        Boolean ilcr = null;
        Boolean incl = null;
        String db = null;
        AQxmlDebug.trace(4, "AQxmlConverter.processStreamsAddTablePropagationRules", "entry");
        block12: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            Integer xmlElement = this.getNextAQElement(n);
            if (xmlElement == null) {
                AQxmlDebug.trace(4, "AQxmlConverter.generateAQxmlDocument", "Null Element");
                continue;
            }
            switch (xmlElement) {
                case 2340: {
                    db = n.getChildNodes().item(0).getNodeValue();
                    continue block12;
                }
                case 2150: {
                    tn = n.getChildNodes().item(0).getNodeValue();
                    continue block12;
                }
                case 2170: {
                    sn = n.getChildNodes().item(0).getNodeValue();
                    continue block12;
                }
                case 2320: {
                    src = n.getChildNodes().item(0).getNodeValue();
                    continue block12;
                }
                case 2330: {
                    dest = n.getChildNodes().item(0).getNodeValue();
                    continue block12;
                }
                case 2180: {
                    String value = n.getChildNodes().item(0).getNodeValue();
                    idml = value != null ? Boolean.valueOf(value) : null;
                    continue block12;
                }
                case 2190: {
                    String value = n.getChildNodes().item(0).getNodeValue();
                    iddl = value != null ? Boolean.valueOf(value) : null;
                    continue block12;
                }
                case 2200: {
                    String value = n.getChildNodes().item(0).getNodeValue();
                    ilcr = value != null ? Boolean.valueOf(value) : null;
                    continue block12;
                }
                case 2210: {
                    dbn = n.getChildNodes().item(0).getNodeValue();
                    continue block12;
                }
                case 2220: {
                    String value = n.getChildNodes().item(0).getNodeValue();
                    incl = value != null ? Boolean.valueOf(value) : null;
                    continue block12;
                }
                default: {
                    AQxmlError.throwAQEx(401, "Invalid Idap Tag: " + n.getNodeName());
                }
            }
        }
        StreamsAddTablePropagationRulesRequest doc = new StreamsAddTablePropagationRulesRequest(tn, sn, src, dest, idml, iddl, ilcr, dbn, incl);
        if (db != null) {
            doc.setDBName(db);
        }
        return doc;
    }

    AQxmlDocument processStreamsStartCapture(NodeList nl) throws AQxmlException {
        String capture_name = null;
        String db = null;
        AQxmlDebug.trace(4, "AQxmlConverter.processStreamsStartCapture", "entry");
        block4: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            Integer xmlElement = this.getNextAQElement(n);
            if (xmlElement == null) {
                AQxmlDebug.trace(4, "AQxmlConverter.generateAQxmlDocument", "Null Element");
                continue;
            }
            switch (xmlElement) {
                case 2340: {
                    db = n.getChildNodes().item(0).getNodeValue();
                    continue block4;
                }
                case 2280: {
                    capture_name = n.getChildNodes().item(0).getNodeValue();
                    continue block4;
                }
                default: {
                    AQxmlError.throwAQEx(401, "Invalid Idap Tag: " + n.getNodeName());
                }
            }
        }
        StreamsStartCaptureRequest doc = new StreamsStartCaptureRequest(capture_name);
        if (db != null) {
            doc.setDBName(db);
        }
        return doc;
    }

    AQxmlDocument processStreamsStartApply(NodeList nl) throws AQxmlException {
        String apply_name = null;
        String db = null;
        AQxmlDebug.trace(4, "AQxmlConverter.processStreamsStartApply", "entry");
        block4: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            Integer xmlElement = this.getNextAQElement(n);
            if (xmlElement == null) {
                AQxmlDebug.trace(4, "AQxmlConverter.generateAQxmlDocument", "Null Element");
                continue;
            }
            switch (xmlElement) {
                case 2340: {
                    db = n.getChildNodes().item(0).getNodeValue();
                    continue block4;
                }
                case 2300: {
                    apply_name = n.getChildNodes().item(0).getNodeValue();
                    continue block4;
                }
                default: {
                    AQxmlError.throwAQEx(401, "Invalid Idap Tag: " + n.getNodeName());
                }
            }
        }
        StreamsStartApplyRequest doc = new StreamsStartApplyRequest(apply_name);
        if (db != null) {
            doc.setDBName(db);
        }
        return doc;
    }

    AQxmlDocument processCommitOrRollback(int request) throws AQxmlException {
        AQxmlClientRequest ret_doc = request == 680 ? new AQxmlCommitRequest() : new AQxmlRollbackRequest();
        return ret_doc;
    }

    AQxmlDocument processRegister(NodeList nl) throws AQxmlException {
        AQxmlRegisterRequest ret_doc = null;
        AQxmlRegisterOption reg_option = null;
        NodeList regCnl = null;
        Object comCnl = null;
        Node n = null;
        Integer xmlElement = null;
        boolean auto_commit = false;
        AQxmlDebug.trace(4, "AQxmlConverter.processReceive", "entry");
        block4: for (int i = 0; i < nl.getLength(); ++i) {
            n = nl.item(i);
            xmlElement = this.getNextAQElement(n);
            if (xmlElement == null) {
                AQxmlDebug.trace(4, "AQxmlConverter.generateAQxmlDocument", "Null Element");
                continue;
            }
            switch (xmlElement) {
                case 180: {
                    regCnl = n.getChildNodes();
                    reg_option = this.genRegisterOption(regCnl);
                    continue block4;
                }
                case 680: {
                    auto_commit = true;
                    continue block4;
                }
                default: {
                    AQxmlError.throwAQEx(401, "Invalid Idap Tag: " + n.getNodeName());
                }
            }
        }
        ret_doc = new AQxmlRegisterRequest(reg_option);
        if (auto_commit) {
            ret_doc.setAutoCommit(true);
        }
        return ret_doc;
    }

    AQxmlRegisterOption genRegisterOption(NodeList nl) throws AQxmlException {
        Node n = null;
        Integer xmlElement = null;
        String destination = null;
        String consumer_name = null;
        String notify_url = null;
        AQxmlRegisterOption reg_option = null;
        this.printUtil("genRegisterOption");
        AQxmlDebug.trace(4, "AQxmlConverter.genRegisterOption", "entry");
        AQxmlDebug.trace(5, "AQxmlConverter.genRegisterOption", "NL: " + nl.getLength());
        block7: for (int i = 0; i < nl.getLength(); ++i) {
            n = nl.item(i);
            xmlElement = this.getNextAQElement(n);
            if (xmlElement == null) {
                AQxmlDebug.trace(4, "AQxmlConverter.genRegisterOption", "Null Element");
                continue;
            }
            switch (xmlElement) {
                case 60: {
                    Integer lk_code;
                    String lk_type = null;
                    destination = this.getTextNodeValue(n);
                    AQxmlDebug.trace(5, "AQxmlConverter.genRegisterOption", "Destination: " + destination);
                    try {
                        lk_type = this.getAttributeValue(n, "lookup_type");
                        lk_code = (Integer)elementHashtable.get(lk_type.toUpperCase());
                    }
                    catch (NullPointerException ne) {
                        lk_code = new Integer(660);
                    }
                    if (lk_code == 660) {
                        int pos = destination.indexOf(".");
                        if (pos == -1) {
                            reg_option = new AQxmlRegisterOption(null, destination, null, null);
                            continue block7;
                        }
                        reg_option = new AQxmlRegisterOption(destination.substring(0, pos), destination.substring(pos + 1), null, null);
                        continue block7;
                    }
                    AQxmlDebug.trace(5, "AQxmlConverter.setOracleJmsProperties", "LDAP: Destination:" + destination);
                    reg_option = new AQxmlRegisterOption(destination, null, null);
                    continue block7;
                }
                case 120: {
                    consumer_name = this.getTextNodeValue(n);
                    AQxmlDebug.trace(5, "AQxmlConverter.genRegisterOption", "Consumer Name: " + consumer_name);
                    reg_option.setConsumerName(consumer_name);
                    continue block7;
                }
                case 190: {
                    notify_url = this.getTextNodeValue(n);
                    AQxmlDebug.trace(5, "AQxmlConverter.genRegisterOption", "Notify Url: " + notify_url);
                    reg_option.setUrl(notify_url);
                    continue block7;
                }
                default: {
                    AQxmlError.throwAQEx(401, "Invalid xml tag: " + n.getNodeName());
                }
            }
        }
        return reg_option;
    }

    AQxmlDocument processPush(NodeList root_cnl) throws AQxmlException {
        AQxmlPushRequest ret_doc = null;
        AQxmlProducerOption prod_option = null;
        NodeList push_cnl = null;
        NodeList msg_cnl = null;
        Object com_cnl = null;
        Node n = null;
        Integer xmlElement = null;
        boolean auto_commit = false;
        Vector xml_msg_list = null;
        this.printUtil("processPush");
        AQxmlDebug.trace(4, "AQxmlConverter.processPush", "entry");
        block5: for (int i = 0; i < root_cnl.getLength(); ++i) {
            n = root_cnl.item(i);
            xmlElement = this.getNextAQElement(n);
            if (xmlElement == null) {
                AQxmlDebug.trace(4, "AQxmlConverter.processPush", "Null Element");
                continue;
            }
            switch (xmlElement) {
                case 215: {
                    AQxmlDebug.trace(4, "AQxmlConverter.processPush", "Push Options");
                    push_cnl = n.getChildNodes();
                    prod_option = this.genProducerOption(push_cnl);
                    continue block5;
                }
                case 350: {
                    msg_cnl = n.getChildNodes();
                    xml_msg_list = this.genMessageList(msg_cnl);
                    continue block5;
                }
                case 680: {
                    auto_commit = true;
                    continue block5;
                }
                default: {
                    AQxmlError.throwAQEx(401, "Invalid Idap Tag: " + n.getNodeName());
                }
            }
        }
        ret_doc = new AQxmlPushRequest(prod_option, xml_msg_list);
        if (auto_commit) {
            ret_doc.setAutoCommit(true);
        }
        return ret_doc;
    }

    AQxmlDocument processSequenceNumReq(NodeList root_cnl) throws AQxmlException {
        AQxmlSequenceNumRequest ret_doc = null;
        NodeList destination_cnl = null;
        NodeList dblink_cnl = null;
        NodeList qid_cnl = null;
        Node n = null;
        Integer xmlElement = null;
        boolean auto_commit = false;
        this.printUtil("processSequenceNumReq");
        AQxmlDebug.trace(4, "AQxmlConverter.processSequenceNumReq", "entry");
        block6: for (int i = 0; i < root_cnl.getLength(); ++i) {
            n = root_cnl.item(i);
            xmlElement = this.getNextAQElement(n);
            if (xmlElement == null) {
                AQxmlDebug.trace(4, "AQxmlConverter.generateAQxmlDocument", "Null Element");
                continue;
            }
            switch (xmlElement) {
                case 60: {
                    destination_cnl = n.getChildNodes();
                    continue block6;
                }
                case 900: {
                    qid_cnl = n.getChildNodes();
                    continue block6;
                }
                case 2030: {
                    dblink_cnl = n.getChildNodes();
                    continue block6;
                }
                case 680: {
                    auto_commit = true;
                    continue block6;
                }
                default: {
                    AQxmlError.throwAQEx(401, "Invalid Idap Tag: " + n.getNodeName());
                }
            }
        }
        ret_doc = new AQxmlSequenceNumRequest(dblink_cnl.item(0).getNodeValue(), destination_cnl.item(0).getNodeValue(), qid_cnl.item(0).getNodeValue());
        if (auto_commit) {
            ret_doc.setAutoCommit(true);
        }
        return ret_doc;
    }

    AQxmlDocument processQueueTypeReq(NodeList root_cnl) throws AQxmlException {
        NodeList destination_cnl = null;
        Node n = null;
        Integer xmlElement = null;
        boolean auto_commit = false;
        this.printUtil("processQueueTypeReq");
        AQOracleDebug.trace(4, "AQxmlConverter.processQueueTypeReq", "entry");
        block4: for (int i = 0; i < root_cnl.getLength(); ++i) {
            n = root_cnl.item(i);
            xmlElement = this.getNextAQElement(n);
            if (xmlElement == null) {
                AQxmlDebug.trace(4, "AQxmlConverter.processQueueTypeReq", "Null Element");
                continue;
            }
            switch (xmlElement) {
                case 60: {
                    destination_cnl = n.getChildNodes();
                    continue block4;
                }
                case 680: {
                    auto_commit = true;
                    continue block4;
                }
                default: {
                    AQxmlError.throwAQEx(401, "Invalid Idap Tag: " + n.getNodeName());
                }
            }
        }
        AQxmlTypeInfoRequest ret_doc = new AQxmlTypeInfoRequest(destination_cnl.item(0).getNodeValue());
        if (auto_commit) {
            ret_doc.setAutoCommit(true);
        }
        return ret_doc;
    }

    NodeList getNodeList(NodeList nl, String node_name) throws AQxmlException {
        Node n = null;
        Object n_name = null;
        NodeList ret_nl = null;
        int i = 0;
        String n_local_name = null;
        AQxmlDebug.trace(5, "AQxmlConverter.getNodeList", "NL: " + nl.getLength());
        n = nl.item(i);
        n_local_name = ((XMLElement)n).getLocalName();
        while (!n_local_name.equalsIgnoreCase(node_name)) {
            n = nl.item(++i);
            n_local_name = ((XMLElement)n).getLocalName();
        }
        if (n_local_name.equalsIgnoreCase(node_name)) {
            ret_nl = n.getChildNodes();
        } else {
            AQxmlDebug.trace(4, "AQxmlConverter.getNodeList", "Error: node is not " + node_name);
            AQxmlError.throwAQEx(401, node_name + " Node not found");
        }
        return ret_nl;
    }

    AQxmlDocument processSend(NodeList root_cnl, int dest_type) throws AQxmlException {
        AQxmlProducerOption prodOption = null;
        NodeList prodCnl = null;
        NodeList msgCnl = null;
        Object prodNode = null;
        Object msgNode = null;
        Object prodNodeName = null;
        Object msgNodeName = null;
        Object comCnl = null;
        Node n = null;
        Integer xmlElement = null;
        boolean auto_commit = false;
        Vector xml_msg_list = null;
        this.printUtil("processSend");
        AQxmlDebug.trace(4, "AQxmlConverter.processSend", "entry");
        block5: for (int i = 0; i < root_cnl.getLength(); ++i) {
            n = root_cnl.item(i);
            xmlElement = this.getNextAQElement(n);
            if (xmlElement == null) {
                AQxmlDebug.trace(4, "AQxmlConverter.generateAQxmlDocument", "Null Element");
                continue;
            }
            switch (xmlElement) {
                case 50: {
                    prodCnl = n.getChildNodes();
                    prodOption = this.genProducerOption(prodCnl);
                    continue block5;
                }
                case 350: {
                    msgCnl = n.getChildNodes();
                    xml_msg_list = this.genMessageList(msgCnl);
                    continue block5;
                }
                case 680: {
                    auto_commit = true;
                    continue block5;
                }
                default: {
                    AQxmlError.throwAQEx(401, "Invalid Idap Tag: " + n.getNodeName());
                }
            }
        }
        AQxmlEnqueueRequest retDoc = dest_type == 1 ? new AQxmlSendRequest(prodOption, xml_msg_list) : new AQxmlPublishRequest(prodOption, xml_msg_list);
        if (auto_commit) {
            ((AQxmlEnqueueRequest)retDoc).setAutoCommit(true);
        }
        return retDoc;
    }

    AQxmlDocument processReceive(NodeList root_cnl) throws AQxmlException {
        AQxmlConsumerOption consumerOption = null;
        NodeList consumerCnl = null;
        Object comCnl = null;
        Node n = null;
        Integer xmlElement = null;
        boolean auto_commit = false;
        this.printUtil("processReceive");
        AQxmlDebug.trace(4, "AQxmlConverter.processReceive", "entry");
        block4: for (int i = 0; i < root_cnl.getLength(); ++i) {
            n = root_cnl.item(i);
            xmlElement = this.getNextAQElement(n);
            if (xmlElement == null) {
                AQxmlDebug.trace(4, "AQxmlConverter.generateAQxmlDocument", "Null Element");
                continue;
            }
            switch (xmlElement) {
                case 110: {
                    consumerCnl = n.getChildNodes();
                    consumerOption = this.genConsumerOption(consumerCnl);
                    continue block4;
                }
                case 680: {
                    auto_commit = true;
                    continue block4;
                }
                default: {
                    AQxmlError.throwAQEx(401, "Invalid Idap Tag: " + n.getNodeName());
                }
            }
        }
        AQxmlReceiveRequest retDoc = new AQxmlReceiveRequest(consumerOption);
        if (auto_commit) {
            retDoc.setAutoCommit(true);
        }
        return retDoc;
    }

    AQxmlProducerOption genProducerOption(NodeList nl) throws AQxmlException {
        Node n = null;
        Integer xmlElement = null;
        String destination = null;
        Object dest_owner = null;
        Object dest_name = null;
        boolean msg_priority = false;
        boolean msg_expiration = false;
        int seq_number = 0;
        String db_link = null;
        int source_qid = 0;
        String prod_txfm = null;
        Object rl_cnl = null;
        AQxmlProducerOption prodOption = null;
        String visib = null;
        this.printUtil("genProducerOption");
        AQxmlDebug.trace(4, "AQxmlConverter.genProducerOption", "entry");
        AQxmlDebug.trace(5, "AQxmlConverter.genProducerOption", "NL: " + nl.getLength());
        block10: for (int i = 0; i < nl.getLength(); ++i) {
            n = nl.item(i);
            xmlElement = this.getNextAQElement(n);
            if (xmlElement == null) {
                AQxmlDebug.trace(4, "AQxmlConverter.genProducerOption", "Null Element");
                continue;
            }
            switch (xmlElement) {
                case 60: {
                    Integer lk_code;
                    String lk_type = null;
                    destination = this.getTextNodeValue(n);
                    AQxmlDebug.trace(5, "AQxmlConverter.genProducerOption", "Destination: " + destination);
                    try {
                        lk_type = this.getAttributeValue(n, "lookup_type");
                        lk_code = (Integer)elementHashtable.get(lk_type.toUpperCase());
                    }
                    catch (NullPointerException ne) {
                        lk_code = new Integer(660);
                    }
                    if (lk_code == 660) {
                        int pos = destination.indexOf(".");
                        if (pos == -1) {
                            prodOption = new AQxmlProducerOption(null, destination);
                            continue block10;
                        }
                        prodOption = new AQxmlProducerOption(destination.substring(0, pos), destination.substring(pos + 1));
                        continue block10;
                    }
                    AQxmlDebug.trace(5, "AQxmlConverter.genProducerOption", "LDAP: Destination:" + destination);
                    prodOption = new AQxmlProducerOption(destination);
                    continue block10;
                }
                case 55: {
                    visib = this.getTextNodeValue(n);
                    AQxmlDebug.trace(5, "AQxmlConverter.genProducerOption", "Visibility: " + visib);
                    if (visib.equalsIgnoreCase("IMMEDIATE")) {
                        prodOption.setVisibility(1);
                        continue block10;
                    }
                    if (!visib.equalsIgnoreCase("ON_COMMIT")) continue block10;
                    prodOption.setVisibility(2);
                    continue block10;
                }
                case 270: {
                    String snum = this.getTextNodeValue(n);
                    seq_number = Integer.parseInt(snum.trim());
                    AQxmlDebug.trace(5, "AQxmlConverter.genProducerOption", "Seq Number: " + seq_number);
                    prodOption.setSequenceNumber(seq_number);
                    continue block10;
                }
                case 2030: {
                    db_link = this.getTextNodeValue(n);
                    AQxmlDebug.trace(5, "AQxmlConverter.genProducerOption", "DB Link: " + db_link);
                    prodOption.setDbLink(db_link);
                    continue block10;
                }
                case 900: {
                    String sqid = this.getTextNodeValue(n);
                    source_qid = Integer.parseInt(sqid.trim());
                    AQxmlDebug.trace(5, "AQxmlConverter.genProducerOption", "Source QID: " + source_qid);
                    prodOption.setSourceQid(source_qid);
                    continue block10;
                }
                case 2040: {
                    prod_txfm = this.getTextNodeValue(n);
                    AQxmlDebug.trace(5, "AQxmlConverter.genProducerOption", "Transformation:" + prod_txfm);
                    prodOption.setTransformation(prod_txfm);
                    continue block10;
                }
                default: {
                    AQxmlError.throwAQEx(401, "Invalid xml tag: " + n.getNodeName());
                }
            }
        }
        return prodOption;
    }

    AQxmlConsumerOption genConsumerOption(NodeList nl) throws AQxmlException {
        Node n = null;
        Integer xmlElement = null;
        String destination = null;
        Object dest_owner = null;
        Object dest_name = null;
        String consumer_name = null;
        int dequeue_mode = 0;
        String deq_mode_str = null;
        int navig_mode = 0;
        String navig_mode_str = null;
        int wait_time = 0;
        Object selector = null;
        int batch_size = 1;
        String cnsmr_txfm = null;
        NodeList cnl = null;
        String visib = null;
        AQxmlConsumerOption consumerOption = null;
        AQxmlDebug.trace(4, "AQxmlConverter.genConsumerOption", "entry");
        this.printUtil("genConsumerOption");
        AQxmlDebug.trace(5, "AQxmlConverter.genConsumerOption", "NL: " + nl.getLength());
        block14: for (int i = 0; i < nl.getLength(); ++i) {
            n = nl.item(i);
            xmlElement = this.getNextAQElement(n);
            if (xmlElement == null) {
                AQxmlDebug.trace(4, "AQxmlConverter.genConsumerOption", "Null Element");
                continue;
            }
            switch (xmlElement) {
                case 60: {
                    Integer lk_code;
                    String lk_type = null;
                    destination = this.getTextNodeValue(n);
                    AQxmlDebug.trace(5, "AQxmlConverter.genConsumerOption", "Destination: " + destination);
                    try {
                        lk_type = this.getAttributeValue(n, "lookup_type");
                        lk_code = (Integer)elementHashtable.get(lk_type.toUpperCase());
                    }
                    catch (NullPointerException ne) {
                        lk_code = new Integer(660);
                    }
                    if (lk_code == 660) {
                        int pos = destination.indexOf(".");
                        if (pos == -1) {
                            consumerOption = new AQxmlConsumerOption(null, destination);
                            continue block14;
                        }
                        consumerOption = new AQxmlConsumerOption(destination.substring(0, pos), destination.substring(pos + 1));
                        continue block14;
                    }
                    AQxmlDebug.trace(5, "AQxmlConverter.genConsumerOption", "LDAP: Destination:" + destination);
                    consumerOption = new AQxmlConsumerOption(destination);
                    continue block14;
                }
                case 120: {
                    consumer_name = this.getTextNodeValue(n);
                    AQxmlDebug.trace(5, "AQxmlConverter.genConsumerOption", "Consumer Name: " + consumer_name);
                    consumerOption.setConsumerName(consumer_name);
                    continue block14;
                }
                case 125: {
                    deq_mode_str = this.getTextNodeValue(n);
                    if (deq_mode_str.equalsIgnoreCase("BROWSE")) {
                        dequeue_mode = 1;
                    } else if (deq_mode_str.equalsIgnoreCase("LOCKED")) {
                        dequeue_mode = 2;
                    } else if (deq_mode_str.equalsIgnoreCase("REMOVE")) {
                        dequeue_mode = 3;
                    } else if (deq_mode_str.equalsIgnoreCase("REMOVE_NODATA")) {
                        dequeue_mode = 4;
                    } else if (deq_mode_str.equalsIgnoreCase("GET_SIGNATURE")) {
                        dequeue_mode = 5;
                    }
                    AQxmlDebug.trace(5, "AQxmlConverter.genConsumerOption", "Dequeue Mode: " + dequeue_mode);
                    consumerOption.setDequeueMode(dequeue_mode);
                    continue block14;
                }
                case 127: {
                    navig_mode_str = this.getTextNodeValue(n);
                    if (navig_mode_str.equalsIgnoreCase("FIRST_MESSAGE")) {
                        navig_mode = 1;
                    } else if (navig_mode_str.equalsIgnoreCase("NEXT_MESSAGE")) {
                        navig_mode = 3;
                    } else if (navig_mode_str.equalsIgnoreCase("NEXT_TRANSACTION")) {
                        navig_mode = 2;
                    }
                    AQxmlDebug.trace(5, "AQxmlConverter.genConsumerOption", "Navigation: " + navig_mode);
                    consumerOption.setNavigationMode(navig_mode);
                    continue block14;
                }
                case 130: {
                    String wt_time = this.getTextNodeValue(n);
                    wait_time = Integer.parseInt(wt_time.trim());
                    AQxmlDebug.trace(5, "AQxmlConverter.genConsumerOption", "Wait Time: " + wait_time);
                    consumerOption.setWaitTime(wait_time);
                    continue block14;
                }
                case 140: {
                    cnl = n.getChildNodes();
                    AQxmlDebug.trace(5, "AQxmlConverter.genConsumerOption", "Selector");
                    this.processSelector(cnl, consumerOption);
                    continue block14;
                }
                case 210: {
                    String b_size = this.getTextNodeValue(n);
                    batch_size = Integer.parseInt(b_size.trim());
                    AQxmlDebug.trace(5, "AQxmlConverter.genConsumerOption", "Batch Size: " + batch_size);
                    consumerOption.setBatchSize(batch_size);
                    continue block14;
                }
                case 1041: {
                    NodeList cnlsig = null;
                    cnlsig = n.getChildNodes();
                    this.setMessageSignature(cnlsig, consumerOption);
                    continue block14;
                }
                case 2040: {
                    cnsmr_txfm = this.getTextNodeValue(n);
                    consumerOption.setTransformation(cnsmr_txfm);
                    continue block14;
                }
                case 55: {
                    visib = this.getTextNodeValue(n);
                    AQxmlDebug.trace(5, "AQxmlConverter.genConsumerOption", "Visibility: " + visib);
                    if (visib.equalsIgnoreCase("IMMEDIATE")) {
                        consumerOption.setVisibility(1);
                        continue block14;
                    }
                    if (!visib.equalsIgnoreCase("ON_COMMIT")) continue block14;
                    consumerOption.setVisibility(2);
                    continue block14;
                }
                default: {
                    AQxmlError.throwAQEx(401, "Invalid xml tag: " + n.getNodeName());
                }
            }
        }
        AQxmlDebug.trace(5, "AQxmlConverter.genConsumerOption", "Return Consumer Option");
        return consumerOption;
    }

    void processSelector(NodeList nl, AQxmlConsumerOption cons_opt) throws AQxmlException {
        Node n = null;
        Object cnl = null;
        Integer xmlElement = null;
        String msgid = null;
        this.printUtil("genMessageList");
        AQxmlDebug.trace(4, "AQxmlConverter.processSelector", "entry");
        AQxmlDebug.trace(5, "AQxmlConverter.processSelector", "NL: " + nl.getLength());
        block5: for (int i = 0; i < nl.getLength(); ++i) {
            n = nl.item(i);
            xmlElement = this.getNextAQElement(n);
            if (xmlElement == null) {
                AQxmlDebug.trace(4, "AQxmlConverter.genMessageList", "Null Element");
                continue;
            }
            switch (xmlElement) {
                case 150: {
                    msgid = this.getTextNodeValue(n);
                    if (msgid.startsWith("ID:")) {
                        msgid = msgid.substring(3);
                    }
                    cons_opt.setMessageId(AQxmlConverter.convertHexStringToByte(msgid));
                    continue block5;
                }
                case 400: {
                    cons_opt.setCorrelation(this.getTextNodeValue(n));
                    continue block5;
                }
                case 170: {
                    cons_opt.setCondition(this.getTextNodeValue(n));
                    continue block5;
                }
                default: {
                    AQxmlError.throwAQEx(401, "Invalid xml tag: " + n.getNodeName());
                }
            }
        }
    }

    Vector genMessageList(NodeList nl) throws AQxmlException {
        Node n = null;
        NodeList cnl = null;
        Integer xmlElement = null;
        Vector xml_msg_list = null;
        this.printUtil("genMessageList");
        AQxmlDebug.trace(4, "AQxmlConverter.genMessageList", "entry");
        AQxmlDebug.trace(5, "AQxmlConverter.genMessageList", "NL: " + nl.getLength());
        xml_msg_list = new Vector();
        block4: for (int i = 0; i < nl.getLength(); ++i) {
            n = nl.item(i);
            xmlElement = this.getNextAQElement(n);
            if (xmlElement == null) {
                AQxmlDebug.trace(4, "AQxmlConverter.genMessageList", "Null Element");
                continue;
            }
            switch (xmlElement) {
                case 790: {
                    continue block4;
                }
                case 360: {
                    cnl = n.getChildNodes();
                    this.i_genMessage(cnl, xml_msg_list);
                    continue block4;
                }
                default: {
                    AQxmlError.throwAQEx(401, "Invalid xml tag: " + n.getNodeName());
                }
            }
        }
        return xml_msg_list;
    }

    void i_genMessage(NodeList nl, Vector xml_msg_list) throws AQxmlException {
        Node n = null;
        NodeList cnl = null;
        Integer xmlElement = null;
        AQxmlMessage xml_msg = null;
        this.printUtil("i_genMessage");
        AQxmlDebug.trace(4, "AQxmlConverter.i_genMessage", "entry");
        if (this.msg_type == -1) {
            AQxmlError.throwAQEx(401, "message type not set");
        }
        switch (this.msg_type) {
            case 0: {
                AQxmlDebug.trace(5, "AQxmlConverter.i_genMessage", "Instantiated JMS Text Message");
                xml_msg = new AQxmlJmsTextMessage(new AQjmsTextMessage());
                break;
            }
            case 1: {
                AQxmlDebug.trace(5, "AQxmlConverter.i_genMessage", "Instantiated JMS Bytes Message");
                xml_msg = new AQxmlJmsBytesMessage(new AQjmsBytesMessage());
                break;
            }
            case 2: {
                AQxmlDebug.trace(5, "AQxmlConverter.i_genMessage", "Instantiated JMS Map Message");
                xml_msg = new AQxmlJmsMapMessage(new AQjmsMapMessage());
                break;
            }
            case 3: {
                AQxmlDebug.trace(5, "AQxmlConverter.i_genMessage", "Instantiated JMS Object Message");
                xml_msg = new AQxmlJmsObjectMessage(new AQjmsObjectMessage());
                break;
            }
            case 4: {
                AQxmlDebug.trace(5, "AQxmlConverter.i_genMessage", "Instantiated Xml Adt Message");
                xml_msg = new AQxmlAdtMessage();
                break;
            }
            case 5: {
                AQxmlDebug.trace(5, "AQxmlConverter.i_genMessage", "Instantiated Raw Message");
                xml_msg = new AQxmlRawMessage();
                break;
            }
            default: {
                AQxmlError.throwAQEx(401, "Invalid xml tag: " + n.getNodeName());
            }
        }
        AQxmlDebug.trace(5, "AQxmlConverter.i_genMessage", "NL: " + nl.getLength());
        block14: for (int i = 0; i < nl.getLength(); ++i) {
            n = nl.item(i);
            xmlElement = this.getNextAQElement(n);
            if (xmlElement == null) {
                AQxmlDebug.trace(4, "AQxmlConverter.i_genMessage", "Null Element");
                continue;
            }
            switch (xmlElement) {
                case 280: {
                    continue block14;
                }
                case 380: {
                    cnl = n.getChildNodes();
                    this.setMessageHeader(cnl, xml_msg);
                    continue block14;
                }
                case 610: {
                    cnl = n.getChildNodes();
                    this.setMessagePayload(cnl, xml_msg);
                    continue block14;
                }
                case 1041: {
                    cnl = n.getChildNodes();
                    this.setMessageSignature(cnl, xml_msg);
                    continue block14;
                }
                default: {
                    AQxmlError.throwAQEx(401, "Invalid xml tag: " + n.getNodeName());
                }
            }
        }
        xml_msg_list.addElement(xml_msg);
    }

    void setUserOrMapProperties(NodeList nl, AQxmlMessage msg) throws AQxmlException {
        Node n = null;
        NodeList cnl = null;
        Integer xmlElement = null;
        Object value_type = null;
        this.printUtil("setUserOrMapProperties");
        AQxmlDebug.trace(4, "AQxmlConverter.setUserOrMapProperties", "entry");
        AQxmlDebug.trace(5, "AQxmlConverter.setUserOrMapProperties", "NL: " + nl.getLength());
        block4: for (int i = 0; i < nl.getLength(); ++i) {
            n = nl.item(i);
            xmlElement = this.getNextAQElement(n);
            if (xmlElement == null) {
                AQxmlDebug.trace(4, "AQxmlConverter.setUserOrMapProperties", "Null Element");
                continue;
            }
            switch (xmlElement) {
                case 580: {
                    cnl = n.getChildNodes();
                    this.i_setUserOrMapProperties(cnl, msg, true);
                    continue block4;
                }
                case 840: {
                    cnl = n.getChildNodes();
                    this.i_setUserOrMapProperties(cnl, msg, false);
                    continue block4;
                }
                default: {
                    AQxmlError.throwAQEx(401, "Invalid xml tag: " + n.getNodeName());
                }
            }
        }
    }

    void i_setUserOrMapProperties(NodeList nl, AQxmlMessage xml_msg, boolean called_from_user_prop) throws AQxmlException {
        Node n = null;
        Object cnl = null;
        Integer xmlElement = null;
        String nv_name = null;
        String nv_string_value = null;
        Integer nv_int_value = null;
        long nv_long_value = 0L;
        Double nv_double_value = null;
        Boolean nv_bool_value = null;
        Float nv_float_value = null;
        Short nv_short_value = null;
        Byte nv_byte_value = null;
        AQjmsMessage msg = null;
        this.printUtil("i_setUserOrMapProperties");
        AQxmlDebug.trace(4, "AQxmlConverter.i_setUserOrMapProperties", "entry");
        if (xml_msg instanceof AQxmlJmsMessage) {
            msg = (AQjmsMessage)((AQxmlJmsMessage)xml_msg).getJmsMessage();
        } else {
            AQxmlError.throwAQEx(401, "Invalid Message type");
        }
        try {
            AQxmlDebug.trace(5, "AQxmlConsumer.i_setUserOrMapProperties", "NL: " + nl.getLength());
            block13: for (int i = 0; i < nl.getLength(); ++i) {
                n = nl.item(i);
                xmlElement = this.getNextAQElement(n);
                if (xmlElement == null) {
                    AQxmlDebug.trace(5, "AQxmlConsumer.i_setUserOrMapProperties", "Null element");
                    continue;
                }
                switch (xmlElement) {
                    case 590: {
                        nv_name = this.getTextNodeValue(n);
                        AQxmlDebug.trace(5, "AQxmlConsumer.i_setUserOrMapProperties", "name: " + nv_name);
                        continue block13;
                    }
                    case 605: {
                        nv_string_value = this.getTextNodeValue(n);
                        AQxmlDebug.trace(5, "AQxmlConsumer.i_setUserOrMapProperties", "str_value: " + nv_string_value);
                        if (called_from_user_prop) {
                            msg.setObjectProperty(nv_name, nv_string_value);
                            continue block13;
                        }
                        ((AQjmsMapMessage)msg).setObject(nv_name, nv_string_value);
                        continue block13;
                    }
                    case 600: {
                        nv_string_value = this.getTextNodeValue(n);
                        AQxmlDebug.trace(5, "AQxmlConsumer.i_setUserOrMapProperties", "int_value: " + nv_string_value);
                        nv_int_value = Integer.valueOf(nv_string_value);
                        if (called_from_user_prop) {
                            msg.setObjectProperty(nv_name, nv_int_value);
                            continue block13;
                        }
                        ((AQjmsMapMessage)msg).setObject(nv_name, nv_int_value);
                        continue block13;
                    }
                    case 601: {
                        nv_string_value = this.getTextNodeValue(n);
                        nv_long_value = Long.parseLong(nv_string_value);
                        AQxmlDebug.trace(5, "AQxmlConsumer.i_setUserOrMapProperties", "long_value: " + nv_long_value);
                        if (called_from_user_prop) {
                            msg.setLongProperty(nv_name, nv_long_value);
                            continue block13;
                        }
                        ((AQjmsMapMessage)msg).setLong(nv_name, nv_long_value);
                        continue block13;
                    }
                    case 602: {
                        nv_string_value = this.getTextNodeValue(n);
                        AQxmlDebug.trace(5, "AQxmlConsumer.i_setUserOrMapProperties", "double_value: " + nv_string_value);
                        nv_double_value = Double.valueOf(nv_string_value);
                        if (called_from_user_prop) {
                            msg.setObjectProperty(nv_name, nv_double_value);
                            continue block13;
                        }
                        ((AQjmsMapMessage)msg).setObject(nv_name, nv_double_value);
                        continue block13;
                    }
                    case 603: {
                        nv_string_value = this.getTextNodeValue(n);
                        AQxmlDebug.trace(5, "AQxmlConsumer.i_setUserOrMapProperties", "boolean_value: " + nv_string_value);
                        nv_bool_value = Boolean.valueOf(nv_string_value);
                        if (called_from_user_prop) {
                            msg.setObjectProperty(nv_name, nv_bool_value);
                            continue block13;
                        }
                        ((AQjmsMapMessage)msg).setObject(nv_name, nv_bool_value);
                        continue block13;
                    }
                    case 604: {
                        nv_string_value = this.getTextNodeValue(n);
                        AQxmlDebug.trace(5, "AQxmlConsumer.i_setUserOrMapProperties", "float_value: " + nv_string_value);
                        nv_float_value = Float.valueOf(nv_string_value);
                        if (called_from_user_prop) {
                            msg.setObjectProperty(nv_name, nv_float_value);
                            continue block13;
                        }
                        ((AQjmsMapMessage)msg).setObject(nv_name, nv_float_value);
                        continue block13;
                    }
                    case 606: {
                        nv_string_value = this.getTextNodeValue(n);
                        AQxmlDebug.trace(5, "AQxmlConsumer.i_setUserOrMapProperties", "short_value: " + nv_string_value);
                        nv_short_value = Short.valueOf(nv_string_value);
                        if (called_from_user_prop) {
                            msg.setObjectProperty(nv_name, nv_short_value);
                            continue block13;
                        }
                        ((AQjmsMapMessage)msg).setObject(nv_name, nv_short_value);
                        continue block13;
                    }
                    case 607: {
                        nv_string_value = this.getTextNodeValue(n);
                        AQxmlDebug.trace(5, "AQxmlConsumer.i_setUserOrMapProperties", "byte_value: " + nv_string_value);
                        nv_byte_value = Byte.valueOf(nv_string_value);
                        if (called_from_user_prop) {
                            msg.setObjectProperty(nv_name, nv_byte_value);
                            continue block13;
                        }
                        ((AQjmsMapMessage)msg).setObject(nv_name, nv_byte_value);
                        continue block13;
                    }
                    default: {
                        AQxmlError.throwAQEx(401, "Invalid xml tag: " + n.getNodeName());
                    }
                }
            }
        }
        catch (JMSException jms_ex) {
            AQxmlDebug.traceEx(5, "AQxmlConsumer.i_setUserOrMapProperties", (Exception)((Object)jms_ex));
            AQxmlError.throwAQEx(406, (Exception)((Object)jms_ex));
        }
    }

    void setMessageSignature(NodeList nl, AQxmlConsumerOption consumerOption) throws AQxmlException {
        AQxmlSignature sign = new AQxmlSignature();
        this.printUtil("setMessageSignature");
        AQOracleDebug.trace(5, "AQxmlConverter.setMessageSignature", "entry");
        AQOracleDebug.trace(5, "setMessageSignature", "NL: " + nl.getLength());
        this.setMessageSignature(nl, sign);
        consumerOption.setSignature(sign);
    }

    void setMessageSignature(NodeList nl, AQxmlMessage xml_msg) throws AQxmlException {
        this.printUtil("setMessageSignature");
        AQOracleDebug.trace(5, "AQxmlConverter.setMessageSignature", "entry");
        AQOracleDebug.trace(5, "setMessageSignature", "NL: " + nl.getLength());
        if (this.msg_type == 4 || this.msg_type == 5) {
            AQOracleDebug.trace(5, "AQxmlConverter.setMessageSignature", "Constructing Adt Msg Signature ");
            AQxmlSignature sign = new AQxmlSignature();
            this.setMessageSignature(nl, sign);
            xml_msg.setSignature(sign);
        } else {
            AQOracleDebug.trace(5, "AQxmlConverter.setMessageSignature", "Constructing Jms Msg Signature ");
            AQjmsSignature sign = new AQjmsSignature();
            AQjmsMessage msg = (AQjmsMessage)((AQxmlJmsMessage)xml_msg).getJmsMessage();
            this.setMessageSignature(nl, sign);
            msg.setSignature(sign);
        }
    }

    void setMessageSignature(NodeList nl, AQjmsSignature sign) throws AQxmlException {
        Node n = null;
        NodeList cnl = null;
        Integer xmlElement = null;
        block6: for (int i = 0; i < nl.getLength(); ++i) {
            n = nl.item(i);
            xmlElement = this.getNextAQElement(n);
            switch (xmlElement) {
                case 1042: {
                    cnl = n.getChildNodes();
                    this.i_setMessageSignedInfo(cnl, sign);
                    continue block6;
                }
                case 1048: {
                    String bytes_payload = this.getTextNodeValue(n);
                    byte[] bdata = null;
                    bdata = AQxmlConverter.convertHexStringToByte(bytes_payload);
                    try {
                        sign.setSignature(bdata);
                    }
                    catch (SQLException sql_ex) {
                        AQxmlDebug.traceEx(3, "AQxmlConverter.setMessageSignature", sql_ex);
                        AQxmlError.throwAQEx(410, sql_ex);
                    }
                    continue block6;
                }
                default: {
                    AQOracleDebug.trace(5, "setMessageSignature: Unprocessed xml tag: ", n.getNodeName());
                }
            }
        }
    }

    void setMessageSignature(NodeList nl, AQxmlSignature sign) throws AQxmlException {
        Node n = null;
        NodeList cnl = null;
        Integer xmlElement = null;
        block4: for (int i = 0; i < nl.getLength(); ++i) {
            n = nl.item(i);
            xmlElement = this.getNextAQElement(n);
            switch (xmlElement) {
                case 1042: {
                    cnl = n.getChildNodes();
                    this.i_setMessageSignedInfo(cnl, sign);
                    continue block4;
                }
                case 1048: {
                    String bytes_payload = this.getTextNodeValue(n);
                    byte[] bdata = null;
                    bdata = AQxmlConverter.convertHexStringToByte(bytes_payload);
                    sign.setSignature(bdata);
                    continue block4;
                }
                default: {
                    AQOracleDebug.trace(5, "setMessageSignature: Unprocessed xml tag: ", n.getNodeName());
                }
            }
        }
    }

    void i_setMessageSignedInfo(NodeList nl, AQjmsSignature sign) throws AQxmlException {
        Node n = null;
        NodeList cnl = null;
        Integer xmlElement = null;
        this.printUtil("i_setMessageSignedInfo");
        AQOracleDebug.trace(5, "AQxmlConverter.i_setMessageSignedInfo", "entry");
        AQOracleDebug.trace(5, "i_setMessageSignedInfo", "NL: " + nl.getLength());
        block9: for (int i = 0; i < nl.getLength(); ++i) {
            n = nl.item(i);
            xmlElement = this.getNextAQElement(n);
            switch (xmlElement) {
                case 1043: {
                    String algoval = this.getAttributeValue(n, "Algorithm");
                    try {
                        sign.setCanalgo(algoval);
                    }
                    catch (SQLException sql_ex) {
                        AQxmlDebug.traceEx(3, "AQxmlConverter.setMessageSignature", sql_ex);
                        AQxmlError.throwAQEx(410, sql_ex);
                    }
                    continue block9;
                }
                case 1044: {
                    String algoval = this.getAttributeValue(n, "Algorithm");
                    try {
                        sign.setSigalgo(algoval);
                    }
                    catch (SQLException sql_ex) {
                        AQxmlDebug.traceEx(3, "AQxmlConverter.setMessageSignature", sql_ex);
                        AQxmlError.throwAQEx(410, sql_ex);
                    }
                    continue block9;
                }
                case 1045: {
                    cnl = n.getChildNodes();
                    this.i_setMessageSignReference(cnl, sign);
                    continue block9;
                }
                default: {
                    AQOracleDebug.trace(5, "i_setMessageSignedInfo:Unprocessed xml tag: ", n.getNodeName());
                }
            }
        }
    }

    void i_setMessageSignedInfo(NodeList nl, AQxmlSignature sign) throws AQxmlException {
        Node n = null;
        NodeList cnl = null;
        Integer xmlElement = null;
        this.printUtil("i_setMessageSignedInfo");
        AQOracleDebug.trace(5, "AQxmlConverter.i_setMessageSignedInfo", "entry");
        AQOracleDebug.trace(5, "i_setMessageSignedInfo", "NL: " + nl.getLength());
        block5: for (int i = 0; i < nl.getLength(); ++i) {
            n = nl.item(i);
            xmlElement = this.getNextAQElement(n);
            switch (xmlElement) {
                case 1043: {
                    String algoval = this.getAttributeValue(n, "Algorithm");
                    sign.setCanalgo(algoval);
                    continue block5;
                }
                case 1044: {
                    String algoval = this.getAttributeValue(n, "Algorithm");
                    sign.setSigalgo(algoval);
                    continue block5;
                }
                case 1045: {
                    cnl = n.getChildNodes();
                    this.i_setMessageSignReference(cnl, sign);
                    continue block5;
                }
                default: {
                    AQOracleDebug.trace(5, "i_setMessageSignedInfo:Unprocessed xml tag: ", n.getNodeName());
                }
            }
        }
    }

    void i_setMessageSignReference(NodeList nl, AQjmsSignature sign) throws AQxmlException {
        Node n = null;
        Object cnl = null;
        Integer xmlElement = null;
        this.printUtil("i_setMessageSignReference");
        AQOracleDebug.trace(5, "AQxmlConverter.i_setMessageSignReference", "entry");
        AQOracleDebug.trace(5, "i_setMessageSignReference", "NL: " + nl.getLength());
        block8: for (int i = 0; i < nl.getLength(); ++i) {
            n = nl.item(i);
            xmlElement = this.getNextAQElement(n);
            switch (xmlElement) {
                case 1046: {
                    String algoval = this.getAttributeValue(n, "Algorithm");
                    try {
                        sign.setDigalgo(algoval);
                    }
                    catch (SQLException sql_ex) {
                        AQxmlDebug.traceEx(3, "AQxmlConverter.setMessageSignature", sql_ex);
                        AQxmlError.throwAQEx(410, sql_ex);
                    }
                    continue block8;
                }
                case 1047: {
                    String bytes_payload = this.getTextNodeValue(n);
                    byte[] bdata = null;
                    bdata = AQxmlConverter.convertHexStringToByte(bytes_payload);
                    try {
                        sign.setDigval(bdata);
                    }
                    catch (SQLException sql_ex) {
                        AQxmlDebug.traceEx(3, "AQxmlConverter.setMessageSignature", sql_ex);
                        AQxmlError.throwAQEx(410, sql_ex);
                    }
                    continue block8;
                }
                default: {
                    AQOracleDebug.trace(5, "i_setMessageSignReference: Unprocessed xml tag: ", n.getNodeName());
                }
            }
        }
    }

    void i_setMessageSignReference(NodeList nl, AQxmlSignature sign) throws AQxmlException {
        Node n = null;
        Object cnl = null;
        Integer xmlElement = null;
        this.printUtil("i_setMessageSignReference");
        AQOracleDebug.trace(5, "AQxmlConverter.i_setMessageSignReference", "entry");
        AQOracleDebug.trace(5, "i_setMessageSignReference", "NL: " + nl.getLength());
        block4: for (int i = 0; i < nl.getLength(); ++i) {
            n = nl.item(i);
            xmlElement = this.getNextAQElement(n);
            switch (xmlElement) {
                case 1046: {
                    String algoval = this.getAttributeValue(n, "Algorithm");
                    sign.setDigalgo(algoval);
                    continue block4;
                }
                case 1047: {
                    String bytes_payload = this.getTextNodeValue(n);
                    byte[] bdata = null;
                    bdata = AQxmlConverter.convertHexStringToByte(bytes_payload);
                    sign.setDigval(bdata);
                    continue block4;
                }
                default: {
                    AQOracleDebug.trace(5, "i_setMessageSignReference: Unprocessed xml tag: ", n.getNodeName());
                }
            }
        }
    }

    void setMessagePayload(NodeList nl, AQxmlMessage xml_msg) throws AQxmlException {
        Node n = null;
        NodeList cnl = null;
        Integer xmlElement = null;
        this.printUtil("setMessagePayload");
        AQxmlDebug.trace(4, "AQxmlConverter.setMessagePayload", "entry");
        AQxmlDebug.trace(5, "setMessagePayload", "NL: " + nl.getLength());
        if (this.msg_type == 4) {
            this.setAdtPayload(nl.item(0), xml_msg);
            return;
        }
        block4: for (int i = 0; i < nl.getLength(); ++i) {
            n = nl.item(i);
            xmlElement = this.getNextAQElement(n);
            if (xmlElement == null && this.msg_type == -1) {
                AQxmlError.throwAQEx(401, "message type not set");
            }
            switch (xmlElement) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    cnl = n.getChildNodes();
                    this.i_setMessagePayload(cnl, xml_msg);
                    continue block4;
                }
                case 5: {
                    this.setBytesData(n, xml_msg);
                    continue block4;
                }
                default: {
                    if (this.msg_type == 4) continue block4;
                    AQxmlError.throwAQEx(401, "Invalid xml tag: " + n.getNodeName());
                }
            }
        }
    }

    void i_setMessagePayload(NodeList nl, AQxmlMessage xml_msg) throws AQxmlException {
        Node n = null;
        NodeList cnl = null;
        Integer xmlElement = null;
        this.printUtil("i_setMessagePayload");
        AQxmlDebug.trace(4, "AQxmlConverter.i_setMessagePayload", "entry");
        AQxmlDebug.trace(5, "AQxmlConverter.i_setMessagePayload", "NL: " + nl.getLength());
        block8: for (int i = 0; i < nl.getLength(); ++i) {
            n = nl.item(i);
            xmlElement = this.getNextAQElement(n);
            if (xmlElement == null) {
                AQxmlDebug.trace(4, "AQxmlConverter.i_setMessagePayload", "Null Element");
                continue;
            }
            if (this.msg_type == 4) {
                AQxmlError.throwAQEx(401, "Invalid message type");
            }
            switch (xmlElement) {
                case 740: {
                    cnl = n.getChildNodes();
                    this.setOracleJmsProperties(cnl, xml_msg);
                    continue block8;
                }
                case 570: {
                    cnl = n.getChildNodes();
                    this.setUserOrMapProperties(cnl, xml_msg);
                    continue block8;
                }
                case 700: {
                    this.setTextData(n, xml_msg);
                    continue block8;
                }
                case 710: {
                    cnl = n.getChildNodes();
                    this.setUserOrMapProperties(cnl, xml_msg);
                    continue block8;
                }
                case 720: {
                    this.setBytesData(n, xml_msg);
                    continue block8;
                }
                case 730: {
                    this.setBytesData(n, xml_msg);
                    continue block8;
                }
                default: {
                    AQxmlError.throwAQEx(401, "Invalid xml tag: " + n.getNodeName());
                }
            }
        }
    }

    void setTextData(Node n, AQxmlMessage xml_msg) throws AQxmlException {
        AQjmsTextMessage msg = null;
        this.printUtil("setTextData");
        AQxmlDebug.trace(5, "AQxmlConverter.setTextPayload", "entry");
        if (xml_msg instanceof AQxmlJmsTextMessage) {
            msg = (AQjmsTextMessage)((AQxmlJmsTextMessage)xml_msg).getJmsMessage();
        } else {
            AQxmlError.throwAQEx(401, "Invalid Msg type");
        }
        String text_payload = this.getTextNodeValue(n);
        try {
            msg.setText(text_payload);
        }
        catch (JMSException jms_ex) {
            AQxmlDebug.traceEx(3, "AQxmlConverter.setTextData", (Exception)((Object)jms_ex));
            AQxmlError.throwAQEx(406, (Exception)((Object)jms_ex));
        }
    }

    void setBytesData(Node n, AQxmlMessage xml_msg) throws AQxmlException {
        byte[] bdata = null;
        AQjmsMessage msg = null;
        this.printUtil("setBytesData");
        AQxmlDebug.trace(5, "AQxmlConverter.setBytesPayload", "entry");
        AQxmlDebug.trace(5, "AQxmlConverter.setBytesPayload", "msg_type: " + this.msg_type);
        String bytes_payload = this.getTextNodeValue(n);
        try {
            bdata = AQxmlConverter.convertHexStringToByte(bytes_payload);
            AQxmlDebug.trace(5, "AQxmlConverter.setBytesPayload", "bdata len: " + bdata.length);
            if (this.msg_type == 1) {
                AQxmlDebug.trace(5, "AQxmlConverter.setBytesPayload", "Bytes message");
                if (xml_msg instanceof AQxmlJmsBytesMessage) {
                    msg = (AQjmsBytesMessage)((AQxmlJmsBytesMessage)xml_msg).getJmsMessage();
                } else {
                    AQxmlError.throwAQEx(401, "Invalid Msg type");
                }
                msg.writeBytes(bdata);
            } else if (this.msg_type == 3) {
                AQxmlDebug.trace(5, "AQxmlConverter.setBytesPayload", "Object message");
                if (xml_msg instanceof AQxmlJmsObjectMessage) {
                    msg = (AQjmsObjectMessage)((AQxmlJmsObjectMessage)xml_msg).getJmsMessage();
                } else {
                    AQxmlError.throwAQEx(401, "Invalid Msg type");
                }
                ((AQjmsObjectMessage)msg).setBytesData(bdata);
            } else {
                AQxmlDebug.trace(5, "AQxmlConverter.setBytesPayload", "Raw message");
                ((AQxmlRawMessage)xml_msg).setBytes(bdata);
            }
        }
        catch (JMSException jms_ex) {
            AQxmlDebug.traceEx(3, "AQxmlConverter.setBytesData", (Exception)((Object)jms_ex));
            AQxmlError.throwAQEx(406, (Exception)((Object)jms_ex));
        }
    }

    void setAdtPayload(Node n, AQxmlMessage xml_msg) throws AQxmlException {
        ((AQxmlAdtMessage)xml_msg).setBodyNode(n);
    }

    void setOracleJmsProperties(NodeList nl, AQxmlMessage xml_msg) throws AQxmlException {
        Node n = null;
        Integer xmlElement = null;
        String app_id = null;
        String group_id = null;
        String group_seq = null;
        AQjmsMessage msg = null;
        AQxmlMessagePropertyList msgProp = new AQxmlMessagePropertyList();
        if (xml_msg instanceof AQxmlJmsMessage) {
            msg = (AQjmsMessage)((AQxmlJmsMessage)xml_msg).getJmsMessage();
        } else {
            AQxmlError.throwAQEx(401, "Invalid Msg type");
        }
        this.printUtil("setOracleJmsProperties");
        AQxmlDebug.trace(4, "AQxmlConverter.setOracleJmsProperties", "entry");
        try {
            AQxmlDebug.trace(5, "AQxmlConverter.setOracleJmsProperties", "NL: " + nl.getLength());
            block12: for (int i = 0; i < nl.getLength(); ++i) {
                n = nl.item(i);
                xmlElement = this.getNextAQElement(n);
                if (xmlElement == null) {
                    AQxmlDebug.trace(4, "AQxmlConverter.setOracleJmsProperties", "Null Element");
                    continue;
                }
                switch (xmlElement) {
                    case 500: {
                        AQxmlDebug.trace(5, "AQxmlConverter.setOracleJmsProperties", "Userid");
                        continue block12;
                    }
                    case 510: {
                        app_id = this.getTextNodeValue(n);
                        if (app_id != null) {
                            AQxmlDebug.trace(5, "AQxmlConverter.setOracleJmsProperties", "Appid: " + app_id);
                            msg.setStringProperty("JMSXAppID", app_id);
                            continue block12;
                        }
                    }
                    case 520: {
                        group_id = this.getTextNodeValue(n);
                        if (group_id == null) continue block12;
                        AQxmlDebug.trace(5, "AQxmlConverter.setOracleJmsProperties", "Group id: " + group_id);
                        msg.setStringProperty("JMSXGroupID", group_id);
                        continue block12;
                    }
                    case 530: {
                        group_seq = this.getTextNodeValue(n);
                        if (group_seq == null) continue block12;
                        AQxmlDebug.trace(5, "AQxmlConverter.setOracleJmsProperties", "Group Sequence: " + group_seq);
                        msg.setIntProperty("JMSXGroupSeq", Integer.parseInt(group_seq.trim()));
                        continue block12;
                    }
                    case 420: {
                        AQxmlDebug.trace(5, "AQxmlConverter.setOracleJmsProperties", "Type");
                        continue block12;
                    }
                    case 390: {
                        AQxmlDebug.trace(5, "AQxmlConverter.setOracleJmsProperties", "TimeStamp");
                        continue block12;
                    }
                    case 560: {
                        AQxmlDebug.trace(5, "AQxmlConverter.setOracleJmsProperties", "RecvTimeStamp");
                        continue block12;
                    }
                    case 410: {
                        NodeList rt_cnl = null;
                        AQxmlAgent reply_agent = null;
                        rt_cnl = n.getChildNodes();
                        AQxmlDebug.trace(5, "AQxmlConverter.setOracleJmsProperties", "Setting Reply to");
                        AQxmlDebug.trace(5, "AQxmlConverter.setOracleJmsProperties", "DATABASE: Reply to");
                        reply_agent = this.parseAgentParams(rt_cnl);
                        msgProp.setReplyTo(reply_agent);
                        ((AQxmlJmsMessage)xml_msg).setPropertyList(msgProp);
                        continue block12;
                    }
                    default: {
                        AQxmlError.throwAQEx(401, "Invalid xml tag: " + n.getNodeName());
                    }
                }
            }
        }
        catch (JMSException jms_ex) {
            AQxmlDebug.traceEx(3, "AQxmlConverter.setOracleJmsProperties", (Exception)((Object)jms_ex));
            AQxmlError.throwAQEx(406, (Exception)((Object)jms_ex));
        }
    }

    AQxmlAgent parseAgentParams(NodeList nl) throws AQxmlException {
        Node n = null;
        Integer xmlElement = null;
        String agent_name = null;
        String agent_address = null;
        String agent_protocol = null;
        String agent_alias = null;
        AQxmlAgent ret_agent = null;
        int agt_prot = 0;
        this.printUtil("parseAgentParams");
        AQxmlDebug.trace(5, "AQxmlConverter.parseAgentParams", "entry");
        AQxmlDebug.trace(5, "parseAgentParams", " NL: " + nl.getLength());
        block6: for (int i = 0; i < nl.getLength(); ++i) {
            n = nl.item(i);
            xmlElement = this.getNextAQElement(n);
            if (xmlElement == null) {
                AQxmlDebug.trace(4, "AQxmlConverter.parseAgentParams", "Null Element");
                continue;
            }
            switch (xmlElement) {
                case 860: {
                    agent_name = this.getTextNodeValue(n);
                    AQxmlDebug.trace(5, "AQxmlConverter.parseAgentParams", "Name: " + agent_name);
                    continue block6;
                }
                case 870: {
                    agent_address = this.getTextNodeValue(n);
                    AQxmlDebug.trace(5, "AQxmlConverter.parseAgentParams", "Address: " + agent_address);
                    continue block6;
                }
                case 880: {
                    agent_protocol = this.getTextNodeValue(n);
                    AQxmlDebug.trace(5, "AQxmlConverter.parseAgentParams", "Protocol: " + agent_protocol);
                    agt_prot = Integer.parseInt(agent_protocol.trim());
                    continue block6;
                }
                case 855: {
                    agent_alias = this.getTextNodeValue(n);
                    AQxmlDebug.trace(5, "AQxmlConverter.parseAgentParams", "LDAP alias:" + agent_alias);
                    continue block6;
                }
                default: {
                    AQxmlError.throwAQEx(401, "Invalid xml tag: " + n.getNodeName());
                }
            }
        }
        ret_agent = agent_alias == null ? new AQxmlAgent(agent_name, agent_address, agt_prot) : new AQxmlAgent(agent_alias);
        return ret_agent;
    }

    void setMessageHeader(NodeList nl, AQxmlMessage xml_msg) throws AQxmlException {
        Node n = null;
        Integer xmlElement = null;
        NodeList rl_cnl = null;
        int rl_size = 0;
        AQjmsMessage msg = null;
        AQxmlMessageHeader adt_msg_header = null;
        boolean pr_set = false;
        this.printUtil("setMessageHeader");
        AQxmlDebug.trace(5, "AQxmlConverter.setMessageHeader", "entry");
        if (this.msg_type == 4 || this.msg_type == 5) {
            AQxmlDebug.trace(5, "AQxmlConverter.setMessageHeader", "Constructing Adt Msg Header ");
            adt_msg_header = new AQxmlMessageHeader();
        } else if (xml_msg instanceof AQxmlJmsMessage) {
            msg = (AQjmsMessage)((AQxmlJmsMessage)xml_msg).getJmsMessage();
            adt_msg_header = ((AQxmlJmsMessage)xml_msg).getHeader();
            if (adt_msg_header == null) {
                adt_msg_header = new AQxmlMessageHeader();
            }
        } else {
            AQxmlError.throwAQEx(401, "Invalid Msg type");
        }
        try {
            AQxmlDebug.trace(5, "setMessageHeader", " NL: " + nl.getLength());
            block15: for (int i = 0; i < nl.getLength(); ++i) {
                n = nl.item(i);
                xmlElement = this.getNextAQElement(n);
                if (xmlElement == null) {
                    AQxmlDebug.trace(4, "AQxmlConverter.setMessageHeader", "Null Element");
                    continue;
                }
                switch (xmlElement) {
                    case 150: {
                        AQxmlDebug.trace(5, "AQxmlConverter.setMessageHeader", "Message Id");
                        continue block15;
                    }
                    case 400: {
                        String msg_correlation = this.getTextNodeValue(n);
                        if (msg_correlation == null) continue block15;
                        AQxmlDebug.trace(5, "AQxmlConverter.setMessageHeader", "Correlation: " + msg_correlation);
                        if (this.msg_type == 4 || this.msg_type == 5) {
                            adt_msg_header.setCorrelationID(msg_correlation);
                            continue block15;
                        }
                        msg.setJMSCorrelationID(msg_correlation);
                        continue block15;
                    }
                    case 760: {
                        continue block15;
                    }
                    case 80: {
                        String msg_expiration = this.getTextNodeValue(n);
                        if (msg_expiration == null) continue block15;
                        int exp = Integer.parseInt(msg_expiration.trim());
                        AQxmlDebug.trace(5, "AQxmlConverter.setMessageHeader", "Expiration: " + exp);
                        if (this.msg_type == 4 || this.msg_type == 5) {
                            adt_msg_header.setExpiration(exp);
                            continue block15;
                        }
                        msg.setJMSExpiration(exp);
                        continue block15;
                    }
                    case 70: {
                        String msg_priority = this.getTextNodeValue(n);
                        if (msg_priority == null) continue block15;
                        int priority = Integer.parseInt(msg_priority.trim());
                        AQxmlDebug.trace(5, "AQxmlConverter.setMessageHeader", "Priority: " + priority);
                        if (this.msg_type == 4 || this.msg_type == 5) {
                            adt_msg_header.setPriority(priority);
                        } else {
                            msg.setJMSPriority(priority);
                        }
                        pr_set = true;
                        continue block15;
                    }
                    case 450: {
                        AQxmlDebug.trace(5, "AQxmlConverter.setMessageHeader", "Delivery count");
                        continue block15;
                    }
                    case 460: {
                        AQxmlDebug.trace(5, "AQxmlConverter.setMessageHeader", "Message State");
                        continue block15;
                    }
                    case 90: {
                        AQxmlDebug.trace(5, "AQxmlConverter.setMessageHeader", "Recipient List");
                        rl_cnl = n.getChildNodes();
                        Vector rcpt_list_v = this.genRcptList(rl_cnl, this.msg_type);
                        rl_size = rcpt_list_v.size();
                        AQxmlAgent[] rcpt_list = new AQxmlAgent[rl_size];
                        for (int j = 0; j < rl_size; ++j) {
                            rcpt_list[j] = (AQxmlAgent)rcpt_list_v.elementAt(j);
                        }
                        if (this.msg_type == 4 || this.msg_type == 5) {
                            adt_msg_header.setRecipientList(rcpt_list);
                            continue block15;
                        }
                        xml_msg.getHeader().setRecipientList(rcpt_list);
                        continue block15;
                    }
                    case 470: {
                        NodeList sndr_cnl = null;
                        AQxmlAgent xml_sender = null;
                        sndr_cnl = n.getChildNodes();
                        xml_sender = this.parseAgentParams(sndr_cnl);
                        adt_msg_header.setSenderId(xml_sender);
                        continue block15;
                    }
                    case 480: {
                        String msg_excep_queue = this.getTextNodeValue(n);
                        if (msg_excep_queue == null) continue block15;
                        AQxmlDebug.trace(5, "AQxmlConverter.setMessageHeader", "Exception Queue: " + msg_excep_queue);
                        if (this.msg_type == 4 || this.msg_type == 5) {
                            adt_msg_header.setExceptionQueue(msg_excep_queue);
                            continue block15;
                        }
                        msg.setStringProperty("JMS_OracleExcpQ", msg_excep_queue);
                        continue block15;
                    }
                    case 490: {
                        String msg_delay = this.getTextNodeValue(n);
                        if (msg_delay != null) {
                            int delay = Integer.parseInt(msg_delay.trim());
                            AQxmlDebug.trace(5, "AQxmlConverter.setMessageHeader", "Delay: " + delay);
                            if (this.msg_type == 4 || this.msg_type == 5) {
                                adt_msg_header.setDelay(delay);
                                continue block15;
                            }
                            msg.setIntProperty("JMS_OracleDelay", delay);
                            continue block15;
                        }
                    }
                    default: {
                        AQxmlError.throwAQEx(401, "Invalid xml tag: " + n.getNodeName());
                    }
                }
            }
            if (!pr_set && this.msg_type != 4 && this.msg_type != 5 && msg != null) {
                msg.setJMSPriority(1);
            }
            xml_msg.setHeader(adt_msg_header);
        }
        catch (JMSException jms_ex) {
            AQxmlDebug.traceEx(3, "AQxmlConverter.setMessageHeader", (Exception)((Object)jms_ex));
            AQxmlError.throwAQEx(406, (Exception)((Object)jms_ex));
        }
    }

    Vector genRcptList(NodeList nl, int msg_type) throws AQxmlException {
        Node n = null;
        Integer xmlElement = null;
        Vector<AQxmlAgent> rl_vector = null;
        NodeList rcpt_nl = null;
        AQxmlAgent rl_agent = null;
        this.printUtil("genRcptList");
        AQxmlDebug.trace(4, "AQxmlConverter.genRcptList", "entry");
        rl_vector = new Vector<AQxmlAgent>();
        AQxmlDebug.trace(5, "genRcptList", " NL: " + nl.getLength());
        block3: for (int i = 0; i < nl.getLength(); ++i) {
            n = nl.item(i);
            xmlElement = this.getNextAQElement(n);
            if (xmlElement == null) {
                AQxmlDebug.trace(4, "AQxmlConverter.genRcptList", "Null Element");
                continue;
            }
            switch (xmlElement) {
                case 100: {
                    rcpt_nl = n.getChildNodes();
                    rl_agent = this.parseAgentParams(rcpt_nl);
                    rl_vector.addElement(rl_agent);
                    continue block3;
                }
                default: {
                    AQxmlError.throwAQEx(401, "Invalid tag name: " + n.getNodeName());
                }
            }
        }
        return rl_vector;
    }

    void printMessageList(AQjmsMessage[] msgList) {
        int i = 0;
        for (i = 0; i < this.message_count; ++i) {
            AQxmlDebug.trace(5, " ", "-------------------------------------------------");
            AQxmlDebug.trace(5, " ", "Printing Message : " + i);
            if (msgList[i] instanceof AQjmsTextMessage) {
                AQxmlDebug.trace(5, " ", "Message number " + i + " is a JMS Text Message");
                AQxmlDebug.trace(5, " ", "-------------------------------------------------");
                this.printMessage(msgList[i]);
                continue;
            }
            if (!(msgList[i] instanceof AQjmsMapMessage)) continue;
            AQxmlDebug.trace(5, " ", "Message number " + i + " is a JMS Map Message");
        }
    }

    void printMessage(AQjmsMessage msg) {
        this.printHeader(msg);
        this.printPayload(msg);
    }

    void printHeader(AQjmsMessage msg) {
        if (msg == null) {
            AQxmlDebug.trace(5, "AQxmlConverter.printHeader", "Message is NULL");
        }
        AQjmsAgent agent = new AQjmsAgent();
        try {
            AQxmlDebug.trace(5, " ", "Message Id     : " + msg.getJMSMessageID());
            AQxmlDebug.trace(5, " ", "Correlation Id : " + msg.getJMSCorrelationID());
            AQxmlDebug.trace(5, " ", "Expiration     : " + msg.getJMSExpiration());
            AQxmlDebug.trace(5, " ", "Priority       : " + msg.getJMSPriority());
            agent = msg.getSenderID();
            if (agent != null) {
                AQxmlDebug.trace(5, " ", "SenderId Name      : " + agent.getName());
                AQxmlDebug.trace(5, " ", "SenderId Address   : " + agent.getAddress());
                AQxmlDebug.trace(5, " ", "SenderId Protocol  : " + agent.getProtocol());
            }
            AQxmlDebug.trace(5, " ", "Exception Queue    : " + msg.getStringProperty("JMS_OracleExcpQ"));
            AQxmlDebug.trace(5, " ", "Delay              : " + msg.getStringProperty("JMS_OracleDelay"));
            AQxmlDebug.trace(5, " ", "Msg State          : " + msg.getStringProperty("JMSXState"));
        }
        catch (SQLException sql_ex) {
            AQxmlDebug.traceEx(3, "AQxmlConverter.printHeader1", sql_ex);
        }
        catch (JMSException jms_ex) {
            AQxmlDebug.traceEx(3, "AQxmlConverter.printHeader2", (Exception)((Object)jms_ex));
        }
    }

    void printPayload(AQjmsMessage msg) {
        try {
            AQxmlDebug.trace(5, " ", "Type               : " + msg.getJMSType());
            AQxmlDebug.trace(5, " ", "UserID             : " + msg.getStringProperty("JMSXUserId"));
            AQxmlDebug.trace(5, " ", "AppID              : " + msg.getStringProperty("JMSXAppId"));
            AQxmlDebug.trace(5, " ", "GroupID            : " + msg.getStringProperty("JMSXGroupId"));
            AQxmlDebug.trace(5, " ", "GroupSeq           : " + msg.getStringProperty("JMSXGroupSeq"));
            AQxmlDebug.trace(5, " ", "Payload text data  : " + ((AQjmsTextMessage)msg).getText());
        }
        catch (JMSException jms_ex) {
            AQxmlDebug.traceEx(3, "AQxmlConverter.printPayload", (Exception)((Object)jms_ex));
        }
    }

    void printUtil(String function_name) {
        AQxmlDebug.trace(5, " ", " ");
        AQxmlDebug.trace(5, " ", " ");
        AQxmlDebug.trace(5, " ", "------------------------------------------------");
        AQxmlDebug.trace(5, " ", "         " + function_name + "             ");
        AQxmlDebug.trace(5, " ", "------------------------------------------------");
        AQxmlDebug.trace(5, " ", " ");
    }

    String getAttributeValue(Node n, String attributename) {
        XMLElement e = (XMLElement)n;
        Attr attribute = e.getAttributeNode(attributename);
        AQxmlDebug.trace(5, "AQxmlConverter.getAttributeValue", "Attribute Name : " + attribute.getName());
        AQxmlDebug.trace(5, "AQxmlConverter.getAttributeValue", "Attribute Value: " + attribute.getValue());
        return attribute.getValue();
    }

    String getTextNodeValue(Node n) {
        String str = null;
        if (n != null) {
            Node ln = n.getLastChild();
            if (ln != null) {
                str = ln.getNodeValue();
                AQxmlDebug.trace(5, "AQxmlConverter.getTextNodeValue-1", "Value: " + str);
            } else {
                str = null;
                AQxmlDebug.trace(5, "AQxmlConverter.getTextNodeValue-2", "Value: " + str);
            }
        } else {
            str = null;
            AQxmlDebug.trace(5, "AQxmlConverter.getTextNodeValue-3", "Value: " + str);
        }
        return str;
    }

    private static void initElementHashtable() {
        AQxmlDebug.trace(5, " AQxmlConverter.initElementHashtable", "initing hash table");
        elementHashtable = new Hashtable();
        elementHashtable.put("PUSH_OPTIONS", new Integer(215));
        elementHashtable.put("AQXMLQUEUETYPEINFO", new Integer(311));
        elementHashtable.put("AQXMLDOCUMENT", new Integer(10));
        elementHashtable.put("SERVER_PROP_OPERATION", new Integer(15));
        elementHashtable.put("CLIENT_OPERATION", new Integer(20));
        elementHashtable.put("TXID", new Integer(30));
        elementHashtable.put("SERVER_OPERATION", new Integer(40));
        elementHashtable.put("PRODUCER_OPTIONS", new Integer(50));
        elementHashtable.put("VISIBILITY", new Integer(55));
        elementHashtable.put("DESTINATION", new Integer(60));
        elementHashtable.put("PRIORITY", new Integer(70));
        elementHashtable.put("EXPIRATION", new Integer(80));
        elementHashtable.put("RECIPIENT_LIST", new Integer(90));
        elementHashtable.put("RECIPIENT", new Integer(100));
        elementHashtable.put("CONSUMER_OPTIONS", new Integer(110));
        elementHashtable.put("CONSUMER_NAME", new Integer(120));
        elementHashtable.put("WAIT_TIME", new Integer(130));
        elementHashtable.put("SELECTOR", new Integer(140));
        elementHashtable.put("MESSAGE_ID", new Integer(150));
        elementHashtable.put("CONDITION", new Integer(170));
        elementHashtable.put("DEQUEUE_MODE", new Integer(125));
        elementHashtable.put("NAVIGATION_MODE", new Integer(127));
        elementHashtable.put("REGISTER_OPTIONS", new Integer(180));
        elementHashtable.put("NOTIFY_URL", new Integer(190));
        elementHashtable.put("QOS", new Integer(200));
        elementHashtable.put("BATCH_SIZE", new Integer(210));
        elementHashtable.put("STATUS_RESPONSE", new Integer(220));
        elementHashtable.put("ACKNOWLEDGE", new Integer(230));
        elementHashtable.put("STATUS_CODE", new Integer(240));
        elementHashtable.put("ERROR_MESSAGE", new Integer(250));
        elementHashtable.put("SEQUENCE_INFO", new Integer(260));
        elementHashtable.put("SEQUENCE_NUMBER", new Integer(270));
        elementHashtable.put("MESSAGE_NUMBER", new Integer(280));
        elementHashtable.put("AQXMLPUSH", new Integer(290));
        elementHashtable.put("AQXMLNOTIFICATION", new Integer(300));
        elementHashtable.put("AQXMLSEQUENCENUMBER", new Integer(310));
        elementHashtable.put("SEND_RESULT", new Integer(320));
        elementHashtable.put("PUBLISH_RESULT", new Integer(330));
        elementHashtable.put("RECEIVE_RESULT", new Integer(340));
        elementHashtable.put("MESSAGE_SET", new Integer(350));
        elementHashtable.put("MESSAGE", new Integer(360));
        elementHashtable.put("MESSAGE_HEADER", new Integer(380));
        elementHashtable.put("TIMESTAMP", new Integer(390));
        elementHashtable.put("CORRELATION", new Integer(400));
        elementHashtable.put("REPLY_TO", new Integer(410));
        elementHashtable.put("TYPE", new Integer(420));
        elementHashtable.put("MESSAGE_PROPERTIES", new Integer(430));
        elementHashtable.put("SYSTEM_PROPERTIES", new Integer(440));
        elementHashtable.put("DELIVERY_COUNT", new Integer(450));
        elementHashtable.put("MESSAGE_STATE", new Integer(460));
        elementHashtable.put("SENDER_ID", new Integer(470));
        elementHashtable.put("EXCEPTION_QUEUE", new Integer(480));
        elementHashtable.put("DELAY", new Integer(490));
        elementHashtable.put("USERID", new Integer(500));
        elementHashtable.put("APPID", new Integer(510));
        elementHashtable.put("GROUPID", new Integer(520));
        elementHashtable.put("GROUP_SEQUENCE", new Integer(530));
        elementHashtable.put("RECV_TIMESTAMP", new Integer(560));
        elementHashtable.put("USER_PROPERTIES", new Integer(570));
        elementHashtable.put("PROPERTY", new Integer(580));
        elementHashtable.put("NAME", new Integer(590));
        elementHashtable.put("INT_VALUE", new Integer(600));
        elementHashtable.put("LONG_VALUE", new Integer(601));
        elementHashtable.put("DOUBLE_VALUE", new Integer(602));
        elementHashtable.put("BOOLEAN_VALUE", new Integer(603));
        elementHashtable.put("FLOAT_VALUE", new Integer(604));
        elementHashtable.put("SHORT_VALUE", new Integer(606));
        elementHashtable.put("BYTE_VALUE", new Integer(607));
        elementHashtable.put("STRING_VALUE", new Integer(605));
        elementHashtable.put("MESSAGE_PAYLOAD", new Integer(610));
        elementHashtable.put("AQXMLSEND", new Integer(620));
        elementHashtable.put("AQXMLRECEIVE", new Integer(630));
        elementHashtable.put("AQXMLPUBLISH", new Integer(640));
        elementHashtable.put("AQXMLREGISTER", new Integer(650));
        elementHashtable.put("DATABASE", new Integer(660));
        elementHashtable.put("LDAP", new Integer(670));
        elementHashtable.put("AQXMLCOMMIT", new Integer(680));
        elementHashtable.put("AQXMLROLLBACK", new Integer(690));
        elementHashtable.put("TEXT_DATA", new Integer(700));
        elementHashtable.put("MAP_DATA", new Integer(710));
        elementHashtable.put("BYTES_DATA", new Integer(720));
        elementHashtable.put("SER_OBJECT_DATA", new Integer(730));
        elementHashtable.put("ORACLE_JMS_PROPERTIES", new Integer(740));
        elementHashtable.put("PROPERTY_TYPE", new Integer(750));
        elementHashtable.put("DELIVERY_MODE", new Integer(760));
        elementHashtable.put("NUMBER", new Integer(770));
        elementHashtable.put("STRING", new Integer(780));
        elementHashtable.put("MESSAGE_COUNT", new Integer(790));
        elementHashtable.put("JMS_TEXT_MESSAGE", new Integer(0));
        elementHashtable.put("JMS_BYTES_MESSAGE", new Integer(1));
        elementHashtable.put("JMS_MAP_MESSAGE", new Integer(2));
        elementHashtable.put("JMS_OBJECT_MESSAGE", new Integer(3));
        elementHashtable.put("ITEM", new Integer(840));
        elementHashtable.put("ITEM_TYPE", new Integer(850));
        elementHashtable.put("AGENT_ALIAS", new Integer(855));
        elementHashtable.put("AGENT_NAME", new Integer(860));
        elementHashtable.put("ADDRESS", new Integer(870));
        elementHashtable.put("PROTOCOL", new Integer(880));
        elementHashtable.put("DBLINK", new Integer(890));
        elementHashtable.put("DATABASE_LINK", new Integer(2030));
        elementHashtable.put("SOURCE_QID", new Integer(900));
        elementHashtable.put("QID", new Integer(2020));
        elementHashtable.put("SIGNATURE", new Integer(1041));
        elementHashtable.put("SIGNEDINFO", new Integer(1042));
        elementHashtable.put("CANONICALIZATIONMETHOD", new Integer(1043));
        elementHashtable.put("REFERENCE", new Integer(1045));
        elementHashtable.put("DIGESTMETHOD", new Integer(1046));
        elementHashtable.put("DIGESTVALUE", new Integer(1047));
        elementHashtable.put("SIGNATUREVALUE", new Integer(1048));
        elementHashtable.put("RAW", new Integer(5));
        elementHashtable.put("TRANSFORMATION", new Integer(2040));
        elementHashtable.put("STREAMSSETUPQUEUEREQUEST", new Integer(2080));
        elementHashtable.put("QUEUE_TABLE", new Integer(2090));
        elementHashtable.put("STORAGE_CLAUSE", new Integer(2100));
        elementHashtable.put("QUEUE_NAME", new Integer(2110));
        elementHashtable.put("QUEUE_USER", new Integer(2120));
        elementHashtable.put("COMMENT", new Integer(2130));
        elementHashtable.put("STREAMSADDTABLERULESREQUEST", new Integer(2140));
        elementHashtable.put("TABLE_NAME", new Integer(2150));
        elementHashtable.put("STREAMS_TYPE", new Integer(2160));
        elementHashtable.put("STREAMS_NAME", new Integer(2170));
        elementHashtable.put("INCLUDE_DML", new Integer(2180));
        elementHashtable.put("INCLUDE_DDL", new Integer(2190));
        elementHashtable.put("INCLUDE_TAGGED_LCR", new Integer(2200));
        elementHashtable.put("SOURCE_DATABASE_NAME", new Integer(2210));
        elementHashtable.put("INCLUSION_RULE", new Integer(2220));
        elementHashtable.put("STREAMSSTARTCAPTUREREQUEST", new Integer(2270));
        elementHashtable.put("CAPTURE_NAME", new Integer(2280));
        elementHashtable.put("DATABASE_NAME", new Integer(2340));
    }

    static URL createURL(String fileName) {
        URL url = null;
        try {
            url = new URL(fileName);
        }
        catch (MalformedURLException ex) {
            File f = new File(fileName);
            try {
                String path = f.getAbsolutePath();
                String fs = System.getProperty("file.separator");
                if (fs.length() == 1) {
                    char sep = fs.charAt(0);
                    if (sep != '/') {
                        path = path.replace(sep, '/');
                    }
                    if (path.charAt(0) != '/') {
                        path = '/' + path;
                    }
                }
                path = "file://" + path;
                url = new URL(path);
            }
            catch (MalformedURLException e) {
                AQxmlDebug.traceEx(5, "AQxmlConverter.createURL", e);
                System.exit(0);
            }
        }
        return url;
    }

    static byte[] convertHexStringToByte(String refString) {
        byte[] byteArray = new byte[refString.length() / 2];
        for (int i = 0; i < refString.length(); i += 2) {
            int intVal = AQxmlConverter.convertCharToInt(refString.charAt(i));
            Integer newInt = new Integer(0xF0 & intVal << 4);
            byteArray[i / 2] = newInt.byteValue();
            intVal = AQxmlConverter.convertCharToInt(refString.charAt(i + 1));
            newInt = new Integer(0xF & intVal);
            int n = i / 2;
            byteArray[n] = (byte)(byteArray[n] | newInt.byteValue());
        }
        return byteArray;
    }

    private static int convertCharToInt(char charVal) {
        switch (charVal) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': 
            case 'a': {
                return 10;
            }
            case 'B': 
            case 'b': {
                return 11;
            }
            case 'C': 
            case 'c': {
                return 12;
            }
            case 'D': 
            case 'd': {
                return 13;
            }
            case 'E': 
            case 'e': {
                return 14;
            }
            case 'F': 
            case 'f': {
                return 15;
            }
        }
        return 48;
    }

    static {
        AQxmlConverter.initElementHashtable();
    }
}

