/*
 * Decompiled with CFR 0.152.
 */
package oracle.jakarta.AQ.xml;

import jakarta.jms.JMSException;
import jakarta.jms.Queue;
import jakarta.jms.Topic;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.naming.directory.DirContext;
import oracle.jakarta.AQ.AQException;
import oracle.jakarta.AQ.AQOracleQueue;
import oracle.jakarta.AQ.AQOracleSession;
import oracle.jakarta.AQ.AQQueue;
import oracle.jakarta.AQ.AQSession;
import oracle.jakarta.AQ.xml.AQxmlDataSource;
import oracle.jakarta.AQ.xml.AQxmlDebug;
import oracle.jakarta.AQ.xml.AQxmlError;
import oracle.jakarta.AQ.xml.AQxmlException;
import oracle.jakarta.AQ.xml.AQxmlGenConverter;
import oracle.jakarta.AQ.xml.AQxmlIdapConverter;
import oracle.jakarta.AQ.xml.AQxmlSoapConverter;
import oracle.jakarta.jms.AQjmsDestination;
import oracle.jakarta.jms.AQjmsSession;

class AQxmlServContext {
    AQxmlDataSource dt_src = null;
    Hashtable data_sources = null;
    Hashtable aq_htable = null;
    Hashtable jmsq_htable = null;
    Hashtable jmst_htable = null;
    String schema_loc = null;
    Object schema_obj = null;
    int max_inactive_time = 120;
    DirContext ldapCtx = null;
    Hashtable conv_list = null;

    AQxmlServContext(AQxmlDataSource data_source) throws AQxmlException {
        this(data_source, null);
    }

    AQxmlServContext(AQxmlDataSource data_source, String schema_location) throws AQxmlException {
        AQxmlDebug.trace(4, "AQxmlServContext:constructor-2", "entry");
        this.dt_src = data_source;
        this.data_sources = new Hashtable();
        this.data_sources.put("default", this.dt_src);
        this.aq_htable = new Hashtable();
        this.jmsq_htable = new Hashtable();
        this.jmst_htable = new Hashtable();
        this.conv_list = new Hashtable();
        this.registerConverter("http://ns.oracle.com/AQ/schemas/envelope", new AQxmlIdapConverter());
        this.registerConverter("http://schemas.xmlsoap.org/soap/envelope/", new AQxmlSoapConverter());
        AQxmlDebug.trace(4, "AQxmlServContext:constructor-2", "exit");
    }

    AQxmlServContext(AQxmlDataSource[] data_source, String[] keys, String schema_location) throws AQxmlException {
        AQxmlDebug.trace(4, "AQxmlServContext:constructor-3", "entry");
        if (data_source.length != keys.length) {
            AQxmlError.throwAQEx(401, "need equal number of data sources and names");
        }
        this.dt_src = data_source[0];
        this.data_sources = new Hashtable();
        for (int i = 0; i < data_source.length; ++i) {
            this.data_sources.put(keys[i], data_source[i]);
        }
        this.aq_htable = new Hashtable();
        this.jmsq_htable = new Hashtable();
        this.jmst_htable = new Hashtable();
        this.conv_list = new Hashtable();
        this.registerConverter("http://ns.oracle.com/AQ/schemas/envelope", new AQxmlIdapConverter());
        this.registerConverter("http://schemas.xmlsoap.org/soap/envelope/", new AQxmlSoapConverter());
        AQxmlDebug.trace(4, "AQxmlServContext:constructor-3", "exit");
    }

    AQxmlDataSource getDataSource() {
        return this.dt_src;
    }

    void setDefaultDataSource(String key) throws AQxmlException {
        AQxmlDataSource ds = (AQxmlDataSource)this.data_sources.get(key);
        if (ds == null) {
            AQxmlError.throwAQEx(434);
        }
        this.dt_src = ds;
    }

    AQxmlDataSource getDataSourceByName(String key) {
        return (AQxmlDataSource)this.data_sources.get(key);
    }

    int getMaxInactiveTime() {
        return this.max_inactive_time;
    }

    synchronized void setMaxInactiveTime(int i) {
        this.max_inactive_time = i;
    }

    DirContext getLdapContext() {
        return this.ldapCtx;
    }

    synchronized void setLdapContext(DirContext ctx) {
        this.ldapCtx = ctx;
    }

    synchronized AQQueue getAQQueue(AQSession aq_sess, String owner, String name, boolean check_multicons) throws AQxmlException {
        AQQueue queue = null;
        AQOracleQueue cl_queue = null;
        AQxmlDebug.trace(3, "AQxmlServContext.getAQQueue", "owner: " + owner + "  name: " + name + "   --check_multicons-" + check_multicons);
        if (owner == null || owner.equals("")) {
            AQxmlError.throwAQEx(414);
        }
        if (aq_sess == null) {
            AQxmlError.throwAQEx(401, "Session = null");
        }
        if ((queue = (AQQueue)this.aq_htable.get(owner.toUpperCase() + "." + name.toUpperCase())) == null) {
            AQxmlDebug.trace(4, "AQxmlServContext.getAQQueue", "queue not in htable");
            try {
                queue = aq_sess.getQueue(owner, name);
            }
            catch (AQException aq_ex) {
                AQxmlDebug.traceEx(3, "AQxmlServContext.getAQQueue-ex1", aq_ex);
                AQxmlError.throwAQEx(436, aq_ex);
            }
            this.aq_htable.put(owner.toUpperCase() + "." + name.toUpperCase(), queue);
        } else {
            AQxmlDebug.trace(4, "AQxmlServContext.getAQQueue", "queue found in htable");
        }
        try {
            if (check_multicons) {
                ((AQOracleQueue)queue).isMultiConsumer();
            }
            cl_queue = ((AQOracleQueue)queue).cloneQueue();
            cl_queue.setAQSession((AQOracleSession)aq_sess);
        }
        catch (AQException aq_ex) {
            AQxmlError.throwAQEx(436, aq_ex);
        }
        return cl_queue;
    }

    synchronized Queue getJmsQueue(AQjmsSession jms_sess, String owner, String name) throws AQxmlException {
        Queue queue = null;
        AQjmsDestination cl_queue = null;
        AQxmlDebug.trace(3, "AQxmlServContext.getJmsQueue", "owner: " + owner + "  name: " + name);
        if (jms_sess == null) {
            AQxmlError.throwAQEx(401, "Session = null");
        }
        if (owner == null || owner.equals("")) {
            AQxmlError.throwAQEx(414);
        }
        queue = (Queue)this.jmsq_htable.get(owner.toUpperCase() + "." + name.toUpperCase());
        try {
            if (queue == null) {
                AQxmlDebug.trace(4, "AQxmlServContext.getJmsQueue", "queue not in htable");
                queue = jms_sess.getQueue(owner, name);
                this.jmsq_htable.put(owner.toUpperCase() + "." + name.toUpperCase(), queue);
            } else {
                AQxmlDebug.trace(4, "AQxmlServContext.getJmsQueue", "queue found in htable");
            }
            cl_queue = ((AQjmsDestination)queue).cloneDestination();
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
        return cl_queue;
    }

    synchronized Topic getJmsTopic(AQjmsSession jms_sess, String owner, String name) throws AQxmlException {
        Topic topic = null;
        AQjmsDestination cl_topic = null;
        AQxmlDebug.trace(3, "AQxmlServContext.getJmsTopic", "owner: " + owner + "  name: " + name);
        if (jms_sess == null) {
            AQxmlError.throwAQEx(401, "Session = null");
        }
        if (owner == null || owner.equals("")) {
            AQxmlError.throwAQEx(414);
        }
        topic = (Topic)this.jmst_htable.get(owner.toUpperCase() + "." + name.toUpperCase());
        try {
            if (topic == null) {
                AQxmlDebug.trace(4, "AQxmlServContext.getJmsTopic", "topic not in htable");
                topic = jms_sess.getTopic(owner, name);
                this.jmst_htable.put(owner.toUpperCase() + "." + name.toUpperCase(), topic);
            } else {
                AQxmlDebug.trace(4, "AQxmlServContext.getJmsTopic", "topic found in htable");
            }
            cl_topic = ((AQjmsDestination)topic).cloneDestination();
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
        return cl_topic;
    }

    synchronized void removeAQQueue(String owner, String name) {
        Object queue = null;
        AQxmlDebug.trace(3, "AQxmlServContext.removeAQQueue", "owner: " + owner + "  name: " + name);
        if (owner == null || owner.equals("")) {
            AQxmlDebug.trace(1, "AQxmlServContext.removeAQQueue", "Owner= null");
        }
        this.aq_htable.remove(owner.toUpperCase() + "." + name.toUpperCase());
    }

    synchronized void removeJmsQueue(String owner, String name) {
        AQxmlDebug.trace(3, "AQxmlServContext.removeJmsQueue", "owner: " + owner + "  name: " + name);
        if (owner == null || owner.equals("")) {
            AQxmlDebug.trace(1, "AQxmlServContext.removeJmsQueue", "Owner= null");
        }
        this.jmsq_htable.remove(owner.toUpperCase() + "." + name.toUpperCase());
    }

    synchronized void removeJmsTopic(String owner, String name) {
        AQxmlDebug.trace(3, "AQxmlServContext.removeJmsTopic", "owner: " + owner + "  name: " + name);
        if (owner == null || owner.equals("")) {
            AQxmlDebug.trace(1, "AQxmlServContext.removeJmsTopic", "Owner = null");
        }
        this.jmst_htable.remove(owner.toUpperCase() + "." + name.toUpperCase());
    }

    synchronized void registerConverter(String namespace, AQxmlGenConverter conv) throws AQxmlException {
        AQxmlDebug.trace(3, "AQxmlServContext.registerConverter", "entry-namespace: " + namespace);
        if (namespace == null) {
            AQxmlError.throwAQEx(401, "namespace = null");
        }
        if (namespace.equals(conv.getNamespace())) {
            this.conv_list.put(namespace, conv);
        } else {
            AQxmlError.throwAQEx(401, "converter does not match namespace");
        }
        AQxmlDebug.trace(3, "AQxmlServContext.registerConverter", "exit");
    }

    synchronized AQxmlGenConverter findConverter(String namespace) throws AQxmlException {
        AQxmlGenConverter conv = null;
        AQxmlDebug.trace(3, "AQxmlServContext.findConverter", "entry-namespace: " + namespace);
        if (namespace == null) {
            AQxmlError.throwAQEx(401, "namespace = null");
        }
        conv = (AQxmlGenConverter)this.conv_list.get(namespace);
        AQxmlDebug.trace(3, "AQxmlServContext.findConverter", "exit");
        return conv;
    }

    synchronized AQxmlGenConverter getConverter(String namespace) throws AQxmlException {
        AQxmlGenConverter conv = null;
        AQxmlGenConverter cl_conv = null;
        AQxmlDebug.trace(3, "AQxmlServContext.getConverter", "entry-namespace: " + namespace);
        if (namespace == null) {
            AQxmlError.throwAQEx(401, "namespace = null");
        }
        conv = (AQxmlGenConverter)this.conv_list.get(namespace);
        conv.getSchemaObject();
        cl_conv = conv.cloneConverter();
        AQxmlDebug.trace(3, "AQxmlServContext.getConverter", "exit");
        return cl_conv;
    }

    Connection getParentDBConnection() throws AQxmlException {
        Connection parent_conn = null;
        AQxmlDebug.trace(4, "AQxmlServContext.getParentDBConnection", "entry");
        try {
            if (this.dt_src == null) {
                AQxmlError.throwAQEx(401, "Invalid dt_src");
            }
            parent_conn = this.dt_src.getDBConnectionFromPool(null);
        }
        catch (SQLException sql_ex) {
            AQxmlError.throwAQEx(410, sql_ex);
        }
        return parent_conn;
    }

    static URL createURL(String fileName) throws MalformedURLException {
        URL url = null;
        try {
            url = new URL(fileName);
        }
        catch (MalformedURLException ex) {
            File f = new File(fileName);
            try {
                String path = f.getAbsolutePath();
                String fs = System.getProperty("file.separator");
                if (fs.length() == 1) {
                    char sep = fs.charAt(0);
                    if (sep != '/') {
                        path = path.replace(sep, '/');
                    }
                    if (path.charAt(0) != '/') {
                        path = '/' + path;
                    }
                }
                path = "file://" + path;
                url = new URL(path);
            }
            catch (MalformedURLException e) {
                AQxmlDebug.traceEx(5, "AQxmlServContext.createURL", e);
                throw e;
            }
        }
        return url;
    }
}

