/*
 * Decompiled with CFR 0.152.
 */
package oracle.jakarta.jms;

import jakarta.jms.JMSException;
import java.sql.Connection;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import oracle.jakarta.jms.AQjmsError;
import oracle.jakarta.jms.AQjmsOracleDebug;
import oracle.jakarta.jms.AQjmsSession;
import oracle.jakarta.jms.WebLogicHelper;
import oracle.jdbc.OracleConnection;

final class EmulatedXAHandler
implements Synchronization {
    private static final String JNDI_OC4J_TRANS_MANAGER = "java:comp/pm/TransactionManager";
    private static TransactionManager m_tm;
    private static boolean tmLookupFailed;
    private final Connection dbConn;
    private final AQjmsSession aqSess;
    private boolean synchronizationRegistered;
    boolean globalTxnFlag;

    EmulatedXAHandler(Connection conn, AQjmsSession sess) {
        AQjmsOracleDebug.trace(3, "EmulatedXAHandler.constructor", "enter");
        this.dbConn = conn;
        this.aqSess = sess;
        EmulatedXAHandler.lookupTransactionManager();
        if (m_tm != null) {
            AQjmsOracleDebug.trace(3, "EmulatedXAHandler.constructor", "Found the transaction manager, we are running inside container.");
        } else {
            AQjmsOracleDebug.trace(3, "EmulatedXAHandler.constructor", "Can not find the transaction manager, we are NOT running in container");
        }
        AQjmsOracleDebug.trace(3, "EmulatedXAHandler.constructor", "exit");
    }

    boolean inGlobalTrans(boolean reCheck) throws JMSException {
        AQjmsOracleDebug.trace(3, "EmulatedXAHandler.inGlobalTrans", "entry, reCheck=" + reCheck);
        if (reCheck) {
            this.checkForGlobalTxn();
        }
        AQjmsOracleDebug.trace(3, "EmulatedXAHandler.inGlobalTrans", "exit");
        return this.globalTxnFlag;
    }

    void checkForGlobalTxn() throws JMSException {
        block7: {
            AQjmsOracleDebug.trace(3, "EmulatedXAHandler.checkForGlobalTxn", "entry");
            if (m_tm != null) {
                try {
                    Transaction currTrans = m_tm.getTransaction();
                    if (currTrans == null) {
                        AQjmsOracleDebug.trace(3, "EmulatedXAHandler.checkForGlobalTxn", "container TM answers NOT IN global txn");
                        this.globalTxnFlag = false;
                        break block7;
                    }
                    AQjmsOracleDebug.trace(3, "EmulatedXAHandler.checkForGlobalTxn", "container TM answers IN global txn " + currTrans);
                    this.globalTxnFlag = true;
                    if (this.synchronizationRegistered) {
                        AQjmsOracleDebug.trace(5, "EmulatedXAHandler.synchronizationRegistered=true", currTrans.toString());
                        break block7;
                    }
                    AQjmsOracleDebug.trace(5, "EmulatedXAHandler.checkForGlobalTxn", "Transaction change:  --> " + currTrans);
                    this.synchronizationRegistered = true;
                    currTrans.registerSynchronization((Synchronization)this);
                }
                catch (Exception ex) {
                    AQjmsOracleDebug.traceEx(3, "EmulatedXAHandler.checkForGlobalTxn", ex);
                    AQjmsError.throwEx(122, (Throwable)ex);
                }
            } else {
                boolean newFlag = ((OracleConnection)this.dbConn).getUsingXAFlag();
                if (newFlag != this.globalTxnFlag) {
                    this.globalTxnFlag = newFlag;
                }
            }
        }
    }

    void setRollbackOnlyIfInGlobalTxn() {
        try {
            Transaction t;
            if (m_tm != null && (t = m_tm.getTransaction()) != null) {
                t.setRollbackOnly();
            }
        }
        catch (Throwable t) {
            AQjmsOracleDebug.traceEx(1, "EmulatedXAHandler.setRollbackOnlyIfInGlobalTxn", t);
        }
    }

    private static synchronized void lookupTransactionManager() {
        block15: {
            InitialContext ctx;
            if (m_tm != null || tmLookupFailed) {
                return;
            }
            AQjmsOracleDebug.trace(3, "EmulatedXAHandler.constructor", "looking up the transaction manager object in container.");
            m_tm = WebLogicHelper.getTranactionManager();
            if (m_tm != null) {
                return;
            }
            try {
                ctx = new InitialContext();
            }
            catch (NamingException t) {
                AQjmsOracleDebug.traceEx(3, "EmulatedXAHandler.constructor cannot create initial context", t);
                break block15;
            }
            try {
                m_tm = (TransactionManager)ctx.lookup(JNDI_OC4J_TRANS_MANAGER);
            }
            catch (Throwable t) {
                AQjmsOracleDebug.traceEx(3, "EmulatedXAHandler.constructor cannot find OC4J transaction manager", t);
            }
            finally {
                try {
                    ctx.close();
                }
                catch (NamingException e) {
                    AQjmsOracleDebug.traceEx(3, "InitialContext.close failed", e);
                }
            }
        }
        tmLookupFailed = true;
    }

    public void beforeCompletion() {
    }

    public void afterCompletion(int ignored) {
        this.aqSess.restartConsumers();
        this.synchronizationRegistered = false;
    }
}

