/*
 * Decompiled with CFR 0.152.
 */
package oracle.jakarta.AQ.xml;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.transaction.xa.Xid;
import oracle.jakarta.AQ.xml.AQxmlAuthContext;
import oracle.jakarta.AQ.xml.AQxmlDataSource;
import oracle.jakarta.AQ.xml.AQxmlDebug;
import oracle.jakarta.AQ.xml.AQxmlError;
import oracle.jakarta.AQ.xml.AQxmlException;
import oracle.jakarta.AQ.xml.AQxmlProcessor;
import oracle.jakarta.AQ.xml.AQxmlServContext;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.internal.OracleConnection;
import oracle.xml.sql.core.OracleXMLUtil;

public class AQxmlSessionContext
implements HttpSessionBindingListener {
    AQxmlAuthContext auth_ctx;
    AQxmlProcessor aq_proc;
    Connection db_conn;
    Xid xid;
    long[] ocihndls;
    long jniCtx;
    Hashtable trans_list;
    int src_qid;
    String src_database;
    int batch_num;
    boolean push_req;
    OracleXMLUtil xutil;

    public synchronized native long aqxmlinit(long[] var1, int var2);

    public AQxmlSessionContext(AQxmlAuthContext auth_ctx, AQxmlProcessor aq_proc) throws AQxmlException {
        this.auth_ctx = auth_ctx;
        this.aq_proc = aq_proc;
        this.xid = null;
        this.xutil = null;
        this.db_conn = null;
        this.trans_list = new Hashtable();
        this.push_req = false;
        this.batch_num = 0;
        this.src_database = null;
        this.src_qid = 0;
    }

    void setJNICtx(long ctx) {
        this.jniCtx = ctx;
    }

    long getJNICtx() {
        return this.jniCtx;
    }

    void setXMLUtil(OracleXMLUtil utl) {
        this.xutil = utl;
    }

    OracleXMLUtil getXMLUtil() {
        return this.xutil;
    }

    synchronized void initJniCtx(long[] oci_hdls) throws AQxmlException {
        AQxmlDebug.trace(3, "AQxmlSessionContext.initJniCtx()", "entry");
        this.jniCtx = this.aqxmlinit(oci_hdls, AQxmlDebug.getTraceLevel());
        AQxmlDebug.trace(3, "AQxmlSessionContext.initJniCtx()", "exit");
    }

    synchronized long[] getCurrentOCIHandles(AQxmlServContext serv_ctx) throws AQxmlException {
        AQxmlDebug.trace(3, "AQxmlSessionContext.getCurrentOCIHandles()", "entry: db_conn" + this.db_conn);
        Properties prop = new Properties();
        try {
            prop = ((OracleConnection)this.db_conn).getOCIHandles();
        }
        catch (Exception e) {
            AQxmlDebug.traceEx(3, "AQxmlSessionContext.getCurrentOCIHandles()", e);
            AQxmlError.throwAQEx(401, "Properties Not Found", e);
        }
        this.ocihndls = new long[3];
        this.ocihndls[0] = Long.parseLong(prop.getProperty("OCIEnvHandle"));
        this.ocihndls[1] = Long.parseLong(prop.getProperty("OCIErrHandle"));
        this.ocihndls[2] = Long.parseLong(prop.getProperty("OCISvcCtxHandle"));
        AQxmlDebug.trace(3, "AQxmlSessionContext.getCurrentOCIHandles()", "exit");
        return this.ocihndls;
    }

    synchronized AQxmlProcessor getProcessor() {
        return this.aq_proc;
    }

    synchronized AQxmlAuthContext getAuthContext() {
        return this.auth_ctx;
    }

    void setAuthContext(AQxmlAuthContext context) {
        this.auth_ctx = context;
    }

    Xid getSessionXid() {
        return this.xid;
    }

    synchronized void setSessionXid(Xid sess_xid) {
        this.xid = sess_xid;
    }

    synchronized void initDBConnection() {
        AQxmlDebug.trace(4, "AQxmlSessionContext.initDBConnection", "entry");
        this.db_conn = null;
    }

    synchronized void resetSessionContext() {
        AQxmlDebug.trace(4, "AQxmlSessionContext.resetSessionContext", "entry");
        this.db_conn = null;
    }

    synchronized void closeDBConnection(boolean reset_conn) {
        AQxmlDebug.trace(4, "AQxmlSessionContext.closeDBConnection", "entry");
        try {
            if (this.xutil != null) {
                this.xutil.close();
                this.xutil = null;
            }
        }
        catch (Exception ut_ex) {
            AQxmlDebug.traceEx(3, "AQxmlSessionContext.closeDBConnection=ut_ex", ut_ex);
            this.xutil = null;
        }
        try {
            if (this.getCurrentDBConnection() != null) {
                AQxmlDebug.trace(5, "AQxmlSessionContext.closeDBConnection: ", "close current db connection");
                this.getCurrentDBConnection().close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (reset_conn) {
            this.db_conn = null;
        }
    }

    synchronized Connection getCurrentDBConnection() throws AQxmlException {
        return this.db_conn;
    }

    synchronized Connection getCurrentDBConnection(String user, AQxmlServContext serv_ctx) throws AQxmlException {
        AQxmlDataSource dt_src = null;
        AQxmlDebug.trace(4, "AQxmlSessionContext.getCurrentDBConnection", "entry: serv_ctx: " + serv_ctx + " user: " + user);
        if (user == null) {
            AQxmlError.throwAQEx(401, "user=null");
        }
        if (serv_ctx == null) {
            AQxmlDebug.trace(4, "AQxmlSessionContext.getCurrentDBConnection", "serv_ctx= null");
            return this.db_conn;
        }
        if (this.db_conn != null) {
            AQxmlDebug.trace(4, "AQxmlSessionContext.getCurrentDBConnection", "db_conn != null");
            return this.db_conn;
        }
        try {
            AQxmlDebug.trace(4, "AQxmlSessionContext.getCurrentDBConnection", "db_conn = null - opening new connection");
            dt_src = serv_ctx.getDataSource();
            if (dt_src == null) {
                AQxmlError.throwAQEx(401, "Invalid dt_src");
            }
            this.db_conn = dt_src.getDBConnectionFromPool(user);
        }
        catch (SQLException sql_ex) {
            AQxmlError.throwAQEx(410, sql_ex);
        }
        return this.db_conn;
    }

    Connection getConn(Connection conn, long env_hdl, long err_hdl, long svc_hdl) throws AQxmlException {
        Properties props1 = new Properties();
        props1.put("OCIEnvHandle", String.valueOf(env_hdl));
        props1.put("OCISvcCtxHandle", String.valueOf(svc_hdl));
        props1.put("OCIErrHandle", String.valueOf(err_hdl));
        props1.put("autoCommit", "false");
        try {
            this.db_conn = DriverManager.getConnection(((OracleConnection)conn).getURL(), props1);
            this.db_conn.setAutoCommit(false);
        }
        catch (SQLException sql_ex) {
            AQxmlDebug.traceEx(3, "AQxmlSessionContext.setCurrentDBConnection-sqlex", sql_ex);
            AQxmlError.throwAQEx(410, sql_ex);
        }
        return this.db_conn;
    }

    Connection setCurrentDBConnection(Connection curr_conn) throws AQxmlException {
        AQxmlDebug.trace(4, "AQxmlSessionContext.setCurrentDBConnection", "entry");
        this.db_conn = curr_conn;
        AQxmlDebug.trace(4, "AQxmlSessionContext.setCurrentDBConnection", "exit");
        return this.db_conn;
    }

    synchronized Connection getParentDBConnection(AQxmlServContext serv_ctx) throws AQxmlException {
        AQxmlDataSource dt_src = null;
        Connection parent_conn = null;
        AQxmlDebug.trace(4, "AQxmlSessionContext.getParentDBConnection", "entry");
        try {
            dt_src = serv_ctx.getDataSource();
            if (dt_src == null) {
                AQxmlError.throwAQEx(401, "Invalid dt_src");
            }
            parent_conn = dt_src.getDBConnectionFromPool(null);
        }
        catch (SQLException sql_ex) {
            AQxmlError.throwAQEx(410, sql_ex);
        }
        return parent_conn;
    }

    public synchronized void valueBound(HttpSessionBindingEvent event) {
        AQxmlDebug.trace(5, "AQxmlSessionContext:valueBound: ", event.getName());
    }

    public synchronized void valueUnbound(HttpSessionBindingEvent event) {
        Boolean[] genxml = new Boolean[1];
        AQxmlDebug.trace(5, "AQxmlSessionContext:valueUnBound: ", event.getName());
    }

    long[] printCurrentOCIHandles(String context, Connection conn) {
        if (AQxmlDebug.getTraceLevel() < 5) {
            return null;
        }
        AQxmlDebug.trace(5, "AQxmlSessionContext.printCurrentOCIHandles()", "entry:" + context);
        Properties prop = new Properties();
        try {
            prop = ((OracleConnection)conn).getOCIHandles();
        }
        catch (Exception e) {
            AQxmlDebug.traceEx(3, "AQxmlSessionContext.printCurrentOCIHandles()", e);
        }
        this.ocihndls = new long[3];
        this.ocihndls[0] = prop.getProperty("OCIEnvHandle") != null ? Long.parseLong(prop.getProperty("OCIEnvHandle")) : 0L;
        this.ocihndls[1] = prop.getProperty("OCIErrHandle") != null ? Long.parseLong(prop.getProperty("OCIErrHandle")) : 0L;
        this.ocihndls[2] = prop.getProperty("OCISvcCtxHandle") != null ? Long.parseLong(prop.getProperty("OCISvcCtxHandle")) : 0L;
        AQxmlDebug.trace(5, "AQxmlSessionContext.printCurrentOCIHandles()", "\nocihdls[0] : " + this.ocihndls[0] + "\nocihdls[1] : " + this.ocihndls[1] + "\nocihdls[2] : " + this.ocihndls[2]);
        return this.ocihndls;
    }

    synchronized String getTransfxmSrc(String transfxm) {
        int commapos = -1;
        OracleCallableStatement pstmt = null;
        String src_type = null;
        String dest_type = null;
        String transfxm_schema = null;
        String transfxm_name = null;
        commapos = transfxm.indexOf(".", 1);
        AQxmlDebug.trace(3, "AQxmlSessionContext.getTransfxmSrc", "enter:" + transfxm);
        try {
            if (commapos == -1) {
                transfxm_schema = ((OracleConnection)this.db_conn).getUserName();
                transfxm_name = transfxm;
            } else {
                transfxm_schema = transfxm.substring(0, commapos);
                transfxm_name = transfxm.substring(commapos + 1);
            }
            AQxmlDebug.trace(3, "AQxmlSessionContext.getTransfxmSrc", "schema" + transfxm_schema + " name: " + transfxm_name);
            src_type = (String)this.trans_list.get(transfxm_schema + "." + transfxm_name);
            if (src_type != null) {
                AQxmlDebug.trace(3, "AQxmlSessionContext.getTransfxmSrc", "src_type cached:" + src_type);
                return src_type;
            }
            pstmt = (OracleCallableStatement)this.db_conn.prepareCall("begin dbms_aqjms.aq$_get_trans_type(?, ?, ? ,?); end;");
            pstmt.setString(1, transfxm_schema);
            pstmt.setString(2, transfxm_name);
            pstmt.registerOutParameter(3, 12);
            pstmt.registerOutParameter(4, 12);
            pstmt.execute();
            src_type = pstmt.getString(3);
            dest_type = pstmt.getString(4);
            AQxmlDebug.trace(3, "AQxmlSessionContext.getTransfxmSrc", "dest_type:" + src_type);
        }
        catch (SQLException ex) {
            AQxmlDebug.traceEx(3, "AQxmlSessionContext.getTransfxmSrc: ex1", ex);
        }
        try {
            pstmt.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (src_type != null) {
            this.trans_list.put(transfxm_schema + "." + transfxm_name, src_type);
        }
        return src_type;
    }

    boolean isPushRequest() {
        return this.push_req;
    }

    void set_push_req(int qid, String dbnm, int batch_no) {
        this.push_req = true;
        this.src_qid = qid;
        this.src_database = dbnm;
        this.batch_num = batch_no;
    }

    void clr_push_req() {
        this.push_req = false;
        this.src_qid = 0;
        this.src_database = null;
        this.batch_num = 0;
    }

    int getSourceQid() {
        return this.src_qid;
    }

    String getSourceDb() {
        return this.src_database;
    }

    int getBatchNum() {
        return this.batch_num;
    }
}

