/*
 * Decompiled with CFR 0.152.
 */
package oracle.jakarta.AQ.xml;

import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueReceiver;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.Topic;
import jakarta.jms.TopicConnection;
import jakarta.jms.TopicPublisher;
import jakarta.jms.TopicSession;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.transaction.xa.XAException;
import oracle.jakarta.AQ.AQAgent;
import oracle.jakarta.AQ.AQDequeueOption;
import oracle.jakarta.AQ.AQDriverManager;
import oracle.jakarta.AQ.AQEnqueueOption;
import oracle.jakarta.AQ.AQException;
import oracle.jakarta.AQ.AQMessage;
import oracle.jakarta.AQ.AQMessageProperty;
import oracle.jakarta.AQ.AQObjectPayload;
import oracle.jakarta.AQ.AQOracleDriver;
import oracle.jakarta.AQ.AQOracleQueue;
import oracle.jakarta.AQ.AQOracleSQLException;
import oracle.jakarta.AQ.AQQueue;
import oracle.jakarta.AQ.AQRawPayload;
import oracle.jakarta.AQ.AQSession;
import oracle.jakarta.AQ.AQSignature;
import oracle.jakarta.AQ.xml.AQxmlAdtMessage;
import oracle.jakarta.AQ.xml.AQxmlAgent;
import oracle.jakarta.AQ.xml.AQxmlAuthContext;
import oracle.jakarta.AQ.xml.AQxmlCallback;
import oracle.jakarta.AQ.xml.AQxmlCallbackContext;
import oracle.jakarta.AQ.xml.AQxmlClientRequest;
import oracle.jakarta.AQ.xml.AQxmlCommitRequest;
import oracle.jakarta.AQ.xml.AQxmlCommitResponse;
import oracle.jakarta.AQ.xml.AQxmlConsumerOption;
import oracle.jakarta.AQ.xml.AQxmlDDLRequest;
import oracle.jakarta.AQ.xml.AQxmlDataSource;
import oracle.jakarta.AQ.xml.AQxmlDebug;
import oracle.jakarta.AQ.xml.AQxmlDocument;
import oracle.jakarta.AQ.xml.AQxmlDriver;
import oracle.jakarta.AQ.xml.AQxmlEnqueueRequest;
import oracle.jakarta.AQ.xml.AQxmlEnqueueResponse;
import oracle.jakarta.AQ.xml.AQxmlError;
import oracle.jakarta.AQ.xml.AQxmlException;
import oracle.jakarta.AQ.xml.AQxmlFault;
import oracle.jakarta.AQ.xml.AQxmlJmsBytesMessage;
import oracle.jakarta.AQ.xml.AQxmlJmsMapMessage;
import oracle.jakarta.AQ.xml.AQxmlJmsMessage;
import oracle.jakarta.AQ.xml.AQxmlJmsObjectMessage;
import oracle.jakarta.AQ.xml.AQxmlJmsTextMessage;
import oracle.jakarta.AQ.xml.AQxmlMessage;
import oracle.jakarta.AQ.xml.AQxmlMessageHeader;
import oracle.jakarta.AQ.xml.AQxmlMessagePropertyList;
import oracle.jakarta.AQ.xml.AQxmlProducerOption;
import oracle.jakarta.AQ.xml.AQxmlPublishRequest;
import oracle.jakarta.AQ.xml.AQxmlPublishResponse;
import oracle.jakarta.AQ.xml.AQxmlPushRequest;
import oracle.jakarta.AQ.xml.AQxmlPushResponse;
import oracle.jakarta.AQ.xml.AQxmlRawMessage;
import oracle.jakarta.AQ.xml.AQxmlReceiveRequest;
import oracle.jakarta.AQ.xml.AQxmlReceiveResponse;
import oracle.jakarta.AQ.xml.AQxmlRegisterOption;
import oracle.jakarta.AQ.xml.AQxmlRegisterRequest;
import oracle.jakarta.AQ.xml.AQxmlRegisterResponse;
import oracle.jakarta.AQ.xml.AQxmlRollbackRequest;
import oracle.jakarta.AQ.xml.AQxmlRollbackResponse;
import oracle.jakarta.AQ.xml.AQxmlSendRequest;
import oracle.jakarta.AQ.xml.AQxmlSendResponse;
import oracle.jakarta.AQ.xml.AQxmlSequenceNumRequest;
import oracle.jakarta.AQ.xml.AQxmlSequenceNumResponse;
import oracle.jakarta.AQ.xml.AQxmlServContext;
import oracle.jakarta.AQ.xml.AQxmlServerResponse;
import oracle.jakarta.AQ.xml.AQxmlSessionContext;
import oracle.jakarta.AQ.xml.AQxmlSessionMgr;
import oracle.jakarta.AQ.xml.AQxmlSignature;
import oracle.jakarta.AQ.xml.AQxmlStatusResponse;
import oracle.jakarta.AQ.xml.AQxmlTypeInfoRequest;
import oracle.jakarta.AQ.xml.AQxmlTypeInfoResponse;
import oracle.jakarta.AQ.xml.StreamsAddTablePropagationRulesRequest;
import oracle.jakarta.AQ.xml.StreamsAddTableRulesRequest;
import oracle.jakarta.AQ.xml.StreamsAddTableRulesResponse;
import oracle.jakarta.AQ.xml.StreamsSetupQueueRequest;
import oracle.jakarta.AQ.xml.StreamsSetupQueueResponse;
import oracle.jakarta.AQ.xml.StreamsStartApplyRequest;
import oracle.jakarta.AQ.xml.StreamsStartApplyResponse;
import oracle.jakarta.AQ.xml.StreamsStartCaptureRequest;
import oracle.jakarta.AQ.xml.StreamsStartCaptureResponse;
import oracle.jakarta.jms.AQjmsAgent;
import oracle.jakarta.jms.AQjmsBytesMessage;
import oracle.jakarta.jms.AQjmsConsumer;
import oracle.jakarta.jms.AQjmsDestination;
import oracle.jakarta.jms.AQjmsMapMessage;
import oracle.jakarta.jms.AQjmsMessage;
import oracle.jakarta.jms.AQjmsObjectMessage;
import oracle.jakarta.jms.AQjmsQueueConnectionFactory;
import oracle.jakarta.jms.AQjmsQueueReceiver;
import oracle.jakarta.jms.AQjmsQueueSender;
import oracle.jakarta.jms.AQjmsSession;
import oracle.jakarta.jms.AQjmsSignature;
import oracle.jakarta.jms.AQjmsTextMessage;
import oracle.jakarta.jms.AQjmsTopicConnectionFactory;
import oracle.jakarta.jms.AQjmsTopicPublisher;
import oracle.jakarta.jms.AQjmsTopicReceiver;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.util.RepConversion;
import oracle.sql.STRUCT;
import oracle.xdb.XMLType;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.sql.core.OracleXMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

class AQxmlProcessor {
    AQxmlServContext serv_ctx = null;
    AQxmlDriver driver = null;

    AQxmlProcessor(AQxmlServContext servlet_context) throws AQxmlException {
        AQxmlDebug.trace(4, "AQxmlProcessor.AQxmlProcessor", "Constructor Entry");
        this.serv_ctx = servlet_context;
        if (servlet_context == null) {
            AQxmlError.throwAQEx(401, "servlet_context = null");
        }
    }

    AQxmlServContext getServletContext() {
        return this.serv_ctx;
    }

    void setServletContext(AQxmlServContext servlet_ctx) {
        this.serv_ctx = servlet_ctx;
    }

    AQxmlDriver getXmlDriver() {
        return this.driver;
    }

    void setXmlDriver(AQxmlDriver xml_drv) {
        this.driver = xml_drv;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void processMessage(HttpServletRequest request, HttpServletResponse response, AQxmlCallback user_cbk, String xsl_proc_instr) throws IOException, AQxmlException {
        Object conv = null;
        AQxmlDocument[] aqdocs = null;
        AQxmlDocument[] retDocs = null;
        XMLDocument responseDoc = null;
        Document dom_doc = null;
        HttpSession http_sess = null;
        AQxmlSessionContext sess_ctx = null;
        AQxmlAuthContext auth_ctx = null;
        Object user = null;
        PrintWriter writer = null;
        int fault_code = 110;
        Object pinstr = null;
        AQxmlCallbackContext ucb_ctx = null;
        AQxmlSessionMgr sess_mgr = null;
        String[] own_queue = new String[2];
        boolean abort_op = false;
        try {
            AQxmlDebug.trace(4, "AQxmlProcessor.processMessage", "Entry");
            responseDoc = new XMLDocument();
            if (this.driver == null) {
                this.driver = new AQxmlDriver();
            }
            dom_doc = this.driver.parseDocument(request, this.serv_ctx);
            aqdocs = this.driver.generateAQxmlDocument(dom_doc, this.serv_ctx);
            fault_code = 100;
            http_sess = request.getSession(false);
            if (http_sess == null) {
                AQxmlDebug.trace(3, "AQxmlProcessor.processMessage", "http_sess=null");
                AQxmlError.throwAQEx(401, "http_sess=null");
            }
            sess_ctx = (AQxmlSessionContext)http_sess.getValue("AQxmlSessionContext");
            response.setContentType("text/xml");
            sess_mgr = new AQxmlSessionMgr();
            retDocs = new AQxmlDocument[aqdocs.length];
            ucb_ctx = new AQxmlCallbackContext(dom_doc, null, xsl_proc_instr);
            for (int i = 0; i < aqdocs.length && aqdocs[i] != null; ++i) {
                try {
                    this.resolveLdapQAlias(aqdocs[i]);
                    boolean is_ddl = aqdocs[i] instanceof AQxmlDDLRequest;
                    if (!(aqdocs[i] instanceof AQxmlClientRequest)) {
                        AQxmlDebug.trace(3, "AQxmlProcessor.processMessage", "doc: " + aqdocs[i]);
                        AQxmlError.throwAQEx(401, "Invalid doc " + aqdocs[i]);
                    }
                    if (this.serv_ctx.getDataSource() != this.serv_ctx.getDataSourceByName(((AQxmlClientRequest)aqdocs[i]).getDBName())) {
                        AQxmlDebug.trace(4, "AQxmlProcessor.processMessage", "switching AQxmlDataSource");
                        sess_mgr.detachUserSession(this.serv_ctx, sess_ctx, this, null);
                        this.serv_ctx.setDefaultDataSource(((AQxmlClientRequest)aqdocs[i]).getDBName());
                    }
                    if (sess_ctx.getCurrentDBConnection() == null) {
                        sess_mgr.initializeUserSession(this.serv_ctx, sess_ctx, this, aqdocs[i], is_ddl);
                    } else {
                        int oper = -1;
                        String uname = null;
                        oper = sess_mgr.getUserOperation(aqdocs[i], own_queue);
                        auth_ctx = sess_ctx.getAuthContext();
                        uname = auth_ctx.getDBUser(this.serv_ctx, own_queue[0], own_queue[1], oper, auth_ctx.getCurrentDbUser());
                        if (is_ddl != (sess_ctx.getSessionXid() != null) || !uname.equalsIgnoreCase(auth_ctx.getCurrentDbUser())) {
                            AQxmlDebug.trace(4, "AQxmlProcessor.processMessage: cannot reuse", " old user:" + auth_ctx.getCurrentDbUser() + " new user:" + uname);
                            sess_mgr.detachUserSession(this.serv_ctx, sess_ctx, this, null);
                            sess_mgr.initializeUserSession(this.serv_ctx, sess_ctx, this, aqdocs[i], uname, is_ddl);
                        } else {
                            AQxmlDebug.trace(4, "AQxmlProcessor.processMessage: reuse ", uname);
                        }
                    }
                    retDocs[i] = this.performAQoperations(sess_ctx, aqdocs[i], dom_doc, (Document)responseDoc, user_cbk, request, response, xsl_proc_instr, ucb_ctx);
                }
                catch (AQxmlException aqxml_ex) {
                    AQxmlDebug.traceEx(4, "AQxmlProcessor.processMessage", aqxml_ex);
                    retDocs[i] = AQxmlProcessor.createExceptionResponse(aqxml_ex, fault_code);
                    if (request != null && user_cbk != null && sess_ctx != null) {
                        ucb_ctx.setDBConnection(sess_ctx.getCurrentDBConnection());
                        ucb_ctx.setServerResponseDoc(retDocs[i]);
                        this.invokeAfterAQCallback(user_cbk, request, response, ucb_ctx);
                        abort_op = true;
                    }
                }
                catch (SQLException sql_ex) {
                    AQxmlDebug.traceEx(4, "AQxmlProcessor.processMessage", sql_ex);
                    abort_op = true;
                    sql_ex.printStackTrace();
                }
                if (abort_op) break;
            }
            AQxmlDebug.trace(5, "AQxmlProcessor.processMessage", "after perfAQoper-2");
            if (!ucb_ctx.getOverrideAQResponseFlag()) {
                AQxmlProcessor.setStylesheetInResponse((Document)responseDoc, ucb_ctx, xsl_proc_instr);
                this.driver.generateDOMDocument(retDocs, (Document)responseDoc, this.serv_ctx);
                writer = response.getWriter();
                AQxmlDebug.trace(5, "AQxmlProcessor.processMessage", "print to stream-2");
                responseDoc.print(writer);
            }
            if (sess_mgr != null) {
                sess_mgr.detachUserSession(this.serv_ctx, sess_ctx, this, null);
            }
            this.setServletContext(null);
            return;
        }
        catch (IOException io_ex) {
            try {
                AQxmlDebug.traceEx(3, "AQxmlProcessor.processMessage-ex2", io_ex);
                throw io_ex;
                catch (AQxmlException aqxml_ex) {
                    AQxmlDebug.traceEx(3, "AQxmlProcessor.processMessage-genxml-ex", aqxml_ex);
                    throw aqxml_ex;
                }
            }
            catch (Throwable throwable) {
                if (sess_mgr != null) {
                    sess_mgr.detachUserSession(this.serv_ctx, sess_ctx, this, null);
                }
                this.setServletContext(null);
                throw throwable;
            }
        }
    }

    static void processMessage(AQxmlDataSource aq_ds, String aq_agent, StringReader request_stream, OutputStream response_stream, String xsl_proc_instr) throws IOException, AQxmlException {
        AQxmlProcessor.processEmailMessage(aq_ds, aq_agent, request_stream, response_stream, xsl_proc_instr);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void processEmailMessage(AQxmlDataSource aq_ds, String email_user, StringReader request_stream, OutputStream response_stream, String xsl_proc_instr) throws IOException, AQxmlException {
        AQxmlProcessor aq_proc = null;
        Object conv = null;
        AQxmlDocument[] aqdocs = null;
        XMLDocument responseDoc = null;
        AQxmlDocument[] retDocs = null;
        AQxmlDriver driver = null;
        Document dom_doc = null;
        Object http_sess = null;
        AQxmlServContext serv_ctx = null;
        AQxmlSessionContext sess_ctx = null;
        AQxmlAuthContext auth_ctx = null;
        Object user = null;
        Object writer = null;
        int fault_code = 110;
        Object pinstr = null;
        AQxmlSessionMgr sess_mgr = null;
        String[] own_queue = new String[2];
        boolean abort_op = false;
        try {
            AQxmlDebug.trace(4, "AQxmlProcessor.processEmailMessage", "Entry");
            if (email_user == null) {
                AQxmlError.throwAQEx(401, "email_user = null");
            }
            if (aq_ds == null) {
                AQxmlError.throwAQEx(401, "data source = null");
            }
            if (request_stream == null || response_stream == null) {
                AQxmlError.throwAQEx(401, "request/response = null");
            }
            responseDoc = new XMLDocument();
            serv_ctx = new AQxmlServContext(aq_ds);
            aq_proc = new AQxmlProcessor(serv_ctx);
            auth_ctx = new AQxmlAuthContext(email_user);
            sess_ctx = new AQxmlSessionContext(auth_ctx, aq_proc);
            driver = new AQxmlDriver();
            dom_doc = driver.parseDocument(request_stream, serv_ctx);
            aqdocs = driver.generateAQxmlDocument(dom_doc, serv_ctx);
            fault_code = 100;
            sess_mgr = new AQxmlSessionMgr();
            for (int i = 0; i < aqdocs.length && aqdocs[i] != null; ++i) {
                boolean is_ddl = aqdocs[i] instanceof AQxmlDDLRequest;
                try {
                    aq_proc.resolveLdapQAlias(aqdocs[i]);
                    if (sess_ctx.getCurrentDBConnection() == null) {
                        sess_mgr.initializeUserSession(serv_ctx, sess_ctx, aq_proc, aqdocs[i], is_ddl);
                    } else {
                        int oper = -1;
                        String uname = null;
                        oper = sess_mgr.getUserOperation(aqdocs[i], own_queue);
                        auth_ctx = sess_ctx.getAuthContext();
                        uname = auth_ctx.getDBUser(serv_ctx, own_queue[0], own_queue[1], oper, auth_ctx.getCurrentDbUser());
                        if (is_ddl != (sess_ctx.getSessionXid() != null) || !uname.equalsIgnoreCase(auth_ctx.getCurrentDbUser())) {
                            AQxmlDebug.trace(4, "AQxmlProcessor.processMessage: cannot reuse", " old user:" + auth_ctx.getCurrentDbUser() + " new user:" + uname);
                            sess_mgr.detachUserSession(serv_ctx, sess_ctx, aq_proc, null);
                            sess_mgr.initializeUserSession(serv_ctx, sess_ctx, aq_proc, aqdocs[i], uname, is_ddl);
                        } else {
                            AQxmlDebug.trace(4, "AQxmlProcessor.processMessage: reuse ", uname);
                        }
                    }
                    retDocs[i] = aq_proc.performAQoperations(sess_ctx, aqdocs[i], dom_doc, (Document)responseDoc, null, null, null, xsl_proc_instr, null);
                }
                catch (AQxmlException aqxml_ex) {
                    AQxmlDebug.traceEx(4, "AQxmlProcessor.processEmailMessage", aqxml_ex);
                    abort_op = true;
                    retDocs[i] = AQxmlProcessor.createExceptionResponse(aqxml_ex, fault_code);
                }
                catch (SQLException sql_ex) {
                    AQxmlDebug.traceEx(4, "AQxmlProcessor.processMessage", sql_ex);
                    abort_op = true;
                    sql_ex.printStackTrace();
                }
                if (abort_op) break;
            }
            AQxmlDebug.trace(5, "AQxmlProcessor.processMessage", "Response Doc: " + (Document)responseDoc);
            if (retDocs != null) {
                AQxmlProcessor.setStylesheetInResponse((Document)responseDoc, null, xsl_proc_instr);
                driver.generateDOMDocument(retDocs, (Document)responseDoc, serv_ctx);
                AQxmlDebug.trace(5, "AQxmlProcessor.processEmailMessage", "print to stream");
                responseDoc.print(response_stream);
            }
            sess_mgr.detachUserSession(serv_ctx, sess_ctx, aq_proc, null);
            return;
        }
        catch (IOException io_ex) {
            try {
                AQxmlDebug.traceEx(3, "AQxmlProcessor.processMessage-ex2", io_ex);
                throw io_ex;
                catch (AQxmlException aqxml_ex) {
                    AQxmlDebug.traceEx(3, "AQxmlProcessor.processMessage-genxml-ex", aqxml_ex);
                    throw aqxml_ex;
                }
            }
            catch (Throwable throwable) {
                sess_mgr.detachUserSession(serv_ctx, sess_ctx, aq_proc, null);
                throw throwable;
            }
        }
    }

    AQxmlDocument performAQoperations(AQxmlSessionContext sess_ctx, AQxmlDocument aq_xml_doc, Document source_doc, Document resp_doc, AQxmlCallback user_cbk, HttpServletRequest request, HttpServletResponse response, String xsl_proc_instr, AQxmlCallbackContext ucb_ctx) throws AQxmlException, IOException {
        AQxmlDocument retDoc = null;
        AQxmlCommitRequest auto_commit = null;
        AQxmlDocument temp_doc = null;
        Object writer = null;
        AQxmlDebug.trace(4, "AQxmlProcessor.performAQoperations", "Entry");
        if (request != null && user_cbk != null) {
            ucb_ctx.setDBConnection(sess_ctx.getCurrentDBConnection());
            this.invokeBeforeAQCallback(user_cbk, request, response, ucb_ctx);
        }
        if (aq_xml_doc instanceof AQxmlSendRequest || aq_xml_doc instanceof AQxmlPublishRequest || aq_xml_doc instanceof AQxmlPushRequest) {
            retDoc = this.enqueueOperation(sess_ctx, (AQxmlClientRequest)aq_xml_doc);
        } else if (aq_xml_doc instanceof AQxmlReceiveRequest) {
            retDoc = this.dequeueOperation(sess_ctx, (AQxmlClientRequest)aq_xml_doc, resp_doc);
        } else if (aq_xml_doc instanceof AQxmlCommitRequest || aq_xml_doc instanceof AQxmlRollbackRequest) {
            retDoc = this.comOrRbOperation(sess_ctx, (AQxmlClientRequest)aq_xml_doc);
        } else if (aq_xml_doc instanceof AQxmlRegisterRequest) {
            retDoc = this.registerOperation(sess_ctx, (AQxmlClientRequest)aq_xml_doc);
        } else if (aq_xml_doc instanceof AQxmlSequenceNumRequest) {
            retDoc = this.getSequenceNumOperation(sess_ctx, (AQxmlClientRequest)aq_xml_doc);
        } else if (aq_xml_doc instanceof AQxmlTypeInfoRequest) {
            retDoc = this.getQueueTypeOperation(sess_ctx, (AQxmlClientRequest)aq_xml_doc);
        } else if (aq_xml_doc instanceof StreamsSetupQueueRequest) {
            retDoc = this.doSetupQueueOperation(sess_ctx, (StreamsSetupQueueRequest)aq_xml_doc);
        } else if (aq_xml_doc instanceof StreamsAddTableRulesRequest) {
            retDoc = this.doAddTableRules(sess_ctx, (StreamsAddTableRulesRequest)aq_xml_doc);
        } else if (aq_xml_doc instanceof StreamsAddTablePropagationRulesRequest) {
            retDoc = this.doAddTablePropagationRules(sess_ctx, (StreamsAddTablePropagationRulesRequest)aq_xml_doc);
        } else if (aq_xml_doc instanceof StreamsStartCaptureRequest) {
            retDoc = this.doStartCapture(sess_ctx, (StreamsStartCaptureRequest)aq_xml_doc);
        } else if (aq_xml_doc instanceof StreamsStartApplyRequest) {
            retDoc = this.doStartApply(sess_ctx, (StreamsStartApplyRequest)aq_xml_doc);
        } else {
            AQxmlDebug.trace(3, "AQxmlProcessor.performaqoperations", "doc: " + aq_xml_doc);
            AQxmlError.throwAQEx(401, "Invalid doc " + aq_xml_doc);
        }
        AQxmlDebug.trace(5, "AQxmlProcessor.performAQOperations", "Ret Doc: " + retDoc);
        if (request != null && user_cbk != null) {
            ucb_ctx.setServerResponseDoc(retDoc);
            this.invokeAfterAQCallback(user_cbk, request, response, ucb_ctx);
        }
        if (((AQxmlClientRequest)aq_xml_doc).getAutoCommit() && !(aq_xml_doc instanceof AQxmlCommitRequest)) {
            auto_commit = new AQxmlCommitRequest();
            temp_doc = this.comOrRbOperation(sess_ctx, auto_commit);
        }
        AQxmlDebug.trace(4, "AQxmlProcessor.performaqoperations: ", "exit");
        return retDoc;
    }

    AQxmlDocument doSetupQueueOperation(AQxmlSessionContext sess_ctx, StreamsSetupQueueRequest client_req) throws AQxmlException {
        Connection db_conn = sess_ctx.getCurrentDBConnection();
        AQxmlStatusResponse status_resp = null;
        AQxmlDebug.trace(4, "AQxmlProcessor.doSetupQueueOperation", "entry");
        try {
            OracleCallableStatement stmt = (OracleCallableStatement)db_conn.prepareCall("begin dbms_streams_adm.set_up_queue(queue_table => ?, storage_clause => ?, queue_name => ?, queue_user=> ?, comment => ?); end; ");
            AQxmlDebug.trace(4, "StreamsSetupQueue", "qt: " + client_req.queue_table);
            AQxmlDebug.trace(4, "StreamsSetupQueue", "sc: " + client_req.storage_clause);
            AQxmlDebug.trace(4, "StreamsSetupQueue", "qn: " + client_req.queue_name);
            AQxmlDebug.trace(4, "StreamsSetupQueue", "qu: " + client_req.queue_user);
            AQxmlDebug.trace(4, "StreamsSetupQueue", "cm: " + client_req.comment);
            stmt.setString(1, client_req.queue_table);
            stmt.setString(2, client_req.storage_clause);
            stmt.setString(3, client_req.queue_name);
            stmt.setString(4, client_req.queue_user);
            stmt.setString(5, client_req.comment);
            stmt.execute();
            try {
                stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            status_resp = new AQxmlStatusResponse(0);
        }
        catch (SQLException sqlex) {
            AQxmlDebug.trace(4, "AQxmlProcessor.doSetupQueueOperation", "sql-exception");
            AQxmlError.throwAQEx(410, sqlex);
        }
        StreamsSetupQueueResponse result = new StreamsSetupQueueResponse();
        ((AQxmlServerResponse)result).setStatusResponse(status_resp);
        return result;
    }

    AQxmlDocument doAddTableRules(AQxmlSessionContext sess_ctx, StreamsAddTableRulesRequest client_req) throws AQxmlException {
        Connection db_conn = sess_ctx.getCurrentDBConnection();
        StreamsAddTableRulesResponse result = null;
        AQxmlDebug.trace(4, "AQxmlProcessor.doAddTableRules", "entry");
        try {
            OracleCallableStatement stmt = (OracleCallableStatement)db_conn.prepareCall("begin dbms_streams_adm.add_table_rules(table_name => ?, streams_type => ?, streams_name => ?, queue_name => ?, include_dml => " + client_req.include_dml.toString() + ", include_ddl => " + client_req.include_ddl.toString() + ", include_tagged_lcr => " + (client_req.include_tagged_lcr != null ? client_req.include_tagged_lcr.toString() : "null") + ", source_database => ?, dml_rule_name => ?, ddl_rule_name => ?, inclusion_rule => " + client_req.inclusion_rule.toString() + "); end;");
            AQxmlDebug.trace(4, "AddTableRules", "tn: " + client_req.table_name);
            AQxmlDebug.trace(4, "AddTableRules", "st: " + client_req.streams_type);
            AQxmlDebug.trace(4, "AddTableRules", "sn: " + client_req.streams_name);
            AQxmlDebug.trace(4, "AddTableRules", "qn: " + client_req.queue_name);
            AQxmlDebug.trace(4, "AddTableRules", "idml: " + client_req.include_dml);
            AQxmlDebug.trace(4, "AddTableRules", "iddl: " + client_req.include_ddl);
            AQxmlDebug.trace(4, "AddTableRules", "ilcr: " + client_req.include_tagged_lcr);
            AQxmlDebug.trace(4, "AddTableRules", "dbn: " + client_req.source_db_name);
            AQxmlDebug.trace(4, "AddTableRules", "incl: " + client_req.inclusion_rule);
            stmt.setString(1, client_req.table_name);
            stmt.setString(2, client_req.streams_type);
            stmt.setString(3, client_req.streams_name);
            stmt.setString(4, client_req.queue_name);
            stmt.setString(5, client_req.source_db_name);
            stmt.registerOutParameter(6, 12);
            stmt.registerOutParameter(7, 12);
            stmt.execute();
            result = new StreamsAddTableRulesResponse(stmt.getString(6), stmt.getString(7));
            try {
                stmt.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sqlex) {
            sqlex.printStackTrace();
            AQxmlDebug.trace(4, "StreamsSetupQueue", "sql-exception");
            AQxmlError.throwAQEx(410, sqlex);
        }
        if (result == null) {
            result = new StreamsAddTableRulesResponse();
        }
        return result;
    }

    AQxmlDocument doAddTablePropagationRules(AQxmlSessionContext sess_ctx, StreamsAddTablePropagationRulesRequest client_req) throws AQxmlException {
        Connection db_conn = sess_ctx.getCurrentDBConnection();
        StreamsAddTableRulesResponse result = null;
        AQxmlDebug.trace(4, "AQxmlProcessor.doAddTablePropagationRules", "entry");
        try {
            OracleCallableStatement stmt = (OracleCallableStatement)db_conn.prepareCall("begin dbms_streams_adm.add_table_propagation_rules(table_name => ?, streams_name => ?, source_queue_name => ?, destination_queue_name => ?, include_dml => " + client_req.include_dml.toString() + ", include_ddl => " + client_req.include_ddl.toString() + ", include_tagged_lcr => " + (client_req.include_tagged_lcr != null ? client_req.include_tagged_lcr.toString() : "null") + ", source_database => ?, dml_rule_name => ?, ddl_rule_name => ?, inclusion_rule => " + client_req.inclusion_rule.toString() + "); end;");
            AQxmlDebug.trace(4, "AddTableRules", "tn: " + client_req.table_name);
            AQxmlDebug.trace(4, "AddTableRules", "sn: " + client_req.streams_name);
            AQxmlDebug.trace(4, "AddTableRules", "srcqn: " + client_req.src_queue_name);
            AQxmlDebug.trace(4, "AddTableRules", "dstqn: " + client_req.dest_queue_name);
            AQxmlDebug.trace(4, "AddTableRules", "idml: " + client_req.include_dml);
            AQxmlDebug.trace(4, "AddTableRules", "iddl: " + client_req.include_ddl);
            AQxmlDebug.trace(4, "AddTableRules", "ilcr: " + client_req.include_tagged_lcr);
            AQxmlDebug.trace(4, "AddTableRules", "dbn: " + client_req.source_db_name);
            AQxmlDebug.trace(4, "AddTableRules", "incl: " + client_req.inclusion_rule);
            stmt.setString(1, client_req.table_name);
            stmt.setString(2, client_req.streams_name);
            stmt.setString(3, client_req.src_queue_name);
            stmt.setString(4, client_req.dest_queue_name);
            stmt.setString(5, client_req.source_db_name);
            stmt.registerOutParameter(6, 12);
            stmt.registerOutParameter(7, 12);
            stmt.execute();
            result = new StreamsAddTableRulesResponse(stmt.getString(6), stmt.getString(7));
            try {
                stmt.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sqlex) {
            sqlex.printStackTrace();
            AQxmlDebug.trace(4, "AQxmlProcessor.doAddTablePropgationRules", "sql-exception");
            AQxmlError.throwAQEx(410, sqlex);
        }
        if (result == null) {
            result = new StreamsAddTableRulesResponse();
        }
        return result;
    }

    AQxmlDocument doStartCapture(AQxmlSessionContext sess_ctx, StreamsStartCaptureRequest client_req) throws AQxmlException {
        Connection db_conn = sess_ctx.getCurrentDBConnection();
        StreamsStartCaptureResponse result = null;
        AQxmlStatusResponse status_resp = null;
        AQxmlDebug.trace(4, "AQxmlProcessor.doStartCapture", "entry");
        try {
            OracleCallableStatement stmt = (OracleCallableStatement)db_conn.prepareCall("begin dbms_capture_adm.start_capture(capture_name => ?); end;");
            AQxmlDebug.trace(4, "AQxmlProcessor.doStartCapture", "name: " + client_req.capture_name);
            stmt.setString(1, client_req.capture_name);
            stmt.execute();
            try {
                stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            status_resp = new AQxmlStatusResponse(0);
        }
        catch (SQLException sqlex) {
            AQxmlDebug.trace(4, "AQxmlProcessor.doStartCapture", "sql-exception");
            AQxmlError.throwAQEx(410, sqlex);
        }
        result = new StreamsStartCaptureResponse();
        ((AQxmlServerResponse)result).setStatusResponse(status_resp);
        return result;
    }

    AQxmlDocument doStartApply(AQxmlSessionContext sess_ctx, StreamsStartApplyRequest client_req) throws AQxmlException {
        Connection db_conn = sess_ctx.getCurrentDBConnection();
        StreamsStartApplyResponse result = null;
        AQxmlStatusResponse status_resp = null;
        AQxmlDebug.trace(4, "AQxmlProcessor.doStartApply", "entry");
        try {
            OracleCallableStatement stmt = (OracleCallableStatement)db_conn.prepareCall("begin dbms_apply_adm.start_apply(apply_name => ?); end;");
            AQxmlDebug.trace(4, "AQxmlProcessor.doStartApply", "name: " + client_req.apply_name);
            stmt.setString(1, client_req.apply_name);
            stmt.execute();
            try {
                stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            status_resp = new AQxmlStatusResponse(0);
        }
        catch (SQLException sqlex) {
            AQxmlDebug.trace(4, "AQxmlProcessor.doStartApply", "sql-exception");
            AQxmlError.throwAQEx(410, sqlex);
        }
        result = new StreamsStartApplyResponse();
        ((AQxmlServerResponse)result).setStatusResponse(status_resp);
        return result;
    }

    AQxmlDocument comOrRbOperation(AQxmlSessionContext sess_ctx, AQxmlClientRequest client_req) throws AQxmlException {
        AQxmlServerResponse com_or_rb_resp = null;
        AQxmlStatusResponse status_resp = null;
        AQxmlSessionMgr sess_mgr = null;
        try {
            sess_mgr = new AQxmlSessionMgr();
            if (client_req instanceof AQxmlCommitRequest) {
                if (sess_ctx.isPushRequest()) {
                    this.updPropStatus(sess_ctx.getCurrentDBConnection(), sess_ctx.getSourceQid(), sess_ctx.getSourceDb(), sess_ctx.getBatchNum());
                }
                sess_mgr.commitUserSession(this.serv_ctx, sess_ctx, this);
                sess_ctx.clr_push_req();
            } else if (client_req instanceof AQxmlRollbackRequest) {
                sess_mgr.rollbackUserSession(this.serv_ctx, sess_ctx, this);
                if (sess_ctx.isPushRequest()) {
                    sess_ctx.clr_push_req();
                }
            } else {
                AQxmlError.throwAQEx(401, "Invalid commit or rollback request");
            }
            status_resp = new AQxmlStatusResponse(0);
        }
        catch (AQxmlException aq_ex) {
            AQxmlDebug.traceEx(3, "AQxmlProcessor.comOrRbOpertion", aq_ex);
            throw aq_ex;
        }
        com_or_rb_resp = client_req instanceof AQxmlCommitRequest ? new AQxmlCommitResponse() : new AQxmlRollbackResponse();
        ((AQxmlServerResponse)com_or_rb_resp).setStatusResponse(status_resp);
        return com_or_rb_resp;
    }

    AQxmlDocument enqueueOperation(AQxmlSessionContext sess_ctx, AQxmlClientRequest client_req) throws AQxmlException {
        AQxmlSendRequest send_req = null;
        AQxmlPublishRequest pub_req = null;
        AQxmlPushRequest push_req = null;
        Object jms_msg_list = null;
        AQxmlDocument server_resp = null;
        boolean i = false;
        boolean jms_type = false;
        AQxmlDebug.trace(4, "AQxmlProcessor.enqueueOperation", "Entry");
        if (client_req instanceof AQxmlSendRequest) {
            send_req = (AQxmlSendRequest)client_req;
        } else if (client_req instanceof AQxmlPublishRequest) {
            pub_req = (AQxmlPublishRequest)client_req;
        } else {
            if (client_req instanceof AQxmlPushRequest) {
                push_req = (AQxmlPushRequest)client_req;
                server_resp = this.pushMessages(sess_ctx, push_req);
                return server_resp;
            }
            AQxmlError.throwAQEx(401, "Invalid request " + client_req);
        }
        jms_type = ((AQxmlEnqueueRequest)client_req).isJmsRequest();
        server_resp = jms_type ? (send_req != null ? this.sendJmsMessages(sess_ctx, send_req) : this.publishJmsMessages(sess_ctx, pub_req)) : this.enqueueAdtMessages(sess_ctx, client_req);
        return server_resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AQxmlDocument pushMessages(AQxmlSessionContext sess_ctx, AQxmlPushRequest push_req) throws AQxmlException {
        AQxmlProducerOption prod_opt = null;
        Vector jms_msg_list = null;
        AQQueue queue = null;
        Connection db_conn = null;
        AQSession aq_sess = null;
        AQOracleDriver aq_drv = null;
        AQxmlDocument server_resp = null;
        boolean jms_type = false;
        AQxmlDebug.trace(4, "AQxmlProcessor.pushMessages", "Entry");
        if (push_req == null) {
            AQxmlError.throwAQEx(401, "push_req = null");
        }
        try {
            db_conn = sess_ctx.getCurrentDBConnection();
            prod_opt = push_req.getProducerOption();
            if (!sess_ctx.isPushRequest()) {
                AQxmlDebug.trace(4, "AQxmlProcessor.pushMessages", "Setting push request");
                sess_ctx.set_push_req(prod_opt.getSourceQid(), prod_opt.getDbLink(), prod_opt.getSequenceNumber());
            }
            aq_drv = new AQOracleDriver();
            aq_sess = aq_drv.createAQSession(db_conn);
            queue = this.serv_ctx.getAQQueue(aq_sess, prod_opt.getDestinationOwner(), prod_opt.getDestinationName(), false);
            jms_msg_list = push_req.getMessageList();
            jms_type = push_req.isJmsRequest();
            server_resp = jms_type ? (!((AQOracleQueue)queue).isMultiConsumer() ? this.sendJmsMessages(sess_ctx, push_req) : this.publishJmsMessages(sess_ctx, push_req)) : this.enqueueAdtMessages(sess_ctx, push_req);
        }
        catch (AQException aq_ex) {
            AQxmlDebug.traceEx(3, "AQxmlProcessor.pushMessages-aq_ex", aq_ex);
            AQxmlError.throwAQEx(436, aq_ex);
        }
        finally {
            try {
                if (aq_sess != null) {
                    aq_sess.close();
                }
                if (queue != null) {
                    queue.close();
                }
            }
            catch (Exception exception) {}
        }
        return server_resp;
    }

    AQxmlDocument sendJmsMessages(AQxmlSessionContext sess_ctx, AQxmlEnqueueRequest enq_req) throws AQxmlException {
        AQxmlProducerOption prod_opt = null;
        QueueConnection q_conn = null;
        QueueSession q_sess = null;
        Queue jms_queue = null;
        QueueSender q_sender = null;
        AQxmlEnqueueResponse enq_resp = null;
        AQxmlStatusResponse status_resp = null;
        AQjmsMessage jms_msg = null;
        AQxmlMessageHeader msg_hdr = null;
        AQxmlMessagePropertyList msgProp = null;
        AQjmsAgent jms_sdr = null;
        AQjmsAgent jms_rplt = null;
        Vector xml_msg_list = null;
        Connection db_conn = null;
        int i = 0;
        int size = 0;
        AQxmlDebug.trace(4, "AQxmlProcessor.sendJmsMessages", "Entry");
        if (enq_req == null) {
            AQxmlError.throwAQEx(401, "enq_req = null");
        }
        try {
            db_conn = sess_ctx.getCurrentDBConnection();
            prod_opt = enq_req.getProducerOption();
            if (prod_opt.getVisibility() == 1) {
                AQxmlError.throwAQEx(443);
            }
            xml_msg_list = enq_req.getMessageList();
            if (enq_resp == null) {
                if (enq_req instanceof AQxmlSendRequest) {
                    enq_resp = new AQxmlSendResponse(prod_opt.getDestinationName());
                } else if (enq_req instanceof AQxmlPushRequest) {
                    enq_resp = new AQxmlPushResponse(prod_opt.getDestinationName());
                } else {
                    AQxmlError.throwAQEx(401, "invalid enq req " + enq_req);
                }
            }
            q_conn = AQjmsQueueConnectionFactory.createQueueConnection(db_conn);
            q_sess = q_conn.createQueueSession(true, 0);
            jms_queue = this.serv_ctx.getJmsQueue((AQjmsSession)q_sess, prod_opt.getDestinationOwner(), prod_opt.getDestinationName());
            enq_resp.setDestination(((AQjmsDestination)jms_queue).getCompleteName());
            q_sender = q_sess.createSender(jms_queue);
            if (prod_opt.getTransformation() != null) {
                ((AQjmsQueueSender)q_sender).setTransformation(prod_opt.getTransformation());
            }
            size = xml_msg_list.size();
            for (i = 0; i < size; ++i) {
                jms_msg = (AQjmsMessage)((AQxmlJmsMessage)xml_msg_list.elementAt(i)).getJmsMessage();
                msg_hdr = ((AQxmlJmsMessage)xml_msg_list.elementAt(i)).getHeader();
                if (msg_hdr != null && msg_hdr.getSenderId() != null) {
                    jms_sdr = (AQjmsAgent)this.convertXmlAgent(msg_hdr.getSenderId(), 1);
                    jms_msg.setSenderID(jms_sdr);
                }
                if ((msgProp = ((AQxmlJmsMessage)xml_msg_list.elementAt(i)).getPropertyList()) != null && msgProp.getReplyTo() != null) {
                    jms_rplt = (AQjmsAgent)this.convertXmlAgent(msgProp.getReplyTo(), 1);
                    jms_msg.setJMSReplyTo(jms_rplt);
                }
                q_sender.send((Message)jms_msg, 2, jms_msg.getJMSPriority(), jms_msg.getJMSExpiration());
                String mid = jms_msg.getJMSMessageID();
                if (mid.startsWith("ID:")) {
                    mid = mid.substring(3);
                }
                enq_resp.setMessageId(mid);
            }
            status_resp = new AQxmlStatusResponse(0);
            enq_resp.setStatusResponse(status_resp);
            q_sender.close();
            q_sess.close();
            q_conn.close();
        }
        catch (JMSException jms_ex) {
            try {
                if (q_sess != null) {
                    q_sess.close();
                }
                if (q_conn != null) {
                    q_conn.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.serv_ctx.removeJmsQueue(prod_opt.getDestinationOwner(), prod_opt.getDestinationName());
            AQxmlDebug.traceEx(3, "AQxmlProcessor.sendJmsMessages", (Exception)((Object)jms_ex));
            AQxmlError.throwAQEx(406, (Exception)((Object)jms_ex));
        }
        return enq_resp;
    }

    AQxmlDocument publishJmsMessages(AQxmlSessionContext sess_ctx, AQxmlEnqueueRequest enq_req) throws AQxmlException {
        AQxmlProducerOption prod_opt = null;
        TopicConnection t_conn = null;
        TopicSession t_sess = null;
        Topic topic = null;
        TopicPublisher t_pub = null;
        AQxmlEnqueueResponse enq_resp = null;
        AQxmlStatusResponse status_resp = null;
        AQjmsMessage jms_msg = null;
        Vector xml_msg_list = null;
        Connection db_conn = null;
        int i = 0;
        AQxmlAgent[] x_rcpt_list = null;
        AQjmsAgent[] j_rcpt_list = null;
        int size = 0;
        AQxmlMessageHeader msg_hdr = null;
        AQxmlMessagePropertyList msgProp = null;
        AQjmsAgent jms_sdr = null;
        AQjmsAgent jms_rplt = null;
        AQxmlDebug.trace(4, "AQxmlProcessor.publishJmsMessages", "Entry");
        if (enq_req == null) {
            AQxmlError.throwAQEx(401, "enq_req = null");
        }
        try {
            db_conn = sess_ctx.getCurrentDBConnection();
            AQxmlDebug.trace(4, "AQxmlProcessor.publishJmsMessages", "after getCurrentDBConn");
            prod_opt = enq_req.getProducerOption();
            if (prod_opt.getVisibility() == 1) {
                AQxmlError.throwAQEx(443);
            }
            xml_msg_list = enq_req.getMessageList();
            AQxmlDebug.trace(5, "AQxmlProcessor.publishJmsMessages", "prod_opt = " + prod_opt + "  xml_msg_list" + xml_msg_list);
            AQxmlDebug.trace(5, "AQxmlProcessor.publishJmsMessages", "prod_opt - dest_owner= " + prod_opt.getDestinationOwner() + "\ndest_name= " + prod_opt.getDestinationName());
            if (enq_resp == null) {
                if (enq_req instanceof AQxmlPublishRequest) {
                    AQxmlDebug.trace(5, "AQxmlProcessor.publishJmsMessages", "enq_req" + enq_req);
                    enq_resp = new AQxmlPublishResponse(prod_opt.getDestinationName());
                } else if (enq_req instanceof AQxmlPushRequest) {
                    enq_resp = new AQxmlPushResponse(prod_opt.getDestinationName());
                } else {
                    AQxmlError.throwAQEx(401, "invalid enq req " + enq_req);
                }
            }
            AQxmlDebug.trace(4, "AQxmlProcessor.publishJmsMessages", "before getTopicConnection");
            t_conn = AQjmsTopicConnectionFactory.createTopicConnection(db_conn);
            t_sess = t_conn.createTopicSession(true, 0);
            AQxmlDebug.trace(4, "AQxmlProcessor.publishJmsMessages", "before getTopic");
            topic = this.serv_ctx.getJmsTopic((AQjmsSession)t_sess, prod_opt.getDestinationOwner(), prod_opt.getDestinationName());
            AQxmlDebug.trace(5, "AQxmlProcessor.publishJmsMessages", "after getTopic: " + topic);
            enq_resp.setDestination(((AQjmsDestination)topic).getCompleteName());
            t_pub = t_sess.createPublisher(topic);
            if (prod_opt.getTransformation() != null) {
                ((AQjmsTopicPublisher)t_pub).setTransformation(prod_opt.getTransformation());
            }
            size = xml_msg_list.size();
            AQxmlDebug.trace(4, "AQxmlProcessor.publishJmsMessages", "size =" + size);
            for (i = 0; i < size; ++i) {
                jms_msg = (AQjmsMessage)((AQxmlJmsMessage)xml_msg_list.elementAt(i)).getJmsMessage();
                msg_hdr = ((AQxmlMessage)xml_msg_list.elementAt(i)).getHeader();
                AQxmlDebug.trace(4, "AQxmlProcessor.publishJmsMessages", "message no. " + i);
                if (msg_hdr.getSenderId() != null) {
                    jms_sdr = (AQjmsAgent)this.convertXmlAgent(msg_hdr.getSenderId(), 1);
                    jms_msg.setSenderID(jms_sdr);
                }
                if ((msgProp = ((AQxmlJmsMessage)xml_msg_list.elementAt(i)).getPropertyList()).getReplyTo() != null) {
                    jms_rplt = (AQjmsAgent)this.convertXmlAgent(msgProp.getReplyTo(), 1);
                    jms_msg.setJMSReplyTo(jms_rplt);
                }
                if ((x_rcpt_list = msg_hdr.getRecipientList()) != null && x_rcpt_list.length != 0) {
                    j_rcpt_list = this.genJmsRcptList(x_rcpt_list);
                }
                ((AQjmsTopicPublisher)t_pub).publish(jms_msg, j_rcpt_list, 2, jms_msg.getJMSPriority(), jms_msg.getJMSExpiration());
                String mid = jms_msg.getJMSMessageID();
                if (mid.startsWith("ID:")) {
                    mid = mid.substring(3);
                }
                enq_resp.setMessageId(mid);
            }
            status_resp = new AQxmlStatusResponse(0);
            enq_resp.setStatusResponse(status_resp);
            t_pub.close();
            t_sess.close();
            t_conn.close();
        }
        catch (JMSException jms_ex) {
            try {
                if (t_sess != null) {
                    t_sess.close();
                }
                if (t_conn != null) {
                    t_conn.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.serv_ctx.removeJmsTopic(prod_opt.getDestinationOwner(), prod_opt.getDestinationName());
            AQxmlDebug.traceEx(3, "AQxmlProcessor.publishJmsMessages", (Exception)((Object)jms_ex));
            AQxmlError.throwAQEx(406, (Exception)((Object)jms_ex));
        }
        return enq_resp;
    }

    Vector convertToAQAgent_v(AQxmlAgent[] ag) throws AQxmlException {
        Vector<Object> ret_v = new Vector<Object>();
        int size = ag.length;
        for (int i = 0; i < size; ++i) {
            ret_v.addElement(this.convertXmlAgent(ag[i], 3));
        }
        return ret_v;
    }

    AQjmsAgent[] genJmsRcptList(AQxmlAgent[] x_agent_list) throws AQxmlException {
        int len = 0;
        AQjmsAgent[] jms_agent_list = null;
        len = x_agent_list.length;
        if (len == 0) {
            return null;
        }
        jms_agent_list = new AQjmsAgent[len];
        for (int i = 0; i < len; ++i) {
            jms_agent_list[i] = (AQjmsAgent)this.convertXmlAgent(x_agent_list[i], 1);
        }
        return jms_agent_list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AQxmlDocument enqueueAdtMessages(AQxmlSessionContext sess_ctx, AQxmlClientRequest client_req) throws AQxmlException {
        AQxmlSendRequest send_req = null;
        AQxmlPublishRequest pub_req = null;
        AQxmlPushRequest push_req = null;
        AQxmlProducerOption prod_opt = null;
        AQEnqueueOption enq_opt = null;
        AQSession aq_sess = null;
        AQOracleQueue queue = null;
        AQxmlEnqueueResponse enq_resp = null;
        AQxmlStatusResponse status_resp = null;
        Vector xml_msg_list = null;
        int i = 0;
        AQMessage message = null;
        AQMessageProperty msg_prop = null;
        AQObjectPayload adtmsg_payload = null;
        AQRawPayload rawmsg_payload = null;
        Object raw_bytes = null;
        AQxmlMessageHeader xml_msg_hdr = null;
        STRUCT msg_struct = null;
        AQOracleDriver aq_drv = null;
        String msg_body = null;
        OracleXMLUtil util = null;
        String adt_payload = null;
        byte[] raw_payload = null;
        Node body_node = null;
        Connection db_conn = null;
        AQAgent agt = null;
        AQxmlAgent xml_agt = null;
        int size = 0;
        Vector aqagent_v = null;
        AQxmlAgent[] rcpt_list = null;
        String adt_pld_type = null;
        CharArrayWriter c_writer = new CharArrayWriter();
        String adt_node_name = null;
        XMLType msg_oradata = null;
        AQxmlDebug.trace(4, "AQxmlProcessor.enqueueAdtMessages", "Entry");
        AQxmlDebug.trace(5, "AQxmlProcessor.enqueueAdtMessages", "Language : " + Locale.getDefault().getLanguage());
        AQxmlDebug.trace(5, "AQxmlProcessor.enqueueAdtMessages", "Country : " + Locale.getDefault().getCountry());
        AQxmlDebug.trace(5, "AQxmlProcessor.enqueueAdtMessages", "Variant : " + Locale.getDefault().getVariant());
        if (client_req instanceof AQxmlSendRequest) {
            send_req = (AQxmlSendRequest)client_req;
            prod_opt = send_req.getProducerOption();
            enq_resp = new AQxmlSendResponse(prod_opt.getDestinationName());
            xml_msg_list = send_req.getMessageList();
        } else if (client_req instanceof AQxmlPublishRequest) {
            pub_req = (AQxmlPublishRequest)client_req;
            prod_opt = pub_req.getProducerOption();
            enq_resp = new AQxmlPublishResponse(prod_opt.getDestinationName());
            xml_msg_list = pub_req.getMessageList();
        } else if (client_req instanceof AQxmlPushRequest) {
            push_req = (AQxmlPushRequest)client_req;
            prod_opt = push_req.getProducerOption();
            enq_resp = new AQxmlPushResponse(prod_opt.getDestinationName());
            xml_msg_list = push_req.getMessageList();
        } else {
            AQxmlError.throwAQEx(401, "Invalid request " + client_req);
        }
        try {
            db_conn = sess_ctx.getCurrentDBConnection();
            util = sess_ctx.getXMLUtil();
            if (util == null) {
                sess_ctx.setXMLUtil(new OracleXMLUtil(db_conn));
                util = sess_ctx.getXMLUtil();
            }
            aq_drv = new AQOracleDriver();
            aq_sess = aq_drv.createAQSession(db_conn);
            queue = (AQOracleQueue)this.serv_ctx.getAQQueue(aq_sess, prod_opt.getDestinationOwner(), prod_opt.getDestinationName(), true);
            enq_resp.setDestination(queue.getCompleteName());
            msg_prop = new AQMessageProperty();
            enq_opt = new AQEnqueueOption(prod_opt.getVisibility(), null, null);
            enq_opt.setTransformation(prod_opt.getTransformation());
            size = xml_msg_list.size();
            AQxmlDebug.trace(4, "AQxmlProcessor:enqueueAdtMessages", "size:" + size);
            for (i = 0; i < size; ++i) {
                AQxmlDebug.trace(4, "AQxmlProcessor:enqueueAdtMessages", "message:" + i);
                message = queue.createMessage();
                AQxmlMessage xml_msg = (AQxmlMessage)xml_msg_list.elementAt(i);
                xml_msg_hdr = xml_msg.getHeader();
                if (xml_msg_hdr == null) {
                    AQxmlDebug.trace(4, "AQxmlProcessor:enqueueAdtMessages", "message hdr null");
                }
                msg_prop.setCorrelation(xml_msg_hdr.getCorrelationID());
                xml_agt = xml_msg_hdr.getSenderId();
                if (xml_agt != null) {
                    agt = (AQAgent)this.convertXmlAgent(xml_agt, 3);
                }
                msg_prop.setSender(agt);
                rcpt_list = xml_msg_hdr.getRecipientList();
                if (rcpt_list != null && rcpt_list.length != 0) {
                    aqagent_v = this.convertToAQAgent_v(rcpt_list);
                    msg_prop.setRecipientList(aqagent_v);
                }
                msg_prop.setDelay(xml_msg_hdr.getDelay());
                msg_prop.setExceptionQueue(xml_msg_hdr.getExceptionQueue());
                msg_prop.setPriority(xml_msg_hdr.getPriority());
                msg_prop.setExpiration(xml_msg_hdr.getExpiration());
                if (xml_msg.getSignature() != null) {
                    AQjmsSignature sign = new AQjmsSignature();
                    this.convertxmltojmssig(xml_msg.getSignature(), sign);
                    msg_prop.setSignature(sign);
                }
                if (queue.getPayloadType() == 2) {
                    raw_payload = ((AQxmlRawMessage)xml_msg_list.elementAt(i)).getBytes();
                    AQxmlDebug.trace(5, "AQxmlProcessor.enqueueAdtMessages", "Raw Payload: " + raw_payload);
                } else {
                    body_node = ((AQxmlAdtMessage)xml_msg_list.elementAt(i)).getBodyNode();
                    try {
                        ((XMLNode)body_node).print((Writer)c_writer);
                    }
                    catch (Exception ex) {
                        AQxmlDebug.traceEx(3, "AQxmlProcessor.enqueueAdtMessages", ex);
                    }
                    try {
                        adt_payload = c_writer.toString();
                    }
                    catch (Exception ex) {
                        AQxmlDebug.traceEx(3, "AQxmlProcessor.enqueueAdtMessages", ex);
                    }
                    c_writer.reset();
                    AQxmlDebug.trace(5, "AQxmlProcessor.enqueueAdtMessages", "Adt Payload: " + adt_payload);
                }
                if (adt_payload != null) {
                    msg_body = adt_payload;
                    adt_pld_type = prod_opt.getTransformation() != null ? sess_ctx.getTransfxmSrc(prod_opt.getTransformation()) : queue.getObjectPayloadType();
                    AQxmlDebug.trace(5, "AQxmlProcessor.enqueueAdtMessages", "adt_pld_type: " + adt_pld_type);
                    AQxmlDebug.trace(5, "AQxmlProcessor.enqueueAdtMessages", "msg_body\n" + msg_body);
                    adtmsg_payload = message.getObjectPayload();
                    if (adt_pld_type.equalsIgnoreCase("SYS.XMLType")) {
                        AQxmlDebug.trace(5, "AQxmlProcessor.enqueueAdtMessages", "before createXML");
                        msg_oradata = XMLType.createXML((Connection)db_conn, (String)msg_body);
                        AQxmlDebug.trace(5, "AQxmlProcessor.enqueueAdtMessages", "after createXML");
                        adtmsg_payload.setPayloadData(msg_oradata);
                    } else if (adt_pld_type.equalsIgnoreCase("SYS.ANYDATA")) {
                        adt_node_name = ((XMLElement)body_node).getLocalName();
                        AQxmlDebug.trace(5, "AQxmlProcessor.enqueueAdtMessages", "adt_node_name" + adt_node_name);
                        msg_struct = util.getStructFromXML(msg_body, adt_node_name);
                        adtmsg_payload.setPayloadData(msg_struct);
                    } else {
                        msg_struct = util.getStructFromXML(msg_body, adt_pld_type);
                        adtmsg_payload.setPayloadData(msg_struct);
                    }
                } else if (raw_payload != null) {
                    rawmsg_payload = message.getRawPayload();
                    rawmsg_payload.setStream(raw_payload, raw_payload.length);
                } else {
                    AQxmlError.throwAQEx(401, "message body cannot be null");
                }
                message.setMessageProperty(msg_prop);
                AQxmlDebug.trace(5, "AQxmlProcessor.enqueueAdtMessages", "before enqueue");
                queue.enqueue(enq_opt, message);
                AQxmlDebug.trace(5, "AQxmlProcessor.enqueueAdtMessage", "after enqueue");
                enq_resp.setMessageId(RepConversion.bArray2String((byte[])message.getMessageId()));
                AQxmlDebug.trace(5, "AQxmlProcessor.enqueueAdtMessage", "after set message id");
                status_resp = new AQxmlStatusResponse(0);
                enq_resp.setStatusResponse(status_resp);
                AQxmlDebug.trace(5, "AQxmlProcessor.enqueueAdtMessage", "after set status");
            }
        }
        catch (AQException aq_ex) {
            AQxmlDebug.traceEx(3, "AQxmlProcessor.enqueueAdtMessage", aq_ex);
            AQxmlError.throwAQEx(436, aq_ex);
        }
        catch (SQLException sql_ex) {
            AQxmlDebug.traceEx(3, "AQxmlProcessor.enqueueAdtMessage-sqlex", sql_ex);
            AQxmlError.throwAQEx(410, sql_ex);
        }
        finally {
            if (aq_sess != null) {
                aq_sess.close();
            }
            if (queue != null) {
                queue.close();
            }
        }
        AQxmlDebug.trace(5, "AQxmlProcessor.enqueueAdtMessages", "Exit");
        return enq_resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AQxmlDocument dequeueOperation(AQxmlSessionContext sess_ctx, AQxmlClientRequest client_req, Document resp_doc) throws AQxmlException {
        AQxmlReceiveRequest receive_req = null;
        AQxmlConsumerOption consumer_opt = null;
        AQxmlDocument server_resp = null;
        boolean is_jms_dest = false;
        AQOracleDriver aq_drv = null;
        AQSession aq_sess = null;
        AQOracleQueue aq_queue = null;
        OracleXMLUtil util = null;
        Connection db_conn = null;
        boolean is_multi_cons = false;
        AQxmlDebug.trace(4, "AQxmlProcessor.dequeueOperation", "Entry");
        if (client_req != null && client_req instanceof AQxmlReceiveRequest) {
            receive_req = (AQxmlReceiveRequest)client_req;
        } else {
            AQxmlError.throwAQEx(401, "Invalid request " + client_req);
        }
        try {
            db_conn = sess_ctx.getCurrentDBConnection();
            AQDriverManager.setCacheStmtFlag(false);
            aq_drv = new AQOracleDriver();
            aq_sess = aq_drv.createAQSession(db_conn);
            consumer_opt = receive_req.getConsumerOption();
            aq_queue = (AQOracleQueue)this.serv_ctx.getAQQueue(aq_sess, consumer_opt.getDestinationOwner(), consumer_opt.getDestinationName(), true);
            is_jms_dest = this.isJmsDestination(aq_queue);
            if (is_jms_dest) {
                is_multi_cons = aq_queue.isMultiConsumer();
                server_resp = this.dequeueJmsMessages(sess_ctx, receive_req, is_multi_cons);
            } else {
                util = new OracleXMLUtil(db_conn);
                server_resp = this.dequeueAdtMessages(receive_req, aq_queue, util, resp_doc);
            }
        }
        catch (AQException aq_ex) {
            AQxmlDebug.traceEx(3, "AQxmlProcessor.dequeueOperation", aq_ex);
            AQxmlError.throwAQEx(436, aq_ex);
        }
        finally {
            try {
                AQxmlDebug.trace(5, "AQxmlProcessor.dequeueOperation", "util.close()");
                if (util != null) {
                    util.close();
                }
            }
            catch (Exception ut_ex) {
                AQxmlDebug.traceEx(3, "AQxmlProcessor.dequeueOperation-closeUtil", ut_ex);
                ut_ex.printStackTrace();
            }
            if (aq_sess != null) {
                aq_sess.close();
            }
            if (aq_queue != null) {
                aq_queue.close();
            }
        }
        return server_resp;
    }

    AQxmlDocument dequeueJmsMessages(AQxmlSessionContext sess_ctx, AQxmlClientRequest client_req, boolean is_multi_consumer) throws AQxmlException {
        AQxmlReceiveRequest receive_req = null;
        AQxmlConsumerOption cons_opt = null;
        QueueConnection q_conn = null;
        QueueSession q_sess = null;
        TopicConnection t_conn = null;
        TopicSession t_sess = null;
        AQjmsDestination jms_dest = null;
        AQjmsDestination queue = null;
        AQjmsDestination topic = null;
        QueueReceiver q_receiver = null;
        AQjmsTopicReceiver t_receiver = null;
        AQxmlReceiveResponse receive_resp = null;
        AQxmlStatusResponse status_resp = null;
        int navig_mode = 0;
        Object selector = null;
        Object condition = null;
        String cons_name = null;
        AQjmsMessage[] msg = null;
        Connection db_conn = null;
        int batch_size = 0;
        int wait_time = 0;
        int i = 0;
        Object ptype = null;
        AQxmlJmsMessage new_msg = null;
        String transformation = null;
        AQxmlDebug.trace(4, "AQxmlProcessor.dequeueJmsMessages", "Entry");
        receive_req = (AQxmlReceiveRequest)client_req;
        try {
            db_conn = sess_ctx.getCurrentDBConnection();
            cons_opt = receive_req.getConsumerOption();
            if (receive_resp == null) {
                receive_resp = new AQxmlReceiveResponse(cons_opt.getDestinationName());
            }
            if (cons_opt.getMessageId() != null) {
                AQxmlDebug.trace(5, "AQxmlProcessor.DequeueJmsMessages", "msgid selector");
                selector = "JMSMessageID= 'ID:" + AQxmlRawMessage.bArray2String(cons_opt.getMessageId()) + "'";
            } else if (cons_opt.getCorrelation() != null) {
                AQxmlDebug.trace(5, "AQxmlProcessor.DequeueJmsMessages", "corrid selector");
                selector = "JMSCorrelationID='" + cons_opt.getCorrelation() + "'";
            } else if (cons_opt.getCondition() != null) {
                AQxmlDebug.trace(5, "AQxmlProcessor.DequeueJmsMessages", "condition selector");
                selector = cons_opt.getCondition();
            }
            AQxmlDebug.trace(5, "AQxmlProcessor.DequeueJmsMessages", "after selectors");
            transformation = cons_opt.getTransformation();
            if (!is_multi_consumer) {
                q_conn = AQjmsQueueConnectionFactory.createQueueConnection(db_conn);
                q_sess = q_conn.createQueueSession(true, 0);
                q_conn.start();
                jms_dest = (AQjmsDestination)this.serv_ctx.getJmsQueue((AQjmsSession)q_sess, cons_opt.getDestinationOwner(), cons_opt.getDestinationName());
                AQxmlDebug.trace(5, "AQxmlProcessor.dequeueJmsMessages", "Queue: " + jms_dest.getQueueName());
                queue = jms_dest;
                receive_resp.setDestination(queue.getCompleteName());
                if (selector != null) {
                    AQxmlDebug.trace(5, "AQxmlProcessor.dequeueJmsMessages", "Selector Mode: " + (String)selector);
                    q_receiver = q_sess.createReceiver((Queue)queue, (String)selector);
                } else {
                    q_receiver = q_sess.createReceiver((Queue)queue);
                }
                ((AQjmsConsumer)q_receiver).setXmlReceive(true);
                navig_mode = cons_opt.getNavigationMode();
                AQxmlDebug.trace(5, "AQxmlProcessor.DequeueJmsMessages", "Navigation Mode: " + navig_mode);
                ((AQjmsQueueReceiver)q_receiver).setNavigationMode(navig_mode);
                batch_size = cons_opt.getBatchSize();
                AQxmlDebug.trace(5, "AQxmlProcessor.DequeueJmsMessages", "batch size loop: " + batch_size);
                msg = new AQjmsMessage[batch_size];
                if (transformation != null) {
                    ((AQjmsQueueReceiver)q_receiver).setTransformation(transformation);
                }
                if (cons_opt.getWaitTime() > 0) {
                    wait_time = 1000 * cons_opt.getWaitTime();
                }
                for (i = 0; i < batch_size; ++i) {
                    if (cons_opt.getSignature() != null) {
                        AQjmsSignature sign = new AQjmsSignature();
                        this.convertxmltojmssig(cons_opt.getSignature(), sign);
                    }
                    if (cons_opt.getDequeueMode() == 1 || cons_opt.getDequeueMode() == 2) {
                        boolean locked = false;
                        if (cons_opt.getDequeueMode() == 2) {
                            locked = true;
                        }
                        msg[i] = wait_time == 0 ? (AQjmsMessage)((AQjmsConsumer)q_receiver).browseNoWait(locked) : (AQjmsMessage)((AQjmsConsumer)q_receiver).browse(wait_time, locked);
                    } else {
                        msg[i] = wait_time == 0 ? (AQjmsMessage)q_receiver.receiveNoWait() : (AQjmsMessage)q_receiver.receive((long)wait_time);
                    }
                    if (msg[i] == null) break;
                    if (msg[i] instanceof AQjmsTextMessage) {
                        new_msg = new AQxmlJmsTextMessage((AQjmsTextMessage)msg[i]);
                    } else if (msg[i] instanceof AQjmsMapMessage) {
                        new_msg = new AQxmlJmsMapMessage((AQjmsMapMessage)msg[i]);
                    } else if (msg[i] instanceof AQjmsBytesMessage) {
                        new_msg = new AQxmlJmsBytesMessage((AQjmsBytesMessage)msg[i]);
                    } else if (msg[i] instanceof AQjmsObjectMessage) {
                        new_msg = new AQxmlJmsObjectMessage((AQjmsObjectMessage)msg[i]);
                    } else {
                        AQxmlError.throwAQEx(401, "invalid jms type " + msg[i]);
                    }
                    receive_resp.setMessage(new_msg);
                }
                q_receiver.close();
                q_sess.close();
                q_conn.close();
            } else {
                t_conn = AQjmsTopicConnectionFactory.createTopicConnection(db_conn);
                t_conn.start();
                t_sess = t_conn.createTopicSession(true, 0);
                topic = jms_dest = (AQjmsDestination)this.serv_ctx.getJmsTopic((AQjmsSession)t_sess, cons_opt.getDestinationOwner(), cons_opt.getDestinationName());
                AQxmlDebug.trace(5, "AQxmlProcessor.dequeueJmsMessages", "Topic: " + jms_dest.getTopicName());
                receive_resp.setDestination(topic.getCompleteName());
                if (selector != null) {
                    AQxmlDebug.trace(5, "AQxmlProcessor.dequeueJmsMessages", "Selector Mode: " + (String)selector);
                }
                if ((cons_name = cons_opt.getConsumerName()) == null) {
                    AQxmlError.throwAQEx(427);
                } else {
                    AQxmlDebug.trace(5, "AQxmlProcessor.dequeueJmsMessages", "cons_name: " + cons_name);
                }
                t_receiver = ((AQjmsSession)t_sess).createTopicReceiver(topic, cons_name, (String)selector);
                ((AQjmsConsumer)t_receiver).setXmlReceive(true);
                navig_mode = cons_opt.getNavigationMode();
                AQxmlDebug.trace(5, "AQxmlProcessor.dequeueJmsMessages", "Navigation Mode: " + navig_mode);
                t_receiver.setNavigationMode(navig_mode);
                batch_size = cons_opt.getBatchSize();
                AQxmlDebug.trace(5, "AQxmlProcessor.dequeueJmsMessages", "batch size loop: " + batch_size);
                msg = new AQjmsMessage[batch_size];
                if (transformation != null) {
                    t_receiver.setTransformation(transformation);
                }
                wait_time = 1000 * cons_opt.getWaitTime();
                for (i = 0; i < batch_size; ++i) {
                    if (cons_opt.getSignature() != null) {
                        AQjmsSignature sign = new AQjmsSignature();
                        this.convertxmltojmssig(cons_opt.getSignature(), sign);
                    }
                    if (cons_opt.getDequeueMode() == 1 || cons_opt.getDequeueMode() == 2) {
                        boolean locked = false;
                        if (cons_opt.getDequeueMode() == 2) {
                            locked = true;
                        }
                        msg[i] = wait_time == 0 ? (AQjmsMessage)((AQjmsConsumer)t_receiver).browseNoWait(locked) : (AQjmsMessage)((AQjmsConsumer)t_receiver).browse(wait_time, locked);
                    } else {
                        msg[i] = wait_time == 0 ? (AQjmsMessage)t_receiver.receiveNoWait() : (AQjmsMessage)t_receiver.receive(wait_time);
                    }
                    if (msg[i] == null) break;
                    if (msg[i] instanceof AQjmsTextMessage) {
                        new_msg = new AQxmlJmsTextMessage((AQjmsTextMessage)msg[i]);
                    } else if (msg[i] instanceof AQjmsMapMessage) {
                        new_msg = new AQxmlJmsMapMessage((AQjmsMapMessage)msg[i]);
                    } else if (msg[i] instanceof AQjmsBytesMessage) {
                        new_msg = new AQxmlJmsBytesMessage((AQjmsBytesMessage)msg[i]);
                    } else if (msg[i] instanceof AQjmsObjectMessage) {
                        new_msg = new AQxmlJmsObjectMessage((AQjmsObjectMessage)msg[i]);
                    } else {
                        AQxmlError.throwAQEx(401, "invalid jms type " + msg[i]);
                    }
                    receive_resp.setMessage(new_msg);
                }
                t_receiver.close();
                t_sess.close();
                t_conn.close();
            }
            status_resp = msg[0] == null ? new AQxmlStatusResponse(-1, 25228, "ORA-25228 - timeout or end-of-fetch during message dequeue") : new AQxmlStatusResponse(0);
            receive_resp.setStatusResponse(status_resp);
        }
        catch (JMSException jms_ex) {
            try {
                if (q_sess != null) {
                    q_sess.close();
                }
                if (t_sess != null) {
                    t_sess.close();
                }
                if (q_conn != null) {
                    q_conn.close();
                }
                if (t_conn != null) {
                    t_conn.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            SQLException sql_ex = null;
            boolean throw_ex = true;
            AQxmlDebug.traceEx(3, "AQxmlProcessor.dequeueJmsMessages 2", (Exception)((Object)jms_ex));
            if (msg != null && msg[0] != null && jms_ex.getLinkedException() != null && jms_ex.getLinkedException() instanceof SQLException && (sql_ex = (SQLException)jms_ex.getLinkedException()).getErrorCode() == 25235) {
                throw_ex = false;
            }
            if (throw_ex) {
                if (!is_multi_consumer) {
                    this.serv_ctx.removeJmsQueue(cons_opt.getDestinationOwner(), cons_opt.getDestinationName());
                } else {
                    this.serv_ctx.removeJmsTopic(cons_opt.getDestinationOwner(), cons_opt.getDestinationName());
                }
                AQxmlError.throwAQEx(406, (Exception)((Object)jms_ex));
            }
            status_resp = new AQxmlStatusResponse(0);
            receive_resp.setStatusResponse(status_resp);
        }
        return receive_resp;
    }

    AQxmlDocument dequeueAdtMessages(AQxmlClientRequest client_req, AQOracleQueue aq_queue, OracleXMLUtil util, Document doc) throws AQxmlException {
        AQxmlReceiveRequest recv_req = null;
        AQxmlConsumerOption cons_opt = null;
        AQDequeueOption deq_opt = null;
        AQxmlMessage[] xml_msg_list = null;
        AQxmlReceiveResponse receive_resp = null;
        AQxmlStatusResponse status_resp = null;
        AQxmlMessageHeader xml_msg_hdr = null;
        AQMessage message = null;
        AQMessageProperty msg_prop = null;
        AQObjectPayload adtmsg_payload = null;
        AQRawPayload rawmsg_payload = null;
        STRUCT str_data = null;
        byte[] raw_bytes = null;
        String condition = null;
        Object xml_string = null;
        int batch_size = 0;
        boolean wait_time = false;
        int i = 0;
        Element body_node = null;
        Text raw_node = null;
        AQAgent agt = null;
        AQxmlAgent xml_agt = null;
        AQjmsSignature sign = new AQjmsSignature();
        AQxmlSignature xmlsig = null;
        Object adt_node_name = null;
        Object msg_oradata = null;
        String p_data_type = null;
        XMLType xdata = null;
        String xml_str_data = null;
        AQxmlDebug.trace(4, "AQxmlProcessor.dequeueAdtMessages", "Entry");
        try {
            recv_req = (AQxmlReceiveRequest)client_req;
            if (receive_resp == null) {
                receive_resp = new AQxmlReceiveResponse(aq_queue.getCompleteName());
            }
            cons_opt = recv_req.getConsumerOption();
            deq_opt = new AQDequeueOption();
            deq_opt.setConsumerName(cons_opt.getConsumerName());
            deq_opt.setDequeueMode(cons_opt.getDequeueMode());
            deq_opt.setNavigationMode(cons_opt.getNavigationMode());
            deq_opt.setVisibility(cons_opt.getVisibility());
            deq_opt.setWaitTime(cons_opt.getWaitTime());
            deq_opt.setMessageId(cons_opt.getMessageId());
            deq_opt.setCorrelation(cons_opt.getCorrelation());
            if (cons_opt.getSignature() != null) {
                this.convertxmltojmssig(cons_opt.getSignature(), sign);
                deq_opt.setSignature(sign);
            }
            deq_opt.setTransformation(cons_opt.getTransformation());
            AQxmlDebug.trace(5, "AQxmlProcessor.dequeueAdtMessages", "Transfx:" + cons_opt.getTransformation());
            condition = cons_opt.getCondition();
            if (condition != null) {
                AQxmlDebug.trace(5, "AQxmlProcessor.dequeueAdtMessages", "Condition: " + condition);
                deq_opt.setCondition(condition);
            }
            batch_size = cons_opt.getBatchSize();
            AQxmlDebug.trace(5, "AQxmlProcessor.dequeueAdtMessages", "batch size: " + batch_size);
            xml_msg_list = new AQxmlMessage[batch_size];
            for (i = 0; i < batch_size; ++i) {
                try {
                    if (aq_queue.getPayloadType() == 2) {
                        message = aq_queue.dequeue(deq_opt);
                        rawmsg_payload = message.getRawPayload();
                        raw_bytes = rawmsg_payload.getBytes();
                        body_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "raw");
                        raw_node = doc.createTextNode(RepConversion.bArray2String((byte[])raw_bytes));
                        body_node.appendChild(raw_node);
                    } else {
                        p_data_type = aq_queue.getObjectPayloadType();
                        AQxmlDebug.trace(5, "AQxmlProcessor.dequeueAdtMessages-p_data_type", p_data_type);
                        if (p_data_type.equalsIgnoreCase("SYS.XMLTYPE")) {
                            message = aq_queue.dequeue(deq_opt, XMLType.getORADataFactory());
                            adtmsg_payload = message.getObjectPayload();
                            xdata = (XMLType)adtmsg_payload.getPayloadData();
                            AQxmlDebug.trace(5, "AQxmlProcessor.dequeueAdtMessages-xdata", xdata.toString());
                            xml_str_data = xdata.getStringVal();
                            AQxmlDebug.trace(5, "AQxmlProcessor.dequeueAdtMessages-xml_str_data: \n", xml_str_data);
                        } else {
                            message = aq_queue.dequeue(deq_opt, Class.forName("oracle.sql.STRUCT"));
                            adtmsg_payload = message.getObjectPayload();
                            str_data = (STRUCT)adtmsg_payload.getPayloadData();
                            body_node = ((XMLDocument)doc).createElementNS("http://ns.oracle.com/AQ/schemas/access", "_AQ_ADT_BODY");
                            util.getXMLFromStruct(str_data, (Node)body_node, null);
                        }
                    }
                    xml_msg_hdr = new AQxmlMessageHeader(message.getMessageId());
                    msg_prop = message.getMessageProperty();
                    xml_msg_hdr.setCorrelationID(msg_prop.getCorrelation());
                    xml_msg_hdr.setEnqueueTime(msg_prop.getEnqueueTime());
                    xml_msg_hdr.setExpiration(msg_prop.getExpiration());
                    xml_msg_hdr.setPriority(msg_prop.getPriority());
                    xml_msg_hdr.setDeliveryCount(msg_prop.getAttempts());
                    if (msg_prop.getAttempts() > 1) {
                        xml_msg_hdr.setRedelivered(true);
                    }
                    if ((agt = msg_prop.getSender()) != null) {
                        xml_agt = new AQxmlAgent(agt.getName(), agt.getAddress(), agt.getProtocol());
                    }
                    xml_msg_hdr.setSenderId(xml_agt);
                    xml_msg_hdr.setState(msg_prop.getState());
                    xml_msg_hdr.setDelay(msg_prop.getDelay());
                    xml_msg_hdr.setExceptionQueue(msg_prop.getExceptionQueue());
                    xml_msg_list[i] = p_data_type != null && p_data_type.equalsIgnoreCase("SYS.XMLTYPE") ? new AQxmlAdtMessage(xml_msg_hdr, xml_str_data) : new AQxmlAdtMessage(xml_msg_hdr, body_node);
                    if (msg_prop.getSignature() != null) {
                        xmlsig = new AQxmlSignature();
                        this.convertaqtoxmlsig(msg_prop.getSignature(), xmlsig);
                        xml_msg_list[i].setSignature(xmlsig);
                    }
                }
                catch (AQException aqex) {
                    AQxmlDebug.traceEx(3, "AQxmlProcessor.dequeueAdtMessages 1", aqex);
                    if (xml_msg_list[0] != null && (aqex.getErrorCode() == 25228 || aqex.getErrorCode() == 25235)) {
                        xml_msg_list[i] = null;
                    }
                    throw aqex;
                }
                if (xml_msg_list[i] == null) break;
                receive_resp.setMessage(xml_msg_list[i]);
            }
            status_resp = new AQxmlStatusResponse(0);
            receive_resp.setStatusResponse(status_resp);
        }
        catch (AQException aq_ex) {
            if (aq_ex.getErrorCode() != 25228 && aq_ex.getErrorCode() != 25235) {
                this.serv_ctx.removeAQQueue(aq_queue.getOwner(), aq_queue.getName());
            }
            AQxmlDebug.traceEx(3, "AQxmlProcessor.dequeueAdtMessages 1", aq_ex);
            AQxmlError.throwAQEx(436, aq_ex);
        }
        catch (ClassNotFoundException cl_ex) {
            AQxmlDebug.traceEx(3, "AQxmlProcessor.dequeueAdtMessages 2", cl_ex);
            AQxmlError.throwAQEx(402, cl_ex);
        }
        catch (SQLException sql_ex) {
            AQxmlDebug.traceEx(3, "AQxmlProcessor.dequeueAdtMessages 2", sql_ex);
            AQxmlError.throwAQEx(410, sql_ex);
        }
        return receive_resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AQxmlDocument registerOperation(AQxmlSessionContext sess_ctx, AQxmlClientRequest client_req) throws AQxmlException {
        AQxmlRegisterRequest register_req = null;
        AQxmlRegisterOption reg_opt = null;
        AQxmlRegisterResponse reg_resp = null;
        AQxmlStatusResponse status_resp = null;
        Connection db_conn = null;
        OracleCallableStatement reg_stmt = null;
        Object reg_name = null;
        AQOracleQueue aq_queue = null;
        AQSession aq_sess = null;
        AQOracleDriver aq_drv = null;
        AQxmlDebug.trace(4, "AQxmlProcessor.registerOperation", "Entry");
        register_req = (AQxmlRegisterRequest)client_req;
        if (register_req == null) {
            AQxmlError.throwAQEx(401, "register_req = null");
        }
        try {
            db_conn = sess_ctx.getCurrentDBConnection();
            aq_drv = new AQOracleDriver();
            aq_sess = aq_drv.createAQSession(db_conn);
            reg_opt = register_req.getRegisterOption();
            aq_queue = (AQOracleQueue)this.serv_ctx.getAQQueue(aq_sess, reg_opt.getDestinationOwner(), reg_opt.getDestinationName(), true);
            reg_stmt = (OracleCallableStatement)db_conn.prepareCall("begin dbms_aqin.aq$_register_in(name=>?, namespace=>?, callback=>?, context=>?); end; ");
            if (aq_queue.isMultiConsumer()) {
                if (reg_opt.getConsumerName() != null) {
                    reg_name = reg_opt.getCompleteDestName() + ":" + reg_opt.getConsumerName();
                } else {
                    AQxmlError.throwAQEx(427);
                }
            } else if (reg_opt.getConsumerName() == null) {
                reg_name = reg_opt.getCompleteDestName();
            } else {
                AQxmlError.throwAQEx(401, "singlecons-q: cons name must be null");
            }
            AQxmlDebug.println("reg_name: " + (String)reg_name);
            reg_stmt.setString(1, (String)reg_name);
            reg_stmt.setInt(2, 1);
            AQxmlDebug.println("url: " + reg_opt.getUrl());
            reg_stmt.setString(3, reg_opt.getUrl());
            reg_stmt.setNull(4, -2);
            reg_stmt.execute();
            status_resp = new AQxmlStatusResponse(0);
        }
        catch (SQLException sql_ex) {
            this.serv_ctx.removeAQQueue(aq_queue.getOwner(), aq_queue.getName());
            AQxmlDebug.traceEx(3, "AQxmlProcessor.registerOperation-sql_ex", sql_ex);
            AQxmlError.throwAQEx(410, sql_ex);
        }
        catch (AQException aq_ex) {
            this.serv_ctx.removeAQQueue(aq_queue.getOwner(), aq_queue.getName());
            AQxmlDebug.traceEx(3, "AQxmlProcessor.register_operation-aq_ex", aq_ex);
            AQxmlError.throwAQEx(436, aq_ex);
        }
        finally {
            try {
                AQxmlDebug.trace(3, "AQxmlProcessor.regoster_operation-finally", "");
                try {
                    if (reg_stmt != null) {
                        reg_stmt.close();
                    }
                }
                catch (Exception sql_ex) {}
                if (aq_queue != null) {
                    aq_queue.close();
                }
                if (aq_sess != null) {
                    aq_sess.close();
                }
            }
            catch (Exception e) {
                AQxmlDebug.trace(3, "AQxmlProcessor.regoster_operation-finally", " ");
            }
        }
        reg_resp = new AQxmlRegisterResponse();
        reg_resp.setStatusResponse(status_resp);
        return reg_resp;
    }

    AQxmlDocument getSequenceNumOperation(AQxmlSessionContext sess_ctx, AQxmlClientRequest client_req) throws AQxmlException {
        AQxmlSequenceNumRequest seq_req = null;
        AQxmlSequenceNumResponse seq_resp = null;
        AQxmlStatusResponse status_resp = null;
        Connection db_conn = null;
        Object seq_stmt = null;
        Integer qid = null;
        String dblink = null;
        int sequence_num = 0;
        OracleCallableStatement pstmt = null;
        AQxmlDebug.trace(4, "AQxmlProcessor.getSequenceNumOperation", "Entry");
        seq_req = (AQxmlSequenceNumRequest)client_req;
        if (seq_req == null) {
            AQxmlError.throwAQEx(401, "sequence_req = null");
        }
        qid = new Integer(seq_req.getQid());
        dblink = seq_req.getDatabaseLink();
        try {
            db_conn = sess_ctx.getCurrentDBConnection();
            AQxmlDebug.trace(4, "AQxmlProcessor.getSequenceNumOperation:", qid.toString());
            AQxmlDebug.trace(4, "AQxmlProcessor.getSequenceNumOperation:", dblink);
            pstmt = (OracleCallableStatement)db_conn.prepareCall("begin sys.dbms_aqjms_internal.aq$_get_prop_stat(? ,? ,? ); end;");
            pstmt.setObject(1, (Object)new Integer(qid), 4);
            pstmt.setString(2, dblink);
            pstmt.registerOutParameter(3, 4);
            pstmt.execute();
            sequence_num = pstmt.getInt(3);
            status_resp = new AQxmlStatusResponse(0);
        }
        catch (SQLException sql_ex) {
            AQxmlDebug.traceEx(3, "AQxmlProcessor.getSequenceNumOperation-sql_ex", sql_ex);
            AQxmlError.throwAQEx(410, sql_ex);
        }
        seq_resp = new AQxmlSequenceNumResponse(dblink, qid.toString(), String.valueOf(sequence_num));
        seq_resp.setStatusResponse(status_resp);
        return seq_resp;
    }

    AQxmlDocument getQueueTypeOperation(AQxmlSessionContext sess_ctx, AQxmlClientRequest client_req) throws AQxmlException {
        int i;
        AQxmlTypeInfoRequest qtyp_req = null;
        AQxmlTypeInfoResponse qtyp_resp = null;
        AQxmlStatusResponse status_resp = null;
        Connection db_conn = null;
        String queue = null;
        String schema = null;
        String name = null;
        OracleCallableStatement tistmt = null;
        int result_code = 0;
        byte[] toid = null;
        int version = 0;
        byte[] tds = null;
        boolean gettds = true;
        AQxmlDebug.trace(4, "AQxmlProcessor.getSequenceNumOperation", "Entry");
        qtyp_req = (AQxmlTypeInfoRequest)client_req;
        if (qtyp_req == null) {
            AQxmlError.throwAQEx(401, "queue_type  = null");
        }
        queue = qtyp_req.getQueue();
        for (i = 0; i < queue.length() && queue.charAt(i) != '.'; ++i) {
        }
        schema = queue.substring(0, i);
        name = queue.substring(i + 1);
        AQxmlDebug.trace(4, "AQxmlProcessor.getSequenceNumOperation", "schema.queue" + schema + "." + name);
        try {
            db_conn = sess_ctx.getCurrentDBConnection();
            tistmt = (OracleCallableStatement)db_conn.prepareCall("begin sys.dbms_aqadm.get_type_info(?, ?, true, ? , ? , ?, ? ); end; ");
            tistmt.setString(1, schema);
            tistmt.setString(2, name);
            tistmt.registerOutParameter(3, 4);
            tistmt.registerOutParameter(4, -2);
            tistmt.registerOutParameter(5, 2);
            tistmt.registerOutParameter(6, -2);
            tistmt.execute();
            result_code = tistmt.getInt(3);
            AQxmlDebug.trace(4, "AQxmlProcessor.getSequenceNumOperation", "return code " + result_code);
            if (result_code == 0) {
                toid = tistmt.getBytes(4);
                version = tistmt.getInt(5);
                tds = tistmt.getBytes(6);
            }
            AQxmlDebug.trace(4, "AQxmlProcessor.getSequenceNumOperation", "toid " + toid);
            status_resp = new AQxmlStatusResponse(0);
        }
        catch (SQLException sql_ex) {
            AQxmlDebug.traceEx(3, "AQxmlProcessor.getQueueTypeOperation-sql_ex", sql_ex);
            AQxmlError.throwAQEx(410, sql_ex);
        }
        qtyp_resp = toid == null ? new AQxmlTypeInfoResponse(queue, String.valueOf(result_code), null, "0", null) : new AQxmlTypeInfoResponse(queue, String.valueOf(result_code), RepConversion.bArray2String(toid), String.valueOf(version), RepConversion.bArray2String(tds));
        qtyp_resp.setStatusResponse(status_resp);
        return qtyp_resp;
    }

    boolean isJmsDestination(AQOracleQueue aq_queue) throws AQException {
        String ptype = null;
        if (aq_queue.getPayloadType() == 2) {
            return false;
        }
        ptype = aq_queue.getObjectPayloadType();
        return ptype.equalsIgnoreCase("SYS.AQ$_JMS_TEXT_MESSAGE") || ptype.equalsIgnoreCase("SYS.AQ$_JMS_BYTES_MESSAGE") || ptype.equalsIgnoreCase("SYS.AQ$_JMS_MAP_MESSAGE") || ptype.equalsIgnoreCase("SYS.AQ$_JMS_OBJECT_MESSAGE") || ptype.equalsIgnoreCase("SYS.AQ$_JMS_STREAM_MESSAGE");
    }

    static AQxmlDocument createExceptionResponse(AQxmlException aqxml_ex, int fault_code) {
        Object linked_ex = null;
        String error_msg = null;
        boolean error_code = false;
        AQxmlStatusResponse status_resp = null;
        Object resp = null;
        boolean com_or_rb = false;
        AQxmlFault fault = null;
        String fault_str = null;
        AQxmlDebug.trace(4, "AQxmlProcessor.createExceptionResponse", "Entry");
        try {
            status_resp = new AQxmlStatusResponse(-1);
            status_resp.setErrorCode(aqxml_ex.getErrorCode());
            error_msg = aqxml_ex.getMessage();
            error_msg = AQxmlProcessor.appendErrorMessage(error_msg, aqxml_ex);
            status_resp.setErrorMessage(error_msg);
            fault_str = fault_code == 110 ? "Client Fault" : "Server Fault";
            fault = new AQxmlFault(fault_code, fault_str, status_resp);
        }
        catch (Exception ex) {
            AQxmlDebug.traceEx(3, "AQxmlProcessor.createExceptionResponse", ex);
        }
        return fault;
    }

    static String appendErrorMessage(String error, Exception ex) {
        Exception next_ex;
        Object ret_str = null;
        ret_str = new String();
        AQxmlDebug.trace(5, "AQxmlProcessor.appendErrorMessage", "Error: " + error);
        if (ex instanceof AQxmlException) {
            next_ex = ((AQxmlException)ex).getNextException();
            AQxmlDebug.trace(5, "AQxmlProcessor.appendErrorMessage", "AQxmlException");
        } else if (ex instanceof AQException) {
            next_ex = ((AQException)ex).getNextException();
            AQxmlDebug.trace(5, "AQxmlProcessor.appendErrorMessage", "AQException");
        } else if (ex instanceof SQLException) {
            next_ex = ((SQLException)ex).getNextException();
            AQxmlDebug.trace(5, "AQxmlProcessor.appendErrorMessage", "SQLException");
        } else if (ex instanceof JMSException) {
            next_ex = ((JMSException)((Object)ex)).getLinkedException();
            AQxmlDebug.trace(5, "AQxmlProcessor.appendErrorMessage", "JMSException");
        } else if (ex instanceof XAException) {
            next_ex = null;
            AQxmlDebug.trace(5, "AQxmlProcessor.appendErrorMessage", "XAException");
        } else {
            next_ex = null;
        }
        if (next_ex != null) {
            ret_str = next_ex instanceof AQOracleSQLException ? error : error + next_ex.getMessage();
            ret_str = AQxmlProcessor.appendErrorMessage((String)ret_str, next_ex);
        } else {
            ret_str = error;
        }
        AQxmlDebug.trace(5, "AQxmlProcessor.appendErrorMessage", "Final Error Msg: " + (String)ret_str);
        return ret_str;
    }

    static void writeErrorMessagetoStream(PrintWriter writer, Exception excp, AQxmlServContext serv_ctx, AQxmlDriver aqxml_drv, int fault_code, String xsl_proc_instr) {
        XMLDocument responseDoc = null;
        Object pinstr = null;
        AQxmlDocument excpAQxmlDoc = null;
        AQxmlDebug.trace(3, "AQxmlProcessor.writeErrorMessagetoStream", "entry");
        try {
            if (excp instanceof AQxmlException) {
                excpAQxmlDoc = AQxmlProcessor.createExceptionResponse((AQxmlException)excp, fault_code);
                responseDoc = new XMLDocument();
                AQxmlProcessor.setStylesheetInResponse((Document)responseDoc, null, xsl_proc_instr);
                if (excpAQxmlDoc != null) {
                    AQxmlDocument[] retDocs = new AQxmlDocument[]{excpAQxmlDoc};
                    aqxml_drv.generateDOMDocument(retDocs, (Document)responseDoc, serv_ctx);
                    AQxmlDebug.trace(5, "AQxmlProcessor.writeErrorMessagetoStream", "print to stream");
                    responseDoc.print(writer);
                }
            } else {
                writer.println("ERROR !!!  " + excp);
                excp.printStackTrace();
            }
        }
        catch (Exception ex) {
            writer.println("ERROR !!!  " + excp);
            excp.printStackTrace();
        }
        AQxmlDebug.trace(3, "AQxmlProcessor.writeErrorMessagetoStream", "exit");
    }

    void invokeBeforeAQCallback(AQxmlCallback user_cbk, HttpServletRequest request, HttpServletResponse response, AQxmlCallbackContext ucb_ctx) {
        Connection db_conn = ucb_ctx.getDBConnection();
        boolean old_state = false;
        AQxmlDebug.trace(5, "AQxmlProcessor.invokeBeforeAQCallback", "entry");
        try {
            if (db_conn != null) {
                old_state = ((OracleConnection)db_conn).getUsingXAFlag();
                AQxmlDebug.trace(5, "AQxmlProcessor.invokeBeforeAQCallback", "old_state " + old_state);
                ((OracleConnection)db_conn).setUsingXAFlag(true);
            } else {
                AQxmlDebug.trace(5, "AQxmlProcessor.invokeBeforeAQCallback", "db_conn=null");
            }
            user_cbk.beforeAQOperation(request, response, ucb_ctx);
        }
        catch (Exception ex) {
            AQxmlDebug.traceEx(1, "AQxmlProcessor.invokeBeforeAQCallback-exception", ex);
        }
        catch (Error err) {
            AQxmlDebug.traceErr(1, "AQxmlProcessor.invokeBeforeAQCallback-error", err);
        }
        if (db_conn != null) {
            ((OracleConnection)db_conn).setUsingXAFlag(old_state);
        }
    }

    void invokeAfterAQCallback(AQxmlCallback user_cbk, HttpServletRequest request, HttpServletResponse response, AQxmlCallbackContext ucb_ctx) {
        Connection db_conn = ucb_ctx.getDBConnection();
        boolean old_state = false;
        AQxmlDebug.trace(5, "AQxmlProcessor.invokeAfterAQCallback", "entry");
        try {
            if (db_conn != null) {
                old_state = ((OracleConnection)db_conn).getUsingXAFlag();
                AQxmlDebug.trace(5, "AQxmlProcessor.invokeAfterAQCallback", "old_state " + old_state);
                ((OracleConnection)db_conn).setUsingXAFlag(true);
            } else {
                AQxmlDebug.trace(5, "AQxmlProcessor.invokeAfterAQCallback", "db_conn=null");
            }
            user_cbk.afterAQOperation(request, response, ucb_ctx);
        }
        catch (Exception ex) {
            AQxmlDebug.traceEx(1, "AQxmlProcessor.invokeAfterAQCallback-exception", ex);
        }
        catch (Error err) {
            AQxmlDebug.traceErr(1, "AQxmlProcessor.invokeAfterAQCallback-error", err);
        }
        if (db_conn != null) {
            ((OracleConnection)db_conn).setUsingXAFlag(old_state);
        }
    }

    void convertxmltojmssig(AQxmlSignature xmlsig, AQjmsSignature jmssig) throws AQxmlException {
        try {
            jmssig.setSignature(xmlsig.getSignature());
            jmssig.setCanalgo(xmlsig.getCanalgo());
            jmssig.setDigalgo(xmlsig.getDigalgo());
            jmssig.setSigalgo(xmlsig.getSigalgo());
            jmssig.setCertificate(xmlsig.getCertificate());
            jmssig.setDigval(xmlsig.getDigval());
        }
        catch (SQLException sql_ex) {
            AQxmlDebug.traceEx(3, "AQxmlProcessor.convertxmltojmssig-sql_ex", sql_ex);
            AQxmlError.throwAQEx(410, sql_ex);
        }
    }

    void convertaqtoxmlsig(AQSignature aqsig, AQxmlSignature xmlsig) throws AQxmlException {
        try {
            xmlsig.setSignature(aqsig.getSignature());
            xmlsig.setCanalgo(aqsig.getCanalgo());
            xmlsig.setDigalgo(aqsig.getDigalgo());
            xmlsig.setSigalgo(aqsig.getSigalgo());
            xmlsig.setCertificate(aqsig.getCertificate());
            xmlsig.setDigval(aqsig.getDigval());
        }
        catch (SQLException sql_ex) {
            AQxmlDebug.traceEx(3, "AQxmlProcessor.convertxmltojmssig-sql_ex", sql_ex);
            AQxmlError.throwAQEx(410, sql_ex);
        }
    }

    Object convertXmlAgent(AQxmlAgent xag, int agtype) throws AQxmlException {
        AQxmlDebug.trace(4, "AQxmlProcessor.convertXmlAgent", "entry");
        if (xag == null) {
            AQxmlError.throwAQEx(401, "Internal Error: agent to be converted is null");
        }
        if (xag.aliasUnresolved()) {
            String ag_alias = xag.getAlias();
            DirContext ldapCtx = this.serv_ctx == null ? null : this.serv_ctx.getLdapContext();
            AQxmlDebug.trace(4, "AQxmlProcessor.convertXmlAgent", "resolve agent alias");
            if (ag_alias == null || ldapCtx == null) {
                AQxmlError.throwAQEx(438);
            }
            try {
                int idx2;
                String cn;
                int idx;
                String agt_cn = null;
                String agt_pro = null;
                SearchControls ctls = new SearchControls();
                ctls.setSearchScope(0);
                NamingEnumeration<SearchResult> results = ldapCtx.search("cn=" + ag_alias, "(objectclass=*)", ctls);
                if (results == null) {
                    AQxmlDebug.trace(3, "AQxmlConverter.lookupAgentAlias", "cannot find the alias in LDAP");
                    AQxmlError.throwAQEx(438);
                }
                SearchResult si = results.next();
                Attributes attrs = si.getAttributes();
                String obj_typ = (String)attrs.get("orclDBAQObjType").get();
                while (obj_typ.toLowerCase().equals("alias")) {
                    String obj_dn = (String)attrs.get("orclDBAQPointerAttr").get();
                    InitialDirContext ctx = new InitialDirContext(ldapCtx.getEnvironment());
                    results = ctx.search(obj_dn, "(objectclass=*)", ctls);
                    if (results == null) {
                        AQxmlDebug.trace(3, "AQxmlConverter.lookupAgentAlias", "failed to search object " + obj_dn);
                        AQxmlError.throwAQEx(438);
                    }
                    si = results.next();
                    attrs = si.getAttributes();
                    obj_typ = (String)attrs.get("orclDBAQObjType").get();
                }
                if (obj_typ.toLowerCase().equals("agent") || obj_typ.toLowerCase().equals("aq_subscriber")) {
                    agt_cn = (String)attrs.get("cn").get();
                }
                if (obj_typ.toLowerCase().equals("jms_subscriber") && (idx = (cn = (String)attrs.get("cn").get()).indexOf(46)) != -1) {
                    agt_cn = cn.substring(idx + 1);
                }
                AQxmlDebug.trace(4, "AQxmlProcessor.convertXmlAgent", "agent cn is" + agt_cn);
                int idx1 = agt_cn.indexOf(58);
                int n = idx2 = idx1 == -1 ? -1 : agt_cn.indexOf(58, idx1 + 1);
                if (idx1 <= 0 || idx2 - idx1 <= 1 || idx2 >= agt_cn.length() - 1) {
                    AQxmlError.throwAQEx(438);
                }
                xag.setName(agt_cn.substring(0, idx1));
                xag.setAddress(agt_cn.substring(idx1 + 1, idx2));
                agt_pro = agt_cn.substring(idx2 + 1, agt_cn.length());
                xag.setProtocol(Integer.valueOf(agt_pro));
                xag.setAliasUnresolved(false);
            }
            catch (NamingException ex) {
                AQxmlDebug.traceEx(3, "AQxmlProcessor.convertXmlAgent", ex);
                AQxmlError.throwAQEx(447, ex);
            }
        }
        try {
            if (agtype == 2) {
                return xag;
            }
            if (agtype == 1) {
                return new AQjmsAgent(xag.getName(), xag.getAddress(), xag.getProtocol());
            }
            if (agtype == 3) {
                return new AQAgent(xag.getName(), xag.getAddress(), xag.getProtocol());
            }
            AQxmlError.throwAQEx(401, "Internal Error: Invalid agent type " + agtype);
        }
        catch (SQLException sql_ex) {
            AQxmlDebug.traceEx(3, "AQxmlProcessor.convertXmlAgent-sql_ex", sql_ex);
            AQxmlError.throwAQEx(410, sql_ex);
        }
        return null;
    }

    String[] resolveDestination(String dest_alias) throws AQxmlException {
        String destown = null;
        String destnam = null;
        AQxmlDebug.trace(4, "AQxmlProcessor.resolveDestination", "entry");
        try {
            NamingEnumeration<SearchResult> results;
            DirContext ldapCtx = this.serv_ctx == null ? null : this.serv_ctx.getLdapContext();
            SearchControls ctls = new SearchControls();
            ctls.setSearchScope(0);
            if (ldapCtx == null || dest_alias == null) {
                AQxmlError.throwAQEx(437);
            }
            if ((results = ldapCtx.search("cn=" + dest_alias, "(objectclass=*)", ctls)) == null) {
                AQxmlDebug.trace(3, "AQxmlProcessor.resolveDestination", "cannot find the alias in LDAP");
                AQxmlError.throwAQEx(437);
            }
            SearchResult si = results.next();
            Attributes attrs = si.getAttributes();
            String obj_typ = (String)attrs.get("orclDBAQObjType").get();
            while (obj_typ.toLowerCase().equals("alias")) {
                String obj_dn = (String)attrs.get("orclDBAQPointerAttr").get();
                InitialDirContext ctx = new InitialDirContext(ldapCtx.getEnvironment());
                results = ctx.search(obj_dn, "(objectclass=*)", ctls);
                if (results == null) {
                    AQxmlDebug.trace(3, "AQxmlProcessor.resolveDestination", "failed to search object " + obj_dn);
                    AQxmlError.throwAQEx(437);
                }
                si = results.next();
                attrs = si.getAttributes();
                obj_typ = (String)attrs.get("orclDBAQObjType").get();
            }
            if (obj_typ.toLowerCase().equals("queue")) {
                destown = (String)attrs.get("orclDBAQObjOwner").get();
                destnam = (String)attrs.get("orclDBAQObjName").get();
            }
        }
        catch (NamingException ex) {
            AQxmlDebug.traceEx(3, "AQxmlProcessor.resolveDestination", ex);
            AQxmlError.throwAQEx(447, ex);
        }
        AQxmlDebug.trace(4, "AQxmlProcessor.resolveDestination", "dest owner:" + destown + " dest name:" + destnam);
        if (destown != null && destnam != null) {
            String[] deststr = new String[]{destown, destnam};
            return deststr;
        }
        AQxmlError.throwAQEx(401, "destination lookup");
        return null;
    }

    void resolveLdapQAlias(AQxmlDocument xml_doc) throws AQxmlException {
        AQxmlProducerOption prod_opt = null;
        AQxmlConsumerOption cons_opt = null;
        AQxmlRegisterOption reg_opt = null;
        String[] dests = null;
        AQxmlDebug.trace(4, "AQxmlProcessor.resolveLdapQAlias", "entry");
        if (xml_doc instanceof AQxmlSendRequest || xml_doc instanceof AQxmlPublishRequest || xml_doc instanceof AQxmlPushRequest) {
            prod_opt = ((AQxmlEnqueueRequest)xml_doc).getProducerOption();
            if (prod_opt.aliasUnresolved()) {
                dests = this.resolveDestination(prod_opt.getDestinationAlias());
                prod_opt.setDestinationOwner(dests[0]);
                prod_opt.setDestinationName(dests[1]);
                prod_opt.setAliasUnresolved(false);
            }
        } else if (xml_doc instanceof AQxmlReceiveRequest) {
            cons_opt = ((AQxmlReceiveRequest)xml_doc).getConsumerOption();
            if (cons_opt.aliasUnresolved()) {
                dests = this.resolveDestination(cons_opt.getDestinationAlias());
                cons_opt.setDestinationOwner(dests[0]);
                cons_opt.setDestinationName(dests[1]);
                cons_opt.setAliasUnresolved(false);
            }
        } else if (xml_doc instanceof AQxmlRegisterRequest && (reg_opt = ((AQxmlRegisterRequest)xml_doc).getRegisterOption()).aliasUnresolved()) {
            dests = this.resolveDestination(reg_opt.getDestinationAlias());
            reg_opt.setDestinationOwner(dests[0]);
            reg_opt.setDestinationName(dests[1]);
            reg_opt.setAliasUnresolved(false);
        }
        AQxmlDebug.trace(4, "AQxmlProcessor.resolveLdapQAlias", "exit");
    }

    static void setStylesheetInResponse(Document resp_doc, AQxmlCallbackContext user_cbk_ctx, String servlet_proc_instr) {
        String proc_instr = null;
        ProcessingInstruction pinstr = null;
        try {
            if (user_cbk_ctx != null) {
                proc_instr = user_cbk_ctx.getStyleSheetProcessingInstr();
            } else if (servlet_proc_instr != null) {
                proc_instr = servlet_proc_instr;
            }
            if (proc_instr != null) {
                pinstr = resp_doc.createProcessingInstruction("xml-stylesheet", proc_instr);
                resp_doc.appendChild(pinstr);
            }
        }
        catch (Exception ex) {
            AQxmlDebug.traceEx(1, "AQxmlProcessor.setStylesheetInResponse-exception: ", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updPropStatus(Connection db_conn, int source_qid, String src_dbnm, int batch_num) throws AQxmlException {
        OracleCallableStatement update_stmt = null;
        AQxmlDebug.trace(3, "AQxmlProcessor.updPropStatus", "Enter");
        AQxmlDebug.trace(5, "AQxmlProcessor.updPropStatus", "src_Qid: " + source_qid + "  src_Dbnm" + src_dbnm + "batch_num: " + batch_num);
        try {
            if (batch_num != 0) {
                update_stmt = (OracleCallableStatement)db_conn.prepareCall("begin dbms_aqjms_internal.aq$_update_prop_stat(qid=>?, db_link=>?, sequence_number=>?, status_code=>?); end; ");
                update_stmt.setObject(1, (Object)new Integer(source_qid), 4);
                update_stmt.setString(2, src_dbnm);
                update_stmt.setObject(3, (Object)new Integer(batch_num), 4);
                update_stmt.setObject(4, (Object)new Integer(2), 4);
                update_stmt.execute();
                AQxmlDebug.trace(3, "AQxmlProcessor.updPropStatus", "Exit");
            }
        }
        catch (SQLException sql_ex) {
            AQxmlDebug.traceEx(3, "AQxmlProcessor.pushMessages-sql_ex", sql_ex);
            AQxmlError.throwAQEx(410, sql_ex);
        }
        finally {
            try {
                if (update_stmt != null) {
                    update_stmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

