/*
 * Decompiled with CFR 0.152.
 */
package oracle.jakarta.jms;

import jakarta.jms.JMSException;
import java.sql.SQLException;
import javax.transaction.xa.XAException;
import oracle.jakarta.AQ.AQException;
import oracle.sql.json.OracleJsonException;

public class AQjmsException
extends JMSException {
    AQjmsException(String message, int ora_error_code) {
        super(message, Integer.toString(ora_error_code));
    }

    AQjmsException(String message, Throwable linked_ex) {
        super(message);
        if (linked_ex instanceof Exception) {
            this.setLinkedException((Exception)linked_ex);
        }
        this.initCause(linked_ex);
    }

    AQjmsException(String message, int ora_error_code, Throwable linked_ex) {
        super(message, Integer.toString(ora_error_code));
        if (linked_ex instanceof Exception) {
            this.setLinkedException((Exception)linked_ex);
        }
        this.initCause(linked_ex);
    }

    AQjmsException(SQLException linked_ex) {
        super(linked_ex.getMessage(), Integer.toString(linked_ex.getErrorCode()));
        this.setLinkedException(linked_ex);
        this.initCause(linked_ex);
    }

    AQjmsException(AQException aq_ex) {
        super(aq_ex.getMessage(), Integer.toString(aq_ex.getErrorCode()));
        this.setLinkedException(aq_ex.getNextException());
        this.initCause(aq_ex);
    }

    AQjmsException(XAException xa_ex) {
        super(xa_ex.getMessage(), Integer.toString(xa_ex.errorCode));
        this.setLinkedException(xa_ex);
        this.initCause(xa_ex);
    }

    AQjmsException(OracleJsonException json_ex) {
        super(json_ex.getMessage());
        this.setLinkedException((Exception)json_ex);
        this.initCause((Throwable)json_ex);
    }

    public int getErrorNumber() {
        try {
            return Integer.parseInt(this.getErrorCode());
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
    }
}

