/*
 * Decompiled with CFR 0.152.
 */
package oracle.jakarta.jms;

import jakarta.jms.JMSException;
import jakarta.jms.TextMessage;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import oracle.jakarta.jms.AQjmsDestination;
import oracle.jakarta.jms.AQjmsError;
import oracle.jakarta.jms.AQjmsException;
import oracle.jakarta.jms.AQjmsGenMessage_C;
import oracle.jakarta.jms.AQjmsMessage;
import oracle.jakarta.jms.AQjmsOracleDebug;
import oracle.jakarta.jms.AQjmsSession;
import oracle.jakarta.jms.AQjmsTextMessage_C;
import oracle.jakarta.jms.AQjmsUtil;
import oracle.jdbc.OracleData;

public class AQjmsTextMessage
extends AQjmsMessage
implements TextMessage {
    String m_textData = null;

    public AQjmsTextMessage() {
        super(true);
        this.access_mode = 2;
    }

    AQjmsTextMessage(AQjmsSession session, String payload) {
        super(session, true);
        this.m_textData = payload;
        this.access_mode = 2;
    }

    AQjmsTextMessage(AQjmsSession session) {
        super(session, true);
        this.access_mode = 2;
    }

    AQjmsTextMessage(AQjmsMessage headerMsg) throws JMSException {
        super(headerMsg);
    }

    AQjmsTextMessage(AQjmsSession session, AQjmsTextMessage_C msgCont) throws JMSException {
        super(session, true);
        try {
            this.header_ext = msgCont.getHeader();
            this.readTextMessageContainer(msgCont);
        }
        catch (SQLException sql_ex) {
            throw new AQjmsException(sql_ex);
        }
        this.access_mode = 0;
    }

    AQjmsTextMessage(AQjmsSession session, AQjmsGenMessage_C msgCont) throws JMSException {
        super(session, true);
        try {
            this.header_ext = msgCont.getHeader();
            this.readGenMessageContainer(msgCont);
        }
        catch (SQLException sql_ex) {
            throw new AQjmsException(sql_ex);
        }
        this.access_mode = 0;
    }

    public void setText(String string) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.m_textData = string;
    }

    public String getText() throws JMSException {
        return this.m_textData;
    }

    @Override
    public void clearBody() throws JMSException {
        this.m_textData = null;
        this.setAccessMode(2);
    }

    @Override
    OracleData getMessageCont(AQjmsSession sess, boolean useTemporaryLob, boolean isBulkEnqueue) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsTextMessage.getMessageCont", "entry");
        AQjmsTextMessage_C cont = new AQjmsTextMessage_C();
        boolean[] writeLobFlag = new boolean[1];
        this.m_tempLob = AQjmsUtil.populateTextContainer(cont, this.header_ext, this.m_textData, sess, useTemporaryLob, writeLobFlag, isBulkEnqueue);
        this.setWriteLobLater(writeLobFlag[0]);
        AQjmsOracleDebug.trace(4, "AQjmsTextMessage.getMessageCont", "exit");
        return cont;
    }

    @Override
    AQjmsGenMessage_C getGenMessageCont(AQjmsSession sess, boolean useTemporaryLob, boolean isBulkEnqueue) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsTextMessage.getGenMessageCont", "entry");
        AQjmsGenMessage_C cont = new AQjmsGenMessage_C();
        boolean[] writeLobFlag = new boolean[1];
        this.m_tempLob = AQjmsUtil.populateTextContainer(cont, this.header_ext, this.m_textData, sess, useTemporaryLob, writeLobFlag, isBulkEnqueue);
        this.setWriteLobLater(writeLobFlag[0]);
        AQjmsOracleDebug.trace(4, "AQjmsTextMessage.getGenMessageCont", "exit");
        return cont;
    }

    @Override
    void writeLob(AQjmsSession sess, AQjmsDestination dest, byte[] msgid, boolean isAnydataDest) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsTextmessage.writeLob", "entry");
        if (this.m_writeLobLater) {
            AQjmsUtil.writeClob(this.m_textData, sess, dest, msgid, isAnydataDest);
        }
        AQjmsOracleDebug.trace(4, "AQjmsTexttmessage.writeLob", "exit");
    }

    private void readTextMessageContainer(AQjmsTextMessage_C msgCont) throws JMSException {
        try {
            this.m_textData = AQjmsUtil.getTextData(msgCont.getTextLen(), msgCont.getTextLob(), msgCont.getTextVc());
        }
        catch (SQLException sqe) {
            throw new AQjmsException(sqe);
        }
    }

    private void readGenMessageContainer(AQjmsGenMessage_C msgCont) throws JMSException {
        try {
            this.m_textData = AQjmsUtil.getTextData(msgCont.getTextLen(), msgCont.getTextLob(), msgCont.getTextVc());
        }
        catch (SQLException sqe) {
            throw new AQjmsException(sqe);
        }
    }

    @Override
    byte[] getBytesCont() throws JMSException {
        byte[] bytes = null;
        if (this.m_textData != null) {
            try {
                bytes = this.m_textData.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException ue) {
                throw new AQjmsException(ue.getMessage(), ue);
            }
        }
        return bytes;
    }
}

