/*
 * Decompiled with CFR 0.152.
 */
package oracle.jakarta.jms;

import jakarta.jms.JMSException;
import jakarta.jms.QueueSession;
import jakarta.jms.Session;
import jakarta.jms.TopicSession;
import jakarta.jms.XAQueueSession;
import jakarta.jms.XASession;
import jakarta.jms.XATopicSession;
import java.sql.SQLException;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import oracle.jakarta.jms.AQjmsEmulatedXAResource;
import oracle.jakarta.jms.AQjmsError;
import oracle.jakarta.jms.AQjmsException;
import oracle.jakarta.jms.AQjmsGeneralDBConnection;
import oracle.jakarta.jms.AQjmsSession;
import oracle.jakarta.jms.AQjmsXAConnection;
import oracle.jakarta.jms.AQjmsXAResource;
import oracle.jakarta.jms.AQjmsXAResourceFactory;
import oracle.jakarta.jms.WebLogicHelper;

public class AQjmsXASession
extends AQjmsSession
implements XASession,
XAQueueSession,
XATopicSession {
    private XAResource m_jmsXAResource;

    AQjmsXASession(AQjmsXAConnection jms_conn, int type, AQjmsGeneralDBConnection genConn, AQjmsXAResourceFactory xaresFactory) throws JMSException {
        super(jms_conn, 0, true, type, genConn);
        XAConnection xaConn = genConn.getXAConnection();
        try {
            if (xaConn == null) {
                if (xaresFactory == null) {
                    this.m_jmsXAResource = WebLogicHelper.createIgnoredXAResource();
                    if (this.m_jmsXAResource == null) {
                        this.m_jmsXAResource = new AQjmsEmulatedXAResource((Session)this);
                    }
                } else {
                    this.m_jmsXAResource = xaresFactory.createXAResource(this);
                }
            } else {
                this.m_jmsXAResource = new AQjmsXAResource(this, xaConn.getXAResource());
            }
        }
        catch (SQLException sqle) {
            throw new AQjmsException(sqle);
        }
        catch (XAException xe) {
            throw new AQjmsException(xe);
        }
    }

    @Override
    protected synchronized void preClose() throws JMSException {
    }

    public Session getSession() throws JMSException {
        return this;
    }

    public QueueSession getQueueSession() throws JMSException {
        if (this.sess_type != 10) {
            AQjmsError.throwEx(107, this.sess_type == 20 ? "XATopicSession" : "XASession");
        }
        return this;
    }

    public TopicSession getTopicSession() throws JMSException {
        if (this.sess_type != 20) {
            AQjmsError.throwEx(107, this.sess_type == 10 ? "XAQueueSession" : "XASession");
        }
        return this;
    }

    @Override
    public synchronized void commit() throws JMSException {
        AQjmsError.throwTranInProgressEx(239, "commit");
    }

    @Override
    public synchronized void rollback() throws JMSException {
        AQjmsError.throwTranInProgressEx(239, "rollback");
    }

    public XAResource getXAResource() {
        return this.m_jmsXAResource;
    }
}

