/*
 * Decompiled with CFR 0.152.
 */
package oracle.jakarta.jms;

import jakarta.jms.BytesMessage;
import jakarta.jms.CompletionListener;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.JMSProducer;
import jakarta.jms.JMSRuntimeException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageFormatException;
import jakarta.jms.MessageFormatRuntimeException;
import jakarta.jms.MessageProducer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import oracle.jakarta.jms.AQjmsAgent;
import oracle.jakarta.jms.AQjmsDestination;
import oracle.jakarta.jms.AQjmsError;
import oracle.jakarta.jms.AQjmsException;
import oracle.jakarta.jms.AQjmsJMSContext;
import oracle.jakarta.jms.AQjmsMessageFormatException;
import oracle.jakarta.jms.AQjmsOracleDebug;
import oracle.jakarta.jms.AQjmsProducer;
import oracle.jakarta.jms.AQjmsProducerProperties;
import oracle.jakarta.jms.AQjmsUtil;

public class AQjmsJMSProducer
implements JMSProducer {
    private static final String JMS_REPLY_TO = "JMSReplyTo";
    Session session;
    MessageProducer producer;
    AQjmsJMSContext jmsContext;
    String correlationID;
    byte[] correlationIDBytes;
    String type;
    Destination replyTo;
    private long deliveryDelay = 0L;
    private int deliveryMode = 2;
    private int priority = 4;
    private long timeToLive = 0L;
    private boolean disableMessageId;
    private boolean disableTimestamp;
    CompletionListener completionListener;
    AQjmsProducerProperties properties = null;

    AQjmsJMSProducer(Session session, MessageProducer producer, AQjmsJMSContext jmsContext) {
        AQjmsOracleDebug.trace(5, "AQjmsJMSProducer", "constructor");
        this.session = session;
        this.producer = producer;
        this.jmsContext = jmsContext;
    }

    public JMSProducer clearProperties() {
        try {
            if (this.properties != null) {
                this.properties.clearPropertiesHashtable();
            }
            return this;
        }
        catch (JMSRuntimeException e) {
            AQjmsOracleDebug.traceEx(3, "AQjmsJMSProducer.clearProperties", e);
            throw e;
        }
    }

    public CompletionListener getAsync() {
        return this.completionListener;
    }

    Hashtable<String, Object> getPropertiesTable() {
        if (this.properties != null) {
            return this.properties.getPropertiesHashtable();
        }
        return null;
    }

    public boolean getBooleanProperty(String name) {
        try {
            if (this.properties != null) {
                return this.properties.getBooleanProperty(name);
            }
            return false;
        }
        catch (AQjmsMessageFormatException e) {
            throw new MessageFormatRuntimeException(e.getErrorCode());
        }
        catch (JMSException e) {
            throw AQjmsUtil.convertToRuntimeException(e);
        }
    }

    public byte getByteProperty(String name) {
        try {
            if (this.properties != null) {
                return this.properties.getByteProperty(name);
            }
            return 0;
        }
        catch (AQjmsMessageFormatException e) {
            throw new MessageFormatRuntimeException(e.getErrorCode());
        }
        catch (JMSException e) {
            throw AQjmsUtil.convertToRuntimeException(e);
        }
    }

    public long getDeliveryDelay() {
        try {
            return this.deliveryDelay;
        }
        catch (RuntimeException e) {
            JMSRuntimeException je = new JMSRuntimeException(e.getMessage());
            je.initCause((Throwable)e);
            throw je;
        }
    }

    public int getDeliveryMode() {
        try {
            return this.deliveryMode;
        }
        catch (RuntimeException e) {
            JMSRuntimeException je = new JMSRuntimeException(e.getMessage());
            je.initCause((Throwable)e);
            throw je;
        }
    }

    public boolean getDisableMessageID() {
        return this.disableMessageId;
    }

    public boolean getDisableMessageTimestamp() {
        return this.disableTimestamp;
    }

    public double getDoubleProperty(String name) {
        try {
            if (this.properties != null) {
                return this.properties.getDoubleProperty(name);
            }
            return 0.0;
        }
        catch (JMSException e) {
            throw AQjmsUtil.convertToRuntimeException(e);
        }
    }

    public float getFloatProperty(String name) {
        try {
            if (this.properties != null) {
                return this.properties.getFloatProperty(name);
            }
            return 0.0f;
        }
        catch (JMSException e) {
            throw AQjmsUtil.convertToRuntimeException(e);
        }
    }

    public int getIntProperty(String name) {
        try {
            if (this.properties != null) {
                return this.properties.getIntProperty(name);
            }
            return 0;
        }
        catch (JMSException e) {
            throw AQjmsUtil.convertToRuntimeException(e);
        }
    }

    public String getJMSCorrelationID() {
        return this.correlationID;
    }

    public byte[] getJMSCorrelationIDAsBytes() {
        return this.correlationIDBytes;
    }

    public Destination getJMSReplyTo() {
        Destination ret = null;
        try {
            ret = this.replyTo;
            if (ret != null) {
                String n = ((AQjmsAgent)ret).getName();
                if (n != null && n.equalsIgnoreCase(JMS_REPLY_TO)) {
                    return ret;
                }
                if (ret instanceof AQjmsAgent) {
                    String a = ((AQjmsAgent)ret).getAddress();
                    if ((n == null || n.equals("") || n.equals(" ")) && (a == null || a.equals(""))) {
                        ret = null;
                    }
                }
            }
        }
        catch (SQLException sql_ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsJMSProducer.getReplyTo", sql_ex);
            throw new JMSRuntimeException("Exception in AQjmsJMSProducer.getJMSReplyTo()", sql_ex.toString(), (Throwable)sql_ex);
        }
        return ret;
    }

    public String getJMSType() {
        return this.type;
    }

    public long getLongProperty(String name) {
        try {
            if (this.properties != null) {
                return this.properties.getLongProperty(name);
            }
            return 0L;
        }
        catch (JMSException e) {
            throw AQjmsUtil.convertToRuntimeException(e);
        }
    }

    public Object getObjectProperty(String name) {
        try {
            if (this.properties != null) {
                return this.properties.getObjectProperty(name);
            }
            return 0;
        }
        catch (JMSException e) {
            throw AQjmsUtil.convertToRuntimeException(e);
        }
    }

    public int getPriority() {
        return this.priority;
    }

    public Set<String> getPropertyNames() {
        if (this.properties != null) {
            return new HashSet<String>(this.properties.getPropertiesHashtable().keySet());
        }
        return null;
    }

    public short getShortProperty(String name) {
        try {
            if (this.properties != null) {
                return this.properties.getShortProperty(name);
            }
            return 0;
        }
        catch (JMSException e) {
            throw AQjmsUtil.convertToRuntimeException(e);
        }
    }

    public String getStringProperty(String name) {
        try {
            if (this.properties != null) {
                return this.properties.getStringProperty(name);
            }
            return null;
        }
        catch (JMSException e) {
            throw AQjmsUtil.convertToRuntimeException(e);
        }
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public boolean propertyExists(String name) {
        try {
            if (this.properties != null) {
                return this.properties.propertyExists(name);
            }
            return false;
        }
        catch (JMSException e) {
            AQjmsOracleDebug.traceEx(3, "AQjmsJMSProducer.propertyExists", e);
            return false;
        }
    }

    public JMSProducer send(Destination destination, Message message) {
        AQjmsOracleDebug.trace(5, "AQjmsJMSProducer.send(Destination, Message)", "entry");
        try {
            this.doSend(destination, message);
        }
        catch (JMSException e) {
            throw AQjmsUtil.convertToRuntimeException(e);
        }
        AQjmsOracleDebug.trace(5, "AQjmsJMSProducer.send(Destination, Message)", "exit");
        return this;
    }

    public JMSProducer send(Destination destination, String strMessage) {
        AQjmsOracleDebug.trace(5, "AQjmsJMSProducer.send(Destination, String)", "entry");
        try {
            TextMessage message = this.session.createTextMessage(strMessage);
            this.doSend(destination, (Message)message);
        }
        catch (JMSException e) {
            throw AQjmsUtil.convertToRuntimeException(e);
        }
        AQjmsOracleDebug.trace(5, "AQjmsJMSProducer.send(Destination, String)", "exit");
        return this;
    }

    public JMSProducer send(Destination destination, Map<String, Object> mapMessage) {
        AQjmsOracleDebug.trace(5, "AQjmsJMSProducer.send(Destination, Map<Key, Val>)", "entry");
        try {
            MapMessage message = this.session.createMapMessage();
            if (mapMessage != null) {
                for (Map.Entry<String, Object> entry : mapMessage.entrySet()) {
                    message.setObject(entry.getKey(), entry.getValue());
                }
            }
            this.doSend(destination, (Message)message);
        }
        catch (JMSException e) {
            throw AQjmsUtil.convertToRuntimeException(e);
        }
        AQjmsOracleDebug.trace(5, "AQjmsJMSProducer.send(Destination, Map<Key, Val>)", "exit");
        return this;
    }

    public JMSProducer send(Destination destination, byte[] byteMessage) {
        AQjmsOracleDebug.trace(5, "AQjmsJMSProducer.send(Destination, byte[])", "entry");
        try {
            BytesMessage message = this.session.createBytesMessage();
            if (byteMessage != null) {
                message.writeBytes(byteMessage);
            }
            this.doSend(destination, (Message)message);
        }
        catch (JMSException e) {
            throw AQjmsUtil.convertToRuntimeException(e);
        }
        AQjmsOracleDebug.trace(5, "AQjmsJMSProducer.send(Destination, byte[])", "exit");
        return this;
    }

    public JMSProducer send(Destination destination, Serializable message) {
        AQjmsOracleDebug.trace(5, "AQjmsJMSProducer.send(Destination, Serializable)", "entry");
        try {
            ObjectMessage objectMessage = this.session.createObjectMessage();
            objectMessage.setObject(message);
            this.doSend(destination, (Message)objectMessage);
        }
        catch (JMSException e) {
            throw AQjmsUtil.convertToRuntimeException(e);
        }
        AQjmsOracleDebug.trace(5, "AQjmsJMSProducer.send(Destination, Serializable)", "exit");
        return this;
    }

    private void doSend(Destination destination, Message message) throws JMSException {
        if (message == null) {
            throw new MessageFormatException("Message must not be null");
        }
        if (this.getPropertiesTable() != null) {
            for (Map.Entry<String, Object> entry : this.getPropertiesTable().entrySet()) {
                message.setObjectProperty(entry.getKey(), this.getObjectProperty(entry.getKey()));
            }
        }
        if (this.correlationID != null) {
            message.setJMSCorrelationID(this.correlationID);
        }
        if (this.correlationIDBytes != null) {
            message.setJMSCorrelationIDAsBytes(this.correlationIDBytes);
        }
        if (this.type != null) {
            message.setJMSType(this.type);
        }
        if (this.replyTo != null) {
            message.setJMSReplyTo(this.replyTo);
        }
        if (this.getAsync() == null) {
            ((AQjmsProducer)this.producer).send(destination, message);
        } else {
            ((AQjmsProducer)this.producer).send(destination, message, this.completionListener);
        }
    }

    public JMSProducer setAsync(CompletionListener completionListener) {
        this.completionListener = completionListener;
        return this;
    }

    public JMSProducer setDeliveryDelay(long deliveryDelay) {
        this.deliveryDelay = deliveryDelay;
        try {
            ((AQjmsProducer)this.producer).setDeliveryDelay(deliveryDelay);
        }
        catch (JMSException e) {
            throw AQjmsUtil.convertToRuntimeException(e);
        }
        return this;
    }

    public JMSProducer setDeliveryMode(int deliveryMode) {
        this.deliveryMode = deliveryMode;
        return this;
    }

    public JMSProducer setDisableMessageID(boolean disableMessageId) {
        this.disableMessageId = disableMessageId;
        try {
            ((AQjmsProducer)this.producer).setDisableMessageID(disableMessageId);
        }
        catch (JMSException e) {
            throw AQjmsUtil.convertToRuntimeException(e);
        }
        return this;
    }

    public JMSProducer setDisableMessageTimestamp(boolean disableTimestamp) {
        this.disableTimestamp = disableTimestamp;
        try {
            ((AQjmsProducer)this.producer).setDisableMessageTimestamp(disableTimestamp);
        }
        catch (JMSException e) {
            throw AQjmsUtil.convertToRuntimeException(e);
        }
        return this;
    }

    public JMSProducer setJMSCorrelationID(String correlationID) {
        this.correlationID = correlationID;
        return this;
    }

    public JMSProducer setJMSCorrelationIDAsBytes(byte[] correlationIDBytes) {
        this.correlationIDBytes = correlationIDBytes;
        return this;
    }

    public JMSProducer setJMSReplyTo(Destination replyTo) {
        try {
            return this.setJMSReplyTo2(replyTo);
        }
        catch (JMSException e) {
            throw AQjmsUtil.convertToRuntimeException(e);
        }
    }

    JMSProducer setJMSReplyTo2(Destination replyTo) throws JMSException {
        try {
            if (replyTo instanceof AQjmsAgent) {
                String n = ((AQjmsAgent)replyTo).getName();
                if (n != null && n.equalsIgnoreCase(JMS_REPLY_TO)) {
                    AQjmsError.throwEx(147);
                }
                this.replyTo = replyTo;
            } else if (replyTo instanceof AQjmsDestination) {
                this.replyTo = replyTo;
            } else if (replyTo == null) {
                this.replyTo = new AQjmsAgent(JMS_REPLY_TO, null);
            } else {
                AQjmsError.throwEx(147);
            }
        }
        catch (SQLException sql_ex) {
            throw new AQjmsException(sql_ex);
        }
        return this;
    }

    public JMSProducer setJMSType(String type) {
        this.type = type;
        return this;
    }

    public JMSProducer setPriority(int priority) {
        this.priority = priority;
        return this;
    }

    public JMSProducer setProperty(String name, boolean value) {
        this.setObjectProperty(name, value);
        return this;
    }

    public JMSProducer setProperty(String name, byte value) {
        this.setObjectProperty(name, value);
        return this;
    }

    public JMSProducer setProperty(String name, short value) {
        this.setObjectProperty(name, value);
        return this;
    }

    public JMSProducer setProperty(String name, int value) {
        this.setObjectProperty(name, value);
        return this;
    }

    public JMSProducer setProperty(String name, long value) {
        this.setObjectProperty(name, value);
        return this;
    }

    public JMSProducer setProperty(String name, float value) {
        this.setObjectProperty(name, Float.valueOf(value));
        return this;
    }

    public JMSProducer setProperty(String name, double value) {
        this.setObjectProperty(name, value);
        return this;
    }

    public JMSProducer setProperty(String name, String value) {
        this.setObjectProperty(name, value);
        return this;
    }

    public JMSProducer setProperty(String name, Object value) {
        this.setObjectProperty(name, value);
        return this;
    }

    public JMSProducer setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
        try {
            ((AQjmsProducer)this.producer).setTimeToLive(timeToLive);
        }
        catch (JMSException e) {
            throw AQjmsUtil.convertToRuntimeException(e);
        }
        return this;
    }

    JMSProducer setObjectProperty(String name, Object value) {
        if (this.properties == null) {
            this.properties = new AQjmsProducerProperties();
        }
        try {
            this.properties.setObjectProperty(name, value);
        }
        catch (JMSException e) {
            AQjmsOracleDebug.traceEx(3, "AQjmsJMSProducer.setObjectProperty", e);
        }
        return this;
    }
}

