/*
 * Decompiled with CFR 0.152.
 */
package oracle.jakarta.jms;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import oracle.jakarta.jms.AQjmsOracleDebug;

public class AQjmsObjectInputStream
extends ObjectInputStream {
    private ClassLoader classLoader;

    public AQjmsObjectInputStream(InputStream in, ClassLoader classLoader) throws IOException {
        super(in);
        this.classLoader = classLoader;
    }

    public Class resolveClass(ObjectStreamClass type) throws IOException, ClassNotFoundException {
        Class<?> clz = null;
        AQjmsOracleDebug.trace(4, "AQjmsObjectInputStream.resolveClass", "trying to resolve class " + type.getName());
        try {
            AQjmsOracleDebug.trace(4, "AQjmsObjectInputStream.resolveClass", "resolve using Class.forName(String, boolean,ClassLoader) method");
            clz = Class.forName(type.getName(), true, this.getClassLoader());
        }
        catch (ClassNotFoundException cnfexc) {
            AQjmsOracleDebug.trace(4, "AQjmsObjectInputStream.resolveClass", "Class.forName(String, boolean,ClassLoader) fail to find class");
        }
        if (clz == null) {
            AQjmsOracleDebug.trace(4, "AQjmsObjectInputStream.resolveClass", "resolve using Class.forName(String) method");
            clz = Class.forName(type.getName());
        }
        return clz;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }
}

