/*
 * Decompiled with CFR 0.152.
 */
package oracle.AQ;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Vector;
import oracle.AQ.AQDriver;
import oracle.AQ.AQException;
import oracle.AQ.AQOracleDebug;
import oracle.AQ.AQSession;

public class AQDriverManager {
    static Vector drivers;
    private static boolean initialized;
    static OutputStream logstream;
    static PrintWriter pstream;
    static boolean cache_stmts;
    static boolean enable_jni;

    static synchronized void initialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        AQDriverManager.loadInitialDrivers();
    }

    private static void loadInitialDrivers() {
        String string;
        try {
            string = System.getProperty("aq.drivers");
        }
        catch (Exception exception) {
            string = null;
        }
        if (string == null) {
            return;
        }
        while (string.length() != 0) {
            String string2;
            int n = string.indexOf(58);
            if (n < 0) {
                string2 = string;
                string = "";
            } else {
                string2 = string.substring(0, n);
                string = string.substring(n + 1);
            }
            if (string2.length() == 0) continue;
            try {
                AQOracleDebug.println("DriverManager.Initialize: loading " + string2);
                Class.forName(string2);
            }
            catch (Exception exception) {
                AQOracleDebug.println("DriverManager.Initialize: load failed: " + exception);
            }
        }
    }

    private AQDriverManager() {
    }

    public static void registerDriver(AQDriver aQDriver) {
        if (!initialized) {
            AQDriverManager.initialize();
        }
        drivers.addElement(aQDriver);
        AQOracleDebug.trace(4, "AQDriverManager.registerDriver", "Registered driver: " + aQDriver.toString());
    }

    public static Vector getDrivers() {
        return drivers;
    }

    public static synchronized AQSession createAQSession(Object object) throws AQException {
        int n = 0;
        AQSession aQSession = null;
        AQDriver aQDriver = null;
        boolean bl = false;
        Vector vector = AQDriverManager.getDrivers();
        if (!initialized) {
            AQDriverManager.initialize();
        }
        if (drivers == null || drivers.size() == 0) {
            if (drivers.size() == 0) {
                throw new AQException(0, "No AQ drivers registered");
            }
        } else {
            try {
                for (n = 0; n < drivers.size(); ++n) {
                    bl = false;
                    aQDriver = (AQDriver)drivers.elementAt(n);
                    try {
                        bl = aQDriver.acceptsObject(object);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!bl) continue;
                    aQSession = aQDriver.createAQSession(object);
                    break;
                }
                if (!bl) {
                    throw new AQException(0, "Cannot open connection - invalid conn");
                }
            }
            catch (Exception exception) {
                throw new AQException(0, exception.getMessage(), exception);
            }
        }
        return aQSession;
    }

    public static OutputStream getLogStream() {
        return logstream;
    }

    public static void setLogStream(OutputStream outputStream) {
        logstream = outputStream;
        pstream = new PrintWriter(logstream);
    }

    public static PrintWriter getPrintWriter() {
        return pstream;
    }

    public static boolean isStmtCachingEnabled() {
        return cache_stmts;
    }

    public static void setCacheStmtFlag(boolean bl) {
        cache_stmts = bl;
    }

    public static void enableOciAQ() {
        enable_jni = true;
    }

    public static void disableOciAQ() {
        enable_jni = false;
    }

    public static boolean isOciAQEnabled() {
        return enable_jni;
    }

    static {
        initialized = false;
        logstream = System.err;
        pstream = new PrintWriter(logstream);
        cache_stmts = true;
        enable_jni = true;
        drivers = new Vector();
    }
}

