/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.util.Hashtable;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.sql.DataSource;
import oracle.jms.AQjmsConstants;
import oracle.jms.AQjmsFactory;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsQueueConnectionFactory;
import oracle.jms.AQjmsSession;
import oracle.jms.AQjmsTopicConnectionFactory;

public class AQjmsContext
implements Context {
    public static final String Q_PREFIX = "Queues/";
    public static final String T_PREFIX = "Topics/";
    public static final String CF_PREFIX = "ConnectionFactory";
    public static final String XACF_PREFIX = "XAConnectionFactory";
    public static final String QCF_PREFIX = "QueueConnectionFactory";
    public static final String XAQCF_PREFIX = "XAQueueConnectionFactory";
    public static final String TCF_PREFIX = "TopicConnectionFactory";
    public static final String XATCF_PREFIX = "XATopicConnectionFactory";
    public static final String DB_URL = "db_url";
    public static final String DB_USERNAME = "java.naming.security.principal";
    public static final String DB_PASSWORD = "java.naming.security.credentials";
    public static final String DATASOURCE_LOCATION = "datasource";
    private String url = null;
    private String username = null;
    private String password = null;
    private String dsLocation = null;
    private DataSource ds = null;

    public AQjmsContext(Hashtable hashtable) throws NamingException {
        this.dsLocation = (String)hashtable.get(DATASOURCE_LOCATION);
        this.url = (String)hashtable.get(DB_URL);
        this.username = (String)hashtable.get(DB_USERNAME);
        this.password = (String)hashtable.get(DB_PASSWORD);
        if (this.url != null) {
            if (this.username == null || this.password == null) {
                this.incompleteConfiguration();
            }
        } else {
            if (this.dsLocation == null) {
                this.incompleteConfiguration();
            }
            if (this.username != null || this.password != null) {
                this.incompleteConfiguration();
            }
        }
        if (this.dsLocation != null && AQjmsConstants.CACHE_DS_IN_CONTEXT) {
            this.getDataSource();
        }
    }

    private void incompleteConfiguration() throws NamingException {
        throw new NamingException("The configuration of the AQjmsInitialContext is not complete. The configuration must contain datasource or (db_url,java.naming.security.principal,java.naming.security.credentials) or both");
    }

    private synchronized DataSource getDataSource() throws NamingException {
        if (this.dsLocation == null) {
            return null;
        }
        if (this.ds == null) {
            InitialContext initialContext = new InitialContext();
            DataSource dataSource = (DataSource)initialContext.lookup(this.dsLocation);
            if (AQjmsConstants.CACHE_DS_IN_CONTEXT) {
                this.ds = dataSource;
            }
            return dataSource;
        }
        return this.ds;
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        throw new NamingException("Not supported");
    }

    @Override
    public Object lookup(String string) throws NamingException {
        AQjmsOracleDebug.trace(3, "AQjmsContext.lookup", "enter");
        Object object = null;
        if (string != null) {
            try {
                String string2 = AQjmsContext.getResourceType(string);
                String string3 = AQjmsContext.getResourceName(string);
                if (string2 == null) {
                    throw new NamingException("Unrecognized prefix in: " + string);
                }
                if (string2.equals(Q_PREFIX)) {
                    if (string3 == null) {
                        throw new NamingException("Empty destination name in: " + string);
                    }
                    object = this.initQ(string3);
                } else if (string2.equals(T_PREFIX)) {
                    if (string3 == null) {
                        throw new NamingException("Empty destination name in: " + string);
                    }
                    object = this.initT(string3);
                } else if (string2.equals(CF_PREFIX)) {
                    object = this.initCF();
                } else if (string2.equals(QCF_PREFIX)) {
                    object = this.initQCF();
                } else if (string2.equals(TCF_PREFIX)) {
                    object = this.initTCF();
                } else if (string2.equals(XACF_PREFIX)) {
                    object = this.initXACF();
                } else if (string2.equals(XAQCF_PREFIX)) {
                    object = this.initXAQCF();
                } else if (string2.equals(XATCF_PREFIX)) {
                    object = this.initXATCF();
                }
            }
            catch (Exception exception) {
                NamingException namingException = new NamingException("Cannot resolve name:" + string);
                namingException.initCause(exception);
                AQjmsOracleDebug.traceEx(1, "AQjmsContext.lookup failed for " + string, exception);
                throw namingException;
            }
        }
        AQjmsOracleDebug.trace(3, "AQjmsContext.lookup", "lookup return:" + object);
        if (object == null) {
            throw new NameNotFoundException("Cannot resolve name:" + string);
        }
        return object;
    }

    @Override
    public void bind(Name name, Object object) throws NamingException {
        throw new NamingException("Not supported");
    }

    @Override
    public void bind(String string, Object object) throws NamingException {
        throw new NamingException("Not supported");
    }

    @Override
    public void rebind(Name name, Object object) throws NamingException {
        throw new NamingException("Not supported");
    }

    @Override
    public void rebind(String string, Object object) throws NamingException {
        throw new NamingException("Not supported");
    }

    @Override
    public void unbind(Name name) throws NamingException {
        throw new NamingException("Not supported");
    }

    @Override
    public void unbind(String string) throws NamingException {
        throw new NamingException("Not supported");
    }

    @Override
    public void rename(Name name, Name name2) throws NamingException {
        throw new NamingException("Not supported");
    }

    @Override
    public void rename(String string, String string2) throws NamingException {
        throw new NamingException("Not supported");
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        throw new NamingException("Not supported");
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String string) throws NamingException {
        throw new NamingException("Not supported");
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        throw new NamingException("Not supported");
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String string) throws NamingException {
        throw new NamingException("Not supported");
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        throw new NamingException("Not supported");
    }

    @Override
    public void destroySubcontext(String string) throws NamingException {
        throw new NamingException("Not supported");
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        throw new NamingException("Not supported");
    }

    @Override
    public Context createSubcontext(String string) throws NamingException {
        throw new NamingException("Not supported");
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        throw new NamingException("Not supported");
    }

    @Override
    public Object lookupLink(String string) throws NamingException {
        throw new NamingException("Not supported");
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        throw new NamingException("Not supported");
    }

    @Override
    public NameParser getNameParser(String string) throws NamingException {
        throw new NamingException("Not supported");
    }

    @Override
    public Name composeName(Name name, Name name2) throws NamingException {
        throw new NamingException("Not supported");
    }

    @Override
    public String composeName(String string, String string2) throws NamingException {
        throw new NamingException("Not supported");
    }

    @Override
    public Object addToEnvironment(String string, Object object) throws NamingException {
        throw new NamingException("Not supported");
    }

    @Override
    public Object removeFromEnvironment(String string) throws NamingException {
        throw new NamingException("Not supported");
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (this.url != null) {
            hashtable.put(DB_URL, this.url);
            hashtable.put(DB_USERNAME, this.username);
            hashtable.put(DB_PASSWORD, this.password);
        }
        if (this.dsLocation != null) {
            hashtable.put(DATASOURCE_LOCATION, this.dsLocation);
        }
        return hashtable;
    }

    @Override
    public void close() throws NamingException {
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        throw new NamingException("Not supported");
    }

    private static String getResourceType(String string) throws JMSException {
        if (string.startsWith(Q_PREFIX)) {
            return Q_PREFIX;
        }
        if (string.equals(CF_PREFIX)) {
            return CF_PREFIX;
        }
        if (string.equals(XACF_PREFIX)) {
            return XACF_PREFIX;
        }
        if (string.equals(QCF_PREFIX)) {
            return QCF_PREFIX;
        }
        if (string.equals(XAQCF_PREFIX)) {
            return XAQCF_PREFIX;
        }
        if (string.startsWith(T_PREFIX)) {
            return T_PREFIX;
        }
        if (string.equals(TCF_PREFIX)) {
            return TCF_PREFIX;
        }
        if (string.equals(XATCF_PREFIX)) {
            return XATCF_PREFIX;
        }
        return null;
    }

    private static String getResourceName(String string) {
        if (string.startsWith(Q_PREFIX)) {
            return string.substring(Q_PREFIX.length());
        }
        if (string.startsWith(T_PREFIX)) {
            return string.substring(T_PREFIX.length());
        }
        return null;
    }

    private Object initQ(String string) throws Exception {
        Queue queue = null;
        QueueConnection queueConnection = null;
        QueueSession queueSession = null;
        try {
            AQjmsQueueConnectionFactory aQjmsQueueConnectionFactory = (AQjmsQueueConnectionFactory)this.initQCF();
            queueConnection = aQjmsQueueConnectionFactory.createQueueConnectionInternal();
            queueSession = queueConnection.createQueueSession(true, 1);
            queue = ((AQjmsSession)queueSession).createQueue(string);
        }
        catch (Exception exception) {
            AQjmsOracleDebug.traceEx(1, "AQjmsContext.initQ failed for queue " + string, exception);
            throw exception;
        }
        finally {
            try {
                queueSession.close();
            }
            catch (Exception exception) {}
            try {
                queueConnection.close();
            }
            catch (Exception exception) {}
        }
        return queue;
    }

    private Object initCF() throws Exception {
        return AQjmsFactory.getConnectionFactory(this.getDataSource(), this.url, this.getProperties());
    }

    private Object initQCF() throws Exception {
        return AQjmsFactory.getQueueConnectionFactory(this.getDataSource(), this.url, this.getProperties());
    }

    private Object initXACF() throws Exception {
        return AQjmsFactory.getXAConnectionFactory(this.getDataSource(), this.url, this.getProperties());
    }

    private Object initXAQCF() throws Exception {
        return AQjmsFactory.getXAQueueConnectionFactory(this.getDataSource(), this.url, this.getProperties());
    }

    private Object initT(String string) throws Exception {
        Topic topic = null;
        TopicConnection topicConnection = null;
        TopicSession topicSession = null;
        try {
            AQjmsTopicConnectionFactory aQjmsTopicConnectionFactory = (AQjmsTopicConnectionFactory)this.initTCF();
            topicConnection = aQjmsTopicConnectionFactory.createTopicConnectionInternal();
            topicSession = topicConnection.createTopicSession(true, 1);
            topic = ((AQjmsSession)topicSession).createTopic(string);
        }
        catch (Exception exception) {
            AQjmsOracleDebug.traceEx(1, "AQjmsContext.initT failed for topic " + string, exception);
            throw exception;
        }
        finally {
            try {
                topicSession.close();
            }
            catch (Exception exception) {}
            try {
                topicConnection.close();
            }
            catch (Exception exception) {}
        }
        return topic;
    }

    private Object initTCF() throws Exception {
        return AQjmsFactory.getTopicConnectionFactory(this.getDataSource(), this.url, this.getProperties());
    }

    private Object initXATCF() throws Exception {
        return AQjmsFactory.getXATopicConnectionFactory(this.getDataSource(), this.url, this.getProperties());
    }

    private Properties getProperties() {
        Properties properties = new Properties();
        if (this.username != null) {
            properties.put("user", this.username);
        }
        if (this.password != null) {
            properties.put("password", this.password);
        }
        return properties;
    }
}

