/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsGeneralDBConnection;
import oracle.jms.AQjmsOracleDebug;

class AQjmsExceptionListener
extends Thread
implements ExceptionListener {
    public static final long DEFAULT_PING_PERIOD = 120000L;
    private static final String PING_QUERY = "SELECT banner FROM v$version where 1<>1";
    private PreparedStatement m_pstmt;
    private ExceptionListener m_el;
    private long m_period = 120000L;
    private boolean m_stop = false;
    private boolean m_suspended = true;
    private boolean m_registered = false;
    private Connection m_dbConn;
    private AQjmsGeneralDBConnection m_genConn;
    private Object expLock = new Object();
    private JMSException expFromMessageListener;

    AQjmsExceptionListener(AQjmsGeneralDBConnection aQjmsGeneralDBConnection) throws JMSException {
        this.m_genConn = aQjmsGeneralDBConnection;
        this.m_dbConn = aQjmsGeneralDBConnection.getDBConnection();
        try {
            this.m_pstmt = this.m_dbConn.prepareStatement(PING_QUERY);
            this.m_pstmt.setQueryTimeout(1);
        }
        catch (SQLException sQLException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsExceptionListener constructor", sQLException);
            throw new AQjmsException(sQLException);
        }
    }

    synchronized void setExceptionListener(ExceptionListener exceptionListener) {
        if (exceptionListener == null) {
            this.m_registered = false;
        } else {
            this.m_registered = true;
            if (!this.isAlive()) {
                this.start();
            }
        }
        this.m_el = exceptionListener;
    }

    ExceptionListener getExceptionListener() {
        return this.m_el;
    }

    public synchronized void onException(JMSException jMSException) {
        if (this.m_el != null) {
            try {
                this.m_el.onException(jMSException);
            }
            catch (RuntimeException runtimeException) {
                AQjmsOracleDebug.traceEx(2, "Exception thrown by onException()", runtimeException);
                throw runtimeException;
            }
            catch (Error error) {
                AQjmsOracleDebug.traceErr(2, "Error thrown by onException()", error);
                throw error;
            }
        }
    }

    void setPingPeriod(long l) {
        if (l <= 0L) {
            return;
        }
        this.m_period = l;
    }

    long getPingPeriod() {
        return this.m_period;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean bl = false;
        while (!this.m_stop) {
            try {
                AQjmsExceptionListener aQjmsExceptionListener = this;
                synchronized (aQjmsExceptionListener) {
                    this.wait(this.m_period);
                }
                if (!this.m_registered || this.m_suspended) continue;
                if (this.checkNotifiedJMSException()) break;
                AQjmsOracleDebug.trace(5, "AQjmsExceptionListener", "executing query");
                this.m_pstmt.executeQuery();
                AQjmsOracleDebug.trace(5, "AQjmsExceptionListener", "done executing query");
                if (!this.checkNotifiedJMSException()) continue;
                break;
            }
            catch (InterruptedException interruptedException) {
                if (!this.m_stop) continue;
                AQjmsOracleDebug.trace(5, "AQjmsExceptionListener", "run stopped");
                return;
            }
            catch (SQLException sQLException) {
                JMSException jMSException = new JMSException(sQLException.toString());
                this.onException(jMSException);
                this.m_stop = true;
            }
        }
    }

    synchronized void resumeExceptionListener() {
        if (this.m_suspended) {
            this.m_suspended = false;
        }
    }

    synchronized void suspendExceptionListener() {
        this.m_suspended = true;
    }

    void close() {
        try {
            if (!this.m_stop) {
                this.m_stop = true;
                if (this.isAlive()) {
                    final AQjmsExceptionListener aQjmsExceptionListener = this;
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            aQjmsExceptionListener.interrupt();
                            return null;
                        }
                    });
                    try {
                        this.join(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        AQjmsOracleDebug.trace(5, "AQjmsExceptionListener", "in close, InterruptedException caught");
                    }
                }
            }
            if (this.m_pstmt != null) {
                try {
                    this.m_pstmt.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.m_pstmt = null;
            }
            try {
                this.m_genConn.close();
            }
            catch (JMSException jMSException) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void feedJMSException(JMSException jMSException) {
        Object object = this.expLock;
        synchronized (object) {
            this.expFromMessageListener = jMSException;
        }
        object = this;
        synchronized (object) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkNotifiedJMSException() {
        Object object = this.expLock;
        synchronized (object) {
            if (this.expFromMessageListener != null) {
                this.m_stop = true;
                JMSException jMSException = this.expFromMessageListener;
                this.expFromMessageListener = null;
                this.onException(jMSException);
            }
        }
        return this.m_stop;
    }

    public void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }
}

