/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import oracle.jms.AQjmsConstants;
import oracle.jms.AQjmsConsumer;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsObject;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsSession;
import oracle.jms.AQjmsSimpleScheduler;
import oracle.jms.AQjmsStatScheduler;
import oracle.jms.DispatchScheduler;
import oracle.jms.ThreadProxy;

class AQjmsListenerWorker
extends AQjmsObject
implements Runnable {
    private AQjmsConsumer m_consumer;
    private MessageListener m_listener;
    private DispatchScheduler m_scheduler;
    private AQjmsSession m_sess;
    private Object m_sleepObj = new Object();
    private Thread m_workThread;

    AQjmsListenerWorker(AQjmsSession aQjmsSession, AQjmsConsumer aQjmsConsumer, MessageListener messageListener) throws JMSException {
        this(aQjmsSession, aQjmsConsumer, messageListener, null);
    }

    AQjmsListenerWorker(AQjmsSession aQjmsSession, AQjmsConsumer aQjmsConsumer, MessageListener messageListener, DispatchScheduler dispatchScheduler) throws JMSException {
        super("AQjmsListenerWorker", aQjmsConsumer);
        this.m_sess = aQjmsSession;
        this.m_consumer = aQjmsConsumer;
        this.m_listener = messageListener;
        this.m_scheduler = dispatchScheduler;
        if (dispatchScheduler == null) {
            if (AQjmsConstants.getDefaultScheduler() == 2) {
                this.m_scheduler = new AQjmsStatScheduler(null);
                AQjmsOracleDebug.trace(3, "AQjmsListenerWorker.constructor", "Using AQjmsStatScheduler as the DispatchScheduler");
            } else {
                this.m_scheduler = new AQjmsSimpleScheduler(null);
                AQjmsOracleDebug.trace(3, "AQjmsListenerWorker.constructor", "Using AQjmsSimpleScheduler as the DispatchScheduler");
            }
        }
        aQjmsConsumer.attach(this);
    }

    synchronized void setMessageListener(MessageListener messageListener) {
        this.m_listener = messageListener;
        if (messageListener == null) {
            this.notifyAll();
        }
    }

    synchronized void setMessageListener(MessageListener messageListener, DispatchScheduler dispatchScheduler) {
        this.m_listener = messageListener;
        this.m_scheduler = dispatchScheduler;
        if (messageListener == null) {
            this.notifyAll();
        }
    }

    synchronized MessageListener getMessageListener() {
        return this.m_listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void preClose() {
        Object object = this.m_sleepObj;
        synchronized (object) {
            this.m_sleepObj.notifyAll();
        }
    }

    @Override
    public void run() {
        while (true) {
            AQjmsOracleDebug.trace(3, "AQjmsListenerWorker.run", "Before dispatchOneMsg to dispatch a message to the listener");
            if (!this.dispatchOneMsg()) {
                AQjmsOracleDebug.trace(3, "AQjmsListenerWorker.run", "dispatchOneMsg return false, EXIT");
                return;
            }
            AQjmsOracleDebug.trace(3, "AQjmsListenerWorker.run", "After dispatchOneMsg, Before get the next sleep time ");
            long l = this.m_scheduler.getNextSleepTime();
            AQjmsOracleDebug.trace(3, "AQjmsListenerWorker.run", "sleep " + l + " millisecond.");
            if (l == 0L) continue;
            this.doSleep(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSleep(long l) {
        Object object = this.m_sleepObj;
        synchronized (object) {
            if (this.isClosed() || this.m_listener == null) {
                AQjmsOracleDebug.trace(3, "AQjmsListenerWorker.doSleep", "consumer is closed or listener is set to null, EXIT");
                return;
            }
            try {
                AQjmsOracleDebug.trace(3, "AQjmsListenerWorker.doSleep", "try to wait for " + l + " milliseconds");
                this.m_sleepObj.wait(l);
            }
            catch (Exception exception) {
                AQjmsOracleDebug.traceEx(3, "AQjmsListenerWorker.doSleep: Sleep thread might be interrupted.", exception);
            }
            AQjmsOracleDebug.trace(3, "AQjmsListenerWorker.doSleep", "exit");
        }
    }

    private void feedSchedulerData(Message message) {
        try {
            if (this.m_scheduler != null) {
                this.m_scheduler.feedData(message);
            }
        }
        catch (Exception exception) {
            AQjmsOracleDebug.traceEx(3, "ListenerWorker.feedSchedulerData: Error in feeding data to DispatchScheduler", exception);
        }
    }

    private void feedSchedulerException(int n, Exception exception) {
        try {
            if (this.m_scheduler != null) {
                this.m_scheduler.feedException(n, exception);
            }
        }
        catch (Exception exception2) {
            AQjmsOracleDebug.traceEx(3, "ListenerWorker.feedSchedulerException: Error in feeding exception to DispatchScheduler", exception2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean dispatchOneMsg() {
        AQjmsOracleDebug.trace(3, "AQjmsListenerWorker.dispatchOneMsg", "entry");
        if (this.isClosed() || this.m_listener == null) {
            AQjmsOracleDebug.trace(3, "AQjmsListenerWorker.dispatchOneMsg", "consumer is closed or listener is set to null, EXIT");
            return false;
        }
        try {
            this.m_consumer.lockReceive("ListenerWorker.dispatchOneMsg", -1L);
        }
        catch (IllegalStateException illegalStateException) {
            return false;
        }
        catch (Exception exception) {
            AQjmsOracleDebug.traceEx(3, "ListenerWorker.dispatchOneMsg: Error in acquiring the lock.", exception);
            this.feedSchedulerException(1, exception);
            return true;
        }
        AQjmsOracleDebug.trace(3, "AQjmsListenerWorker.dispatchOneMsg", "lockReceive returns, got the lock");
        Message message = null;
        try {
            message = this.m_consumer.receiveForListener();
        }
        catch (Exception exception) {
            AQjmsOracleDebug.traceEx(3, "ListenerWorker.dispatchOneMsg: Error in receiving message", exception);
            this.feedSchedulerException(1, exception);
            this.m_consumer.unlock("ListenerWorker.dispatchOneMsg");
            this.feedExceptionToConnection(exception);
            return true;
        }
        try {
            AQjmsOracleDebug.trace(3, "AQjmsListenerWorker.dispatchOneMsg", "Received the message: " + (message == null ? "null message" : message.getJMSMessageID()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.feedSchedulerData(message);
        if (message != null) {
            AQjmsException aQjmsException = null;
            try {
                this.m_sess.startListener();
                AQjmsOracleDebug.trace(3, "AQjmsListenerWorker.dispatchOneMsg", "Before calling onMessage method");
                this.m_listener.onMessage(message);
                AQjmsOracleDebug.trace(3, "AQjmsListenerWorker.dispatchOneMsg", "After calling onMessage method");
            }
            catch (Throwable throwable) {
                aQjmsException = new AQjmsException("Error in onMessage Method", throwable);
                AQjmsOracleDebug.traceEx(3, "ListenerWorker.dispatchOneMsg: error in onMessage of MessageListener class", (Throwable)((Object)aQjmsException));
            }
            finally {
                this.m_sess.stopListener();
            }
            try {
                int n = this.m_sess.getAcknowledgeMode();
                if (n == 1 || n == 3) {
                    if (aQjmsException == null) {
                        this.m_sess.forceCommit();
                        AQjmsOracleDebug.trace(3, "AQjmsListenerWorker.dispatchOneMsg", "acknowledged the message just received.");
                    } else {
                        this.m_sess.forceRollback();
                        AQjmsOracleDebug.trace(3, "AQjmsListenerWorker.dispatchOneMsg", "recover the message just received.");
                        this.feedSchedulerException(2, (Exception)((Object)aQjmsException));
                    }
                }
            }
            catch (Exception exception) {
                AQjmsOracleDebug.traceEx(3, "ListenerWorker.dispatchOneMsg: error in acknowledgement or recovery after onMessage", exception);
            }
        }
        this.m_consumer.unlock("ListenerWorker.dispatchOneMsg");
        AQjmsOracleDebug.trace(3, "AQjmsListenerWorker.dispatchOneMsg", "unlock the session and EXIT");
        return true;
    }

    void launch() throws JMSException {
        this.launch(null);
    }

    void launch(ThreadProxy threadProxy) throws JMSException {
        try {
            if (threadProxy == null) {
                this.m_workThread = new Thread(this);
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        AQjmsListenerWorker.this.m_workThread.setDaemon(true);
                        return null;
                    }
                });
                this.m_workThread.start();
            } else {
                this.m_workThread = threadProxy.launch(this);
            }
        }
        catch (Exception exception) {
            AQjmsOracleDebug.traceEx(3, "ListenerWorker.launch: error in staring the listening thread", exception);
            AQjmsError.throwEx(237, (Throwable)exception);
        }
    }

    Thread getListenerWorkerThread() {
        return this.m_workThread;
    }

    private void feedExceptionToConnection(Exception exception) {
        JMSException jMSException = null;
        try {
            jMSException = exception instanceof JMSException ? (JMSException)((Object)exception) : new AQjmsException(exception.getMessage(), exception);
            this.m_sess.jms_conn.feedJMSException(jMSException);
        }
        catch (Exception exception2) {
            AQjmsOracleDebug.traceEx(3, "ListenerWorker.feedExceptionToConnection: Error in feeding exception to Connection", exception2);
        }
    }
}

