/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageEOFException;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.jms.Topic;
import oracle.AQ.AQOracleAgent;
import oracle.jdbc.OracleArray;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleData;
import oracle.jdbc.OracleOpaque;
import oracle.jdbc.OracleStruct;
import oracle.jdbc.aq.AQAgent;
import oracle.jdbc.aq.AQEnqueueOptions;
import oracle.jdbc.aq.AQFactory;
import oracle.jdbc.aq.AQMessage;
import oracle.jdbc.aq.AQMessageProperties;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.internal.JMSEnqueueOptions;
import oracle.jdbc.internal.JMSFactory;
import oracle.jdbc.internal.JMSMessage;
import oracle.jdbc.internal.JMSMessageProperties;
import oracle.jms.AQjmsAdtMessage;
import oracle.jms.AQjmsAgent;
import oracle.jms.AQjmsArrayErrorInfo;
import oracle.jms.AQjmsArrayErrors;
import oracle.jms.AQjmsBytesMessage;
import oracle.jms.AQjmsBytesMessage_C;
import oracle.jms.AQjmsConnection;
import oracle.jms.AQjmsConstants;
import oracle.jms.AQjmsDestination;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsGenMessage_C;
import oracle.jms.AQjmsInterOp;
import oracle.jms.AQjmsMapMessage;
import oracle.jms.AQjmsMapMessage_C;
import oracle.jms.AQjmsMessage;
import oracle.jms.AQjmsMessageHeaderExt;
import oracle.jms.AQjmsMessageProperty;
import oracle.jms.AQjmsObject;
import oracle.jms.AQjmsObjectMessage;
import oracle.jms.AQjmsObjectMessage_C;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsPropertyList;
import oracle.jms.AQjmsRecipients;
import oracle.jms.AQjmsSession;
import oracle.jms.AQjmsSignature;
import oracle.jms.AQjmsStreamMessage;
import oracle.jms.AQjmsStreamMessage_C;
import oracle.jms.AQjmsTempLobTruncateException;
import oracle.jms.AQjmsTextMessage;
import oracle.jms.AQjmsTextMessage_C;
import oracle.jms.AQjmsUtil;
import oracle.sql.ANYDATA;
import oracle.sql.CustomDatum;
import oracle.sql.Datum;
import oracle.sql.ORAData;

public class AQjmsProducer
extends AQjmsObject
implements MessageProducer {
    AQjmsSession jms_sess;
    AQjmsDestination prod_dest;
    int type;
    boolean msgid_enabled;
    boolean timestamp_enabled;
    int m_priority;
    long m_timetolive;
    int del_mode;
    private String transfxm;
    private String connection_id;

    AQjmsProducer(AQjmsSession aQjmsSession, AQjmsDestination aQjmsDestination, int n) throws JMSException {
        super("Producer", aQjmsSession);
        this.jms_sess = aQjmsSession;
        this.prod_dest = aQjmsDestination;
        this.type = n;
        this.del_mode = 2;
        this.m_priority = this.jms_sess.getCompliant() ? 4 : 1;
        this.m_timetolive = -1L;
        this.timestamp_enabled = true;
        this.msgid_enabled = true;
        this.transfxm = null;
        this.connection_id = this.jms_sess.jms_conn.getConnectionID();
        aQjmsSession.attach(this);
    }

    private native void ocienq(String var1, Message var2, int var3, boolean var4, int var5, int var6, int var7, long var8, AQjmsAgent[] var10, long[] var11, long var12, String var14) throws Exception;

    private native void ocienq2(String var1, Message var2, int var3, boolean var4, int var5, int var6, int var7, long var8, AQjmsAgent[] var10, long[] var11, long var12, String var14, String var15, String var16, byte[] var17) throws Exception;

    public synchronized void setDisableMessageID(boolean bl) throws JMSException {
        this.checkClosed("setDisableMessageID");
        this.msgid_enabled = bl;
    }

    public synchronized boolean getDisableMessageID() throws JMSException {
        this.checkClosed("getDisableMessageID");
        return this.msgid_enabled;
    }

    public synchronized void setDisableMessageTimestamp(boolean bl) throws JMSException {
        this.checkClosed("setDisableMessageTimestamp");
        this.timestamp_enabled = bl;
    }

    public synchronized boolean getDisableMessageTimestamp() throws JMSException {
        this.checkClosed("getDisableMessageTimestamp");
        return this.timestamp_enabled;
    }

    public synchronized void setDeliveryMode(int n) throws JMSException {
        this.checkClosed("setDeliveryMode");
        if (n != 2 && n != 1) {
            AQjmsError.throwEx(101, Integer.toString(n));
        }
        this.del_mode = n;
    }

    public synchronized int getDeliveryMode() throws JMSException {
        this.checkClosed("getDeliveryMode");
        return this.del_mode;
    }

    public synchronized void setPriority(int n) throws JMSException {
        this.checkClosed("setPriority");
        this.m_priority = n;
    }

    public synchronized int getPriority() throws JMSException {
        this.checkClosed("getPriority");
        return this.m_priority;
    }

    public synchronized void setTimeToLive(long l) throws JMSException {
        this.checkClosed("setTimeToLive");
        this.m_timetolive = l;
    }

    public synchronized long getTimeToLive() throws JMSException {
        this.checkClosed("getTimeToLive");
        return this.m_timetolive;
    }

    public synchronized Queue getQueue() throws JMSException {
        this.checkClosed("getQueue");
        if (this.type == 10) {
            return this.prod_dest;
        }
        AQjmsError.throwEx(107, "TopicPublisher");
        return null;
    }

    public synchronized void setTransformation(String string) {
        this.transfxm = string;
    }

    public synchronized String getTransformation() {
        return this.transfxm;
    }

    public synchronized void send(Message message) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsProducer.send-1", "entry");
        this.checkClosed("send");
        if (this.type != 10 && this.type != 30) {
            AQjmsError.throwEx(107, "TopicPublisher");
        }
        if (this.prod_dest == null) {
            throw new UnsupportedOperationException("send is called without a valid Queue");
        }
        if (this.prod_dest.isQueue()) {
            this.send(this.prod_dest, message, this.del_mode, this.m_priority, this.m_timetolive, null, null, false);
        } else {
            this.publish(this.prod_dest, message, this.del_mode, this.m_priority, this.m_timetolive, null, null, false, null);
        }
        AQjmsOracleDebug.trace(4, "AQjmsProducer.send-1", "exit");
    }

    public synchronized void send(Message message, int n, int n2, long l) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsProducer.send-2", "entry");
        this.checkClosed("send(msg,mode,prio,ttl)");
        if (this.type != 10 && this.type != 30) {
            AQjmsError.throwEx(107, "TopicPublisher");
        }
        if (this.prod_dest == null) {
            throw new UnsupportedOperationException("send is called without a valid Queue");
        }
        if (this.prod_dest.isQueue()) {
            this.send(this.prod_dest, message, n, n2, l, null, null, false);
        } else {
            this.publish(this.prod_dest, message, n, n2, l, null, null, false, null);
        }
        AQjmsOracleDebug.trace(4, "AQjmsProducer.send-2", "exit");
    }

    public synchronized void send(Queue queue, Message message) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsProducer.send-3", "entry");
        this.checkClosed("send(q,msg)");
        boolean bl = false;
        this.send(queue, message, this.del_mode, this.m_priority, this.m_timetolive, null, null, bl);
        AQjmsOracleDebug.trace(4, "AQjmsProducer.send-3", "exit");
    }

    public synchronized void send(Queue queue, Message message, int n, int n2, long l) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsProducer.send-4", "entry");
        this.checkClosed("send(q,msg,mode,prio,ttl)");
        boolean bl = false;
        this.send(queue, message, n, n2, l, null, null, bl);
        AQjmsOracleDebug.trace(4, "AQjmsProducer.send-4", "exit");
    }

    public synchronized void bufferSend(Queue queue, Message message, int n, long l) throws JMSException {
        if (((AQjmsDestination)queue).isSharded()) {
            AQjmsError.throwEx(244, "bufferSend");
        }
        AQjmsOracleDebug.trace(4, "AQjmsProducer.bufferSend", "entry");
        this.checkClosed("send(q,msg,prio,ttl)");
        boolean bl = true;
        this.send(queue, message, 1, n, l, null, null, bl);
        AQjmsOracleDebug.trace(4, "AQjmsProducer.bufferSend", "exit");
    }

    synchronized void send(Queue queue, Message message, int n, int n2, long l, Integer n3, byte[] byArray, boolean bl) throws JMSException {
        AQjmsDestination aQjmsDestination = null;
        AQjmsOracleDebug.trace(4, "AQjmsProducer.send-main", "entry");
        this.checkClosed("send(q,msg,mode,prio,ttl,dev..)");
        if (message == null) {
            AQjmsError.throwEx(133);
        }
        if (queue == null) {
            if (this.prod_dest == null || this.prod_dest.getQueueName() == null) {
                AQjmsError.throwInvalidDestEx(143);
            } else {
                AQjmsOracleDebug.trace(5, "AQjmsProducer.send", "prod_dest: " + this.prod_dest.getCompleteName());
                aQjmsDestination = this.prod_dest;
            }
        } else if (queue.getQueueName() != null) {
            if (queue instanceof AQjmsDestination) {
                AQjmsOracleDebug.trace(5, "AQjmsProducer.send", "queue: " + ((AQjmsDestination)queue).getCompleteName());
                aQjmsDestination = (AQjmsDestination)queue;
            } else {
                AQjmsError.throwInvalidDestEx(125);
            }
        } else {
            AQjmsError.throwInvalidDestEx(143);
        }
        AQjmsOracleDebug.trace(5, "AQjmsProducer.send", "dest_queue: " + aQjmsDestination.getCompleteName());
        if (AQjmsConstants.useJdbcAQ() && this.jms_sess.getDriver().equalsIgnoreCase("thin") && !this.isXMLType(message)) {
            if (aQjmsDestination.isSharded()) {
                this.jdbcEnqueueSh(aQjmsDestination, message, n, n2, l, bl, null);
            } else {
                this.jdbcEnqueue(aQjmsDestination, message, n, n2, l, n3, byArray, bl, null);
            }
        } else {
            this.enqueue(aQjmsDestination, message, n, n2, l, n3, byArray, bl, null);
        }
        AQjmsOracleDebug.trace(4, "AQjmsProducer.send-main", "exit");
    }

    private boolean isXMLType(Message message) throws JMSException {
        if (!(message instanceof AQjmsAdtMessage)) {
            return false;
        }
        return ((AQjmsAdtMessage)message).getAdtPayload().getClass().getName().equals("oracle.xdb.XMLType");
    }

    private String getAdtType(AQjmsDestination aQjmsDestination) throws JMSException {
        if (this.transfxm == null) {
            return aQjmsDestination.getAdtType();
        }
        return AQjmsUtil.getTransType(this.jms_sess.getDBConnection(), aQjmsDestination, this.transfxm).getSourceType();
    }

    private boolean useTempLobs(boolean bl) {
        return this.jms_sess.toUseTempLobs() || this.transfxm != null || bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void jdbcEnqueue(AQjmsDestination aQjmsDestination, Message message, int n, int n2, long l, Integer n3, byte[] byArray, boolean bl, AQjmsAgent[] aQjmsAgentArray) throws JMSException {
        AQjmsMessage aQjmsMessage;
        AQjmsOracleDebug.trace(4, "AQjmsProducer.jdbcEnqueue", "entry");
        String string = "START";
        if (message == null) {
            AQjmsError.throwEx(133);
        }
        if (aQjmsDestination == null) {
            AQjmsError.throwEx(127);
        }
        if ((aQjmsMessage = (AQjmsMessage)AQjmsProducer.convertForeignMessage(this.jms_sess, message)).getInputStream() != null && !aQjmsDestination.isSharded()) {
            AQjmsError.throwInvalidDestEx(245);
        }
        byte[] byArray2 = null;
        try {
            Object object;
            AQAgent[] aQAgentArray;
            Object object2;
            Object object3;
            Object object4;
            String string2 = this.getAdtType(aQjmsDestination);
            if (aQjmsMessage.isHeaderOnly()) {
                aQjmsMessage = (AQjmsMessage)AQjmsProducer.convertHeaderMessage(aQjmsMessage, string2);
                aQjmsMessage.setStringProperty2("JMS_OracleHeaderOnly", "yes");
            }
            this.checkMessageType(string2, aQjmsMessage, false);
            if (!(aQjmsMessage instanceof AQjmsAdtMessage)) {
                aQjmsMessage.setStringProperty2("JMS_OracleDeliveryMode", "" + n);
            }
            if (aQjmsDestination.isTopic() && !(aQjmsMessage instanceof AQjmsAdtMessage)) {
                aQjmsMessage.setStringProperty2("JMS_OracleConnectionID", this.connection_id);
            }
            long l2 = System.currentTimeMillis();
            aQjmsMessage.setJMSTimestamp(l2);
            if (!this.lock("jdbcEnqueue", -1L)) {
                AQjmsError.throwEx(122);
            }
            oracle.jdbc.OracleConnection oracleConnection = (oracle.jdbc.OracleConnection)this.jms_sess.getDBConnection();
            if (!(aQjmsMessage instanceof AQjmsAdtMessage)) {
                object4 = aQjmsMessage.getMessageHeaderExt();
                if (((AQjmsMessageHeaderExt)object4).getReplyto() == null) {
                    object3 = new AQjmsAgent(" ", null, 0);
                    ((AQjmsMessageHeaderExt)object4).setReplyto((AQjmsAgent)object3);
                }
                ((AQjmsMessageHeaderExt)object4).setUserid((object3 = this.jms_sess.getJmsConnection()) == null ? null : ((AQjmsConnection)object3).getUserName());
                object2 = AQjmsMessage.convertHashtableToPropertyList(aQjmsMessage.getPropertiesHashtable());
                ((AQjmsMessageHeaderExt)object4).setProperties((AQjmsPropertyList)object2);
            }
            object4 = aQjmsDestination.getCompleteName();
            AQjmsOracleDebug.trace(5, "AQjmsProducer.jdbcEnqueue", "destination Name: " + (String)object4);
            object3 = AQFactory.createAQMessageProperties();
            object3.setDelay(aQjmsMessage.getDelay());
            object3.setExceptionQueue(aQjmsMessage.getExceptionQueue());
            if (aQjmsMessage.isJMSBody() && this.jms_sess.getCompliant()) {
                n2 = AQjmsMessage.toJMSPriority(n2);
            }
            object3.setPriority(n2);
            object3.setCorrelation(aQjmsMessage.getJMSCorrelationID());
            AQjmsOracleDebug.trace(5, "AQjmsProducer.jdbcEnqueue", "set correlation: " + aQjmsMessage.getJMSCorrelationID());
            object2 = aQjmsMessage.getSenderID();
            if (object2 != null) {
                aQAgentArray = AQFactory.createAQAgent();
                aQAgentArray.setName(((AQjmsAgent)object2).getName());
                aQAgentArray.setAddress(((AQjmsAgent)object2).getAddress());
                aQAgentArray.setProtocol(((AQjmsAgent)object2).getProtocol());
                object3.setSender((AQAgent)aQAgentArray);
                AQjmsOracleDebug.trace(5, "AQjmsProducer.jdbcEnqueue", "set sender_name: " + ((AQjmsAgent)object2).getName() + "\nset sender_addr: " + ((AQjmsAgent)object2).getAddress() + "\nset sender_protocol: " + ((AQjmsAgent)object2).getProtocol());
            }
            if (aQjmsAgentArray != null && aQjmsAgentArray.length > 0) {
                AQjmsOracleDebug.trace(5, "AQjmsProducer.jdbcEnqueue", "recipient list specified");
                aQAgentArray = new AQAgent[aQjmsAgentArray.length];
                for (int i = 0; i < aQjmsAgentArray.length; ++i) {
                    aQAgentArray[i] = AQFactory.createAQAgent();
                    aQAgentArray[i].setAddress(aQjmsAgentArray[i].getAddress());
                    aQAgentArray[i].setName(aQjmsAgentArray[i].getName());
                    aQAgentArray[i].setProtocol(aQjmsAgentArray[i].getProtocol());
                }
                object3.setRecipientList(aQAgentArray);
            } else {
                AQjmsOracleDebug.trace(5, "AQjmsProducer.jdbcEnqueue", "recipient list not specified");
            }
            int n4 = 0;
            n4 = l == 0L || l == -1L ? -1 : (int)l / 1000;
            object3.setExpiration(n4);
            AQEnqueueOptions aQEnqueueOptions = new AQEnqueueOptions();
            aQEnqueueOptions.setRetrieveMessageId(true);
            int n5 = 0;
            n5 = bl ? 1 : 2;
            aQEnqueueOptions.setVisibility(AQjmsConstants.toEnqueueVisibilityEnum(n5));
            AQjmsOracleDebug.trace(5, "AQjmsProducer.jdbcEnqueue", "visibility: " + n5);
            AQjmsOracleDebug.trace(5, "AQjmsProducer.jdbcEnqueue", "JMS delivery mode: " + n);
            int n6 = this.deliveryModeFromJMSToAQ(n);
            if (!bl) {
                n6 = 1;
            }
            AQjmsOracleDebug.trace(5, "AQjmsProducer.jdbcEnqueue", "AQ delivery mode: " + n6);
            aQEnqueueOptions.setDeliveryMode(AQjmsConstants.toEnqueueDeliveryModeEnum(n6));
            if (this.transfxm != null) {
                aQEnqueueOptions.setTransformation(this.transfxm);
                AQjmsOracleDebug.trace(5, "AQjmsProducer.jdbcEnqueue", "set transformation: " + this.transfxm);
            }
            if (n3 != null) {
                int n7 = n3;
                aQEnqueueOptions.setSequenceDeviation(AQjmsConstants.toSequenceDeviationEnum(n7));
                if (byArray != null) {
                    aQEnqueueOptions.setRelativeMessageId(byArray);
                }
                AQjmsOracleDebug.trace(5, "AQjmsProducer.jdbcEnqueue", "set seq_deviation: " + n3 + "\nset relative_msgid: " + byArray);
            }
            Object object5 = null;
            if (aQjmsMessage instanceof AQjmsAdtMessage) {
                object = ((AQjmsAdtMessage)aQjmsMessage).getAdtPayload();
                if (object == null) {
                    AQjmsError.throwEx(104);
                }
                if (object instanceof OracleData) {
                    object5 = ((OracleData)object).toJDBCObject((Connection)oracleConnection);
                } else if (object instanceof CustomDatum) {
                    object5 = ((CustomDatum)object).toDatum((OracleConnection)oracleConnection);
                } else if (object instanceof ORAData) {
                    object5 = ((ORAData)object).toDatum((Connection)oracleConnection);
                } else {
                    AQjmsError.throwEx(129);
                }
            } else {
                object5 = string2.equalsIgnoreCase("SYS.AQ$_JMS_MESSAGE") ? aQjmsMessage.getGenMessageCont(this.jms_sess, this.useTempLobs(bl), false).toJDBCObject((Connection)oracleConnection) : aQjmsMessage.getMessageCont(this.jms_sess, this.useTempLobs(bl), false).toJDBCObject((Connection)oracleConnection);
            }
            aQjmsMessage.validateUserProperties();
            object = AQFactory.createAQMessage((AQMessageProperties)object3);
            if (string2.equalsIgnoreCase("SYS.ANYDATA") || object5 instanceof OracleOpaque) {
                object.setPayload(ANYDATA.convertDatum((Datum)((Datum)object5)));
            } else {
                object.setPayload((Struct)((OracleStruct)object5));
            }
            oracleConnection.enqueue((String)object4, aQEnqueueOptions, (AQMessage)object);
            string = "MESSAGE_INSERTED";
            byArray2 = object.getMessageId();
            if (aQjmsMessage.getWriteLobLater()) {
                aQjmsMessage.writeLob(this.jms_sess, aQjmsDestination.getCompleteTableName(), object.getMessageId(), string2.equalsIgnoreCase("SYS.ANYDATA"));
            }
            string = "LOB_WRITTEN";
            aQjmsMessage.setJMSMessageID(object.getMessageId());
            aQjmsMessage.setJMSDestination((Destination)aQjmsDestination);
            aQjmsMessage.setJMSDeliveryMode(n);
            if (l == 0L || l == -1L) {
                aQjmsMessage.setJMSExpiration(0L);
            } else {
                aQjmsMessage.setJMSExpiration(l2 + l);
            }
            aQjmsMessage.setJMSPriority(n2);
            if (message != aQjmsMessage) {
                AQjmsProducer.copyAQjmsMessageSendHeaders(aQjmsMessage, message);
            }
            string = "SEND_COMPLETED";
            if (!this.jms_sess.isInTransactionRechecked()) {
                this.jms_sess.forceCommit();
            }
        }
        catch (SQLException sQLException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsProducer.jdbcEnqueue", sQLException);
            if (sQLException.getErrorCode() != 24033) {
                throw new AQjmsException(sQLException);
            }
        }
        finally {
            if (string.equals("MESSAGE_INSERTED")) {
                try {
                    if (!this.jms_sess.isInTransactionRechecked()) {
                        this.jms_sess.forceRollback();
                    } else if (!this.purgeEmptyMessage(aQjmsDestination.getCompleteName(), byArray2)) {
                        this.jms_sess.setConsistency(false);
                    }
                }
                catch (Throwable throwable) {}
            }
            try {
                aQjmsMessage.messageSendCallback(false);
            }
            catch (AQjmsTempLobTruncateException aQjmsTempLobTruncateException) {
                if (aQjmsTempLobTruncateException.isBlob()) {
                    this.jms_sess.cachedTempBlob = null;
                } else {
                    this.jms_sess.cachedTempClob = null;
                }
            }
            catch (Throwable throwable) {}
            try {
                this.unlock("jdbcEnqueue");
            }
            catch (Throwable throwable) {}
            AQjmsOracleDebug.trace(3, "AQjmsProducer.jdbcEnqueue", "exit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void jdbcEnqueueSh(AQjmsDestination aQjmsDestination, Message message, int n, int n2, long l, boolean bl, AQjmsAgent[] aQjmsAgentArray) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsProducer.jdbcEnqueueSh", "entry");
        if (message == null) {
            AQjmsError.throwEx(133);
        }
        if (aQjmsDestination == null) {
            AQjmsError.throwEx(127);
        }
        AQjmsMessage aQjmsMessage = (AQjmsMessage)AQjmsProducer.convertForeignMessage(this.jms_sess, message);
        byte[] byArray = null;
        InputStream inputStream = null;
        PushbackInputStream pushbackInputStream = null;
        try {
            JMSMessage jMSMessage;
            JMSEnqueueOptions jMSEnqueueOptions;
            Object object;
            Object object2;
            oracle.jdbc.internal.OracleConnection oracleConnection;
            long l2;
            block44: {
                AQAgent[] aQAgentArray;
                if (aQjmsDestination.isTopic() && !(aQjmsMessage instanceof AQjmsAdtMessage)) {
                    aQjmsMessage.setStringProperty2("JMS_OracleConnectionID", this.connection_id);
                }
                l2 = System.currentTimeMillis();
                aQjmsMessage.setJMSTimestamp(l2);
                if (!this.lock("jdbcEnqueueSh", -1L)) {
                    AQjmsError.throwEx(122);
                }
                oracleConnection = (oracle.jdbc.internal.OracleConnection)this.jms_sess.getDBConnection();
                if (!(aQjmsMessage instanceof AQjmsAdtMessage)) {
                    object2 = aQjmsMessage.getMessageHeaderExt();
                    if (((AQjmsMessageHeaderExt)object2).getReplyto() == null) {
                        object = new AQjmsAgent(" ", null, 0);
                        ((AQjmsMessageHeaderExt)object2).setReplyto((AQjmsAgent)object);
                    }
                    ((AQjmsMessageHeaderExt)object2).setUserid((object = this.jms_sess.getJmsConnection()) == null ? null : ((AQjmsConnection)object).getUserName());
                }
                object2 = aQjmsDestination.getCompleteName();
                AQjmsOracleDebug.trace(5, "AQjmsProducer.jdbcEnqueueSh", "destination Name: " + (String)object2);
                object = AQFactory.createAQMessageProperties();
                object.setDelay(aQjmsMessage.getDelay());
                object.setExceptionQueue(aQjmsMessage.getExceptionQueue());
                object.setPriority(n2);
                object.setCorrelation(aQjmsMessage.getJMSCorrelationID());
                AQjmsOracleDebug.trace(5, "AQjmsProducer.jdbcEnqueueSh", "set correlation: " + aQjmsMessage.getJMSCorrelationID());
                AQjmsAgent aQjmsAgent = aQjmsMessage.getSenderID();
                if (aQjmsAgent != null) {
                    aQAgentArray = AQFactory.createAQAgent();
                    aQAgentArray.setName(aQjmsAgent.getName());
                    aQAgentArray.setAddress(aQjmsAgent.getAddress());
                    aQAgentArray.setProtocol(aQjmsAgent.getProtocol());
                    object.setSender((AQAgent)aQAgentArray);
                    AQjmsOracleDebug.trace(5, "AQjmsProducer.jdbcEnqueueSh", "set sender_name: " + aQjmsAgent.getName() + "\nset sender_addr: " + aQjmsAgent.getAddress() + "\nset sender_protocol: " + aQjmsAgent.getProtocol());
                }
                if (aQjmsAgentArray != null && aQjmsAgentArray.length > 0) {
                    AQjmsOracleDebug.trace(5, "AQjmsProducer.jdbcEnqueueSh", "recipient list specified");
                    aQAgentArray = new AQAgent[aQjmsAgentArray.length];
                    for (int i = 0; i < aQjmsAgentArray.length; ++i) {
                        aQAgentArray[i] = AQFactory.createAQAgent();
                        aQAgentArray[i].setAddress(aQjmsAgentArray[i].getAddress());
                        aQAgentArray[i].setName(aQjmsAgentArray[i].getName());
                        aQAgentArray[i].setProtocol(aQjmsAgentArray[i].getProtocol());
                    }
                    object.setRecipientList(aQAgentArray);
                } else {
                    AQjmsOracleDebug.trace(5, "AQjmsProducer.jdbcEnqueueSh", "recipient list not specified");
                }
                int n3 = 0;
                n3 = l == 0L || l == -1L ? -1 : (int)l / 1000;
                object.setExpiration(n3);
                jMSEnqueueOptions = new JMSEnqueueOptions();
                jMSEnqueueOptions.setRetrieveMessageId(true);
                int n4 = 0;
                n4 = bl ? 1 : 2;
                jMSEnqueueOptions.setVisibility(AQjmsConstants.toJmsEnqueueVisibilityEnum(n4));
                AQjmsOracleDebug.trace(5, "AQjmsProducer.jdbcEnqueueSh", "visibility: " + n4);
                AQjmsOracleDebug.trace(5, "AQjmsProducer.jdbcEnqueueSh", "JMS delivery mode: " + n);
                int n5 = this.deliveryModeFromJMSToAQ(n);
                AQjmsOracleDebug.trace(5, "AQjmsProducer.jdbcEnqueueSh", "AQ delivery mode: " + n5);
                jMSEnqueueOptions.setDeliveryMode(AQjmsConstants.toJmsEnqueueDeliveryModeEnum(n5));
                JMSMessageProperties jMSMessageProperties = JMSFactory.createJMSMessageProperties();
                String string = aQjmsMessage.getUserProperties();
                jMSMessageProperties.setUserProperties(string);
                String string2 = aQjmsMessage.getJmsHeaders(n);
                jMSMessageProperties.setHeaderProperties(string2);
                JMSMessageProperties.JMSMessageType jMSMessageType = this.getTypeEnumOfJMSMessage(aQjmsMessage);
                AQjmsOracleDebug.trace(5, "AQjmsProducer.jdbcEnqueueSh", "JMSMessageType: " + jMSMessageType);
                jMSMessageProperties.setJMSMessageType(jMSMessageType);
                jMSMessage = JMSFactory.createJMSMessage((JMSMessageProperties)jMSMessageProperties);
                if (aQjmsMessage != null && aQjmsMessage.getInputStream() != null) {
                    if (n == 1) {
                        AQjmsError.throwEx(247);
                    }
                    if (aQjmsMessage.getBytesCont() != null) {
                        if (aQjmsMessage instanceof BytesMessage && aQjmsMessage.getBytesCont().length > 0) {
                            AQjmsError.throwEx(251);
                        }
                        if (aQjmsMessage instanceof StreamMessage && aQjmsMessage.getBytesCont().length > 4) {
                            AQjmsError.throwEx(251);
                        }
                    }
                    inputStream = aQjmsMessage.getInputStream();
                    try {
                        pushbackInputStream = new PushbackInputStream(inputStream, 1);
                        int n6 = pushbackInputStream.read();
                        if (n6 == -1) {
                            AQjmsOracleDebug.trace(5, "AQjmsProducer.jdbcEnqueueSh", "Streaming Enqueue with empty inputstream");
                            if (aQjmsMessage instanceof StreamMessage && aQjmsMessage.getBytesCont().length == 4) {
                                jMSMessage.setPayload(aQjmsMessage.getBytesCont());
                            }
                            break block44;
                        }
                        pushbackInputStream.unread(n6);
                        AQjmsOracleDebug.trace(5, "AQjmsProducer.jdbcEnqueueSh", "Streaming Enqueue");
                        jMSMessage.setPayload((InputStream)pushbackInputStream);
                    }
                    catch (IOException iOException) {
                        AQjmsError.throwEx(157, (Throwable)iOException);
                    }
                } else {
                    jMSMessage.setPayload(aQjmsMessage.getBytesCont());
                }
            }
            oracleConnection.jmsEnqueue((String)object2, jMSEnqueueOptions, jMSMessage, (AQMessageProperties)object);
            byArray = jMSMessage.getMessageId();
            aQjmsMessage.setJMSMessageID(byArray);
            aQjmsMessage.setJMSDestination((Destination)aQjmsDestination);
            aQjmsMessage.setJMSDeliveryMode(n);
            if (l == 0L || l == -1L) {
                aQjmsMessage.setJMSExpiration(0L);
            } else {
                aQjmsMessage.setJMSExpiration(l2 + l);
            }
            aQjmsMessage.setJMSPriority(n2);
            if (message != aQjmsMessage) {
                AQjmsProducer.copyAQjmsMessageSendHeaders(aQjmsMessage, message);
            }
            if (!this.jms_sess.isInTransactionRechecked()) {
                this.jms_sess.forceCommit();
            }
        }
        catch (SQLException sQLException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsProducer.jdbcEnqueueSh", sQLException);
            if (sQLException.getErrorCode() != 24033) {
                throw new AQjmsException(sQLException);
            }
        }
        finally {
            try {
                this.unlock("jdbcEnqueueSh");
            }
            catch (Throwable throwable) {}
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (pushbackInputStream != null) {
                    pushbackInputStream.close();
                }
            }
            catch (IOException iOException) {}
            AQjmsOracleDebug.trace(3, "AQjmsProducer.jdbcEnqueueSh", "exit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void enqueue(AQjmsDestination aQjmsDestination, Message message, int n, int n2, long l, Integer n3, byte[] byArray, boolean bl, AQjmsAgent[] aQjmsAgentArray) throws JMSException {
        Connection connection = null;
        AQjmsConnection aQjmsConnection = null;
        AQjmsMessageHeaderExt aQjmsMessageHeaderExt = null;
        AQjmsPropertyList aQjmsPropertyList = null;
        String string = "";
        OracleCallableStatement oracleCallableStatement = null;
        AQjmsAgent aQjmsAgent = null;
        byte[] byArray2 = null;
        long l2 = 0L;
        long l3 = 0L;
        Map<String, Class<?>> map = null;
        OracleArray oracleArray = null;
        Object object = null;
        String string2 = null;
        String string3 = null;
        int n4 = 0;
        AQjmsAgent aQjmsAgent2 = null;
        AQjmsSignature aQjmsSignature = null;
        int n5 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        Message message2 = null;
        boolean bl4 = false;
        String string4 = null;
        boolean bl5 = true;
        String string5 = "START";
        Date date = new Date();
        AQjmsOracleDebug.trace(4, "AQjmsProducer.enqueue", "entry");
        if (message == null) {
            AQjmsError.throwEx(133);
        }
        if (!this.lock("enqueue", -1L)) {
            AQjmsError.throwEx(122);
        }
        try {
            boolean bl6;
            message2 = message;
            message = AQjmsProducer.convertForeignMessage(this.jms_sess, message);
            string4 = this.getAdtType(aQjmsDestination);
            boolean bl7 = aQjmsDestination.isSharded();
            AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "isSharded: " + bl7);
            if (!bl7) {
                if (message instanceof AQjmsMessage && ((AQjmsMessage)message).getInputStream() != null) {
                    AQjmsError.throwInvalidDestEx(245);
                }
                if (((AQjmsMessage)(message = AQjmsProducer.convertHeaderMessage(message, string4))).isJMSBody() && this.jms_sess.getCompliant()) {
                    n2 = AQjmsMessage.toJMSPriority(n2);
                }
                if (((AQjmsMessage)message).isHeaderOnly()) {
                    ((AQjmsMessage)message).setStringProperty2("JMS_OracleHeaderOnly", "yes");
                }
                if (!(message instanceof AQjmsAdtMessage)) {
                    ((AQjmsMessage)message).setStringProperty2("JMS_OracleDeliveryMode", "" + n);
                }
            }
            if (aQjmsDestination.isTopic() && !(message instanceof AQjmsAdtMessage)) {
                ((AQjmsMessage)message).setStringProperty2("JMS_OracleConnectionID", this.connection_id);
            }
            message.setJMSTimestamp(date.getTime());
            if (aQjmsDestination == null) {
                AQjmsError.throwEx(127);
            }
            aQjmsConnection = this.jms_sess.getJmsConnection();
            if (!bl7) {
                bl3 = string4.equalsIgnoreCase("SYS.ANYDATA");
                bl4 = this.useTempLobs(bl);
            }
            boolean bl8 = bl6 = this.jms_sess.hasOciAQContext() && !(message instanceof AQjmsAdtMessage) && !bl3;
            if (!bl7) {
                this.checkMessageType(string4, message, bl6);
            }
            string = aQjmsDestination.getCompleteName();
            AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "q_name: " + string);
            l3 = l == 0L || l == -1L ? -1L : l / 1000L;
            connection = this.jms_sess.getDBConnection();
            map = connection.getTypeMap();
            if (!(message instanceof AQjmsAdtMessage)) {
                aQjmsMessageHeaderExt = ((AQjmsMessage)message).getMessageHeaderExt();
                if (aQjmsMessageHeaderExt.getReplyto() == null) {
                    aQjmsAgent2 = new AQjmsAgent(" ", null, 0);
                    aQjmsMessageHeaderExt.setReplyto(aQjmsAgent2);
                }
                string2 = aQjmsConnection.getUserName();
                aQjmsMessageHeaderExt.setUserid(string2);
                if (!bl7) {
                    aQjmsPropertyList = AQjmsMessage.convertHashtableToPropertyList(((AQjmsMessage)message).getPropertiesHashtable());
                    aQjmsMessageHeaderExt.setProperties(aQjmsPropertyList);
                }
            }
            n4 = ((AQjmsMessage)message).getDelay();
            string3 = ((AQjmsMessage)message).getExceptionQueue();
            aQjmsSignature = ((AQjmsMessage)message).getSignature();
            bl2 = "SYS.AQ$_JMS_MESSAGE".equalsIgnoreCase(string4);
            AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "JMS delivery mode: " + n);
            int n6 = this.deliveryModeFromJMSToAQ(n);
            int n7 = bl ? 1 : 2;
            AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "AQ delivery mode: " + n6);
            if (!bl7) {
                if (n7 != 1) {
                    n6 = 1;
                }
                ((AQjmsMessage)message).validateUserProperties();
            }
            AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "visibility: " + n7);
            if (bl6) {
                long[] lArray = this.jms_sess.getOCIHandles();
                int n8 = this.getTypeCodeOfJMSMessage(message);
                AQjmsOracleDebug.println("Context: " + this.jms_sess.oci_aq_cntxt);
                if (aQjmsDestination.isSharded()) {
                    String string6 = ((AQjmsMessage)message).getUserProperties();
                    String string7 = ((AQjmsMessage)message).getJmsHeaders(n);
                    byte[] byArray3 = ((AQjmsMessage)message).getBytesCont();
                    this.ocienq2(string, message, n8, bl2, n2, n7, n6, l3, aQjmsAgentArray, lArray, this.jms_sess.oci_aq_cntxt, this.transfxm, string7, string6, byArray3);
                    ((AQjmsMessage)message).setWriteLobLater(false);
                } else {
                    this.ocienq(string, message, n8, bl2, n2, n7, n6, l3, aQjmsAgentArray, lArray, this.jms_sess.oci_aq_cntxt, this.transfxm);
                }
                string5 = "MESSAGE_INSERTED";
                byArray2 = ((AQjmsMessage)message).getJMSMessageIDAsBytes();
                AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "message id: " + message.getJMSMessageID());
            } else {
                try {
                    map.put("SYS.AQ$_AGENT", Class.forName("oracle.AQ.AQOracleAgent"));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    AQjmsError.throwEx("Unable to put the oracle.AQ.AQOracleAgent class into sql map", (Throwable)classNotFoundException);
                }
                AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "message type: " + message.getClass().getName());
                int n9 = 0;
                if (message instanceof AQjmsAdtMessage) {
                    object = ((AQjmsAdtMessage)message).getAdtPayload();
                    if (object == null) {
                        AQjmsError.throwEx(104);
                    }
                    AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "co_payload: " + object.getClass().getName());
                    if (aQjmsAgentArray != null && aQjmsAgentArray.length > 0) {
                        AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "recipient list specified");
                        oracleCallableStatement = this.jms_sess.getAdtStmt();
                        n9 = 2;
                    } else {
                        AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "recipient list not specified");
                        oracleCallableStatement = this.jms_sess.getAdtNoRecplStmt();
                        n9 = 3;
                    }
                } else if (message instanceof AQjmsMessage) {
                    oracleCallableStatement = this.jms_sess.getEnqueueStmt(message);
                    n9 = 1;
                } else {
                    AQjmsError.throwEx(129);
                }
                oracleCallableStatement.setString(this.getIndex(n9, "queue_name"), string);
                AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "set queue_name: " + string);
                aQjmsAgent = ((AQjmsMessage)message).getSenderID();
                if (aQjmsAgent != null) {
                    oracleCallableStatement.setString(this.getIndex(n9, "sender_name"), aQjmsAgent.getName());
                    oracleCallableStatement.setString(this.getIndex(n9, "sender_addr"), aQjmsAgent.getAddress());
                    oracleCallableStatement.setInt(this.getIndex(n9, "sender_protocol"), aQjmsAgent.getProtocol());
                    AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "set sender_name: " + aQjmsAgent.getName() + "\nset sender_addr: " + aQjmsAgent.getAddress() + "\nset sender_protocol: " + aQjmsAgent.getProtocol());
                } else {
                    oracleCallableStatement.setString(this.getIndex(n9, "sender_name"), null);
                    oracleCallableStatement.setString(this.getIndex(n9, "sender_addr"), null);
                    oracleCallableStatement.setInt(this.getIndex(n9, "sender_protocol"), 0);
                    AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "set sender_name: null\nset sender_addr: null\nset sender_protocol: null");
                }
                oracleCallableStatement.setNull(this.getIndex(n9, "original_msgid"), -2);
                AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "set original_msgid: null");
                oracleCallableStatement.setString(this.getIndex(n9, "correlation"), message.getJMSCorrelationID());
                AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "set correlation: " + message.getJMSCorrelationID());
                oracleCallableStatement.setObject(this.getIndex(n9, "visibility"), (Object)n7, 4);
                AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "set visibility: " + n7);
                oracleCallableStatement.setObject(this.getIndex(n9, "priority"), (Object)n2, 4);
                AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "set priority: " + n2);
                oracleCallableStatement.setObject(this.getIndex(n9, "delay"), (Object)n4, 4);
                AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "set delay: " + n4);
                oracleCallableStatement.setLong(this.getIndex(n9, "expiration"), l3);
                AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "set expiration: " + l3);
                if (n3 != null) {
                    if (n3 == 2 || n3 == 3) {
                        oracleCallableStatement.setObject(this.getIndex(n9, "sequence_deviation"), (Object)n3, 4);
                        if (byArray != null) {
                            oracleCallableStatement.setObject(this.getIndex(n9, "relative_msgid"), (Object)byArray, -2);
                        } else {
                            oracleCallableStatement.setNull(this.getIndex(n9, "relative_msgid"), -2);
                        }
                        AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "set seq_deviation: " + n3 + "\nset relative_msgid: " + byArray);
                    } else {
                        AQjmsError.throwEx(154);
                    }
                } else {
                    oracleCallableStatement.setNull(this.getIndex(n9, "sequence_deviation"), 2);
                    oracleCallableStatement.setNull(this.getIndex(n9, "relative_msgid"), -2);
                    AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "set seq_deviation: null\nset relative_msgid: null");
                }
                oracleCallableStatement.setString(this.getIndex(n9, "exception_queue"), string3);
                AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "set exception_queue: " + string3);
                oracleCallableStatement.setObject(this.getIndex(n9, "payload_type"), (Object)1, 4);
                AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "set payload_type: 1");
                oracleCallableStatement.registerOutParameter(this.getIndex(n9, "msgid"), -2);
                AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "register out parameter msgid.");
                n5 = this.getIndex(n9, "recipients");
                if (n5 != -1) {
                    if (aQjmsAgentArray != null && aQjmsAgentArray.length > 0) {
                        oracleArray = this.createRecpArrayfromAgentList(aQjmsAgentArray);
                        oracleCallableStatement.setObject(n5, (Object)oracleArray, 2003);
                    } else {
                        oracleCallableStatement.setNull(n5, 2003, "SYS.AQ$_RECIPIENTS");
                    }
                    AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "set recipients: " + aQjmsAgentArray);
                }
                if ((n5 = this.getIndex(n9, "object_user_data")) != -1) {
                    if (object instanceof CustomDatum) {
                        oracleCallableStatement.setCustomDatum(n5, (CustomDatum)object);
                    } else if (object instanceof OracleData) {
                        oracleCallableStatement.setObject(n5, (Object)((OracleData)object));
                    } else if (object instanceof ORAData) {
                        oracleCallableStatement.setObject(n5, (Object)((ORAData)object));
                    } else {
                        AQjmsError.throwEx(129);
                    }
                    AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "set object_user_data: " + object);
                }
                if ((n5 = this.getIndex(n9, "jms_message")) != -1) {
                    oracleCallableStatement.setObject(n5, (Object)((AQjmsMessage)message).getMessageCont(this.jms_sess, bl4, false));
                    bl5 = ((AQjmsMessage)message).getWriteLobLater();
                    AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "set jms_message: " + message);
                }
                if ((n5 = this.getIndex(n9, "signature")) != -1) {
                    if (aQjmsSignature != null) {
                        oracleCallableStatement.setObject(n5, (Object)aQjmsSignature);
                    } else {
                        oracleCallableStatement.setNull(n5, 2002, "SYS.AQ$_SIG_PROP");
                    }
                    AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "set signature: " + aQjmsSignature);
                }
                if ((n5 = this.getIndex(n9, "transformation")) != -1) {
                    oracleCallableStatement.setString(n5, this.transfxm);
                    AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "set transformation: " + this.transfxm);
                }
                if ((n5 = this.getIndex(n9, "gen_payload")) != -1) {
                    if (bl2) {
                        oracleCallableStatement.setInt(n5, 1);
                    } else {
                        oracleCallableStatement.setInt(n5, 0);
                    }
                    AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "set gen_payload: " + bl2);
                }
                if ((n5 = this.getIndex(n9, "create_new_lob")) != -1) {
                    int n10 = bl5 ? 1 : 0;
                    oracleCallableStatement.setObject(n5, (Object)n10, 4);
                    AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "set create_new_lob: " + n10);
                }
                if ((n5 = this.getIndex(n9, "delivery_mode")) != -1) {
                    oracleCallableStatement.setInt(n5, n6);
                    AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "set AQ delivery_mode: " + n6);
                }
                long l4 = System.currentTimeMillis();
                oracleCallableStatement.execute();
                long l5 = System.currentTimeMillis();
                string5 = "MESSAGE_INSERTED";
                AQjmsOracleDebug.trace(1, "AQjmsProducer.enqueue", "execute Query " + (l5 - l4) + " msecs");
                byArray2 = oracleCallableStatement.getBytes(this.getIndex(n9, "msgid"));
                ((AQjmsMessage)message).setJMSMessageID(byArray2);
            }
            if (((AQjmsMessage)message).getWriteLobLater()) {
                ((AQjmsMessage)message).writeLob(this.jms_sess, aQjmsDestination.getCompleteTableName(), byArray2, bl3);
            }
            string5 = "LOB_WRITTEN";
            byArray2 = ((AQjmsMessage)message).getJMSMessageIDAsBytes();
            message.setJMSDestination((Destination)aQjmsDestination);
            message.setJMSDeliveryMode(n);
            if (l == 0L || l == -1L) {
                message.setJMSExpiration(0L);
            } else {
                l2 = date.getTime() + l3 * 1000L;
                message.setJMSExpiration(l2);
            }
            message.setJMSPriority(n2);
            ((AQjmsMessage)message).setDelay(n4);
            ((AQjmsMessage)message).setExceptionQueue(string3);
            if (message2 != message) {
                AQjmsProducer.copyAQjmsMessageSendHeaders(message, message2);
            }
            string5 = "SEND_COMPLETED";
            if (!this.jms_sess.isInTransactionRechecked()) {
                this.jms_sess.forceCommit();
            }
        }
        catch (SQLException sQLException) {
            try {
                if (oracleCallableStatement != null) {
                    this.jms_sess.destroyStmt(oracleCallableStatement);
                }
            }
            catch (Exception exception) {
                AQjmsOracleDebug.traceEx(5, "AQjmsProducer.enqueue-ex2", exception);
            }
            AQjmsOracleDebug.traceEx(3, "AQjmsProducer.enqueue-ex", sQLException);
            if (sQLException.getErrorCode() != 24033) {
                throw new AQjmsException(sQLException);
            }
        }
        catch (JMSException jMSException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsProducer.enqueue-ex", jMSException);
            throw jMSException;
        }
        catch (Exception exception) {
            AQjmsOracleDebug.traceEx(3, "AQjmsProducer.enqueue-ex", exception);
            AQjmsError.throwEx(122, (Throwable)exception);
        }
        finally {
            if (string5.equals("MESSAGE_INSERTED")) {
                try {
                    if (!this.jms_sess.isInTransactionRechecked()) {
                        this.jms_sess.forceRollback();
                    } else if (!this.purgeEmptyMessage(aQjmsDestination.getCompleteName(), byArray2)) {
                        this.jms_sess.setConsistency(false);
                    }
                }
                catch (Throwable throwable) {}
            }
            try {
                ((AQjmsMessage)message).messageSendCallback(false);
            }
            catch (AQjmsTempLobTruncateException aQjmsTempLobTruncateException) {
                if (aQjmsTempLobTruncateException.isBlob()) {
                    this.jms_sess.cachedTempBlob = null;
                } else {
                    this.jms_sess.cachedTempClob = null;
                }
            }
            catch (Throwable throwable) {}
            try {
                this.unlock("enqueue");
            }
            catch (Throwable throwable) {}
            AQjmsOracleDebug.trace(4, "AQjmsProducer.enqueue", "exit");
        }
    }

    private boolean purgeEmptyMessage(String string, byte[] byArray) {
        AQjmsOracleDebug.trace(3, "AQjmsProducer.purgeEmptyMessage", "enter");
        boolean bl = true;
        try {
            Connection connection = this.jms_sess.getDBConnection();
            String string2 = "begin dbms_aqjms.aq$_purge_message(queue_name => ?, msgid => ?); end; ";
            AQjmsOracleDebug.trace(3, "AQjmsProducer.purgeEmptyMessage", "the purge statement:\n" + string2);
            CallableStatement callableStatement = connection.prepareCall(string2);
            callableStatement.setString(1, string);
            callableStatement.setBytes(2, byArray);
            callableStatement.execute();
            AQjmsOracleDebug.trace(3, "AQjmsProducer.purgeEmptyMessage", "purging the empty message is successful");
        }
        catch (Exception exception) {
            AQjmsOracleDebug.traceEx(1, "AQjmsProducer.purgeEmptyMessage encountered exception", exception);
            bl = false;
        }
        AQjmsOracleDebug.trace(3, "AQjmsProducer.purgeEmptyMessage", "exit: success=" + bl);
        return bl;
    }

    private int deliveryModeFromJMSToAQ(int n) {
        if (n == 2) {
            return 1;
        }
        return 2;
    }

    private int getIndex(int n, String string) throws JMSException {
        int n2 = AQjmsInterOp.getEnqueueStmtIndex(this.jms_sess.getDBVersion(), n, string);
        if (n2 != -1) {
            AQjmsOracleDebug.trace(5, "AQjmsProducer.getIndex", "parameter: " + string + ", index: " + n2);
        }
        return n2;
    }

    public synchronized Topic getTopic() throws JMSException {
        this.checkClosed("getTopic");
        if (this.type == 20) {
            return this.prod_dest;
        }
        AQjmsError.throwEx(107, "QueueReceiver");
        return null;
    }

    public synchronized void publish(Message message) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-1", "entry");
        this.checkClosed("publish");
        if (this.type != 20) {
            AQjmsError.throwEx(107, "QueueSender");
        }
        if (this.prod_dest == null) {
            throw new UnsupportedOperationException("publish is called without a valid Topic");
        }
        this.publish(this.prod_dest, message, this.del_mode, this.m_priority, this.m_timetolive, null, null, false, null);
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-1", "exit");
    }

    public synchronized void publish(Message message, int n, int n2, long l) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-2", "entry");
        this.checkClosed("publish(msg,mode,prio,ttl)");
        if (this.type != 20) {
            AQjmsError.throwEx(107, "QueueSender");
        }
        if (this.prod_dest == null) {
            throw new UnsupportedOperationException("publish is called without a valid Topic");
        }
        this.publish(this.prod_dest, message, n, n2, l, null, null, false, null);
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-2", "exit");
    }

    public synchronized void publish(Topic topic, Message message) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-3", "entry");
        this.publish(topic, message, this.del_mode, this.m_priority, this.m_timetolive, null, null, false, null);
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-3", "exit");
    }

    public synchronized void publish(Topic topic, Message message, int n, int n2, long l) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-4", "entry");
        this.publish(topic, message, n, n2, l, null, null, false, null);
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-4", "exit");
    }

    public synchronized void bufferPublish(Topic topic, Message message, int n, long l) throws JMSException {
        if (((AQjmsDestination)topic).isSharded()) {
            AQjmsError.throwEx(244, "bufferPublish");
        }
        AQjmsOracleDebug.trace(4, "AQjmsProducer.bufferPublish", "entry");
        this.publish(topic, message, 1, n, l, null, null, true, null);
        AQjmsOracleDebug.trace(4, "AQjmsProducer.bufferPublish", "exit");
    }

    synchronized void publish(Topic topic, Message message, int n, int n2, long l, Integer n3, byte[] byArray, boolean bl, AQjmsAgent[] aQjmsAgentArray) throws JMSException {
        AQjmsDestination aQjmsDestination = null;
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-5", "entry");
        this.checkClosed("publish(t,msg,mode,prio,ttl,seq..)");
        if (message == null) {
            AQjmsError.throwEx(133);
        }
        if (topic == null) {
            if (this.prod_dest == null || this.prod_dest.getTopicName() == null) {
                AQjmsError.throwInvalidDestEx(166);
            } else {
                aQjmsDestination = this.prod_dest;
            }
        } else if (topic instanceof AQjmsDestination) {
            AQjmsOracleDebug.trace(5, "AQjmsProducer.publish", "topic: " + ((AQjmsDestination)topic).getCompleteName());
            aQjmsDestination = (AQjmsDestination)topic;
        } else {
            AQjmsError.throwInvalidDestEx(166);
        }
        if (AQjmsConstants.useJdbcAQ() && this.jms_sess.getDriver().equalsIgnoreCase("thin") && !this.isXMLType(message)) {
            if (aQjmsDestination.isSharded()) {
                this.jdbcEnqueueSh(aQjmsDestination, message, n, n2, l, bl, aQjmsAgentArray);
            } else {
                this.jdbcEnqueue(aQjmsDestination, message, n, n2, l, n3, byArray, bl, aQjmsAgentArray);
            }
        } else {
            this.enqueue(aQjmsDestination, message, n, n2, l, n3, byArray, bl, aQjmsAgentArray);
        }
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-5", "exit");
    }

    public synchronized void publish(Message message, AQjmsAgent[] aQjmsAgentArray) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-6", "entry");
        this.checkClosed("publish(msg,rcplist)");
        if (this.type != 20) {
            AQjmsError.throwEx(107, "QueueSender");
        }
        if (this.prod_dest == null) {
            throw new UnsupportedOperationException("publish is called without a valid Topic");
        }
        this.publish(this.prod_dest, message, this.del_mode, this.m_priority, this.m_timetolive, null, null, false, aQjmsAgentArray);
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-6", "exit");
    }

    public synchronized void publish(Topic topic, Message message, AQjmsAgent[] aQjmsAgentArray) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-7", "entry");
        this.publish(topic, message, this.del_mode, this.m_priority, this.m_timetolive, null, null, false, aQjmsAgentArray);
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-7", "exit");
    }

    public synchronized void publish(Message message, AQjmsAgent[] aQjmsAgentArray, int n, int n2, long l) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-8", "entry");
        if (this.type != 20) {
            AQjmsError.throwEx(107, "QueueSender");
        }
        if (this.prod_dest == null) {
            throw new UnsupportedOperationException("publish is called without a valid Topic");
        }
        this.publish(this.prod_dest, message, n, n2, l, null, null, false, aQjmsAgentArray);
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-8", "exit");
    }

    public synchronized void publish(Topic topic, Message message, AQjmsAgent[] aQjmsAgentArray, int n, int n2, long l) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-9", "entry");
        this.publish(topic, message, n, n2, l, null, null, false, aQjmsAgentArray);
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-9", "exit");
    }

    private OracleArray createRecpArrayfromAgentList(AQjmsAgent[] aQjmsAgentArray) throws JMSException {
        Connection connection = null;
        Object[] objectArray = null;
        OracleArray oracleArray = null;
        int n = 0;
        AQOracleAgent aQOracleAgent = null;
        AQjmsAgent aQjmsAgent = null;
        int n2 = 0;
        int n3 = 0;
        AQjmsOracleDebug.trace(5, "AQjmsProducer.createRecpArrayfromAgentList", "entry");
        if (aQjmsAgentArray == null || aQjmsAgentArray.length == 0) {
            AQjmsError.throwEx(145);
        }
        n = aQjmsAgentArray.length;
        objectArray = new Object[n];
        try {
            for (n2 = 0; n2 < n; ++n2) {
                aQjmsAgent = aQjmsAgentArray[n2];
                if (aQjmsAgent == null) {
                    n3 = n2 + 1;
                    AQjmsError.throwEx(201);
                }
                aQOracleAgent = new AQOracleAgent(aQjmsAgent.getName(), aQjmsAgent.getAddress(), aQjmsAgent.getProtocol());
                AQjmsOracleDebug.trace(5, "AQjmsProducer", "recp[" + n2 + "]: " + aQjmsAgent.getName() + "::" + aQjmsAgent.getAddress() + "::" + aQjmsAgent.getProtocol());
                objectArray[n2] = aQOracleAgent;
            }
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
        try {
            connection = this.jms_sess.getDBConnection();
        }
        catch (Exception exception) {
            AQjmsError.throwEx(112, (Throwable)exception);
        }
        try {
            oracleArray = (OracleArray)((oracle.jdbc.OracleConnection)connection).createOracleArray("SYS.AQ$_RECIPIENTS", (Object)objectArray);
        }
        catch (SQLException sQLException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsProducer.createRecpArrayfromAgentList", sQLException);
            throw new AQjmsException(sQLException);
        }
        AQjmsOracleDebug.trace(5, "AQjmsProducer.createRecpArrayfromAgentList", "exit");
        return oracleArray;
    }

    @Override
    public void close() throws JMSException {
        super.close();
    }

    @Override
    protected synchronized void localClose() throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsProducer.localClose", "ENTRY");
        this.jms_sess = null;
        AQjmsOracleDebug.trace(4, "AQjmsProducer.localClose", "EXIT");
    }

    boolean isProducerClosed() {
        if (this.jms_sess == null) {
            AQjmsOracleDebug.trace(5, "AQjmsProducer.isProducerClosed", "Producer closed");
            return true;
        }
        return false;
    }

    void checkMessageType(String string, Message message, boolean bl) throws JMSException {
        boolean bl2;
        AQjmsOracleDebug.trace(5, "AQjmsProducer.checkMessageType", "adt type: " + string);
        AQjmsOracleDebug.trace(5, "AQjmsProducer.checkMessageType", "message_class: " + message.getClass().getName());
        boolean bl3 = string.equalsIgnoreCase("SYS.AQ$_JMS_MESSAGE");
        boolean bl4 = bl2 = bl3 && (bl || this.jms_sess.hasGenMsgSupport());
        if (message instanceof AQjmsTextMessage) {
            if (!(string.equalsIgnoreCase("SYS.AQ$_JMS_TEXT_MESSAGE") || string.equalsIgnoreCase("SYS.ANYDATA") || bl2)) {
                AQjmsError.throwEx(108, "TextMessage", string);
            }
        } else if (message instanceof AQjmsBytesMessage) {
            if (!(string.equalsIgnoreCase("SYS.AQ$_JMS_BYTES_MESSAGE") || string.equalsIgnoreCase("SYS.ANYDATA") || bl2)) {
                AQjmsError.throwEx(108, "BytesMessage", string);
            }
        } else if (message instanceof AQjmsStreamMessage) {
            if (!(string.equalsIgnoreCase("SYS.AQ$_JMS_STREAM_MESSAGE") || string.equalsIgnoreCase("SYS.ANYDATA") || bl2)) {
                AQjmsError.throwEx(108, "StreamMessage", string);
            }
        } else if (message instanceof AQjmsMapMessage) {
            if (!(string.equalsIgnoreCase("SYS.AQ$_JMS_MAP_MESSAGE") || string.equalsIgnoreCase("SYS.ANYDATA") || bl2)) {
                AQjmsError.throwEx(108, "MapMessage", string);
            }
        } else if (message instanceof AQjmsObjectMessage) {
            if (!(string.equalsIgnoreCase("SYS.AQ$_JMS_OBJECT_MESSAGE") || string.equalsIgnoreCase("SYS.ANYDATA") || bl2)) {
                AQjmsError.throwEx(108, "ObjectMessage", string);
            }
        } else if (message instanceof AQjmsAdtMessage) {
            if (string.equalsIgnoreCase("SYS.AQ$_JMS_MESSAGE") || string.equalsIgnoreCase("SYS.AQ$_JMS_TEXT_MESSAGE") || string.equalsIgnoreCase("SYS.AQ$_JMS_BYTES_MESSAGE") || string.equalsIgnoreCase("SYS.AQ$_JMS_MAP_MESSAGE") || string.equalsIgnoreCase("SYS.AQ$_JMS_OBJECT_MESSAGE") || string.equalsIgnoreCase("SYS.AQ$_JMS_STREAM_MESSAGE")) {
                AQjmsError.throwEx(108, "AdtMessage", string);
            }
        } else {
            AQjmsError.throwEx(108, message.getClass().getName(), string);
        }
    }

    private static Message convertHeaderMessage(Message message, String string) throws JMSException {
        if (message instanceof AQjmsMessage && ((AQjmsMessage)message).isHeaderOnly()) {
            if (string.equalsIgnoreCase("SYS.AQ$_JMS_TEXT_MESSAGE")) {
                return new AQjmsTextMessage((AQjmsMessage)message);
            }
            if (string.equalsIgnoreCase("SYS.AQ$_JMS_BYTES_MESSAGE") || string.equalsIgnoreCase("SYS.ANYDATA") || string.equalsIgnoreCase("SYS.AQ$_JMS_MESSAGE")) {
                return new AQjmsBytesMessage((AQjmsMessage)message);
            }
            if (string.equalsIgnoreCase("SYS.AQ$_JMS_STREAM_MESSAGE")) {
                return new AQjmsStreamMessage((AQjmsMessage)message);
            }
            if (string.equalsIgnoreCase("SYS.AQ$_JMS_MAP_MESSAGE")) {
                return new AQjmsMapMessage((AQjmsMessage)message);
            }
            if (string.equalsIgnoreCase("SYS.AQ$_JMS_OBJECT_MESSAGE")) {
                return new AQjmsObjectMessage((AQjmsMessage)message);
            }
        }
        return message;
    }

    private static Message convertForeignMessage(AQjmsSession aQjmsSession, Message message) throws JMSException {
        Object object;
        Object object2;
        if (message == null || message instanceof AQjmsMessage) {
            return message;
        }
        Object object3 = null;
        object3 = message instanceof BytesMessage ? aQjmsSession.createBytesMessage() : (message instanceof MapMessage ? aQjmsSession.createMapMessage() : (message instanceof ObjectMessage ? aQjmsSession.createObjectMessage() : (message instanceof StreamMessage ? aQjmsSession.createStreamMessage() : (message instanceof TextMessage ? aQjmsSession.createTextMessage() : aQjmsSession.createMessage()))));
        AQjmsProducer.copyForeignClientHeaders(message, (Message)object3);
        Enumeration enumeration = message.getPropertyNames();
        while (enumeration != null && enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            if (object2 == null || (object = (Object)message.getObjectProperty((String)object2)) == null) continue;
            if (!AQjmsMessage.isSystemProperty((String)object2)) {
                object3.setObjectProperty((String)object2, object);
                continue;
            }
            if (!AQjmsMessage.isSettableSystemProperty((String)object2)) continue;
            object3.setObjectProperty((String)object2, object);
        }
        if (message instanceof BytesMessage) {
            ((BytesMessage)message).reset();
            int n = 0;
            object = new byte[1024];
            while ((n = ((BytesMessage)message).readBytes(object)) != -1) {
                object3.writeBytes(object, 0, n);
            }
        } else if (message instanceof MapMessage) {
            object2 = ((MapMessage)message).getMapNames();
            while (object2 != null && object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                ((MapMessage)object3).setObject((String)object, ((MapMessage)message).getObject((String)object));
            }
        } else if (message instanceof ObjectMessage) {
            object2 = ((ObjectMessage)message).getObject();
            if (object2 != null) {
                ((ObjectMessage)object3).setObject((Serializable)object2);
            }
        } else if (message instanceof StreamMessage) {
            ((StreamMessage)message).reset();
            try {
                object2 = null;
                while ((object2 = ((StreamMessage)message).readObject()) != null) {
                    ((StreamMessage)object3).writeObject(object2);
                }
            }
            catch (MessageEOFException messageEOFException) {}
        } else if (message instanceof TextMessage && (object2 = ((TextMessage)message).getText()) != null) {
            ((TextMessage)object3).setText((String)object2);
        }
        return object3;
    }

    private static void copyAQjmsMessageSendHeaders(Message message, Message message2) throws JMSException {
        try {
            message2.setJMSDestination(message.getJMSDestination());
        }
        catch (JMSException jMSException) {
            AQjmsOracleDebug.traceEx(5, "Foreign message does not accept an AQ destination as the JMSDestination header -> ignored", jMSException);
        }
        message2.setJMSDeliveryMode(message.getJMSDeliveryMode());
        message2.setJMSExpiration(message.getJMSExpiration());
        message2.setJMSPriority(message.getJMSPriority());
        message2.setJMSMessageID(message.getJMSMessageID());
        message2.setJMSTimestamp(message.getJMSTimestamp());
    }

    private static void copyForeignClientHeaders(Message message, Message message2) throws JMSException {
        message2.setJMSCorrelationID(message.getJMSCorrelationID());
        try {
            Destination destination = message.getJMSReplyTo();
            if (destination instanceof AQjmsDestination || destination instanceof AQjmsAgent) {
                message2.setJMSReplyTo(destination);
            } else if (destination != null) {
                AQjmsOracleDebug.trace(5, "AQjmsProducer.copyForeignClientHeaders", "Skip copying foreign JMSReplyTo header " + destination);
            }
        }
        catch (JMSException jMSException) {
            AQjmsOracleDebug.traceEx(5, "Error copying foreign JMSReplyTo header -> ignored", jMSException);
        }
        message2.setJMSType(message.getJMSType());
    }

    public Destination getDestination() throws JMSException {
        this.checkClosed("getDestination");
        return this.prod_dest;
    }

    public void send(Destination destination, Message message) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsProducer.send-3", "entry");
        this.checkClosed("send(dest,msg)");
        if (!(destination instanceof AQjmsDestination)) {
            AQjmsError.throwInvalidDestEx(127);
        }
        if (this.prod_dest != null) {
            throw new UnsupportedOperationException("MessageProducer was assigned a destination at creation time");
        }
        if (((AQjmsDestination)destination).isQueue()) {
            this.send((Queue)destination, message, this.del_mode, this.m_priority, this.m_timetolive, null, null, false);
        } else {
            this.publish((Topic)destination, message, this.del_mode, this.m_priority, this.m_timetolive, null, null, false, null);
        }
        AQjmsOracleDebug.trace(4, "AQjmsProducer.send-3", "exit");
    }

    public void send(Destination destination, Message message, int n, int n2, long l) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsProducer.send-4", "entry");
        this.checkClosed("send(dest,msg,mode,prio,ttl)");
        if (!(destination instanceof AQjmsDestination)) {
            AQjmsError.throwInvalidDestEx(127);
        }
        if (((AQjmsDestination)destination).isQueue()) {
            this.send((Queue)destination, message, n, n2, l, null, null, false);
        } else {
            this.publish((Topic)destination, message, n, n2, l, null, null, false, null);
        }
        AQjmsOracleDebug.trace(4, "AQjmsProducer.send-4", "exit");
    }

    public synchronized void bufferSend(Destination destination, Message message, int n, long l) throws JMSException {
        if (((AQjmsDestination)destination).isSharded()) {
            AQjmsError.throwEx(244, "bufferSend");
        }
        AQjmsOracleDebug.trace(4, "AQjmsProducer.bufferSend", "entry");
        this.checkClosed("bufferSend(dest,msg,prio,ttl)");
        if (!(destination instanceof AQjmsDestination)) {
            AQjmsError.throwInvalidDestEx(127);
        }
        if (((AQjmsDestination)destination).isQueue()) {
            this.send((Queue)destination, message, 1, n, l, null, null, true);
        } else {
            this.publish((Topic)destination, message, 1, n, l, null, null, true, null);
        }
        AQjmsOracleDebug.trace(4, "AQjmsProducer.bufferSend", "exit");
    }

    synchronized void send(Destination destination, Message message, int n, int n2, long l, Integer n3, byte[] byArray, boolean bl) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsProducer.send-5", "entry");
        this.checkClosed("send(dest,msg,mode,prio,ttl, seq_deviation, relative_msg_id, visib)");
        if (!(destination instanceof AQjmsDestination)) {
            AQjmsError.throwInvalidDestEx(127);
        }
        if (((AQjmsDestination)destination).isQueue()) {
            this.send((Queue)destination, message, n, n2, l, n3, byArray, bl);
        } else {
            this.publish((Topic)destination, message, n, n2, l, n3, byArray, bl, null);
        }
        AQjmsOracleDebug.trace(4, "AQjmsProducer.send-5", "exit");
    }

    public void bulkSend(Message[] messageArray) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsProducer.bulkSend-1", "entry");
        this.checkClosed("bulkSend");
        if (this.type != 10 && this.type != 30) {
            AQjmsError.throwEx(107, "TopicPublisher");
        }
        if (this.prod_dest == null) {
            throw new UnsupportedOperationException("bulkSend is called without a valid Destination");
        }
        if (this.prod_dest.isQueue()) {
            this.bulkSend(this.prod_dest, messageArray, null, null, null, null, null);
        } else {
            this.bulkPublish(this.prod_dest, messageArray, null, null, null, null, null, null);
        }
        AQjmsOracleDebug.trace(4, "AQjmsProducer.bulkSend-1", "exit");
    }

    public void bulkSend(Message[] messageArray, int[] nArray, int[] nArray2, long[] lArray) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsProducer.bulkSend-2", "entry");
        this.checkClosed("bulkSend(msg,mode,prio,ttl)");
        if (this.type != 10 && this.type != 30) {
            AQjmsError.throwEx(107, "TopicPublisher");
        }
        if (this.prod_dest == null) {
            throw new UnsupportedOperationException("bulkSend is called without a valid Destination");
        }
        if (this.prod_dest.isQueue()) {
            this.bulkSend(this.prod_dest, messageArray, nArray, nArray2, lArray, null, null);
        } else {
            this.bulkPublish(this.prod_dest, messageArray, nArray, nArray2, lArray, null, null, null);
        }
        AQjmsOracleDebug.trace(4, "AQjmsProducer.bulkSend-2", "exit");
    }

    public void bulkSend(Destination destination, Message[] messageArray) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsProducer.bulkSend-3", "entry");
        this.checkClosed("bulkSend(dest,msg)");
        if (!(destination instanceof AQjmsDestination)) {
            AQjmsError.throwInvalidDestEx(127);
        }
        if (((AQjmsDestination)destination).isQueue()) {
            this.bulkSend((Queue)destination, messageArray, null, null, null, null, null);
        } else {
            this.bulkPublish((Topic)destination, messageArray, null, null, null, null, null, null);
        }
        AQjmsOracleDebug.trace(4, "AQjmsProducer.send-3", "exit");
    }

    public void bulkSend(Destination destination, Message[] messageArray, int[] nArray, int[] nArray2, long[] lArray) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsProducer.bulkSend-4", "entry");
        this.checkClosed("bulkSend(dest,msg,mode,prio,ttl)");
        if (!(destination instanceof AQjmsDestination)) {
            AQjmsError.throwInvalidDestEx(127);
        }
        if (((AQjmsDestination)destination).isQueue()) {
            this.bulkSend((Queue)destination, messageArray, nArray, nArray2, lArray, null, null);
        } else {
            this.bulkPublish((Topic)destination, messageArray, nArray, nArray2, lArray, null, null, null);
        }
        AQjmsOracleDebug.trace(4, "AQjmsProducer.bulkSend-4", "exit");
    }

    synchronized void bulkSend(Queue queue, Message[] messageArray, int[] nArray, int[] nArray2, long[] lArray, Integer n, byte[] byArray) throws JMSException {
        AQjmsDestination aQjmsDestination = null;
        AQjmsOracleDebug.trace(4, "AQjmsProducer.send-main", "entry");
        if (messageArray == null) {
            AQjmsError.throwEx(133);
        }
        for (int i = 0; i < messageArray.length; ++i) {
            if (messageArray[i] != null) continue;
            AQjmsError.throwEx(133);
        }
        if (queue == null) {
            if (this.prod_dest == null || this.prod_dest.getQueueName() == null) {
                AQjmsError.throwInvalidDestEx(143);
            } else {
                AQjmsOracleDebug.trace(5, "AQjmsProducer.send", "prod_dest: " + this.prod_dest.getCompleteName());
                aQjmsDestination = this.prod_dest;
            }
        } else if (queue.getQueueName() != null) {
            if (queue instanceof AQjmsDestination) {
                AQjmsOracleDebug.trace(5, "AQjmsProducer.send", "queue: " + ((AQjmsDestination)queue).getCompleteName());
                aQjmsDestination = (AQjmsDestination)queue;
            } else {
                AQjmsError.throwInvalidDestEx(125);
            }
        } else {
            AQjmsError.throwInvalidDestEx(143);
        }
        AQjmsOracleDebug.trace(5, "AQjmsProducer.send", "dest_queue: " + aQjmsDestination.getCompleteName());
        this.bulkEnqueue(aQjmsDestination, messageArray, nArray, nArray2, lArray, n, byArray, null);
        AQjmsOracleDebug.trace(4, "AQjmsProducer.send-main", "exit");
    }

    private AQjmsMessageHeaderExt getHeaderWithProperties(Message message, AQjmsConnection aQjmsConnection) throws JMSException {
        AQjmsMessageHeaderExt aQjmsMessageHeaderExt = null;
        AQjmsPropertyList aQjmsPropertyList = null;
        AQjmsAgent aQjmsAgent = null;
        String string = null;
        try {
            if (!(message instanceof AQjmsAdtMessage)) {
                aQjmsMessageHeaderExt = ((AQjmsMessage)message).getMessageHeaderExt();
                if (aQjmsMessageHeaderExt.getReplyto() == null) {
                    aQjmsAgent = new AQjmsAgent(" ", null, 0);
                    aQjmsMessageHeaderExt.setReplyto(aQjmsAgent);
                }
                string = aQjmsConnection.getUserName();
                aQjmsMessageHeaderExt.setUserid(string);
                aQjmsPropertyList = AQjmsMessage.convertHashtableToPropertyList(((AQjmsMessage)message).getPropertiesHashtable());
                aQjmsMessageHeaderExt.setProperties(aQjmsPropertyList);
            }
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
        return aQjmsMessageHeaderExt;
    }

    private OracleArray convertToORADATAArray(Message[] messageArray, AQjmsDestination aQjmsDestination, AQjmsConnection aQjmsConnection, Connection connection) throws JMSException, SQLException {
        OracleArray oracleArray = null;
        AQjmsGenMessage_C[] aQjmsGenMessage_CArray = null;
        AQjmsTextMessage_C[] aQjmsTextMessage_CArray = null;
        AQjmsBytesMessage_C[] aQjmsBytesMessage_CArray = null;
        AQjmsStreamMessage_C[] aQjmsStreamMessage_CArray = null;
        AQjmsMapMessage_C[] aQjmsMapMessage_CArray = null;
        AQjmsObjectMessage_C[] aQjmsObjectMessage_CArray = null;
        String string = null;
        AQjmsMessageHeaderExt aQjmsMessageHeaderExt = null;
        string = this.getAdtType(aQjmsDestination);
        if (string.equalsIgnoreCase("SYS.AQ$_JMS_MESSAGE")) {
            aQjmsGenMessage_CArray = new AQjmsGenMessage_C[messageArray.length];
            for (int i = 0; i < messageArray.length; ++i) {
                if (messageArray[i] instanceof AQjmsTextMessage) {
                    aQjmsGenMessage_CArray[i] = ((AQjmsTextMessage)messageArray[i]).getGenMessageCont(this.jms_sess, true, true);
                } else if (messageArray[i] instanceof AQjmsBytesMessage) {
                    aQjmsGenMessage_CArray[i] = ((AQjmsBytesMessage)messageArray[i]).getGenMessageCont(this.jms_sess, true, true);
                } else if (messageArray[i] instanceof AQjmsStreamMessage) {
                    aQjmsGenMessage_CArray[i] = ((AQjmsStreamMessage)messageArray[i]).getGenMessageCont(this.jms_sess, true, true);
                } else if (messageArray[i] instanceof AQjmsMapMessage) {
                    aQjmsGenMessage_CArray[i] = ((AQjmsMapMessage)messageArray[i]).getGenMessageCont(this.jms_sess, true, true);
                } else if (messageArray[i] instanceof AQjmsObjectMessage) {
                    aQjmsGenMessage_CArray[i] = ((AQjmsObjectMessage)messageArray[i]).getGenMessageCont(this.jms_sess, true, true);
                }
                aQjmsMessageHeaderExt = this.getHeaderWithProperties(messageArray[i], aQjmsConnection);
                if (aQjmsMessageHeaderExt == null) continue;
                aQjmsGenMessage_CArray[i].setHeader(aQjmsMessageHeaderExt);
            }
            oracleArray = (OracleArray)((oracle.jdbc.OracleConnection)connection).createOracleArray("SYS.AQ$_JMS_MESSAGES", (Object)aQjmsGenMessage_CArray);
        } else if (string.equalsIgnoreCase("SYS.AQ$_JMS_TEXT_MESSAGE")) {
            aQjmsTextMessage_CArray = new AQjmsTextMessage_C[messageArray.length];
            for (int i = 0; i < messageArray.length; ++i) {
                if (!(messageArray[i] instanceof AQjmsTextMessage)) continue;
                aQjmsTextMessage_CArray[i] = (AQjmsTextMessage_C)((AQjmsTextMessage)messageArray[i]).getMessageCont(this.jms_sess, true, true);
                aQjmsMessageHeaderExt = this.getHeaderWithProperties(messageArray[i], aQjmsConnection);
                if (aQjmsMessageHeaderExt == null) continue;
                aQjmsTextMessage_CArray[i].setHeader(aQjmsMessageHeaderExt);
            }
            oracleArray = (OracleArray)((oracle.jdbc.OracleConnection)connection).createOracleArray("SYS.AQ$_JMS_TEXT_MESSAGES", (Object)aQjmsTextMessage_CArray);
        } else if (string.equalsIgnoreCase("SYS.AQ$_JMS_BYTES_MESSAGE")) {
            aQjmsBytesMessage_CArray = new AQjmsBytesMessage_C[messageArray.length];
            for (int i = 0; i < messageArray.length; ++i) {
                if (!(messageArray[i] instanceof AQjmsBytesMessage)) continue;
                aQjmsBytesMessage_CArray[i] = (AQjmsBytesMessage_C)((AQjmsBytesMessage)messageArray[i]).getMessageCont(this.jms_sess, true, true);
                aQjmsMessageHeaderExt = this.getHeaderWithProperties(messageArray[i], aQjmsConnection);
                if (aQjmsMessageHeaderExt == null) continue;
                aQjmsBytesMessage_CArray[i].setHeader(aQjmsMessageHeaderExt);
            }
            oracleArray = (OracleArray)((oracle.jdbc.OracleConnection)connection).createOracleArray("SYS.AQ$_JMS_BYTES_MESSAGES", (Object)aQjmsBytesMessage_CArray);
        } else if (string.equalsIgnoreCase("SYS.AQ$_JMS_STREAM_MESSAGE")) {
            aQjmsStreamMessage_CArray = new AQjmsStreamMessage_C[messageArray.length];
            for (int i = 0; i < messageArray.length; ++i) {
                if (!(messageArray[i] instanceof AQjmsStreamMessage)) continue;
                aQjmsStreamMessage_CArray[i] = (AQjmsStreamMessage_C)((AQjmsStreamMessage)messageArray[i]).getMessageCont(this.jms_sess, true, true);
                aQjmsMessageHeaderExt = this.getHeaderWithProperties(messageArray[i], aQjmsConnection);
                if (aQjmsMessageHeaderExt == null) continue;
                aQjmsStreamMessage_CArray[i].setHeader(aQjmsMessageHeaderExt);
            }
            oracleArray = (OracleArray)((oracle.jdbc.OracleConnection)connection).createOracleArray("SYS.AQ$_JMS_STREAM_MESSAGES", (Object)aQjmsStreamMessage_CArray);
        } else if (string.equalsIgnoreCase("SYS.AQ$_JMS_MAP_MESSAGE")) {
            aQjmsMapMessage_CArray = new AQjmsMapMessage_C[messageArray.length];
            for (int i = 0; i < messageArray.length; ++i) {
                if (!(messageArray[i] instanceof AQjmsMapMessage)) continue;
                aQjmsMapMessage_CArray[i] = (AQjmsMapMessage_C)((AQjmsMapMessage)messageArray[i]).getMessageCont(this.jms_sess, true, true);
                aQjmsMessageHeaderExt = this.getHeaderWithProperties(messageArray[i], aQjmsConnection);
                if (aQjmsMessageHeaderExt == null) continue;
                aQjmsMapMessage_CArray[i].setHeader(aQjmsMessageHeaderExt);
            }
            oracleArray = (OracleArray)((oracle.jdbc.OracleConnection)connection).createOracleArray("SYS.AQ$_JMS_MAP_MESSAGES", (Object)aQjmsMapMessage_CArray);
        } else if (string.equalsIgnoreCase("SYS.AQ$_JMS_OBJECT_MESSAGE")) {
            aQjmsObjectMessage_CArray = new AQjmsObjectMessage_C[messageArray.length];
            for (int i = 0; i < messageArray.length; ++i) {
                if (!(messageArray[i] instanceof AQjmsObjectMessage)) continue;
                aQjmsObjectMessage_CArray[i] = (AQjmsObjectMessage_C)((AQjmsObjectMessage)messageArray[i]).getMessageCont(this.jms_sess, true, true);
                aQjmsMessageHeaderExt = this.getHeaderWithProperties(messageArray[i], aQjmsConnection);
                if (aQjmsMessageHeaderExt == null) continue;
                aQjmsObjectMessage_CArray[i].setHeader(aQjmsMessageHeaderExt);
            }
            oracleArray = (OracleArray)((oracle.jdbc.OracleConnection)connection).createOracleArray("SYS.AQ$_JMS_OBJECT_MESSAGES", (Object)aQjmsObjectMessage_CArray);
        } else {
            AQjmsError.throwEx(127);
        }
        return oracleArray;
    }

    private OracleArray convertToMessagePropertyArray(Message[] messageArray, int[] nArray, long[] lArray, AQjmsAgent[][] aQjmsAgentArray, Connection connection) throws SQLException, JMSException {
        AQjmsMessageProperty[] aQjmsMessagePropertyArray = null;
        OracleArray oracleArray = null;
        AQjmsRecipients aQjmsRecipients = null;
        Integer n = null;
        Integer n2 = null;
        Integer n3 = null;
        aQjmsMessagePropertyArray = new AQjmsMessageProperty[messageArray.length];
        for (int i = 0; i < messageArray.length; ++i) {
            aQjmsMessagePropertyArray[i] = new AQjmsMessageProperty();
            if (((AQjmsMessage)messageArray[i]).isJMSBody() && this.jms_sess.getCompliant()) {
                n = new Integer(AQjmsMessage.toJMSPriority(nArray[i]));
                aQjmsMessagePropertyArray[i].setPriority(n);
            } else {
                n = new Integer(nArray[i]);
                aQjmsMessagePropertyArray[i].setPriority(n);
            }
            if (lArray[i] == 0L || lArray[i] == -1L) {
                n2 = new Integer(-1);
                aQjmsMessagePropertyArray[i].setExpiration(n2);
            } else {
                n2 = new Integer((int)(lArray[i] / 1000L));
                aQjmsMessagePropertyArray[i].setExpiration(n2);
            }
            n3 = new Integer(((AQjmsMessage)messageArray[i]).getDelay());
            aQjmsMessagePropertyArray[i].setDelay(n3);
            aQjmsMessagePropertyArray[i].setExceptionQueue(((AQjmsMessage)messageArray[i]).getExceptionQueue());
            aQjmsMessagePropertyArray[i].setSignature(((AQjmsMessage)messageArray[i]).getSignature());
            if (aQjmsAgentArray != null && aQjmsAgentArray[i] != null && aQjmsAgentArray[i].length > 0) {
                aQjmsRecipients = new AQjmsRecipients(aQjmsAgentArray[i]);
                aQjmsMessagePropertyArray[i].setRecipientList(aQjmsRecipients);
            }
            aQjmsMessagePropertyArray[i].setSenderId(((AQjmsMessage)messageArray[i]).getSenderID());
            aQjmsMessagePropertyArray[i].setCorrelation(((AQjmsMessage)messageArray[i]).getJMSCorrelationID());
        }
        oracleArray = (OracleArray)((oracle.jdbc.OracleConnection)connection).createOracleArray("SYS.AQ$_JMS_MESSAGE_PROPERTIES", (Object)aQjmsMessagePropertyArray);
        return oracleArray;
    }

    synchronized void bulkPublish(Topic topic, Message[] messageArray, int[] nArray, int[] nArray2, long[] lArray, Integer n, byte[] byArray, AQjmsAgent[][] aQjmsAgentArray) throws JMSException {
        AQjmsDestination aQjmsDestination = null;
        AQjmsOracleDebug.trace(4, "AQjmsProducer.bulkPublish-5", "entry");
        this.checkClosed("bulkPublish(t,msg,mode,prio,ttl,seq..)");
        if (messageArray == null) {
            AQjmsError.throwEx(133);
        }
        if (topic == null) {
            if (this.prod_dest == null || this.prod_dest.getTopicName() == null) {
                AQjmsError.throwInvalidDestEx(166);
            } else {
                aQjmsDestination = this.prod_dest;
            }
        } else if (topic instanceof AQjmsDestination) {
            AQjmsOracleDebug.trace(5, "AQjmsProducer.publish", "topic: " + ((AQjmsDestination)topic).getCompleteName());
            aQjmsDestination = (AQjmsDestination)topic;
        } else {
            AQjmsError.throwInvalidDestEx(166);
        }
        this.bulkEnqueue(aQjmsDestination, messageArray, nArray, nArray2, lArray, n, byArray, aQjmsAgentArray);
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-5", "exit");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void bulkEnqueue(AQjmsDestination aQjmsDestination, Message[] messageArray, int[] nArray, int[] nArray2, long[] lArray, Integer n, byte[] byArray, AQjmsAgent[][] aQjmsAgentArray) throws JMSException {
        Connection connection = null;
        AQjmsConnection aQjmsConnection = null;
        String string = "";
        OracleCallableStatement oracleCallableStatement = null;
        Map<String, Class<?>> map = null;
        boolean bl = false;
        boolean bl2 = false;
        Message[] messageArray2 = null;
        OracleArray oracleArray = null;
        OracleArray oracleArray2 = null;
        OracleArray oracleArray3 = null;
        byte[][] byArray2 = null;
        AQjmsArrayErrors aQjmsArrayErrors = null;
        AQjmsArrayErrorInfo[] aQjmsArrayErrorInfoArray = null;
        AQjmsException aQjmsException = null;
        String string2 = null;
        AQjmsOracleDebug.trace(4, "AQjmsProducer.bulkEnqueue", "entry");
        if (aQjmsDestination.isSharded()) {
            aQjmsDestination.setAdtType("SYS.AQ$_JMS_MESSAGE");
        }
        try {
            int n2;
            if (aQjmsDestination == null) {
                AQjmsError.throwEx(127);
            }
            Date date = new Date();
            if (!this.lock("bulkEnqueue", -1L)) {
                AQjmsError.throwEx(122);
            }
            aQjmsConnection = this.jms_sess.getJmsConnection();
            string2 = this.getAdtType(aQjmsDestination);
            bl2 = string2.equalsIgnoreCase("SYS.ANYDATA");
            boolean bl3 = false;
            string = aQjmsDestination.getCompleteName();
            AQjmsOracleDebug.trace(5, "AQjmsProducer.bulkEnqueue", "q_name: " + string);
            try {
                connection = this.jms_sess.getDBConnection();
                map = connection.getTypeMap();
            }
            catch (Exception exception) {
                AQjmsError.throwEx(112, (Throwable)exception);
            }
            bl = "SYS.AQ$_JMS_MESSAGE".equalsIgnoreCase(string2);
            if (messageArray == null) {
                AQjmsError.throwEx(133);
            }
            if (nArray == null) {
                nArray = new int[messageArray.length];
                for (int i = 0; i < messageArray.length; ++i) {
                    nArray[i] = this.del_mode;
                }
            }
            if (nArray2 == null) {
                nArray2 = new int[messageArray.length];
                for (int i = 0; i < messageArray.length; ++i) {
                    nArray2[i] = this.m_priority;
                }
            }
            if (lArray == null) {
                lArray = new long[messageArray.length];
                for (int i = 0; i < messageArray.length; ++i) {
                    lArray[i] = this.m_timetolive;
                }
            }
            messageArray2 = new Message[messageArray.length];
            for (n2 = 0; n2 < messageArray.length; ++n2) {
                if (messageArray[n2] == null) {
                    AQjmsError.throwEx(133);
                }
                messageArray2[n2] = messageArray[n2];
                messageArray[n2] = AQjmsProducer.convertForeignMessage(this.jms_sess, messageArray[n2]);
                messageArray[n2] = AQjmsProducer.convertHeaderMessage(messageArray[n2], string2);
                this.checkMessageType(string2, messageArray[n2], bl3);
            }
            oracleArray = this.convertToORADATAArray(messageArray, aQjmsDestination, aQjmsConnection, connection);
            oracleArray2 = this.convertToMessagePropertyArray(messageArray, nArray2, lArray, aQjmsAgentArray, connection);
            for (n2 = 0; n2 < messageArray.length; ++n2) {
                if (((AQjmsMessage)messageArray[n2]).isHeaderOnly()) {
                    ((AQjmsMessage)messageArray[n2]).setStringProperty2("JMS_OracleHeaderOnly", "yes");
                }
                if (!(messageArray[n2] instanceof AQjmsAdtMessage)) {
                    ((AQjmsMessage)messageArray[n2]).setStringProperty2("JMS_OracleDeliveryMode", "" + nArray[n2]);
                }
                messageArray[n2].setJMSTimestamp(date.getTime());
                if (aQjmsDestination.isTopic() && !(messageArray[n2] instanceof AQjmsAdtMessage)) {
                    ((AQjmsMessage)messageArray[n2]).setStringProperty2("JMS_OracleConnectionID", this.connection_id);
                }
                ((AQjmsMessage)messageArray[n2]).validateUserProperties();
            }
            if (bl3) {
            } else {
                map.put("SYS.AQ$_AGENT", Class.forName("oracle.AQ.AQOracleAgent"));
                map.put("SYS.AQ$_SIG_PROP", Class.forName("oracle.jms.AQjmsSignature"));
                map.put("SYS.AQ$_RECIPIENTS", Class.forName("oracle.jms.AQjmsRecipients"));
                map.put("SYS.AQ$_MESSAGE_PROPERTY", Class.forName("oracle.jms.AQjmsMessageProperty"));
                map.put("SYS.AQ$_JMS_ARRAY_ERROR_INFO", Class.forName("oracle.jms.AQjmsArrayErrorInfo"));
                oracleCallableStatement = this.jms_sess.getArrayEnqueueStmt(string2);
                oracleCallableStatement.setString(1, string);
                oracleCallableStatement.setObject(2, (Object)oracleArray, 2003);
                oracleCallableStatement.setObject(3, (Object)messageArray.length, 4);
                oracleCallableStatement.setObject(4, (Object)oracleArray2, 2003);
                oracleCallableStatement.setObject(5, (Object)2, 4);
                if (n != null) {
                    if (n == 2 || n == 3) {
                        oracleCallableStatement.setObject(7, (Object)n, 4);
                        AQjmsOracleDebug.trace(5, "AQjmsProducer.bulkEnqueue", "seq_dev: " + n);
                        if (byArray != null) {
                            oracleCallableStatement.setObject(6, (Object)byArray, -2);
                        } else {
                            oracleCallableStatement.setNull(6, -2);
                        }
                    } else {
                        AQjmsError.throwEx(154);
                    }
                } else {
                    oracleCallableStatement.setNull(7, 4);
                    oracleCallableStatement.setNull(6, -2);
                }
                oracleCallableStatement.setString(8, this.transfxm);
                oracleCallableStatement.registerOutParameter(9, 2003, "SYS.AQ$_JMS_ARRAY_MSGIDS");
                oracleCallableStatement.registerOutParameter(10, 2003, "SYS.AQ$_JMS_ARRAY_ERRORS");
                oracleCallableStatement.registerOutParameter(11, 4);
                oracleCallableStatement.execute();
                oracleArray3 = (OracleArray)oracleCallableStatement.getArray(9);
                aQjmsArrayErrors = (AQjmsArrayErrors)oracleCallableStatement.getObject(10, AQjmsArrayErrors.getOracleDataFactory());
                if (aQjmsArrayErrors != null) {
                    aQjmsArrayErrorInfoArray = aQjmsArrayErrors.getArray();
                }
                byArray2 = (byte[][])oracleArray3.getArray();
                for (n2 = 0; n2 < messageArray.length; ++n2) {
                    if (aQjmsArrayErrorInfoArray == null) {
                        ((AQjmsMessage)messageArray[n2]).setJMSMessageID(byArray2[n2]);
                    } else if (aQjmsArrayErrorInfoArray[n2] == null) {
                        ((AQjmsMessage)messageArray[n2]).setJMSMessageID(byArray2[n2]);
                    } else {
                        aQjmsException = aQjmsException == null ? new AQjmsException("Array enqueue error at position " + aQjmsArrayErrorInfoArray[n2].getErrorPosition() + " with message " + aQjmsArrayErrorInfoArray[n2].getErrorMsg(), 207) : new AQjmsException("Array enqueue error at position " + aQjmsArrayErrorInfoArray[n2].getErrorPosition() + " with message " + aQjmsArrayErrorInfoArray[n2].getErrorMsg(), 207, (Throwable)((Object)aQjmsException));
                    }
                    if (aQjmsArrayErrorInfoArray != null && aQjmsException != null) {
                        throw aQjmsException;
                    }
                    messageArray[n2].setJMSDestination((Destination)aQjmsDestination);
                    messageArray[n2].setJMSDeliveryMode(nArray[n2]);
                    if (lArray[n2] == 0L || lArray[n2] == -1L) {
                        messageArray[n2].setJMSExpiration(0L);
                    } else {
                        messageArray[n2].setJMSExpiration(date.getTime() + lArray[n2]);
                    }
                    messageArray[n2].setJMSPriority(nArray2[n2]);
                    if (messageArray2[n2] == messageArray[n2]) continue;
                    AQjmsProducer.copyAQjmsMessageSendHeaders(messageArray[n2], messageArray2[n2]);
                }
                if (!this.jms_sess.isInTransactionRechecked()) {
                    this.jms_sess.forceCommit();
                }
            }
        }
        catch (JMSException jMSException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsProducer.bulkEnqueue", jMSException);
            throw jMSException;
        }
        catch (SQLException sQLException) {
            try {
                if (oracleCallableStatement != null) {
                    this.jms_sess.destroyStmt(oracleCallableStatement);
                }
            }
            catch (Exception exception) {
                AQjmsOracleDebug.traceEx(5, "AQjmsProducer.enqueue-ex2", exception);
            }
            AQjmsOracleDebug.traceEx(3, "AQjmsProducer.enqueue-ex3", sQLException);
            if (sQLException.getErrorCode() != 24033) {
                throw new AQjmsException(sQLException);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            AQjmsError.throwEx(146, (Throwable)classNotFoundException);
        }
        catch (Exception exception) {
            AQjmsError.throwEx(204, (Throwable)exception);
        }
        finally {
            try {
                for (int i = 0; i < messageArray.length; ++i) {
                    ((AQjmsMessage)messageArray[i]).messageSendCallback(true);
                }
            }
            catch (Throwable throwable) {}
            try {
                this.unlock("bulkEnqueue");
            }
            catch (Throwable throwable) {}
        }
        AQjmsOracleDebug.trace(4, "AQjmsProducer.bulkEnqueue", "exit");
    }

    private int getTypeCodeOfJMSMessage(Message message) throws JMSException {
        int n = 0;
        if (message instanceof AQjmsTextMessage) {
            n = 0;
        } else if (message instanceof AQjmsBytesMessage) {
            n = 1;
        } else if (message instanceof AQjmsStreamMessage) {
            n = 2;
        } else if (message instanceof AQjmsMapMessage) {
            n = 3;
        } else if (message instanceof AQjmsObjectMessage) {
            n = 4;
        } else if (message instanceof AQjmsMessage) {
            n = 100;
        } else {
            AQjmsError.throwEx(122, "wrong msg type");
        }
        return n;
    }

    private JMSMessageProperties.JMSMessageType getTypeEnumOfJMSMessage(Message message) throws JMSException {
        if (message instanceof AQjmsTextMessage) {
            return JMSMessageProperties.JMSMessageType.TEXT_MESSAGE;
        }
        if (message instanceof AQjmsBytesMessage) {
            return JMSMessageProperties.JMSMessageType.BYTES_MESSAGE;
        }
        if (message instanceof AQjmsStreamMessage) {
            return JMSMessageProperties.JMSMessageType.STREAM_MESSAGE;
        }
        if (message instanceof AQjmsMapMessage) {
            return JMSMessageProperties.JMSMessageType.MAP_MESSAGE;
        }
        if (message instanceof AQjmsObjectMessage) {
            return JMSMessageProperties.JMSMessageType.OBJECT_MESSAGE;
        }
        if (message instanceof AQjmsMessage) {
            return JMSMessageProperties.JMSMessageType.MESSAGE;
        }
        AQjmsError.throwEx(122, "wrong msg type");
        return JMSMessageProperties.JMSMessageType.MESSAGE;
    }
}

