/*
 * Decompiled with CFR 0.152.
 */
package oracle.AQ;

import oracle.AQ.AQException;
import oracle.AQ.AQRawPayload;
import oracle.AQ.AQUtil;

public class AQOracleRawPayload
implements AQRawPayload {
    private byte[] data;
    private int length;

    public AQOracleRawPayload(byte[] byArray, int n) {
        this.data = byArray;
        this.length = n;
    }

    public AQOracleRawPayload() {
        this.data = new byte[100];
        this.length = 100;
    }

    @Override
    public int getStream(byte[] byArray, int n) throws AQException {
        int n2 = 0;
        int n3 = n;
        if (byArray.length < n) {
            AQUtil.throwAQEx(189);
        }
        if (n3 > this.length) {
            n3 = this.length;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            byArray[n2] = this.data[n2];
        }
        return n3;
    }

    @Override
    public byte[] getBytes() throws AQException {
        int n = 0;
        byte[] byArray = null;
        byArray = new byte[this.length];
        for (n = 0; n < this.length; ++n) {
            byArray[n] = this.data[n];
        }
        return byArray;
    }

    @Override
    public void setStream(byte[] byArray, int n) throws AQException {
        int n2 = 0;
        if (n > this.data.length) {
            this.data = new byte[n];
        }
        for (n2 = 0; n2 < n; ++n2) {
            this.data[n2] = byArray[n2];
        }
        this.length = n;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.data == null || this.length == 0) {
            stringBuffer.append("Data  :  <Empty byte array!>");
        } else {
            int n = this.length;
            stringBuffer.append("Length:  " + this.length);
            stringBuffer.append("Data  :  ");
            for (int i = 0; i < n; ++i) {
                int n2 = this.data[i] & 0xFF;
                if (n2 < 16) {
                    stringBuffer.append("0" + Integer.toHexString(n2));
                    continue;
                }
                stringBuffer.append(Integer.toHexString(n2));
            }
        }
        return stringBuffer.toString();
    }
}

