/*
 * Decompiled with CFR 0.152.
 */
package oracle.AQ;

import oracle.AQ.AQException;

public class AQQueueTableProperty {
    static final boolean DEFAULT_MULTICONSUMER_FLAG = false;
    static final boolean DEFAULT_AUTO_COMMIT = true;
    static final int DEFAULT_MESSAGE_GROUPING = 0;
    public static final int NONE = 0;
    public static final int TRANSACTIONAL = 1;
    public static final int NON_REPUDIATE_SENDER = 1;
    public static final int NON_REPUDIATE_SNDRCV = 2;
    private String payload_type;
    private String storage_clause;
    private String sort_order;
    private boolean multi_consumer;
    private int mess_grouping;
    private String comment;
    private boolean auto_commit;
    private String compatible;
    private int primary_inst;
    private int secondary_inst;
    private int non_repudiation;
    private boolean secure;

    public AQQueueTableProperty(String string) throws AQException {
        if (string == null || string.equals("")) {
            throw new AQException(0, "payload type must be specified");
        }
        this.payload_type = string;
        this.storage_clause = null;
        this.sort_order = null;
        this.multi_consumer = false;
        this.mess_grouping = 0;
        this.comment = null;
        this.auto_commit = true;
        this.compatible = null;
        this.primary_inst = 0;
        this.secondary_inst = 0;
        this.non_repudiation = 0;
        this.secure = false;
    }

    public String getPayloadType() throws AQException {
        return this.payload_type;
    }

    public void setPayloadType(String string) throws AQException {
        if (string == null || string.equals("")) {
            throw new AQException(0, "payload type must be specified");
        }
        this.payload_type = string;
    }

    String getStorageClause() throws AQException {
        return this.storage_clause;
    }

    public void setStorageClause(String string) throws AQException {
        this.storage_clause = string;
    }

    public String getSortOrder() throws AQException {
        return this.sort_order;
    }

    public void setSortOrder(String string) throws AQException {
        this.sort_order = string;
    }

    public boolean isMulticonsumerEnabled() throws AQException {
        return this.multi_consumer;
    }

    public void setMultiConsumer(boolean bl) throws AQException {
        this.multi_consumer = bl;
    }

    public int getMessageGrouping() throws AQException {
        return this.mess_grouping;
    }

    public void setMessageGrouping(int n) throws AQException {
        this.mess_grouping = n;
    }

    public String getComment() throws AQException {
        return this.comment;
    }

    public void setComment(String string) throws AQException {
        this.comment = string;
    }

    boolean isAutoCommitEnabled() throws AQException {
        return this.auto_commit;
    }

    void setAutoCommit(boolean bl) throws AQException {
        this.auto_commit = bl;
    }

    public String getCompatible() throws AQException {
        return this.compatible;
    }

    public void setCompatible(String string) throws AQException {
        this.compatible = string;
    }

    public int getPrimaryInstance() throws AQException {
        return this.primary_inst;
    }

    public void setPrimaryInstance(int n) throws AQException {
        this.primary_inst = n;
    }

    public int getSecondaryInstance() throws AQException {
        return this.secondary_inst;
    }

    public void setSecondaryInstance(int n) throws AQException {
        this.secondary_inst = n;
    }

    public int getNonRepudiation() throws AQException {
        return this.non_repudiation;
    }

    public void setNonRepudiation(int n) throws AQException {
        this.non_repudiation = n;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean bl) throws AQException {
        this.secure = bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[AQQueueTableProperty]");
        stringBuffer.append("\n  payload_type     : " + this.payload_type);
        stringBuffer.append("\n  storage_clause   : " + this.storage_clause);
        stringBuffer.append("\n  sort_order       : " + this.sort_order);
        stringBuffer.append("\n  multi_consumer   : " + this.multi_consumer);
        if (this.mess_grouping == 1) {
            stringBuffer.append("\n  message_grouping : TRANSACTIONAL");
        } else {
            stringBuffer.append("\n  message grouping : NONE");
        }
        stringBuffer.append("\n  comment          : " + this.comment);
        stringBuffer.append("\n  compatible       : " + this.compatible);
        stringBuffer.append("\n  auto_commit      : " + this.auto_commit);
        stringBuffer.append("\n  primary inst     : " + this.primary_inst);
        stringBuffer.append("\n  Secondary inst   : " + this.secondary_inst);
        stringBuffer.append("\n  Non Repudiation  : " + this.non_repudiation);
        stringBuffer.append("\n  Secure           : " + this.secure);
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }
}

