/*
 * Decompiled with CFR 0.152.
 */
package oracle.AQ;

import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import oracle.AQ.AQException;
import oracle.AQ.AQOracleDebug;

public class AQUtil {
    private SimpleDateFormat printdateformat;
    private SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static ResourceBundle bundle;

    public AQUtil() {
        this.printdateformat = new SimpleDateFormat("EE MMM dd HH:mm:ss.SSS zz yyyy  ");
    }

    static String ByteArraytoString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (byArray == null) {
            stringBuffer.append("<Null byte array!>");
        } else {
            int n = byArray.length;
            for (int i = 0; i < n; ++i) {
                int n2 = byArray[i] & 0xFF;
                if (n2 < 16) {
                    stringBuffer.append("0" + Integer.toHexString(n2));
                    continue;
                }
                stringBuffer.append(Integer.toHexString(n2));
            }
        }
        return stringBuffer.toString();
    }

    String convertDateObjToPrintStr(Date date) {
        String string = "";
        string = this.printdateformat.format(date);
        return string;
    }

    Date convertPrintStrToDateObj(String string) {
        Date date = null;
        try {
            date = this.printdateformat.parse("1998-07-07 00:00:00");
        }
        catch (Exception exception) {
            AQOracleDebug.traceEx(4, "AQUtil.converttoDateObj", exception);
        }
        return date;
    }

    static String getMessage(String string, Object[] objectArray) {
        String string2 = null;
        if (bundle == null) {
            bundle = ResourceBundle.getBundle("oracle.jms.AQjmsMessages");
        }
        try {
            string2 = MessageFormat.format(bundle.getString(string), objectArray);
            string2 = "JMS-" + string + ": " + string2;
        }
        catch (Exception exception) {
            string2 = "Message [" + string + "] not found in 'AQjmsMessages'.";
        }
        return string2;
    }

    public static void throwAQEx(int n) throws AQException {
        String string = null;
        string = AQUtil.getMessage(Integer.toString(n), null);
        throw new AQException(n, string);
    }

    public static void throwAQEx(int n, Exception exception) throws AQException {
        String string = null;
        string = AQUtil.getMessage(Integer.toString(n), null);
        throw new AQException(n, string, exception);
    }

    public static void throwAQEx(int n, String string) throws AQException {
        String string2 = null;
        Object[] objectArray = new String[]{string == null ? "" : string};
        string2 = AQUtil.getMessage(Integer.toString(n), objectArray);
        throw new AQException(n, string2);
    }

    public static void throwAQEx(int n, String string, Exception exception) throws AQException {
        String string2 = null;
        Object[] objectArray = new String[]{string == null ? "" : string};
        string2 = AQUtil.getMessage(Integer.toString(n), objectArray);
        throw new AQException(n, string2, exception);
    }
}

