/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.rmi.server.UID;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.naming.InitialContext;
import oracle.jdbc.OracleBlob;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleClob;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleData;
import oracle.jms.AQjmsBytesMessage_C;
import oracle.jms.AQjmsConstants;
import oracle.jms.AQjmsDestination;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsGenMessage_C;
import oracle.jms.AQjmsMapMessage_C;
import oracle.jms.AQjmsMessageHeaderExt;
import oracle.jms.AQjmsObject;
import oracle.jms.AQjmsObjectMessage_C;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsSession;
import oracle.jms.AQjmsStreamMessage_C;
import oracle.jms.AQjmsTextMessage_C;
import oracle.jms.AQjmsTransformation;

class AQjmsUtil {
    static final int JAVA_WAIT_NONE = 1000;
    static final int JAVA_WAIT_FOREVER = 0;
    private static final String s_pfx = AQjmsUtil.getHostTimePrefix();
    private static long s_cnt = 0L;

    AQjmsUtil() {
    }

    static String getSystemProperty(String string) {
        final String string2 = string;
        String string3 = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(string2);
            }
        });
        return string3;
    }

    static String getSystemProperty(String string, String string2) {
        final String string3 = string;
        final String string4 = string2;
        String string5 = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(string3, string4);
            }
        });
        return string5;
    }

    static boolean selectorEquals(String string, String string2) {
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        string = string.trim();
        string2 = string2.trim();
        return string.equals(string2);
    }

    static boolean topicEquals(AQjmsDestination aQjmsDestination, AQjmsDestination aQjmsDestination2) throws JMSException {
        boolean bl = AQjmsUtil.stringEqualsNoCase(aQjmsDestination.getTopicOwner(), aQjmsDestination2.getTopicOwner());
        boolean bl2 = AQjmsUtil.stringEqualsNoCase(aQjmsDestination.getTopicName(), aQjmsDestination2.getTopicName());
        return bl && bl2;
    }

    static boolean stringEqualsNoCase(String string, String string2) {
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        return string.equalsIgnoreCase(string2);
    }

    private static String getHostTimePrefix() {
        String string = "localhost";
        String string2 = new UID().toString();
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (Throwable throwable) {
            AQjmsOracleDebug.trace(1, "AQjmsUtil.getHostTimePrefix", "");
        }
        return string + "." + string2;
    }

    static synchronized String newID() {
        return s_pfx + "." + ++s_cnt;
    }

    static String newID(String string) {
        return "OJMS." + string + "." + AQjmsUtil.newID();
    }

    static void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            AQjmsOracleDebug.trace(5, "WARN: AQjmsUtil.sleep", "interrupted");
        }
    }

    static void wait(Object object, long l) {
        try {
            object.wait(l);
        }
        catch (InterruptedException interruptedException) {
            AQjmsOracleDebug.trace(5, "WARN: AQjmsUtil.wait", "interrupted");
        }
    }

    static AQjmsObject get(Iterator iterator) {
        return (AQjmsObject)((WeakReference)iterator.next()).get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void sync(Collection collection) {
        if (collection == null) {
            return;
        }
        Collection collection2 = collection;
        synchronized (collection2) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                AQjmsObject aQjmsObject = AQjmsUtil.get(iterator);
                if (aQjmsObject != null && aQjmsObject.isOpen()) continue;
                iterator.remove();
            }
        }
    }

    static void throwClosed(AQjmsObject aQjmsObject) throws JMSException {
        AQjmsUtil.throwClosed(aQjmsObject, "");
    }

    static void throwClosed(AQjmsObject aQjmsObject, String string) throws JMSException {
        int n = aQjmsObject instanceof Connection ? 114 : (aQjmsObject instanceof Session ? 131 : (aQjmsObject instanceof MessageProducer ? 138 : (aQjmsObject instanceof MessageConsumer ? 115 : 122)));
        AQjmsError.throwIllegalStateEx(n, string + ":" + aQjmsObject.getID());
    }

    static long javaTimeout(long l) {
        if (l == 0L) {
            return 1000L;
        }
        if (l == -1L) {
            return 0L;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object lookupObject(String string, Class clazz) throws JMSException {
        InitialContext initialContext = null;
        Object object = null;
        try {
            initialContext = new InitialContext();
            object = initialContext.lookup(string);
        }
        catch (Exception exception) {
            AQjmsError.throwEx(118, (Throwable)exception);
        }
        finally {
            if (initialContext != null) {
                try {
                    initialContext.close();
                }
                catch (Exception exception) {}
            }
        }
        if (!clazz.isInstance(object)) {
            AQjmsError.throwEx(195, string);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static AQjmsTransformation getTransType(java.sql.Connection connection, AQjmsDestination aQjmsDestination, String string) throws JMSException {
        AQjmsOracleDebug.trace(3, "AQjmsUtil.getTransType", "entry:" + string);
        if (string == null) {
            AQjmsError.throwEx(122, "transformation is null");
        }
        Statement statement = null;
        AQjmsTransformation aQjmsTransformation = null;
        try {
            String string2 = null;
            String string3 = null;
            int n = string.indexOf(".", 1);
            if (n == -1) {
                string2 = ((OracleConnection)connection).getUserName();
                string3 = string;
            } else {
                string2 = string.substring(0, n);
                string3 = string.substring(n + 1);
            }
            AQjmsOracleDebug.trace(3, "AQjmsUtil.getTransType", "schema" + string2 + " name: " + string3);
            Hashtable hashtable = aQjmsDestination.getTransTable();
            aQjmsTransformation = (AQjmsTransformation)hashtable.get(string2 + "." + string3);
            if (aQjmsTransformation == null) {
                AQjmsOracleDebug.trace(3, "AQjmsUtil.getTransType", "transformation is not in the cache, retrive from db.");
                statement = connection.prepareCall("begin dbms_aqjms.aq$_get_trans_type(?, ?, ?, ?);end;");
                statement.setString(1, string2);
                statement.setString(2, string3);
                statement.registerOutParameter(3, 12);
                statement.registerOutParameter(4, 12);
                statement.execute();
                String string4 = statement.getString(3);
                String string5 = statement.getString(4);
                aQjmsTransformation = new AQjmsTransformation(string4, string5);
                hashtable.put(string2 + "." + string3, aQjmsTransformation);
            }
        }
        catch (SQLException sQLException) {
            String string6 = sQLException.getErrorCode() == 1403 ? "Transformation " + string + " does not exist" : "Error retrieving transformation types";
            AQjmsError.throwEx(string6, (Throwable)sQLException);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Throwable throwable) {}
            }
        }
        AQjmsOracleDebug.trace(3, "AQjmsUtil.getTransType", "transformation:" + aQjmsTransformation);
        return aQjmsTransformation;
    }

    static OracleClob populateTextContainer(OracleData oracleData, AQjmsMessageHeaderExt aQjmsMessageHeaderExt, String string, AQjmsSession aQjmsSession, boolean bl, boolean[] blArray, boolean bl2) throws JMSException {
        blArray[0] = false;
        int n = 0;
        if (string != null) {
            n = string.length();
        }
        Integer n2 = new Integer(n);
        OracleClob oracleClob = null;
        OracleClob oracleClob2 = null;
        String string2 = null;
        boolean bl3 = false;
        try {
            Object object;
            if (aQjmsSession.maxBytes(n) > 4000) {
                if (bl) {
                    if (AQjmsConstants.CACHE_TEMPLOBS && !bl2) {
                        if (aQjmsSession.cachedTempClob == null) {
                            object = (OracleConnection)aQjmsSession.getDBConnection();
                            aQjmsSession.cachedTempClob = oracleClob2 = (OracleClob)object.createClob();
                        } else {
                            oracleClob2 = aQjmsSession.cachedTempClob;
                        }
                    } else {
                        object = (OracleConnection)aQjmsSession.getDBConnection();
                        oracleClob2 = (OracleClob)object.createClob();
                    }
                    oracleClob = oracleClob2;
                    oracleClob.setString(1L, string);
                } else {
                    oracleClob = null;
                    blArray[0] = true;
                }
            } else {
                string2 = string;
            }
            if (oracleData instanceof AQjmsGenMessage_C) {
                object = (AQjmsGenMessage_C)oracleData;
                ((AQjmsGenMessage_C)object).setMessageType(new Integer(0));
                ((AQjmsGenMessage_C)object).setHeader(aQjmsMessageHeaderExt);
                ((AQjmsGenMessage_C)object).setTextLen(n2);
                ((AQjmsGenMessage_C)object).setTextVc(string2);
                ((AQjmsGenMessage_C)object).setTextLob(oracleClob);
            } else if (oracleData instanceof AQjmsTextMessage_C) {
                object = (AQjmsTextMessage_C)oracleData;
                ((AQjmsTextMessage_C)object).setHeader(aQjmsMessageHeaderExt);
                ((AQjmsTextMessage_C)object).setTextLen(n2);
                ((AQjmsTextMessage_C)object).setTextVc(string2);
                ((AQjmsTextMessage_C)object).setTextLob(oracleClob);
            } else {
                AQjmsError.throwEx(122, "invalid OracleData type:" + oracleData);
            }
            bl3 = true;
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
        finally {
            if (!bl3 && oracleClob2 != null) {
                try {
                    if (AQjmsConstants.CACHE_TEMPLOBS && !bl2) {
                        aQjmsSession.cachedTempClob = null;
                        oracleClob2.free();
                    } else {
                        oracleClob2.free();
                    }
                }
                catch (Throwable throwable) {}
            }
        }
        return oracleClob2;
    }

    static OracleBlob populateBytesContainer(OracleData oracleData, int n, AQjmsMessageHeaderExt aQjmsMessageHeaderExt, byte[] byArray, AQjmsSession aQjmsSession, boolean bl, boolean[] blArray, boolean bl2) throws JMSException {
        blArray[0] = false;
        int n2 = 0;
        if (byArray != null) {
            n2 = byArray.length;
        }
        Integer n3 = new Integer(n2);
        OracleBlob oracleBlob = null;
        OracleBlob oracleBlob2 = null;
        byte[] byArray2 = null;
        boolean bl3 = false;
        try {
            Object object;
            if (n2 > 2000) {
                if (bl) {
                    if (AQjmsConstants.CACHE_TEMPLOBS && !bl2) {
                        if (aQjmsSession.cachedTempBlob == null) {
                            object = (OracleConnection)aQjmsSession.getDBConnection();
                            aQjmsSession.cachedTempBlob = oracleBlob2 = (OracleBlob)object.createBlob();
                        } else {
                            oracleBlob2 = aQjmsSession.cachedTempBlob;
                        }
                    } else {
                        object = (OracleConnection)aQjmsSession.getDBConnection();
                        oracleBlob2 = (OracleBlob)object.createBlob();
                    }
                    oracleBlob = oracleBlob2;
                    oracleBlob.setBytes(1L, byArray);
                } else {
                    oracleBlob = null;
                    blArray[0] = true;
                }
            } else {
                byArray2 = byArray;
            }
            if (oracleData instanceof AQjmsGenMessage_C) {
                object = (AQjmsGenMessage_C)oracleData;
                ((AQjmsGenMessage_C)object).setMessageType(new Integer(n));
                ((AQjmsGenMessage_C)object).setHeader(aQjmsMessageHeaderExt);
                ((AQjmsGenMessage_C)object).setBytesLen(n3);
                ((AQjmsGenMessage_C)object).setBytesRaw(byArray2);
                ((AQjmsGenMessage_C)object).setBytesLob(oracleBlob);
            } else if (oracleData instanceof AQjmsBytesMessage_C) {
                object = (AQjmsBytesMessage_C)oracleData;
                ((AQjmsBytesMessage_C)object).setHeader(aQjmsMessageHeaderExt);
                ((AQjmsBytesMessage_C)object).setBytesLen(n3);
                ((AQjmsBytesMessage_C)object).setBytesRaw(byArray2);
                ((AQjmsBytesMessage_C)object).setBytesLob(oracleBlob);
            } else if (oracleData instanceof AQjmsStreamMessage_C) {
                object = (AQjmsStreamMessage_C)oracleData;
                ((AQjmsStreamMessage_C)object).setHeader(aQjmsMessageHeaderExt);
                ((AQjmsStreamMessage_C)object).setBytesLen(n3);
                ((AQjmsStreamMessage_C)object).setBytesRaw(byArray2);
                ((AQjmsStreamMessage_C)object).setBytesLob(oracleBlob);
            } else if (oracleData instanceof AQjmsMapMessage_C) {
                object = (AQjmsMapMessage_C)oracleData;
                ((AQjmsMapMessage_C)object).setHeader(aQjmsMessageHeaderExt);
                ((AQjmsMapMessage_C)object).setBytesLen(n3);
                ((AQjmsMapMessage_C)object).setBytesRaw(byArray2);
                ((AQjmsMapMessage_C)object).setBytesLob(oracleBlob);
            } else if (oracleData instanceof AQjmsObjectMessage_C) {
                object = (AQjmsObjectMessage_C)oracleData;
                ((AQjmsObjectMessage_C)object).setHeader(aQjmsMessageHeaderExt);
                ((AQjmsObjectMessage_C)object).setBytesLen(n3);
                ((AQjmsObjectMessage_C)object).setBytesRaw(byArray2);
                ((AQjmsObjectMessage_C)object).setBytesLob(oracleBlob);
            } else {
                AQjmsError.throwEx(122, "invalid OracleData type:" + oracleData);
            }
            bl3 = true;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new AQjmsException(sQLException);
        }
        finally {
            if (!bl3 && oracleBlob2 != null) {
                try {
                    if (AQjmsConstants.CACHE_TEMPLOBS && !bl2) {
                        aQjmsSession.cachedTempBlob = null;
                        oracleBlob2.free();
                    } else {
                        oracleBlob2.free();
                    }
                }
                catch (Throwable throwable) {}
            }
        }
        return oracleBlob2;
    }

    static void writeClob(String string, AQjmsSession aQjmsSession, String string2, byte[] byArray, boolean bl) throws JMSException {
        OracleCallableStatement oracleCallableStatement = null;
        try {
            java.sql.Connection connection = aQjmsSession.getDBConnection();
            if (string2 == null) {
                AQjmsError.throwEx(122, "qtable is null");
            }
            AQjmsOracleDebug.trace(5, "AQjmsUtil.writeClob", "qtable: " + string2);
            AQjmsOracleDebug.trace(5, "AQjmsStreamMessage.writeClob", "isAnydataDest: " + bl);
            if (!bl && !aQjmsSession.isKprb() && (long)string.length() <= AQjmsConstants.getLongLobThreshold()) {
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("UPDATE " + string2 + " tab set tab.user_data.text_lob = ? where tab.msgid = ?");
                oracleCallableStatement.setString(1, string);
                oracleCallableStatement.setBytes(2, byArray);
                int n = oracleCallableStatement.executeUpdate();
                if (n != 1) {
                    AQjmsError.throwEx(122, "Write lob updated no row or more than 1 row");
                }
            } else {
                oracleCallableStatement = bl ? (OracleCallableStatement)connection.prepareCall("SELECT dbms_aqin.aq$_getclob_from_jmsanydata(user_data) FROM " + string2 + " where msgid = ?") : (OracleCallableStatement)connection.prepareCall("SELECT tab.user_data.text_lob FROM " + string2 + " tab where msgid = ?");
                oracleCallableStatement.setBytes(1, byArray);
                ResultSet resultSet = oracleCallableStatement.executeQuery();
                OracleClob oracleClob = null;
                if (resultSet.next()) {
                    oracleClob = (OracleClob)resultSet.getClob(1);
                }
                if (oracleClob == null) {
                    AQjmsOracleDebug.trace(1, "AQjmsUtil.writeClob", "Internal error - text_lob is null");
                    AQjmsError.throwEx(122, "text_lob is null");
                }
                oracleClob.setString(1L, string);
            }
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
        finally {
            try {
                if (oracleCallableStatement != null) {
                    oracleCallableStatement.close();
                }
            }
            catch (Throwable throwable) {}
        }
    }

    static void writeBlob(byte[] byArray, AQjmsSession aQjmsSession, String string, byte[] byArray2, boolean bl) throws JMSException {
        OracleCallableStatement oracleCallableStatement = null;
        try {
            java.sql.Connection connection = aQjmsSession.getDBConnection();
            if (string == null) {
                AQjmsError.throwEx(122, "qtable is null");
            }
            AQjmsOracleDebug.trace(5, "AQjmsUtil.writeBlob", "qtable: " + string);
            AQjmsOracleDebug.trace(5, "AQjmsStreamMessage.writeBlob", "isAnydataDest: " + bl);
            if (!bl && !aQjmsSession.isKprb() && (long)byArray.length <= AQjmsConstants.getLongLobThreshold()) {
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("UPDATE " + string + " tab set tab.user_data.bytes_lob = ? where tab.msgid = ?");
                oracleCallableStatement.setBytes(1, byArray);
                oracleCallableStatement.setBytes(2, byArray2);
                int n = oracleCallableStatement.executeUpdate();
                if (n != 1) {
                    AQjmsError.throwEx(122, "Write lob updated no row or more than 1 row");
                }
            } else {
                oracleCallableStatement = bl ? (OracleCallableStatement)connection.prepareCall("SELECT dbms_aqin.aq$_getblob_from_jmsanydata(user_data) FROM " + string + " where msgid = ?") : (OracleCallableStatement)connection.prepareCall("SELECT tab.user_data.bytes_lob FROM " + string + " tab where msgid = ?");
                oracleCallableStatement.setBytes(1, byArray2);
                ResultSet resultSet = oracleCallableStatement.executeQuery();
                OracleBlob oracleBlob = null;
                if (resultSet.next()) {
                    oracleBlob = (OracleBlob)resultSet.getBlob(1);
                }
                if (oracleBlob == null) {
                    AQjmsOracleDebug.trace(1, "AQjmsUtil.writeBlob", "Internal error - bytes_lob is null");
                    AQjmsError.throwEx(122, "bytes_lob is null");
                }
                oracleBlob.setBytes(1L, byArray);
            }
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
        finally {
            try {
                if (oracleCallableStatement != null) {
                    oracleCallableStatement.close();
                }
            }
            catch (Throwable throwable) {}
        }
    }

    static String getTextData(int n, OracleClob oracleClob, String string) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsUtil.getTextData", "entry");
        AQjmsOracleDebug.trace(5, "AQjmsUtil.getTextData", "textLen: " + n);
        String string2 = string;
        if (string2 == null && oracleClob != null) {
            try {
                string2 = oracleClob.getSubString(1L, n);
            }
            catch (SQLException sQLException) {
                throw new AQjmsException(sQLException);
            }
        }
        if (string2 == null && n != 0 || string2 != null && string2.length() != n) {
            AQjmsError.throwEx(122, "Corrupted message");
        }
        AQjmsOracleDebug.trace(4, "AQjmsUtil.getTextData", "exit");
        return string2;
    }

    static byte[] getBytesData(int n, OracleBlob oracleBlob, byte[] byArray) throws JMSException {
        byte[] byArray2 = null;
        AQjmsOracleDebug.trace(4, "AQjmsUtil.getBytesData", "entry");
        AQjmsOracleDebug.trace(5, "AQjmsUtil.getBytesData", "bytesLen: " + n);
        try {
            if (byArray != null) {
                byArray2 = byArray;
            } else if (oracleBlob != null) {
                byArray2 = oracleBlob.getBytes(1L, n);
            }
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
        if (byArray2 == null && n != 0 || byArray2 != null && byArray2.length != n) {
            AQjmsError.throwEx(122, "Corrupted message");
        }
        AQjmsOracleDebug.trace(4, "AQjmsUtil.getBytesData", "exit");
        return byArray2;
    }
}

