/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import javax.jms.JMSException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import oracle.jms.AQjmsConstants;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsXASession;

public class AQjmsXAResource
implements XAResource {
    private XAResource m_jdbcXAResource;
    private AQjmsXASession m_jmsXASession;

    AQjmsXAResource(AQjmsXASession aQjmsXASession, XAResource xAResource) {
        this.m_jdbcXAResource = xAResource;
        this.m_jmsXASession = aQjmsXASession;
    }

    @Override
    public void commit(Xid xid, boolean bl) throws XAException {
        AQjmsOracleDebug.trace(1, "AQjmsXAResource.commit", "enter: XAResource=" + this + ", xid=" + xid + ",  onePhase=" + bl);
        this.checkConsistency();
        try {
            this.m_jdbcXAResource.commit(xid, bl);
            if (!AQjmsConstants.ignorePriority()) {
                this.m_jmsXASession.restartConsumers();
            }
        }
        catch (XAException xAException) {
            AQjmsOracleDebug.traceEx(1, "AQjmsXAResource.commit", xAException);
            throw xAException;
        }
        AQjmsOracleDebug.trace(1, "AQjmsXAResource.commit", "exit");
    }

    @Override
    public void end(Xid xid, int n) throws XAException {
        AQjmsOracleDebug.trace(1, "AQjmsXAResource.end", "enter: XAResource=" + this + ", xid=" + xid + ", flags=" + n);
        try {
            this.m_jdbcXAResource.end(xid, n);
        }
        catch (XAException xAException) {
            AQjmsOracleDebug.traceEx(1, "AQjmsXAResource.end", xAException);
            throw xAException;
        }
        AQjmsOracleDebug.trace(1, "AQjmsXAResource.end", "exit");
    }

    @Override
    public void forget(Xid xid) throws XAException {
        AQjmsOracleDebug.trace(1, "AQjmsXAResource.forget", "enter: XAResource=" + this + ", xid=" + xid);
        try {
            this.m_jdbcXAResource.forget(xid);
        }
        catch (XAException xAException) {
            AQjmsOracleDebug.traceEx(1, "AQjmsXAResource.forget", xAException);
            throw xAException;
        }
        AQjmsOracleDebug.trace(1, "AQjmsXAResource.forget", "exit");
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        AQjmsOracleDebug.trace(1, "AQjmsXAResource.getTransactionTimeout", "enter");
        int n = 0;
        try {
            n = this.m_jdbcXAResource.getTransactionTimeout();
        }
        catch (XAException xAException) {
            AQjmsOracleDebug.traceEx(1, "AQjmsXAResource.getTransactionTimeout", xAException);
            throw xAException;
        }
        AQjmsOracleDebug.trace(1, "AQjmsXAResource.getTransactionTimeout", "exit");
        return n;
    }

    @Override
    public boolean isSameRM(XAResource xAResource) throws XAException {
        AQjmsOracleDebug.trace(1, "AQjmsXAResource.isSameRM", "enter: my XAResource=" + this + ", target XAResource=" + xAResource);
        boolean bl = false;
        try {
            bl = xAResource == null ? false : (this == xAResource ? true : (xAResource instanceof AQjmsXAResource ? this.m_jdbcXAResource.isSameRM(((AQjmsXAResource)xAResource).getWrappedXARes()) : this.m_jdbcXAResource.isSameRM(xAResource)));
        }
        catch (XAException xAException) {
            AQjmsOracleDebug.traceEx(1, "AQjmsXAResource.isSameRM", xAException);
            throw xAException;
        }
        AQjmsOracleDebug.trace(1, "AQjmsXAResource.isSameRM", "exit");
        return bl;
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        AQjmsOracleDebug.trace(1, "AQjmsXAResource.prepare", "enter: XAResource=" + this + ", xid=" + xid);
        this.checkConsistency();
        int n = 0;
        try {
            n = this.m_jdbcXAResource.prepare(xid);
        }
        catch (XAException xAException) {
            AQjmsOracleDebug.traceEx(1, "AQjmsXAResource.prepare", xAException);
            throw xAException;
        }
        AQjmsOracleDebug.trace(1, "AQjmsXAResource.prepare", "exit");
        return n;
    }

    @Override
    public Xid[] recover(int n) throws XAException {
        AQjmsOracleDebug.trace(1, "AQjmsXAResource.recover", "enter: XAResource=" + this + ", flag=" + n);
        Xid[] xidArray = null;
        try {
            xidArray = this.m_jdbcXAResource.recover(n);
        }
        catch (XAException xAException) {
            AQjmsOracleDebug.traceEx(1, "AQjmsXAResource.recover", xAException);
            throw xAException;
        }
        AQjmsOracleDebug.trace(1, "AQjmsXAResource.recover", "exit");
        return xidArray;
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        AQjmsOracleDebug.trace(1, "AQjmsXAResource.rollback", "enter: XAResource=" + this + ", xid=" + xid);
        try {
            this.m_jdbcXAResource.rollback(xid);
            this.m_jmsXASession.setConsistency(true);
            this.m_jmsXASession.restartConsumers();
        }
        catch (XAException xAException) {
            AQjmsOracleDebug.traceEx(1, "AQjmsXAResource.rollback", xAException);
            throw xAException;
        }
        AQjmsOracleDebug.trace(1, "AQjmsXAResource.rollback", "exit");
    }

    @Override
    public boolean setTransactionTimeout(int n) throws XAException {
        AQjmsOracleDebug.trace(1, "AQjmsXAResource.setTransactionTimeout", "enter: XAResource=" + this + ", seconds=" + n);
        boolean bl = false;
        try {
            bl = this.m_jdbcXAResource.setTransactionTimeout(n);
        }
        catch (XAException xAException) {
            AQjmsOracleDebug.traceEx(1, "AQjmsXAResource.setTransactionTimeout", xAException);
            throw xAException;
        }
        AQjmsOracleDebug.trace(1, "AQjmsXAResource.setTransactionTimeout", "exit");
        return bl;
    }

    @Override
    public void start(Xid xid, int n) throws XAException {
        AQjmsOracleDebug.trace(1, "AQjmsXAResource.start", "enter: XAResource=" + this + ", xid=" + xid + ", flags=" + n);
        try {
            this.m_jdbcXAResource.start(xid, n);
        }
        catch (XAException xAException) {
            AQjmsOracleDebug.traceEx(1, "AQjmsXAResource.start", xAException);
            throw xAException;
        }
        AQjmsOracleDebug.trace(1, "AQjmsXAResource.start", "exit");
    }

    XAResource getWrappedXARes() {
        return this.m_jdbcXAResource;
    }

    private void checkConsistency() throws XAException {
        try {
            this.m_jmsXASession.checkConsistency();
        }
        catch (JMSException jMSException) {
            throw new XAException("cannot commit the JMS session that is in inconsistent state");
        }
    }
}

