/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.util.Date;
import javax.management.ObjectName;
import oracle.AQ.AQOracleDebug;
import oracle.jms.AQjmsConstants;
import oracle.jms.AQjmsEnableDebug;
import oracle.jms.AQjmsUtil;

public class AQjmsOracleDebug {
    static OutputStream logstream;
    static PrintWriter pstream;
    public static boolean DEBUG;
    private static int TRACE_LEVEL;
    public static final int AQ_ORA_TR0 = 0;
    public static final int AQ_ORA_TR1 = 1;
    public static final int AQ_ORA_TR2 = 2;
    public static final int AQ_ORA_TR3 = 3;
    public static final int AQ_ORA_TR4 = 4;
    public static final int AQ_ORA_TR5 = 5;
    public static final int AQ_ORA_TR6 = 6;

    private AQjmsOracleDebug() {
    }

    public static void setDebug(boolean bl) {
        DEBUG = bl;
        AQOracleDebug.setDebug(bl);
    }

    public static void setTraceLevel(int n) {
        TRACE_LEVEL = n > 6 ? 6 : (n < 0 ? 0 : n);
        AQOracleDebug.setTraceLevel(n);
    }

    public static int getTraceLevel() {
        return TRACE_LEVEL;
    }

    public static OutputStream getLogStream() {
        return logstream;
    }

    public static void setLogStream(OutputStream outputStream) {
        logstream = outputStream;
        pstream = new PrintWriter(logstream);
    }

    static void trace(int n, String string, String string2) {
        if (TRACE_LEVEL >= n || n == 6 && AQjmsConstants.syncDebug()) {
            pstream.println(Thread.currentThread().getName() + (TRACE_LEVEL >= 4 ? " [" + new Date(System.currentTimeMillis()).toString() + "] " : "  ") + string + ":  " + string2);
            pstream.flush();
        }
    }

    static void traceEx(int n, String string, Throwable throwable) {
        if (TRACE_LEVEL >= n || n == 6 && AQjmsConstants.syncDebug()) {
            pstream.println(Thread.currentThread().getName() + (TRACE_LEVEL >= 4 ? " [" + new Date(System.currentTimeMillis()).toString() + "] " : "  ") + string + ": Exception: " + throwable);
            if (TRACE_LEVEL >= 5 && throwable != null) {
                throwable.printStackTrace(pstream);
            }
            pstream.flush();
        }
    }

    static void traceErr(int n, String string, Error error) {
        if (TRACE_LEVEL >= n || n == 6 && AQjmsConstants.syncDebug()) {
            pstream.println(Thread.currentThread().getName() + (TRACE_LEVEL >= 4 ? " [" + new Date(System.currentTimeMillis()).toString() + "] " : "  ") + string + ": Error: " + error);
            if (TRACE_LEVEL >= 5 && error != null) {
                error.printStackTrace(pstream);
            }
            pstream.flush();
        }
    }

    static void print(String string) {
        if (DEBUG) {
            pstream.print(string);
            pstream.flush();
        }
    }

    static void println(String string) {
        if (DEBUG) {
            pstream.println(Thread.currentThread().getName() + "  " + string);
            pstream.flush();
        }
    }

    static {
        Object object;
        logstream = null;
        pstream = null;
        DEBUG = false;
        TRACE_LEVEL = Integer.getInteger("oracle.jms.traceLevel", 0);
        try {
            object = AQjmsUtil.getSystemProperty("oracle.jms.traceFile");
            logstream = object != null ? new FileOutputStream((String)object) : System.out;
        }
        catch (Exception exception) {
            logstream = System.out;
        }
        pstream = new PrintWriter(logstream);
        try {
            object = ManagementFactory.getPlatformMBeanServer();
            AQjmsEnableDebug aQjmsEnableDebug = new AQjmsEnableDebug();
            ObjectName objectName = new ObjectName("oracle.jms:type=AQjmsEnableDebugMBean");
            if (!object.isRegistered(objectName)) {
                object.registerMBean(aQjmsEnableDebug, objectName);
            }
        }
        catch (Exception exception) {
            System.out.println("Exception while registering AQjmsEnableDebugMBean: " + exception.getMessage());
            exception.printStackTrace();
        }
    }
}

