/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.io.StringReader;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import oracle.jdbc.util.RepConversion;
import oracle.jms.AQjmsDeqSel;
import oracle.jms.AQjmsDestination;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsInterOp;
import oracle.jms.AQjmsMessage;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsParser;
import oracle.jms.ParseException;
import oracle.jms.TokenMgrError;

class AQjmsSelector {
    String selector;
    String rule;
    String sel_corr_id;
    byte[] sel_msg_id;
    int sel_type;
    String adt_rule;
    boolean compliant;
    private AQjmsDestination destination;

    AQjmsSelector(String string, int n, int n2, short s, AQjmsDestination aQjmsDestination) throws JMSException {
        this(string, n, n2, s, true, aQjmsDestination);
    }

    AQjmsSelector(String string, int n, int n2, short s, boolean bl) throws JMSException {
        this(string, n, n2, s, bl, null);
    }

    AQjmsSelector(String string, int n, int n2, short s, boolean bl, AQjmsDestination aQjmsDestination) throws JMSException {
        this.destination = aQjmsDestination;
        this.sel_type = 0;
        this.selector = string;
        this.sel_corr_id = null;
        this.sel_msg_id = null;
        this.adt_rule = null;
        this.compliant = bl;
        boolean bl2 = AQjmsInterOp.is82compatible(s);
        AQjmsOracleDebug.trace(4, "AQjmsSelector-constructor", "entry");
        AQjmsOracleDebug.trace(5, "AQjmsSelector-constructor", "selector: " + string + " dest_type: " + n + " dest_pload_type: " + n2);
        if (n2 == 4) {
            this.AQjmsSelCnd(string, n, n2);
            return;
        }
        if (n2 == 2) {
            if (n == 10) {
                AQjmsOracleDebug.trace(5, "AQjmsSelector-constructor", "adt_type - dest=QUEUE");
                this.sel_type = 50;
                this.rule = string;
            } else {
                this.setAdtRule(string);
                this.sel_type = 40;
            }
            return;
        }
        if (n == 10) {
            if (!bl2 || string.indexOf("JMSCorrelationID") != -1 || string.indexOf("JMSMessageID") != -1) {
                try {
                    this.sel_type = this.parseDeqSelector(string + ";", n);
                }
                catch (InvalidSelectorException invalidSelectorException) {
                    if (bl2) {
                        this.AQjmsSelCnd(string, n, n2);
                    }
                    throw invalidSelectorException;
                }
                if (bl2 && this.sel_type == 0) {
                    this.AQjmsSelCnd(string, n, n2);
                }
                AQjmsOracleDebug.trace(5, "AQjmsSelector-constructor", "Prior v8.2:\nselector_type: " + this.sel_type + "   sel_msg_id: " + this.sel_msg_id + "   sel_corr_id: " + this.sel_corr_id);
            } else {
                this.AQjmsSelCnd(string, n, n2);
            }
        } else if (n == 20) {
            this.AQjmsSelCnd(string, n, n2);
        } else {
            AQjmsOracleDebug.trace(3, "AQjmsSelector-constructor", "INTERNAL_ERROR - invalid destination type");
            AQjmsError.throwEx(122, "Invalid destination type");
        }
        AQjmsOracleDebug.trace(5, "AQjmsSelector-constructor", this.getTrace());
        AQjmsOracleDebug.trace(4, "AQjmsSelector-constructor", "exit");
    }

    private void AQjmsSelCnd(String string, int n, int n2) throws JMSException {
        if (this.sel_type != 0) {
            AQjmsOracleDebug.trace(5, "AQjmsSelector.AQjmsSelCnd", "sel_type: " + this.sel_type);
            AQjmsOracleDebug.trace(5, "AQjmsSelector.AQjmsSelCnd", "dest_type: " + n);
            AQjmsOracleDebug.trace(5, "AQjmsSelector.AQjmsSelCnd", "dest_pload_type: " + n2);
        }
        try {
            this.rule = this.parseRule(string + ";", n2);
        }
        catch (TokenMgrError tokenMgrError) {
            AQjmsOracleDebug.traceErr(3, "Token Mgr Error - Invalid selector", tokenMgrError);
            AQjmsError.throwInvalidSelectorEx(159, "Token Mgr Error", tokenMgrError);
        }
        if (this.rule != null) {
            AQjmsOracleDebug.trace(5, "AQjmsSelector-constructor", "rule_len: " + this.rule.length());
            AQjmsOracleDebug.trace(5, "AQjmsSelector-constructor", "rule: " + this.rule);
        }
        if (this.rule.length() > 12000) {
            AQjmsError.throwInvalidSelectorEx(159, "Rule Parse error - exceeded 12000 characters");
        }
        this.sel_type = n == 10 ? 50 : 10;
    }

    public int parseDeqSelector(String string, int n) throws JMSException {
        AQjmsDeqSel aQjmsDeqSel = null;
        String string2 = null;
        int n2 = 0;
        AQjmsOracleDebug.trace(4, "AQjmsSelector.parseDeqSelector", "entry");
        aQjmsDeqSel = new AQjmsDeqSel(new StringReader(string));
        try {
            string2 = aQjmsDeqSel.DequeueSelector();
            AQjmsOracleDebug.trace(5, "AQjmsSelector.parseDeqSelector", "expr: " + string2);
            if (string2.equals("JMSMessageID")) {
                n2 = 30;
                this.sel_msg_id = aQjmsDeqSel.msg_id;
                AQjmsOracleDebug.trace(5, "AQjmsSelector.parseDeqSelector", "sel_msg_id: " + RepConversion.bArray2String((byte[])this.sel_msg_id));
            } else if (string2.equals("JMSCorrelationID")) {
                n2 = 20;
                this.sel_corr_id = aQjmsDeqSel.corr_id;
                AQjmsOracleDebug.trace(5, "AQjmsSelector.parseDeqSelector", "sel_corr_id: " + this.sel_corr_id);
            } else {
                n2 = 0;
            }
        }
        catch (ParseException parseException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSelector.parseDeqSelector- parseEx", parseException);
            AQjmsError.throwInvalidSelectorEx(159, "Selector Parse error", parseException);
        }
        catch (TokenMgrError tokenMgrError) {
            AQjmsOracleDebug.traceErr(3, "AQjmsSelector.parseDeqSelector- TokenMgrErr", tokenMgrError);
            AQjmsError.throwInvalidSelectorEx(159, "Selector Parse error: " + tokenMgrError.getMessage(), tokenMgrError);
        }
        AQjmsOracleDebug.trace(5, "AQjmsSelector.parseDeqSelector", "sel_type" + n2);
        AQjmsOracleDebug.trace(4, "AQjmsSelector.parseDeqSelector", "exit");
        return n2;
    }

    String parseRule(String string, int n) throws JMSException {
        AQjmsParser aQjmsParser = null;
        String string2 = null;
        AQjmsOracleDebug.trace(4, "AQjmsSelector.parseRule", "entry");
        aQjmsParser = new AQjmsParser(new StringReader(string));
        aQjmsParser.setDestPayloadType(n);
        if (n == 4) {
            aQjmsParser.initForJmsSharded();
            AQjmsOracleDebug.trace(4, "AQjmsSelector.parseRule", "parser.initForJmsSharded() for JMS sharded destination");
        } else {
            aQjmsParser.setCompliant(this.compliant);
            AQjmsOracleDebug.trace(4, "AQjmsSelector.parseRule", "set the <compliant> of AQjmsParser to:" + this.compliant);
        }
        try {
            string2 = aQjmsParser.SubscriberRule();
            AQjmsOracleDebug.println("\nMessage parsed successfully");
        }
        catch (ParseException parseException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSelector.parseRule - parseEx", parseException);
            AQjmsError.throwInvalidSelectorEx(159, "Rule Parse error", parseException);
        }
        AQjmsOracleDebug.trace(5, "AQjmsSelector.parseRule", "rule: " + string2);
        AQjmsOracleDebug.trace(4, "AQjmsSelector.parseRule", "exit");
        return string2;
    }

    String getSelectorString() {
        return this.selector;
    }

    int getSelectorType() {
        return this.sel_type;
    }

    String getRule() {
        return this.rule;
    }

    String getSelectorCorrelationId() {
        return this.sel_corr_id;
    }

    byte[] getSelectorMessageId() {
        return this.sel_msg_id;
    }

    String getAdtRule() {
        return this.adt_rule;
    }

    void setAdtRule(String string) throws JMSException {
        if (string.length() > 12000) {
            AQjmsError.throwInvalidSelectorEx(159, "Adt Selector Parse error - exceeded 12000 characters");
        }
        this.adt_rule = string;
        AQjmsOracleDebug.trace(5, "AQjmsSelector.setAdtRule", "adt_rule: " + this.adt_rule);
    }

    String getTrace() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[AQjmsSelector]");
        stringBuffer.append("\n  selector         : " + this.selector);
        stringBuffer.append("\n  rule             : " + this.rule);
        stringBuffer.append("\n  sel_corr_id      : " + this.sel_corr_id);
        stringBuffer.append("\n  adt_rule         : " + this.adt_rule);
        stringBuffer.append("\n  sel_msg_id       : " + AQjmsMessage.ByteArraytoString(this.sel_msg_id));
        stringBuffer.append("\n  sel_type         : " + this.sel_type);
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }
}

