/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.TimeoutException;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.sql.DataSource;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.pool.OracleOCIConnectionPool;
import oracle.jms.AQjmsClientSubscriberMap;
import oracle.jms.AQjmsConnectionMetaData;
import oracle.jms.AQjmsConstants;
import oracle.jms.AQjmsDBConnMgr;
import oracle.jms.AQjmsDestination;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsExceptionListener;
import oracle.jms.AQjmsGeneralDBConnection;
import oracle.jms.AQjmsObject;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsSession;

public class AQjmsConnection
extends AQjmsObject
implements QueueConnection,
TopicConnection {
    int conn_type;
    AQjmsConnectionMetaData metadata;
    AQjmsExceptionListener m_el;
    int m_tempCount = 0;
    static Hashtable s_temps = new Hashtable();
    String connection_id;
    String clientID = null;
    private boolean compliant = AQjmsConstants.IS_COMPLIANT;
    private boolean m_usetemplobs = AQjmsConstants.IS_USETEMPLOBS;
    AQjmsDBConnMgr connMgr = null;
    private boolean m_touched = false;
    Set<String> queueSet = new HashSet<String>();

    AQjmsConnection(String string, String string2, int n, String string3, String string4, String string5, int n2) throws JMSException {
        super("Connection", null);
        this.connMgr = new AQjmsDBConnMgr(string, string2, n, string3, string4, string5, false);
        this.initialize(n2);
    }

    AQjmsConnection(String string, Properties properties, int n) throws JMSException {
        super("Connection", null);
        this.connMgr = new AQjmsDBConnMgr(string, properties, false);
        this.initialize(n);
    }

    AQjmsConnection(String string, String string2, String string3, int n) throws JMSException {
        super("Connection", null);
        this.connMgr = new AQjmsDBConnMgr(string, string2, string3, false);
        this.initialize(n);
    }

    AQjmsConnection(Connection connection, int n) throws JMSException {
        super("Connection", null);
        this.connMgr = new AQjmsDBConnMgr(connection);
        this.initialize(n);
        AQjmsOracleDebug.trace(5, "AQjmsConnectionn ctor (user jdbc conn)", "connection: " + connection + " type: " + n);
    }

    AQjmsConnection(DataSource dataSource, String string, String string2, int n) throws JMSException {
        super("Connection", null);
        this.connMgr = new AQjmsDBConnMgr(dataSource, string, string2);
        this.initialize(n);
        AQjmsOracleDebug.trace(5, "AQjmsConnectionn ctor (datasource)", " type: " + n);
    }

    AQjmsConnection(OracleOCIConnectionPool oracleOCIConnectionPool, int n) throws JMSException {
        super("Connection", null);
        this.connMgr = new AQjmsDBConnMgr(oracleOCIConnectionPool);
        this.initialize(n);
        AQjmsOracleDebug.trace(5, "AQjmsConnectionn ctor (oci connection pool)", " type: " + n);
    }

    AQjmsConnection() {
        super("Connection", null);
    }

    void initialize(int n) throws JMSException {
        if (n == 10 || n == 20 || n == 30) {
            this.conn_type = n;
        } else {
            if (this.connMgr != null) {
                try {
                    this.connMgr.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            AQjmsError.throwEx(127);
        }
        this.metadata = new AQjmsConnectionMetaData();
        this.m_el = null;
    }

    String getUserName() {
        return this.connMgr.getUserName();
    }

    public String getClientID() throws JMSException {
        if (this.isClosed()) {
            AQjmsError.throwIllegalStateEx(114, null);
        }
        return this.getClientIDForce();
    }

    String getClientIDForce() {
        if (this.clientID == null) {
            return this.getUserName();
        }
        return this.clientID;
    }

    public synchronized void setClientID(String string) throws JMSException {
        if (this.isClosed()) {
            AQjmsError.throwIllegalStateEx(114, null);
        }
        if (this.m_touched) {
            AQjmsError.throwIllegalStateEx(240, null);
        }
        this.m_touched = true;
        this.clientID = string;
    }

    public synchronized ConnectionMetaData getMetaData() throws JMSException {
        if (this.isClosed()) {
            AQjmsError.throwIllegalStateEx(114, null);
        }
        this.m_touched = true;
        return this.metadata;
    }

    public synchronized void setExceptionListener(ExceptionListener exceptionListener) throws JMSException {
        if (this.isClosed()) {
            AQjmsError.throwIllegalStateEx(114, null);
        }
        this.m_touched = true;
        if (this.m_el != null) {
            this.m_el.setExceptionListener(exceptionListener);
        } else {
            AQjmsGeneralDBConnection aQjmsGeneralDBConnection = this.connMgr.getConnection(true);
            this.m_el = new AQjmsExceptionListener(aQjmsGeneralDBConnection);
            this.m_el.setParentJmsConn(this);
            if (this.isStarted()) {
                this.m_el.resumeExceptionListener();
            }
            this.m_el.setExceptionListener(exceptionListener);
        }
    }

    public synchronized ExceptionListener getExceptionListener() throws JMSException {
        if (this.isClosed()) {
            AQjmsError.throwIllegalStateEx(114, null);
        }
        this.m_touched = true;
        if (this.m_el != null) {
            return this.m_el.getExceptionListener();
        }
        return null;
    }

    boolean getCompliant() {
        return this.compliant;
    }

    void setCompliant(boolean bl) {
        this.compliant = bl;
        AQjmsOracleDebug.trace(4, "AQjmsConnection.setCompliant", "Current <compliant> is set to:" + bl);
    }

    protected boolean isUseTempLobs() {
        return this.m_usetemplobs;
    }

    void setUseTempLobs(boolean bl) {
        this.m_usetemplobs = bl;
        AQjmsOracleDebug.trace(4, "AQjmsConnection.setUseTempLobs", "Set usetemplobs to:" + bl);
    }

    public synchronized void start() throws JMSException {
        this.m_touched = true;
        this.startAll("start");
        if (this.m_el != null) {
            this.m_el.resumeExceptionListener();
        }
    }

    public synchronized void stop() throws JMSException {
        this.m_touched = true;
        this.stopAll("stop");
        if (this.m_el != null) {
            this.m_el.suspendExceptionListener();
        }
        try {
            if (AQjmsConstants.useJmsNotification()) {
                this.handleJMSNotification();
            }
        }
        catch (TimeoutException timeoutException) {
            this.m_touched = true;
            this.startAll("start");
            if (this.m_el != null) {
                this.m_el.resumeExceptionListener();
            }
            AQjmsError.throwEx(256);
        }
    }

    @Override
    public void close() throws JMSException {
        super.close();
    }

    @Override
    protected synchronized void preClose() {
        AQjmsOracleDebug.trace(4, "AQjmsConnection.preClose", "ENTRY");
        if (this.m_el != null) {
            this.m_el.close();
            this.m_el = null;
        }
        AQjmsOracleDebug.trace(4, "AQjmsConnection.preClose", "EXIT");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void localClose() throws JMSException {
        Object object;
        AQjmsOracleDebug.trace(4, "AQjmsConnection.localClose", "ENTRY");
        if (AQjmsConstants.FREE_CLOSED_SUB) {
            AQjmsClientSubscriberMap.removeClientID(this.getClientIDForce());
        }
        Vector vector = new Vector();
        Object object2 = s_temps;
        synchronized (object2) {
            object = s_temps.keys();
            while (object.hasMoreElements()) {
                Object k = object.nextElement();
                if (s_temps.get(k) != this) continue;
                vector.addElement(k);
                s_temps.remove(k);
            }
        }
        if (vector.size() > 0) {
            object2 = this.connMgr.getConnection(true);
            object = ((AQjmsGeneralDBConnection)object2).getDBConnection();
            for (int i = 0; i < vector.size(); ++i) {
                AQjmsDestination aQjmsDestination = (AQjmsDestination)vector.elementAt(i);
                try {
                    this.closeTemp((Connection)object, aQjmsDestination);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ((AQjmsGeneralDBConnection)object2).close();
        }
        this.connMgr.close();
        AQjmsOracleDebug.trace(5, "AQjmsConnection.closeConnectionResources", "Connection closed");
    }

    public synchronized QueueSession createQueueSession(boolean bl, int n) throws JMSException {
        AQjmsSession aQjmsSession = null;
        if (this.isClosed()) {
            AQjmsError.throwIllegalStateEx(114, null);
        }
        this.m_touched = true;
        if (this.conn_type != 10) {
            AQjmsError.throwEx(107, this.conn_type == 20 ? "TopicConnection" : "Connection");
        }
        AQjmsGeneralDBConnection aQjmsGeneralDBConnection = this.connMgr.getConnection(false);
        try {
            Connection connection = aQjmsGeneralDBConnection.getDBConnection();
            if (this.connection_id == null) {
                this.setConnectionID(connection);
            }
            aQjmsSession = new AQjmsSession(this, n, bl, 10, aQjmsGeneralDBConnection);
        }
        catch (JMSException jMSException) {
            AQjmsOracleDebug.traceEx(1, "AQjmsConnection.createQueueSession", jMSException);
            throw jMSException;
        }
        finally {
            if (aQjmsSession == null) {
                try {
                    if (aQjmsGeneralDBConnection != null) {
                        aQjmsGeneralDBConnection.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        AQjmsOracleDebug.trace(5, "AQjmsConnection:createQueueSession", "Created session");
        return aQjmsSession;
    }

    public synchronized ConnectionConsumer createConnectionConsumer(Queue queue, String string, ServerSessionPool serverSessionPool, int n) throws JMSException {
        AQjmsError.throwEx(102);
        return null;
    }

    public synchronized TopicSession createTopicSession(boolean bl, int n) throws JMSException {
        AQjmsSession aQjmsSession = null;
        if (this.isClosed()) {
            AQjmsError.throwIllegalStateEx(114, null);
        }
        this.m_touched = true;
        if (this.conn_type != 20) {
            AQjmsError.throwEx(107, this.conn_type == 10 ? "QueueConnection" : "Connection");
        }
        AQjmsGeneralDBConnection aQjmsGeneralDBConnection = this.connMgr.getConnection(false);
        try {
            Connection connection = aQjmsGeneralDBConnection.getDBConnection();
            if (this.connection_id == null) {
                this.setConnectionID(connection);
            }
            aQjmsSession = new AQjmsSession(this, n, bl, 20, aQjmsGeneralDBConnection);
        }
        catch (JMSException jMSException) {
            AQjmsOracleDebug.traceEx(1, "AQjmsConnection.createTopicSession", jMSException);
            throw jMSException;
        }
        finally {
            if (aQjmsSession == null) {
                try {
                    if (aQjmsGeneralDBConnection != null) {
                        aQjmsGeneralDBConnection.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        AQjmsOracleDebug.trace(5, "AQjmsConnection:createTopicSession", "Created session");
        return aQjmsSession;
    }

    public synchronized ConnectionConsumer createConnectionConsumer(Topic topic, String string, ServerSessionPool serverSessionPool, int n) throws JMSException {
        AQjmsError.throwEx(102);
        return null;
    }

    public synchronized ConnectionConsumer createDurableConnectionConsumer(Topic topic, String string, String string2, ServerSessionPool serverSessionPool, int n) throws JMSException {
        AQjmsError.throwEx(102);
        return null;
    }

    public synchronized Session getCurrentJmsSession() {
        return (Session)super.anyChild();
    }

    public OracleOCIConnectionPool getOCIConnectionPool() {
        return this.connMgr.getOCIConnectionPool();
    }

    String getDriver() {
        return this.connMgr.getDriver();
    }

    short getDBVersion() {
        return this.connMgr.getDBVersion();
    }

    int getDBMaxIdenLength() {
        return this.connMgr.getDBMaxIdenLength();
    }

    int getDBCompatMajorVersion() {
        return this.connMgr.getDBCompatMajorVersion();
    }

    int getDBCompatMinorVersion() {
        return this.connMgr.getDBCompatMinorVersion();
    }

    void releaseExternalConnection() {
        this.connMgr.releaseExternalConnection();
    }

    void setPingPeriod(long l) throws JMSException {
        if (this.m_el != null) {
            this.m_el.setPingPeriod(l);
        } else {
            AQjmsError.throwEx(107, "Session with NO ExceptionListener");
        }
    }

    long getPingPeriod() {
        if (this.m_el != null) {
            return this.m_el.getPingPeriod();
        }
        return 120000L;
    }

    @Override
    protected void finalize() {
        try {
            if (!this.isClosed()) {
                this.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        AQjmsOracleDebug.println("AQjmsConnection.finalize");
    }

    synchronized int getTempCount() {
        return ++this.m_tempCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerTemp(AQjmsDestination aQjmsDestination) throws JMSException {
        aQjmsDestination.makeTemp();
        Hashtable hashtable = s_temps;
        synchronized (hashtable) {
            s_temps.put(aQjmsDestination, this);
        }
    }

    synchronized void closeTemp(Connection connection, AQjmsDestination aQjmsDestination) throws JMSException {
        OracleCallableStatement oracleCallableStatement = null;
        AQjmsGeneralDBConnection aQjmsGeneralDBConnection = null;
        try {
            if (connection == null) {
                aQjmsGeneralDBConnection = this.connMgr.getConnection(true);
                connection = aQjmsGeneralDBConnection.getDBConnection();
            }
            if (aQjmsDestination.isSharded()) {
                String string = "BEGIN dbms_aqadm.stop_queue(queue_name => ?); dbms_aqadm.drop_sharded_queue(queue_name => ?); END;";
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall(string);
                oracleCallableStatement.setString(1, aQjmsDestination.getCompleteName());
                oracleCallableStatement.setString(2, aQjmsDestination.getCompleteName());
            } else {
                String string = "DECLARE PRAGMA AUTONOMOUS_TRANSACTION; BEGIN dbms_aqadm.stop_queue(queue_name => ?); dbms_aqadm.drop_queue(queue_name => ?); dbms_aqadm.drop_queue_table(queue_table => ?, force => true, auto_commit => true); END;";
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall(string);
                oracleCallableStatement.setString(1, aQjmsDestination.getCompleteName());
                oracleCallableStatement.setString(2, aQjmsDestination.getCompleteName());
                oracleCallableStatement.setString(3, aQjmsDestination.getCompleteTableName());
            }
            oracleCallableStatement.execute();
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
        finally {
            if (oracleCallableStatement != null) {
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            if (aQjmsGeneralDBConnection != null) {
                aQjmsGeneralDBConnection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void findCloseTemp(AQjmsDestination aQjmsDestination) throws JMSException {
        AQjmsConnection aQjmsConnection = null;
        Hashtable hashtable = s_temps;
        synchronized (hashtable) {
            if (!s_temps.containsKey(aQjmsDestination)) {
                return;
            }
            aQjmsConnection = (AQjmsConnection)s_temps.get(aQjmsDestination);
            s_temps.remove(aQjmsDestination);
        }
        if (aQjmsConnection != null) {
            aQjmsConnection.closeTemp(null, aQjmsDestination);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static AQjmsConnection getJmsConnection(AQjmsDestination aQjmsDestination) {
        AQjmsConnection aQjmsConnection = null;
        Hashtable hashtable = s_temps;
        synchronized (hashtable) {
            if (s_temps.containsKey(aQjmsDestination)) {
                aQjmsConnection = (AQjmsConnection)s_temps.get(aQjmsDestination);
            }
        }
        return aQjmsConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setConnectionID(Connection connection) throws JMSException {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery("select SYS_GUID() from dual");
            resultSet.next();
            this.connection_id = this.BytesToString(resultSet.getBytes(1));
        }
        catch (SQLException sQLException) {
            AQjmsError.throwEx(122, (Throwable)sQLException);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    private String BytesToString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            if (n < 16) {
                stringBuffer.append('0');
            }
            stringBuffer.append(Integer.toHexString(n));
        }
        return stringBuffer.toString();
    }

    String getConnectionID() {
        return this.connection_id;
    }

    public synchronized Session createSession(boolean bl, int n) throws JMSException {
        AQjmsSession aQjmsSession = null;
        if (this.isClosed()) {
            AQjmsError.throwIllegalStateEx(114, null);
        }
        this.m_touched = true;
        AQjmsGeneralDBConnection aQjmsGeneralDBConnection = this.connMgr.getConnection(false);
        try {
            Connection connection = aQjmsGeneralDBConnection.getDBConnection();
            if (this.connection_id == null) {
                this.setConnectionID(connection);
            }
            aQjmsSession = new AQjmsSession(this, n, bl, 30, aQjmsGeneralDBConnection);
        }
        catch (JMSException jMSException) {
            AQjmsOracleDebug.traceEx(1, "AQjmsConnection.createSession", jMSException);
            throw jMSException;
        }
        finally {
            if (aQjmsSession == null) {
                try {
                    if (aQjmsGeneralDBConnection != null) {
                        aQjmsGeneralDBConnection.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        AQjmsOracleDebug.trace(5, "AQjmsConnection:createSession", "Created session");
        return aQjmsSession;
    }

    public synchronized ConnectionConsumer createConnectionConsumer(Destination destination, String string, ServerSessionPool serverSessionPool, int n) throws JMSException {
        AQjmsError.throwEx(102);
        return null;
    }

    void feedJMSException(JMSException jMSException) throws JMSException {
        ExceptionListener exceptionListener = this.getExceptionListener();
        if (exceptionListener != null) {
            this.m_el.feedJMSException(jMSException);
        } else {
            AQjmsOracleDebug.trace(1, "AQjmsConnection:feedJMSException", "Exception Listener found Null for jms connection " + this + ". Queue List " + this.queueSet + " Time Now: " + new Date());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addQueueToSet(String string) {
        try {
            Set<String> set = this.queueSet;
            synchronized (set) {
                this.queueSet.add(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

