/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.Topic;
import oracle.jdbc.OracleArray;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleData;
import oracle.jdbc.OracleDataFactory;
import oracle.jdbc.OracleStruct;
import oracle.jdbc.aq.AQAgent;
import oracle.jdbc.aq.AQDequeueOptions;
import oracle.jdbc.aq.AQMessage;
import oracle.jdbc.aq.AQMessageProperties;
import oracle.jdbc.internal.JMSDequeueOptions;
import oracle.jdbc.internal.JMSMessage;
import oracle.jdbc.internal.JMSMessageProperties;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.util.RepConversion;
import oracle.jms.AQjmsAdtMessage;
import oracle.jms.AQjmsAgent;
import oracle.jms.AQjmsBytesMessage;
import oracle.jms.AQjmsBytesMessage_C;
import oracle.jms.AQjmsBytesMessages_C;
import oracle.jms.AQjmsClientSubscriberMap;
import oracle.jms.AQjmsConnection;
import oracle.jms.AQjmsConstants;
import oracle.jms.AQjmsDestination;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsGenMessage_C;
import oracle.jms.AQjmsGenMessages_C;
import oracle.jms.AQjmsJsonMessage;
import oracle.jms.AQjmsListenerWorker;
import oracle.jms.AQjmsMapMessage;
import oracle.jms.AQjmsMapMessage_C;
import oracle.jms.AQjmsMapMessages_C;
import oracle.jms.AQjmsMessage;
import oracle.jms.AQjmsMessageHeaderExt;
import oracle.jms.AQjmsMessageProperties;
import oracle.jms.AQjmsMessageProperty;
import oracle.jms.AQjmsNtfRegistration;
import oracle.jms.AQjmsObject;
import oracle.jms.AQjmsObjectMessage;
import oracle.jms.AQjmsObjectMessage_C;
import oracle.jms.AQjmsObjectMessages_C;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsPropertyList;
import oracle.jms.AQjmsQueueReceiver;
import oracle.jms.AQjmsSelector;
import oracle.jms.AQjmsSession;
import oracle.jms.AQjmsSignature;
import oracle.jms.AQjmsStreamMessage;
import oracle.jms.AQjmsStreamMessage_C;
import oracle.jms.AQjmsStreamMessages_C;
import oracle.jms.AQjmsTextMessage;
import oracle.jms.AQjmsTextMessage_C;
import oracle.jms.AQjmsTextMessages_C;
import oracle.jms.AQjmsTopicReceiver;
import oracle.jms.AQjmsTopicSubscriber;
import oracle.jms.AQjmsUtil;
import oracle.jms.DispatchScheduler;
import oracle.jms.ThreadProxy;
import oracle.jms.WebLogicHelper;
import oracle.sql.ANYDATA;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.Datum;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.TIMESTAMP;
import oracle.sql.json.OracleJsonDatum;
import oracle.sql.json.OracleJsonFactory;
import oracle.xdb.XMLType;

public class AQjmsConsumer
extends AQjmsObject
implements AQjmsQueueReceiver,
AQjmsTopicSubscriber,
AQjmsTopicReceiver {
    AQjmsSession jms_sess;
    AQjmsSelector selector;
    AQjmsDestination cons_dest;
    int dest_type;
    int deq_mode;
    int navig_mode;
    int visibility;
    String cons_name;
    volatile boolean first_receive;
    boolean nolocal;
    boolean xml_receive;
    CustomDatumFactory cd_factory;
    OracleDataFactory od_factory;
    ORADataFactory orad_factory;
    OracleJsonFactory ora_json_factory;
    private OracleCallableStatement deq_stmt;
    private String transfxm;
    private String client_id;
    private boolean hasInfo = true;
    private boolean durable = true;
    AQjmsListenerWorker m_lsnrWorker = null;
    private AQjmsNtfRegistration ntfReg = null;

    AQjmsConsumer(AQjmsSession aQjmsSession, Destination destination, int n, int n2, String string, Object object) throws JMSException {
        this(aQjmsSession, destination, n, n2, string, object, null, null, false);
    }

    AQjmsConsumer(AQjmsSession aQjmsSession, Destination destination, int n, int n2, String string, Object object, AQjmsSelector aQjmsSelector, String string2) throws JMSException {
        this(aQjmsSession, destination, n, n2, string, object, aQjmsSelector, string2, false);
    }

    AQjmsConsumer(AQjmsSession aQjmsSession, Destination destination, int n, int n2, String string, Object object, AQjmsSelector aQjmsSelector, String string2, boolean bl) throws JMSException {
        super("MessageConsumer", aQjmsSession);
        String string3 = null;
        Map map = null;
        AQjmsOracleDebug.trace(4, "AQjmsConsumer-constructor", "entry");
        if (destination == null) {
            AQjmsError.throwEx(200);
        }
        this.jms_sess = aQjmsSession;
        this.cons_dest = (AQjmsDestination)destination;
        this.dest_type = n;
        this.deq_stmt = null;
        int n3 = this.cons_dest.getPloadType();
        if (destination instanceof AQjmsDestination && ((AQjmsDestination)destination).isTemp() && this.jms_sess.getJmsConnection() != AQjmsConnection.getJmsConnection((AQjmsDestination)destination)) {
            AQjmsError.throwEx(231);
        }
        if (n2 == 1 || n2 == 2 || n2 == 3 || n2 == 4 || n2 == 5) {
            this.deq_mode = n2;
        } else {
            AQjmsError.throwEx(124);
        }
        this.navig_mode = AQjmsConstants.getNavigationMode();
        this.visibility = 2;
        if (n == 20 && string == null) {
            AQjmsError.throwEx(116);
        }
        this.cons_name = string;
        AQjmsOracleDebug.trace(5, "AQjmsConsumer-constructor", "dest_type: " + n);
        AQjmsOracleDebug.trace(5, "AQjmsConsumer-constructor", "cons_dest: " + this.cons_dest.getCompleteName());
        if (this.cons_name != null) {
            AQjmsOracleDebug.trace(5, "AQjmsConsumer-constructor", "consumer_name: " + this.cons_name);
        }
        string3 = this.cons_dest.getAdtType();
        AQjmsOracleDebug.trace(5, "AQjmsConsumer-constructor", "p_type: " + string3);
        if (this.cons_dest.isJson()) {
            if (object == null) {
                this.ora_json_factory = aQjmsSession.getJsonFactory();
            } else if (object instanceof OracleJsonFactory) {
                this.ora_json_factory = (OracleJsonFactory)object;
            } else {
                AQjmsError.throwEx(222);
            }
        } else if (!this.cons_dest.isSharded() || this.cons_dest.isSharded() && n3 == 1) {
            if (!this.cons_dest.isSharded() && (string3.equalsIgnoreCase("SYS.AQ$_JMS_MESSAGE") || string3.equalsIgnoreCase("SYS.AQ$_JMS_TEXT_MESSAGE") || string3.equalsIgnoreCase("SYS.AQ$_JMS_BYTES_MESSAGE") || string3.equalsIgnoreCase("SYS.AQ$_JMS_MAP_MESSAGE") || string3.equalsIgnoreCase("SYS.AQ$_JMS_OBJECT_MESSAGE") || string3.equalsIgnoreCase("SYS.AQ$_JMS_STREAM_MESSAGE"))) {
                if (object != null) {
                    AQjmsError.throwEx(136);
                }
                this.cd_factory = null;
                this.od_factory = null;
                this.orad_factory = null;
                this.ora_json_factory = null;
            } else if (string3.equalsIgnoreCase("SYS.ANYDATA")) {
                if (object != null) {
                    AQjmsError.throwEx(223);
                }
                map = this.jms_sess.getTypeMap();
                try {
                    map.put("SYS.AQ$_JMS_TEXT_MESSAGE", Class.forName("oracle.jms.AQjmsTextMessage_C"));
                    map.put("SYS.AQ$_JMS_BYTES_MESSAGE", Class.forName("oracle.jms.AQjmsBytesMessage_C"));
                    map.put("SYS.AQ$_JMS_STREAM_MESSAGE", Class.forName("oracle.jms.AQjmsStreamMessage_C"));
                    map.put("SYS.AQ$_JMS_MAP_MESSAGE", Class.forName("oracle.jms.AQjmsMapMessage_C"));
                    map.put("SYS.AQ$_JMS_OBJECT_MESSAGE", Class.forName("oracle.jms.AQjmsObjectMessage_C"));
                }
                catch (Exception exception) {
                    AQjmsOracleDebug.traceEx(5, "AQjmsConsumer-constructor-typemap-ex", exception);
                }
            } else {
                if (object == null) {
                    AQjmsError.throwEx(137);
                }
                this.cd_factory = null;
                this.od_factory = null;
                this.orad_factory = null;
                if (object instanceof CustomDatumFactory) {
                    this.cd_factory = (CustomDatumFactory)object;
                } else if (object instanceof OracleDataFactory) {
                    this.od_factory = (OracleDataFactory)object;
                } else if (object instanceof ORADataFactory) {
                    this.orad_factory = (ORADataFactory)object;
                } else {
                    AQjmsError.throwEx(222);
                }
            }
        }
        this.selector = aQjmsSelector;
        if (aQjmsSelector != null) {
            AQjmsOracleDebug.trace(5, "AQjmsConsumer-constructor", "selector: " + aQjmsSelector.getSelectorString());
        }
        this.nolocal = bl;
        this.first_receive = true;
        this.transfxm = string2;
        AQjmsOracleDebug.trace(4, "AQjmsConsumer-constructor", "exit");
        this.client_id = this.jms_sess.jms_conn.getClientIDForce();
        aQjmsSession.attach(this);
        if (this.cons_dest.isTemp()) {
            this.cons_dest.addConsForTempDest();
        }
    }

    AQjmsConsumer(AQjmsSession aQjmsSession, Destination destination, int n, int n2, String string, Object object, AQjmsSelector aQjmsSelector, String string2, boolean bl, boolean bl2) throws JMSException {
        this(aQjmsSession, destination, n, n2, string, object, aQjmsSelector, string2, bl);
        this.hasInfo = bl2;
    }

    private AQjmsMessage ocideqSQ(String string, String string2, int n, int n2, String string3, String string4, byte[] byArray, int n3, int n4, long l, boolean bl, long[] lArray, long l2, String string5, AQjmsSession aQjmsSession) throws Exception {
        Object[] objectArray = new Object[8];
        this.ocideq2(string, string2, n, n2, string3, string4, byArray, n3, n4, l, bl, lArray, l2, string5, aQjmsSession, objectArray);
        Integer n5 = (Integer)objectArray[0];
        byte[] byArray2 = (byte[])objectArray[1];
        String string6 = (String)objectArray[2];
        String string7 = (String)objectArray[3];
        byte[] byArray3 = (byte[])objectArray[4];
        Integer n6 = (Integer)objectArray[5];
        String string8 = (String)objectArray[6];
        Integer n7 = (Integer)objectArray[7];
        return AQjmsConsumer.convertToAQjmsMessages(aQjmsSession, n5, byArray2, string6, string7, byArray3, n6, string8, n7);
    }

    static AQjmsMessage convertToAQjmsMessages(AQjmsSession aQjmsSession, int n, byte[] byArray, String string, String string2, byte[] byArray2, int n2, String string3, int n3) throws JMSException {
        return AQjmsConsumer.convertToAQjmsMessages(aQjmsSession, n, byArray, string, string2, byArray2, n2, string3, n3, false);
    }

    static AQjmsMessage convertToAQjmsMessages(AQjmsSession aQjmsSession, int n, byte[] byArray, String string, String string2, byte[] byArray2, int n2, String string3, int n3, boolean bl) throws JMSException {
        AQjmsMessage aQjmsMessage = null;
        switch (n) {
            case 0: {
                try {
                    String string4 = byArray == null ? null : new String(byArray, "UTF8");
                    aQjmsMessage = new AQjmsTextMessage(aQjmsSession, string4);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    AQjmsError.throwEx("Failed to convert payload to String", (Throwable)unsupportedEncodingException);
                }
                break;
            }
            case 1: {
                aQjmsMessage = new AQjmsBytesMessage(aQjmsSession, byArray);
                break;
            }
            case 2: {
                if (bl) {
                    aQjmsMessage = new AQjmsStreamMessage(aQjmsSession, byArray, true);
                    break;
                }
                aQjmsMessage = new AQjmsStreamMessage(aQjmsSession, byArray);
                break;
            }
            case 3: {
                aQjmsMessage = new AQjmsMapMessage(aQjmsSession, byArray);
                break;
            }
            case 4: {
                aQjmsMessage = new AQjmsObjectMessage(aQjmsSession, byArray, false);
                break;
            }
            case 100: {
                aQjmsMessage = new AQjmsMessage(aQjmsSession, true);
                break;
            }
            default: {
                throw new JMSException("Unknow message type: " + n);
            }
        }
        aQjmsMessage.setAccessMode(2);
        aQjmsMessage.setJmsHeaders(string);
        aQjmsMessage.setUserProperties(string2);
        aQjmsMessage.setJMSMessageID(byArray2);
        aQjmsMessage.setJMSPriority(n2);
        aQjmsMessage.setJMSCorrelationID(string3);
        aQjmsMessage.setAccessMode(0);
        aQjmsMessage.setJMSExpiration(n3);
        return aQjmsMessage;
    }

    private native AQjmsMessage ocideq2(String var1, String var2, int var3, int var4, String var5, String var6, byte[] var7, int var8, int var9, long var10, boolean var12, long[] var13, long var14, String var16, AQjmsSession var17, Object[] var18) throws Exception;

    private native AQjmsMessage ocideq(String var1, String var2, int var3, boolean var4, int var5, int var6, String var7, String var8, byte[] var9, int var10, int var11, long var12, boolean var14, long[] var15, long var16, String var18, AQjmsSession var19) throws Exception;

    public synchronized String getMessageSelector() throws JMSException {
        this.checkClosed("getMessageSelector");
        if (!this.hasInfo) {
            AQjmsError.throwEx(233);
        }
        if (this.selector != null) {
            return this.selector.getSelectorString();
        }
        return null;
    }

    public synchronized MessageListener getMessageListener() throws JMSException {
        this.checkClosed("getMessageListener");
        if (this.jms_sess.getMessageListener() != null) {
            AQjmsError.throwEx(198);
        }
        if (AQjmsConstants.useJmsNotification() && this.cons_dest.isSharded() && AQjmsConstants.useJdbcAQ() && this.jms_sess.getDriver().equalsIgnoreCase("thin")) {
            if (this.ntfReg != null) {
                return this.ntfReg.getMessageListener();
            }
        } else if (this.m_lsnrWorker != null) {
            return this.m_lsnrWorker.getMessageListener();
        }
        return null;
    }

    synchronized AQjmsSelector getAQjmsSelector() throws JMSException {
        this.checkClosed("getAQjmsSelector");
        return this.selector;
    }

    Message receiveForListener() throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.receiveForListener", "entry");
        Message message = null;
        if (AQjmsConstants.useJdbcAQ() && this.jms_sess.getDriver().equalsIgnoreCase("thin") && !this.returnXMLType(this.cons_dest)) {
            int n = this.cons_dest.getPloadType();
            message = this.cons_dest.isSharded() && n != 1 && n != 4 ? this.jdbcDequeueSh(this.cons_dest, 0L, this.cons_name, 1, 3, true, this.visibility, 1) : this.jdbcDequeue(this.cons_dest, 0L, this.cons_name, 1, 3, true, this.visibility, 1);
        } else {
            message = this.dequeue(this.cons_dest, 0L, this.cons_name, 1, 3, null, true, this.visibility, 1);
        }
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.receiveForListener", "exit");
        return message;
    }

    private void doCommit(AQjmsSession aQjmsSession) throws JMSException {
        try {
            int n = aQjmsSession.getAcknowledgeMode();
            if (n == 1 || n == 3) {
                aQjmsSession.commitNoCheck();
                AQjmsOracleDebug.trace(3, "AQjmsConsumer.doCommit", "acknowledged one message received by committing the database connection");
            }
        }
        catch (Exception exception) {
            AQjmsError.throwEx(120, (Throwable)exception);
        }
    }

    public synchronized void setMessageListener(MessageListener messageListener) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.setMessageListener", "entry");
        this.checkClosed("setMessageListener(MessageListener)");
        if (this.jms_sess.getMessageListener() != null) {
            AQjmsError.throwEx(198);
        }
        if (AQjmsConstants.useJmsNotification() && this.cons_dest.isSharded() && AQjmsConstants.useJdbcAQ() && this.jms_sess.getDriver().equalsIgnoreCase("thin")) {
            this.setMessageListenerForNotification(messageListener);
        } else if (this.m_lsnrWorker != null) {
            this.m_lsnrWorker.setMessageListener(messageListener);
            if (messageListener == null) {
                this.m_lsnrWorker = null;
            }
        } else {
            this.m_lsnrWorker = new AQjmsListenerWorker(this.jms_sess, this, messageListener);
            this.m_lsnrWorker.launch();
        }
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.setMessageListener", "exit");
    }

    synchronized void setPrivilegedMessageListener(MessageListener messageListener) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.setMessageListener", "entry");
        this.checkClosed("setPrivilegedMessageListener(MessageListener)");
        if (this.m_lsnrWorker != null) {
            this.m_lsnrWorker.setMessageListener(messageListener);
            if (messageListener == null) {
                this.m_lsnrWorker = null;
            }
        } else {
            this.m_lsnrWorker = new AQjmsListenerWorker(this.jms_sess, this, messageListener);
            this.m_lsnrWorker.launch();
        }
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.setMessageListener", "exit");
    }

    public synchronized void setMessageListener(MessageListener messageListener, DispatchScheduler dispatchScheduler, ThreadProxy threadProxy) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.setMessageListener", "entry");
        this.checkClosed("setMessageListener(MessageListener, DispatchScheduler");
        if (this.jms_sess.getMessageListener() != null) {
            AQjmsError.throwEx(198);
        }
        if (this.m_lsnrWorker != null) {
            this.m_lsnrWorker.setMessageListener(messageListener, dispatchScheduler);
            if (messageListener == null) {
                this.m_lsnrWorker = null;
            }
        } else {
            this.m_lsnrWorker = new AQjmsListenerWorker(this.jms_sess, this, messageListener, dispatchScheduler);
            this.m_lsnrWorker.launch(threadProxy);
        }
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.setMessageListener", "exit");
    }

    public synchronized Thread getListenerWorkerThread() {
        if (this.m_lsnrWorker != null) {
            return this.m_lsnrWorker.getListenerWorkerThread();
        }
        return null;
    }

    public Message receive() throws JMSException {
        return this.receiveFromAQ(-1L);
    }

    public Message receiveNoWait() throws JMSException {
        return this.receiveFromAQ(0L);
    }

    public Message receive(long l) throws JMSException {
        if (l == 0L) {
            l = -1L;
        }
        return this.receiveFromAQ(l);
    }

    @Override
    public Message receive(AQjmsSignature aQjmsSignature) throws JMSException {
        return this.receiveFromAQ(-1L, aQjmsSignature);
    }

    @Override
    public Message receive(long l, AQjmsSignature aQjmsSignature) throws JMSException {
        if (l == 0L) {
            l = -1L;
        }
        return this.receiveFromAQ(l, aQjmsSignature);
    }

    public Message bufferReceive() throws JMSException {
        if (this.cons_dest.isSharded()) {
            AQjmsError.throwEx(244, "bufferReceive");
        }
        return this.receiveFromAQ(-1L, null, 1, 3);
    }

    public Message bufferReceiveNoWait() throws JMSException {
        if (this.cons_dest.isSharded()) {
            AQjmsError.throwEx(244, "bufferReceiveNoWait");
        }
        return this.receiveFromAQ(0L, null, 1, 3);
    }

    public Message bufferReceive(long l) throws JMSException {
        if (this.cons_dest.isSharded()) {
            AQjmsError.throwEx(244, "bufferReceive");
        }
        return this.bufferReceive(l, null);
    }

    public Message bufferReceive(long l, AQjmsSignature aQjmsSignature) throws JMSException {
        if (this.cons_dest.isSharded()) {
            AQjmsError.throwEx(244, "bufferReceive");
        }
        if (l == 0L) {
            l = -1L;
        }
        return this.receiveFromAQ(l, aQjmsSignature, 1, 3);
    }

    Message receiveFromAQ(long l) throws JMSException {
        return this.receiveFromAQ(l, null);
    }

    Message receiveFromAQ(long l, AQjmsSignature aQjmsSignature) throws JMSException {
        return this.receiveFromAQ(l, aQjmsSignature, this.visibility, 1);
    }

    Message receiveFromAQ(long l, AQjmsSignature aQjmsSignature, int n, int n2) throws JMSException {
        Message message = null;
        AQjmsConnection aQjmsConnection = null;
        String string = null;
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.receive-2", "entry");
        if (!this.lockReceive("receiveFromAQ(sig)", l)) {
            return null;
        }
        try {
            int n3;
            this.CheckConnClosed("receiveFromAQ");
            this.jms_sess.checkConnectionClosed();
            aQjmsConnection = this.jms_sess.getJmsConnection();
            if (this.jms_sess.getMessageListener() != null) {
                AQjmsError.throwEx(198);
            }
            AQjmsOracleDebug.trace(5, "AQjmsConsumer.receive-2", "timeout(millisecs): " + l);
            this.jms_sess.checkForGlobalTxn();
            if (this.first_receive) {
                n3 = 1;
                this.first_receive = false;
            } else {
                n3 = this.navig_mode;
            }
            if (this.cons_dest.isTopic() && this.jms_sess.diffSubName(this.cons_name) || WebLogicHelper.runningInWLServer() && this.jms_sess.isInGlobalTransaction() && this.jms_sess.wlsXaTopicNextDisabled) {
                n3 = 1;
            }
            if (AQjmsConstants.useJdbcAQ() && this.jms_sess.getDriver().equalsIgnoreCase("thin") && !this.returnXMLType(this.cons_dest)) {
                AQjmsOracleDebug.trace(2, "AQjmsConsumer.receiveFromAQ", "taking jdbc AQ dequeue code path");
                int n4 = this.cons_dest.getPloadType();
                message = this.cons_dest.isSharded() && n4 != 1 && n4 != 4 ? this.jdbcDequeueCommonSh(this.cons_dest, l, this.cons_name, n3, this.deq_mode, false, n, n2) : this.jdbcDequeueCommon(this.cons_dest, l, this.cons_name, n3, this.deq_mode, false, n, n2);
            } else {
                AQjmsOracleDebug.trace(2, "AQjmsConsumer.receiveFromAQ", "taking PL/SQL dequeue code path");
                message = this.dequeue(this.cons_dest, l, this.cons_name, n3, this.deq_mode, aQjmsSignature, false, n, n2);
            }
        }
        catch (JMSException jMSException) {
            int n5 = 0;
            try {
                n5 = Integer.parseInt(jMSException.getErrorCode());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (Integer.toString(257).equals(jMSException.getErrorCode())) {
                AQjmsOracleDebug.trace(0, "AQjmsConsumer.receiveFromAQ", "jdbcReadTimeout: " + AQjmsConstants.getJdbcReadTimeOut() + ", jmsNetworkTimeout: " + AQjmsConstants.getNetworkTimeOut() + ", networkTimeoutFactor: " + AQjmsConstants.getNetworkTimeOutFactor() + ", receiveTimeout: " + l);
                string = Integer.toString(257);
            }
            Object object = jMSException.getMessage();
            if (this.jms_sess != null && this.jms_sess.jdbcConnInfo != null) {
                object = (String)object + ". JDBC Connection Info:" + this.jms_sess.jdbcConnInfo.toString();
            }
            AQjmsException aQjmsException = new AQjmsException((String)object, n5, jMSException);
            throw aQjmsException;
        }
        finally {
            this.unlock("receiveFromAQ(sig)");
            if (Integer.toString(257).equals(string)) {
                try {
                    aQjmsConnection.close();
                }
                catch (Exception exception) {}
            }
        }
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.receive-2", "exit");
        return message;
    }

    private boolean returnXMLType(AQjmsDestination aQjmsDestination) throws JMSException {
        String string = this.transfxm == null ? aQjmsDestination.getAdtType() : AQjmsUtil.getTransType(this.jms_sess.getDBConnection(), aQjmsDestination, this.transfxm).getDestType();
        return "SYS.XMLTYPE".equalsIgnoreCase(string);
    }

    Message jdbcDequeue(AQjmsDestination aQjmsDestination, long l, String string, int n, int n2, boolean bl, int n3, int n4) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.jdbcDequeue", "entry");
        this.checkClosed("jdbcDequeue");
        Message message = this.jdbcDequeueCommon(aQjmsDestination, l, string, n, n2, bl, n3, n4);
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.jdbcDequeue", "exit");
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Message jdbcDequeueCommon(AQjmsDestination aQjmsDestination, long l, String string, int n, int n2, boolean bl, int n3, int n4) throws JMSException {
        String string3;
        oracle.jdbc.OracleConnection oracleConnection = null;
        try {
            oracleConnection = (oracle.jdbc.OracleConnection)this.jms_sess.getDBConnection();
        }
        catch (Exception exception) {
            AQjmsOracleDebug.traceEx(3, "AQjmsConsumer.jdbcDequeue", exception);
            AQjmsError.throwEx(112, (Throwable)exception);
        }
        AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "After getDbConnection");
        AQjmsMessage aQjmsMessage = null;
        int n5 = 0;
        try {
            Object object;
            AQMessage aQMessage;
            String string2;
            block104: {
                int n6;
                AQDequeueOptions aQDequeueOptions = new AQDequeueOptions();
                aQDequeueOptions.setRetrieveMessageId(true);
                if (aQjmsDestination == null) {
                    AQjmsError.throwEx(200);
                }
                if ((string3 = aQjmsDestination.getCompleteName()) == null) {
                    AQjmsError.throwEx(200);
                }
                string2 = null;
                string2 = aQjmsDestination.isJson() ? "JSON" : (this.transfxm == null ? aQjmsDestination.getAdtType() : AQjmsUtil.getTransType(this.jms_sess.getDBConnection(), aQjmsDestination, this.transfxm).getDestType());
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "destination name: " + string3 + "  destination data type: " + string2);
                aQDequeueOptions.setConsumerName(string);
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "consumer name: " + string);
                if (this.selector != null) {
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "selector: " + this.selector);
                    if (this.selector.getSelectorType() == 30) {
                        aQDequeueOptions.setDequeueMessageId(this.selector.getSelectorMessageId());
                        AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "selector msgid: " + RepConversion.bArray2String((byte[])this.selector.getSelectorMessageId()));
                    } else if (this.selector.getSelectorType() == 20) {
                        aQDequeueOptions.setCorrelation(this.selector.getSelectorCorrelationId());
                        AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "selector correlation: " + this.selector.getSelectorCorrelationId());
                    } else if (this.selector.getSelectorType() == 50) {
                        aQDequeueOptions.setCondition(this.selector.getRule());
                        AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "selector dequeue condition: " + this.selector.getRule());
                    }
                }
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "dequeue mode: " + n2 + " navigation: " + n);
                aQDequeueOptions.setDequeueMode(AQjmsConstants.toDequeueModeEnum(n2));
                aQDequeueOptions.setNavigation(AQjmsConstants.toNavigationEnum(n));
                if (n3 != 1) {
                    n4 = 1;
                }
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "visibility : " + n3 + " delivery mode: " + n4);
                aQDequeueOptions.setVisibility(AQjmsConstants.toDequeueVisibilityEnum(n3));
                aQDequeueOptions.setDeliveryFilter(AQjmsConstants.toDeliveryFilterEnum(n4));
                aQDequeueOptions.setTransformation(this.transfxm);
                long[] lArray = this.calculateValuesForTimeout(l);
                long l5 = lArray[0];
                long l4 = lArray[1];
                long l3 = lArray[2];
                long l2 = lArray[3];
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "Timeout: " + l5 + " seconds.  Iterations: " + l3 + " Interval: " + l4 + " Last interval: " + l2);
                aQDequeueOptions.setWait((int)l4);
                aQMessage = null;
                if (l5 != -1L) {
                    if (this.jms_sess.isNetworkTimeoutRequired() && l != 0L) {
                        try {
                            n5 = oracleConnection.getNetworkTimeout();
                            if (AQjmsConstants.getNetworkTimeOut() != -1 && (long)AQjmsConstants.getNetworkTimeOut() > l) {
                                AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "Network Timeout in milliseconds: " + AQjmsConstants.getNetworkTimeOut());
                                oracleConnection.setNetworkTimeout((Executor)Executors.newSingleThreadExecutor(), AQjmsConstants.getNetworkTimeOut());
                            } else {
                                AQjmsOracleDebug.trace(5, "TESTING AQjmsConsumer.jdbcDequeue", "Network Timeout in milliseconds: " + new Long(l * (long)AQjmsConstants.getNetworkTimeOutFactor()).intValue());
                                oracleConnection.setNetworkTimeout((Executor)Executors.newSingleThreadExecutor(), new Long(l * (long)AQjmsConstants.getNetworkTimeOutFactor()).intValue());
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    n6 = 0;
                } else {
                    while (true) {
                        try {
                            do {
                                AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "wait time: " + l4);
                            } while ((aQMessage = this.jdbcConnectionDequeueCheck25242(oracleConnection, string3, aQDequeueOptions, string2)) == null);
                            break block104;
                        }
                        catch (SQLException sQLException) {
                            AQjmsOracleDebug.traceEx(3, "AQjmsConsumer.jdbcDequeue", sQLException);
                            if (sQLException.getErrorCode() == 25228) continue;
                            if (sQLException.getErrorCode() != 25263) throw sQLException;
                            if (!this.isClosed()) continue;
                            Message message = null;
                            if (n5 == 0) return message;
                            if (oracleConnection == null) return message;
                            try {
                                AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "Setting network timeout to: " + n5);
                                oracleConnection.setNetworkTimeout((Executor)Executors.newSingleThreadExecutor(), n5);
                                return message;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            return message;
                        }
                        break;
                    }
                }
                while ((long)n6 < l3) {
                    block105: {
                        try {
                            if ((long)n6 == l3 - 1L) {
                                aQDequeueOptions.setWait((int)l2);
                            }
                            AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "wait time: " + l2);
                            aQMessage = this.jdbcConnectionDequeueCheck25242(oracleConnection, string3, aQDequeueOptions, string2);
                            if (aQMessage != null) {
                                break;
                            }
                        }
                        catch (SQLException sQLException) {
                            AQjmsOracleDebug.traceEx(3, "AQjmsConsumer.jdbcDequeue", sQLException);
                            if (sQLException.getErrorCode() != 25228) {
                                if (sQLException.getErrorCode() != 25263) throw sQLException;
                            }
                            if (!this.isClosed()) break block105;
                            Message message = null;
                            if (n5 == 0) return message;
                            if (oracleConnection == null) return message;
                            try {
                                AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "Setting network timeout to: " + n5);
                                oracleConnection.setNetworkTimeout((Executor)Executors.newSingleThreadExecutor(), n5);
                                return message;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            return message;
                        }
                    }
                    ++n6;
                }
            }
            if (aQMessage == null || n2 == 4) {
                AQjmsOracleDebug.trace(4, "AQjmsConsumer.jdbcDequeue", "remove no data");
                Message message = null;
                return message;
            }
            ANYDATA aNYDATA = null;
            OracleStruct oracleStruct = null;
            OracleJsonDatum oracleJsonDatum = null;
            int n7 = 0;
            if (aQMessage.isANYDATAPayload()) {
                aNYDATA = aQMessage.getANYDATAPayload();
            } else if (aQMessage.isSTRUCTPayload()) {
                oracleStruct = (OracleStruct)aQMessage.getStructPayload();
                n7 = oracleStruct.getOracleMetaData().getTypeCode();
            } else if (aQMessage.isJSONPayload()) {
                oracleJsonDatum = aQMessage.getJSONPayload();
            } else {
                AQjmsError.throwEx(122, "invalid message payload type");
            }
            AQjmsOracleDebug.trace(4, "AQjmsConsumer.jdbcDequeue", "payload type:" + string2 + "payload type code:" + n7);
            if (string2.equalsIgnoreCase("SYS.AQ$_JMS_MESSAGE")) {
                AQjmsGenMessage_C aQjmsGenMessage_C = (AQjmsGenMessage_C)AQjmsGenMessage_C.getFactory().create((Object)oracleStruct, n7);
                int n8 = aQjmsGenMessage_C.getMessageType();
                switch (n8) {
                    case 0: {
                        aQjmsMessage = new AQjmsTextMessage(this.jms_sess, aQjmsGenMessage_C);
                        break;
                    }
                    case 1: {
                        aQjmsMessage = new AQjmsBytesMessage(this.jms_sess, aQjmsGenMessage_C);
                        break;
                    }
                    case 2: {
                        aQjmsMessage = new AQjmsStreamMessage(this.jms_sess, aQjmsGenMessage_C);
                        break;
                    }
                    case 3: {
                        aQjmsMessage = new AQjmsMapMessage(this.jms_sess, aQjmsGenMessage_C);
                        break;
                    }
                    case 4: {
                        aQjmsMessage = new AQjmsObjectMessage(this.jms_sess, aQjmsGenMessage_C);
                        break;
                    }
                    default: {
                        AQjmsError.throwEx(108, "The message_type within aq$_jms_message ADT " + n8 + " is not valid JMS message type");
                    }
                }
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "general payload messaeg retrieved");
            } else if (string2.equalsIgnoreCase("SYS.AQ$_JMS_TEXT_MESSAGE")) {
                AQjmsTextMessage_C aQjmsTextMessage_C = (AQjmsTextMessage_C)AQjmsTextMessage_C.getFactory().create((Object)oracleStruct, n7);
                aQjmsMessage = new AQjmsTextMessage(this.jms_sess, aQjmsTextMessage_C);
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "text_message retrieved");
            } else if (string2.equalsIgnoreCase("SYS.AQ$_JMS_BYTES_MESSAGE")) {
                AQjmsBytesMessage_C aQjmsBytesMessage_C = (AQjmsBytesMessage_C)AQjmsBytesMessage_C.getFactory().create((Object)oracleStruct, n7);
                aQjmsMessage = new AQjmsBytesMessage(this.jms_sess, aQjmsBytesMessage_C);
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "bytes_message retrieved");
            } else if (string2.equalsIgnoreCase("SYS.AQ$_JMS_MAP_MESSAGE")) {
                AQjmsMapMessage_C aQjmsMapMessage_C = (AQjmsMapMessage_C)AQjmsMapMessage_C.getFactory().create((Object)oracleStruct, n7);
                aQjmsMessage = new AQjmsMapMessage(this.jms_sess, aQjmsMapMessage_C);
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "map_message retrieved");
            } else if (string2.equalsIgnoreCase("SYS.AQ$_JMS_OBJECT_MESSAGE")) {
                AQjmsObjectMessage_C aQjmsObjectMessage_C = (AQjmsObjectMessage_C)AQjmsObjectMessage_C.getFactory().create((Object)oracleStruct, n7);
                aQjmsMessage = new AQjmsObjectMessage(this.jms_sess, aQjmsObjectMessage_C, this.xml_receive);
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "object_message retrieved");
            } else if (string2.equalsIgnoreCase("SYS.AQ$_JMS_STREAM_MESSAGE")) {
                AQjmsStreamMessage_C aQjmsStreamMessage_C = (AQjmsStreamMessage_C)AQjmsStreamMessage_C.getFactory().create((Object)oracleStruct, n7);
                aQjmsMessage = new AQjmsStreamMessage(this.jms_sess, aQjmsStreamMessage_C);
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "stream_message retrieved");
            } else if (string2.equalsIgnoreCase("SYS.ANYDATA")) {
                aQjmsMessage = this.convertAnydataToMessage(aNYDATA);
            } else {
                if (this.od_factory != null) {
                    OracleData oracleData = this.od_factory.create((Object)oracleStruct, n7);
                    aQjmsMessage = new AQjmsAdtMessage(this.jms_sess, oracleData);
                } else if (this.cd_factory != null) {
                    CustomDatum customDatum = this.cd_factory.create((Datum)oracleStruct, n7);
                    aQjmsMessage = new AQjmsAdtMessage(this.jms_sess, customDatum);
                } else if (this.orad_factory != null) {
                    ORAData oRAData = this.orad_factory.create((Datum)oracleStruct, n7);
                    aQjmsMessage = new AQjmsAdtMessage(this.jms_sess, oRAData);
                } else if (oracleJsonDatum != null) {
                    aQjmsMessage = new AQjmsJsonMessage(this.jms_sess, oracleJsonDatum);
                } else {
                    AQjmsError.throwEx(129);
                }
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "adt message retrieved");
            }
            AQMessageProperties aQMessageProperties = aQMessage.getMessageProperties();
            long l6 = aQMessageProperties.getEnqueueTime().getTime();
            aQjmsMessage.setEnqueueTime(l6);
            AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "set AQ enqueue time as " + l6);
            aQjmsMessage.setMessageState(aQMessageProperties.getState().getCode());
            byte[] byArray = aQMessage.getMessageId();
            aQjmsMessage.setJMSMessageID(byArray);
            String string4 = aQMessageProperties.getCorrelation();
            aQjmsMessage.setJMSCorrelationID(string4);
            int n9 = aQMessageProperties.getPriority();
            aQjmsMessage.setJMSPriority(n9);
            AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "msg_id: " + RepConversion.bArray2String((byte[])byArray) + " corrid: " + string4 + " priority: " + n9);
            int n10 = aQMessageProperties.getDelay();
            aQjmsMessage.setDelay(n10);
            AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "msg_delay(secs): " + n10);
            int n11 = aQMessageProperties.getExpiration();
            aQjmsMessage.setJMSExpiration(n11);
            AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "exptime(secs): " + n11);
            int n12 = aQMessageProperties.getDequeueAttemptsCount();
            aQjmsMessage.setAttempts(n12);
            AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "attempts: " + n12);
            if (n12 > 0) {
                aQjmsMessage.setJMSRedelivered(true);
            } else {
                aQjmsMessage.setJMSRedelivered(false);
            }
            String string5 = aQMessageProperties.getExceptionQueue();
            aQjmsMessage.setExceptionQueue(string5);
            AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "exception queue: " + string5);
            AQAgent aQAgent = aQMessageProperties.getSender();
            if (aQAgent != null && aQAgent.getName() != null && !aQAgent.getName().equals("")) {
                object = new AQjmsAgent(aQAgent.getName(), aQAgent.getAddress(), aQAgent.getProtocol());
                aQjmsMessage.setSenderID((AQjmsAgent)object);
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "Sender: " + (AQjmsAgent)object);
            }
            aQjmsMessage.setOriginalMessageId(aQMessageProperties.getPreviousQueueMessageId());
            if (aQjmsMessage.isJMSBody() && this.jms_sess.getCompliant()) {
                aQjmsMessage.setJMSPriority(AQjmsMessage.toJMSPriority(aQjmsMessage.getJMSPriority()));
            }
            if (!(aQjmsMessage instanceof AQjmsAdtMessage) && !(aQjmsMessage instanceof AQjmsJsonMessage)) {
                object = aQjmsMessage.getMessageHeaderExt();
                AQjmsPropertyList aQjmsPropertyList = object == null ? null : ((AQjmsMessageHeaderExt)object).getProperties();
                Hashtable hashtable = null;
                hashtable = aQjmsPropertyList == null ? new Hashtable() : AQjmsMessage.convertPropertyListToHashtable(aQjmsPropertyList);
                aQjmsMessage.setPropertiesHashtable(hashtable);
                if (hashtable != null && hashtable.get("JMS_OracleHeaderOnly") != null) {
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", " Header only, Copying to generic msg");
                    aQjmsMessage = new AQjmsMessage(aQjmsMessage);
                    aQjmsMessage.setHeaderOnly();
                }
                if (hashtable != null && hashtable.get("JMS_OracleDeliveryMode") != null) {
                    aQjmsMessage.setJMSDeliveryMode(aQjmsMessage.getIntProperty("JMS_OracleDeliveryMode"));
                }
            }
            if (aQjmsMessage.getJMSExpiration() <= 0L) {
                aQjmsMessage.setJMSExpiration(0L);
            } else {
                aQjmsMessage.setJMSExpiration(aQjmsMessage.getJMSExpiration() * 1000L + aQjmsMessage.getJMSTimestamp());
            }
            long l7 = System.currentTimeMillis();
            aQjmsMessage.setReceiveTime(l7);
            AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "recv_time: " + l7);
            aQjmsMessage.setPropReadOnly(true);
            aQjmsMessage.setAccessMode(0);
            aQjmsMessage.setJMSDestination((Destination)aQjmsDestination);
            if (bl) return aQjmsMessage;
            this.doCommit(this.jms_sess);
            return aQjmsMessage;
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() == 1013) {
                string3 = null;
                return string3;
            }
            if (sQLException.getErrorCode() == 17002) {
                AQjmsOracleDebug.trace(0, "AQjmsConsumer.jdbcDequeue", "Err ORA-17002 caused JMS-257");
                AQjmsError.throwEx(257, (Throwable)sQLException);
            }
            AQjmsError.throwEx(120, (Throwable)sQLException);
            return aQjmsMessage;
        }
        catch (Exception exception) {
            AQjmsOracleDebug.traceEx(3, "AQjmsConsumer.jdbcDequeue", exception);
            AQjmsError.throwEx(120, (Throwable)exception);
            return aQjmsMessage;
        }
        finally {
            if (n5 != 0 && oracleConnection != null) {
                try {
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "Setting network timeout to: " + n5);
                    oracleConnection.setNetworkTimeout((Executor)Executors.newSingleThreadExecutor(), n5);
                }
                catch (Exception exception) {}
            }
        }
    }

    private Message jdbcDequeueSh(AQjmsDestination aQjmsDestination, long l, String string, int n, int n2, boolean bl, int n3, int n4) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.jdbcDequeueSh", "entry");
        this.checkClosed("jdbcDequeueSh");
        Message message = this.jdbcDequeueCommonSh(aQjmsDestination, l, string, n, n2, bl, n3, n4);
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.jdbcDequeueSh", "exit");
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Message jdbcDequeueCommonSh(AQjmsDestination aQjmsDestination, long l, String string, int n, int n2, boolean bl, int n3, int n4) throws JMSException {
        String string2;
        OracleConnection oracleConnection = null;
        try {
            oracleConnection = (OracleConnection)this.jms_sess.getDBConnection();
        }
        catch (Exception exception) {
            AQjmsOracleDebug.traceEx(3, "AQjmsConsumer.jdbcDequeueSh", exception);
            AQjmsError.throwEx(112, (Throwable)exception);
        }
        AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeueSh", "After getDbConnection");
        AQjmsMessage aQjmsMessage = null;
        int n5 = 0;
        try {
            JMSMessage jMSMessage;
            block67: {
                int n6;
                JMSDequeueOptions jMSDequeueOptions = new JMSDequeueOptions();
                jMSDequeueOptions.setRetrieveMessageId(true);
                if (aQjmsDestination == null) {
                    AQjmsError.throwEx(200);
                }
                if ((string2 = aQjmsDestination.getCompleteName()) == null) {
                    AQjmsError.throwEx(200);
                }
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeueSh", "destination name: " + string2);
                jMSDequeueOptions.setConsumerName(string);
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeueSh", "consumer name: " + string);
                if (this.selector != null) {
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeueSh", "selector: " + this.selector);
                    if (this.selector.getSelectorType() == 30) {
                        jMSDequeueOptions.setDequeueMessageId(this.selector.getSelectorMessageId());
                        AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeueSh", "selector msgid: " + RepConversion.bArray2String((byte[])this.selector.getSelectorMessageId()));
                    } else if (this.selector.getSelectorType() == 20) {
                        jMSDequeueOptions.setCorrelation(this.selector.getSelectorCorrelationId());
                        AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeueSh", "selector correlation: " + this.selector.getSelectorCorrelationId());
                    } else if (this.selector.getSelectorType() == 50) {
                        jMSDequeueOptions.setCondition(this.selector.getRule());
                        AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeueSh", "selector dequeue condition: " + this.selector.getRule());
                    }
                }
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeueSh", "dequeue mode: " + n2 + " navigation: " + n);
                jMSDequeueOptions.setDequeueMode(AQjmsConstants.toJmsDequeueModeEnum(n2));
                n4 = 3;
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeueSh", "visibility : " + n3 + " delivery mode: " + n4);
                jMSDequeueOptions.setVisibility(AQjmsConstants.toJmsDequeueVisibilityEnum(n3));
                jMSDequeueOptions.setDeliveryMode(AQjmsConstants.toJmsDeliveryFilterEnum(n4));
                long[] lArray = this.calculateValuesForTimeout(l);
                long l5 = lArray[0];
                long l4 = lArray[1];
                long l3 = lArray[2];
                long l2 = lArray[3];
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeueSh", "Timeout: " + l5 + " seconds.  Iterations: " + l3 + " Interval: " + l4 + " Last interval: " + l2);
                jMSDequeueOptions.setWait((int)l4);
                if (AQjmsConstants.useJmsStreaming() && this.jms_sess.getDriver().equalsIgnoreCase("thin") && !bl && (this.jms_sess.getAcknowledgeMode() == 2 || this.jms_sess.getAcknowledgeMode() == 0)) {
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeueSh", "Streaming is enabled by the client");
                    jMSDequeueOptions.setStreamingMode(JMSDequeueOptions.StreamingMode.DEQ_STREAMING_FLAG_GET_LOB_LOCATOR);
                }
                jMSMessage = null;
                if (l5 != -1L) {
                    if (this.jms_sess.isNetworkTimeoutRequired() && l != 0L) {
                        try {
                            n5 = oracleConnection.getNetworkTimeout();
                            if (AQjmsConstants.getNetworkTimeOut() != -1 && (long)AQjmsConstants.getNetworkTimeOut() > l) {
                                AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "Network Timeout in milliseconds: " + new Long(l * (long)AQjmsConstants.getNetworkTimeOutFactor()).intValue());
                                oracleConnection.setNetworkTimeout((Executor)Executors.newSingleThreadExecutor(), AQjmsConstants.getNetworkTimeOut());
                            } else {
                                AQjmsOracleDebug.trace(5, "TESTING AQjmsConsumer.jdbcDequeue", "Network Timeout in milliseconds: " + new Long(l * (long)AQjmsConstants.getNetworkTimeOutFactor()).intValue());
                                oracleConnection.setNetworkTimeout((Executor)Executors.newSingleThreadExecutor(), new Long(l * (long)AQjmsConstants.getNetworkTimeOutFactor()).intValue());
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    n6 = 0;
                } else {
                    while (true) {
                        try {
                            do {
                                AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeueSh", "wait time: " + l4);
                            } while ((jMSMessage = this.jdbcConnectionDequeueCheck25242Sh(oracleConnection, string2, jMSDequeueOptions)) == null);
                            break block67;
                        }
                        catch (SQLException sQLException) {
                            AQjmsOracleDebug.traceEx(3, "AQjmsConsumer.jdbcDequeueSh", sQLException);
                            if (sQLException.getErrorCode() == 25228) continue;
                            if (sQLException.getErrorCode() != 25263) throw sQLException;
                            if (!this.isClosed()) continue;
                            Message message = null;
                            if (n5 == 0) return message;
                            if (oracleConnection == null) return message;
                            try {
                                AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "Setting network timeout to: " + n5);
                                oracleConnection.setNetworkTimeout((Executor)Executors.newSingleThreadExecutor(), n5);
                                return message;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            return message;
                        }
                        break;
                    }
                }
                while ((long)n6 < l3) {
                    block68: {
                        try {
                            if ((long)n6 == l3 - 1L) {
                                jMSDequeueOptions.setWait((int)l2);
                            }
                            AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeueSh", "wait time: " + l2);
                            jMSMessage = this.jdbcConnectionDequeueCheck25242Sh(oracleConnection, string2, jMSDequeueOptions);
                            if (jMSMessage != null) {
                                break;
                            }
                        }
                        catch (SQLException sQLException) {
                            AQjmsOracleDebug.traceEx(3, "AQjmsConsumer.jdbcDequeueSh", sQLException);
                            if (sQLException.getErrorCode() != 25228) {
                                if (sQLException.getErrorCode() != 25263) throw sQLException;
                            }
                            if (!this.isClosed()) break block68;
                            Message message = null;
                            if (n5 == 0) return message;
                            if (oracleConnection == null) return message;
                            try {
                                AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "Setting network timeout to: " + n5);
                                oracleConnection.setNetworkTimeout((Executor)Executors.newSingleThreadExecutor(), n5);
                                return message;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            return message;
                        }
                    }
                    ++n6;
                }
            }
            if (jMSMessage == null || n2 == 4) {
                AQjmsOracleDebug.trace(4, "AQjmsConsumer.jdbcDequeueSh", "remove no data");
                Message message = null;
                return message;
            }
            byte[] byArray = jMSMessage.getMessageId();
            byte[] byArray2 = jMSMessage.getPayload();
            JMSMessageProperties jMSMessageProperties = jMSMessage.getJMSMessageProperties();
            String string3 = jMSMessageProperties.getHeaderProperties();
            String string4 = jMSMessageProperties.getUserProperties();
            JMSMessageProperties.JMSMessageType jMSMessageType = jMSMessageProperties.getJMSMessageType();
            int n7 = jMSMessageType.getCode();
            AQMessageProperties aQMessageProperties = jMSMessage.getAQMessageProperties();
            int n8 = aQMessageProperties.getPriority();
            String string5 = aQMessageProperties.getCorrelation();
            int n9 = aQMessageProperties.getExpiration();
            long l6 = 0L;
            boolean bl2 = false;
            int n10 = 0;
            n10 = string4.lastIndexOf(",23,JMS_OracleMessageLength");
            if (n10 >= 1) {
                l6 = Long.parseLong(string4.substring(string4.lastIndexOf(",") + 1).trim());
                string4 = string4.substring(0, n10);
                String string6 = string4.substring(0, string4.indexOf(","));
                string4 = string4.replaceFirst(string6, Long.toString(Long.parseLong(string6) - 1L));
                bl2 = true;
            }
            AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeueSh", "msg_id: " + RepConversion.bArray2String((byte[])byArray) + " type: " + n7 + " corrid: " + string5 + " priority: " + n8 + " headerProperties: " + string3 + " userProperties: " + string4);
            aQjmsMessage = AQjmsConsumer.convertToAQjmsMessages(this.jms_sess, n7, byArray2, string3, string4, byArray, n8, string5, n9, bl2);
            long l7 = aQMessageProperties.getEnqueueTime().getTime();
            aQjmsMessage.setEnqueueTime(l7);
            AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeueSh", "set AQ enqueue time as " + l7);
            aQjmsMessage.setMessageState(aQMessageProperties.getState().getCode());
            int n11 = aQMessageProperties.getDelay();
            aQjmsMessage.setDelay(n11);
            AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeueSh", "msg_delay(secs): " + n11);
            int n12 = aQMessageProperties.getExpiration();
            aQjmsMessage.setJMSExpiration(n12);
            AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeueSh", "exptime(secs): " + n12);
            int n13 = aQMessageProperties.getDequeueAttemptsCount();
            aQjmsMessage.setAttempts(n13);
            AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeueSh", "attempts: " + n13);
            if (n13 > 0) {
                aQjmsMessage.setJMSRedelivered(true);
            } else {
                aQjmsMessage.setJMSRedelivered(false);
            }
            String string7 = aQMessageProperties.getExceptionQueue();
            aQjmsMessage.setExceptionQueue(string7);
            AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeueSh", "exception queue: " + string7);
            AQAgent aQAgent = aQMessageProperties.getSender();
            if (aQAgent != null && aQAgent.getName() != null && !aQAgent.getName().equals("")) {
                AQjmsAgent aQjmsAgent = new AQjmsAgent(aQAgent.getName(), aQAgent.getAddress(), aQAgent.getProtocol());
                aQjmsMessage.setSenderID(aQjmsAgent);
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeueSh", "Sender: " + aQjmsAgent);
            }
            aQjmsMessage.setOriginalMessageId(aQMessageProperties.getPreviousQueueMessageId());
            if (aQjmsMessage.getJMSExpiration() <= 0L) {
                aQjmsMessage.setJMSExpiration(0L);
            } else {
                aQjmsMessage.setJMSExpiration(aQjmsMessage.getJMSExpiration() * 1000L + aQjmsMessage.getJMSTimestamp());
            }
            long l8 = System.currentTimeMillis();
            aQjmsMessage.setReceiveTime(l8);
            AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeueSh", "recv_time: " + l8);
            aQjmsMessage.setPropReadOnly(true);
            aQjmsMessage.setJMSDestination((Destination)aQjmsDestination);
            if (bl2) {
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeueSh", "bodyLength : " + l6);
                aQjmsMessage.setBodyLength(l6);
                aQjmsMessage.setLargeBody(true);
                aQjmsMessage.setLobLocator(byArray2);
                return aQjmsMessage;
            }
            if (bl) return aQjmsMessage;
            this.doCommit(this.jms_sess);
            return aQjmsMessage;
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() == 1013) {
                string2 = null;
                return string2;
            }
            if (sQLException.getErrorCode() == 17002) {
                AQjmsOracleDebug.trace(0, "AQjmsConsumer.jdbcDequeue", "Err ORA-17002 caused JMS-257");
                AQjmsError.throwEx(257, (Throwable)sQLException);
            }
            AQjmsError.throwEx(120, (Throwable)sQLException);
            return aQjmsMessage;
        }
        catch (Exception exception) {
            AQjmsOracleDebug.traceEx(3, "AQjmsConsumer.jdbcDequeueSh", exception);
            AQjmsError.throwEx(120, (Throwable)exception);
            return aQjmsMessage;
        }
        finally {
            if (n5 != 0 && oracleConnection != null) {
                try {
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcDequeue", "Setting network timeout to: " + n5);
                    oracleConnection.setNetworkTimeout((Executor)Executors.newSingleThreadExecutor(), n5);
                }
                catch (Exception exception) {}
            }
        }
    }

    private void executeDequeueSqlCheck25242(int n) throws SQLException {
        try {
            this.deq_stmt.execute();
        }
        catch (SQLException sQLException) {
            if (WebLogicHelper.runningInWLServer() && this.dest_type == 20 && this.jms_sess.isInGlobalTransaction() && !this.jms_sess.wlsXaTopicNextDisabled && sQLException.getErrorCode() == 25242) {
                this.jms_sess.wlsXaTopicNextDisabled = true;
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.executeDequeueSqlCheck25242", "handling ORA-25242 error -> retry with the navigation mode FIRST_MESSAGE");
                this.deq_stmt.setObject(n, (Object)1, 4);
                this.deq_stmt.execute();
            }
            throw sQLException;
        }
    }

    private AQjmsMessage executeOciDequeueCheck25242(String string, String string2, int n, boolean bl, int[] nArray, int n2, String string3, String string4, byte[] byArray, int n3, int n4, long l, long[] lArray, long l2, boolean bl2) throws Exception {
        try {
            return this.syncedOCIDeq(string, string2, n, bl, nArray[0], n2, string3, string4, byArray, n3, n4, l, this.xml_receive, lArray, l2, this.transfxm, this.jms_sess, bl2);
        }
        catch (SQLException sQLException) {
            if (WebLogicHelper.runningInWLServer() && this.dest_type == 20 && this.jms_sess.isInGlobalTransaction() && !this.jms_sess.wlsXaTopicNextDisabled && sQLException.getErrorCode() == 25242) {
                this.jms_sess.wlsXaTopicNextDisabled = true;
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.executeOciDequeueCheck25242", "handling ORA-25242 error -> retry with the navigation mode FIRST_MESSAGE");
                nArray[0] = 1;
                return this.syncedOCIDeq(string, string2, n, bl, nArray[0], n2, string3, string4, byArray, n3, n4, l, this.xml_receive, lArray, l2, this.transfxm, this.jms_sess, bl2);
            }
            throw sQLException;
        }
    }

    private AQMessage jdbcConnectionDequeueCheck25242(oracle.jdbc.OracleConnection oracleConnection, String string, AQDequeueOptions aQDequeueOptions, String string2) throws SQLException {
        try {
            return oracleConnection.dequeue(string, aQDequeueOptions, string2);
        }
        catch (SQLException sQLException) {
            if (WebLogicHelper.runningInWLServer() && this.dest_type == 20 && this.jms_sess.isInGlobalTransaction() && !this.jms_sess.wlsXaTopicNextDisabled && sQLException.getErrorCode() == 25242) {
                this.jms_sess.wlsXaTopicNextDisabled = true;
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcConnectionDequeueCheck25242", "handling ORA-25242 error -> retry with the navigation mode FIRST_MESSAGE");
                aQDequeueOptions.setNavigation(AQDequeueOptions.NavigationOption.FIRST_MESSAGE);
                return oracleConnection.dequeue(string, aQDequeueOptions, string2);
            }
            throw sQLException;
        }
    }

    private JMSMessage jdbcConnectionDequeueCheck25242Sh(OracleConnection oracleConnection, String string, JMSDequeueOptions jMSDequeueOptions) throws SQLException {
        try {
            return oracleConnection.jmsDequeue(string, jMSDequeueOptions);
        }
        catch (SQLException sQLException) {
            if (WebLogicHelper.runningInWLServer() && this.dest_type == 20 && this.jms_sess.isInGlobalTransaction() && !this.jms_sess.wlsXaTopicNextDisabled && sQLException.getErrorCode() == 25242) {
                this.jms_sess.wlsXaTopicNextDisabled = true;
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.jdbcConnectionDequeueCheck25242Sh", "handling ORA-25242 error -> retry with the navigation mode FIRST_MESSAGE");
                return null;
            }
            throw sQLException;
        }
    }

    private AQjmsMessage convertAnydataToMessage(ANYDATA aNYDATA) throws JMSException, SQLException {
        AQjmsOracleDebug.trace(3, "AQjmsConsumer.convertAnydataToMessage", "entry");
        Datum datum = aNYDATA.accessDatum();
        if (datum == null) {
            AQjmsError.throwEx(224);
        }
        Object object = datum.toJdbc();
        AQjmsMessage aQjmsMessage = null;
        if (object instanceof OracleData || object instanceof ORAData) {
            if (object instanceof AQjmsTextMessage_C) {
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.convertAnydataToMessage", "text_message retrieved from anydata");
                aQjmsMessage = new AQjmsTextMessage(this.jms_sess, (AQjmsTextMessage_C)object);
            } else if (object instanceof AQjmsBytesMessage_C) {
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.convertAnydataToMessage", "bytes_message retrieved from anydata");
                aQjmsMessage = new AQjmsBytesMessage(this.jms_sess, (AQjmsBytesMessage_C)object);
            } else if (object instanceof AQjmsMapMessage_C) {
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.convertAnydataToMessage", "map_message retrieved from anydata");
                aQjmsMessage = new AQjmsMapMessage(this.jms_sess, (AQjmsMapMessage_C)object);
            } else if (object instanceof AQjmsObjectMessage_C) {
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.convertAnydataToMessage", "object_message retrieved from anydata");
                aQjmsMessage = new AQjmsObjectMessage(this.jms_sess, (AQjmsObjectMessage_C)object, this.xml_receive);
            } else if (object instanceof AQjmsStreamMessage_C) {
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.convertAnydataToMessage", "stream_message retrieved from anydata");
                aQjmsMessage = new AQjmsStreamMessage(this.jms_sess, (AQjmsStreamMessage_C)object);
            } else {
                aQjmsMessage = object instanceof XMLType || object instanceof ORAData ? new AQjmsAdtMessage(this.jms_sess, (ORAData)object) : new AQjmsAdtMessage(this.jms_sess, (OracleData)object);
            }
        } else {
            AQjmsOracleDebug.trace(3, "AQjmsConsumer.convertAnydataToMessage", "anydata-invalid obj");
            if (object != null) {
                AQjmsOracleDebug.trace(3, "AQjmsConsumer.dequeue", "anydata-invalid obj class:" + object.getClass().getName());
            }
            AQjmsError.throwEx(224);
        }
        AQjmsOracleDebug.trace(3, "AQjmsConsumer.convertAnydataToMessage", "exit");
        return aQjmsMessage;
    }

    synchronized void purgeSeen(Hashtable hashtable, int n) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.purgeSeen", "entry");
        if (hashtable != null) {
            AQjmsSelector aQjmsSelector = this.selector;
            int n2 = this.deq_mode;
            this.deq_mode = 3;
            JMSException jMSException = null;
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                try {
                    String string = (String)enumeration.nextElement();
                    String string2 = "JMSMessageID = '" + string + "'";
                    this.selector = new AQjmsSelector(string2, 10, n, this.jms_sess.dbversion, this.jms_sess.getCompliant());
                    this.receiveNoData(0L);
                }
                catch (JMSException jMSException2) {
                    AQjmsOracleDebug.traceEx(3, "AQjmsConsumer.purgeSeen", jMSException2);
                    jMSException = jMSException2;
                    break;
                }
            }
            this.selector = aQjmsSelector;
            this.deq_mode = n2;
            if (jMSException != null) {
                throw jMSException;
            }
        }
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.purgeSeen", "exit");
    }

    Message dequeue(AQjmsDestination aQjmsDestination, long l, String string, int n, int n2, AQjmsSignature aQjmsSignature, boolean bl) throws JMSException {
        return this.dequeue(aQjmsDestination, l, string, n, n2, aQjmsSignature, bl, this.visibility, 1);
    }

    Message dequeue(AQjmsDestination aQjmsDestination, long l, String string, int n, int n2, AQjmsSignature aQjmsSignature, boolean bl, int n3, int n4) throws JMSException {
        OracleDataFactory oracleDataFactory = null;
        Connection connection = null;
        AQjmsConnection aQjmsConnection = null;
        String string2 = "";
        AQjmsGenMessage_C aQjmsGenMessage_C = null;
        AQjmsTextMessage_C aQjmsTextMessage_C = null;
        AQjmsTextMessage aQjmsTextMessage = null;
        AQjmsBytesMessage_C aQjmsBytesMessage_C = null;
        AQjmsBytesMessage aQjmsBytesMessage = null;
        AQjmsMapMessage_C aQjmsMapMessage_C = null;
        AQjmsMapMessage aQjmsMapMessage = null;
        AQjmsObjectMessage_C aQjmsObjectMessage_C = null;
        AQjmsObjectMessage aQjmsObjectMessage = null;
        AQjmsStreamMessage_C aQjmsStreamMessage_C = null;
        AQjmsStreamMessage aQjmsStreamMessage = null;
        AQjmsMessage aQjmsMessage = null;
        CustomDatum customDatum = null;
        OracleData oracleData = null;
        ORAData oRAData = null;
        AQjmsAdtMessage aQjmsAdtMessage = null;
        AQjmsPropertyList aQjmsPropertyList = null;
        AQjmsMessageHeaderExt aQjmsMessageHeaderExt = null;
        Hashtable hashtable = null;
        Map<String, Class<?>> map = null;
        byte[] byArray = null;
        byte[] byArray2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        AQjmsAgent aQjmsAgent = null;
        TIMESTAMP tIMESTAMP = null;
        Timestamp timestamp = null;
        int n5 = 0;
        int n6 = 0;
        long l2 = 1L;
        long l3 = 0L;
        int n7 = 0;
        boolean bl2 = false;
        long l4 = 0L;
        long l5 = 0L;
        int n8 = 0;
        int n9 = -1;
        boolean bl3 = false;
        long[] lArray = null;
        int[] nArray = null;
        boolean bl4 = false;
        long l6 = 0L;
        String string6 = string == null ? null : string.toUpperCase();
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.dequeue", "entry");
        this.checkClosed("dequeue");
        l4 = l >= 0L ? (l + 999L) / 1000L : -1L;
        n6 = this.jms_sess.getCloseCheckInterval();
        AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "sec_timeout: " + l4 + "  close_check_interval: " + n6);
        if (l4 > (long)n6) {
            l2 = l4 / (long)n6;
            l3 = l4 % (long)n6;
            if (l3 > 0L) {
                ++l2;
            } else {
                l3 = n6;
            }
        } else {
            l2 = 1L;
            l3 = l4;
        }
        AQjmsOracleDebug.println("Timeout: " + l4 + " Iterations: " + l2 + " Interval: " + n6 + " Last_interval: " + l3);
        long l7 = n6;
        if (aQjmsDestination == null || aQjmsDestination.getCompleteName() == null) {
            AQjmsError.throwEx(200);
        }
        aQjmsConnection = this.jms_sess.getJmsConnection();
        try {
            connection = this.jms_sess.getDBConnection();
            map = connection.getTypeMap();
        }
        catch (Exception exception) {
            AQjmsOracleDebug.traceEx(3, "AQjmsConsumer.dequeue", exception);
            AQjmsError.throwEx(112, (Throwable)exception);
        }
        AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "After getDbConnection");
        try {
            map.put("SYS.AQ$_AGENT", Class.forName("oracle.AQ.AQOracleAgent"));
        }
        catch (Exception exception) {
            AQjmsError.throwEx(146);
        }
        try {
            boolean bl5;
            String string7;
            block124: {
                string7 = this.transfxm == null ? aQjmsDestination.getAdtType() : AQjmsUtil.getTransType(this.jms_sess.getDBConnection(), aQjmsDestination, this.transfxm).getDestType();
                string2 = aQjmsDestination.getCompleteName();
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "q_name: " + string2 + "  p_data_type: " + string7);
                bl5 = aQjmsDestination.isSharded();
                if (!bl5) {
                    if (n3 != 1) {
                        n4 = 1;
                    }
                    if (string7.equalsIgnoreCase("SYS.AQ$_JMS_MESSAGE")) {
                        bl3 = true;
                        oracleDataFactory = AQjmsGenMessage_C.getFactory();
                        n9 = 0;
                    } else if (string7.equalsIgnoreCase("SYS.AQ$_JMS_TEXT_MESSAGE")) {
                        oracleDataFactory = AQjmsTextMessage_C.getFactory();
                        n9 = 0;
                    } else if (string7.equalsIgnoreCase("SYS.AQ$_JMS_BYTES_MESSAGE")) {
                        oracleDataFactory = AQjmsBytesMessage_C.getFactory();
                        n9 = 1;
                    } else if (string7.equalsIgnoreCase("SYS.AQ$_JMS_STREAM_MESSAGE")) {
                        oracleDataFactory = AQjmsStreamMessage_C.getFactory();
                        n9 = 2;
                    } else if (string7.equalsIgnoreCase("SYS.AQ$_JMS_MAP_MESSAGE")) {
                        oracleDataFactory = AQjmsMapMessage_C.getFactory();
                        n9 = 3;
                    } else if (string7.equalsIgnoreCase("SYS.AQ$_JMS_OBJECT_MESSAGE")) {
                        oracleDataFactory = AQjmsObjectMessage_C.getFactory();
                        n9 = 4;
                    } else if (string7.equalsIgnoreCase("SYS.ANYDATA")) {
                        oracleDataFactory = null;
                    } else if (this.cd_factory != null || this.od_factory != null || this.orad_factory != null) {
                        oracleDataFactory = this.cd_factory != null ? this.cd_factory : (this.od_factory != null ? this.od_factory : this.orad_factory);
                    } else {
                        AQjmsError.throwEx(129, string7);
                    }
                } else {
                    n4 = 3;
                }
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "visibility : " + n3 + " delivery mode: " + n4);
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "Payload type" + n9);
                if (this.selector != null) {
                    AQjmsOracleDebug.println("AQjmsConsumer selector: " + this.selector);
                    if (this.selector.getSelectorType() == 30) {
                        byArray2 = this.selector.getSelectorMessageId();
                        AQjmsOracleDebug.println("AQjmsConsumer selector-msgid: " + RepConversion.bArray2String((byte[])this.selector.getSelectorMessageId()));
                    } else if (this.selector.getSelectorType() == 20) {
                        string4 = this.selector.getSelectorCorrelationId();
                        AQjmsOracleDebug.println("AQjmsConsumer selector corr_id: " + string4);
                    } else if (this.selector.getSelectorType() == 50) {
                        string3 = this.selector.getRule();
                        AQjmsOracleDebug.println("AQjmsConsumer selector deq_cnd: " + string3);
                    }
                }
                if (this.jms_sess.hasOciAQContext() && this.cd_factory == null && this.od_factory == null && this.orad_factory == null && (string7 == null ? bl5 : !string7.equalsIgnoreCase("SYS.ANYDATA"))) {
                    lArray = this.jms_sess.getOCIHandles();
                    l6 = this.jms_sess.oci_aq_cntxt;
                    nArray = new int[]{n};
                    bl4 = true;
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "use_ociaq_lib = true");
                } else {
                    bl4 = false;
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "use_ociaq_lib = false");
                    this.deq_stmt = this.jms_sess.getDequeueStmt();
                    this.deq_stmt.setString(1, string2);
                    this.deq_stmt.setString(2, string);
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "consumer_name: " + string);
                    if (this.selector != null) {
                        AQjmsOracleDebug.println("AQjmsConsumer selector: " + this.selector);
                        if (this.selector.getSelectorType() == 30) {
                            byArray2 = this.selector.getSelectorMessageId();
                            this.deq_stmt.setBytes(3, byArray2);
                            this.deq_stmt.setString(4, null);
                            if (this.jms_sess.is82compatible()) {
                                this.deq_stmt.setString(26, null);
                            }
                            AQjmsOracleDebug.println("AQjmsConsumer selector-msgid: " + RepConversion.bArray2String((byte[])this.selector.getSelectorMessageId()));
                        } else if (this.selector.getSelectorType() == 20) {
                            this.deq_stmt.setNull(3, -2);
                            this.deq_stmt.setString(4, string4);
                            if (this.jms_sess.is82compatible()) {
                                this.deq_stmt.setString(26, null);
                            }
                            AQjmsOracleDebug.println("AQjmsConsumer selector-corrid: " + string4);
                        } else if (this.selector.getSelectorType() == 50) {
                            this.deq_stmt.setNull(3, -2);
                            this.deq_stmt.setString(4, null);
                            if (this.jms_sess.is82compatible()) {
                                this.deq_stmt.setString(26, string3);
                            }
                            AQjmsOracleDebug.println("AQjmsConsumer selector-condition: " + string3);
                        } else {
                            this.deq_stmt.setNull(3, -2);
                            this.deq_stmt.setString(4, null);
                            if (this.jms_sess.is82compatible()) {
                                this.deq_stmt.setString(26, null);
                            }
                        }
                    } else {
                        this.deq_stmt.setNull(3, -2);
                        this.deq_stmt.setString(4, null);
                        if (this.jms_sess.is82compatible()) {
                            this.deq_stmt.setString(26, null);
                        }
                    }
                    this.deq_stmt.setObject(5, (Object)n2, 4);
                    this.deq_stmt.setObject(6, (Object)n, 4);
                    this.deq_stmt.setObject(7, (Object)n3, 4);
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "dq_mode: " + n2 + " navig: " + n + " visibility: " + n3);
                    this.deq_stmt.setLong(8, l7);
                    this.deq_stmt.registerOutParameter(9, 93);
                    this.deq_stmt.registerOutParameter(10, 4);
                    this.deq_stmt.registerOutParameter(11, -2);
                    this.deq_stmt.registerOutParameter(12, 12);
                    this.deq_stmt.registerOutParameter(13, 4);
                    this.deq_stmt.registerOutParameter(14, 4);
                    this.deq_stmt.registerOutParameter(15, 4);
                    this.deq_stmt.registerOutParameter(16, 4);
                    this.deq_stmt.registerOutParameter(17, 12);
                    this.deq_stmt.registerOutParameter(18, 2003, "SYS.AQ$_RECIPIENTS");
                    this.deq_stmt.registerOutParameter(19, 12);
                    this.deq_stmt.registerOutParameter(20, 12);
                    this.deq_stmt.registerOutParameter(21, 4);
                    this.deq_stmt.registerOutParameter(22, -2);
                    this.deq_stmt.setObject(23, (Object)1, 4);
                    this.deq_stmt.registerOutParameter(24, -2);
                    if (string7.equalsIgnoreCase("SYS.XMLTYPE") || string7.equalsIgnoreCase("SYS.ANYDATA")) {
                        this.deq_stmt.registerOutParameter(25, 2007, string7);
                    } else {
                        this.deq_stmt.registerOutParameter(25, 2002, string7);
                    }
                    if (this.jms_sess.is82compatible()) {
                        if (aQjmsSignature != null) {
                            this.deq_stmt.setObject(27, (Object)aQjmsSignature);
                        } else {
                            this.deq_stmt.setNull(27, 2002, "SYS.AQ$_SIG_PROP");
                        }
                        this.deq_stmt.registerOutParameter(28, 2002, "SYS.AQ$_SIG_PROP");
                        this.deq_stmt.setString(29, this.transfxm);
                    }
                    if (this.jms_sess.is102compatible()) {
                        this.deq_stmt.setObject(30, (Object)n4, 4);
                        this.deq_stmt.registerOutParameter(31, 4);
                    }
                }
                if (l4 == -1L) {
                    while (true) {
                        bl2 = false;
                        try {
                            AQjmsOracleDebug.println("AQjmsConsumer.dequeue: wt_time: " + l7);
                            if (bl4) {
                                aQjmsMessage = this.executeOciDequeueCheck25242(string2, string6, n9, bl3, nArray, n2, string4, string3, byArray2, n3, n4, l7, lArray, l6, bl5);
                            } else {
                                this.executeDequeueSqlCheck25242(6);
                            }
                        }
                        catch (SQLException sQLException) {
                            AQjmsOracleDebug.println("SQL excpetion-1:" + sQLException.getErrorCode());
                            if (sQLException.getErrorCode() == 25228 || sQLException.getErrorCode() == 25263) {
                                if (this.isClosed()) {
                                    return null;
                                }
                                bl2 = true;
                            }
                            AQjmsOracleDebug.traceEx(3, "AQjmsConsumer.dequeue-sqlex", sQLException);
                            throw sQLException;
                        }
                        AQjmsOracleDebug.println("Checking if session is closed: retry: " + bl2);
                        if (bl2) {
                            Thread.yield();
                            continue;
                        }
                        break block124;
                        break;
                    }
                }
                n7 = 0;
                while ((long)n7 < l2) {
                    bl2 = false;
                    try {
                        if ((long)n7 == l2 - 1L) {
                            l7 = l3;
                        }
                        AQjmsOracleDebug.println("AQjmsConsumer.dequeue: wt_time: " + l7);
                        if (bl4) {
                            aQjmsMessage = this.executeOciDequeueCheck25242(string2, string6, n9, bl3, nArray, n2, string4, string3, byArray2, n3, n4, l7, lArray, l6, bl5);
                        } else {
                            if ((long)n7 == l2 - 1L) {
                                this.deq_stmt.setLong(8, l7);
                            }
                            this.executeDequeueSqlCheck25242(6);
                        }
                    }
                    catch (SQLException sQLException) {
                        AQjmsOracleDebug.println("SQL excpetion-2:" + sQLException.getErrorCode());
                        if ((long)n7 < l2 - 1L && (sQLException.getErrorCode() == 25228 || sQLException.getErrorCode() == 25263)) {
                            if (this.isClosed()) {
                                return null;
                            }
                            bl2 = true;
                        }
                        throw sQLException;
                    }
                    AQjmsOracleDebug.println("Checking if session is closed: retry: " + bl2);
                    if (!bl2) break;
                    Thread.yield();
                    ++n7;
                }
            }
            if (n2 == 4) {
                AQjmsOracleDebug.trace(4, "AQjmsConsumer.dequeue", "exit-1");
                if (!this.jms_sess.isDeqStmtCachingEnabled() && this.deq_stmt != null) {
                    this.jms_sess.destroyStmt(this.deq_stmt);
                }
                return null;
            }
            if (bl4) {
                if (aQjmsMessage == null) {
                    AQjmsOracleDebug.trace(1, "AQjmsConsumer.dequeue", "Encounter null message and the dequeue mode is not DEQUEUE_REMOVE_NODATA");
                    throw new AQjmsException("Encounter null message with dequeue mode not DEQUEUE_REMOVE_NODATA", 122);
                }
                n8 = aQjmsMessage.getAttempts();
            } else {
                if (string7.equalsIgnoreCase("SYS.AQ$_JMS_MESSAGE")) {
                    aQjmsGenMessage_C = (AQjmsGenMessage_C)this.deq_stmt.getObject(25, oracleDataFactory);
                    int n10 = aQjmsGenMessage_C.getMessageType();
                    switch (n10) {
                        case 0: {
                            aQjmsMessage = new AQjmsTextMessage(this.jms_sess, aQjmsGenMessage_C);
                            break;
                        }
                        case 1: {
                            aQjmsMessage = new AQjmsBytesMessage(this.jms_sess, aQjmsGenMessage_C);
                            break;
                        }
                        case 2: {
                            aQjmsMessage = new AQjmsStreamMessage(this.jms_sess, aQjmsGenMessage_C);
                            break;
                        }
                        case 3: {
                            aQjmsMessage = new AQjmsMapMessage(this.jms_sess, aQjmsGenMessage_C);
                            break;
                        }
                        case 4: {
                            aQjmsMessage = new AQjmsObjectMessage(this.jms_sess, aQjmsGenMessage_C);
                            break;
                        }
                        default: {
                            AQjmsError.throwEx(108, "The message_type within aq$_jms_message ADT " + n10 + " is not valid JMS message type");
                        }
                    }
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "general payload messaeg retrieved");
                } else if (string7.equalsIgnoreCase("SYS.AQ$_JMS_TEXT_MESSAGE")) {
                    aQjmsTextMessage_C = (AQjmsTextMessage_C)this.deq_stmt.getObject(25, oracleDataFactory);
                    aQjmsTextMessage = new AQjmsTextMessage(this.jms_sess, aQjmsTextMessage_C);
                    aQjmsMessage = aQjmsTextMessage;
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "text_message retrieved");
                } else if (string7.equalsIgnoreCase("SYS.AQ$_JMS_BYTES_MESSAGE")) {
                    aQjmsBytesMessage_C = (AQjmsBytesMessage_C)this.deq_stmt.getObject(25, oracleDataFactory);
                    aQjmsBytesMessage = new AQjmsBytesMessage(this.jms_sess, aQjmsBytesMessage_C);
                    aQjmsMessage = aQjmsBytesMessage;
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "bytes_message retrieved");
                } else if (string7.equalsIgnoreCase("SYS.AQ$_JMS_MAP_MESSAGE")) {
                    aQjmsMapMessage_C = (AQjmsMapMessage_C)this.deq_stmt.getObject(25, oracleDataFactory);
                    aQjmsMapMessage = new AQjmsMapMessage(this.jms_sess, aQjmsMapMessage_C);
                    aQjmsMessage = aQjmsMapMessage;
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "map_message retrieved");
                } else if (string7.equalsIgnoreCase("SYS.AQ$_JMS_OBJECT_MESSAGE")) {
                    aQjmsObjectMessage_C = (AQjmsObjectMessage_C)this.deq_stmt.getObject(25, oracleDataFactory);
                    aQjmsObjectMessage = new AQjmsObjectMessage(this.jms_sess, aQjmsObjectMessage_C, this.xml_receive);
                    aQjmsMessage = aQjmsObjectMessage;
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "object_message retrieved");
                } else if (string7.equalsIgnoreCase("SYS.AQ$_JMS_STREAM_MESSAGE")) {
                    aQjmsStreamMessage_C = (AQjmsStreamMessage_C)this.deq_stmt.getObject(25, oracleDataFactory);
                    aQjmsStreamMessage = new AQjmsStreamMessage(this.jms_sess, aQjmsStreamMessage_C);
                    aQjmsMessage = aQjmsStreamMessage;
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "stream_message retrieved");
                } else if (string7.equalsIgnoreCase("SYS.ANYDATA")) {
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "before receiving anydata message");
                    aQjmsMessage = this.convertAnydataToMessage((ANYDATA)this.deq_stmt.getObject(25));
                } else {
                    if (oracleDataFactory instanceof CustomDatumFactory) {
                        customDatum = (CustomDatum)this.deq_stmt.getCustomDatum(25, (CustomDatumFactory)oracleDataFactory);
                        aQjmsAdtMessage = new AQjmsAdtMessage(this.jms_sess, customDatum);
                    } else if (oracleDataFactory instanceof ORADataFactory) {
                        oRAData = (ORAData)this.deq_stmt.getORAData(25, (ORADataFactory)oracleDataFactory);
                        aQjmsAdtMessage = new AQjmsAdtMessage(this.jms_sess, oRAData);
                    } else {
                        oracleData = (OracleData)this.deq_stmt.getObject(25, oracleDataFactory);
                        aQjmsAdtMessage = new AQjmsAdtMessage(this.jms_sess, oracleData);
                    }
                    aQjmsMessage = aQjmsAdtMessage;
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "adt_message retrieved");
                }
                tIMESTAMP = this.deq_stmt.getTIMESTAMP(9);
                timestamp = tIMESTAMP.timestampValue();
                long l8 = timestamp.getTime();
                aQjmsMessage.setEnqueueTime(l8);
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "set AQ enqueue_time as " + l8);
                aQjmsMessage.setMessageState(this.deq_stmt.getInt(10));
                byArray = this.deq_stmt.getBytes(11);
                aQjmsMessage.setJMSMessageID(byArray);
                aQjmsMessage.setJMSCorrelationID(this.deq_stmt.getString(12));
                aQjmsMessage.setJMSPriority(this.deq_stmt.getInt(13));
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "msg_id: " + RepConversion.bArray2String((byte[])byArray) + " corrid: " + this.deq_stmt.getString(12) + " priority: " + this.deq_stmt.getInt(13));
                n5 = this.deq_stmt.getInt(14);
                aQjmsMessage.setDelay(n5);
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "msg_delay(secs): " + n5);
                l5 = this.deq_stmt.getLong(15);
                aQjmsMessage.setJMSExpiration(l5);
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "exptime(secs): " + l5);
                n8 = this.deq_stmt.getInt(16);
                aQjmsMessage.setAttempts(n8);
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "attempts: " + n8);
                aQjmsMessage.setExceptionQueue(this.deq_stmt.getString(17));
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "excp_q: " + this.deq_stmt.getString(17));
                string5 = this.deq_stmt.getString(19);
                if (string5 != null && !string5.equals("")) {
                    aQjmsAgent = new AQjmsAgent();
                    aQjmsAgent.setName(string5);
                    aQjmsAgent.setAddress(this.deq_stmt.getString(20));
                    aQjmsAgent.setProtocol(this.deq_stmt.getInt(21));
                    aQjmsMessage.setSenderID(aQjmsAgent);
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "Sender" + aQjmsAgent);
                }
                aQjmsMessage.setOriginalMessageId(this.deq_stmt.getBytes(22));
                if (this.jms_sess.is82compatible()) {
                    aQjmsMessage.setSignature((AQjmsSignature)this.deq_stmt.getObject(28, AQjmsSignature.getFactory()));
                }
            }
            if (!bl5) {
                if (aQjmsMessage.isJMSBody() && this.jms_sess.getCompliant()) {
                    aQjmsMessage.setJMSPriority(AQjmsMessage.toJMSPriority(aQjmsMessage.getJMSPriority()));
                }
                if (!(aQjmsMessage instanceof AQjmsAdtMessage)) {
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "after receive-0 " + aQjmsMessage);
                    aQjmsMessageHeaderExt = aQjmsMessage.getMessageHeaderExt();
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "after receive-1");
                    aQjmsPropertyList = aQjmsMessageHeaderExt.getProperties();
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "after receive-2");
                    hashtable = aQjmsPropertyList == null ? new Hashtable() : AQjmsMessage.convertPropertyListToHashtable(aQjmsPropertyList);
                    aQjmsMessage.setPropertiesHashtable(hashtable);
                }
                if (hashtable != null && hashtable.get("JMS_OracleHeaderOnly") != null) {
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", " Header only, Copying to generic msg");
                    AQjmsMessage aQjmsMessage2 = new AQjmsMessage(aQjmsMessage);
                    aQjmsMessage = null;
                    aQjmsMessage = aQjmsMessage2;
                    aQjmsMessage.setHeaderOnly();
                }
                if (hashtable != null && hashtable.get("JMS_OracleDeliveryMode") != null) {
                    aQjmsMessage.setJMSDeliveryMode(Integer.parseInt(aQjmsMessage.getStringProperty("JMS_OracleDeliveryMode")));
                }
            }
            if (aQjmsMessage.getJMSExpiration() <= 0L) {
                aQjmsMessage.setJMSExpiration(0L);
            } else {
                aQjmsMessage.setJMSExpiration(aQjmsMessage.getJMSExpiration() * 1000L + aQjmsMessage.getJMSTimestamp());
            }
            Date date = new Date();
            aQjmsMessage.setReceiveTime(date.getTime());
            if (n8 > 0) {
                aQjmsMessage.setJMSRedelivered(true);
            } else {
                aQjmsMessage.setJMSRedelivered(false);
            }
            AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "recv_time: " + date);
            aQjmsMessage.setPropReadOnly(true);
            aQjmsMessage.setAccessMode(0);
            aQjmsMessage.setJMSDestination((Destination)aQjmsDestination);
            if (!bl) {
                this.doCommit(this.jms_sess);
            }
            if (!this.jms_sess.isDeqStmtCachingEnabled() && this.deq_stmt != null) {
                this.jms_sess.destroyStmt(this.deq_stmt);
            }
        }
        catch (SQLException sQLException) {
            this.jms_sess.destroyStmt(this.deq_stmt);
            if ((sQLException.getErrorCode() == 25228 || sQLException.getErrorCode() == 25263) && n2 != 4) {
                aQjmsMessage = null;
            } else if (sQLException.getErrorCode() == 1013) {
                aQjmsMessage = null;
            } else {
                AQjmsError.throwEx(120, (Throwable)sQLException);
            }
        }
        catch (JMSException jMSException) {
            this.jms_sess.destroyStmt(this.deq_stmt);
            AQjmsOracleDebug.traceEx(3, "AQjmsConsumer.dequeue-ex3", jMSException);
            AQjmsError.throwEx(120, (Throwable)jMSException);
        }
        catch (Exception exception) {
            this.jms_sess.destroyStmt(this.deq_stmt);
            AQjmsOracleDebug.traceEx(3, "AQjmsConsumer.dequeue-ex3", exception);
            AQjmsError.throwEx(120, (Throwable)exception);
        }
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.dequeue", "exit-2");
        return aQjmsMessage;
    }

    @Override
    public void close() throws JMSException {
        super.close();
    }

    @Override
    void markClosed() {
        super.markClosed();
        if (this.jms_sess != null && this.isInUse()) {
            this.jms_sess.cancelBlockingReceive();
        }
    }

    @Override
    protected synchronized void localClose() throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.localClose", "entry");
        this.closeConsumerResources();
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.close", "exit");
    }

    synchronized void closeConsumerResources() {
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.closeConsumerResources", "entry");
        this.jms_sess.removeConsumer(this);
        AQjmsOracleDebug.trace(5, "AQjmsConsumer.close", "deq_stmt closed");
        if (this.isDurable() && this.jms_sess.getCompliant() && this.hasInfo && this.cons_name != null && !this.cons_name.equals("") && this.client_id != null) {
            boolean bl = AQjmsClientSubscriberMap.deactivateClientSubscriber(this.client_id, this.cons_name);
            if (bl) {
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.close", "deactivate subscriber " + this.cons_name + " success.");
            } else {
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.close", "deactivate subscriber, " + this.cons_name + " not found.");
            }
        }
        if (this.cons_dest.isTemp()) {
            this.cons_dest.removeConsForTempDest();
        }
        this.selector = null;
        this.cons_dest = null;
        this.cd_factory = null;
        this.od_factory = null;
        this.orad_factory = null;
        this.jms_sess = null;
        this.deq_stmt = null;
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.localClose", "exit-2");
    }

    public synchronized Queue getQueue() throws JMSException {
        this.checkClosed("getQueue");
        if (this.dest_type == 10) {
            return this.cons_dest;
        }
        AQjmsError.throwEx(107, "TopicSubscriber");
        return null;
    }

    @Override
    public synchronized Topic getTopic() throws JMSException {
        this.checkClosed("getTopic");
        if (this.dest_type == 20) {
            return this.cons_dest;
        }
        AQjmsError.throwEx(107, "QueueReceiver");
        return null;
    }

    public synchronized boolean getNoLocal() throws JMSException {
        this.checkClosed("getNoLocal");
        if (this.dest_type == 10) {
            AQjmsError.throwEx(107, "QueueReceiver");
        }
        if (!this.hasInfo) {
            AQjmsError.throwEx(233);
        }
        return this.nolocal;
    }

    @Override
    public synchronized int getNavigationMode() throws JMSException {
        this.checkClosed("getNavigationMode");
        return this.navig_mode;
    }

    @Override
    public synchronized void setNavigationMode(int n) throws JMSException {
        this.checkClosed("setNavigationMode");
        if (n == 1 || n == 3 || n == 2) {
            this.navig_mode = n;
        } else {
            AQjmsError.throwEx(128);
        }
        AQjmsOracleDebug.trace(5, "AQjmsConsumer.setNavigationMode", "navig_mode: " + n);
    }

    @Override
    public synchronized void setTransformation(String string) {
        this.transfxm = string;
    }

    @Override
    public synchronized String getTransformation() {
        return this.transfxm;
    }

    boolean isDurable() {
        return this.durable;
    }

    void setDurable(boolean bl) {
        this.durable = bl;
    }

    @Override
    public synchronized void receiveNoData() throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.receiveNoData-1", "entry");
        this.receiveNoData(-1L);
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.receiveNoData-1", "exit");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void receiveNoData(long l) throws JMSException {
        int n;
        Message message = null;
        AQjmsConnection aQjmsConnection = null;
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.receiveNoData-2", "entry");
        AQjmsOracleDebug.trace(5, "AQjmsConsumer.receiveNoData", "timeout: " + l);
        this.checkClosed("receiveNoData");
        aQjmsConnection = this.jms_sess.getJmsConnection();
        if (!aQjmsConnection.isStarted()) {
            AQjmsError.throwEx(113);
        }
        this.jms_sess.checkForGlobalTxn();
        if (this.first_receive) {
            n = 1;
            this.first_receive = false;
        } else {
            n = this.navig_mode;
        }
        if (!this.lockReceive("receiveNoData", l)) {
            return;
        }
        try {
            if (this.dest_type == 10) {
                message = this.dequeue(this.cons_dest, l, null, n, 4, null, false);
            } else if (this.dest_type == 20) {
                message = this.dequeue(this.cons_dest, l, this.cons_name, n, 4, null, false);
            }
        }
        finally {
            this.unlock("receiveNoData");
        }
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.receiveNoData-2", "exit");
    }

    @Override
    public Message receiveSignature() throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.receiveSignature-1", "entry");
        return this.receiveSignature(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Message receiveSignature(long l) throws JMSException {
        int n;
        Message message = null;
        AQjmsConnection aQjmsConnection = null;
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.receiveSignature-2", "entry");
        AQjmsOracleDebug.trace(5, "AQjmsConsumer.receiveSignature-2", "timeout: " + l);
        this.checkClosed("receiveSignature");
        aQjmsConnection = this.jms_sess.getJmsConnection();
        if (!aQjmsConnection.isStarted()) {
            AQjmsError.throwEx(113);
        }
        this.jms_sess.checkForGlobalTxn();
        if (this.first_receive) {
            n = 1;
            this.first_receive = false;
        } else {
            n = this.navig_mode;
        }
        if (!this.lockReceive("receiveSignature", l)) {
            return null;
        }
        try {
            if (this.dest_type == 10) {
                message = this.dequeue(this.cons_dest, l, null, n, 5, null, false);
            } else if (this.dest_type == 20) {
                message = this.dequeue(this.cons_dest, l, this.cons_name, n, 5, null, false);
            }
        }
        finally {
            this.unlock("receiveSignature");
        }
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.receiveSignature-2", "exit");
        return message;
    }

    public void setXmlReceive(boolean bl) {
        this.xml_receive = bl;
    }

    public Message browse(long l, boolean bl) throws JMSException {
        if (l == 0L) {
            l = -1L;
        }
        this.deq_mode = bl ? 2 : 1;
        return this.receiveFromAQ(l);
    }

    public Message browseNoWait(boolean bl) throws JMSException {
        this.deq_mode = bl ? 2 : 1;
        return this.receiveFromAQ(0L);
    }

    void restart() {
        this.first_receive = true;
    }

    @Override
    public void finalize() {
        AQjmsOracleDebug.println("AQjmsConsumer.finalize");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AQjmsMessage syncedOCIDeq(String string, String string2, int n, boolean bl, int n2, int n3, String string3, String string4, byte[] byArray, int n4, int n5, long l, boolean bl2, long[] lArray, long l2, String string5, AQjmsSession aQjmsSession, boolean bl3) throws Exception {
        AQjmsMessage aQjmsMessage;
        block14: {
            AQjmsOracleDebug.trace(5, "AQjmsConsumer.syncedOCIDeq", "Calling Native Deq-2");
            AQjmsOracleDebug.println("Context: " + l2);
            AQjmsOracleDebug.trace(5, "AQjmsConsumer.syncedOCIDeq", "msg_dequeue_mode: " + n3);
            AQjmsOracleDebug.trace(5, "AQjmsConsumer.syncedOCIDeq", "consumer_name: " + string2);
            AQjmsSession aQjmsSession2 = this.jms_sess;
            aQjmsMessage = null;
            AQjmsOracleDebug.trace(5, "AQjmsConsumer.syncedOCIDeq", "ENTRY");
            try {
                Connection connection = aQjmsSession2.getDBConnection();
                Connection connection2 = ((oracle.jdbc.OracleConnection)connection)._getPC();
                if (connection2 != null) {
                    Connection connection3 = connection2;
                    synchronized (connection3) {
                        block13: {
                            AQjmsOracleDebug.trace(5, "AQjmsConsumer.syncedOCIDeq", "in connection sync block, conn= " + connection + ", pc-conn=" + connection2);
                            if (!connection2.isClosed()) break block13;
                            AQjmsMessage aQjmsMessage2 = null;
                            return aQjmsMessage2;
                        }
                        aQjmsMessage = bl3 ? this.ocideqSQ(string, string2, n2, n3, string3, string4, byArray, n4, n5, l, bl2, lArray, l2, string5, aQjmsSession) : this.ocideq(string, string2, n, bl, n2, n3, string3, string4, byArray, n4, n5, l, bl2, lArray, l2, string5, aQjmsSession);
                        break block14;
                    }
                }
                if (!connection.isClosed()) {
                    aQjmsMessage = bl3 ? this.ocideqSQ(string, string2, n2, n3, string3, string4, byArray, n4, n5, l, bl2, lArray, l2, string5, aQjmsSession) : this.ocideq(string, string2, n, bl, n2, n3, string3, string4, byArray, n4, n5, l, bl2, lArray, l2, string5, aQjmsSession);
                } else {
                    AQjmsOracleDebug.trace(1, "AQjmsConsumer.syncedOCIDeq", "WARNING!!: Physical connection is null");
                    AQjmsError.throwEx(112, "db connection is closed");
                }
            }
            catch (IllegalStateException illegalStateException) {
            }
            finally {
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.syncedOCIDeq", "EXIT: retmsg=" + aQjmsMessage);
            }
        }
        return aQjmsMessage;
    }

    public Message[] bulkReceive(int n) throws JMSException {
        return this.bulkReceiveFromAQ(-1L, n, null);
    }

    public Message[] bulkReceive(int n, long l) throws JMSException {
        return this.bulkReceiveFromAQ(l, n, null);
    }

    public Message[] bulkReceiveNoWait(int n) throws JMSException {
        return this.bulkReceiveFromAQ(0L, n, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Message[] bulkReceiveFromAQ(long l, int n, AQjmsSignature aQjmsSignature) throws JMSException {
        int n2;
        Message[] messageArray = null;
        AQjmsConnection aQjmsConnection = null;
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.batchReceivefromAQ", "entry");
        this.checkClosed("bulkReceiveFromAQ");
        aQjmsConnection = this.jms_sess.getJmsConnection();
        if (!aQjmsConnection.isStarted()) {
            return null;
        }
        if (this.jms_sess.getMessageListener() != null) {
            AQjmsError.throwEx(198);
        }
        AQjmsOracleDebug.trace(5, "AQjmsConsumer.batchReceiveFromAQ", "timeout(millisecs): " + l);
        this.jms_sess.checkForGlobalTxn();
        if (this.first_receive) {
            n2 = 1;
            this.first_receive = false;
        } else {
            n2 = this.navig_mode;
        }
        if (!this.lockReceive("batchReceiveFromAQ(sig)", l)) {
            return null;
        }
        try {
            if (this.dest_type == 10) {
                messageArray = this.bulkDequeue(this.cons_dest, l, n, null, n2, this.deq_mode, aQjmsSignature, false);
            } else if (this.dest_type == 20) {
                messageArray = this.bulkDequeue(this.cons_dest, l, n, this.cons_name, n2, this.deq_mode, aQjmsSignature, false);
            }
        }
        finally {
            this.unlock("bulkReceiveFromAQ(sig)");
        }
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.receive-2", "exit");
        return messageArray;
    }

    Message[] bulkDequeue(AQjmsDestination aQjmsDestination, long l, int n, String string, int n2, int n3, AQjmsSignature aQjmsSignature, boolean bl) throws JMSException {
        int n4 = 0;
        Connection connection = null;
        AQjmsConnection aQjmsConnection = null;
        String string2 = "";
        AQjmsGenMessages_C aQjmsGenMessages_C = null;
        AQjmsGenMessage_C[] aQjmsGenMessage_CArray = null;
        AQjmsTextMessages_C aQjmsTextMessages_C = null;
        AQjmsTextMessage_C[] aQjmsTextMessage_CArray = null;
        AQjmsBytesMessages_C aQjmsBytesMessages_C = null;
        AQjmsBytesMessage_C[] aQjmsBytesMessage_CArray = null;
        AQjmsMapMessages_C aQjmsMapMessages_C = null;
        AQjmsMapMessage_C[] aQjmsMapMessage_CArray = null;
        AQjmsObjectMessages_C aQjmsObjectMessages_C = null;
        AQjmsObjectMessage_C[] aQjmsObjectMessage_CArray = null;
        AQjmsStreamMessages_C aQjmsStreamMessages_C = null;
        AQjmsStreamMessage_C[] aQjmsStreamMessage_CArray = null;
        Message[] messageArray = null;
        AQjmsPropertyList aQjmsPropertyList = null;
        AQjmsMessageHeaderExt aQjmsMessageHeaderExt = null;
        Hashtable hashtable = null;
        Map<String, Class<?>> map = null;
        byte[][] byArray = null;
        byte[] byArray2 = null;
        String string3 = null;
        String string4 = null;
        Timestamp timestamp = null;
        int n5 = 0;
        int n6 = 0;
        long l2 = 1L;
        long l3 = 0L;
        int n7 = 0;
        boolean bl2 = false;
        long l4 = 0L;
        long l5 = 0L;
        int n8 = 0;
        Object var54_44 = null;
        boolean bl3 = false;
        AQjmsMessageProperty[] aQjmsMessagePropertyArray = null;
        AQjmsMessageProperties aQjmsMessageProperties = null;
        OracleArray oracleArray = null;
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.bulkDequeue", "entry");
        if (aQjmsDestination.isSharded()) {
            aQjmsDestination.setAdtType("SYS.AQ$_JMS_MESSAGE");
            n2 = 1;
        }
        this.checkClosed("bulkDequeue");
        l4 = l >= 0L ? (l + 999L) / 1000L : -1L;
        n6 = this.jms_sess.getCloseCheckInterval();
        AQjmsOracleDebug.trace(5, "AQjmsConsumer.bulkDequeue", "sec_timeout: " + l4 + "  close_check_interval: " + n6);
        if (l4 > (long)n6) {
            l2 = l4 / (long)n6;
            l3 = l4 % (long)n6;
            if (l3 > 0L) {
                ++l2;
            } else {
                l3 = n6;
            }
        } else {
            l2 = 1L;
            l3 = l4;
        }
        AQjmsOracleDebug.println("Timeout: " + l4 + " Iterations: " + l2 + " Interval: " + n6 + " Last_interval: " + l3);
        if (aQjmsDestination == null || aQjmsDestination.getCompleteName() == null) {
            AQjmsError.throwEx(200);
        }
        aQjmsConnection = this.jms_sess.getJmsConnection();
        try {
            connection = this.jms_sess.getDBConnection();
            map = connection.getTypeMap();
        }
        catch (Exception exception) {
            AQjmsError.throwEx(112, (Throwable)exception);
        }
        AQjmsOracleDebug.trace(5, "AQjmsConsumer.bulkDequeue", "After getDbConnection");
        try {
            map.put("SYS.AQ$_AGENT", Class.forName("oracle.AQ.AQOracleAgent"));
            map.put("SYS.AQ$_SIG_PROP", Class.forName("oracle.jms.AQjmsSignature"));
            map.put("SYS.AQ$_RECIPIENTS", Class.forName("oracle.jms.AQjmsRecipients"));
            map.put("SYS.AQ$_JMS_MESSAGE_PROPERTY", Class.forName("oracle.jms.AQjmsMessageProperty"));
            map.put("SYS.AQ$_JMS_TEXT_MESSAGE", Class.forName("oracle.jms.AQjmsTextMessage_C"));
            map.put("SYS.AQ$_JMS_BYTES_MESSAGE", Class.forName("oracle.jms.AQjmsBytesMessage_C"));
            map.put("SYS.AQ$_JMS_STREAM_MESSAGE", Class.forName("oracle.jms.AQjmsStreamMessage_C"));
            map.put("SYS.AQ$_JMS_MAP_MESSAGE", Class.forName("oracle.jms.AQjmsMapMessage_C"));
            map.put("SYS.AQ$_JMS_OBJECT_MESSAGE", Class.forName("oracle.jms.AQjmsObjectMessage_C"));
            map.put("SYS.AQ$_JMS_MESSAGE", Class.forName("oracle.jms.AQjmsGenMessage_C"));
        }
        catch (Exception exception) {
            AQjmsError.throwEx(146);
        }
        try {
            String string5;
            block95: {
                long l6;
                string5 = this.transfxm == null ? aQjmsDestination.getAdtType() : AQjmsUtil.getTransType(this.jms_sess.getDBConnection(), aQjmsDestination, this.transfxm).getDestType();
                string2 = aQjmsDestination.getCompleteName();
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.bulkDequeue", "q_name: " + string2 + "  p_data_type: " + string5);
                if (this.selector != null) {
                    AQjmsOracleDebug.println("AQjmsConsumer selector: " + this.selector);
                    if (this.selector.getSelectorType() == 30) {
                        byArray2 = this.selector.getSelectorMessageId();
                        AQjmsOracleDebug.println("AQjmsConsumer selector-msgid: " + RepConversion.bArray2String((byte[])this.selector.getSelectorMessageId()));
                    } else if (this.selector.getSelectorType() == 20) {
                        string4 = this.selector.getSelectorCorrelationId();
                        AQjmsOracleDebug.println("AQjmsConsumer selector corr_id: " + string4);
                    } else if (this.selector.getSelectorType() == 50) {
                        string3 = this.selector.getRule();
                        AQjmsOracleDebug.println("AQjmsConsumer selector deq_cnd: " + string3);
                    }
                }
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.bulkDequeue", "use_ociaq_lib = false");
                this.deq_stmt = this.jms_sess.getArrayDequeueStmt(string5);
                this.deq_stmt.setString(1, string2);
                this.deq_stmt.setObject(2, (Object)n, 4);
                this.deq_stmt.setString(3, string);
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.bulkDequeue", "consumer_name: " + string);
                if (this.selector != null) {
                    AQjmsOracleDebug.println("AQjmsConsumer selector: " + this.selector);
                    if (this.selector.getSelectorType() == 20) {
                        this.deq_stmt.setString(8, string4);
                        this.deq_stmt.setString(9, null);
                        AQjmsOracleDebug.println("AQjmsConsumer selector-corrid: " + string4);
                    } else if (this.selector.getSelectorType() == 50) {
                        this.deq_stmt.setString(8, null);
                        this.deq_stmt.setString(9, string3);
                        AQjmsOracleDebug.println("AQjmsConsumer selector-condition: " + string3);
                    } else {
                        this.deq_stmt.setString(8, null);
                        this.deq_stmt.setString(9, null);
                    }
                } else {
                    this.deq_stmt.setString(8, null);
                    this.deq_stmt.setString(9, null);
                }
                this.deq_stmt.setObject(4, (Object)n3, 4);
                this.deq_stmt.setObject(5, (Object)n2, 4);
                this.deq_stmt.setObject(6, (Object)this.visibility, 4);
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.bulkDequeue", "dq_mode: " + n3 + "navig: " + n2 + "visibility: " + this.visibility);
                this.deq_stmt.registerOutParameter(12, 2003, "SYS.AQ$_JMS_MESSAGE_PROPERTIES");
                if (string5.equalsIgnoreCase("SYS.AQ$_JMS_MESSAGE")) {
                    this.deq_stmt.registerOutParameter(13, 2003, "SYS.AQ$_JMS_MESSAGES");
                } else if (string5.equalsIgnoreCase("SYS.AQ$_JMS_TEXT_MESSAGE")) {
                    this.deq_stmt.registerOutParameter(13, 2003, "SYS.AQ$_JMS_TEXT_MESSAGES");
                } else if (string5.equalsIgnoreCase("SYS.AQ$_JMS_BYTES_MESSAGE")) {
                    this.deq_stmt.registerOutParameter(13, 2003, "SYS.AQ$_JMS_BYTES_MESSAGES");
                } else if (string5.equalsIgnoreCase("SYS.AQ$_JMS_STREAM_MESSAGE")) {
                    this.deq_stmt.registerOutParameter(13, 2003, "SYS.AQ$_JMS_STREAM_MESSAGES");
                } else if (string5.equalsIgnoreCase("SYS.AQ$_JMS_MAP_MESSAGE")) {
                    this.deq_stmt.registerOutParameter(13, 2003, "SYS.AQ$_JMS_MAP_MESSAGES");
                } else if (string5.equalsIgnoreCase("SYS.AQ$_JMS_OBJECT_MESSAGE")) {
                    this.deq_stmt.registerOutParameter(13, 2003, "SYS.AQ$_JMS_BYTES_MESSAGES");
                } else {
                    AQjmsError.throwInvalidDestEx(127);
                }
                this.deq_stmt.registerOutParameter(14, 2003, "SYS.AQ$_JMS_ARRAY_MSGIDS");
                this.deq_stmt.registerOutParameter(15, 4);
                if (aQjmsSignature != null) {
                    this.deq_stmt.setObject(10, (Object)aQjmsSignature);
                } else {
                    this.deq_stmt.setNull(10, 2002, "SYS.AQ$_SIG_PROP");
                }
                this.deq_stmt.setString(11, this.transfxm);
                if (l4 == -1L) {
                    while (true) {
                        bl2 = false;
                        try {
                            l6 = n6;
                            AQjmsOracleDebug.println("AQjmsConsumer.bulkDequeue: wt_time: " + l6);
                            this.deq_stmt.setLong(7, l6);
                            this.executeDequeueSqlCheck25242(5);
                        }
                        catch (SQLException sQLException) {
                            AQjmsOracleDebug.println("SQL excpetion-1:" + sQLException.getErrorCode());
                            if (sQLException.getErrorCode() == 25228 || sQLException.getErrorCode() == 25263) {
                                bl2 = true;
                            }
                            AQjmsOracleDebug.traceEx(3, "AQjmsConsumer.bulkDequeue-sqlex", sQLException);
                            throw sQLException;
                        }
                        AQjmsOracleDebug.println("Checking if session is closed: retry: " + bl2);
                        if (this.isClosed()) {
                            AQjmsOracleDebug.println("Session closed: return");
                            if (!this.jms_sess.isDeqStmtCachingEnabled() && this.deq_stmt != null) {
                                this.jms_sess.destroyStmt(this.deq_stmt);
                            }
                            return null;
                        }
                        if (bl2) {
                            Thread.yield();
                            continue;
                        }
                        break block95;
                        break;
                    }
                }
                n7 = 0;
                while ((long)n7 < l2) {
                    bl2 = false;
                    try {
                        l6 = (long)n7 == l2 - 1L ? l3 : (long)n6;
                        AQjmsOracleDebug.println("AQjmsConsumer.bulkDequeue: wt_time: " + l6);
                        this.deq_stmt.setLong(7, l6);
                        this.executeDequeueSqlCheck25242(5);
                    }
                    catch (SQLException sQLException) {
                        AQjmsOracleDebug.println("SQL excpetion-2:" + sQLException.getErrorCode());
                        if ((long)n7 < l2 - 1L && (sQLException.getErrorCode() == 25228 || sQLException.getErrorCode() == 25263)) {
                            bl2 = true;
                        }
                        throw sQLException;
                    }
                    AQjmsOracleDebug.println("Checking if session is closed: retry: " + bl2);
                    if (this.isClosed()) {
                        AQjmsOracleDebug.println("Session closed: return");
                        if (!this.jms_sess.isDeqStmtCachingEnabled() && this.deq_stmt != null) {
                            this.jms_sess.destroyStmt(this.deq_stmt);
                        }
                        return null;
                    }
                    if (!bl2) break;
                    Thread.yield();
                    ++n7;
                }
            }
            if (n3 == 4) {
                AQjmsOracleDebug.trace(4, "AQjmsConsumer.bulkDequeue", "exit-1");
                if (!this.jms_sess.isDeqStmtCachingEnabled() && this.deq_stmt != null) {
                    this.jms_sess.destroyStmt(this.deq_stmt);
                }
                return null;
            }
            n4 = this.deq_stmt.getInt(15);
            if (n4 > 0) {
                if (string5.equalsIgnoreCase("SYS.AQ$_JMS_MESSAGE")) {
                    aQjmsGenMessages_C = (AQjmsGenMessages_C)this.deq_stmt.getObject(13, AQjmsGenMessages_C.getOracleDataFactory());
                    aQjmsGenMessage_CArray = aQjmsGenMessages_C.getArray();
                    messageArray = new Message[aQjmsGenMessage_CArray.length];
                    block20: for (int i = 0; i < aQjmsGenMessage_CArray.length; ++i) {
                        int n9 = aQjmsGenMessage_CArray[i].getMessageType();
                        switch (n9) {
                            case 0: {
                                messageArray[i] = new AQjmsTextMessage(this.jms_sess, aQjmsGenMessage_CArray[i]);
                                continue block20;
                            }
                            case 1: {
                                messageArray[i] = new AQjmsBytesMessage(this.jms_sess, aQjmsGenMessage_CArray[i]);
                                continue block20;
                            }
                            case 2: {
                                messageArray[i] = new AQjmsStreamMessage(this.jms_sess, aQjmsGenMessage_CArray[i]);
                                continue block20;
                            }
                            case 3: {
                                messageArray[i] = new AQjmsMapMessage(this.jms_sess, aQjmsGenMessage_CArray[i]);
                                continue block20;
                            }
                            case 4: {
                                messageArray[i] = new AQjmsObjectMessage(this.jms_sess, aQjmsGenMessage_CArray[i]);
                                continue block20;
                            }
                            default: {
                                AQjmsError.throwEx(108, "The message_type within aq$_jms_message ADT " + n9 + " is not valid JMS message type");
                            }
                        }
                    }
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.bulkDequeue", "general payload messaeg retrieved");
                } else if (string5.equalsIgnoreCase("SYS.AQ$_JMS_TEXT_MESSAGE")) {
                    aQjmsTextMessages_C = (AQjmsTextMessages_C)this.deq_stmt.getObject(13, AQjmsTextMessages_C.getOracleDataFactory());
                    aQjmsTextMessage_CArray = aQjmsTextMessages_C.getArray();
                    messageArray = new Message[aQjmsTextMessage_CArray.length];
                    for (int i = 0; i < aQjmsTextMessage_CArray.length; ++i) {
                        messageArray[i] = new AQjmsTextMessage(this.jms_sess, aQjmsTextMessage_CArray[i]);
                    }
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.bulkDequeue", "text_message retrieved");
                } else if (string5.equalsIgnoreCase("SYS.AQ$_JMS_BYTES_MESSAGE")) {
                    aQjmsBytesMessages_C = (AQjmsBytesMessages_C)this.deq_stmt.getObject(13, AQjmsBytesMessages_C.getOracleDataFactory());
                    aQjmsBytesMessage_CArray = aQjmsBytesMessages_C.getArray();
                    messageArray = new Message[aQjmsBytesMessage_CArray.length];
                    for (int i = 0; i < aQjmsBytesMessage_CArray.length; ++i) {
                        messageArray[i] = new AQjmsBytesMessage(this.jms_sess, aQjmsBytesMessage_CArray[i]);
                    }
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.bulkDequeue", "bytes_message retrieved");
                } else if (string5.equalsIgnoreCase("SYS.AQ$_JMS_MAP_MESSAGE")) {
                    aQjmsMapMessages_C = (AQjmsMapMessages_C)this.deq_stmt.getObject(13, AQjmsMapMessages_C.getOracleDataFactory());
                    aQjmsMapMessage_CArray = aQjmsMapMessages_C.getArray();
                    messageArray = new Message[aQjmsMapMessage_CArray.length];
                    for (int i = 0; i < aQjmsMapMessage_CArray.length; ++i) {
                        messageArray[i] = new AQjmsMapMessage(this.jms_sess, aQjmsMapMessage_CArray[i]);
                    }
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.bulkDequeue", "map_message retrieved");
                } else if (string5.equalsIgnoreCase("SYS.AQ$_JMS_OBJECT_MESSAGE")) {
                    aQjmsObjectMessages_C = (AQjmsObjectMessages_C)this.deq_stmt.getObject(13, AQjmsObjectMessages_C.getOracleDataFactory());
                    aQjmsObjectMessage_CArray = aQjmsObjectMessages_C.getArray();
                    messageArray = new Message[aQjmsObjectMessage_CArray.length];
                    for (int i = 0; i < aQjmsObjectMessage_CArray.length; ++i) {
                        messageArray[i] = new AQjmsObjectMessage(this.jms_sess, aQjmsObjectMessage_CArray[i], this.xml_receive);
                    }
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.bulkDequeue", "object_message retrieved");
                } else if (string5.equalsIgnoreCase("SYS.AQ$_JMS_STREAM_MESSAGE")) {
                    aQjmsStreamMessages_C = (AQjmsStreamMessages_C)this.deq_stmt.getObject(13, AQjmsStreamMessages_C.getOracleDataFactory());
                    aQjmsStreamMessage_CArray = aQjmsStreamMessages_C.getArray();
                    messageArray = new Message[aQjmsStreamMessage_CArray.length];
                    for (int i = 0; i < aQjmsStreamMessage_CArray.length; ++i) {
                        messageArray[i] = new AQjmsStreamMessage(this.jms_sess, aQjmsStreamMessage_CArray[i]);
                    }
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.bulkDequeue", "stream_message retrieved");
                } else {
                    AQjmsError.throwInvalidDestEx(127);
                }
                aQjmsMessageProperties = (AQjmsMessageProperties)this.deq_stmt.getObject(12, AQjmsMessageProperties.getOracleDataFactory());
                aQjmsMessagePropertyArray = aQjmsMessageProperties.getArray();
                oracleArray = (OracleArray)this.deq_stmt.getArray(14);
                if (oracleArray != null) {
                    byArray = (byte[][])oracleArray.getArray();
                }
                for (int i = 0; i < messageArray.length; ++i) {
                    Object object;
                    timestamp = aQjmsMessagePropertyArray[i].getEnqueueTime();
                    long l7 = timestamp.getTime();
                    ((AQjmsMessage)messageArray[i]).setEnqueueTime(l7);
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.bulkDequeue", "set AQ enqueue_time as " + l7);
                    ((AQjmsMessage)messageArray[i]).setMessageState(aQjmsMessagePropertyArray[i].getState());
                    ((AQjmsMessage)messageArray[i]).setJMSMessageID(byArray[i]);
                    messageArray[i].setJMSCorrelationID(aQjmsMessagePropertyArray[i].getCorrelation());
                    messageArray[i].setJMSPriority(aQjmsMessagePropertyArray[i].getPriority().intValue());
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.bulkDequeue", "msg_id: " + messageArray[i].getJMSMessageID() + " corrid: " + aQjmsMessagePropertyArray[i].getCorrelation() + " priority: " + aQjmsMessagePropertyArray[i].getPriority());
                    ((AQjmsMessage)messageArray[i]).setDelay(aQjmsMessagePropertyArray[i].getDelay());
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.bulkDequeue", "msg_delay(secs): " + n5);
                    messageArray[i].setJMSExpiration(aQjmsMessagePropertyArray[i].getExpiration().longValue());
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.bulkDequeue", "exptime(secs): " + l5);
                    ((AQjmsMessage)messageArray[i]).setAttempts(aQjmsMessagePropertyArray[i].getAttempts());
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.bulkDequeue", "attempts: " + aQjmsMessagePropertyArray[i].getAttempts());
                    ((AQjmsMessage)messageArray[i]).setExceptionQueue(aQjmsMessagePropertyArray[i].getExceptionQueue());
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.bulkDequeue", "excp_q: " + aQjmsMessagePropertyArray[i].getExceptionQueue());
                    ((AQjmsMessage)messageArray[i]).setSenderID(aQjmsMessagePropertyArray[i].getSenderId());
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.bulkDequeue", "Sender" + aQjmsMessagePropertyArray[i].getSenderId());
                    ((AQjmsMessage)messageArray[i]).setOriginalMessageId(aQjmsMessagePropertyArray[i].getOriginalMsgid());
                    ((AQjmsMessage)messageArray[i]).setSignature(aQjmsMessagePropertyArray[i].getSignature());
                    if (!aQjmsDestination.isSharded() && ((AQjmsMessage)messageArray[i]).isJMSBody() && this.jms_sess.getCompliant()) {
                        messageArray[i].setJMSPriority(AQjmsMessage.toJMSPriority(messageArray[i].getJMSPriority()));
                    }
                    if (this.cd_factory == null && this.od_factory == null && this.orad_factory == null && var54_44 == null || bl3) {
                        aQjmsMessageHeaderExt = ((AQjmsMessage)messageArray[i]).getMessageHeaderExt();
                        aQjmsPropertyList = aQjmsMessageHeaderExt.getProperties();
                        hashtable = aQjmsPropertyList == null ? new Hashtable() : AQjmsMessage.convertPropertyListToHashtable(aQjmsPropertyList);
                        ((AQjmsMessage)messageArray[i]).setPropertiesHashtable(hashtable);
                    }
                    if (hashtable != null && hashtable.get("JMS_OracleHeaderOnly") != null) {
                        AQjmsOracleDebug.trace(5, "AQjmsConsumer.bulkDequeue", " Header only, Copying to generic msg");
                        object = new AQjmsMessage((AQjmsMessage)messageArray[i]);
                        messageArray[i] = null;
                        messageArray[i] = object;
                        ((AQjmsMessage)messageArray[i]).setHeaderOnly();
                    }
                    if (hashtable != null && hashtable.get("JMS_OracleDeliveryMode") != null) {
                        messageArray[i].setJMSDeliveryMode(Integer.parseInt(messageArray[i].getStringProperty("JMS_OracleDeliveryMode")));
                    }
                    if (messageArray[i].getJMSExpiration() <= 0L) {
                        messageArray[i].setJMSExpiration(0L);
                    } else {
                        messageArray[i].setJMSExpiration(messageArray[i].getJMSExpiration() * 1000L + messageArray[i].getJMSTimestamp());
                    }
                    object = new Date();
                    ((AQjmsMessage)messageArray[i]).setReceiveTime(((Date)object).getTime());
                    if (n8 > 0) {
                        messageArray[i].setJMSRedelivered(true);
                    } else {
                        messageArray[i].setJMSRedelivered(false);
                    }
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.bulkDequeue", "recv_time: " + (Date)object);
                    ((AQjmsMessage)messageArray[i]).setPropReadOnly(true);
                    ((AQjmsMessage)messageArray[i]).setAccessMode(0);
                    messageArray[i].setJMSDestination((Destination)aQjmsDestination);
                }
            }
            if (!bl) {
                this.doCommit(this.jms_sess);
            }
            if (!this.jms_sess.isDeqStmtCachingEnabled() && this.deq_stmt != null) {
                this.jms_sess.destroyStmt(this.deq_stmt);
            }
        }
        catch (SQLException sQLException) {
            this.jms_sess.destroyStmt(this.deq_stmt);
            if ((sQLException.getErrorCode() == 25228 || sQLException.getErrorCode() == 25263) && n3 != 4) {
                messageArray = null;
            } else {
                AQjmsError.throwEx(120, (Throwable)sQLException);
            }
        }
        catch (Exception exception) {
            this.jms_sess.destroyStmt(this.deq_stmt);
            AQjmsOracleDebug.traceEx(3, "AQjmsConsumer.bulkDequeue-ex3", exception);
            AQjmsError.throwEx(120, (Throwable)exception);
        }
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.bulkDequeue", "exit-2");
        return messageArray;
    }

    private long[] calculateValuesForTimeout(long l) {
        long l2 = 0L;
        if (l == 0L) {
            l2 = 0L;
        } else if (l > 0L) {
            l2 = l / 1000L;
            if (l2 == 0L) {
                l2 = 1L;
            }
        } else {
            l2 = -1L;
        }
        long l3 = this.jms_sess.getCloseCheckInterval();
        long l4 = 0L;
        long l5 = 0L;
        if (l2 != -1L) {
            if (l2 > l3) {
                l4 = l2 / l3;
                l5 = l2 % l3;
                if (l5 <= 0L) {
                    l5 = l3;
                }
            } else {
                l4 = 1L;
                l5 = l2;
            }
        }
        long[] lArray = new long[]{l2, l3, ++l4, l5};
        return lArray;
    }

    AQjmsNtfRegistration getNtfReg() {
        return this.ntfReg;
    }

    private synchronized void setMessageListenerForNotification(MessageListener messageListener) throws JMSException {
        if (this.ntfReg == null) {
            AQjmsNtfRegistration aQjmsNtfRegistration = new AQjmsNtfRegistration(this, this.jms_sess, messageListener);
            try {
                aQjmsNtfRegistration.registerJdbcNotification();
                this.ntfReg = aQjmsNtfRegistration;
                this.attach(this.ntfReg);
                this.jms_sess.usedJMSRegistration = true;
            }
            catch (JMSException jMSException) {
                AQjmsOracleDebug.traceEx(5, "setMessageListenerForNotification", jMSException);
                throw jMSException;
            }
        } else {
            this.ntfReg.setMessageListener(messageListener);
            if (messageListener == null) {
                this.ntfReg = null;
            }
        }
    }

    @Override
    void startJMSNotification() throws JMSException {
        if (this.ntfReg != null) {
            AQjmsOracleDebug.trace(4, "AQjmsConsumer.startJMSNotification", "starting JMS Notification");
            this.ntfReg.startJMSNotification();
        }
    }

    @Override
    void stopJMSNotification() throws JMSException {
        if (this.ntfReg != null) {
            AQjmsOracleDebug.trace(4, "AQjmsConsumer.stopJMSNotification", "stopping JMS Notification");
            this.ntfReg.stopJMSNotification();
        }
    }

    boolean isRegistrationDisabled() throws JMSException {
        if (this.ntfReg != null) {
            AQjmsOracleDebug.trace(4, "AQjmsConsumer.isRegistrationDisabled", "check the status of the registration");
            return this.ntfReg.isRegistrationDisabled();
        }
        return true;
    }

    void disableConsumerExceptionListener() {
        if (this.ntfReg == null) {
            return;
        }
        this.ntfReg.disableConsumerExceptionListener();
    }
}

