/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms.plsql;

import oracle.jdbc.OracleBlob;
import oracle.jdbc.OracleClob;
import oracle.jdbc.OracleStruct;
import oracle.jms.plsql.ExceptionHandler;
import oracle.jms.plsql.MsgStore;
import oracle.jms.plsql.ResourceMgr;
import oracle.jms.plsql.StreamMsgEntity;
import oracle.jms.plsql.TypeConversion;
import oracle.sql.NUMBER;

public class StreamMsgHandler {
    private static MsgStore msgStore = new MsgStore(2);

    public static int prepare(int n, int[] nArray, byte[] byArray, OracleBlob oracleBlob) {
        try {
            byte[] byArray2 = null;
            if (byArray != null) {
                byArray2 = byArray;
            } else if (oracleBlob != null) {
                byArray2 = oracleBlob.getBytes(1L, (int)oracleBlob.length());
            }
            nArray[0] = n < 0 ? msgStore.createMsgEntity(byArray2) : msgStore.createMsgEntity(n, byArray2);
            return 0;
        }
        catch (Throwable throwable) {
            return ExceptionHandler.getErrorCode(throwable);
        }
    }

    public static int clear_body(int n, int[] nArray) {
        try {
            nArray[0] = n < 0 ? msgStore.createMsgEntity() : msgStore.createMsgEntity(n);
            return 0;
        }
        catch (Throwable throwable) {
            return ExceptionHandler.getErrorCode(throwable);
        }
    }

    public static int get_mode(int n, int[] nArray) {
        try {
            StreamMsgEntity streamMsgEntity = (StreamMsgEntity)msgStore.getMsgEntity(n);
            nArray[0] = streamMsgEntity.getMode();
            return 0;
        }
        catch (Throwable throwable) {
            return ExceptionHandler.getErrorCode(throwable);
        }
    }

    public static int reset(int n) {
        try {
            StreamMsgEntity streamMsgEntity = (StreamMsgEntity)msgStore.getMsgEntity(n);
            streamMsgEntity.reset();
            return 0;
        }
        catch (Throwable throwable) {
            return ExceptionHandler.getErrorCode(throwable);
        }
    }

    public static int flush(int n, int[] nArray, byte[][] byArray, OracleBlob[] oracleBlobArray) {
        try {
            StreamMsgEntity streamMsgEntity = (StreamMsgEntity)msgStore.getMsgEntity(n);
            byte[] byArray2 = streamMsgEntity.flush();
            nArray[0] = byArray2.length;
            if (byArray2.length > 2000) {
                if (oracleBlobArray[0] == null) {
                    oracleBlobArray[0] = (OracleBlob)ResourceMgr.getConnection().createBlob();
                } else {
                    oracleBlobArray[0].truncate(0L);
                }
                oracleBlobArray[0].setBytes(1L, byArray2);
            } else {
                byArray[0] = byArray2;
            }
            return 0;
        }
        catch (Throwable throwable) {
            return ExceptionHandler.getErrorCode(throwable);
        }
    }

    public static int clean(int n) {
        try {
            msgStore.cleanMsgEntity(n);
            return 0;
        }
        catch (Throwable throwable) {
            return ExceptionHandler.getErrorCode(throwable);
        }
    }

    public static int clean_all() {
        try {
            msgStore.cleanAllMsgEntity();
            return 0;
        }
        catch (Throwable throwable) {
            return ExceptionHandler.getErrorCode(throwable);
        }
    }

    public static int read_object(int n, OracleStruct[] oracleStructArray, int[] nArray) {
        try {
            StreamMsgEntity streamMsgEntity = (StreamMsgEntity)msgStore.getMsgEntity(n);
            Object object = streamMsgEntity.readObject();
            TypeConversion.objToJmsValue(object, oracleStructArray, nArray);
            return 0;
        }
        catch (Throwable throwable) {
            try {
                nArray[0] = 1;
                oracleStructArray[0] = TypeConversion.getNullSTRUCT();
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            return ExceptionHandler.getErrorCode(throwable);
        }
    }

    public static int read_number(int n, NUMBER[] nUMBERArray, int n2) {
        try {
            StreamMsgEntity streamMsgEntity = (StreamMsgEntity)msgStore.getMsgEntity(n);
            Object object = streamMsgEntity.readObject(n2);
            nUMBERArray[0] = TypeConversion.objToNumber(object, n2);
            return 0;
        }
        catch (Throwable throwable) {
            return ExceptionHandler.getErrorCode(throwable);
        }
    }

    public static int read_bytes(int n, OracleBlob[] oracleBlobArray) {
        try {
            StreamMsgEntity streamMsgEntity = (StreamMsgEntity)msgStore.getMsgEntity(n);
            Object object = streamMsgEntity.readObject(9);
            if (object == null) {
                oracleBlobArray[0] = null;
                return 0;
            }
            byte[] byArray = (byte[])object;
            if (oracleBlobArray[0] == null) {
                oracleBlobArray[0] = (OracleBlob)ResourceMgr.getConnection().createBlob();
            } else {
                oracleBlobArray[0].truncate(0L);
            }
            oracleBlobArray[0].setBytes(1L, byArray);
            return 0;
        }
        catch (Throwable throwable) {
            return ExceptionHandler.getErrorCode(throwable);
        }
    }

    public static int read_char(int n, String[] stringArray) {
        try {
            StreamMsgEntity streamMsgEntity = (StreamMsgEntity)msgStore.getMsgEntity(n);
            Object object = streamMsgEntity.readObject(7);
            if (object == null) {
                stringArray[0] = null;
                return 0;
            }
            stringArray[0] = ((Character)object).toString();
            return 0;
        }
        catch (Throwable throwable) {
            return ExceptionHandler.getErrorCode(throwable);
        }
    }

    public static int read_string(int n, OracleClob[] oracleClobArray) {
        try {
            StreamMsgEntity streamMsgEntity = (StreamMsgEntity)msgStore.getMsgEntity(n);
            Object object = streamMsgEntity.readObject(8);
            if (object == null) {
                oracleClobArray[0] = null;
                return 0;
            }
            String string = (String)object;
            if (oracleClobArray[0] == null) {
                oracleClobArray[0] = (OracleClob)ResourceMgr.getConnection().createClob();
            } else {
                oracleClobArray[0].truncate(0L);
            }
            oracleClobArray[0].setString(1L, string);
            return 0;
        }
        catch (Throwable throwable) {
            return ExceptionHandler.getErrorCode(throwable);
        }
    }

    public static int write_number(int n, NUMBER nUMBER, int n2) {
        try {
            StreamMsgEntity streamMsgEntity = (StreamMsgEntity)msgStore.getMsgEntity(n);
            streamMsgEntity.writeObject(TypeConversion.numberToObj(nUMBER, n2));
            return 0;
        }
        catch (Throwable throwable) {
            return ExceptionHandler.getErrorCode(throwable);
        }
    }

    public static int write_bytes(int n, byte[] byArray, int n2, int n3) {
        try {
            if (byArray == null) {
                return 0;
            }
            StreamMsgEntity streamMsgEntity = (StreamMsgEntity)msgStore.getMsgEntity(n);
            if (n2 == 0 && n3 == byArray.length) {
                streamMsgEntity.writeObject(byArray);
            } else {
                byte[] byArray2 = new byte[n3];
                System.arraycopy(byArray, n2, byArray2, 0, n3);
                streamMsgEntity.writeObject(byArray2);
            }
            return 0;
        }
        catch (Throwable throwable) {
            return ExceptionHandler.getErrorCode(throwable);
        }
    }

    public static int write_bytes(int n, OracleBlob oracleBlob, int n2, int n3) {
        try {
            if (oracleBlob == null) {
                return 0;
            }
            StreamMsgEntity streamMsgEntity = (StreamMsgEntity)msgStore.getMsgEntity(n);
            if ((long)(n2 + n3) > oracleBlob.length()) {
                throw new IndexOutOfBoundsException();
            }
            byte[] byArray = oracleBlob.getBytes((long)(n2 + 1), n3);
            streamMsgEntity.writeObject(byArray);
            return 0;
        }
        catch (Throwable throwable) {
            return ExceptionHandler.getErrorCode(throwable);
        }
    }

    public static int write_char(int n, String string) {
        try {
            if (string != null && string.length() > 0) {
                StreamMsgEntity streamMsgEntity = (StreamMsgEntity)msgStore.getMsgEntity(n);
                streamMsgEntity.writeObject(new Character(string.charAt(0)));
            }
            return 0;
        }
        catch (Throwable throwable) {
            return ExceptionHandler.getErrorCode(throwable);
        }
    }

    public static int write_string(int n, String string) {
        try {
            if (string == null) {
                return 0;
            }
            StreamMsgEntity streamMsgEntity = (StreamMsgEntity)msgStore.getMsgEntity(n);
            streamMsgEntity.writeObject(string);
            return 0;
        }
        catch (Throwable throwable) {
            return ExceptionHandler.getErrorCode(throwable);
        }
    }

    public static int write_string(int n, OracleClob oracleClob) {
        try {
            if (oracleClob == null) {
                return 0;
            }
            StreamMsgEntity streamMsgEntity = (StreamMsgEntity)msgStore.getMsgEntity(n);
            streamMsgEntity.writeObject(oracleClob.getSubString(1L, (int)oracleClob.length()));
            return 0;
        }
        catch (Throwable throwable) {
            return ExceptionHandler.getErrorCode(throwable);
        }
    }
}

