/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import javax.jms.JMSConsumer;
import javax.jms.JMSException;
import javax.jms.JMSRuntimeException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import oracle.jms.AQjmsConsumer;
import oracle.jms.AQjmsJMSContext;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsUtil;

public class AQjmsJMSConsumer
implements JMSConsumer {
    private final MessageConsumer consumer;
    private final AQjmsJMSContext context;

    AQjmsJMSConsumer(AQjmsJMSContext context, MessageConsumer consumer) {
        AQjmsOracleDebug.trace(5, "AQjmsJMSConsumer", "constructor");
        this.context = context;
        this.consumer = consumer;
    }

    public String getMessageSelector() {
        try {
            return ((AQjmsConsumer)this.consumer).getMessageSelector();
        }
        catch (JMSException e) {
            AQjmsOracleDebug.traceEx(3, "AQjmsJMSConsumer.getMessageSelector", e);
            throw AQjmsUtil.convertToRuntimeException(e);
        }
    }

    public MessageListener getMessageListener() throws JMSRuntimeException {
        try {
            return ((AQjmsConsumer)this.consumer).getMessageListener();
        }
        catch (JMSException e) {
            throw AQjmsUtil.convertToRuntimeException(e);
        }
    }

    public void setMessageListener(MessageListener listener) throws JMSRuntimeException {
        try {
            ((AQjmsConsumer)this.consumer).setMessageListener(listener);
        }
        catch (JMSException e) {
            throw AQjmsUtil.convertToRuntimeException(e);
        }
    }

    public Message receive() {
        try {
            return ((AQjmsConsumer)this.consumer).receive();
        }
        catch (JMSException e) {
            throw AQjmsUtil.convertToRuntimeException(e);
        }
    }

    public Message receive(long timeout) {
        try {
            return ((AQjmsConsumer)this.consumer).receive(timeout);
        }
        catch (JMSException e) {
            throw AQjmsUtil.convertToRuntimeException(e);
        }
    }

    public Message receiveNoWait() {
        try {
            return ((AQjmsConsumer)this.consumer).receiveNoWait();
        }
        catch (JMSException e) {
            throw AQjmsUtil.convertToRuntimeException(e);
        }
    }

    public void close() {
        try {
            this.consumer.close();
        }
        catch (JMSException e) {
            throw AQjmsUtil.convertToRuntimeException(e);
        }
    }

    public <T> T receiveBody(Class<T> c) {
        try {
            Message message = this.consumer.receive();
            return (T)(message == null ? null : message.getBody(c));
        }
        catch (JMSException e) {
            throw AQjmsUtil.convertToRuntimeException(e);
        }
    }

    public <T> T receiveBody(Class<T> c, long timeout) {
        try {
            Message message = this.consumer.receive(timeout);
            return (T)(message == null ? null : message.getBody(c));
        }
        catch (JMSException e) {
            throw AQjmsUtil.convertToRuntimeException(e);
        }
    }

    public <T> T receiveBodyNoWait(Class<T> c) {
        try {
            Message message = this.consumer.receiveNoWait();
            return (T)(message == null ? null : message.getBody(c));
        }
        catch (JMSException e) {
            throw AQjmsUtil.convertToRuntimeException(e);
        }
    }
}

