/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import javax.jms.JMSException;
import javax.jms.Session;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import oracle.jms.AQjmsConstants;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsSession;
import oracle.jms.AQjmsXAException;

public class AQjmsEmulatedXAResource
implements XAResource {
    private Session m_session;
    private int m_transactionTimeout;

    public AQjmsEmulatedXAResource(Session sess) {
        this.m_session = sess;
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        AQjmsOracleDebug.trace(1, "AQjmsEmulatedXAResource.commit", "enter: xid=" + String.valueOf(xid) + " onePhase=" + onePhase);
        try {
            this.m_session.commit();
        }
        catch (JMSException jmse) {
            AQjmsOracleDebug.traceEx(1, "AQjmsEmulatedXAResource.commit", jmse);
            throw new AQjmsXAException(jmse, "AQjmsEmulatedXAResource.commit failed. xid=" + String.valueOf(xid) + ", onePhase=" + onePhase);
        }
        if (this.m_session instanceof AQjmsSession && !AQjmsConstants.ignorePriority()) {
            ((AQjmsSession)this.m_session).restartConsumers();
        }
        AQjmsOracleDebug.trace(1, "AQjmsEmulatedXAResource.commit", "exit");
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        AQjmsOracleDebug.trace(1, "AQjmsEmulatedXAResource.end", "enter: xid=" + String.valueOf(xid) + " flags=" + flags);
        AQjmsOracleDebug.trace(1, "AQjmsEmulatedXAResource.end", "exit");
    }

    @Override
    public void forget(Xid xid) throws XAException {
        AQjmsOracleDebug.trace(1, "AQjmsEmulatedXAResource.forget", "enter: xid=" + String.valueOf(xid));
        AQjmsOracleDebug.trace(1, "AQjmsEmulatedXAResource.forget", "exit");
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        AQjmsOracleDebug.trace(1, "AQjmsEmulatedXAResource.getTransactionTimeout", "enter");
        AQjmsOracleDebug.trace(1, "AQjmsEmulatedXAResource.getTransactionTimeout", "exit: transaction timeout=" + this.m_transactionTimeout);
        return this.m_transactionTimeout;
    }

    @Override
    public boolean isSameRM(XAResource xares) throws XAException {
        AQjmsOracleDebug.trace(1, "AQjmsEmulatedXAResource.isSameRM", "enter");
        boolean isSame = false;
        isSame = xares == null ? false : (this == xares ? true : (xares instanceof AQjmsEmulatedXAResource ? this.m_session == ((AQjmsEmulatedXAResource)xares).m_session : false));
        AQjmsOracleDebug.trace(1, "AQjmsEmulatedXAResource.isSameRM: isSameRM=" + isSame, "exit");
        return isSame;
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        AQjmsOracleDebug.trace(1, "AQjmsEmulatedXAResource.prepare", "enter: xid=" + String.valueOf(xid));
        AQjmsOracleDebug.trace(1, "AQjmsEmulatedXAResource.prepare", "exit");
        return 0;
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        AQjmsOracleDebug.trace(1, "AQjmsEmulatedXAResource.recover", "enter: flag=" + flag);
        AQjmsOracleDebug.trace(1, "AQjmsEmulatedXAResource.recover", "exit");
        return new Xid[0];
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        AQjmsOracleDebug.trace(1, "AQjmsEmulatedXAResource.rollback", "enter: xid=" + String.valueOf(xid));
        try {
            this.m_session.rollback();
        }
        catch (JMSException jmse) {
            AQjmsOracleDebug.traceEx(1, "AQjmsEmulatedXAResource.rollback", jmse);
            throw new AQjmsXAException(jmse, "AQjmsEmulatedXAResource.rollback failed. xid=" + String.valueOf(xid));
        }
        if (this.m_session instanceof AQjmsSession) {
            ((AQjmsSession)this.m_session).restartConsumers();
        }
        AQjmsOracleDebug.trace(1, "AQjmsEmulatedXAResource.rollback", "exit");
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        AQjmsOracleDebug.trace(1, "AQjmsEmulatedXAResource.setTransactionTimeout", "enter: seconds=" + seconds);
        this.m_transactionTimeout = seconds;
        AQjmsOracleDebug.trace(1, "AQjmsEmulatedXAResource.setTransactionTimeout", "exit");
        return true;
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        AQjmsOracleDebug.trace(1, "AQjmsEmulatedXAResource.start", "enter: xid=" + String.valueOf(xid) + " flags=" + flags);
        AQjmsOracleDebug.trace(1, "AQjmsEmulatedXAResource.start", "exit");
    }
}

