/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import oracle.jms.AQjmsConstants;
import oracle.jms.AQjmsConsumer;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsObject;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsSession;
import oracle.jms.AQjmsSimpleScheduler;
import oracle.jms.AQjmsStatScheduler;
import oracle.jms.DispatchScheduler;
import oracle.jms.ThreadProxy;

class AQjmsListenerWorker
extends AQjmsObject
implements Runnable {
    private AQjmsConsumer m_consumer;
    private MessageListener m_listener;
    private DispatchScheduler m_scheduler;
    private AQjmsSession m_sess;
    private Object m_sleepObj = new Object();
    private Thread m_workThread;
    private String consumer_name = "";
    private String m_diagInfo = "";

    AQjmsListenerWorker(AQjmsSession sess, AQjmsConsumer cons, MessageListener lsnr) throws JMSException {
        this(sess, cons, lsnr, null);
    }

    AQjmsListenerWorker(AQjmsSession sess, AQjmsConsumer cons, MessageListener lsnr, DispatchScheduler scheduler) throws JMSException {
        super("AQjmsListenerWorker", cons);
        this.m_sess = sess;
        this.m_consumer = cons;
        this.m_listener = lsnr;
        this.m_scheduler = scheduler;
        if (this.m_consumer.cons_name != null) {
            this.consumer_name = this.m_consumer.cons_name;
        }
        if (scheduler == null) {
            if (AQjmsConstants.getDefaultScheduler() == 2) {
                this.m_scheduler = new AQjmsStatScheduler(null);
                AQjmsOracleDebug.trace(3, "AQjmsListenerWorker.constructor", "Using AQjmsStatScheduler as the DispatchScheduler");
            } else {
                this.m_scheduler = new AQjmsSimpleScheduler(null);
                AQjmsOracleDebug.trace(3, "AQjmsListenerWorker.constructor", "Using AQjmsSimpleScheduler as the DispatchScheduler");
            }
        }
        cons.attach(this);
        try {
            this.m_diagInfo = "Queue: " + String.valueOf(this.m_consumer.cons_dest) + " Consumer_name: " + this.consumer_name;
            if (this.m_sess.jdbcConnInfo != null) {
                this.m_diagInfo = this.m_diagInfo + " JDBC INFO: " + this.m_sess.jdbcConnInfo.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    synchronized void setMessageListener(MessageListener lsnr) {
        this.m_listener = lsnr;
        if (lsnr == null) {
            this.notifyAll();
        }
    }

    synchronized void setMessageListener(MessageListener lsnr, DispatchScheduler scheduler) {
        this.m_listener = lsnr;
        this.m_scheduler = scheduler;
        if (lsnr == null) {
            this.notifyAll();
        }
    }

    synchronized MessageListener getMessageListener() {
        return this.m_listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void preClose() {
        Object object = this.m_sleepObj;
        synchronized (object) {
            this.m_sleepObj.notifyAll();
        }
    }

    @Override
    public void run() {
        AQjmsOracleDebug.trace(1, "AQjmsListenerWorker.run", "START: " + Thread.currentThread().getName() + ": " + this.m_diagInfo);
        while (true) {
            AQjmsOracleDebug.trace(3, "AQjmsListenerWorker.run", "Before dispatchOneMsg to dispatch a message to the listener");
            if (!this.dispatchOneMsg()) {
                AQjmsOracleDebug.trace(1, "AQjmsListenerWorker.run", "dispatchOneMsg return false, EXIT " + this.m_diagInfo);
                return;
            }
            AQjmsOracleDebug.trace(3, "AQjmsListenerWorker.run", "After dispatchOneMsg, Before get the next sleep time ");
            long sleepTime = this.m_scheduler.getNextSleepTime();
            AQjmsOracleDebug.trace(3, "AQjmsListenerWorker.run", "sleep " + sleepTime + " millisecond.");
            if (sleepTime == 0L) continue;
            this.doSleep(sleepTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSleep(long sleepTime) {
        Object object = this.m_sleepObj;
        synchronized (object) {
            if (this.isClosed() || this.m_listener == null) {
                AQjmsOracleDebug.trace(3, "AQjmsListenerWorker.doSleep", "consumer is closed or listener is set to null, EXIT");
                return;
            }
            try {
                AQjmsOracleDebug.trace(3, "AQjmsListenerWorker.doSleep", "try to wait for " + sleepTime + " milliseconds");
                this.m_sleepObj.wait(sleepTime);
            }
            catch (Exception e) {
                AQjmsOracleDebug.traceEx(3, "AQjmsListenerWorker.doSleep: Sleep thread might be interrupted.", e);
            }
            AQjmsOracleDebug.trace(3, "AQjmsListenerWorker.doSleep", "exit");
        }
    }

    private void feedSchedulerData(Message msg) {
        try {
            if (this.m_scheduler != null) {
                this.m_scheduler.feedData(msg);
            }
        }
        catch (Exception e) {
            AQjmsOracleDebug.traceEx(3, "ListenerWorker.feedSchedulerData: Error in feeding data to DispatchScheduler", e);
        }
    }

    private void feedSchedulerException(int exceptionType, Exception exp) {
        try {
            if (this.m_scheduler != null) {
                this.m_scheduler.feedException(exceptionType, exp);
            }
        }
        catch (Exception e) {
            AQjmsOracleDebug.traceEx(3, "ListenerWorker.feedSchedulerException: Error in feeding exception to DispatchScheduler", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean dispatchOneMsg() {
        AQjmsOracleDebug.trace(3, "AQjmsListenerWorker.dispatchOneMsg", "entry");
        if (this.isClosed() || this.m_listener == null) {
            AQjmsOracleDebug.trace(3, "AQjmsListenerWorker.dispatchOneMsg", "consumer is closed or listener is set to null, EXIT");
            return false;
        }
        try {
            this.m_consumer.lockReceive("ListenerWorker.dispatchOneMsg", -1L);
        }
        catch (IllegalStateException ise) {
            return false;
        }
        catch (Exception e) {
            AQjmsOracleDebug.traceEx(3, "ListenerWorker.dispatchOneMsg: Error in acquiring the lock.", e);
            this.feedSchedulerException(1, e);
            return true;
        }
        AQjmsOracleDebug.trace(3, "AQjmsListenerWorker.dispatchOneMsg", "lockReceive returns, got the lock");
        Message msg = null;
        try {
            AQjmsOracleDebug.trace(2, "AQjmsListenerWorker.dispatchOneMsg", this.m_diagInfo);
            msg = this.m_consumer.receiveForListener();
        }
        catch (Exception e) {
            AQjmsOracleDebug.traceEx(1, "ListenerWorker.dispatchOneMsg: Error in receiving message for listener " + this.m_diagInfo, e);
            this.feedSchedulerException(1, e);
            this.m_consumer.unlock("ListenerWorker.dispatchOneMsg");
            if (this.m_sess.isClosed()) {
                return false;
            }
            if (this.isOpen()) {
                this.feedExceptionToConnection(e);
            }
            return true;
        }
        try {
            AQjmsOracleDebug.trace(3, "AQjmsListenerWorker.dispatchOneMsg", "Received the message: " + (msg == null ? "null message" : msg.getJMSMessageID()));
        }
        catch (Exception e) {
            // empty catch block
        }
        this.feedSchedulerData(msg);
        if (msg != null) {
            AQjmsException oe = null;
            try {
                this.m_sess.startListener();
                AQjmsOracleDebug.trace(2, "AQjmsListenerWorker.dispatchOneMsg", "Before calling onMessage method");
                this.m_listener.onMessage(msg);
                AQjmsOracleDebug.trace(2, "AQjmsListenerWorker.dispatchOneMsg", "After calling onMessage method");
            }
            catch (Throwable th) {
                oe = new AQjmsException("Error in onMessage Method", th);
                AQjmsOracleDebug.traceEx(1, "ListenerWorker.dispatchOneMsg: error in onMessage of MessageListener class", (Throwable)((Object)oe));
            }
            finally {
                this.m_sess.stopListener();
            }
            try {
                int mode = this.m_sess.getAcknowledgeMode();
                if (mode == 1 || mode == 3) {
                    if (oe == null) {
                        this.m_sess.forceCommit();
                        AQjmsOracleDebug.trace(3, "AQjmsListenerWorker.dispatchOneMsg", "acknowledged the message just received.");
                    } else {
                        this.m_sess.forceRollback();
                        AQjmsOracleDebug.trace(3, "AQjmsListenerWorker.dispatchOneMsg", "recover the message just received.");
                        this.feedSchedulerException(2, (Exception)((Object)oe));
                    }
                }
            }
            catch (Exception e) {
                AQjmsOracleDebug.traceEx(3, "ListenerWorker.dispatchOneMsg: error in acknowledgement or recovery after onMessage", e);
            }
        }
        this.m_consumer.unlock("ListenerWorker.dispatchOneMsg");
        AQjmsOracleDebug.trace(3, "AQjmsListenerWorker.dispatchOneMsg", "unlock the session and EXIT");
        return true;
    }

    void launch() throws JMSException {
        this.launch(null);
    }

    void launch(ThreadProxy proxy) throws JMSException {
        try {
            if (proxy == null) {
                this.m_workThread = new Thread(this);
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        AQjmsListenerWorker.this.m_workThread.setDaemon(true);
                        return null;
                    }
                });
                this.m_workThread.start();
            } else {
                this.m_workThread = proxy.launch(this);
            }
        }
        catch (Exception e) {
            AQjmsOracleDebug.traceEx(3, "ListenerWorker.launch: error in staring the listening thread", e);
            AQjmsError.throwEx(237, (Throwable)e);
        }
    }

    Thread getListenerWorkerThread() {
        return this.m_workThread;
    }

    private void feedExceptionToConnection(Exception exp) {
        JMSException jmsExp = null;
        try {
            jmsExp = exp instanceof JMSException ? (JMSException)((Object)exp) : new AQjmsException(exp.getMessage(), exp);
            AQjmsOracleDebug.trace(1, "AQjmsListenerWorker.feedExceptionToConnection", "Exception: " + String.valueOf((Object)jmsExp) + " DIAG:" + this.m_diagInfo);
            this.m_sess.jms_conn.feedJMSException(jmsExp);
        }
        catch (Exception e) {
            AQjmsOracleDebug.traceEx(0, "ListenerWorker.feedExceptionToConnection: Error in feeding exception to Connection: DIAG" + this.m_diagInfo, e);
        }
    }
}

