/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.jms.JMSException;
import oracle.jms.AQjmsConstants;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsParserConstants;
import oracle.jms.AQjmsParserExpr;
import oracle.jms.AQjmsParserTokenManager;
import oracle.jms.JavaCharStream;
import oracle.jms.ParseException;
import oracle.jms.Token;

class AQjmsParser
implements AQjmsParserConstants {
    private static final String JMS_PROPERTY_DELIMETER = "#^$";
    boolean doStrongTypeChecking = AQjmsConstants.isStronglyTypedSelector();
    boolean is_func_call = false;
    int dest_pload_type = 0;
    boolean compliant = AQjmsConstants.IS_COMPLIANT;
    private String v1;
    private String v2v3v4;
    private static String JMS_HEADER = "1)";
    private static String USER_PROP = "0)";
    public AQjmsParserTokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[30];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private final JJCalls[] jj_2_rtns = new JJCalls[6];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private static final LookaheadSuccess jj_ls;
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;
    private boolean trace_enabled;

    public void setDestPayloadType(int dest_pload_type) {
        this.dest_pload_type = dest_pload_type;
    }

    public void setCompliant(boolean compliant) {
        this.compliant = compliant;
    }

    void initForJmsSharded() {
        this.dest_pload_type = 4;
        this.doStrongTypeChecking = true;
        this.compliant = true;
        this.v1 = ":v1,'";
        this.v2v3v4 = "',:v2,:v3,:v4,";
    }

    public String parseRule(String parser_input) throws JMSException {
        AQjmsParser parser = null;
        String rule = null;
        AQjmsOracleDebug.trace(4, "AQjmsParser.parseRule", "entry");
        parser = new AQjmsParser(new StringReader(parser_input));
        try {
            rule = parser.SubscriberRule();
            AQjmsOracleDebug.trace(5, "AQjmsParser.parseRule", "Rule: " + rule);
            AQjmsOracleDebug.println("\nMessage parsed successfully");
        }
        catch (ParseException ex) {
            AQjmsOracleDebug.traceEx(4, "Rule parse error", ex);
            new AQjmsException("Rule Parse error", 100, ex);
        }
        AQjmsOracleDebug.trace(4, "AQjmsParser.parseRule", "exit");
        return rule;
    }

    public String mapJMSStringToColumn(String input, int sel_type) throws ParseException {
        String new_value = null;
        AQjmsOracleDebug.trace(5, "AQjmsParser.mapJMSStringToColumn", "Sel type: " + sel_type);
        if (sel_type == 10 || sel_type == 50) {
            new_value = this.dest_pload_type == 4 ? this.mapJMSPropertyNamesSharded(input) : this.mapJMSPropertyNames(input);
        }
        return new_value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String mapJMSPropertyNamesSharded(String input) throws ParseException {
        Object newValue = null;
        if (input == null) {
            throw new ParseException("input is NULL");
        }
        AQjmsOracleDebug.trace(5, "AQjmsParser.mapJMSPropertyNamesSharded", "Input: " + input);
        if (input.equals("")) {
            return input;
        }
        if (input.equalsIgnoreCase("NULL")) {
            return input;
        }
        if (input.startsWith("JMS_Oracle")) {
            if (input.equals("JMS_OracleConnectionID")) return JMS_PROPERTY_DELIMETER + input + JMS_PROPERTY_DELIMETER;
            throw new ParseException("Oracle specific property: " + input + " not supported in message selector");
        }
        if (input.startsWith("JMS") && !input.startsWith("JMSX")) {
            if (input.equals("JMSMessageID")) {
                newValue = "tab.msgid";
            } else if (input.equals("JMSCorrelationID")) {
                newValue = "correlation";
            } else if (input.equals("JMSPriority")) {
                newValue = "priority";
            } else if (input.equals("JMSTimestamp")) {
                newValue = "enqueue_time";
            } else if (input.equals("JMSType")) {
                newValue = this.toRulesSyntaxJmsSharded(input, 2, JMS_HEADER);
            } else {
                if (!input.equals("JMSDeliveryMode")) throw new ParseException("Header: " + input + " not supported in message selector");
                newValue = this.toRulesSyntaxJmsSharded(input, 2, JMS_HEADER);
            }
        } else {
            newValue = this.is_func_call ? input : JMS_PROPERTY_DELIMETER + input + JMS_PROPERTY_DELIMETER;
        }
        AQjmsOracleDebug.trace(5, "AQjmsParser.mapJMSPropertyNamesSharded", "New value: " + (String)newValue);
        return newValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String mapJMSPropertyNames(String input) throws ParseException {
        Object new_value = null;
        if (input == null) {
            throw new ParseException("input is NULL");
        }
        AQjmsOracleDebug.trace(5, "AQjmsParser.mapJMSPropertyNames", "Input: " + input);
        if (input.equals("")) {
            return input;
        }
        if (input.equalsIgnoreCase("NULL")) {
            return input;
        }
        if (input.startsWith("JMS_Oracle")) {
            if (!input.equals("JMS_OracleConnectionID")) {
                throw new ParseException("Oracle specific property: " + input + " not supported in message selector");
            }
            new_value = JMS_PROPERTY_DELIMETER + input + JMS_PROPERTY_DELIMETER;
        } else if (input.startsWith("JMS")) {
            if (input.equals("JMSPriority")) {
                new_value = this.compliant ? "(9 - priority)" : "priority";
            } else if (input.equals("JMSCorrelationID")) {
                new_value = "corrid";
            } else if (input.equals("JMSTimestamp")) {
                new_value = "enq_time";
            } else if (input.equals("JMSMessageID")) {
                new_value = "tab.msgid";
            } else if (input.equals("JMSType")) {
                new_value = "tab.user_data.header.type";
            } else if (input.equals("JMSXUserID")) {
                new_value = "tab.user_data.header.userid";
            } else if (input.equals("JMSXAppID")) {
                new_value = "tab.user_data.header.appid";
            } else if (input.equals("JMSXGroupID")) {
                new_value = "tab.user_data.header.groupid";
            } else if (input.equals("JMSXGroupSeq")) {
                new_value = "tab.user_data.header.groupseq";
            } else {
                if (!input.equals("JMSDeliveryMode")) throw new ParseException("System property: " + input + " not supported in message selector");
                new_value = "#^$JMS_OracleDeliveryMode#^$";
            }
        } else {
            new_value = this.is_func_call ? input : JMS_PROPERTY_DELIMETER + input + JMS_PROPERTY_DELIMETER;
        }
        AQjmsOracleDebug.trace(5, "AQjmsParser.mapJMSPropertyNames", "New value: " + (String)new_value);
        return new_value;
    }

    String trimIDPrefix(String jmsID) throws ParseException {
        AQjmsOracleDebug.trace(4, "AQjmsParser", "trimIDPrefix - entry");
        if (jmsID == null || jmsID.length() < 5 || !jmsID.substring(1, 4).equals("ID:")) {
            AQjmsOracleDebug.trace(3, "AQjmsParser", "trimIDPrefix - parse exception");
            throw new ParseException("Invalid JMSMessageID in selector");
        }
        String aqID = jmsID.substring(0, 1) + jmsID.substring(4);
        AQjmsOracleDebug.trace(4, "AQjmsParser", "trimIDPrefix - exit");
        return aqID;
    }

    String checkForEscapeChars(String quoted_input) {
        int start_idx = 0;
        int idx = 0;
        boolean str_len = false;
        boolean retry = true;
        String input = null;
        String new_str = null;
        StringBuffer sbuf = new StringBuffer();
        AQjmsOracleDebug.trace(5, "AQjmsParser.checkForEscapeChars", "QuotedInput:  " + quoted_input);
        if (quoted_input == null || quoted_input.length() <= 2) {
            return quoted_input;
        }
        input = quoted_input.substring(1, quoted_input.length() - 1);
        sbuf.append("'");
        if (input != null && input.length() > 0) {
            while (retry) {
                idx = input.indexOf("\\", start_idx);
                if (idx == -1) {
                    retry = false;
                    if (start_idx == 0) {
                        sbuf.append(input);
                        continue;
                    }
                    sbuf.append(input.substring(start_idx));
                    continue;
                }
                if (idx < input.length() - 1 && input.charAt(idx + 1) == '\'') {
                    sbuf.append(input.substring(start_idx, idx));
                    sbuf.append("'");
                    sbuf.append(input.charAt(idx + 1));
                    start_idx = idx + 2;
                } else {
                    sbuf.append(input.substring(start_idx, idx + 1));
                    start_idx = idx + 1;
                }
                if (start_idx < input.length()) {
                    retry = true;
                    continue;
                }
                retry = false;
            }
        } else {
            sbuf.append(input);
        }
        sbuf.append("'");
        new_str = sbuf.toString();
        AQjmsOracleDebug.trace(5, "AQjmsParser.checkForEscapeChars", "New String:  " + new_str);
        return new_str;
    }

    private String toRulesSyntax(String propname, int type) {
        String outprop = null;
        outprop = this.doStrongTypeChecking && type == 1 ? (this.dest_pload_type == 3 ? "decode(dbms_aqjms.get_ptype('" + propname + "', dbms_aqjms.aq$_pr(tab.user_data)), 200, dbms_aqjms.get_numval('" + propname + "', dbms_aqjms.aq$_pr(tab.user_data)), null)" : "decode(dbms_aqjms.get_ptype('" + propname + "', tab.user_data.header.properties), 200, dbms_aqjms.get_numval('" + propname + "', tab.user_data.header.properties), null)") : (this.doStrongTypeChecking && type == 2 ? (this.dest_pload_type == 3 ? "decode(dbms_aqjms.get_ptype('" + propname + "', dbms_aqjms.aq$_pr(tab.user_data)), 100, dbms_aqjms.get_strval('" + propname + "', dbms_aqjms.aq$_pr(tab.user_data)), null)" : "tab.user_data.header.get_string_property ('" + propname + "') ") : (this.doStrongTypeChecking && type == 4 ? (this.dest_pload_type == 3 ? "decode(dbms_aqjms.get_ptype('" + propname + "', dbms_aqjms.aq$_pr(tab.user_data)), 200, dbms_aqjms.get_numval('" + propname + "', dbms_aqjms.aq$_pr(tab.user_data)), null)" : "tab.user_data.header.get_boolean_property_as_int ('" + propname + "') ") : (this.dest_pload_type == 3 ? "decode(dbms_aqjms.get_ptype('" + propname + "', dbms_aqjms.aq$_pr(tab.user_data)), 100, dbms_aqjms.get_strval('" + propname + "', dbms_aqjms.aq$_pr(tab.user_data)), 200, dbms_aqjms.get_numval('" + propname + "', dbms_aqjms.aq$_pr(tab.user_data)), null)" : "decode(dbms_aqjms.get_ptype('" + propname + "', tab.user_data.header.properties), 100, dbms_aqjms.get_strval('" + propname + "', tab.user_data.header.properties), 200, dbms_aqjms.get_numval('" + propname + "', tab.user_data.header.properties), null)")));
        return outprop;
    }

    private String toRulesSyntaxJmsSharded(String propName, int type, String headerOrUsrProp) {
        Object outProp = null;
        if (type == 2) {
            outProp = "sys.dbms_aqjms.search_string_property(";
        } else if (type == 1) {
            outProp = "sys.dbms_aqjms.search_number_property(";
        } else if ((type & 4) != 0) {
            outProp = "sys.dbms_aqjms.search_boolean_property(";
        } else {
            throw new RuntimeException("Unsupported");
        }
        outProp = (String)outProp + this.v1 + propName + this.v2v3v4 + headerOrUsrProp;
        return outProp;
    }

    void promoteToString(AQjmsParserExpr expr) throws ParseException {
        this.promoteExpression(expr, 2, false);
    }

    void promoteToNumeric(AQjmsParserExpr expr) throws ParseException {
        this.promoteExpression(expr, 1, false);
    }

    void promoteExpression(AQjmsParserExpr expr, int type, boolean add_boolean_compare) throws ParseException {
        String origstr = expr.getString();
        String propname = null;
        StringBuffer outstr = new StringBuffer(origstr.length());
        int startind = 0;
        int endind = 0;
        if (add_boolean_compare) {
            outstr.append("(");
        }
        AQjmsOracleDebug.println("promoteExpression: IN: " + origstr);
        while ((startind = origstr.indexOf(JMS_PROPERTY_DELIMETER, startind)) >= 0) {
            outstr.append(origstr.substring(endind, startind));
            endind = origstr.indexOf(JMS_PROPERTY_DELIMETER, startind += JMS_PROPERTY_DELIMETER.length());
            propname = origstr.substring(startind, endind);
            endind += JMS_PROPERTY_DELIMETER.length();
            if (this.dest_pload_type == 4) {
                outstr.append(this.toRulesSyntaxJmsSharded(propname, type, USER_PROP));
            } else {
                outstr.append(this.toRulesSyntax(propname, type));
            }
            startind = endind;
        }
        String appendstr = origstr.substring(endind, origstr.length());
        if (propname != null && propname.equals("JMS_OracleDeliveryMode")) {
            appendstr = appendstr.replaceAll("'PERSISTENT'", "2");
            appendstr = appendstr.replaceAll("'NON_PERSISTENT'", "1");
        }
        outstr.append(appendstr);
        if (add_boolean_compare) {
            outstr.append(") = 1");
        }
        if (outstr.toString().startsWith("enqueue_time") || outstr.toString().startsWith("enq_time")) {
            String selectorExpression = outstr.toString();
            StringBuffer stringBuffer = new StringBuffer();
            StringTokenizer selectorTokens = new StringTokenizer(selectorExpression, " ");
            while (selectorTokens.hasMoreElements()) {
                String individualToken = selectorTokens.nextToken();
                long timeInMillSeconds = 0L;
                if (individualToken.matches(".*\\d.*")) {
                    try {
                        timeInMillSeconds = Long.parseLong(individualToken);
                        individualToken = this.convertEnqueueTimeToTimestamp(timeInMillSeconds);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ParseException("Invalid JMSTimestamp in selector");
                    }
                }
                stringBuffer.append(individualToken + " ");
            }
            expr.setString(stringBuffer.toString().trim());
        } else {
            expr.setString(outstr.toString());
        }
        AQjmsOracleDebug.println("promoteExpression: RETURN expr: " + expr.getString());
    }

    private String convertEnqueueTimeToTimestamp(long enqueueTimeInMilliSeconds) {
        SimpleDateFormat utcDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SS");
        utcDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        String selectorRuleForJMSTimestamp = "to_timestamp_tz('" + utcDateFormat.format(new Date(enqueueTimeInMilliSeconds)) + " UTC', 'YYYY-MM-DD HH24:MI:SS.FF TZR TZD')";
        return selectorRuleForJMSTimestamp;
    }

    public final String SequenceOfStatements() throws ParseException {
        Object rs = new String("");
        String str = null;
        block3: while (true) {
            str = this.SubscriberRule();
            rs = (String)rs + str + "\n";
            this.jj_consume_token(32);
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 11: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 27: 
                case 30: 
                case 31: 
                case 33: 
                case 36: 
                case 37: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[0] = this.jj_gen;
        return rs;
    }

    public final String SubscriberRule() throws ParseException {
        AQjmsParserExpr expr = null;
        expr = this.SQLExpression();
        this.jj_consume_token(32);
        AQjmsOracleDebug.println("SubscriberRule: \n" + expr.getString());
        return expr.getString();
    }

    public final AQjmsParserExpr SQLExpression() throws ParseException {
        Object rs = new String("");
        AQjmsParserExpr thisexpr = new AQjmsParserExpr();
        AQjmsParserExpr expr1 = null;
        AQjmsParserExpr expr2 = null;
        expr1 = this.SQLAndExpression();
        rs = (String)rs + expr1.getString();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 13: {
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(13);
            rs = (String)rs + " OR ";
            thisexpr.setTypeBoolean();
            expr2 = this.SQLAndExpression();
            rs = (String)rs + expr2.getString();
        }
        thisexpr.setType(expr1.getType());
        thisexpr.setString((String)rs);
        AQjmsOracleDebug.println("SQLExpression: " + (String)rs + " Type: " + thisexpr.getType());
        return thisexpr;
    }

    public final AQjmsParserExpr SQLAndExpression() throws ParseException {
        Object rs = new String("");
        AQjmsParserExpr thisexpr = new AQjmsParserExpr();
        AQjmsParserExpr expr1 = null;
        AQjmsParserExpr expr2 = null;
        expr1 = this.SQLUnaryLogicalExpression();
        rs = (String)rs + expr1.getString();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 6: {
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(6);
            rs = (String)rs + " AND ";
            thisexpr.setTypeBoolean();
            expr2 = this.SQLUnaryLogicalExpression();
            rs = (String)rs + expr2.getString();
        }
        thisexpr.setType(expr1.getType());
        thisexpr.setString((String)rs);
        return thisexpr;
    }

    public final AQjmsParserExpr SQLUnaryLogicalExpression() throws ParseException {
        Object rs = new String("");
        AQjmsParserExpr thisexpr = new AQjmsParserExpr();
        AQjmsParserExpr expr = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 11: {
                this.jj_consume_token(11);
                rs = (String)rs + " NOT ";
                thisexpr.setTypeBoolean();
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        expr = this.SQLRelationalExpression();
        rs = (String)rs + expr.getString();
        thisexpr.setString((String)rs);
        thisexpr.setType(expr.getType());
        return thisexpr;
    }

    public final AQjmsParserExpr SQLRelationalExpression() throws ParseException {
        boolean gotMsgid = false;
        Object rs = new String("");
        AQjmsParserExpr thisexpr = new AQjmsParserExpr();
        AQjmsParserExpr expr1 = null;
        AQjmsParserExpr expr2 = null;
        AQjmsParserExpr exprop = null;
        if (this.jj_2_1(16)) {
            this.jj_consume_token(33);
            rs = (String)rs + "(";
            expr1 = this.SQLExpressionList(false);
            rs = (String)rs + expr1.getString();
            thisexpr.setType(expr1.getType());
            this.jj_consume_token(35);
            rs = (String)rs + ")";
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 27: 
                case 30: 
                case 31: 
                case 33: 
                case 36: 
                case 37: {
                    expr1 = this.SQLSimpleExpression();
                    rs = (String)rs + expr1.getString();
                    if ("tab.msgid".equals(expr1.getString())) {
                        gotMsgid = true;
                    }
                    thisexpr.setType(expr1.getType());
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        block3 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 48: {
                        exprop = this.Relop();
                        rs = (String)rs + exprop.getString();
                        expr2 = this.SQLSimpleExpression();
                        if (gotMsgid) {
                            expr2.setString(this.trimIDPrefix(expr2.getString()));
                        }
                        rs = (String)rs + expr2.getString();
                        if (this.doStrongTypeChecking && (thisexpr.isString() || thisexpr.isBoolean() || expr2.isString() || expr2.isBoolean()) && !exprop.isEqualOperator() && !exprop.isNotEqualOperator()) {
                            throw new ParseException("String and Boolean can only use \"=\" and \"<>\" operators");
                        }
                        if (!this.doStrongTypeChecking || thisexpr.isVariable() || expr2.isVariable() || thisexpr.getType() == expr2.getType()) break block3;
                        throw new ParseException("Operand type mismatch: " + thisexpr.getType() + " and " + expr2.getType());
                    }
                    default: {
                        this.jj_la1[5] = this.jj_gen;
                        if (this.jj_2_2(2)) {
                            expr2 = this.SQLInClause(gotMsgid);
                            rs = (String)rs + expr2.getString();
                            break block3;
                        }
                        if (this.jj_2_3(2)) {
                            expr2 = this.SQLBetweenClause(gotMsgid);
                            rs = (String)rs + expr2.getString();
                            break block3;
                        }
                        if (this.jj_2_4(2)) {
                            expr2 = this.SQLLikeClause(gotMsgid);
                            rs = (String)rs + expr2.getString();
                            break block3;
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 9: {
                                exprop = new AQjmsParserExpr();
                                String str = this.IsNullClause(exprop);
                                rs = (String)rs + str;
                                expr2 = new AQjmsParserExpr();
                                expr2.setTypeVariable();
                                break block3;
                            }
                        }
                        this.jj_la1[6] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
            }
        }
        int relexprtype = 0;
        relexprtype = expr2 == null ? 4 : (!expr2.isVariable() ? expr2.getType() : thisexpr.getType());
        AQjmsOracleDebug.println("RELEXPR: Gleaned type is " + relexprtype + " for: " + (String)rs);
        if (this.dest_pload_type == 4 && expr1.isVariable() && expr2 != null && expr2.isVariable()) {
            this.convertComparisonExpression(thisexpr, expr1, expr2, exprop, (String)rs);
        } else {
            thisexpr.setString((String)rs);
            this.promoteExpression(thisexpr, relexprtype, expr2 == null && (thisexpr.isVariable() || thisexpr.isBooleanLiteral()));
        }
        thisexpr.setTypeBoolean();
        return thisexpr;
    }

    private void convertComparisonExpression(AQjmsParserExpr thisexpr, AQjmsParserExpr expr1, AQjmsParserExpr expr2, AQjmsParserExpr exprop, String rs) throws ParseException {
        String rs3;
        String rs2;
        String rs1;
        if (exprop.isEqualOperator() || exprop.isNotEqualOperator() || exprop.isTypeIsNotNullClauseOperator()) {
            thisexpr.setString((String)rs);
            this.promoteExpression(thisexpr, 2, false);
            rs1 = thisexpr.getString();
            thisexpr.setString((String)rs);
            this.promoteExpression(thisexpr, 1, false);
            rs2 = thisexpr.getString();
            thisexpr.setString((String)rs);
            this.promoteExpression(thisexpr, 4, false);
            rs3 = thisexpr.getString();
            rs = "(" + rs1 + " OR " + rs2 + " OR " + rs3 + ")";
            thisexpr.setString((String)rs);
        }
        if (exprop.isTypeIsNullClauseOperator()) {
            thisexpr.setString((String)rs);
            this.promoteExpression(thisexpr, 2, false);
            rs1 = thisexpr.getString();
            thisexpr.setString((String)rs);
            this.promoteExpression(thisexpr, 1, false);
            rs2 = thisexpr.getString();
            thisexpr.setString((String)rs);
            this.promoteExpression(thisexpr, 4, false);
            rs3 = thisexpr.getString();
            rs = "(" + rs1 + " AND " + rs2 + " AND " + rs3 + ")";
            thisexpr.setString((String)rs);
        } else {
            thisexpr.setString((String)rs);
            this.promoteExpression(thisexpr, 1, false);
        }
    }

    public final AQjmsParserExpr SQLExpressionList(boolean gotMsgid) throws ParseException {
        Object rs = new String("");
        AQjmsParserExpr thisexpr = new AQjmsParserExpr();
        AQjmsParserExpr expr = null;
        expr = this.SQLSimpleExpression();
        if (gotMsgid) {
            expr.setString(this.trimIDPrefix(expr.getString()));
        }
        rs = (String)rs + expr.getString();
        thisexpr.setType(expr.getType());
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 34: {
                    break;
                }
                default: {
                    this.jj_la1[8] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(34);
            rs = (String)rs + ", ";
            expr = this.SQLSimpleExpression();
            if (gotMsgid) {
                expr.setString(this.trimIDPrefix(expr.getString()));
            }
            rs = (String)rs + expr.getString();
            thisexpr.setType(expr.getType());
        }
        AQjmsOracleDebug.println("SQLExpressionList: " + (String)rs + " Type: " + thisexpr.getType());
        thisexpr.setString((String)rs);
        return thisexpr;
    }

    public final AQjmsParserExpr SQLInClause(boolean gotMsgid) throws ParseException {
        Object rs = new String("");
        AQjmsParserExpr expr = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 11: {
                this.jj_consume_token(11);
                rs = (String)rs + " NOT ";
                break;
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
            }
        }
        this.jj_consume_token(8);
        rs = (String)rs + " IN ";
        this.jj_consume_token(33);
        rs = (String)rs + "(";
        expr = this.SQLExpressionList(gotMsgid);
        rs = (String)rs + expr.getString();
        this.jj_consume_token(35);
        rs = (String)rs + ")";
        expr.setString((String)rs);
        if (this.doStrongTypeChecking && !expr.isString() && !expr.isVariable()) {
            throw new ParseException("[NOT] IN operator can only take string operands, not optype " + expr.getType());
        }
        this.promoteToString(expr);
        return expr;
    }

    public final AQjmsParserExpr SQLBetweenClause(boolean gotMsgid) throws ParseException {
        Object rs = new String("");
        AQjmsParserExpr thisexpr = new AQjmsParserExpr();
        AQjmsParserExpr expr = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 11: {
                this.jj_consume_token(11);
                rs = (String)rs + " NOT ";
                break;
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
            }
        }
        this.jj_consume_token(7);
        rs = (String)rs + " BETWEEN ";
        expr = this.SQLSimpleExpression();
        if (this.doStrongTypeChecking && !expr.isVariable() && !expr.isNumeric()) {
            throw new ParseException("Between clause requires numeric arguments");
        }
        if (gotMsgid) {
            expr.setString(this.trimIDPrefix(expr.getString()));
        }
        thisexpr.setType(expr.getType());
        rs = (String)rs + expr.getString();
        this.jj_consume_token(6);
        rs = (String)rs + " AND ";
        expr = this.SQLSimpleExpression();
        if (this.doStrongTypeChecking && !expr.isVariable() && !expr.isNumeric()) {
            throw new ParseException("Between clause requires numeric arguments");
        }
        if (gotMsgid) {
            expr.setString(this.trimIDPrefix(expr.getString()));
        }
        rs = (String)rs + expr.getString();
        thisexpr.setString((String)rs);
        this.promoteToNumeric(thisexpr);
        return thisexpr;
    }

    public final AQjmsParserExpr SQLLikeClause(boolean gotMsgid) throws ParseException {
        Object rs = new String("");
        AQjmsParserExpr thisexpr = new AQjmsParserExpr();
        AQjmsParserExpr expr = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 11: {
                this.jj_consume_token(11);
                rs = (String)rs + " NOT ";
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
            }
        }
        this.jj_consume_token(10);
        rs = (String)rs + " LIKE ";
        expr = this.SQLSimpleExpression();
        if (gotMsgid) {
            expr.setString(this.trimIDPrefix(expr.getString()));
        }
        rs = (String)rs + expr.getString();
        thisexpr.setType(expr.getType());
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 14: {
                this.jj_consume_token(14);
                rs = (String)rs + " ESCAPE ";
                expr = this.SQLSimpleExpression();
                rs = (String)rs + expr.getString();
                break;
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
            }
        }
        thisexpr.setString((String)rs);
        if (this.doStrongTypeChecking && !thisexpr.isString() && !thisexpr.isVariable()) {
            throw new ParseException("[NOT] LIKE operator can only take string operands, not optype " + thisexpr.getType());
        }
        this.promoteToString(thisexpr);
        return thisexpr;
    }

    public final String IsNullClause(AQjmsParserExpr op) throws ParseException {
        Object rs = new String("");
        this.jj_consume_token(9);
        rs = (String)rs + " IS ";
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 11: {
                this.jj_consume_token(11);
                rs = (String)rs + " NOT ";
                op.setTypeIsNotNullClauseOperator();
                break;
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
                op.setTypeIsNullClauseOperator();
            }
        }
        this.jj_consume_token(12);
        rs = (String)rs + " NULL ";
        return rs;
    }

    public final AQjmsParserExpr SQLSimpleExpression() throws ParseException {
        Object rs = new String("");
        AQjmsParserExpr thisexpr = new AQjmsParserExpr();
        AQjmsParserExpr expr = null;
        expr = this.SQLMultiplicativeExpression();
        rs = (String)rs + expr.getString();
        thisexpr.setType(expr.getType());
        while (this.jj_2_5(2)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 36: {
                    this.jj_consume_token(36);
                    rs = (String)rs + " + ";
                    break;
                }
                case 37: {
                    this.jj_consume_token(37);
                    rs = (String)rs + " - ";
                    break;
                }
                default: {
                    this.jj_la1[14] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            expr = this.SQLMultiplicativeExpression();
            rs = (String)rs + expr.getString();
            thisexpr.setType(expr.getType());
        }
        AQjmsOracleDebug.println("SQLSimpleExpression: " + (String)rs + " Type: " + thisexpr.getType());
        thisexpr.setString((String)rs);
        return thisexpr;
    }

    public final AQjmsParserExpr SQLMultiplicativeExpression() throws ParseException {
        Object rs = new String("");
        AQjmsParserExpr thisexpr = new AQjmsParserExpr();
        AQjmsParserExpr expr = null;
        expr = this.SQLExponentExpression();
        rs = (String)rs + expr.getString();
        thisexpr.setType(expr.getType());
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 38: 
                case 39: {
                    break;
                }
                default: {
                    this.jj_la1[15] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 38: {
                    this.jj_consume_token(38);
                    rs = (String)rs + "*";
                    break;
                }
                case 39: {
                    this.jj_consume_token(39);
                    rs = (String)rs + "/";
                    break;
                }
                default: {
                    this.jj_la1[16] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            expr = this.SQLExponentExpression();
            rs = (String)rs + expr.getString();
            thisexpr.setType(expr.getType());
        }
        AQjmsOracleDebug.println("SQLMultiplicativeExpression: " + (String)rs + " Type: " + thisexpr.getType());
        thisexpr.setString((String)rs);
        return thisexpr;
    }

    public final AQjmsParserExpr SQLExponentExpression() throws ParseException {
        Object rs = new String("");
        AQjmsParserExpr thisexpr = new AQjmsParserExpr();
        AQjmsParserExpr expr = null;
        expr = this.SQLUnaryExpression();
        rs = (String)rs + expr.getString();
        thisexpr.setType(expr.getType());
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 40: {
                    break;
                }
                default: {
                    this.jj_la1[17] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(40);
            rs = (String)rs + "**";
            expr = this.SQLUnaryExpression();
            rs = (String)rs + expr.getString();
            thisexpr.setType(expr.getType());
        }
        thisexpr.setString((String)rs);
        return thisexpr;
    }

    public final AQjmsParserExpr SQLUnaryExpression() throws ParseException {
        Object rs = new String("");
        boolean unaryOperand = false;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 36: 
            case 37: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 36: {
                        this.jj_consume_token(36);
                        rs = (String)rs + "+";
                        unaryOperand = true;
                        break block0;
                    }
                    case 37: {
                        this.jj_consume_token(37);
                        rs = (String)rs + "-";
                        unaryOperand = true;
                        break block0;
                    }
                }
                this.jj_la1[18] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[19] = this.jj_gen;
            }
        }
        AQjmsParserExpr expr = this.SQLPrimaryExpression();
        if (unaryOperand && this.doStrongTypeChecking && !expr.isNumeric() && !expr.isVariable()) {
            throw new ParseException("Operators \"+\" and \"-\" can only be used with numeric operands");
        }
        rs = (String)rs + expr.getString();
        expr.setString((String)rs);
        if (unaryOperand) {
            this.promoteToNumeric(expr);
        }
        return expr;
    }

    public final AQjmsParserExpr SQLPrimaryExpression() throws ParseException {
        Object rs = new String("");
        String str = null;
        Token tok = null;
        AQjmsParserExpr thisexpr = new AQjmsParserExpr();
        AQjmsParserExpr expr = null;
        if (this.jj_2_6(16)) {
            str = this.FunctionCall();
            rs = (String)rs + str;
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 27: 
                case 31: {
                    str = this.TableColumn();
                    rs = (String)rs + str;
                    thisexpr.setTypeVariable();
                    break;
                }
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    str = this.NumericLiteral();
                    rs = (String)rs + str;
                    thisexpr.setTypeNumeric();
                    break;
                }
                case 30: {
                    tok = this.jj_consume_token(30);
                    rs = (String)rs + this.checkForEscapeChars(tok.image);
                    thisexpr.setTypeString();
                    break;
                }
                case 15: {
                    tok = this.jj_consume_token(15);
                    rs = (String)rs + " 1 ";
                    thisexpr.setTypeBooleanLiteral();
                    break;
                }
                case 16: {
                    tok = this.jj_consume_token(16);
                    rs = (String)rs + " 0 ";
                    thisexpr.setTypeBooleanLiteral();
                    break;
                }
                case 33: {
                    this.jj_consume_token(33);
                    rs = (String)rs + "(";
                    expr = this.SQLExpression();
                    rs = (String)rs + expr.getString();
                    thisexpr.setType(expr.getType());
                    this.jj_consume_token(35);
                    rs = (String)rs + ")";
                    break;
                }
                default: {
                    this.jj_la1[20] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        AQjmsOracleDebug.println("SQLPrimaryExpression: " + (String)rs + " Type: " + thisexpr.getType());
        thisexpr.setString((String)rs);
        return thisexpr;
    }

    public final String FunctionCall() throws ParseException {
        AQjmsOracleDebug.println("Before evaluating function: ");
        this.is_func_call = true;
        Object rs = new String("");
        String str = null;
        str = this.OracleObjectName();
        rs = (String)rs + str;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 41: {
                this.jj_consume_token(41);
                rs = (String)rs + ".";
                str = this.OracleObjectName();
                rs = (String)rs + str;
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 41: {
                        this.jj_consume_token(41);
                        rs = (String)rs + ".";
                        str = this.OracleObjectName();
                        rs = (String)rs + str;
                        break block0;
                    }
                }
                this.jj_la1[21] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[22] = this.jj_gen;
            }
        }
        this.jj_consume_token(33);
        rs = (String)rs + "(";
        block6 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 27: 
            case 30: 
            case 31: 
            case 33: 
            case 36: 
            case 37: 
            case 38: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 27: 
                    case 30: 
                    case 31: 
                    case 33: 
                    case 36: 
                    case 37: {
                        str = this.SQLArguments();
                        rs = (String)rs + str;
                        break block6;
                    }
                    case 38: {
                        this.jj_consume_token(38);
                        rs = (String)rs + "*";
                        break block6;
                    }
                }
                this.jj_la1[23] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[24] = this.jj_gen;
            }
        }
        this.jj_consume_token(35);
        rs = (String)rs + ")";
        AQjmsOracleDebug.println("Function: " + (String)rs);
        AQjmsOracleDebug.println("After evaluating function: ");
        this.is_func_call = false;
        return rs;
    }

    public final String SQLArguments() throws ParseException {
        Object rs = new String("");
        AQjmsParserExpr expr = null;
        expr = this.SQLExpressionList(false);
        rs = (String)rs + expr.getString();
        AQjmsOracleDebug.println("SQL Arguments: " + (String)rs);
        return rs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final String TableColumn() throws ParseException {
        Object rs = new String("");
        String str = null;
        String new_value = new String("");
        String substr = null;
        str = this.OracleObjectName();
        rs = (String)rs + str;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 41: {
                this.jj_consume_token(41);
                rs = (String)rs + ".";
                str = this.OracleObjectName();
                rs = (String)rs + str;
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 41: {
                        this.jj_consume_token(41);
                        rs = (String)rs + ".";
                        str = this.OracleObjectName();
                        rs = (String)rs + str;
                        break block0;
                    }
                }
                this.jj_la1[25] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[26] = this.jj_gen;
            }
        }
        AQjmsOracleDebug.println("TableColumn: " + (String)rs);
        if (((String)rs).length() >= 13) {
            substr = ((String)rs).substring(0, 13);
            AQjmsOracleDebug.println("TableColumn-substr: " + substr);
        }
        if (substr != null && substr.equalsIgnoreCase("tab.user_data")) {
            if (this.dest_pload_type != 3) throw new ParseException("invalid object name: " + (String)rs);
            return rs;
        }
        if (((String)rs).indexOf(".") != -1) throw new ParseException("invalid object name: " + (String)rs);
        return this.mapJMSStringToColumn((String)rs, 10);
    }

    public final String OracleObjectName() throws ParseException {
        Object rs = new String("");
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 27: {
                Token tk = this.jj_consume_token(27);
                rs = (String)rs + tk.image;
                break;
            }
            case 31: {
                Token tk = this.jj_consume_token(31);
                rs = (String)rs + tk.image;
                break;
            }
            default: {
                this.jj_la1[27] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        AQjmsOracleDebug.println("OracleObjectName: " + (String)rs);
        return rs;
    }

    public final AQjmsParserExpr Relop() throws ParseException {
        AQjmsParserExpr expr = new AQjmsParserExpr();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 42: {
                this.jj_consume_token(42);
                expr.setString(" = ");
                expr.setTypeEqualOperator();
                break;
            }
            case 43: {
                this.jj_consume_token(43);
                expr.setString(" <> ");
                expr.setTypeNotEqualOperator();
                break;
            }
            case 44: {
                this.jj_consume_token(44);
                expr.setString(" != ");
                expr.setTypeNotEqualOperator();
                break;
            }
            case 45: {
                this.jj_consume_token(45);
                expr.setString(" > ");
                expr.setTypeOperator();
                break;
            }
            case 46: {
                this.jj_consume_token(46);
                expr.setString(" >= ");
                expr.setTypeOperator();
                break;
            }
            case 47: {
                this.jj_consume_token(47);
                expr.setString(" < ");
                expr.setTypeOperator();
                break;
            }
            case 48: {
                this.jj_consume_token(48);
                expr.setString(" <= ");
                expr.setTypeOperator();
                break;
            }
            default: {
                this.jj_la1[28] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return expr;
    }

    public final String NumericLiteral() throws ParseException {
        Object rs = new String("");
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 19: {
                Token tk = this.jj_consume_token(19);
                rs = (String)rs + tk.image.substring(0, tk.image.length() - 1);
                break;
            }
            case 17: {
                Token tk = this.jj_consume_token(17);
                rs = (String)rs + Long.parseLong(tk.image.substring(2, tk.image.length()), 16);
                break;
            }
            case 18: {
                Token tk = this.jj_consume_token(18);
                rs = (String)rs + Long.parseLong(tk.image, 8);
                break;
            }
            case 20: {
                Token tk = this.jj_consume_token(20);
                rs = (String)rs + tk.image;
                break;
            }
            default: {
                this.jj_la1[29] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    private boolean jj_3R_SQLMultiplicativeExpression_1138_7_23() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_SQLMultiplicativeExpression_1138_8_31()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_SQLMultiplicativeExpression_1139_12_32()) {
                return true;
            }
        }
        return this.jj_3R_SQLExponentExpression_1163_3_19();
    }

    private boolean jj_3R_SQLAndExpression_751_7_59() {
        if (this.jj_scan_token(6)) {
            return true;
        }
        return this.jj_3R_SQLUnaryLogicalExpression_771_5_58();
    }

    private boolean jj_3R_SQLAndExpression_750_5_55() {
        Token xsp;
        if (this.jj_3R_SQLUnaryLogicalExpression_771_5_58()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_SQLAndExpression_751_7_59());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_SQLMultiplicativeExpression_1133_3_14() {
        Token xsp;
        if (this.jj_3R_SQLExponentExpression_1163_3_19()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_SQLMultiplicativeExpression_1138_7_23());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_SQLSimpleExpression_1108_22_13() {
        return this.jj_scan_token(37);
    }

    private boolean jj_3R_SQLSimpleExpression_1107_20_12() {
        return this.jj_scan_token(36);
    }

    private boolean jj_3R_TableColumn_1305_6_57() {
        if (this.jj_scan_token(41)) {
            return true;
        }
        return this.jj_3R_OracleObjectName_1364_3_20();
    }

    private boolean jj_3R_TableColumn_1304_6_54() {
        if (this.jj_scan_token(41)) {
            return true;
        }
        if (this.jj_3R_OracleObjectName_1364_3_20()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_TableColumn_1305_6_57()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_SQLExpression_729_7_56() {
        if (this.jj_scan_token(13)) {
            return true;
        }
        return this.jj_3R_SQLAndExpression_750_5_55();
    }

    private boolean jj_3R_SQLExpression_728_5_49() {
        Token xsp;
        if (this.jj_3R_SQLAndExpression_750_5_55()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_SQLExpression_729_7_56());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_TableColumn_1303_3_46() {
        if (this.jj_3R_OracleObjectName_1364_3_20()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_TableColumn_1304_6_54()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_5() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_SQLSimpleExpression_1107_20_12()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_SQLSimpleExpression_1108_22_13()) {
                return true;
            }
        }
        return this.jj_3R_SQLMultiplicativeExpression_1133_3_14();
    }

    private boolean jj_3R_SQLSimpleExpression_1102_3_8() {
        Token xsp;
        if (this.jj_3R_SQLMultiplicativeExpression_1133_3_14()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_5());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_SQLExpressionList_907_6_48() {
        if (this.jj_scan_token(34)) {
            return true;
        }
        return this.jj_3R_SQLSimpleExpression_1102_3_8();
    }

    private boolean jj_3R_SQLArguments_1285_5_35() {
        return this.jj_3R_SQLExpressionList_900_3_45();
    }

    private boolean jj_3R_SQLExpressionList_900_3_45() {
        Token xsp;
        if (this.jj_3R_SQLSimpleExpression_1102_3_8()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_SQLExpressionList_907_6_48());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_IsNullClause_1082_5_77() {
        return this.jj_scan_token(11);
    }

    private boolean jj_3R_IsNullClause_1081_3_68() {
        if (this.jj_scan_token(9)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_IsNullClause_1082_5_77()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(12);
    }

    private boolean jj_3R_FunctionCall_1263_10_29() {
        return this.jj_scan_token(38);
    }

    private boolean jj_3R_FunctionCall_1262_9_28() {
        return this.jj_3R_SQLArguments_1285_5_35();
    }

    private boolean jj_3R_FunctionCall_1262_8_22() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_FunctionCall_1262_9_28()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_FunctionCall_1263_10_29()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_FunctionCall_1260_8_27() {
        if (this.jj_scan_token(41)) {
            return true;
        }
        return this.jj_3R_OracleObjectName_1364_3_20();
    }

    private boolean jj_3R_FunctionCall_1259_8_21() {
        if (this.jj_scan_token(41)) {
            return true;
        }
        if (this.jj_3R_OracleObjectName_1364_3_20()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_FunctionCall_1260_8_27()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_FunctionCall_1258_3_15() {
        if (this.jj_3R_OracleObjectName_1364_3_20()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_FunctionCall_1259_8_21()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(33)) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_FunctionCall_1262_8_22()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(35);
    }

    private boolean jj_3R_SQLLikeClause_1055_8_76() {
        if (this.jj_scan_token(14)) {
            return true;
        }
        return this.jj_3R_SQLSimpleExpression_1102_3_8();
    }

    private boolean jj_3R_SQLLikeClause_1047_8_18() {
        return this.jj_scan_token(11);
    }

    private boolean jj_3R_SQLRelationalExpression_854_8_66() {
        return this.jj_3R_IsNullClause_1081_3_68();
    }

    private boolean jj_3R_SQLPrimaryExpression_1236_8_44() {
        if (this.jj_scan_token(33)) {
            return true;
        }
        if (this.jj_3R_SQLExpression_728_5_49()) {
            return true;
        }
        return this.jj_scan_token(35);
    }

    private boolean jj_3R_SQLLikeClause_1047_5_11() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_SQLLikeClause_1047_8_18()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(10)) {
            return true;
        }
        if (this.jj_3R_SQLSimpleExpression_1102_3_8()) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_SQLLikeClause_1055_8_76()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_4() {
        return this.jj_3R_SQLLikeClause_1047_5_11();
    }

    private boolean jj_3R_SQLPrimaryExpression_1231_7_43() {
        return this.jj_scan_token(16);
    }

    private boolean jj_3_3() {
        return this.jj_3R_SQLBetweenClause_1006_5_10();
    }

    private boolean jj_3R_NumericLiteral_1419_7_53() {
        return this.jj_scan_token(20);
    }

    private boolean jj_3_6() {
        return this.jj_3R_FunctionCall_1258_3_15();
    }

    private boolean jj_3R_SQLPrimaryExpression_1226_7_42() {
        return this.jj_scan_token(15);
    }

    private boolean jj_3_2() {
        return this.jj_3R_SQLInClause_973_5_9();
    }

    private boolean jj_3R_SQLPrimaryExpression_1224_7_41() {
        return this.jj_scan_token(30);
    }

    private boolean jj_3R_NumericLiteral_1415_7_52() {
        return this.jj_scan_token(18);
    }

    private boolean jj_3R_NumericLiteral_1411_7_51() {
        return this.jj_scan_token(17);
    }

    private boolean jj_3R_SQLPrimaryExpression_1219_7_40() {
        return this.jj_3R_NumericLiteral_1406_3_47();
    }

    private boolean jj_3R_SQLPrimaryExpression_1218_7_39() {
        return this.jj_3R_TableColumn_1303_3_46();
    }

    private boolean jj_3R_SQLPrimaryExpression_1216_5_38() {
        return this.jj_3R_FunctionCall_1258_3_15();
    }

    private boolean jj_3R_NumericLiteral_1406_5_50() {
        return this.jj_scan_token(19);
    }

    private boolean jj_3R_SQLPrimaryExpression_1215_3_34() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_SQLPrimaryExpression_1216_5_38()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_SQLPrimaryExpression_1218_7_39()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_SQLPrimaryExpression_1219_7_40()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_SQLPrimaryExpression_1224_7_41()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_SQLPrimaryExpression_1226_7_42()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_SQLPrimaryExpression_1231_7_43()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_SQLPrimaryExpression_1236_8_44()) {
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_NumericLiteral_1406_3_47() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_NumericLiteral_1406_5_50()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_NumericLiteral_1411_7_51()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_NumericLiteral_1415_7_52()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_NumericLiteral_1419_7_53()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_Relop_1389_6_75() {
        return this.jj_scan_token(48);
    }

    private boolean jj_3R_SQLRelationalExpression_814_8_64() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_SQLRelationalExpression_814_8_65()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_2()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_3()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_4()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_SQLRelationalExpression_854_8_66()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_SQLRelationalExpression_814_8_65() {
        if (this.jj_3R_Relop_1383_3_67()) {
            return true;
        }
        return this.jj_3R_SQLSimpleExpression_1102_3_8();
    }

    private boolean jj_3R_SQLBetweenClause_1006_7_17() {
        return this.jj_scan_token(11);
    }

    private boolean jj_3R_Relop_1388_6_74() {
        return this.jj_scan_token(47);
    }

    private boolean jj_3R_Relop_1387_6_73() {
        return this.jj_scan_token(46);
    }

    private boolean jj_3R_SQLBetweenClause_1006_5_10() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_SQLBetweenClause_1006_7_17()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(7)) {
            return true;
        }
        if (this.jj_3R_SQLSimpleExpression_1102_3_8()) {
            return true;
        }
        if (this.jj_scan_token(6)) {
            return true;
        }
        return this.jj_3R_SQLSimpleExpression_1102_3_8();
    }

    private boolean jj_3R_Relop_1386_6_72() {
        return this.jj_scan_token(45);
    }

    private boolean jj_3R_Relop_1385_6_71() {
        return this.jj_scan_token(44);
    }

    private boolean jj_3R_Relop_1384_6_70() {
        return this.jj_scan_token(43);
    }

    private boolean jj_3_1() {
        if (this.jj_scan_token(33)) {
            return true;
        }
        if (this.jj_3R_SQLSimpleExpression_1102_3_8()) {
            return true;
        }
        return this.jj_scan_token(34);
    }

    private boolean jj_3R_Relop_1383_6_69() {
        return this.jj_scan_token(42);
    }

    private boolean jj_3R_Relop_1383_3_67() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_Relop_1383_6_69()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_Relop_1384_6_70()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_Relop_1385_6_71()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_Relop_1386_6_72()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_Relop_1387_6_73()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_Relop_1388_6_74()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_Relop_1389_6_75()) {
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_SQLUnaryExpression_1185_9_37() {
        return this.jj_scan_token(37);
    }

    private boolean jj_3R_SQLUnaryExpression_1184_9_36() {
        return this.jj_scan_token(36);
    }

    private boolean jj_3R_SQLUnaryExpression_1184_9_33() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_SQLUnaryExpression_1184_9_36()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_SQLUnaryExpression_1185_9_37()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_SQLRelationalExpression_804_6_63() {
        return this.jj_3R_SQLSimpleExpression_1102_3_8();
    }

    private boolean jj_3R_SQLUnaryExpression_1184_5_24() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_SQLUnaryExpression_1184_9_33()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_SQLPrimaryExpression_1215_3_34();
    }

    private boolean jj_3R_SQLRelationalExpression_795_7_62() {
        if (this.jj_scan_token(33)) {
            return true;
        }
        if (this.jj_3R_SQLExpressionList_900_3_45()) {
            return true;
        }
        return this.jj_scan_token(35);
    }

    private boolean jj_3R_SQLRelationalExpression_795_4_61() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_SQLRelationalExpression_795_7_62()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_SQLRelationalExpression_804_6_63()) {
                return true;
            }
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_SQLRelationalExpression_814_8_64()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_OracleObjectName_1365_7_26() {
        return this.jj_scan_token(31);
    }

    private boolean jj_3R_OracleObjectName_1364_7_25() {
        return this.jj_scan_token(27);
    }

    private boolean jj_3R_OracleObjectName_1364_3_20() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_OracleObjectName_1364_7_25()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_OracleObjectName_1365_7_26()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_SQLInClause_973_8_16() {
        return this.jj_scan_token(11);
    }

    private boolean jj_3R_SQLExponentExpression_1164_7_30() {
        if (this.jj_scan_token(40)) {
            return true;
        }
        return this.jj_3R_SQLUnaryExpression_1184_5_24();
    }

    private boolean jj_3R_SQLInClause_973_5_9() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_SQLInClause_973_8_16()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(8)) {
            return true;
        }
        if (this.jj_scan_token(33)) {
            return true;
        }
        if (this.jj_3R_SQLExpressionList_900_3_45()) {
            return true;
        }
        return this.jj_scan_token(35);
    }

    private boolean jj_3R_SQLExponentExpression_1163_3_19() {
        Token xsp;
        if (this.jj_3R_SQLUnaryExpression_1184_5_24()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_SQLExponentExpression_1164_7_30());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_SQLUnaryLogicalExpression_771_7_60() {
        return this.jj_scan_token(11);
    }

    private boolean jj_3R_SQLUnaryLogicalExpression_771_5_58() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_SQLUnaryLogicalExpression_771_7_60()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_SQLRelationalExpression_795_4_61();
    }

    private boolean jj_3R_SQLMultiplicativeExpression_1139_12_32() {
        return this.jj_scan_token(39);
    }

    private boolean jj_3R_SQLMultiplicativeExpression_1138_8_31() {
        return this.jj_scan_token(38);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{-937457664, 8192, 64, 2048, -937459712, 0, 512, 3968, 0, 2048, 2048, 2048, 16384, 2048, 0, 0, 0, 0, 0, 0, -937459712, 0, 0, -937459712, -937459712, 0, 0, -2013265920, 0, 0x1E0000};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{50, 0, 0, 0, 50, 130048, 0, 130048, 4, 0, 0, 0, 0, 0, 48, 192, 192, 256, 48, 48, 2, 512, 512, 114, 114, 512, 512, 0, 130048, 0};
    }

    public AQjmsParser(InputStream stream) {
        this(stream, null);
    }

    public AQjmsParser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new JavaCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new AQjmsParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 30; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 30; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public AQjmsParser(Reader stream) {
        int i;
        this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        this.token_source = new AQjmsParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 30; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        if (this.jj_input_stream == null) {
            this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        } else {
            this.jj_input_stream.ReInit(stream, 1, 1);
        }
        if (this.token_source == null) {
            this.token_source = new AQjmsParserTokenManager(this.jj_input_stream);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 30; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public AQjmsParser(AQjmsParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 30; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(AQjmsParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 30; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                boolean isMatched = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    isMatched = false;
                    break;
                }
                if (!isMatched) continue;
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[49];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 30; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 49; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final boolean trace_enabled() {
        return this.trace_enabled;
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 6; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        AQjmsParser.jj_la1_init_0();
        AQjmsParser.jj_la1_init_1();
        jj_ls = new LookaheadSuccess();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

