/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import javax.jms.JMSException;
import oracle.jms.AQjmsError;
import oracle.sql.Datum;

class AQjmsPropDatum {
    private float floatValue;
    private double doubleValue;
    private Datum d_value;
    private String s_value;
    private int type;

    AQjmsPropDatum(float v) throws JMSException {
        this.type = 25;
        this.floatValue = v;
    }

    AQjmsPropDatum(double v) throws JMSException {
        this.type = 26;
        this.doubleValue = v;
    }

    AQjmsPropDatum(int type, Datum value) throws JMSException {
        if (type != 27) {
            this.type = type;
        } else {
            AQjmsError.throwEx(119, "type cannot be string");
        }
        this.d_value = value;
        this.s_value = null;
    }

    AQjmsPropDatum(int type, String value) throws JMSException {
        if (type == 27) {
            this.type = type;
        } else {
            AQjmsError.throwEx(119, "type must be STRING");
        }
        this.d_value = null;
        this.s_value = value;
    }

    Object getValue() {
        switch (this.type) {
            case 27: {
                return this.s_value;
            }
            case 25: {
                return new Float(this.floatValue);
            }
            case 26: {
                return new Double(this.doubleValue);
            }
        }
        return this.d_value;
    }

    Datum getDatumValue() {
        return this.d_value;
    }

    String getStringValue() {
        return this.s_value;
    }

    int getType() {
        return this.type;
    }
}

