/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.Topic;
import oracle.jms.AQjmsConsumer;
import oracle.jms.AQjmsDestination;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsMessage;
import oracle.jms.AQjmsObject;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsSelector;
import oracle.jms.AQjmsSession;
import oracle.jms.TopicBrowser;
import oracle.jms.TopicReceiver;

public class AQjmsTopicBrowser
extends AQjmsObject
implements TopicBrowser,
Enumeration {
    TopicReceiver receiver = null;
    byte[] next_msg_id = null;
    int dequeue_mode = 0;
    int browse_counter = 0;
    boolean sel_msgid_flag = false;
    AQjmsSession jms_sess = null;
    AQjmsSelector b_selector = null;
    AQjmsDestination jms_dest = null;
    AQjmsMessage msg = null;
    AQjmsMessage new_msg = null;
    Hashtable msgid_seen = null;

    AQjmsTopicBrowser(Session session, Destination destination, int dest_type, int deq_mode, String consumer_name, AQjmsSelector selector, Object payload_factory) throws JMSException {
        super("TopicBrowser", (AQjmsSession)session);
        this.jms_sess = (AQjmsSession)session;
        this.dequeue_mode = deq_mode;
        this.jms_dest = (AQjmsDestination)destination;
        this.b_selector = selector;
        this.msgid_seen = new Hashtable();
        this.receiver = new AQjmsConsumer(this.jms_sess, destination, dest_type, deq_mode, consumer_name, payload_factory, selector, null);
        ((AQjmsSession)session).attach(this);
    }

    @Override
    public void close() throws JMSException {
        super.close();
    }

    @Override
    public void localClose() {
        try {
            AQjmsOracleDebug.trace(5, "AQjmsTopicBrowser.close", "closing receiver");
            this.receiver.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Topic getTopic() throws JMSException {
        if (this.jms_dest != null) {
            return this.jms_dest;
        }
        AQjmsError.throwEx(166);
        return null;
    }

    @Override
    public Enumeration getEnumeration() {
        return this;
    }

    @Override
    public String getMessageSelector() throws JMSException {
        return this.receiver.getMessageSelector();
    }

    public Object nextElement() throws NoSuchElementException {
        AQjmsOracleDebug.trace(4, "AQjmsTopicBrowser.nextElement", "entry");
        try {
            if (this.msg != null) {
                this.new_msg = this.msg;
                this.msg = null;
            } else {
                if (this.sel_msgid_flag) {
                    AQjmsOracleDebug.trace(4, "AQjmsTopicBrowser.nextElement", "no such element exception - deq by msgid");
                    throw new NoSuchElementException();
                }
                this.new_msg = (AQjmsMessage)this.receiver.receiveNoWait();
                if (this.new_msg == null) {
                    AQjmsOracleDebug.trace(3, "AQjmsTopicBrowser.nextElement", "no such element exception");
                    throw new NoSuchElementException();
                }
            }
            AQjmsOracleDebug.trace(4, "AQjmsTopicBrowser.nextElement", "exit");
            if (this.b_selector != null && this.b_selector.getSelectorType() == 30) {
                this.sel_msgid_flag = true;
            }
        }
        catch (JMSException aq_ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsTopicBrowser.nextElement", aq_ex);
            throw new NoSuchElementException();
        }
        try {
            String id = this.new_msg.getJMSMessageID();
            this.msgid_seen.put(id, id);
        }
        catch (JMSException aq_ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsTopicBrowser.nextElement", aq_ex);
        }
        return this.new_msg;
    }

    @Override
    public boolean hasMoreElements() {
        if (this.sel_msgid_flag) {
            AQjmsOracleDebug.trace(4, "AQjmsTopicBrowser.hasMoreElements", "null message returned from receive-deq by msgid");
            return false;
        }
        if (this.msg != null) {
            AQjmsOracleDebug.trace(5, "AQjmsTopicBrowser.hasMoreElements", "message already exists");
            return true;
        }
        try {
            this.msg = (AQjmsMessage)this.receiver.receiveNoWait();
            if (this.msg == null) {
                AQjmsOracleDebug.trace(4, "AQjmsTopicBrowser.hasMoreElements", "null message returned from receive");
                return false;
            }
        }
        catch (JMSException ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsTopicBrowser.hasMoreElements - no message", ex);
            return false;
        }
        AQjmsOracleDebug.trace(4, "AQjmsTopicBrowser.hasMoreElements", "received message");
        if (this.b_selector != null && this.b_selector.getSelectorType() == 30) {
            this.sel_msgid_flag = true;
        }
        return true;
    }

    @Override
    public void purgeSeen() throws JMSException {
        String ptype = null;
        int pload_type = 0;
        AQjmsOracleDebug.trace(4, "AQjmsTopicBrowser.purgeSeen", "entry");
        if (this.dequeue_mode != 2) {
            AQjmsOracleDebug.trace(3, "AQjmsTopicBrowser.purgeSeen", "invalid dequeue mode, not LOCKED");
            AQjmsError.throwEx(124);
        }
        pload_type = (ptype = this.jms_dest.getAdtType()).equalsIgnoreCase("SYS.AQ$_JMS_MESSAGE") || ptype.equalsIgnoreCase("SYS.AQ$_JMS_TEXT_MESSAGE") || ptype.equalsIgnoreCase("SYS.AQ$_JMS_BYTES_MESSAGE") || ptype.equalsIgnoreCase("SYS.AQ$_JMS_MAP_MESSAGE") || ptype.equalsIgnoreCase("SYS.AQ$_JMS_OBJECT_MESSAGE") || ptype.equalsIgnoreCase("SYS.AQ$_JMS_STREAM_MESSAGE") ? 1 : (ptype.equalsIgnoreCase("SYS.ANYDATA") ? 3 : 2);
        ((AQjmsConsumer)this.receiver).purgeSeen(this.msgid_seen, pload_type);
        this.msgid_seen.clear();
        AQjmsOracleDebug.trace(4, "AQjmsTopicBrowser.purgeSeen", "purged");
    }

    public void setTransformation(String transformation) {
        ((AQjmsConsumer)this.receiver).setTransformation(transformation);
    }

    public String getTransformation() {
        return ((AQjmsConsumer)this.receiver).getTransformation();
    }
}

