/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import oracle.jms.AQjmsConstants;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsUcpDs;
import oracle.jms.AQjmsUcpDsStats;
import oracle.ucp.UniversalConnectionPoolAdapter;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.admin.UniversalConnectionPoolManager;
import oracle.ucp.admin.UniversalConnectionPoolManagerImpl;
import oracle.ucp.jdbc.PoolDataSource;
import oracle.ucp.jdbc.PoolDataSourceFactory;
import oracle.ucp.jdbc.PoolXADataSource;

public class AQjmsUcp {
    static UniversalConnectionPoolManager mgr = null;
    static Object lockMgr = new Object();
    static final HashMap<String, Level> traceLevelMap = new HashMap();
    static ConcurrentHashMap<String, AQjmsUcpDs> poolMap;

    private AQjmsUcp() {
    }

    public static PoolDataSource getPool(String jdbcUrl, String user, String password, boolean isXA) {
        Properties jdbc_info = new Properties();
        jdbc_info.put("user", user);
        jdbc_info.put("password", password);
        return AQjmsUcp.getPool(jdbcUrl, jdbc_info, isXA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PoolDataSource getPool(String jdbcUrl, Properties info, boolean isXA) {
        Object object;
        String user = info.getProperty("user");
        if (user == null) {
            return null;
        }
        user = user.toLowerCase();
        jdbcUrl = jdbcUrl.toLowerCase();
        AQjmsUcpDs ucpPool = null;
        String ucpKey = user + "_" + jdbcUrl + (isXA ? "_XA" : "");
        try {
            object = poolMap;
            synchronized (object) {
                ucpPool = poolMap.get(ucpKey);
                if (ucpPool != null) {
                    ucpPool.incUseCount();
                    return ucpPool.getPoolDataSource();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            object = lockMgr;
            synchronized (object) {
                if (mgr == null) {
                    mgr = UniversalConnectionPoolManagerImpl.getUniversalConnectionPoolManager();
                    String ucpTraceL = null;
                    ucpTraceL = System.getProperty("oracle.jms.ucp.trace");
                    if (ucpTraceL != null) {
                        try {
                            Level traceLevel = traceLevelMap.get(ucpTraceL);
                            if (traceLevel != null) {
                                mgr.setLogLevel(traceLevel);
                            }
                        }
                        catch (Exception e) {
                            AQjmsOracleDebug.traceEx(3, "AQjmsUcp.getPool: Failed to set UCP Tracing to " + ucpTraceL, e);
                        }
                    }
                }
                if ((ucpPool = poolMap.get(ucpKey)) == null) {
                    int sessCnt = Integer.parseInt(System.getProperty("oracle.jms.ucp.initsize", "1"));
                    int maxCnt = Integer.parseInt(System.getProperty("oracle.jms.ucp.maxsize", AQjmsConstants.DEFAULT_UCPMAXSIZE));
                    sessCnt = Math.min(sessCnt, maxCnt);
                    AQjmsOracleDebug.trace(3, "AQjmsuCP.getPool", "Creating UCP Pool with Key " + ucpKey + "\n Requeted Size = " + sessCnt);
                    long startTime = System.currentTimeMillis();
                    PoolDataSource pds = AQjmsUcp.initializePool(jdbcUrl, info.getProperty("user"), info.getProperty("password"), sessCnt, isXA, ucpKey);
                    if (pds == null) {
                        AQjmsOracleDebug.trace(3, "AQjmsuCP.getPool", "Failed to create ucp pool ");
                        return null;
                    }
                    long endTime = System.currentTimeMillis();
                    AQjmsOracleDebug.trace(3, "AQjmsuCP.getPool", "UCP Pool Created. Time Taken =" + (endTime - startTime) / 1000L + " Seconds. \n Available Sessions= " + pds.getAvailableConnectionsCount());
                    ucpPool = new AQjmsUcpDs(pds, isXA);
                    try {
                        String delayCleanupPara = System.getProperty("oracle.jms.ucp.delay.clean");
                        boolean isDelayedCleanup = false;
                        isDelayedCleanup = delayCleanupPara == null ? pds.getFastConnectionFailoverEnabled() || pds.getMinPoolSize() > 0 || Boolean.parseBoolean("false") : Boolean.parseBoolean(delayCleanupPara);
                        if (isDelayedCleanup) {
                            int waitTime = Integer.parseInt(System.getProperty("oracle.jms.ucp.clean.wait", "10"));
                            ucpPool.setDelayedCleanup(true);
                            ucpPool.setWaitTime(waitTime);
                        }
                    }
                    catch (Exception e) {
                        AQjmsOracleDebug.traceEx(3, "AQjmsUcp.getPool: setDelayedCleanup ", e);
                    }
                    poolMap.put(ucpKey, ucpPool);
                    ucpPool.incUseCount();
                } else {
                    ucpPool.incUseCount();
                }
            }
        }
        catch (Exception e) {
            AQjmsOracleDebug.traceEx(3, "AQjmsUcp.getPool ", e);
            ucpPool = null;
            return null;
        }
        return ucpPool.getPoolDataSource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closePool(PoolDataSource ucpPool) throws Exception {
        if (ucpPool == null) {
            return;
        }
        String ucpKey = ucpPool.getConnectionPoolName();
        try {
            ConcurrentHashMap<String, AQjmsUcpDs> concurrentHashMap = poolMap;
            synchronized (concurrentHashMap) {
                AQjmsUcpDs jmsPoolDs = poolMap.get(ucpKey);
                int useCount = jmsPoolDs.decUseCount();
                AQjmsOracleDebug.trace(3, "AQjmsUcp.closePool", "Ucp Key = " + ucpKey + "\n Use Count " + useCount + " Available Connections " + ucpPool.getAvailableConnectionsCount() + " Borrowed Connections " + ucpPool.getBorrowedConnectionsCount());
                if (useCount == 0) {
                    Object object = lockMgr;
                    synchronized (object) {
                        useCount = jmsPoolDs.getUseCount();
                        if (useCount > 0) {
                            return;
                        }
                        if (jmsPoolDs.delayedCleanup) {
                            AQjmsOracleDebug.trace(3, "AQjmsUcp.closePool", "Ucp Key = " + ucpKey + "\n Poll will be destroyed in " + jmsPoolDs.getWaitTime());
                            jmsPoolDs.selfDestruct();
                        } else {
                            AQjmsUcp.deletePool(ucpKey);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            AQjmsOracleDebug.traceEx(3, "AQjmsuCP.closePool Exception while Destroying Pool, UcpKey  " + ucpKey, e);
        }
    }

    private static PoolDataSource initializePool(String url, String user, String password, int initSize, boolean isXA, String poolName) throws SQLException, UniversalConnectionPoolException {
        PoolXADataSource pds = null;
        try {
            Object ucpMaxT = System.getProperty("oracle.ucp.MaxInitThreads");
            if (ucpMaxT == null || ((String)ucpMaxT).equals("")) {
                int ucpCreatorThreads = Math.max(initSize / 4, 1);
                System.setProperty("oracle.ucp.MaxInitThreads", "" + ucpCreatorThreads);
                ucpMaxT = "" + ucpCreatorThreads;
            }
            if (isXA) {
                pds = PoolDataSourceFactory.getPoolXADataSource();
                pds.setConnectionFactoryClassName("oracle.jdbc.xa.client.OracleXADataSource");
            } else {
                pds = PoolDataSourceFactory.getPoolDataSource();
                pds.setConnectionFactoryClassName("oracle.jdbc.pool.OracleDataSource");
            }
            pds.setUser(user);
            pds.setPassword(password);
            pds.setURL(url);
            pds.setInitialPoolSize(initSize);
            pds.setConnectionPoolName(poolName);
            pds.setValidateConnectionOnBorrow(true);
            int tOut = 0;
            try {
                String inactiveTimeoutStr = System.getProperty("oracle.jms.ucp.inactivetimeout", "0");
                tOut = Integer.parseInt(inactiveTimeoutStr);
                pds.setInactiveConnectionTimeout(tOut);
            }
            catch (Exception e) {
                AQjmsOracleDebug.traceEx(3, "AQjmsuCP.initializePool Exception while setting INACTIVE CONNECTION TIMEOUT. UcpKey:  " + poolName, e);
            }
            int reuseCnt = 0;
            try {
                String reuseStr = System.getProperty("oracle.jms.ucp.reusecount", "0");
                reuseCnt = Integer.parseInt(reuseStr);
                pds.setMaxConnectionReuseCount(reuseCnt);
            }
            catch (Exception e) {
                AQjmsOracleDebug.traceEx(3, "AQjmsuCP.initializePool Exception while setting CONNECTION REUSE COUNT. UcpKey:  " + poolName, e);
            }
            try {
                int minCnt = Integer.parseInt(System.getProperty("oracle.jms.ucp.minsize", "0"));
                if (minCnt > 0) {
                    pds.setMinPoolSize(minCnt);
                }
            }
            catch (Exception e) {
                AQjmsOracleDebug.traceEx(3, "AQjmsuCP.initializePool Exception while setting MIN POOl SIZE. UcpKey  " + poolName, e);
            }
            try {
                int maxCnt = Integer.parseInt(System.getProperty("oracle.jms.ucp.maxsize", AQjmsConstants.DEFAULT_UCPMAXSIZE));
                if (maxCnt <= Integer.MAX_VALUE) {
                    pds.setMaxPoolSize(maxCnt);
                }
            }
            catch (Exception e) {
                AQjmsOracleDebug.traceEx(3, "AQjmsuCP.initializePool Exception while setting MAX POOL SIZE. UcpKey  " + poolName, e);
            }
            try {
                boolean fcfEnabled = Boolean.parseBoolean(System.getProperty("oracle.jms.ucp.fcf", "false"));
                pds.setFastConnectionFailoverEnabled(fcfEnabled);
                String onsConfig = System.getProperty("oracle.jms.ons.config");
                if (onsConfig != null) {
                    pds.setONSConfiguration(onsConfig);
                    pds.setFastConnectionFailoverEnabled(true);
                }
            }
            catch (Exception e) {
                AQjmsOracleDebug.traceEx(3, "AQjmsuCP.initializePool Exception while setting Fast Connection Failover. UcpKey  " + poolName, e);
            }
            mgr.createConnectionPool((UniversalConnectionPoolAdapter)pds);
            mgr.startConnectionPool(pds.getConnectionPoolName());
            AQjmsOracleDebug.trace(3, "AQjmsuCP.initializePool: Created ", "Pool Name = " + poolName + "\n  Available Connections " + pds.getAvailableConnectionsCount() + " Borrowed Connections " + pds.getBorrowedConnectionsCount() + " UCP Creator Threads " + (String)ucpMaxT + " Inactive Time Out " + tOut + " ReUse Count " + reuseCnt);
        }
        catch (Exception e) {
            AQjmsOracleDebug.traceEx(3, "AQjmsuCP.initializePool Exception while creating Pool, UcpKey  " + poolName, e);
        }
        return pds;
    }

    static void deletePool(String ucpKey) throws Exception {
        poolMap.remove(ucpKey);
        try {
            AQjmsOracleDebug.trace(3, "AQjmsuCP.closePool", "Destroying Pool, UcpKey  " + ucpKey);
            mgr.destroyConnectionPool(ucpKey);
        }
        catch (Exception e) {
            AQjmsOracleDebug.traceEx(3, "AQjmsuCP.closePool Exception while Destroying Pool, UcpKey  " + ucpKey, e);
            throw e;
        }
    }

    public static HashMap<String, AQjmsUcpDsStats> getAQjmsUcpStats() {
        HashMap<String, AQjmsUcpDsStats> poolStats = new HashMap<String, AQjmsUcpDsStats>();
        for (Map.Entry<String, AQjmsUcpDs> pool : poolMap.entrySet()) {
            AQjmsUcpDs ds = pool.getValue();
            poolStats.put(pool.getKey(), new AQjmsUcpDsStats(ds.getPoolDataSource()));
        }
        return poolStats;
    }

    static {
        traceLevelMap.put("ALL", Level.ALL);
        traceLevelMap.put("CONFIG", Level.CONFIG);
        traceLevelMap.put("FINE", Level.FINE);
        traceLevelMap.put("FINER", Level.FINER);
        traceLevelMap.put("FINEST", Level.FINEST);
        traceLevelMap.put("INFO", Level.INFO);
        traceLevelMap.put("OFF", Level.OFF);
        traceLevelMap.put("SEVER", Level.SEVERE);
        traceLevelMap.put("WARNING", Level.WARNING);
        poolMap = new ConcurrentHashMap(2);
    }
}

