/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.sql.SQLException;
import javax.jms.JMSException;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TopicSession;
import javax.jms.XAQueueSession;
import javax.jms.XASession;
import javax.jms.XATopicSession;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import oracle.jms.AQjmsEmulatedXAResource;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsGeneralDBConnection;
import oracle.jms.AQjmsSession;
import oracle.jms.AQjmsXAConnection;
import oracle.jms.AQjmsXAResource;
import oracle.jms.AQjmsXAResourceFactory;
import oracle.jms.WebLogicHelper;

public class AQjmsXASession
extends AQjmsSession
implements XASession,
XAQueueSession,
XATopicSession {
    private XAResource m_jmsXAResource;

    AQjmsXASession(AQjmsXAConnection jms_conn, int type, AQjmsGeneralDBConnection genConn, AQjmsXAResourceFactory xaresFactory) throws JMSException {
        super(jms_conn, 0, true, type, genConn);
        XAConnection xaConn = genConn.getXAConnection();
        try {
            if (xaConn == null) {
                if (xaresFactory == null) {
                    this.m_jmsXAResource = WebLogicHelper.createIgnoredXAResource();
                    if (this.m_jmsXAResource == null) {
                        this.m_jmsXAResource = new AQjmsEmulatedXAResource((Session)this);
                    }
                } else {
                    this.m_jmsXAResource = xaresFactory.createXAResource(this);
                }
            } else {
                this.m_jmsXAResource = new AQjmsXAResource(this, xaConn.getXAResource());
            }
        }
        catch (SQLException sqle) {
            throw new AQjmsException(sqle);
        }
        catch (XAException xe) {
            throw new AQjmsException(xe);
        }
    }

    @Override
    protected synchronized void preClose() throws JMSException {
    }

    public Session getSession() throws JMSException {
        return this;
    }

    public QueueSession getQueueSession() throws JMSException {
        if (this.sess_type != 10) {
            AQjmsError.throwEx(107, this.sess_type == 20 ? "XATopicSession" : "XASession");
        }
        return this;
    }

    public TopicSession getTopicSession() throws JMSException {
        if (this.sess_type != 20) {
            AQjmsError.throwEx(107, this.sess_type == 10 ? "XAQueueSession" : "XASession");
        }
        return this;
    }

    @Override
    public synchronized void commit() throws JMSException {
        AQjmsError.throwTranInProgressEx(239, "commit");
    }

    @Override
    public synchronized void rollback() throws JMSException {
        AQjmsError.throwTranInProgressEx(239, "rollback");
    }

    public XAResource getXAResource() {
        return this.m_jmsXAResource;
    }
}

