/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.impl.dump;

import java.util.EnumSet;
import java.util.Locale;
import java.util.ResourceBundle;
import oracle.dfw.common.ArgumentType;
import oracle.dfw.common.DiagnosticsCategory;
import oracle.dfw.common.DiagnosticsEvent;
import oracle.dfw.common.DiagnosticsEventManager;
import oracle.dfw.common.DiagnosticsListener;
import oracle.dfw.config.DiagnosticsConfiguration;
import oracle.dfw.config.DiagnosticsConfigurationChangedEvent;
import oracle.dfw.dump.ComponentDiagnosticDump;
import oracle.dfw.dump.DumpContext;
import oracle.dfw.dump.DumpExecutionException;
import oracle.dfw.dump.DumpResult;
import oracle.dfw.dump.DumpWriter;
import oracle.dfw.dump.DumpWriterException;
import oracle.dfw.impl.dump.ExternalUtility;
import oracle.dfw.resource.DiagnosticTranslation;

public class ClassHistogram
extends ComponentDiagnosticDump
implements DiagnosticsListener {
    private static final String DFW_MESSAGES = DiagnosticTranslation.class.getName();
    private DiagnosticsConfiguration config_;
    private static final String MODE_ARG = "mode";
    private static volatile byte[] s_reservedMemory;

    public ClassHistogram() {
        int reservedMemoryKB_ = 512;
        ClassHistogram.setReservedMemory(new byte[reservedMemoryKB_ * 1024]);
        this.defineArgument(MODE_ARG, ArgumentType.STRING, false, DFW_MESSAGES, "DFW_CLASSHISTOGRAM_MODE_ARG");
    }

    public ClassHistogram(DiagnosticsConfiguration config) {
        this();
        this.config_ = config;
        int reservedMemoryKB_ = this.config_.getReservedMemoryKB();
        if (reservedMemoryKB_ > 0) {
            ClassHistogram.setReservedMemory(new byte[reservedMemoryKB_ * 1024]);
        } else {
            ClassHistogram.setReservedMemory(new byte[0]);
        }
        DiagnosticsEventManager.registerListener(this);
    }

    @Override
    public DumpResult executeDump(DumpContext context) throws DumpExecutionException, DumpWriterException {
        String modeStr = context.getArguments().getString(MODE_ARG);
        DumpWriter dw = new DumpWriter(context);
        try {
            if (modeStr != null && modeStr.length() > 0) {
                ExternalUtility.COMMAND cmd = ExternalUtility.COMMAND.valueOf(modeStr.toUpperCase());
                ExternalUtility.execute(cmd, dw);
            } else {
                ExternalUtility.execute(ExternalUtility.COMMAND.CLASSHISTOGRAM, dw);
            }
        }
        catch (Exception e) {
            dw.dumpln(e.getMessage());
            dw.dumpln("Cause: " + e.getCause());
        }
        return dw.getDumpResult();
    }

    @Override
    public String getName() {
        return "classhistogram";
    }

    @Override
    public String getOwner() {
        return "jvm";
    }

    @Override
    public EnumSet<DiagnosticsCategory> getDumpCategories() {
        return EnumSet.of(DiagnosticsCategory.MEMORY);
    }

    @Override
    public String getDumpDescription() {
        return this.getMsg("DFW_CLASSHISTOGRAM_DESCRIPTION", null);
    }

    @Override
    public String getDumpDescription(Locale locale) {
        return this.getMsg("DFW_CLASSHISTOGRAM_DESCRIPTION", locale);
    }

    private String getMsg(String key, Locale locale) {
        try {
            if (locale != null) {
                return ResourceBundle.getBundle(DFW_MESSAGES, locale).getString(key);
            }
            return ResourceBundle.getBundle(DFW_MESSAGES).getString(key);
        }
        catch (Exception e) {
            return key;
        }
    }

    @Override
    public Class<? extends DiagnosticsEvent>[] getHandledEventClasses() {
        return new Class[]{DiagnosticsConfigurationChangedEvent.class};
    }

    @Override
    public void handleEvent(DiagnosticsEvent event) {
        DiagnosticsConfiguration config;
        if (event instanceof DiagnosticsConfigurationChangedEvent && (config = ((DiagnosticsConfigurationChangedEvent)event).getDiagnosticsConfiguration()) != null) {
            int reservedMemoryKB_ = config.getReservedMemoryKB();
            if (reservedMemoryKB_ > 0) {
                ClassHistogram.setReservedMemory(new byte[reservedMemoryKB_ * 1024]);
            } else {
                ClassHistogram.setReservedMemory(null);
                System.gc();
            }
        }
    }

    public static void releaseReservedMemory() {
        ClassHistogram.setReservedMemory(null);
        System.gc();
    }

    private static void setReservedMemory(byte[] alloc) {
        s_reservedMemory = alloc;
    }
}

