/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.logging.Logger;

final class Chain<T> {
    private final Link<T>[] vacant;
    private int highWaterMark;
    private Link<T> head = null;
    private Link<T> tail = null;
    private int size = 0;
    private final IntConsumer sizeChangeTrigger;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;

    Chain(Link<T>[] linkArray, int n2, IntConsumer intConsumer) {
        this.vacant = linkArray;
        this.highWaterMark = n2;
        this.sizeChangeTrigger = intConsumer;
    }

    Chain(Link<T>[] linkArray, int n3) {
        this(linkArray, n3, n2 -> {});
    }

    static <T> void addHead(T t2, Chain<T> ... chainArray) {
        Link<T> link;
        if (chainArray.length == 0) {
            link = null;
        } else {
            Link<T>[] linkArray = chainArray[0].vacant;
            int n2 = chainArray[0].highWaterMark;
            n2 = Math.max(0, n2 - 1);
            link = linkArray[n2];
            linkArray[n2] = null;
        }
        if (link == null) {
            new Link<T>(t2, chainArray);
        } else {
            link.link(t2, chainArray);
        }
    }

    T removeHead() {
        return this.remove(this.head);
    }

    T removeTail() {
        return this.remove(this.tail);
    }

    private T remove(Link<T> link) {
        if (link == null) {
            return null;
        }
        this.highWaterMark = Math.min(this.highWaterMark + 1, this.vacant.length - 1);
        this.vacant[this.highWaterMark] = link;
        return link.unlink();
    }

    int size() {
        return this.size;
    }

    void forEach(Consumer<? super T> consumer) {
        Integer n2 = null;
        Link<T> link = this.head;
        while (null != link) {
            consumer.accept(link.value);
            if (n2 == null) {
                for (int i2 = 0; i2 < link.chains.length; ++i2) {
                    if (this != link.chains[i2]) continue;
                    n2 = i2;
                    break;
                }
            }
            link = link.next[n2];
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("[ ");
        boolean[] blArray = new boolean[]{false};
        this.forEach(object -> {
            stringBuilder.append(blArray[0] ? ", " : "").append(object.toString());
            blArray[0] = true;
        });
        return stringBuilder.append(" ]").toString();
    }

    static {
        try {
            $$$methodRef$$$10 = Chain.class.getDeclaredConstructor(Link[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = Chain.class.getDeclaredConstructor(Link[].class, Integer.TYPE, IntConsumer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = Chain.class.getDeclaredMethod("lambda$new$0", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = Chain.class.getDeclaredMethod("lambda$toString$1", StringBuilder.class, boolean[].class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = Chain.class.getDeclaredMethod("toString", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = Chain.class.getDeclaredMethod("forEach", Consumer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = Chain.class.getDeclaredMethod("size", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = Chain.class.getDeclaredMethod("remove", Link.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = Chain.class.getDeclaredMethod("removeTail", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = Chain.class.getDeclaredMethod("removeHead", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = Chain.class.getDeclaredMethod("addHead", Object.class, Chain[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }

    static final class Link<T> {
        private T value;
        private Chain<T>[] chains;
        private final Link<T>[] prev;
        private final Link<T>[] next;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;

        private Link(T t2, Chain<T> ... chainArray) {
            this.prev = new Link[chainArray.length];
            this.next = new Link[chainArray.length];
            this.link(t2, chainArray);
        }

        private void link(T t2, Chain<T> ... chainArray) {
            this.value = t2;
            this.chains = chainArray;
            for (int i2 = 0; i2 < chainArray.length; ++i2) {
                Chain<T> chain = chainArray[i2];
                chain.sizeChangeTrigger.accept(++chain.size);
                this.next[i2] = chain.head;
                this.prev[i2] = null;
                if (null != chain.head) {
                    chain.head.prev[i2] = this;
                }
                chain.head = this;
                if (null != chain.tail) continue;
                chain.tail = this;
            }
        }

        private T unlink() {
            T t2 = this.value;
            this.value = null;
            for (int i2 = 0; i2 < this.chains.length; ++i2) {
                Chain<T> chain = this.chains[i2];
                chain.sizeChangeTrigger.accept(--chain.size);
                if (this.prev[i2] == null) {
                    chain.head = this.next[i2];
                } else {
                    this.prev[i2].next[i2] = this.next[i2];
                }
                if (this.next[i2] == null) {
                    chain.tail = this.prev[i2];
                    continue;
                }
                this.next[i2].prev[i2] = this.prev[i2];
            }
            return t2;
        }

        public String toString() {
            return this.value.toString();
        }

        static {
            try {
                $$$methodRef$$$3 = Link.class.getDeclaredConstructor(Object.class, Chain[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = Link.class.getDeclaredMethod("toString", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = Link.class.getDeclaredMethod("unlink", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = Link.class.getDeclaredMethod("link", Object.class, Chain[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }
}

