/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DynamicByteArray;
import oracle.jdbc.driver.T4CAccessor;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CTTIoer11;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.net.ns.BreakNetException;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
abstract class T4CMarshaller {
    private static final T4CMarshaller BASIC;
    private static final T4CMarshaller STREAM;
    static final T4CMarshaller CHAR;
    static final T4CMarshaller LONG_RAW;
    static final T4CMarshaller RAW;
    static final T4CMarshaller VARCHAR;
    static final T4CMarshaller LONG;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;

    abstract boolean unmarshalOneRow(Accessor var1) throws SQLException, IOException;

    abstract int readStreamFromWire(byte[] var1, int var2, int var3, int[] var4, boolean[] var5, boolean[] var6, T4CMAREngine var7, T4CTTIoer11 var8) throws SQLException, IOException;

    private T4CMarshaller() {
    }

    static {
        try {
            $$$methodRef$$$0 = T4CMarshaller.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        BASIC = new BasicMarshaller();
        STREAM = new StreamMarshaller();
        CHAR = BASIC;
        LONG_RAW = STREAM;
        RAW = BASIC;
        VARCHAR = BASIC;
        LONG = STREAM;
    }

    private static final class StreamMarshaller
    extends T4CMarshaller {
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;

        private StreamMarshaller() {
        }

        @Override
        boolean unmarshalOneRow(Accessor accessor) throws SQLException, IOException {
            T4CAccessor t4CAccessor = (T4CAccessor)((Object)accessor);
            T4CMAREngine t4CMAREngine = t4CAccessor.getMAREngine();
            if (accessor.isUseless()) {
                ++accessor.lastRowProcessed;
                return false;
            }
            boolean bl = false;
            accessor.escapeSequenceArr[0] = t4CMAREngine.unmarshalUB1();
            if (t4CMAREngine.escapeSequenceNull(accessor.escapeSequenceArr[0])) {
                accessor.setNull(accessor.lastRowProcessed, true);
                t4CMAREngine.processIndicator(false, 0);
                int n2 = (int)t4CMAREngine.unmarshalUB4();
                accessor.escapeSequenceArr[0] = 0;
                accessor.previousRowProcessed = accessor.lastRowProcessed++;
            } else {
                accessor.setNull(accessor.lastRowProcessed, false);
                accessor.readHeaderArr[0] = true;
                accessor.readAsNonStreamArr[0] = false;
                if (accessor.statement.isFetchStreams || accessor.definedColumnType == -2 || accessor.definedColumnType == 12 || accessor.definedColumnType == 1) {
                    int n3 = 0;
                    int n4 = 0;
                    byte[] byArray = accessor.statement.connection.getByteBuffer(32768);
                    accessor.setOffset(accessor.lastRowProcessed);
                    while (n3 != -1) {
                        n3 = this.readStreamFromWire(byArray, 0, 32768, accessor.escapeSequenceArr, accessor.readHeaderArr, accessor.readAsNonStreamArr, t4CMAREngine, ((T4CConnection)accessor.statement.connection).oer);
                        if (n3 == -1) continue;
                        if (accessor.statement.connection.checksumMode.needToCalculateFetchChecksum()) {
                            long l2;
                            accessor.statement.checkSum = l2 = CRC64.updateChecksum(accessor.statement.checkSum, byArray, 0, n3);
                        }
                        accessor.rowData.put(byArray, 0, n3);
                        n4 += n3;
                    }
                    accessor.setLength(accessor.lastRowProcessed, n4);
                    accessor.previousRowProcessed = accessor.lastRowProcessed++;
                    accessor.isStream = false;
                    accessor.statement.connection.cacheBuffer(byArray);
                } else {
                    bl = true;
                }
            }
            return bl;
        }

        @Override
        int readStreamFromWire(byte[] byArray, int n2, int n3, int[] nArray, boolean[] blArray, boolean[] blArray2, T4CMAREngine t4CMAREngine, T4CTTIoer11 t4CTTIoer11) throws SQLException, IOException {
            int n4;
            block13: {
                n4 = -1;
                try {
                    if (!blArray2[0]) {
                        if (n3 > 32768 || n3 < 0) {
                            throw (SQLException)DatabaseError.createSqlException(433).fillInStackTrace();
                        }
                        if (blArray[0]) {
                            if (nArray[0] == 254) {
                                n4 = t4CMAREngine.useCLRBigChunks ? t4CMAREngine.unmarshalSB4() : (int)t4CMAREngine.unmarshalUB1();
                            } else {
                                if (nArray[0] == 0) {
                                    t4CTTIoer11.connection.internalClose();
                                    throw (SQLException)DatabaseError.createSqlException(401).fillInStackTrace();
                                }
                                blArray2[0] = true;
                                n4 = nArray[0];
                            }
                            blArray[0] = false;
                            nArray[0] = 0;
                        } else {
                            n4 = t4CMAREngine.useCLRBigChunks ? t4CMAREngine.unmarshalSB4() : (int)t4CMAREngine.unmarshalUB1();
                        }
                    } else {
                        blArray2[0] = false;
                    }
                    if (n4 > 0) {
                        t4CMAREngine.unmarshalNBytes(byArray, n2, n4);
                    } else {
                        n4 = -1;
                    }
                }
                catch (BreakNetException breakNetException) {
                    n4 = t4CMAREngine.unmarshalSB1();
                    if (n4 != 4) break block13;
                    t4CTTIoer11.init();
                    t4CTTIoer11.processError();
                }
            }
            if (n4 == -1) {
                blArray[0] = true;
                t4CMAREngine.unmarshalUB2();
                t4CMAREngine.unmarshalUB2();
            }
            return n4;
        }

        static {
            try {
                $$$methodRef$$$2 = StreamMarshaller.class.getDeclaredConstructor(new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = StreamMarshaller.class.getDeclaredMethod("readStreamFromWire", byte[].class, Integer.TYPE, Integer.TYPE, int[].class, boolean[].class, boolean[].class, T4CMAREngine.class, T4CTTIoer11.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = StreamMarshaller.class.getDeclaredMethod("unmarshalOneRow", Accessor.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    private static final class BasicMarshaller
    extends T4CMarshaller {
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;

        private BasicMarshaller() {
        }

        @Override
        boolean unmarshalOneRow(Accessor accessor) throws SQLException, IOException {
            T4CAccessor t4CAccessor = (T4CAccessor)((Object)accessor);
            boolean bl = false;
            if (!accessor.isUseless()) {
                if (accessor.isUnexpected()) {
                    long l2 = accessor.rowData.getPosition();
                    t4CAccessor.unmarshalColumnMetadata();
                    this.unmarshalBytes(accessor);
                    accessor.rowData.setPosition(l2);
                    accessor.setNull(accessor.lastRowProcessed, true);
                } else if (accessor.isNullByDescribe()) {
                    accessor.setNull(accessor.lastRowProcessed, true);
                    t4CAccessor.unmarshalColumnMetadata();
                    if (accessor.statement.connection.versionNumber < 9200) {
                        t4CAccessor.processIndicator(0);
                    }
                } else {
                    t4CAccessor.unmarshalColumnMetadata();
                    bl = this.unmarshalBytes(accessor);
                }
            }
            accessor.previousRowProcessed = accessor.lastRowProcessed++;
            return bl;
        }

        private boolean unmarshalBytes(Accessor accessor) throws SQLException, IOException {
            T4CAccessor t4CAccessor = (T4CAccessor)((Object)accessor);
            T4CMAREngine t4CMAREngine = t4CAccessor.getMAREngine();
            accessor.setOffset(accessor.lastRowProcessed);
            int n2 = accessor.statement.maxFieldSize > 0 ? ((DynamicByteArray)accessor.rowData).unmarshalCLR(t4CMAREngine, accessor.statement.maxFieldSize) : ((DynamicByteArray)accessor.rowData).unmarshalCLR(t4CMAREngine);
            t4CAccessor.processIndicator(n2);
            accessor.setLength(accessor.lastRowProcessed, n2);
            accessor.setNull(accessor.lastRowProcessed, n2 == 0);
            return false;
        }

        @Override
        int readStreamFromWire(byte[] byArray, int n2, int n3, int[] nArray, boolean[] blArray, boolean[] blArray2, T4CMAREngine t4CMAREngine, T4CTTIoer11 t4CTTIoer11) throws SQLException, IOException {
            return -1;
        }

        static {
            try {
                $$$methodRef$$$3 = BasicMarshaller.class.getDeclaredConstructor(new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = BasicMarshaller.class.getDeclaredMethod("readStreamFromWire", byte[].class, Integer.TYPE, Integer.TYPE, int[].class, boolean[].class, boolean[].class, T4CMAREngine.class, T4CTTIoer11.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = BasicMarshaller.class.getDeclaredMethod("unmarshalBytes", Accessor.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = BasicMarshaller.class.getDeclaredMethod("unmarshalOneRow", Accessor.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }
}

